GDPC               p       `                                                                            [gd_scene load_steps=3 format=3 uid="uid://btxsj316mhlcb"]

[ext_resource type="Texture2D" uid="uid://c7lbcumdordl1" path="res://gfx/characters/cloud.png" id="1_vnemq"]

[sub_resource type="Curve" id="16"]
_limits = [-360.0, 360.0, 0.0, 1.0]
_data = [Vector2(0, -160.364), 0.0, 0.0, 0, 0, Vector2(1, 212.727), 0.0, 0.0, 0, 0]
point_count = 2

[node name="LandingParticles" type="CPUParticles2D"]
position = Vector2(0, 16)
emitting = false
amount = 12
lifetime = 0.75
one_shot = true
preprocess = 0.25
explosiveness = 0.9
texture = ExtResource("1_vnemq")
emission_shape = 1
emission_sphere_radius = 1.0
direction = Vector2(0, -100)
spread = 90.0
gravity = Vector2(0, 0)
angle_curve = SubResource("16")
hue_variation_max = 0.1
           [gd_resource type="ShaderMaterial" load_steps=3 format=3 uid="uid://befebu3ihc1xj"]

[ext_resource type="Texture2D" uid="uid://dsvefemdecm5k" path="res://gfx/gui/purplegrad.png" id="1_pye57"]

[sub_resource type="Shader" id="Shader_3wcgi"]
code = "shader_type canvas_item;

const int foo = 0;
uniform sampler2D gradient;
uniform float speed_scale = 1;

void fragment() {
	vec4 color = texture(TEXTURE, UV);
	float x = mod(color.r - TIME * speed_scale, 1.0);
	COLOR = vec4(texture(gradient, vec2(x, 0)).rgb, color.a);
}"

[resource]
shader = SubResource("Shader_3wcgi")
shader_parameter/gradient = ExtResource("1_pye57")
shader_parameter/speed_scale = 0.125
               [gd_scene load_steps=4 format=3 uid="uid://bb47hwjrqur5n"]

[ext_resource type="PackedScene" uid="uid://tkvrxcpr7j11" path="res://game_entities/neoHotspot.tscn" id="1_57vk1"]
[ext_resource type="Material" uid="uid://bjw3bnt7x1uak" path="res://gfx/shaders/furniture_shadow_material.tres" id="2_cmmcg"]
[ext_resource type="Texture2D" uid="uid://dorpf8nwqkrbj" path="res://gfx/characters/pirates/antonio.png" id="3_6gkwx"]

[node name="Antonio" instance=ExtResource("1_57vk1")]
dimensions = Vector2(32, 64)
emoter_offset = Vector2(0, -32)
display_name = "Antonio"
description = ""
script_name = "Antonio"

[node name="Sprite2D" type="Sprite2D" parent="." index="2"]
material = ExtResource("2_cmmcg")
texture = ExtResource("3_6gkwx")
      [gd_scene load_steps=4 format=3 uid="uid://csb1vh5tgs45m"]

[ext_resource type="PackedScene" uid="uid://tkvrxcpr7j11" path="res://game_entities/neoHotspot.tscn" id="1_xe235"]
[ext_resource type="Texture2D" uid="uid://bl2cx0lvp550m" path="res://gfx/characters/pirates/blue_hair_pirate_body.png" id="2_aceha"]
[ext_resource type="Material" uid="uid://bjw3bnt7x1uak" path="res://gfx/shaders/furniture_shadow_material.tres" id="2_lxkck"]

[node name="Blue-Haired Pirate" instance=ExtResource("1_xe235")]
dimensions = Vector2(32, 60)
emoter_offset = Vector2(0, -32)
display_name = "Blue-Haired Pirate"
description_speaker = "Blue"
description = ""
script_name = "Blue"

[node name="Sprite2D" type="Sprite2D" parent="." index="2"]
material = ExtResource("2_lxkck")
texture = ExtResource("2_aceha")
        [gd_scene load_steps=4 format=3 uid="uid://qci0sx1ylnjh"]

[ext_resource type="PackedScene" uid="uid://tkvrxcpr7j11" path="res://game_entities/neoHotspot.tscn" id="1_to315"]
[ext_resource type="Material" uid="uid://bjw3bnt7x1uak" path="res://gfx/shaders/furniture_shadow_material.tres" id="2_tjeac"]
[ext_resource type="Texture2D" uid="uid://c1xybv2ppgljn" path="res://gfx/characters/pirates/brown_hair_pirate_body.png" id="2_yckel"]

[node name="Brown-Haired Pirate" instance=ExtResource("1_to315")]
dimensions = Vector2(32, 60)
emoter_offset = Vector2(0, -32)
display_name = "Brown-Haired Pirate"
description_speaker = "Brown"
description = ""
script_name = "Brown"

[node name="Sprite2D" type="Sprite2D" parent="." index="2"]
material = ExtResource("2_tjeac")
texture = ExtResource("2_yckel")
    [gd_scene load_steps=4 format=3 uid="uid://cygpro82l2ydb"]

[ext_resource type="PackedScene" uid="uid://tkvrxcpr7j11" path="res://game_entities/neoHotspot.tscn" id="1_2khk1"]
[ext_resource type="Texture2D" uid="uid://bguhklb7eo2e7" path="res://gfx/characters/crew/captain_body.png" id="2_6sptb"]
[ext_resource type="Texture2D" uid="uid://dnmaninx4tvcj" path="res://gfx/characters/player/shadow.png" id="3_ctsvj"]

[node name="Captain Rodriguez" instance=ExtResource("1_2khk1")]
dimensions = Vector2(32, 60)
emoter_offset = Vector2(0, -32)
display_name = "Captain Rodriguez"
description_speaker = "Captain Rodriguez"
description = ""
script_name = "CaptainRodriguez"

[node name="Sprite2D" type="Sprite2D" parent="." index="2"]
texture = ExtResource("2_6sptb")

[node name="Sprite2D" type="Sprite2D" parent="Sprite2D" index="0"]
z_index = -1
position = Vector2(-2, 24)
texture = ExtResource("3_ctsvj")
           [gd_scene load_steps=4 format=3 uid="uid://eogf0fr0b2v"]

[ext_resource type="PackedScene" uid="uid://tkvrxcpr7j11" path="res://game_entities/neoHotspot.tscn" id="1_ildv4"]
[ext_resource type="Material" uid="uid://bjw3bnt7x1uak" path="res://gfx/shaders/furniture_shadow_material.tres" id="2_ureps"]
[ext_resource type="Texture2D" uid="uid://bprj2kjxxcnre" path="res://gfx/characters/crew/mechanics.png" id="3_rss12"]

[node name="Mechanics" instance=ExtResource("1_ildv4")]
dimensions = Vector2(64, 64)
display_name = "Mechanics"
description = ""
can_interact = false
script_name = "Mechanics"

[node name="Sprite2D" type="Sprite2D" parent="." index="2"]
material = ExtResource("2_ureps")
texture = ExtResource("3_rss12")
              [gd_scene load_steps=6 format=3 uid="uid://ydshaikn11va"]

[ext_resource type="PackedScene" uid="uid://tkvrxcpr7j11" path="res://game_entities/neoHotspot.tscn" id="1_ldpld"]
[ext_resource type="Material" uid="uid://bjw3bnt7x1uak" path="res://gfx/shaders/furniture_shadow_material.tres" id="2_1g6gp"]
[ext_resource type="Texture2D" uid="uid://drt6j8sm8rk2h" path="res://gfx/characters/pirates/pirate_captain.png" id="2_inltn"]
[ext_resource type="Texture2D" uid="uid://b3ejnbyejgwvs" path="res://gfx/decor/smoke1.png" id="4_d0kd0"]

[sub_resource type="Gradient" id="Gradient_6e0it"]
colors = PackedColorArray(0.207843, 0.207843, 0.207843, 0.266667, 0.0605303, 0.0605304, 0.0605302, 0)

[node name="Pirate Leader" instance=ExtResource("1_ldpld")]
dimensions = Vector2(32, 60)
emoter_offset = Vector2(0, -32)
display_name = "Pirate Leader"
description_speaker = "Pirate Leader"
description = ""
script_name = "PirateLeader"

[node name="Sprite2D" type="Sprite2D" parent="." index="2"]
material = ExtResource("2_1g6gp")
texture = ExtResource("2_inltn")

[node name="CPUParticles2D" type="CPUParticles2D" parent="." index="3"]
position = Vector2(6, -10)
amount = 4
lifetime = 4.0
explosiveness = 0.5
fixed_fps = 20
fract_delta = false
local_coords = true
texture = ExtResource("4_d0kd0")
direction = Vector2(0, -1)
spread = 20.0
gravity = Vector2(0, 0)
initial_velocity_min = 20.0
initial_velocity_max = 20.0
radial_accel_min = -10.0
radial_accel_max = 10.0
damping_min = 10.0
damping_max = 10.0
angle_min = -180.0
angle_max = 180.0
color_ramp = SubResource("Gradient_6e0it")
            [gd_scene load_steps=4 format=3 uid="uid://cdgd7k568gqti"]

[ext_resource type="PackedScene" uid="uid://tkvrxcpr7j11" path="res://game_entities/neoHotspot.tscn" id="1_wagma"]
[ext_resource type="Texture2D" uid="uid://3rgpdvv3a1q3" path="res://gfx/characters/crew/sbeve_body.png" id="2_hchb0"]
[ext_resource type="Texture2D" uid="uid://dnmaninx4tvcj" path="res://gfx/characters/player/shadow.png" id="3_6rhm4"]

[node name="Sbeve" instance=ExtResource("1_wagma")]
dimensions = Vector2(32, 60)
emoter_offset = Vector2(0, -32)
display_name = "Sbeve"
description_speaker = "Sbeve"
description = ""
script_name = "Sbeve"

[node name="Sprite2D" type="Sprite2D" parent="." index="2"]
texture = ExtResource("2_hchb0")

[node name="Sprite2D" type="Sprite2D" parent="Sprite2D" index="0"]
z_index = -1
position = Vector2(-2.13333, 26)
scale = Vector2(1.26667, 1)
texture = ExtResource("3_6rhm4")
           [gd_scene load_steps=3 format=3 uid="uid://oai4aojdursd"]

[ext_resource type="PackedScene" uid="uid://tkvrxcpr7j11" path="res://game_entities/neoHotspot.tscn" id="1_a0x8d"]
[ext_resource type="Texture2D" uid="uid://b24q66qcmvs66" path="res://gfx/characters/lizards/nerd_lizard.png" id="2_ks6wx"]

[node name="Smart Lizard" instance=ExtResource("1_a0x8d")]
dimensions = Vector2(32, 60)
emoter_offset = Vector2(0, -32)
auto_zed = true
display_name = "Smart Lizard"
description_speaker = "Smart Lizard"
description = ""
script_name = "Smart"

[node name="Sprite2D" type="Sprite2D" parent="." index="2"]
texture = ExtResource("2_ks6wx")
      [gd_scene load_steps=3 format=3 uid="uid://c6mxyrla60mkj"]

[ext_resource type="PackedScene" uid="uid://tkvrxcpr7j11" path="res://game_entities/neoHotspot.tscn" id="1_6sipe"]
[ext_resource type="Texture2D" uid="uid://bafhl8125lfyd" path="res://gfx/characters/lizards/bartender_lizard.png" id="2_r61xc"]

[node name="Social Lizard" instance=ExtResource("1_6sipe")]
dimensions = Vector2(32, 60)
emoter_offset = Vector2(0, -32)
auto_zed = true
display_name = "Social Lizard"
description_speaker = "Social Lizard"
description = ""
script_name = "Social"

[node name="Sprite2D" type="Sprite2D" parent="." index="2"]
texture = ExtResource("2_r61xc")
            [gd_scene load_steps=3 format=3 uid="uid://d37kxm4ro5npk"]

[ext_resource type="PackedScene" uid="uid://tkvrxcpr7j11" path="res://game_entities/neoHotspot.tscn" id="1_3v61s"]
[ext_resource type="Texture2D" uid="uid://pvxe83pbpm7" path="res://gfx/characters/crew/navigator.png" id="2_s8o1n"]

[node name="Teli" instance=ExtResource("1_3v61s")]
dimensions = Vector2(32, 60)
emoter_offset = Vector2(0, -32)
display_name = "Teli"
description_speaker = "Teli"
description = ""
script_name = "Teli"

[node name="Sprite2D" type="Sprite2D" parent="." index="2"]
texture = ExtResource("2_s8o1n")
     [gd_scene load_steps=3 format=3 uid="uid://cej0gcvyhdmbc"]

[ext_resource type="PackedScene" uid="uid://tkvrxcpr7j11" path="res://game_entities/neoHotspot.tscn" id="1_7mqfc"]
[ext_resource type="Texture2D" uid="uid://c4nk6ljk1wxoc" path="res://gfx/characters/lizards/security_lizard.png" id="2_c3s6f"]

[node name="Tough Lizard" instance=ExtResource("1_7mqfc")]
dimensions = Vector2(32, 60)
emoter_offset = Vector2(0, -32)
display_name = "Tough Lizard"
description_speaker = "Tough Lizard"
description = ""
script_name = "Tough"

[node name="Sprite2D" type="Sprite2D" parent="." index="2"]
texture = ExtResource("2_c3s6f")
 GDSCe   d]  (/`d\M 
77X R4U	I_cA8%W;G'vww77CTogPɖ1u_7Z; _rby1M)}Jw}tEx_#G~#>цwQ__B\3#?_	$~$
~#??
"?ς???	Bw4g e~+/Q??Āɿ¯ćD!@o.6
ydhh'HFEHC/&"ӐRditSdt4DIɿc)	"9$'H."גʟsLFS`:z!%9h))4eI%WQO0)%%:zh	!=HIFC=/$׋ɨ))Ҕ\GG15LS^C/&I]GGE!2RzMQ::Ɉ?^H.&גRB$%WRBHK$	9FJ2z
-^HFϝ9sǿ!%㡊dɒ%KgD[<sԿ02ZRjRz
I1B"sǹ72~1:W9p9j	Cg&Vt[|w%;WCŉԐ!M	jgv%U?jF]R4*0Gihdư|f
Sk*|GJӅDiԌqC'șҹsc]UေQU#NGCC	᪨fS'p.~@1
f}W`T܄2Ӆ/Ɛ)c(L}_U/Z95ЌMUU5ĈsPI툡-33UL}_188U*+*
fSTWc+f>hS.|w}}RS͌&u}_iHѾFgX}E}Uo0;ﳒ/}e#y/k 1l^2xYG'^!𱉗A<9^||q%xi%>JyY[|QS?#X|Dc/>.y(>&yفH^RW>yU>	R>y	 ^}R/|B*^ e㥏>^|G/s>3y##x90>x΋5xs5h[s1=cs[G|d=ǁsT|U?ܕ	U(od<7?s1p ܎?
Ks6<_=g๚m*Ƴu/~<V7yw,~2y
0:ųJ[=+`5뉟YTڳ(,og<ԳRby|Y2^Y+1x
g-~70/-~U+~oo.7(m	~_&෧_y?~k?MoQ,mD?~~OoG6"~
v[G(L$;?>j7,)XGS>bSJ|I>6)hõРFo{py,h``8à}ˎIN\tp3Fc^,=
Fs<,tpQ,{Zy=:'-Ԍ-cT.<Fkh)	+kS!bMfLR^m"uzd碳|So)t3V0ua:[A*d+a?NY<璭^~oEH@2lٹ3N%+Kuzd碳ϐ>2v[Gv.:<>>q:HqvFt`yO7T"@{*Vp~)}aD.6u0{V_!a9qLV&Ч^{n+Kj
{
>seB>{Ya+x^l6԰j
+IC
ZSC:dҰ[B-8[-4zK0r1BVdliȔae鳕ǆ``irC^asAy0K;Nv6<v6->{vFwLvFuvFU);8&
;;اMkmް9xtyIFci`mNу,msfi͉rj9iM&6mN{06#54PBrE.j[Ц,b(AT	%)Ptr'ݒ[r\vdɸivZ;NFNv]յZRFuQFwZ;յV'd'eluV';)e'[VQFe2J)NJuRF)N(:;;(1c1c1c1QXjX#P|Oh.;jR]vaFS#V^KJ()MˎR
@I&M0a#	^K4-"*Qƺ}L$1ʳHH A,J#F{bӧF鴵z
n0+a?6Xy,O(vYg!B!1H VD(!i?1|.[]>MďMt][{bÉ=xQGOݱIGԡCǴo->i+}6-[iõPVlZ&gR^:m	u,&
_|#v}uc 
yV6m{5mCJMVlڐ>eiRucjiKqmRPgk
k+"{%'
ݞΫtJ5}HaiRĵW}2pZgAX8%',j
dǲëO.mxY:'Nk*x'NCo{RXM@vtWhȔˎ<b'֥
rT8UbJWA>{I{sV.S}J<it.PeʳO)gZpctF+{F
iWٽ%Ӧg{Hy]v4h>{E!hlS=©.,ԓɆ.VN'hy.idCNv/;<FvZ
o:thRÛ>g2~+A{m{φӟˎ7MZ
id?Nv/5sl8ٽc!}.
gbv4hxO#[i^9:8@Nـ=ʨx` @    C ,0M 	dyED)bhIJP	v- z$&F/h#GZ;(fK3lm2HZ܄=6'VCN	Vbö6OvN&/48vy>PQ*Zu[eKm"OjW,t>5Iq4U3h B{+dM9q>,18Po׼+?ۣs %0MwMvB6iE"
>2*ߡT\jJPYmo|rԡg']򾢮IFu~Kդ	t{͠f.˄0AHϡ؀ڀ=78/g|LIk ~<ΣXc9GrU{b
Rװt^=ny4*bfJL1
a0}&k(jc0!SIХٺxJ$n>b@|nkѝ'݊LI{ux9zL9r 'A4oĩYC+8yW>Ӄ*chE%@[[b#776Twh8Bgծw{@DnQ\σoԽig
 36ʒ9:[[WёU]봕Ҥ7.Ӥ	}O["^I)c'SQR{?ط4nH7F6yt {
M	Gyoٴr3U&聼+x:O;z
@U6kɎ?Az
2'y_1}1p׽hsɂ͕29K^FքdUrP1)8!"װ;NFM*=֠+c) 8
=*{=M
(M;&{_sDDJJ;{hٰ Q_ϷƳGB҈	$Ӡ-Ň<GS%Ј-*c̿*MBP4~O30ׁ>7Xv|oU_tt}¹قopI]a^-"~aU
Cl.sE4ᅝ3qݩ7xPeSj]s
V^MєiM M4ܓJ%>8|>;0gT,)mnMzaEZLc(ߨjsj2DBfO_Y"ǴMq(=<mg	Sb5	fuc_%g>^lZE]V:)Lmĉ<6m?cϗP1-C7L3Zp7éq
cֱNFoܠ2'^S%cwOLIX!GhY-A[<CYuIjObsГO6Iyc;:1 v8VƓ»N@Ρ`"*?°weǻ*QiΦ("9&-y샮qDMzAgHGa-9]
Ѩd&[ܲp-(q5R~p+@q"rڇǁpqYCjF1
9)?^`+m,z$7ľ姚d8$g/rq<og"3>gOzq$t1Nޚ--n5/C;3v/yl^z'Q#x89 ΚW[ě݄hD Ke .V3lX+%2BMmUQEDJR$7p d6		$ͽB,1}&QAo=
<}i@/t҃rM*^ᮔ?ICϬ80"7u0+Ȍ=+@/b*A`> ދ};+ʻ]"<R+w}ݛoK:07~'M< !7wHTt02ek7d:QF?[Ts!K~.s[`N58 E?U<PY<Iݓ7pqF-3swwiJ~q]sIT%4VzS
OfswFdq@Q8[K}DօӦǱtIRA?L	mg%m<faƹyRuƌ&2-ߣ;OhOs*ovcrx) z؈+D	<o(a7t4j"sPa/]c%8vXWuvW-N7I]Is \Alss+Y^h{P[ZsS&O.X+8^臺 6%lL:.lQw8wҬϓeL"@6YeI(X Z7I {zxV?cۈ=ugOj
.)Y:&AM/S[e{K*8uUzceЕ~Hoxy2KH҅æg:~}@"6b +t$|O=5;7߀*M^ҕ6P4ʂ%8<
_Cڸy{mBsF,FvH
n_trdl|.CNcgpDĺ"TKL~4}>y8@^z{xE릓ݚ{/{ǝb,e8De	!-_QwSoU;lY/0xXןAR'<Pq^p/s뷠(8rXvBu/WǱ:'doc*%ʞ!Ã$RƟ\!I΁j^6
*iJ'uaGGDPL0c
D]
xm=fepz\)e]g߸Oí!6b޻F=!s@~?:{PyF}=>@:Ѐ4+e<{9mM ńՏxōBOهů/Nt .<QO;$9XOS'<
";ÕUedF|pC7O<۝px~GOF /4G| Ip,Lo>_=f~es{^xEƟ+?ǈ`WGqjrG?y<lk^ac|bNӚ˯ї&\sRvڅ&>e۝76LXF>$A:w$[# 0?Q7J3'6p# [gd_scene load_steps=9 format=3 uid="uid://dpj227ev6qwj7"]

[ext_resource type="Script" uid="uid://chuqp3mehh3wn" path="res://actors/character.gd" id="1"]

[sub_resource type="Animation" id="Animation_bsln0"]
resource_name = "fade"
tracks/0/type = "value"
tracks/0/imported = false
tracks/0/enabled = true
tracks/0/path = NodePath(".:modulate")
tracks/0/interp = 1
tracks/0/loop_wrap = true
tracks/0/keys = {
"times": PackedFloat32Array(0, 0.5),
"transitions": PackedFloat32Array(1, 1),
"update": 0,
"values": [Color(1, 1, 1, 1), Color(1, 1, 1, 0)]
}

[sub_resource type="Animation" id="Animation_rseek"]
resource_name = "flip"
length = 3.0
tracks/0/type = "method"
tracks/0/imported = false
tracks/0/enabled = true
tracks/0/path = NodePath(".")
tracks/0/interp = 1
tracks/0/loop_wrap = true
tracks/0/keys = {
"times": PackedFloat32Array(0.2, 1.3, 2.5),
"transitions": PackedFloat32Array(1, 1, 1),
"values": [{
"args": [],
"method": &"_forceflip"
}, {
"args": [],
"method": &"_forceflip"
}, {
"args": [],
"method": &"_forceflip"
}]
}

[sub_resource type="Animation" id="Animation_u1h3m"]
resource_name = "horizontal_squish"
length = 0.6
tracks/0/type = "value"
tracks/0/imported = false
tracks/0/enabled = true
tracks/0/path = NodePath(".:scale")
tracks/0/interp = 1
tracks/0/loop_wrap = true
tracks/0/keys = {
"times": PackedFloat32Array(0, 0.4),
"transitions": PackedFloat32Array(1, 1),
"update": 0,
"values": [Vector2(1, 1), Vector2(0, 1)]
}

[sub_resource type="Animation" id="Animation_bo7l3"]
resource_name = "vertical_squish"
length = 0.6
tracks/0/type = "value"
tracks/0/imported = false
tracks/0/enabled = true
tracks/0/path = NodePath(".:scale")
tracks/0/interp = 1
tracks/0/loop_wrap = true
tracks/0/keys = {
"times": PackedFloat32Array(0, 0.4),
"transitions": PackedFloat32Array(1, 1),
"update": 0,
"values": [Vector2(1, 1), Vector2(1, 0)]
}

[sub_resource type="Animation" id="Animation_bx5ai"]
resource_name = "wait"
length = 1.365
tracks/0/type = "value"
tracks/0/imported = false
tracks/0/enabled = true
tracks/0/path = NodePath(".:dummy_property")
tracks/0/interp = 1
tracks/0/loop_wrap = true
tracks/0/keys = {
"times": PackedFloat32Array(0.2, 1.1),
"transitions": PackedFloat32Array(1, 1),
"update": 1,
"values": [5, 0]
}

[sub_resource type="Animation" id="Animation_c2bru"]
resource_name = "wiggle"
length = 0.75
step = 0.05
tracks/0/type = "value"
tracks/0/imported = false
tracks/0/enabled = true
tracks/0/path = NodePath(".:scale")
tracks/0/interp = 1
tracks/0/loop_wrap = true
tracks/0/keys = {
"times": PackedFloat32Array(0, 0.15, 0.3, 0.45, 0.6),
"transitions": PackedFloat32Array(1, 1, 1, 1, 1),
"update": 0,
"values": [Vector2(1, 1), Vector2(0.592, 1.1), Vector2(1, 1), Vector2(0.592, 1.1), Vector2(1, 1)]
}

[sub_resource type="AnimationLibrary" id="AnimationLibrary_5jusd"]
_data = {
&"fade": SubResource("Animation_bsln0"),
&"flip": SubResource("Animation_rseek"),
&"horizontal_squish": SubResource("Animation_u1h3m"),
&"vertical_squish": SubResource("Animation_bo7l3"),
&"wait": SubResource("Animation_bx5ai"),
&"wiggle": SubResource("Animation_c2bru")
}

[node name="character" type="CharacterBody2D"]
z_index = -1
script = ExtResource("1")

[node name="safety_timer" type="Timer" parent="."]
one_shot = true

[node name="AnimationPlayer" type="AnimationPlayer" parent="."]
libraries = {
"": SubResource("AnimationLibrary_5jusd")
}

[connection signal="ready" from="." to="." method="_on_character_ready"]
[connection signal="timeout" from="safety_timer" to="." method="_on_safety_timer_timeout"]
     [gd_scene load_steps=143 format=3 uid="uid://dls0iud7anxmg"]

[ext_resource type="PackedScene" uid="uid://dpj227ev6qwj7" path="res://actors/character.tscn" id="1"]
[ext_resource type="PackedScene" uid="uid://b20glj05e5oxk" path="res://actors/player_scripting.tscn" id="3"]
[ext_resource type="Script" uid="uid://nrcg1t7at64h" path="res://actors/player_body_sprite.gd" id="3_c6yke"]
[ext_resource type="Script" uid="uid://cr7hbmvs23eov" path="res://actors/player_camera.gd" id="3_vs1ij"]
[ext_resource type="Texture2D" uid="uid://bkcsl8s2xcm0q" path="res://gfx/characters/player/player_human.png" id="4_hnac2"]
[ext_resource type="Texture2D" uid="uid://mpoms8rcbb8j" path="res://gfx/characters/player/coat.png" id="5_xt8mn"]
[ext_resource type="Texture2D" uid="uid://cc82t3hlw0nbh" path="res://gfx/characters/player/human_head.png" id="8_x6evy"]
[ext_resource type="Texture2D" uid="uid://bb0dxvhg0nq6j" path="res://gfx/characters/player/pants.png" id="9_4flyk"]
[ext_resource type="Texture2D" uid="uid://dv3d7bsxerkxm" path="res://gfx/characters/player/player_lizard.png" id="10_2hto0"]
[ext_resource type="Texture2D" uid="uid://dnmaninx4tvcj" path="res://gfx/characters/player/shadow.png" id="10_h571y"]
[ext_resource type="Texture2D" uid="uid://nb11koq6vx03" path="res://gfx/characters/player/shirt.png" id="10_injdq"]
[ext_resource type="Texture2D" uid="uid://ct6a5gwt73t8f" path="res://gfx/characters/player/tanktop.png" id="11_eer5y"]
[ext_resource type="Texture2D" uid="uid://d0k1b1tvw7lho" path="res://gfx/characters/player/catsuit.png" id="11_wn8wb"]
[ext_resource type="Texture2D" uid="uid://dhepl7dhm13k7" path="res://gfx/characters/player/shorts.png" id="11_y262g"]
[ext_resource type="Texture2D" uid="uid://ycs7f67qww5p" path="res://gfx/characters/player/shoes.png" id="13_r1f7g"]
[ext_resource type="Texture2D" uid="uid://bwr6oq85x64hg" path="res://gfx/characters/player/bandana.png" id="14_k7stq"]
[ext_resource type="Texture2D" uid="uid://ckd6utwhql6u" path="res://gfx/characters/player/helmet.png" id="15_dxpnl"]
[ext_resource type="Texture2D" uid="uid://y52tu3jdkeiu" path="res://gfx/characters/player/lizard_head.png" id="16_exju4"]
[ext_resource type="Texture2D" uid="uid://dfcieo3r5c8wp" path="res://gfx/characters/player/tail.png" id="17_2xu71"]
[ext_resource type="Texture2D" uid="uid://c20tppjrm4fyi" path="res://gfx/characters/player/lizard_shoes.png" id="18_4llow"]

[sub_resource type="RectangleShape2D" id="9"]
size = Vector2(1, 5.5)

[sub_resource type="SpriteFrames" id="SpriteFrames_mxjc0"]
animations = [{
"frames": [],
"loop": true,
"name": &"standing",
"speed": 5.0
}, {
"frames": [],
"loop": true,
"name": &"walking",
"speed": 5.0
}]

[sub_resource type="AtlasTexture" id="AtlasTexture_w4nh5"]
atlas = ExtResource("4_hnac2")
region = Rect2(0, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_rnmeu"]
atlas = ExtResource("4_hnac2")
region = Rect2(64, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_7g4qm"]
atlas = ExtResource("4_hnac2")
region = Rect2(128, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_peexe"]
atlas = ExtResource("4_hnac2")
region = Rect2(192, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_h5ng1"]
atlas = ExtResource("4_hnac2")
region = Rect2(256, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_3yqip"]
atlas = ExtResource("4_hnac2")
region = Rect2(320, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_4egc1"]
atlas = ExtResource("4_hnac2")
region = Rect2(384, 0, 64, 64)

[sub_resource type="SpriteFrames" id="SpriteFrames_01s50"]
animations = [{
"frames": [{
"duration": 1.0,
"texture": SubResource("AtlasTexture_w4nh5")
}],
"loop": true,
"name": &"standing",
"speed": 5.0
}, {
"frames": [{
"duration": 1.0,
"texture": SubResource("AtlasTexture_rnmeu")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_7g4qm")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_peexe")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_h5ng1")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_3yqip")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_4egc1")
}],
"loop": true,
"name": &"walking",
"speed": 5.0
}]

[sub_resource type="AtlasTexture" id="AtlasTexture_s0icb"]
atlas = ExtResource("8_x6evy")
region = Rect2(0, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_tkfn6"]
atlas = ExtResource("8_x6evy")
region = Rect2(64, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_ihv1q"]
atlas = ExtResource("8_x6evy")
region = Rect2(128, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_g8d4n"]
atlas = ExtResource("8_x6evy")
region = Rect2(192, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_25ppd"]
atlas = ExtResource("8_x6evy")
region = Rect2(256, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_5xwg6"]
atlas = ExtResource("8_x6evy")
region = Rect2(320, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_wvykr"]
atlas = ExtResource("8_x6evy")
region = Rect2(384, 0, 64, 64)

[sub_resource type="SpriteFrames" id="SpriteFrames_ts51m"]
animations = [{
"frames": [{
"duration": 1.0,
"texture": SubResource("AtlasTexture_s0icb")
}],
"loop": true,
"name": &"standing",
"speed": 5.0
}, {
"frames": [{
"duration": 1.0,
"texture": SubResource("AtlasTexture_tkfn6")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_ihv1q")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_g8d4n")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_25ppd")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_5xwg6")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_wvykr")
}],
"loop": true,
"name": &"walking",
"speed": 5.0
}]

[sub_resource type="AtlasTexture" id="AtlasTexture_iw8qy"]
atlas = ExtResource("9_4flyk")
region = Rect2(0, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_phs6m"]
atlas = ExtResource("9_4flyk")
region = Rect2(64, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_2u4kw"]
atlas = ExtResource("9_4flyk")
region = Rect2(128, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_1tk83"]
atlas = ExtResource("9_4flyk")
region = Rect2(192, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_v2e01"]
atlas = ExtResource("9_4flyk")
region = Rect2(256, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_8yv0p"]
atlas = ExtResource("9_4flyk")
region = Rect2(320, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_b8u4c"]
atlas = ExtResource("9_4flyk")
region = Rect2(384, 0, 64, 64)

[sub_resource type="SpriteFrames" id="SpriteFrames_vphkr"]
animations = [{
"frames": [{
"duration": 1.0,
"texture": SubResource("AtlasTexture_iw8qy")
}],
"loop": true,
"name": &"standing",
"speed": 5.0
}, {
"frames": [{
"duration": 1.0,
"texture": SubResource("AtlasTexture_phs6m")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_2u4kw")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_1tk83")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_v2e01")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_8yv0p")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_b8u4c")
}],
"loop": true,
"name": &"walking",
"speed": 5.0
}]

[sub_resource type="AtlasTexture" id="AtlasTexture_otjwn"]
atlas = ExtResource("10_injdq")
region = Rect2(0, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_gae5d"]
atlas = ExtResource("10_injdq")
region = Rect2(64, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_04vst"]
atlas = ExtResource("10_injdq")
region = Rect2(128, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_mct3j"]
atlas = ExtResource("10_injdq")
region = Rect2(192, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_ayxu0"]
atlas = ExtResource("10_injdq")
region = Rect2(256, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_ec3d4"]
atlas = ExtResource("10_injdq")
region = Rect2(320, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_wvb8j"]
atlas = ExtResource("10_injdq")
region = Rect2(384, 0, 64, 64)

[sub_resource type="SpriteFrames" id="SpriteFrames_bbtog"]
animations = [{
"frames": [{
"duration": 1.0,
"texture": SubResource("AtlasTexture_otjwn")
}],
"loop": true,
"name": &"standing",
"speed": 5.0
}, {
"frames": [{
"duration": 1.0,
"texture": SubResource("AtlasTexture_gae5d")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_04vst")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_mct3j")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_ayxu0")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_ec3d4")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_wvb8j")
}],
"loop": true,
"name": &"walking",
"speed": 5.0
}]

[sub_resource type="AtlasTexture" id="AtlasTexture_qdscw"]
atlas = ExtResource("5_xt8mn")
region = Rect2(0, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_y8jkp"]
atlas = ExtResource("5_xt8mn")
region = Rect2(64, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_mpkg8"]
atlas = ExtResource("5_xt8mn")
region = Rect2(128, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_3o8cr"]
atlas = ExtResource("5_xt8mn")
region = Rect2(192, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_yvr7n"]
atlas = ExtResource("5_xt8mn")
region = Rect2(256, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_mijhn"]
atlas = ExtResource("5_xt8mn")
region = Rect2(320, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_8itc3"]
atlas = ExtResource("5_xt8mn")
region = Rect2(384, 0, 64, 64)

[sub_resource type="SpriteFrames" id="SpriteFrames_ynt0k"]
animations = [{
"frames": [{
"duration": 1.0,
"texture": SubResource("AtlasTexture_qdscw")
}],
"loop": true,
"name": &"standing",
"speed": 5.0
}, {
"frames": [{
"duration": 1.0,
"texture": SubResource("AtlasTexture_y8jkp")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_mpkg8")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_3o8cr")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_yvr7n")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_mijhn")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_8itc3")
}],
"loop": true,
"name": &"walking",
"speed": 5.0
}]

[sub_resource type="AtlasTexture" id="AtlasTexture_wx0rh"]
atlas = ExtResource("13_r1f7g")
region = Rect2(0, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_beojw"]
atlas = ExtResource("13_r1f7g")
region = Rect2(64, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_84epk"]
atlas = ExtResource("13_r1f7g")
region = Rect2(128, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_pwjt0"]
atlas = ExtResource("13_r1f7g")
region = Rect2(192, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_08gbr"]
atlas = ExtResource("13_r1f7g")
region = Rect2(256, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_ej0ht"]
atlas = ExtResource("13_r1f7g")
region = Rect2(320, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_ss1ae"]
atlas = ExtResource("13_r1f7g")
region = Rect2(384, 0, 64, 64)

[sub_resource type="SpriteFrames" id="SpriteFrames_xavrc"]
animations = [{
"frames": [{
"duration": 1.0,
"texture": SubResource("AtlasTexture_wx0rh")
}],
"loop": true,
"name": &"standing",
"speed": 5.0
}, {
"frames": [{
"duration": 1.0,
"texture": SubResource("AtlasTexture_beojw")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_84epk")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_pwjt0")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_08gbr")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_ej0ht")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_ss1ae")
}],
"loop": true,
"name": &"walking",
"speed": 5.0
}]

[sub_resource type="AtlasTexture" id="AtlasTexture_v2xiw"]
atlas = ExtResource("17_2xu71")
region = Rect2(0, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_c1fh1"]
atlas = ExtResource("17_2xu71")
region = Rect2(64, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_7o2ah"]
atlas = ExtResource("17_2xu71")
region = Rect2(128, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_8p73h"]
atlas = ExtResource("17_2xu71")
region = Rect2(192, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_462pk"]
atlas = ExtResource("17_2xu71")
region = Rect2(256, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_okber"]
atlas = ExtResource("17_2xu71")
region = Rect2(320, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_vsynp"]
atlas = ExtResource("17_2xu71")
region = Rect2(384, 0, 64, 64)

[sub_resource type="SpriteFrames" id="SpriteFrames_fciho"]
animations = [{
"frames": [{
"duration": 1.0,
"texture": SubResource("AtlasTexture_v2xiw")
}],
"loop": true,
"name": &"standing",
"speed": 5.0
}, {
"frames": [{
"duration": 1.0,
"texture": SubResource("AtlasTexture_c1fh1")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_7o2ah")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_8p73h")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_462pk")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_okber")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_vsynp")
}],
"loop": true,
"name": &"walking",
"speed": 5.0
}]

[sub_resource type="AtlasTexture" id="AtlasTexture_ndgv1"]
atlas = ExtResource("10_2hto0")
region = Rect2(0, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_hqg1o"]
atlas = ExtResource("10_2hto0")
region = Rect2(64, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_6ivab"]
atlas = ExtResource("10_2hto0")
region = Rect2(128, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_caxco"]
atlas = ExtResource("10_2hto0")
region = Rect2(192, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_qqc4j"]
atlas = ExtResource("10_2hto0")
region = Rect2(256, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_c552h"]
atlas = ExtResource("10_2hto0")
region = Rect2(320, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_s6pbo"]
atlas = ExtResource("10_2hto0")
region = Rect2(384, 0, 64, 64)

[sub_resource type="SpriteFrames" id="SpriteFrames_j88ap"]
animations = [{
"frames": [{
"duration": 1.0,
"texture": SubResource("AtlasTexture_ndgv1")
}],
"loop": true,
"name": &"standing",
"speed": 5.0
}, {
"frames": [{
"duration": 1.0,
"texture": SubResource("AtlasTexture_hqg1o")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_6ivab")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_caxco")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_qqc4j")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_c552h")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_s6pbo")
}],
"loop": true,
"name": &"walking",
"speed": 5.0
}]

[sub_resource type="AtlasTexture" id="AtlasTexture_nqry6"]
atlas = ExtResource("11_wn8wb")
region = Rect2(0, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_6pih5"]
atlas = ExtResource("11_wn8wb")
region = Rect2(64, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_y74gh"]
atlas = ExtResource("11_wn8wb")
region = Rect2(128, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_0ceo3"]
atlas = ExtResource("11_wn8wb")
region = Rect2(192, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_wcbyi"]
atlas = ExtResource("11_wn8wb")
region = Rect2(256, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_fsykn"]
atlas = ExtResource("11_wn8wb")
region = Rect2(320, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_7bltm"]
atlas = ExtResource("11_wn8wb")
region = Rect2(384, 0, 64, 64)

[sub_resource type="SpriteFrames" id="SpriteFrames_r8v5t"]
animations = [{
"frames": [{
"duration": 1.0,
"texture": SubResource("AtlasTexture_nqry6")
}],
"loop": true,
"name": &"standing",
"speed": 5.0
}, {
"frames": [{
"duration": 1.0,
"texture": SubResource("AtlasTexture_6pih5")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_y74gh")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_0ceo3")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_wcbyi")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_fsykn")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_7bltm")
}],
"loop": true,
"name": &"walking",
"speed": 5.0
}]

[sub_resource type="AtlasTexture" id="AtlasTexture_b8rpv"]
atlas = ExtResource("11_y262g")
region = Rect2(0, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_kxnet"]
atlas = ExtResource("11_y262g")
region = Rect2(64, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_v7gm2"]
atlas = ExtResource("11_y262g")
region = Rect2(128, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_fhx3n"]
atlas = ExtResource("11_y262g")
region = Rect2(192, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_8b1uc"]
atlas = ExtResource("11_y262g")
region = Rect2(256, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_hmehs"]
atlas = ExtResource("11_y262g")
region = Rect2(320, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_rvok8"]
atlas = ExtResource("11_y262g")
region = Rect2(384, 0, 64, 64)

[sub_resource type="SpriteFrames" id="SpriteFrames_tjexb"]
animations = [{
"frames": [{
"duration": 1.0,
"texture": SubResource("AtlasTexture_b8rpv")
}],
"loop": true,
"name": &"standing",
"speed": 5.0
}, {
"frames": [{
"duration": 1.0,
"texture": SubResource("AtlasTexture_kxnet")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_v7gm2")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_fhx3n")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_8b1uc")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_hmehs")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_rvok8")
}],
"loop": true,
"name": &"walking",
"speed": 5.0
}]

[sub_resource type="AtlasTexture" id="AtlasTexture_ugtck"]
atlas = ExtResource("11_eer5y")
region = Rect2(0, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_xr01q"]
atlas = ExtResource("11_eer5y")
region = Rect2(64, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_aiuv1"]
atlas = ExtResource("11_eer5y")
region = Rect2(128, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_tqx4y"]
atlas = ExtResource("11_eer5y")
region = Rect2(192, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_h82i1"]
atlas = ExtResource("11_eer5y")
region = Rect2(256, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_1pkii"]
atlas = ExtResource("11_eer5y")
region = Rect2(320, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_w83nf"]
atlas = ExtResource("11_eer5y")
region = Rect2(384, 0, 64, 64)

[sub_resource type="SpriteFrames" id="SpriteFrames_ciedd"]
animations = [{
"frames": [{
"duration": 1.0,
"texture": SubResource("AtlasTexture_ugtck")
}],
"loop": true,
"name": &"standing",
"speed": 5.0
}, {
"frames": [{
"duration": 1.0,
"texture": SubResource("AtlasTexture_xr01q")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_aiuv1")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_tqx4y")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_h82i1")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_1pkii")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_w83nf")
}],
"loop": true,
"name": &"walking",
"speed": 5.0
}]

[sub_resource type="AtlasTexture" id="AtlasTexture_4ruct"]
atlas = ExtResource("15_dxpnl")
region = Rect2(0, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_pe86h"]
atlas = ExtResource("15_dxpnl")
region = Rect2(64, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_ue5oo"]
atlas = ExtResource("15_dxpnl")
region = Rect2(128, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_0uuna"]
atlas = ExtResource("15_dxpnl")
region = Rect2(192, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_0jycx"]
atlas = ExtResource("15_dxpnl")
region = Rect2(256, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_lj5fv"]
atlas = ExtResource("15_dxpnl")
region = Rect2(320, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_s7udc"]
atlas = ExtResource("15_dxpnl")
region = Rect2(384, 0, 64, 64)

[sub_resource type="SpriteFrames" id="SpriteFrames_g08ql"]
animations = [{
"frames": [{
"duration": 1.0,
"texture": SubResource("AtlasTexture_4ruct")
}],
"loop": true,
"name": &"standing",
"speed": 5.0
}, {
"frames": [{
"duration": 1.0,
"texture": SubResource("AtlasTexture_pe86h")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_ue5oo")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_0uuna")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_0jycx")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_lj5fv")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_s7udc")
}],
"loop": true,
"name": &"walking",
"speed": 5.0
}]

[sub_resource type="AtlasTexture" id="AtlasTexture_fw37v"]
atlas = ExtResource("16_exju4")
region = Rect2(0, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_3evdp"]
atlas = ExtResource("16_exju4")
region = Rect2(64, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_s3eny"]
atlas = ExtResource("16_exju4")
region = Rect2(128, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_mq7u7"]
atlas = ExtResource("16_exju4")
region = Rect2(192, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_57x38"]
atlas = ExtResource("16_exju4")
region = Rect2(256, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_do78h"]
atlas = ExtResource("16_exju4")
region = Rect2(320, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_hl380"]
atlas = ExtResource("16_exju4")
region = Rect2(384, 0, 64, 64)

[sub_resource type="SpriteFrames" id="SpriteFrames_bxr2h"]
animations = [{
"frames": [{
"duration": 1.0,
"texture": SubResource("AtlasTexture_fw37v")
}],
"loop": true,
"name": &"standing",
"speed": 5.0
}, {
"frames": [{
"duration": 1.0,
"texture": SubResource("AtlasTexture_3evdp")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_s3eny")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_mq7u7")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_57x38")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_do78h")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_hl380")
}],
"loop": true,
"name": &"walking",
"speed": 5.0
}]

[sub_resource type="AtlasTexture" id="AtlasTexture_l1oka"]
atlas = ExtResource("18_4llow")
region = Rect2(0, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_dla26"]
atlas = ExtResource("18_4llow")
region = Rect2(64, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_bgxtu"]
atlas = ExtResource("18_4llow")
region = Rect2(128, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_ovodm"]
atlas = ExtResource("18_4llow")
region = Rect2(192, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_e3crw"]
atlas = ExtResource("18_4llow")
region = Rect2(256, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_qv2ik"]
atlas = ExtResource("18_4llow")
region = Rect2(320, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_nh0fe"]
atlas = ExtResource("18_4llow")
region = Rect2(384, 0, 64, 64)

[sub_resource type="SpriteFrames" id="SpriteFrames_x36o6"]
animations = [{
"frames": [{
"duration": 1.0,
"texture": SubResource("AtlasTexture_l1oka")
}],
"loop": true,
"name": &"standing",
"speed": 5.0
}, {
"frames": [{
"duration": 1.0,
"texture": SubResource("AtlasTexture_dla26")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_bgxtu")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_ovodm")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_e3crw")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_qv2ik")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_nh0fe")
}],
"loop": true,
"name": &"walking",
"speed": 5.0
}]

[sub_resource type="AtlasTexture" id="AtlasTexture_1mv3f"]
atlas = ExtResource("14_k7stq")
region = Rect2(0, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_xuqto"]
atlas = ExtResource("14_k7stq")
region = Rect2(64, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_apntd"]
atlas = ExtResource("14_k7stq")
region = Rect2(128, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_fsxdm"]
atlas = ExtResource("14_k7stq")
region = Rect2(192, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_squ2p"]
atlas = ExtResource("14_k7stq")
region = Rect2(256, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_f8ndn"]
atlas = ExtResource("14_k7stq")
region = Rect2(320, 0, 64, 64)

[sub_resource type="AtlasTexture" id="AtlasTexture_2kjlc"]
atlas = ExtResource("14_k7stq")
region = Rect2(384, 0, 64, 64)

[sub_resource type="SpriteFrames" id="SpriteFrames_tbys6"]
animations = [{
"frames": [{
"duration": 1.0,
"texture": SubResource("AtlasTexture_1mv3f")
}],
"loop": true,
"name": &"standing",
"speed": 5.0
}, {
"frames": [{
"duration": 1.0,
"texture": SubResource("AtlasTexture_xuqto")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_apntd")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_fsxdm")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_squ2p")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_f8ndn")
}, {
"duration": 1.0,
"texture": SubResource("AtlasTexture_2kjlc")
}],
"loop": true,
"name": &"walking",
"speed": 5.0
}]

[node name="player" instance=ExtResource("1")]
script_name = "cEgo"
is_player = true
body = NodePath("body")
character_speed = 140

[node name="player_scripting" parent="." index="0" instance=ExtResource("3")]

[node name="CollisionShape2D" type="CollisionShape2D" parent="." index="1"]
z_index = 1
position = Vector2(0, -9.5)
shape = SubResource("9")

[node name="PlayerCamera" type="Camera2D" parent="." index="3"]
editor_draw_drag_margin = true
script = ExtResource("3_vs1ij")

[node name="desmooth" type="Timer" parent="PlayerCamera" index="0"]
wait_time = 1.5
one_shot = true

[node name="body" type="AnimatedSprite2D" parent="." index="4"]
position = Vector2(0, -32)
sprite_frames = SubResource("SpriteFrames_mxjc0")
animation = &"standing"
script = ExtResource("3_c6yke")

[node name="base" type="AnimatedSprite2D" parent="body" index="0"]
sprite_frames = SubResource("SpriteFrames_01s50")
animation = &"standing"

[node name="human_head" type="AnimatedSprite2D" parent="body" index="1"]
visible = false
sprite_frames = SubResource("SpriteFrames_ts51m")
animation = &"walking"

[node name="pants" type="AnimatedSprite2D" parent="body" index="2"]
visible = false
modulate = Color(0.34902, 0.34902, 0.34902, 1)
sprite_frames = SubResource("SpriteFrames_vphkr")
animation = &"standing"

[node name="shirt" type="AnimatedSprite2D" parent="body" index="3"]
visible = false
sprite_frames = SubResource("SpriteFrames_bbtog")
animation = &"standing"

[node name="coat" type="AnimatedSprite2D" parent="body" index="4"]
visible = false
sprite_frames = SubResource("SpriteFrames_ynt0k")
animation = &"standing"

[node name="shoes" type="AnimatedSprite2D" parent="body" index="5"]
sprite_frames = SubResource("SpriteFrames_xavrc")
animation = &"standing"

[node name="tail" type="AnimatedSprite2D" parent="body" index="6"]
sprite_frames = SubResource("SpriteFrames_fciho")
animation = &"standing"

[node name="lizard" type="AnimatedSprite2D" parent="body" index="7"]
sprite_frames = SubResource("SpriteFrames_j88ap")
animation = &"standing"

[node name="catsuit" type="AnimatedSprite2D" parent="body" index="8"]
visible = false
sprite_frames = SubResource("SpriteFrames_r8v5t")
animation = &"standing"

[node name="shadow" type="Sprite2D" parent="body" index="9"]
position = Vector2(0, 32)
texture = ExtResource("10_h571y")

[node name="shorts" type="AnimatedSprite2D" parent="body" index="10"]
sprite_frames = SubResource("SpriteFrames_tjexb")
animation = &"standing"

[node name="tanktop" type="AnimatedSprite2D" parent="body" index="11"]
sprite_frames = SubResource("SpriteFrames_ciedd")
animation = &"standing"

[node name="helmet" type="AnimatedSprite2D" parent="body" index="12"]
visible = false
sprite_frames = SubResource("SpriteFrames_g08ql")
animation = &"walking"

[node name="lizard_head" type="AnimatedSprite2D" parent="body" index="13"]
visible = false
sprite_frames = SubResource("SpriteFrames_bxr2h")
animation = &"walking"

[node name="lizard_shoes" type="AnimatedSprite2D" parent="body" index="14"]
sprite_frames = SubResource("SpriteFrames_x36o6")
animation = &"standing"

[node name="bandana" type="AnimatedSprite2D" parent="body" index="15"]
sprite_frames = SubResource("SpriteFrames_tbys6")
animation = &"standing"

[connection signal="animating_now" from="." to="body" method="_on_player_animating_now"]
[connection signal="arrived_destination" from="." to="player_scripting" method="_on_player_arrived_destination"]
[connection signal="h_flipped" from="." to="body" method="_on_player_h_flipped"]
[connection signal="neo_settings" from="." to="player_scripting" method="_on_player_neo_settings"]
[connection signal="new_state" from="." to="body" method="_on_player_new_state"]
[connection signal="tree_entered" from="." to="." method="_on_player_tree_entered"]
[connection signal="timeout" from="PlayerCamera/desmooth" to="PlayerCamera" method="_on_desmooth_timeout"]
[connection signal="animation_changed" from="body" to="body" method="_on_animation_changed"]
              GDSCe     (/`6 }JTR v"y{=Y k&ɄU{o\}|_m	#(j׸UQUUg u  	~O1OoaRƣԔ+,-,,*+.?:^RZl|̘Al%쌎pѡo)S1!$B]dkcw n#dwA]kdwv7lwu%g;KOW	??\h-WI?IޏFd^?#k2~,TB???Ag=?Os P kR̘k%&,KAc$SJrL"giItR:)ZkZiZkJiVkU:m6R:iNJ)~'&~%!~O?sôKYI5?~B~6ğs)񗑕DⰮXBeT5! !
 I^p88՚zbH$p3aa
!%`0	@h~65%$$zvNgW;911t:.jr3hj)[8n7CFe+vܼ`lV$O^ eOYyh;;sEGǫ%''9|қ)$B
bLJg< (4I0$%E5ٰ/?Φ6Xc;n6`Q&V%fcf"r,|)5.gAknY&+'jWgHkE9Hΰ;k<'
sR}_W7ˣr͘WҌ*̳?rBu710řR:ݝ]2o)~asºs&ɴ`Ukm1uybnH|3Ƙ;33Fhգ%0
ŉ^ۭ@rJGg_,qJ7ohp̓ >E%-H!O1׫0'yʟ'=8IÂW<~2dfl3m0'va.ѥnBfgn
 46[=n-Ww+O
mǈ0cצ%`
r53(3y^oDBlоx`o7$%ɭm-"@"  `N @@̈ H0PC9z:{gKR%
p.=SG?~L_s=NrDr93;&ѥ2>޳%m&_V-piE5`f7Xδfa@5{ZOؽ3SM8[Nx[]g _?ΝMv/>T\9wp|n
:Gά>hcpOrvgrXZ^/RunOq?n:3J
3_J4whG 2
?ÿ:P*Un: [c&B3݋k>
gX:Y2^@k޴W]/(eN.)tex'UA֍
cZ/ܸ{[e_Gʛ?X}
7    GDSCe     (/` TC7@ˤ1_++Vv0 3o80\aqV8j@!1 4 - Y|DKv]X݅v#	~#?$=!
7ij{	*_*j W?KNJ'#Qz
~I1o7ygdDڼ45օ5d"f/c@'ȒYI_:HJ4D-i%IARȲ)y	4+hJRҲtzUcSbVR{CnheULaTn0Ydy 7,ws`c1w
}0o>xCDcĀSfP.	y%Gݔxs+u@svW3<gܰB^!zm,߿#Ċ`v=6.->L'#|47m-?9;ox8u`Sn 0t_|,v&gm^
#ƇCCZXNJ?rQM䋖Wmp/3e6öY,v<S3?:هw9g?GDSCe   |  (/`|8 8HQk_+RB&D~BJj
?cK 2$u)ô15:dq+TC   &tݓSԋbwʹr 9|E8IEԐKc^v<Pj	ΗWLfRpbHׁ!Μt eq+
+$XRL	a	=_^⽗ɽ7+ޫuuM{%^{/?/WG~?_D?ȏW~Пq	_4~1?w/`hդvN&r&O,bJ{i`䜖(.eFK,[UQkY#VZiɑ+cVZ+%Ir$Ir$IrZ+RJ)$~"~S?ۿtÿT驃?驇6SُG-??7+\??<D4|-N  jôVn_jLJJ:Q=fN쀀rՎ21<A!߅Sѣi`dX	gK [dx0[pM!!2(%hxJScTX!86Vݘyj c	S؟lKV8&j&(c'ii4̺+1l-c$fEtMD$H

R(t"Z'0FDAAJR>k`듻uN+q'ԎՙI;~b;|c*\Ԛkh#FKPm
`ӳrI^h:	?\AB^vl >{
zZޔK;
Ơey|4T? uVVk!J޹ۤ
s5t3C
=AV.MC¼aҹ(	.TV"dRd23֮py@jrend'rέM-臱-J/婎@7\[c7VX0½\)4\0mǰNҤrnk6?b
c
ؒljCeac2p0PAj/N0C@ lf7;HVl++\U#nS[v7^c <>3L`g<c+Xy3Vg<c+`\C=@Wׇ>u޽Wi׼$wWM>]=?|pqZgM.u`*8zǽ}z6C`2y% d"~oD.BВK6l۟)/_.j/<h[Y/<.QbZʻy9KVE}Nî* r9tWjZѐ铧Vt們'h ϻK]@F_ 1{(Ë&;<֣O-t?

e^{OD)5$oO̣p;_#
7l{rtFtS]/-_h~u@[]k:~_?9C֯v~xd>fz:;yװ'xi=|8]l:_]?dE?lBp\OhKXd6~;0;znuQ~sdW(|~2}~g(c߻bbhw'[dN z  [gd_scene load_steps=3 format=3 uid="uid://b20glj05e5oxk"]

[ext_resource type="AudioStream" uid="uid://dgmcgarrxp13a" path="res://sfx/step_hard.ogg" id="1"]
[ext_resource type="Script" uid="uid://ii5gjd3s25pf" path="res://actors/player_scripting.gd" id="2"]

[node name="player_scripting" type="Node"]
script = ExtResource("2")

[node name="AudioStreamPlayer" type="AudioStreamPlayer" parent="."]
stream = ExtResource("1")
volume_db = -28.0

[connection signal="finished" from="AudioStreamPlayer" to="." method="_on_AudioStreamPlayer_finished"]
              GDSCe     (/` 5 G!58p&\Ŧ_ӫǥYX)SjJ
@17IOZ⿨1q7?O?[A@au=!:;h=#>6O;=Hvك,S]`?w"Y>Q~|s:HsB[Ɩgb    [gd_scene load_steps=124 format=3 uid="uid://cnijp86cm63ly"]

[ext_resource type="Texture2D" uid="uid://dy6gvtf2wxq6k" path="res://gfx/characters/shadow.png" id="1"]
[ext_resource type="Texture2D" uid="uid://c7tfwpu6ueexh" path="res://gfx/characters/rando/glasses.png" id="2"]
[ext_resource type="Texture2D" uid="uid://c0hbkhhe7fwtx" path="res://gfx/characters/hi_res_rando/rando_lines.png" id="2_equr0"]
[ext_resource type="Texture2D" uid="uid://dry28urtxvhl" path="res://gfx/characters/rando/rando_lines.png" id="3"]
[ext_resource type="Texture2D" uid="uid://cf51d1hx3328r" path="res://gfx/characters/rando/rando_skin.png" id="4"]
[ext_resource type="Texture2D" uid="uid://bfqkilmjicaw2" path="res://gfx/characters/hi_res_rando/rando_lizard_lines.png" id="4_3ww2s"]
[ext_resource type="Script" uid="uid://bt8lik08lf13c" path="res://actors/rando_accessories.gd" id="5"]
[ext_resource type="Texture2D" uid="uid://b6sxthb54wc2o" path="res://gfx/characters/rando/hat.png" id="6"]
[ext_resource type="Texture2D" uid="uid://cf5b44hqd3otd" path="res://gfx/characters/hi_res_rando/rando_skin.png" id="6_crg6p"]
[ext_resource type="Texture2D" uid="uid://b0w0gdp4jsh1u" path="res://gfx/characters/rando/long.png" id="7"]
[ext_resource type="Texture2D" uid="uid://eikt7wsxk4tc" path="res://gfx/characters/rando/messy.png" id="8"]
[ext_resource type="Texture2D" uid="uid://bcs00h1rxsxp0" path="res://gfx/characters/hi_res_rando/rando_lizard_skin.png" id="8_qehbk"]
[ext_resource type="Texture2D" uid="uid://d313tbdwxu3k2" path="res://gfx/characters/rando/afro.png" id="9"]
[ext_resource type="Texture2D" uid="uid://b53loswsmlnxb" path="res://gfx/characters/rando/shirtpants.png" id="10"]
[ext_resource type="Texture2D" uid="uid://cmgmr2vh8yfyq" path="res://gfx/characters/hi_res_rando/rando_suit.png" id="10_7dcqq"]
[ext_resource type="Texture2D" uid="uid://cxonn22yf8fcp" path="res://gfx/characters/hi_res_rando/rando_sailor.png" id="10_yxwdb"]
[ext_resource type="Texture2D" uid="uid://bj2tp5jp0yf65" path="res://gfx/characters/rando/beard.png" id="11"]
[ext_resource type="Texture2D" uid="uid://b64qqtf7iro5g" path="res://gfx/characters/hi_res_rando/rando_robe.png" id="11_2jvk6"]
[ext_resource type="Texture2D" uid="uid://b6njn2mhwujqq" path="res://gfx/characters/hi_res_rando/afro.png" id="11_6jfvk"]
[ext_resource type="Texture2D" uid="uid://4u8mv216iprh" path="res://gfx/characters/hi_res_rando/rando_skirt.png" id="11_l5a22"]
[ext_resource type="Texture2D" uid="uid://behnv8au8rj71" path="res://gfx/characters/hi_res_rando/beard.png" id="12_af3bb"]
[ext_resource type="Texture2D" uid="uid://bmb027uueekfc" path="res://gfx/characters/hi_res_rando/rando_topless.png" id="12_bowq2"]
[ext_resource type="Texture2D" uid="uid://kbcuc333xo65" path="res://gfx/characters/rando/finaltuft.png" id="13"]
[ext_resource type="Texture2D" uid="uid://bxjjgcl6iwmk0" path="res://gfx/characters/hi_res_rando/glasses.png" id="13_lbtgt"]
[ext_resource type="Texture2D" uid="uid://44edr3safj8v" path="res://gfx/characters/hi_res_rando/rando_shorts.png" id="13_xo6or"]
[ext_resource type="Texture2D" uid="uid://cmatntm38how3" path="res://gfx/characters/rando/soft_serve.png" id="14"]
[ext_resource type="Texture2D" uid="uid://bgn7246ccxgxc" path="res://gfx/characters/hi_res_rando/rando_shoulder.png" id="14_3l8ir"]
[ext_resource type="Texture2D" uid="uid://cbolv8rccfwp3" path="res://gfx/characters/hi_res_rando/long.png" id="14_tl31v"]
[ext_resource type="Texture2D" uid="uid://bmwkw5ienmxi0" path="res://gfx/characters/rando/piqued.png" id="15"]
[ext_resource type="Texture2D" uid="uid://kqudkjm1tc2m" path="res://gfx/characters/hi_res_rando/soft_servie.png" id="15_003c2"]
[ext_resource type="Texture2D" uid="uid://baohs8r413iis" path="res://gfx/characters/rando/straight.png" id="16"]
[ext_resource type="Texture2D" uid="uid://bdjymj2b8ocea" path="res://gfx/characters/rando/rando_lines_lizard.png" id="17"]
[ext_resource type="Texture2D" uid="uid://g4u5beop5tcr" path="res://gfx/characters/hi_res_rando/rando_armor.png" id="17_2xnp3"]
[ext_resource type="Texture2D" uid="uid://b37n0jc0su7v7" path="res://gfx/characters/rando/rando_skin_lizard.png" id="19"]
[ext_resource type="Texture2D" uid="uid://djdk02yccnr0g" path="res://gfx/characters/hi_res_rando/side_shave.png" id="19_pr1qg"]
[ext_resource type="Texture2D" uid="uid://qalfkaiplsvx" path="res://gfx/characters/hi_res_rando/longer.png" id="22_hjuqy"]
[ext_resource type="Texture2D" uid="uid://nga4amcyafn" path="res://gfx/characters/hi_res_rando/rando_bandana.png" id="37_osj47"]

[sub_resource type="AtlasTexture" id="2"]
atlas = ExtResource("4")
region = Rect2(0, 0, 26, 26)

[sub_resource type="AtlasTexture" id="3"]
atlas = ExtResource("4")
region = Rect2(0, 26, 26, 26)

[sub_resource type="AtlasTexture" id="4"]
atlas = ExtResource("4")
region = Rect2(0, 52, 26, 26)

[sub_resource type="AtlasTexture" id="5"]
atlas = ExtResource("4")
region = Rect2(0, 78, 26, 26)

[sub_resource type="AtlasTexture" id="6"]
atlas = ExtResource("4")
region = Rect2(0, 104, 26, 26)

[sub_resource type="AtlasTexture" id="7"]
atlas = ExtResource("4")
region = Rect2(0, 130, 26, 26)

[sub_resource type="SpriteFrames" id="8"]
animations = [{
"frames": [{
"duration": 1.0,
"texture": ExtResource("6_crg6p")
}],
"loop": true,
"name": &"Standing",
"speed": 5.0
}, {
"frames": [{
"duration": 1.0,
"texture": SubResource("2")
}, {
"duration": 1.0,
"texture": SubResource("3")
}, {
"duration": 1.0,
"texture": SubResource("4")
}, {
"duration": 1.0,
"texture": SubResource("5")
}, {
"duration": 1.0,
"texture": SubResource("6")
}, {
"duration": 1.0,
"texture": SubResource("7")
}],
"loop": true,
"name": &"Walking",
"speed": 5.0
}]

[sub_resource type="AtlasTexture" id="10"]
atlas = ExtResource("3")
region = Rect2(0, 0, 26, 26)

[sub_resource type="AtlasTexture" id="11"]
atlas = ExtResource("3")
region = Rect2(0, 26, 26, 26)

[sub_resource type="AtlasTexture" id="12"]
atlas = ExtResource("3")
region = Rect2(0, 52, 26, 26)

[sub_resource type="AtlasTexture" id="13"]
atlas = ExtResource("3")
region = Rect2(0, 78, 26, 26)

[sub_resource type="AtlasTexture" id="14"]
atlas = ExtResource("3")
region = Rect2(0, 104, 26, 26)

[sub_resource type="AtlasTexture" id="15"]
atlas = ExtResource("3")
region = Rect2(0, 130, 26, 26)

[sub_resource type="SpriteFrames" id="16"]
animations = [{
"frames": [{
"duration": 1.0,
"texture": ExtResource("2_equr0")
}],
"loop": true,
"name": &"Standing",
"speed": 5.0
}, {
"frames": [{
"duration": 1.0,
"texture": SubResource("10")
}, {
"duration": 1.0,
"texture": SubResource("11")
}, {
"duration": 1.0,
"texture": SubResource("12")
}, {
"duration": 1.0,
"texture": SubResource("13")
}, {
"duration": 1.0,
"texture": SubResource("14")
}, {
"duration": 1.0,
"texture": SubResource("15")
}],
"loop": true,
"name": &"Walking",
"speed": 5.0
}]

[sub_resource type="AtlasTexture" id="107"]
atlas = ExtResource("19")
region = Rect2(0, 156, 26, 26)

[sub_resource type="SpriteFrames" id="108"]
animations = [{
"frames": [{
"duration": 1.0,
"texture": ExtResource("8_qehbk")
}],
"loop": true,
"name": &"Standing",
"speed": 5.0
}, {
"frames": [{
"duration": 1.0,
"texture": SubResource("107")
}],
"loop": true,
"name": &"Walking",
"speed": 5.0
}]

[sub_resource type="AtlasTexture" id="104"]
atlas = ExtResource("17")
region = Rect2(0, 156, 26, 26)

[sub_resource type="SpriteFrames" id="105"]
animations = [{
"frames": [{
"duration": 1.0,
"texture": ExtResource("4_3ww2s")
}],
"loop": true,
"name": &"Standing",
"speed": 5.0
}, {
"frames": [{
"duration": 1.0,
"texture": SubResource("104")
}],
"loop": true,
"name": &"Walking",
"speed": 5.0
}]

[sub_resource type="AtlasTexture" id="46"]
atlas = ExtResource("9")
region = Rect2(0, 0, 26, 26)

[sub_resource type="AtlasTexture" id="47"]
atlas = ExtResource("9")
region = Rect2(0, 26, 26, 26)

[sub_resource type="AtlasTexture" id="48"]
atlas = ExtResource("9")
region = Rect2(0, 52, 26, 26)

[sub_resource type="AtlasTexture" id="49"]
atlas = ExtResource("9")
region = Rect2(0, 78, 26, 26)

[sub_resource type="AtlasTexture" id="50"]
atlas = ExtResource("9")
region = Rect2(0, 104, 26, 26)

[sub_resource type="AtlasTexture" id="51"]
atlas = ExtResource("9")
region = Rect2(0, 130, 26, 26)

[sub_resource type="AtlasTexture" id="62"]
atlas = ExtResource("11")
region = Rect2(0, 0, 26, 26)

[sub_resource type="AtlasTexture" id="63"]
atlas = ExtResource("11")
region = Rect2(0, 26, 26, 26)

[sub_resource type="AtlasTexture" id="64"]
atlas = ExtResource("11")
region = Rect2(0, 52, 26, 26)

[sub_resource type="AtlasTexture" id="65"]
atlas = ExtResource("11")
region = Rect2(0, 78, 26, 26)

[sub_resource type="AtlasTexture" id="66"]
atlas = ExtResource("11")
region = Rect2(0, 104, 26, 26)

[sub_resource type="AtlasTexture" id="67"]
atlas = ExtResource("11")
region = Rect2(0, 130, 26, 26)

[sub_resource type="AtlasTexture" id="17"]
atlas = ExtResource("2")
region = Rect2(0, 0, 26, 26)

[sub_resource type="AtlasTexture" id="18"]
atlas = ExtResource("2")
region = Rect2(0, 26, 26, 26)

[sub_resource type="AtlasTexture" id="19"]
atlas = ExtResource("2")
region = Rect2(0, 52, 26, 26)

[sub_resource type="AtlasTexture" id="20"]
atlas = ExtResource("2")
region = Rect2(0, 78, 26, 26)

[sub_resource type="AtlasTexture" id="21"]
atlas = ExtResource("2")
region = Rect2(0, 104, 26, 26)

[sub_resource type="AtlasTexture" id="22"]
atlas = ExtResource("2")
region = Rect2(0, 130, 26, 26)

[sub_resource type="AtlasTexture" id="25"]
atlas = ExtResource("6")
region = Rect2(0, 0, 26, 26)

[sub_resource type="AtlasTexture" id="26"]
atlas = ExtResource("6")
region = Rect2(0, 26, 26, 26)

[sub_resource type="AtlasTexture" id="27"]
atlas = ExtResource("6")
region = Rect2(0, 52, 26, 26)

[sub_resource type="AtlasTexture" id="28"]
atlas = ExtResource("6")
region = Rect2(0, 78, 26, 26)

[sub_resource type="AtlasTexture" id="29"]
atlas = ExtResource("6")
region = Rect2(0, 104, 26, 26)

[sub_resource type="AtlasTexture" id="30"]
atlas = ExtResource("6")
region = Rect2(0, 130, 26, 26)

[sub_resource type="AtlasTexture" id="34"]
atlas = ExtResource("7")
region = Rect2(0, 0, 26, 26)

[sub_resource type="AtlasTexture" id="35"]
atlas = ExtResource("7")
region = Rect2(0, 26, 26, 26)

[sub_resource type="AtlasTexture" id="36"]
atlas = ExtResource("7")
region = Rect2(0, 52, 26, 26)

[sub_resource type="AtlasTexture" id="37"]
atlas = ExtResource("7")
region = Rect2(0, 78, 26, 26)

[sub_resource type="AtlasTexture" id="38"]
atlas = ExtResource("7")
region = Rect2(0, 104, 26, 26)

[sub_resource type="AtlasTexture" id="39"]
atlas = ExtResource("7")
region = Rect2(0, 130, 26, 26)

[sub_resource type="AtlasTexture" id="40"]
atlas = ExtResource("8")
region = Rect2(0, 0, 26, 26)

[sub_resource type="AtlasTexture" id="41"]
atlas = ExtResource("8")
region = Rect2(0, 26, 26, 26)

[sub_resource type="AtlasTexture" id="42"]
atlas = ExtResource("8")
region = Rect2(0, 52, 26, 26)

[sub_resource type="AtlasTexture" id="43"]
atlas = ExtResource("8")
region = Rect2(0, 78, 26, 26)

[sub_resource type="AtlasTexture" id="44"]
atlas = ExtResource("8")
region = Rect2(0, 104, 26, 26)

[sub_resource type="AtlasTexture" id="45"]
atlas = ExtResource("8")
region = Rect2(0, 130, 26, 26)

[sub_resource type="AtlasTexture" id="68"]
atlas = ExtResource("15")
region = Rect2(0, 0, 26, 26)

[sub_resource type="AtlasTexture" id="69"]
atlas = ExtResource("15")
region = Rect2(0, 26, 26, 26)

[sub_resource type="AtlasTexture" id="70"]
atlas = ExtResource("15")
region = Rect2(0, 52, 26, 26)

[sub_resource type="AtlasTexture" id="71"]
atlas = ExtResource("15")
region = Rect2(0, 78, 26, 26)

[sub_resource type="AtlasTexture" id="72"]
atlas = ExtResource("15")
region = Rect2(0, 104, 26, 26)

[sub_resource type="AtlasTexture" id="73"]
atlas = ExtResource("15")
region = Rect2(0, 130, 26, 26)

[sub_resource type="AtlasTexture" id="74"]
atlas = ExtResource("14")
region = Rect2(0, 0, 26, 26)

[sub_resource type="AtlasTexture" id="75"]
atlas = ExtResource("14")
region = Rect2(0, 26, 26, 26)

[sub_resource type="AtlasTexture" id="76"]
atlas = ExtResource("14")
region = Rect2(0, 52, 26, 26)

[sub_resource type="AtlasTexture" id="77"]
atlas = ExtResource("14")
region = Rect2(0, 78, 26, 26)

[sub_resource type="AtlasTexture" id="78"]
atlas = ExtResource("14")
region = Rect2(0, 104, 26, 26)

[sub_resource type="AtlasTexture" id="79"]
atlas = ExtResource("14")
region = Rect2(0, 130, 26, 26)

[sub_resource type="AtlasTexture" id="89"]
atlas = ExtResource("16")
region = Rect2(0, 0, 26, 26)

[sub_resource type="AtlasTexture" id="90"]
atlas = ExtResource("16")
region = Rect2(0, 26, 26, 26)

[sub_resource type="AtlasTexture" id="91"]
atlas = ExtResource("16")
region = Rect2(0, 52, 26, 26)

[sub_resource type="AtlasTexture" id="92"]
atlas = ExtResource("16")
region = Rect2(0, 78, 26, 26)

[sub_resource type="AtlasTexture" id="93"]
atlas = ExtResource("16")
region = Rect2(0, 104, 26, 26)

[sub_resource type="AtlasTexture" id="94"]
atlas = ExtResource("16")
region = Rect2(0, 130, 26, 26)

[sub_resource type="AtlasTexture" id="80"]
atlas = ExtResource("13")
region = Rect2(0, 0, 26, 26)

[sub_resource type="AtlasTexture" id="81"]
atlas = ExtResource("13")
region = Rect2(0, 26, 26, 26)

[sub_resource type="AtlasTexture" id="82"]
atlas = ExtResource("13")
region = Rect2(0, 52, 26, 26)

[sub_resource type="AtlasTexture" id="83"]
atlas = ExtResource("13")
region = Rect2(0, 78, 26, 26)

[sub_resource type="AtlasTexture" id="84"]
atlas = ExtResource("13")
region = Rect2(0, 104, 26, 26)

[sub_resource type="AtlasTexture" id="85"]
atlas = ExtResource("13")
region = Rect2(0, 130, 26, 26)

[sub_resource type="SpriteFrames" id="24"]
animations = [{
"frames": [],
"loop": true,
"name": &"Standing",
"speed": 5.0
}, {
"frames": [{
"duration": 1.0,
"texture": ExtResource("11_6jfvk")
}],
"loop": true,
"name": &"StandingAfro",
"speed": 5.0
}, {
"frames": [{
"duration": 1.0,
"texture": ExtResource("12_af3bb")
}],
"loop": true,
"name": &"StandingBeard",
"speed": 5.0
}, {
"frames": [{
"duration": 1.0,
"texture": ExtResource("13_lbtgt")
}],
"loop": true,
"name": &"StandingGlasses",
"speed": 5.0
}, {
"frames": [{
"duration": 1.0,
"texture": ExtResource("14_tl31v")
}],
"loop": true,
"name": &"StandingLong",
"speed": 5.0
}, {
"frames": [{
"duration": 1.0,
"texture": ExtResource("22_hjuqy")
}],
"loop": true,
"name": &"StandingLonger",
"speed": 5.0
}, {
"frames": [{
"duration": 1.0,
"texture": ExtResource("19_pr1qg")
}],
"loop": true,
"name": &"StandingShave",
"speed": 5.0
}, {
"frames": [{
"duration": 1.0,
"texture": ExtResource("15_003c2")
}],
"loop": true,
"name": &"StandingSoftServe",
"speed": 5.0
}, {
"frames": [],
"loop": true,
"name": &"Walking",
"speed": 5.0
}, {
"frames": [{
"duration": 1.0,
"texture": SubResource("46")
}, {
"duration": 1.0,
"texture": SubResource("47")
}, {
"duration": 1.0,
"texture": SubResource("48")
}, {
"duration": 1.0,
"texture": SubResource("49")
}, {
"duration": 1.0,
"texture": SubResource("50")
}, {
"duration": 1.0,
"texture": SubResource("51")
}],
"loop": true,
"name": &"WalkingAfro",
"speed": 5.0
}, {
"frames": [{
"duration": 1.0,
"texture": SubResource("62")
}, {
"duration": 1.0,
"texture": SubResource("63")
}, {
"duration": 1.0,
"texture": SubResource("64")
}, {
"duration": 1.0,
"texture": SubResource("65")
}, {
"duration": 1.0,
"texture": SubResource("66")
}, {
"duration": 1.0,
"texture": SubResource("67")
}],
"loop": true,
"name": &"WalkingBeard",
"speed": 5.0
}, {
"frames": [{
"duration": 1.0,
"texture": SubResource("17")
}, {
"duration": 1.0,
"texture": SubResource("18")
}, {
"duration": 1.0,
"texture": SubResource("19")
}, {
"duration": 1.0,
"texture": SubResource("20")
}, {
"duration": 1.0,
"texture": SubResource("21")
}, {
"duration": 1.0,
"texture": SubResource("22")
}],
"loop": true,
"name": &"WalkingGlasses",
"speed": 5.0
}, {
"frames": [{
"duration": 1.0,
"texture": SubResource("25")
}, {
"duration": 1.0,
"texture": SubResource("26")
}, {
"duration": 1.0,
"texture": SubResource("27")
}, {
"duration": 1.0,
"texture": SubResource("28")
}, {
"duration": 1.0,
"texture": SubResource("29")
}, {
"duration": 1.0,
"texture": SubResource("30")
}],
"loop": true,
"name": &"WalkingHat",
"speed": 5.0
}, {
"frames": [{
"duration": 1.0,
"texture": SubResource("34")
}, {
"duration": 1.0,
"texture": SubResource("35")
}, {
"duration": 1.0,
"texture": SubResource("36")
}, {
"duration": 1.0,
"texture": SubResource("37")
}, {
"duration": 1.0,
"texture": SubResource("38")
}, {
"duration": 1.0,
"texture": SubResource("39")
}],
"loop": true,
"name": &"WalkingLong",
"speed": 5.0
}, {
"frames": [{
"duration": 1.0,
"texture": SubResource("40")
}, {
"duration": 1.0,
"texture": SubResource("41")
}, {
"duration": 1.0,
"texture": SubResource("42")
}, {
"duration": 1.0,
"texture": SubResource("43")
}, {
"duration": 1.0,
"texture": SubResource("44")
}, {
"duration": 1.0,
"texture": SubResource("45")
}],
"loop": true,
"name": &"WalkingMessy",
"speed": 5.0
}, {
"frames": [{
"duration": 1.0,
"texture": SubResource("68")
}, {
"duration": 1.0,
"texture": SubResource("69")
}, {
"duration": 1.0,
"texture": SubResource("70")
}, {
"duration": 1.0,
"texture": SubResource("71")
}, {
"duration": 1.0,
"texture": SubResource("72")
}, {
"duration": 1.0,
"texture": SubResource("73")
}],
"loop": true,
"name": &"WalkingPiqued",
"speed": 5.0
}, {
"frames": [{
"duration": 1.0,
"texture": SubResource("74")
}, {
"duration": 1.0,
"texture": SubResource("75")
}, {
"duration": 1.0,
"texture": SubResource("76")
}, {
"duration": 1.0,
"texture": SubResource("77")
}, {
"duration": 1.0,
"texture": SubResource("78")
}, {
"duration": 1.0,
"texture": SubResource("79")
}],
"loop": true,
"name": &"WalkingSoftServe",
"speed": 5.0
}, {
"frames": [{
"duration": 1.0,
"texture": SubResource("89")
}, {
"duration": 1.0,
"texture": SubResource("90")
}, {
"duration": 1.0,
"texture": SubResource("91")
}, {
"duration": 1.0,
"texture": SubResource("92")
}, {
"duration": 1.0,
"texture": SubResource("93")
}, {
"duration": 1.0,
"texture": SubResource("94")
}],
"loop": true,
"name": &"WalkingStraight",
"speed": 5.0
}, {
"frames": [{
"duration": 1.0,
"texture": SubResource("80")
}, {
"duration": 1.0,
"texture": SubResource("81")
}, {
"duration": 1.0,
"texture": SubResource("82")
}, {
"duration": 1.0,
"texture": SubResource("83")
}, {
"duration": 1.0,
"texture": SubResource("84")
}, {
"duration": 1.0,
"texture": SubResource("85")
}],
"loop": true,
"name": &"WalkingTuft",
"speed": 5.0
}]

[sub_resource type="AtlasTexture" id="54"]
atlas = ExtResource("10")
region = Rect2(0, 0, 26, 26)

[sub_resource type="AtlasTexture" id="55"]
atlas = ExtResource("10")
region = Rect2(0, 26, 26, 26)

[sub_resource type="AtlasTexture" id="56"]
atlas = ExtResource("10")
region = Rect2(0, 52, 26, 26)

[sub_resource type="AtlasTexture" id="57"]
atlas = ExtResource("10")
region = Rect2(0, 78, 26, 26)

[sub_resource type="AtlasTexture" id="58"]
atlas = ExtResource("10")
region = Rect2(0, 104, 26, 26)

[sub_resource type="AtlasTexture" id="59"]
atlas = ExtResource("10")
region = Rect2(0, 130, 26, 26)

[sub_resource type="SpriteFrames" id="60"]
animations = [{
"frames": [{
"duration": 1.0,
"texture": ExtResource("10_yxwdb")
}, {
"duration": 1.0,
"texture": ExtResource("11_2jvk6")
}, {
"duration": 1.0,
"texture": ExtResource("10_7dcqq")
}, {
"duration": 1.0,
"texture": ExtResource("11_l5a22")
}, {
"duration": 1.0,
"texture": ExtResource("12_bowq2")
}, {
"duration": 1.0,
"texture": ExtResource("13_xo6or")
}, {
"duration": 1.0,
"texture": ExtResource("14_3l8ir")
}, {
"duration": 1.0,
"texture": ExtResource("17_2xnp3")
}],
"loop": true,
"name": &"StandingShirt",
"speed": 5.0
}, {
"frames": [{
"duration": 1.0,
"texture": SubResource("54")
}, {
"duration": 1.0,
"texture": SubResource("55")
}, {
"duration": 1.0,
"texture": SubResource("56")
}, {
"duration": 1.0,
"texture": SubResource("57")
}, {
"duration": 1.0,
"texture": SubResource("58")
}, {
"duration": 1.0,
"texture": SubResource("59")
}],
"loop": true,
"name": &"WalkingShirt",
"speed": 5.0
}]

[node name="Rando" type="Node2D"]
use_parent_material = true
script = ExtResource("5")

[node name="body" type="AnimatedSprite2D" parent="."]
z_as_relative = false
use_parent_material = true
position = Vector2(0, -26)
sprite_frames = SubResource("8")
animation = &"Standing"

[node name="lines" type="AnimatedSprite2D" parent="."]
z_as_relative = false
position = Vector2(0, -26)
sprite_frames = SubResource("16")
animation = &"Standing"

[node name="lizard_body" type="AnimatedSprite2D" parent="."]
visible = false
z_as_relative = false
position = Vector2(0, -26)
sprite_frames = SubResource("108")
animation = &"Standing"

[node name="lizard_lines" type="AnimatedSprite2D" parent="."]
visible = false
z_as_relative = false
position = Vector2(0, -26)
sprite_frames = SubResource("105")
animation = &"Standing"

[node name="hair" type="AnimatedSprite2D" parent="."]
z_as_relative = false
position = Vector2(0, -26)
sprite_frames = SubResource("24")
animation = &"StandingLonger"

[node name="clothes" type="AnimatedSprite2D" parent="."]
z_as_relative = false
position = Vector2(0, -26)
sprite_frames = SubResource("60")
animation = &"StandingShirt"

[node name="Sprite2D" type="Sprite2D" parent="."]
visible = false
modulate = Color(1, 1, 1, 0.921569)
z_as_relative = false
scale = Vector2(2, 2)
texture = ExtResource("1")

[node name="bandana" type="Sprite2D" parent="."]
visible = false
z_as_relative = false
position = Vector2(0, -26)
texture = ExtResource("37_osj47")

[node name="NavigationObstacle2D" type="NavigationObstacle2D" parent="."]
position = Vector2(-2, -4)
radius = 10.81
carve_navigation_mesh = true
           GDSCe   t*  (/`t)Z :aBpQkRHhO# >Lq[isd'J@(@J+oaé(e
E  ]J]9\)]Fe%6Dx)5:,^\/+&HhL*I~?c3^EQ$#8@bX?d	?eo9,>G&Hз)creQ4>(D}`h-}Ag4$<"A"DRIPf
3eo)#3symeHnڼicgO763j6@no֌܌Ҽ{JsչO4lm~q$;tνwν{ޛޫF/ʹ<.MoJ:ě$5B}~_9|UWW7W6fo᫘/?]W-?/*~u.{_~WW ~	_7~T_C/;?ԯl$AyL	73[~h%>jHr69RP&mliuc	'0Q\D%
\	AӁ'''өi)=` -*iR2fhGN#%  |MiEYEPd&Y2VkZkZkZkjΤӞZ{y<ӞZkkjj1y~%;!<./8OMD&f_țbo{3țk~ ox-fMǛ:zǛ7oޤfƛ(M&|x?˒%B%A%GƚvF䊴EQE(J#
k
CTH{UG)V<r;(Sv:i1A@;:pŵ@C:;ɮJj&wǜtcFx\NT8!4aB\P"hS{]
=YUTA vh@NiT*+,,,(,(
ŢTQG0j r6&^KUx<w5	ʆ Kӄ+ 1AYJT&!Ķ!M3P M	uЦF P
JBR !=B{`U)U% 
jJN颎@rȨeRS
JRJ (,)QΈH%%e6Ђ BPkm/I㴓InHj|	8m9YFиbeJƘL&	SLg>B͖Ƙ'%"i#$J 2mU!Ih&ԣ9df<t23:EJu/9A	f{J啨nc4ZWd4ރg
0<V&d5vv74^M7Uu:7l@
>~fzH
l8Hnk Ms	_-Df9&Ny}tCͽ9hnFcob
_.%n0IzP;Y
#E6mFֻuw^Ka
2Csgi?sk b' w
ґOqMqC,'8'ȩ`87'(,˦-oӖ)+jK$aeieI	}:F:-El鲧`Lǉ3U1ʦ1jJ+3'^sLlBg4&Σ!mH8m>zKI~	f UFi4(AEG^kϳ#a8TK+-Ѷ#˽7:`siΜp4\F]cFr
DF=Ahѹtv[州vാ4ubZ- .wvcd?Vno+t]Xb?ݬQXA('E|74n~af>ktΣNpE7ky5˼x͚e^f2/^tf/Y̋ݬYŋn,9e>
y/bp+. ,?!Bq}qz'*n&8M+`r q!j?.hD)
|S#'}ҹ!wlE~,WYnɋLOTymq~OLT;߇bOTeQj2б
~`7{L8>/EۀH5ўٜ1(dp	7N&<sOKXdl%zb̧c"{j6,@:k:?_酲OY`ܷV/'.Lp!C?FO91wonXCy{VC>pOe3|Wn}]&+ƣxX鍞qt_9C<OL.
w<>oC~e_x[_n
ĂOd?匡OsL92zww~'8E=#&@6z=pǴ
^?wmdYif3
{
?}Ϧ<C$lؤ]!'";_tjm[10̿{X뽉L9ny|;OOz?"w_˅[n5'D2Q\{?{'j9	^          GDSCe      (/ Е rk:x:]UUUUwwd˕RT"ATK6'\)or3S*B  2pvfdc[nU*O         RSRC                    AudioStreamWAV                                                              resource_local_to_scene    resource_name    data    format 
   loop_mode    loop_begin 	   loop_end 	   mix_rate    stereo    tags    script           local://AudioStreamWAV_i80ce 8         AudioStreamWAV          xX                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         # W   7%fu~ #~1 551t3a=&K  IJ2hjT# vY>Mg!Mroq8UP dLxq SPa
 p   '+ #]tz^2?.Btl& NPeb0	~*	* 26'=6~ cl  C n WK  (6 m1RO@|(q ];YMRb,a $!  GZ  C4  8    } j  1wgHdo6l$   Y[M^O
2x	
h77	XdN#8([+,+{+*(('A$ xSuvv%C2n	1)+1ZAtMY;*~*m
nү̴ˏLYXº˷q̬ͪm\ϻñ6&'/4@6.9J=@3BCFJK/IRE)A:~1C'
,o٧_-޲^w4pI%/=O(|:u#'+/368:<?NACCDDDCvA>;8Q5z1;-("&	 ,!qwiX Z
cwC"%|(*c,-,+)?'$"G#!
-
$-3:&ENaQNMGhFHmIBl8343"-'~#Y#vJbۯՁeȯ\xiWq\vH7	
a`
XSG" Qei'6&"k?cOHx4λ4I#ǍĵŢ/ƣȽ]M_DזLq7IKԱѻQ
M/7ЪI7eEop:=rK0m"7""%4&&-&%n"s%mbBff,N-[,M4~ G
2$xz}R!"}$'
+-//01q2E33
3R2c1/n.-Z+(%" !{E	@  		8l2w:Z !"I!  L?J_%<*-2.9=f>;9:d=S=967E887640+'!h _ o,?
^B#
7kz	r[D7	".vf N<%)ly,߇Cި;ްPvqfn)M3l.W6+߭UԪc6;59z7ƔM\}Xo&	uvU/f̤=o.$),W/Z258<&B?GJlLLIA8/%HCϣz!$MBs %)'+++e*(%"|1'Z $.(g+.147$9G:;B>@EBuC3EGGGFE~C@>:61r,g&,
bXZc
u
yU#(,/f246542M0]-)F&"k[q!$'o*,.22&689:;:9-9	70)$b \)1
?	yMWwS

Yb;$9jUX(x)$
YaH_TEB	W߅q{Lҿx?#lĶ3̱HDRZL"򦹨e驋sܦܤѤģ @jԛ,KJ޵þ7=!o&W*,/p4!9=TC{ILKHHD<24(f	W"'PΩ{jͳGM_/$)-021f0-+o)'Y$?"&! "$2')O,/2579;P>
ACEGHIJmIdHG8EB'@7=9L5/&)!	Q8cg$+.u!'O,X15:<>>'><:H73e0,(f$

U_

|

e

} #$Q" MqYZdAy}BRr\1d	m& cFf @ ENW]>lMjU9{5fYhA
6PmEjړHصhdG^Qg򧟩竸i!c<bݸ Ѷų-p񛑘4W$piq!P&(*
.16P:s=eAEGwFAa9.7#
+S@5յ@QP\2Åɳf֘k=		$w*q047f9862/ -)%D"k ! #w%7(+/94
9=0APCD)F8HJlLMNPQ}SSRPLIE@^:2<+Z#qK8{U~H LC7#(-28>$BDFG)GDbAD=8f3.	)$ X.X<
	t	R	Y			u		b	

^
x=
`m(6
}D #^$~$%)-,,d-03H3&33w2p/,L*&#<!{w
;X'}[2 k&# }RMg*8<|.HÍԻVXz|o}0ҹ/fֹEȳ߳n?ʯwŪۦfͩ|8 uvܿ4Q@> _ 4!G#V&'%H#|,[ /xު,'9 4Z^n $(,0u355E54210.~-)-j-y.03#6
8:=@5AAAAXBBCBAlA@@j>;85;3}0b-0*'# 
T
N
fj "$&'()@+;-X/\1&3`4475431.+(x%C"HRi;
b		+	h	Q	b-}gTlp,J\E	
.Nb !"&+.,=+-]0e1011`1/@/-?*%l"V_	5HU  L *WMx`	R	@Ek;;iW7vi"11g	ܕ<EҔU̔xŋ )aL;D%>(ZBlŲ1j_4AoLR/Y+Ơpr2ըͪNGrsҹ76=o
'U !#<%%$"u8Ikgp	Q="&R+/$3.5677n7L7V7651515567@9:<>ABCDDEEUFF`EED3DB@><i96317.+'$$!9LVg

i2"$&2()+-/1c34K55r5H4N2/m-*'$
"eb'0v
e
]	ih}4h6
&D8R&4	-@
ApH#(n-034[6x764D321`0{/-J+(L% Ce\

2^#oEGY					J	0		*

\J
{	
$] s NzEc*ʝȡĈM˷yE?'wֱb*̬H9®aX1FFߞ?LI뫇,uַ4t'3$&'n'P'k&%$&()Y'k$!W	a5"ޙ0
\xy{"&*-=035n778876?532272X23^6Q95<1?8BEyGHIJJJPJRIdHGRFTDA?%=:63/,)>%!L
X

 j#&j(|*7,->/0T2345f665n42<0-p)%!5JLevT
R d j)($ &-5;n?ACFQH4H@GFE`Cd@<G82w,s& #
"?p# cr	Y
=
LK	&fW
3\]vD\}Budɠ`ͽټIs<ԿNc޿強%̵B˲rޮt}30z8DיGϘKŝYnͤICuLĳ.̻ҝI{>  @"P# $G%'*,,{*M& 	
IIETތ`ZcnnZ7!e'N-27;=h?@@?>=<;%:8D8d889:s<E>?@*AtA\A@@@@@"ArAABA@H?=;9#6,30,)@%.!	#5`
Z
= "%6'),.03t4"5_54)30-*W'#L Y:42
[
). t  ZQ U}%kb

.	,l (/6:<>%AB{BAA2ByA:@
?=95)09*#
OnJM[0OOO		T2AlEdK0e^)o@|=o4K.j@ۇcOՆӸѯ!"M˹sZ_ػ~󺚺!pDBFp7bYj,icJϧ@ͳ_$zn֨H/=H%)++D+++**2,./A/:-u)#_&2KxY`ڞ^֢ةRC"W 

=~$"(-_2z69;<'=w=p=<t;:3:j:3;s<>?RBEGIiK0L_LeL7LKJZIKHTGFE&DA?=:7z41@-\)%!C(			Zj!\$&E($*,./247
9:V;:97
51u.*'#D	J29~5ENBU P  J  
Hj5(&+H c
J")06/;`>ACDRFGGECB=@;P72^-9'!	Gn&np;5@\W*4 <*
Q
J7;4?
v\]}\PW}	cK(eةXmθpGwXX] 5£,ļa͵f>Gh[\NĠ	]	IʩխL5WAٯ7ˤYyf H~N!5!vL,F:G'e B$
}!$&((('&%4%%'{)+.275A8:_<`=!>>>?>V>==>=<==<=u=e=<;:8*630-h)%"!8f'>YbF]L?!#%!'':'p&8%#! s$IW_B0
9
6Xyo(YgF{(Hg\,!'r,'163:::F; <;]:r8464q31F.+' #Uh `Y]e

.#	G&FU%Ui2
 L,Ge n(wB\kTdZӐ)#̴ʠɞǹňJ}&O6浾ĳݭmR!QӞǛ՚ɚÚÚWϛ3fQQȠ§ȫlIi'$)*+z-/0$234
78862-&X>AT-5iֽ`A`m:	j
"(1-1558h9N9s87R5431//H01135B8_:o<>;ABXDE[GHHGeG/GFEDdCBX@>3;73/+7&:!;G
Z	%.?

Ri-!U$&)v-035[78A9]86p5y30-*&"pZm
2	;	k/*_`1j* ^Dw #l	D/L$-5;@NFCKYM$NNnNLHEA<+71+"%XG(</,Gh*Ek, (u *#H>Zc".6+;74>܍֜^&̖Ȕu|ģbWĽp\0TX ӱjik%ת>v&=§z9ʩJ+m*@ƦMPʷa
!G%m(.+-B0!3/5542.E)#&dD+rs^::j5 z	  &+/h36678875&30.4-5,+u++,./1Y395o79W<>T@ABCDDEEEEEEECA7?<}8o4/*=%a

[5	c
zG!$'*E-/2344d4s32%0-*R'#\ fB

	
	[/U;(R 	'>#C;Okr 	
&-5<<?u?>?A4@I;7X8D8521-("rMR)!:&	
uoZc;J
	 =xEJk)L"|:RQOrxלUΐb0Ŝć\ĜöPuH'6q{޵yJ:NتdըϨ`KӬ鬄b~٩Ϫ忇| N1	LV!n$O(+4.[1466461,%4_$XBޥ&7ݩTPR:2
K8L#(-s268:O:y97631|0/..,//0
123O457V9:[<=5?@@OA BBBBBB'B@P?<9?6G2-A)[$gFj	wt]	

O #4'E*,M/o12333210-$+($ 3J/
e
	:YzOV!g*7	d 3PC6!&)+x-..-,*=*7)Q('&j%#h!q	r
lTKd#+{
 {



c
	n<'1 0r3ayt0P}&RiձN#Ihm9~`3rXgʷKг+Hȯͮ۬ݫjxӫY|H;
qcذ:ޭ1&QnRHqD
Z $S'*+-/Z110R-*% ;75gy	x6Nh?~
"$!&*X-70256C65532<1G0/L/L//
0012+45795<G><@,BCDLEEEFEDCBbAB?<:63.*&.!H7!
l;	
Ff" E#&(*,.%0$111-1R0.-*_(%O"3lf
e	W=f\7J<?K\


b!":$?'m*++*+-^.-,,*'b$ Z[,RUm
@	>"
X;3e\L
Hz	. |q=,#>
#!:3Z"oV`81ߟ>֦ і;ψ̀#LÃL%`ٷHi!m>7Bhɳ˴^u`1s۴ʹóޱ\u$u߭ͭ/rҭ
ְ[r˩ַRG
t<"}$&)+-/&00L0-k*R&h!t
!Z(Z)XpE
'3"%)-03`67765m420/..T.t. //023#68d;(>@CDEFFFE<EDCB#A?><962/*% KpU
g]0|
jcb"$D')+-.Y0U11110/-:+>($!	4t	nM5 AFwA-X@:!H'-0110121-+h++*)(&s#
2 mgt$G
I

,wNm)IU5DRVKgw-*nW4`*}3m'ӹѣWϝʖ@7j­3*rZ⹺f1D0'DgfI}ӬR47w~ӫPĭ'pY8Gxo4Uj wyP i"$%')))%*B*`)'#; P
iY1o
iVy(	
.!%(,04689:2:9765454}444755678P:<>$@A;C:DDAEEDC%CVBOA)@>=;98741f.J*%!
.K
%|&Jd "$&y(O*+7-..//=/d.a-+*'8%"Voy|
+
T	&?b|X	
!
!##r%;'(O'&%
&%u$C#a"! `2f{	2yR-Z		
6W@

!+&o
Pv) DsyljRa
H[*rQ& 7;hLٙEԍҰ
0RxǛpzѼMV׷3k83
'U@Ĭǭe`ۭE}O:e#b
͘ҶGyE6OZ !""""= 
]7
	@Dx bz oa3*
e1 #&),/25t79y;m<<<D<;:9V98888D9:{:;;<=y>Q?@@XAA0BlB-BAA`@?Q><g;9863g1.+(X%
">
+XwP!",$%&'(_))))))a(='%$W"2 {'
z	0Ih.<V$&Z&$#$%$""Q#$=$($t#"w B

<>)|

/`d55,Jt<	tYF cvC;
%@].C
b0wgg(lه׆ԕxHO*ƸQX(2ڷN'¯HdwҩΩ0񪾫a
𯩰*0̳8bdŷ̹e~ŏǿɨY@Ϧ;C[s{YrL^-A '
z
VzdVJQ?\5]aW' !a#$&(c)*,.02+457:;i<=>??(@!@?|??>>>>=J=.=</<Z;:;:99[988j76!6W5q4321j10/
/-,+*)(&|%I$2#C"1! "v*r
Jv  P( x"D%2),$/0355]4
2/.c-)%}"o	90t G> ?	sP<6q.gB*t(
h,Urjp2WZMK!?D/t=[nL{#O,σP͒eWȿƂŝnyc̹&s.¯tz?ۧf7ԫG:?µ طYJǻ˽| bŉ)ǠMo=^;\ۆܟݖް `C[ 	(&${hZ !H""#O$G$#]#:#0#)#>###$% ''("))4*^+,p-\./|1C34t67.9f:;<=> ??@AgBMBAAXA@+@b?> >=p=m=p=H=<<n<<C;x:98o8I8D8"877~7h77|65433O210~/.--H,6+?*)),)((i(('0'&i&%*%z$$#<#"G"w""5#S#d#l#W##"! A Q<O6"(y%cl.

	^ < In!n/   K[ X l}8gM޷)ݠ-ܱ*qڒ1؂MՙտԏiGKG1ХΌ̋c2º̿־K¼Hg7굪2ܶk &޵QC_PK/񾉿-F7Ƥ4˘ήϟЃuӈP~`Zm"LUK\3 "i"X"C"u"|"! .#b=c!#e%
' ){+-/_2468:<=>)??u@A"A@U@X@t@@e?>>>{>M>>W?@@AWBBCDDCCCC[DyDCUCYCNCB5A??>="<:886Z42"1//-+{*t)(v'&&0&%w%%<%$$	$\$$$%7&''('H'&g&%Q$#! pwH-pRj%'aUx
	PdwK 	Er	 mB$Wx-bM/C*ޖ0i܈acܫvJ%_-?0}
ZͺcD1)Ķfþ2(ڻ/غxQ˺׺
cƻu(x$+F	ϹY͹ҺgŽt-n)Mŕ}Ƶ?ʕˇ#!ϑbѨ4TӇlAE k,	

>"$C%Y&'A((()('&%Z%B$" /hPE !e#$L&')+-/E1	3M579;5=>>}?@@e@??F@@W@?>k>W>=<t<<U==>?@mAABCDdFGHIIKRKJ:ILHGnGnFCD\A>I=;9Z754220.,;+9*)'&&'6''(*P+V,-i-----l...(.;.. /(.+m)'5'&# 2\uo$@A=
5
J

h
	FxBw 7 . c O JUx~
W-y\M7^ٶkؚjLwآؗ+؛׆ענ9/Ջ&iрqϱ{OiØu{
g
ŽƽMپ@ƞʱI$o؋!ڷ^|ۨ}դ͆˅ĕ/๎ŷDBtro̞
~ϾMӇWՔա%sܦ9mo
 $s-4R! [
O{po9h_fU !e#&(o*_,.K13
56V7N7789&::::8:;;;<>A<CErH(KMORU~V*W
WV<VUScQUO.NLIFNC@=M9~5o2/0-*&#!S ,;^S(DI!#$&g'()**\+X,-(....//o.-9,+)u'$"M!2 K)$7E3h<*;
H
CS
P	  {uB2|e|4[pc:Dgd+x_@,UZVz{ޤ,J|'F05T<ϕO2N˯^Ⱥ	@eTe̂̾Ͱ2Εϰ5ё-҆ӷӴx@(Lݭ"]2Mm״0u,҈{uZ]G͑!Γ?Ԭ֩eݲߘ`2ekm0`tIX67
 v
5x9U`9K6-m09fe!"#!%&')*+,k,q,[,2,+*[*)$)e(''_&}%$
$#U#"x""#$%&')*4,-.|/012j333333=3h2m10/D/.-p-,,$,+*?*)))(n(Y(O(V(W(:(''''&&g%$$T#"! Z?<:+_/1RjAG'6%
G
	"e07SBte(FQie_YLnB<ClޮZ܎kaS%ەY	ۉ+xQץ_n;6*
ըՕՅztՁՏՍՇոlփ֗P׈
ؕBلټd&۰9܅ܘ݇Vݜ0߶Ol[s7:T^+.V:  =	
\
Z\2,1.P(P.5/Q  !g"v#g$$M%J&<''C(((\))j**+a++,_,,	-,,---.+.N..@//h0000u111n1R1H1D1)10@0/N/.n.--G,+*C*)('g'&7&%$$,$###o#A#-##"K"!!&! & e@"=>=M^	W


G	lMHW AS]L(}I	!Y?B?C!t*Ioޞ"ۃ
ڇ	٪Nl(֋uO'S|֥U~ׁuT97֦uE<Ognֆ֑֙֊ր֎ָLז2{^٧SVIu2@ܝ3=޴sp<AH}dpKA`BFE'2Ywv3 Z  Cwg?V#y.		
V
&#F:-^0; (H"K .!""#$$%X%%%%0&&&&"'S'U'i''g'I'n''Y'#'+'C'%'&&&&Z&&%%%%	&%%%%Q%+%	%$a$!$######p#W##"&"!! p Q  LO^UXWJ.4a


\	XT\8\qhy ~ &\]+|`uMb[[E'&U?u]"F:*&n=nxjf !7Kg}}fF1&HsN`Ct*Q:]E(btB?h368PcB5/c].GrP'+DZ|/:_=   oL%4uG		7


CM0

+~*z5?V0-pp=(i0tGOhq-:jn-6'/BB=06YUvnS7`%T9
%jA<=T

K
yi
F
		O	hpE)i-  " do
mZ@{<w(3Iqp.BRd/tanvpyk`KAC7Ux|vI,GsoY;d
[#7@EB?+GU*407B*`[7BIK~f  8B;2Ib/~Aq&XkIJ\AS		R
GB
Y
o




nX~|(HdV&$p9osG;	iT8)]0kks_XI

'
s0"



		U		 	qsX3D<+:ka6?   ? gRXG3hVW/I*MF7N[d*_hvU+B=yR|X>4Y|}fkvyiR>@KNANZ0%V]a+mHD%]<9I~0U@+XQ2Y@|C<     - i  pP?q-3"b 8g$6h	M	v											
)


3
Y




	'BA



2
	
+
o

!






W
]





f
[
=
			T		"	o|e?#Q0'H=kDHF~{H_ &J      Z % ~QNL($n6hptGDDV}sj^]I*N
s^* i79*#uqur_; .b8.w2;4<a{u}~W =n[~( C ; < H L W s      1ZN>A;m#4w(z^r=^5O}c9xQ%u4~HY$/?VcaH]!Oxt=-7(     a S V H "   
 \         
      RSRC     [remap]

importer="wav"
type="AudioStreamWAV"
uid="uid://cettblhfgwn2w"
path="res://.godot/imported/a.wav-8810b76d702576f68c8dbed8b22dd97d.sample"
             RSRC                    AudioStreamWAV                                                              resource_local_to_scene    resource_name    data    format 
   loop_mode    loop_begin 	   loop_end 	   mix_rate    stereo    tags    script           local://AudioStreamWAV_h6ftv 8         AudioStreamWAV          a                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      }tlfa\RJB?;2(	|wpjkkh\XY^^^^_fifdbgkonov}0;M_jw 
 ( G a o      9_:[y <[|"<Nd0G]l~%0BPdvr[J>-{^AY5lDlC|X/  N # }>w0\Y0dGGIf%z:wA^#~@XY'q2v7I}V+ qd^J4) %!"9Wq2rYZgD9>Z}rv2C mTA-		

}rdQ@% i!@"##$[%&&y'((`))~*+++m,,4---.W.....////	/...`.#.--6-,_,+x+*v*)J)((O'&%%G$v#"! nL 
b'	z=s/`LHCi:ߔޜݶ8nإ!lռmCҵ-ѭ-мMΈ'z/̭sB˝}leO?69<=;JTg|˚˷1j̨8{"·TNoҗzwՃ֒נثٺޛtM/Y7-t"J9 `Oi	YuO/Rn !&#{$%('()@+,-/!0)1223Z445#667788999[::
;S;;;;;{;N;;:e::9t9"98{80877/76Q65S544=3f210/.-,++:*c)('&&%$$#+"%! Rz\Uf

z	19v Z3>q R2\,RVe5qEy^dD+Kp&\#:01`Dn\ajA#Kw;m+BSXXbkkbaggbkt|
(@Vi~1Z"\$i{#zV#yx4_<  mZ^e|	.

c

>o,$oCz(35'a  9!!!*"""#^###/$g$$$$#%J%j%r%z%%%%%%%%%%%%l%R%;%*%%$$$$Q$$##u#B##"e""!w!(! S E#(lg"lkW3uv/l
9
+
e	JD~'H q9k'O+Hi<`EF@W$N@߱ތ
ݠ:Ju q٩G׬Y ׯ`Ձ?ԕ`-өwD!ҞҍҌҘҥұҾ
-UӄӹVԓR՜6֔}`kڶcܦc4
ߒ`C$0W}Dw&o	P Dq9


neJ.d!M"o#$%&'()*l+L, --./@001`233444I55%666)7p77778)8487848&887777B776q665G54c43V323210c0/.G.-,,V+*)('' &/%7$A#L"Z!m %=PXTVTPA 
	Bat 0Hj#];BO[%w#O=>1.t#F	gG$ߟ~od\PA=Rbs}ߑ߶"8Wp=[.`%>Xu)Up8Vr	,FmR_;Z=6m\m4UNUsS2 [)Q	u
Q*

T"j/Lp'P^ 9!!U""O##+$$$O%%&O&&&K'''%(Z(((()%)7)9)?)<)0)&))	)((((w(K("(''r'2'&&*&%a%$$$##"!! w aFowwfMKAJ
6
N
	O
n1j7 ziS`Pbs;*w'En(;OX$e8nAtAxP2hM#zH}Z;fD"_8|dF-[6V/~nUD7- 
#Cl
Qcj'}
-z%Cr;vLtW@+  	
y
oaK7 \6i5t#  v!""V##{$%%&&'''X(()e)))4*g****+3+?+H+J+L+G+;+++++***i*;**)q)*)((?('''&D&%h%$x$###w"!P! # A9a4%qO8`
<
	
	O3q& @  r]dl2UV0{jbo!8w<MQ"h8|Y.oV6 xlcUC5$jXI6&{m^NA)2Px:m-sW]!|kak!`]o(L"k@  dG"	k
L 
|MzCBea
En    !w!!W""$#z##-$|$$%F%|%%%#&L&p&&&&&&&&&&&&&&&a&4&&%%`%#%$$H$##H#"""!?! U QH:G
lv%sM-v	U
7
	%	r w,b( e G-'$>x\g%h/d?oK%}]E'
wiXF5'
zcVH;-rbXJ5z]@!qH!oM$d?hB&	zaM9'	%Ii(YaY%WBESW@i!r;pG  gAs	L
#
y@h-u(@6|Jihc  O!! """:###,$r$$$,%`%%%%&&&;&N&\&j&j&f&d&\&P&:&#&&%%%b%*%$$q$($##'#"f"!!&! A J@/}Ugk%{&|`T
X
J
	@[Q o ]LNZs-U:Ih%k0]2`3bI)
zaI4"xh\OF7.$
 ztpfZTOID=5&
w`F3!
lR2|Z9vY?$~l`[]]cfhw6dJAm!I!z,KuRT[
p%  Gv'X{	+

Y

w#4&n4O`ggZ,\i
Z W    !<![!s!!!!!!!!!!!!!a!C!!   Y  `ocE}/<LP`ZT0b:|
Y@
)
	
	zwz= a "Kq:xbR^B|>OR"}QZ.xO%cF.teRH<&}smi]YTWVONJJGBC@CCA@DHHFPRQJ=8<<5, "

#$)-9CEPX`hlu'=Pj+\)aX*r N&y%}3c-|[NLO\t %Kd,Dc		l




-2=45'xN2,|?x)W}
'?Wfvzk]E0W+f0r+Rv*}'waIQT%
Y
(T


	K	z
?j+VI} N 3mZDG9=>2BFeA;Qk1nFZ+c>vbH0|raUKB1($	*8GUgs~)H^w#JlEqWPh><<T{ChO@7*"($  49?@JPYbg		r

myu

pgN?+g2:B(m.d=c3LZjxt^L8 g9qB{GEr-IGUQD=,
s

\W
P
		=	!_/e>z[= } " a	TVUY^
fqw,2`=p,zEk9	o=	tCc>mN-}dVG2s_XSMB562/35ACMT[dr2Je#KmAm&UH
O(s 0p;99m$! ;w aFc1
&Yi	Jk   T  !";# #P"!^!r!!4"x! + !!U!  !0!  3  T    + I:R*='vQ
i

E


xW
f
	s	k. x%vK=3	I


%t2h	^8UsWdH-7'\
	w!^ Yk88~7sUV`' 
ٹهآ[ףGi[ӣӶ>ӛoҏa
	љϲAɐ{"ȼǮƒo!`ǇǁVcŀŘŶŉ*Sä߿|FZx(𽍾#.kĜ5ȥ}DϘ8{ـ+%]=|?vpnz&
9||!"$E'+*,,,-.90h1W2n34@6:7x77@6!531f0P/l.L-#,+@,-.///S/~.-+4)J(((''''j'l&%[$U$\$##*"!R! = B"#%&'&&.'''_''j()S+,-.W0D1[100/0//00111W1#1=1r1y1r11622232N2345E433320.-./012B4%5	54 433_20
0/#000.----j+*)1'&%%%$"!& (!${tA8L6C~

Fj	M#/1  I?<$I?=<,߄7ԷҟеϳZ< :XFKսBkG:󲅱mM. )~\3TU8(L6g=Zwŏ# ؒ:a7ݗ7+vա2HLbοć(Bt)V"%V*?.1468e9:::::9:c<M>f???&@{ABHCjBAf@@RAA%A?=<:69m7%51f-)F&#zxhJY\X~<aqB#a$*a@uRgS!
$&(*-0S3\68:=_?AHCDnDRDCB@o>;:877y66E531/-#,*)(((k(w'%r$"~!;$.i	0?PyZ#n'
%
~
6a0az8"###$'+e..S. -,*m)'T%!H

[wz"HN1oVmiՒ΃APҗ\ѝѶmѴsύ?*_J/Υ]'̻ʓ_ǐB	$ȳƐƠ+ƥºY1Ex@oĮ4\О昋}&Α=%46]:uPgP
= SƐͣM
R>"K&(+.012^456'766L7Z8
9=86
678*:q::n:;=k=<:8$7531 /+($ bFp

B~A	6T"nW!$&),b/1J46*:E=|@_CFHwKNRPQeSTVXZ\]]]]\ZYSWUS7QN$LIGHEBr@G><:8J631/{,)
'$"" y	' vl }a$th L"$c'{)*y,I.0113(32g3%5776+66!8[999W999K9~876)3/z-3+'X#>yt5U	0 'cow%Jc{ThݗlהֶH2pUl%ؼrv_قpRdץ׽؝׶~pz7ҟ̊CSǥyOμpm{1
/
112@67sהmBS<KӚm(טWBZk
(#M(,0V4689:A;:976w78875H6M899r9c9:<>>3>=;:751-o(#	a1 )0.V )

@yRH6J!K%(l,/T37G:!=?zB EVGILdOQfTWVZ_\]\^^^^6\ZWV7TRO3MJHFUDA
?==;B974|2/	-*)'$ +;  r&9T~de<0#"K&)],._/0c1	2z23374k43335O888D779W:964e3/320- *&,$D"
t1
y
)
c[T(9ݞ~(m;bc؉غ;}ٝ5)޼gM4r}/ctݯ=ؤ&'%9ʖǟ M?߻8GpʨLV㛪aה2މ℺Ą2bm
ˋN$cBVVhKjZcsm>"
/M[-$(@-1c58:;;F;:9r8789B:89"889:9:799!:@<===p;98163R/)[$7	R rPW	Q \
y|
8
u65CWf$X ["$'+-/$369<?BELH-JK1NPS8VY \]2__u_^\-ZVQT)ROAMJGEvB?<9631/-+(&-$! q	\m.E}mGt%Jaw? fX
{[!%5+/2w579;<==#>3>=<4<<==<4;::9876Z6w653,1).z+%)1'%
#u}	~O>"HoDݻ@ޘs~kR0bޮߗ)+ߨ&vޠkoYQђ'̒ɭƽJy#>٤ݡ/ו^"g剐	ur׃5݄AietQŋfߏ=)Ӟ.^¾l'|a %*/3u7:=C>>>>:><~;<o>j>{<:;>_?>=4=@>?@?5=;85D30,2'!EMx
at i'dmwA_G	`xGA(!g &#&`*-1f5<9<
@B)EGGJ%LMOQSHVYU[\]]^]\ZY^VSQONMpJG5EB?<963u1.`,)9'$!XD, 4	{Sk0 d"
bU >R#J'k)*;++,U,,5.n147A;U>@LBCD
DBDA.AAAABCrB@>V=0;8
51</-+'e$-!iO+I	2 UB%ZZ|hfD8)ߐߝ{ߑ&O*gaN#8h$ۿڹd/ڿtr,@Foymgq]X%8 ̋Q\UDxyЃ熎r rֈn?bWEUE%/Ӳ75-Nd$* 0548;|>@A?>=z=<:.:;=u<9P88:97065y6n7*75c3:1#/E-;+ (#d<G
l.O13Q`k8	Xo "K%F')+.E25=9 =ADG	J5LNPURlST*VYXZ%]^^B^{]\ZW@T@Q+O@MJGDAp>:62z/,)&9$"/fa
 iN @chDMJPIgZ2` ZQ
U#$V),-/2B6899<O@DGI2KL;MMeMK,JGDTA:>==O><!8432/n*$!H! 8D
OryECrd08]hOX@߸  p߰69
[߅ߑ1މ=[ HփԹе&3HŵưW-?AX.2h;,}ԇEBĈ&يԊHʎEҗYe*eAc Dپ_jU" $u'!+./3	8@<-?v@[AfBPB AG@?>=;<>?=;:;<;o9776p653`16.+)
';#XT I!DkU
> i	$'!K#$4&Q(*'-T/147:>BSF2IKMO6RST.UUVWvYwZUZGYWVUS9PLIGEC @<96/3/g,)&$w!4KI
@ 5M	sYp_Si|	j%"*,.1k21`/@-X-T/1357+9:<=V>>4><;9;=><909:::61-
+^*n(-%!j}B^v!:Sfw	4*awy<,O&߸9-ޢbRc8-wg8Էԕԛӱt%ȀƟüѶ224ϩƥԢd*]Î+
戧5ϋI2f3,x sYș"*4߼¤	ף50  g"9$?&b*/+46a8f:N<]=F=<:9T:9888985L32'4j43J1//01d/,)n'&$!x@wf aie7,{Adw#oCN
_gTHl "$&'(J*a,.0247[:;=c@CFqIK9MNP0QQ1R<RRSqUV)USiReQO2MIFDB?<9Z63/,)'$"y % Z@y

	 S@-VS;.`)O B'_,./00121d1p356D88899:9754T664_2/23H4)2E/-,+)&#"~!!
 [ d$B4:XP7_
g/B"4)R"i v)߷gݩۯو'ӌѝʀOSɽx+ieM᣸YLP֔y[I֌fCH.y?
!)kLY˞Ң3PcliѹѽzsŇ8t-QU

!t$%'L*.25789m:98A642/1j0011R0R.-/E/-+*)J)*<*)(%^$#["i*0
2
z G   PX h	C
p'!"=%'*,T---[./p1g346|8;>BDiF\G>HcIJKLLL,MINOQPNMKaJHE[B?w=:;9641-*'v%#!W:C
0
	i$aGm 7>f >i{	
n;C~4!&^*B-./'00/7-+++	-.j13u4u444C42\0.,+,-K-+)V('<&+#
I

ES }5RoO9}a-jVO+%}x4j9(H3CݔjݥL؏aӡѸm%˃ɠ0Ⱦǳ {hҹ 1Э۪إɠ۞ ܗ|ז>'eҖf5Uƚf<ˡܢŧ,Cͱ'dzM*+7!%;*-/0d012(2d0.O-f,+,o-m.-n+*,//t.,,,,- .-+K)'''%{!T/	K a q"r*A;' u!!#$%%%%&(q*+-9.0c3]7:<$>I?@BDDDoE7FG{IJK6JH"GFDfB?#=;m975i30A.+)'%$I" D"w_FU

S	R#I7 LD Dkk	
.N@7e!$ 'E)+,d,*5)Z)}+-/X1235a6{6}5S43v1/--N..-+*l+K+(:$;|/)Z)_5p$ H`:$P\^[/qf],Z"8Lޕgص$T XMЕε̗cȡƈūĸÓ0¿51r.PvN9ʟB:-9Nz4ؘGA`M6E?韌=*2ī[7zU׼)>/5
D,{#&),-5///!/...-?-3.z/E/%-H++S./.5-5-.B00/L.,++O*l(	%*!gz
z	fd  Q/.	E
1 3xaO$    !@#$<&'(*F-v03689:=}?MABB\BCEHHHFFF-F)E*C=A?n><:\85!30?.,0+)(&'$"! jZp
Y
T	eS  4plY	7Z
C!9""""V#($+%%&\().++-.0/.,p-..F-+d++>,+z)>'N%w#! !.
}+
UHH'Rs)~QiT0{,O\u
d;xۈYٯ؍Սj|M͝!8frûUH%y{0sզ쥱?1ȡp@¡Y%Q.	v~t9Φ2X-@稘,yԲkFK7Ǩ֡-=;
Bm l$&'('H'''&$&$%()'&R(+--++c-..?.-Q-,/,r+)'$!H4 DT

!
 Th

9zQi{ !r!!"7#9#'##$&()	+-h146779:c<6=p==?ACC;CbB~A@?&>e<:98=753j20J/`-+*"*9)'%$P$ $m#" i@$
8
r%W	O	g"$&'-)*+,T+U*)V))(8(''''('0'%${#"#A#K# #"""!y 4%U,
	O=|@#*:_gZQPWI?u*+
Y3<+]1pN:XԮOҴ"1̺$7V {-8n{{B:s2
Nl6ᮻʮ֮Ǯ=)tױϲ,@B+ö,Cк:Y8mҐ0
0|a3	l-X7M	""""$%W'()++4+**)(&# >@1T-vt)9+%DR "S$x%%%I%W%%<&#&%$\$$X%&}''h(F*,	/0//./1/22L334666543?3=3+322p1.0O/.-\,*R)(v((\(a'.&%%%&%%$g$-$#"! A C0< !#$%%&''c%#U##{$$$s%&f&I&%_%$-$#""!t!M!q 	gxG$~
!"rU
*_EO]
	W	e@ x
!cD	Lr
5Cxw_ y]"|ߵFX<qܦRڰ)ٹ"|Wp/"cGst
~$(jjeXW[*ûC~)*jo
<Ͽ.I$RDrkÚ {ci:iɓ@;^m!.	bvE
sl{Oe_r _"#$$%&8&H&&H%#""#$$:$#$%,&7%#A"!"#"%%+&S&&'((<(H'&''@(((N(((k(/))(u'M&G&Q'()((*+-?.-e,+,,-.--..Y/h/D/#/.f.J..00
0o/f/N023T55 5Z4g44473h1012Y32:211H23t3`33343B20//.,})'O(('q%$##.#! @*{E!IJID* 



	?		
	-t~ kL3|+Xj5ouPh|
]]u߽S2eۖ;_K@֊9PivҼtQ9ЛΜ"MVi˟\
#Aj~Ɇɂ}ɘ9ʑʡ6˳ː˅̒F8@x̶
;͐	]θσ!ѼIҍҀҤ8ӕՁՠMׇ2aح>_iڢێH݋S,%
RkgIO_3Z|S@k
| y*402!!!!"#$%&&'()****z*y*b*D**+v,,g,O,,-,+E+Y+O,J----u,/,],,f,+~++++
,n,,\-i-n--j./.2.?-,.-+..../0
22334t567899$:q:::*:o9888m766d625|32h1-10e/%.{-[-5-,+B+M+U+*-*)),)$(&%Z%$d$#i",! '#$a%/d
p
	2v>s 5^[,w('6
N3gH)ilButFSyޗ7ޡiBٷuמKՓ%՝ԋӼbѭѭѡn?13Wтџјј[ҵ.ӊӰӦӌӑ[erO5ֻ֙֓օI&S؏ ّ}
Tp0TݔV޽iߩZ4TI 8v#uaHc@
nuW:?^C_1$?H[W/h%-hn5		
M<


MUzyugIh]  !"#G##I$$&%%$(%%&''&('((1))2))***U*^*{*T*)M)=)l)l))~(('' (''L'''_''','&&2'p'S'&&?&&%X%$K$#s#"U""!^! ) D?2
9qC-W&tOrJ ZFS:j

ot
	!	m+gjT  T/R|Y{ G.a2N&=II=Q#[)paPZ0')f+Fs<rlv\Lgv~lkvf60W5"=T!=X6#bsDO7OSH1  iqD67[z<	#
-<
C




fu!_5${/(i%s_ySaiIW3'R*A@N1Q w+U
t
2
bm#

g

	s	;	Q2ctceIl6  D ~If- ~PRrzib]M6e5	K$b XL CPz/AEC9|U 7_'WZ\*AIIY#wQOtp'xF8K]J@Oy9Lv#Eq"C8	*Cc#O'dny	Q1 s  |D\
WP,e Ai<Zu		?	|			
A
a



'YsfaD


}

|
S

				O	 			t`3[%kaQ9 wZ\v{\/$<bkTZ0]0viQ#E    X @ 7 , #   
 ( 4 A W n |  } w f D    zwmYX]T<1Fm~c8+9JKJRo 3 > M ] m v f = 	 wc6tn_J-/D@1',1<MdrZKNL< yzmZUr-Pq-D]okf]O>/#$+:B2 8U_eq
   & S \ c       .Wv'##.2--$%,1-yvoneNCN\bXG)
    _ ? . ! 
          
  	   " * = < ,  u\OOMEFKM?1"8]ytovhXMD<3-'(0)):5-"
wcUA1'/JurS91*!vhT7"zaA %9P_o1FUi}           
      RSRC             [remap]

importer="wav"
type="AudioStreamWAV"
uid="uid://cbsgt5sx83udx"
path="res://.godot/imported/b.wav-74db3304b7924faa085f8187ad892f30.sample"
             RSRC                    AudioStreamWAV                                                              resource_local_to_scene    resource_name    data    format 
   loop_mode    loop_begin 	   loop_end 	   mix_rate    stereo    tags    script           local://AudioStreamWAV_sj2x1 8         AudioStreamWAV          [                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 
    ) 4 @ M ] p      	,S}W{IDw	
	Yl5stNv(kP.^Sueo<1Y6hk-I96e)$	+/evUFpg|: _3/5U0 1	.x5sazt<*"u8
{i`[tFvP lPKy$	=w*5'ifw *t,-./e11.($ l<
3TEKT)(t
u
dFwoS	PEP!eA:f$~c$ 
 {
>rjS&	FW0Ty  \ 	g\
y	@
	xbB	 M9AXp&R}- !! @=/<	! +9d
N
		YJweJ8.*`.:4x/FC1Y/<eET $V^r}_xcL0T  ]+;"dG"8@yF_%(@0ALn;7lgdq%TYs^5/CA} OsA 8##+ _`3atY)wHavE+ ^ 2z .'& ( Gb_"0R	 IB"IW@ev%3 sM<rQ(B
	}			e

%


p	)
y

H
~NV




N.qNW
Fq
2				g	 	
	Y
_		+
f	!Nvx,
8	U	+	H^	j> !omDi{nmiO)~ c w A{LDM  Y  {U Gere-:%t-> a>C8k~*9 ao4
  -0=/J$
 L &`$ 1  )6 )H D~7HBOP[t.m=O KoP	gB/Jc>&VBU 4j"w(f4 =5GHbN([#
t1
F,90.xp:"<
e2y;A<=wx x
 5W [Gso
 h  !  s  -l% u  ] k  8{ t~@BGr)#BFU8uP\ %md~C#h > -F\J5> " 6O`   @ ZMu|OV0}wR  VXp"K`)y [6l   1 =xk./6MMq-816  $ l  b%M]3    J { E LT-/%y3wW;T ; / `sT`)P0;>g <  r  K     4=  . lv Jly|Fv> @?WF&dL<0 + u8n?e   83 ROzX? /   3j  d Rv^ L	  )v,ko*cTr9kG{I]a	
1i\ t ; ?/  W 2 sPq2cu8   lYj!DuN9hnYE(FF+h{JWZ50_MN~ b f Xc7"  Z>\u:K:
  a UpFOr'<N2Ih  ~% 2  ? c4  2<wh`
OpSB?zR;*Kx`%Q5k]f_QTQR#`3V+MMfE>  }p(hN u!n}X-^0~YLm5| & ]WyVe} nz|\ Z4) , z Y=}0O>  L W J5QYIvE
+&0DpOd:,+1(.eBT#1oL7,RFSyf))j.}      R  9%e<    \   g z\~t{' 7=*re\ab`C<(\Or)l+wC"!-JfM_UP#rh'"{$*Nvz,l&2c&3'Ow/bfUBl\y`SX F#Cx. @<		_
k-
8]I&)XO;h@Q`	
:yR-hd%cA7o{IqIJ|$,'$'x+x	4!PlEI8
Ii

i
g	 3 7  uBsun%mLkU_	nK	g ߴlݡۈۨaڅ8s_'7*00`ҟ|hwtϔ=Z5Ϊ8[Θ͂rΙBv̱s#KͲuϏ-k`Pс.N~j?Cל)f\Xn݉~%$?Hf>N W"%$y%&'o()+-.."0123v5`7M8<889:^;<<<[<<%<<;;:9S877r64y3Z2C1/].-,+M*)*,/G36`9`;4>CABBA<@=;:::v9:7L5(4O3221//X135&8o9l:;Z<$===i=<}<;:
:8646320/.,*(&%$$>#""|"I"! (;xg. b,u4Pa)
ь"\gʠUqƫĉw}R,$*0ùYln֭ת7PM/ӠLOş˟Þ7Ϟ})
pWDyƉCPQ̣fzK݀dC@;tO !"k$&),,-&/15h:>CFPJ8M]OPQQ1QONsMULJGDAX>:62.)&`#m #yM~1

 
	'' 
5v"&Z,16:>MBEHJL2NOWQ<RURVR;RQdPzONM<ML-LcLM[ORPsPPQRR/RPNyLI9GNDCA*>i:A62/,(O$l %9$`O
Q

	<l 06pZt.
ZaXP}|yuH\ .AjQQpeߚTpř bCְK2KnJ(jΟ}Ξ$Οoբ?ʢnGA_e+栺0Ǩx𫠮 ػH %6(x+/2346{88-86B5556h53-4@7c;?=C"G$KMOPPKPO1MDKIYH:F3DA>>:7{2-)$/ e NE__O/"F		+
 vYu` A%)z.k3B8a<?BtDF!IJ*LMNjPQ2RR%SSS2SRQPNOML+JHcF0ECBAiA@?[><:98\5u2k/,(&#Sn\
1MxA

85)<MxH
hG'Mn	(2,8{Z.HJ	޽ۻZ)͈˩ɚ}ZHɻ˹/x`ְ¯&
l%ڣà1WlX(s1$nْ1yߡ騮3zҶ%uG e&'&&z&q')+F---,,..,)(+06<MBFICK7LJL)KUHNE_CA@[@?Q>;9c50],'"ci$xHjh 9q\,{x	"G&*/48;T>A;DGvJLNOPPQRZSSQPO6OMJeFB>D<:G9#8"7H65
543"12-(%"We)	f O%B*Gg\1s8{^ j[ H$&)C-0&2"1r14&6532472:;-<D<<i=<d:74
2/+\(9%!h]1H	8!$Kw^t `.ܗ+ԣb+VʣȁĝÇN8Ûdi Wluxܻxٴ3ZOml!RG՜}ޖwזPƔGϘJeW8*I܎^/@jʆg*W!##-"p#	&%h" "'-R4<CIH~LOPOHMI&GDfBDBBB+AA@->94/)#![
	g&%hIEvu"ny(jP2wg^.yo
!&+i/p377<?KBDLGIKMPbSUUUTRPmMHB=:9"8K8999x:);[;j:l85b2	/r,U*'#E*M4`
P)mg;)+&	m	Z'&f #&'`*.254668>ECCAPBEG5HGFE|DrCAK?3<9C73l/',B*(j%8"dhz. wC]61 l{Ԛ	gnәi6Ӽѐ\~ΔcV;A%<eihŴydX]~I BkaԁhpYoqC#"Y."'k/i6<AGpKOLJGDCvA?>>?@T@3=8l4&0j*!	Q"+RIZV(=f4J

L!%)K-2M8e<?AE!JLN>OQ/TU^UnS.QON$LmGA=g;m:t:";;<?>AbBEBPA?= 94N0,)&!r&
)qpQ$j
T%@_TE <f +/B $)92=J5V2^bGfkxoFo
ke^XQrLIFA;4H0,)&"|7EsQW
&~.'Xٜ{Ѫ#y~;f: 1߽0Ȓo5kî7xS9%6ݽ
崉֯	j	a=>fdN㌇˄xO3%拀+Q _	t3
p'!K7!'.7?=AFIbKKJHGFDCvDEFEA;7471?* +W
8c`/+[$6x`Ac%){:Tu|V`05 4n. #',U2P7;?DHtJJ!LNQ<SDSQ*POPO!MH1E4CBCEXGHI0KbKJ5ImG~D?94$1
.*$eR	>M;
.<>w|(qT
Z#81Q=3GPYkaeeUcN_VZoUPLJ)I"FAJ=:8B6>3g0...b//O-7+(&$ \u7c\ m h5f#!{\,DXbۇtqިqt֧`(ÖEŠ'ɡ,Κ_Њ̐{ɗƙƅ\leW?ҩwpÛEUӘܘ=7"3%&5d6٨GudE&01; %"!V#(+d+'#%&F+C0S6j<AFkK%NMK;IFDBABEGmIH
EA\?;6-$VR*[4[WB>rhuL1\B7
GL#s',V1;6e:>>tB>GUKMORWfZ\[YXVU
SQNHDBeA8AAC&DHEEvEzDC@=7	36/+(A$%

He
4܍5Dg~u-l r
"*28= COHLHO(PPuQPNZLJ?I)GB|=a9"741-)&c$L"N.F)
+	&~ l{#u,ܣP?٧٪.
[7b	ڊUB<Z͓@yɋu"mTˏˋdfʪXpd9:Һ]@e+uѤך𚮛0̜ѝȥ܂biHCsda"""%w),*o'&t)e-{28=AFFJKLMK5JHAGEEFGHGD%A=+:.6p0n( e
(	d R
'F+9KI9
	xe"&+058<?
CEEFH-KLYMQLJIHYGEAg>C<;:j;<=>?>=<:;84~/*M'# p	 
5s)jYW
:%#mA nz/k!x'-2W8=ACEGFFFDE<CfAp?<9*8S6#3/@-*,+( '%#  

5 4
dA`Pa@\ߚޫ_!*؁֝ԗqС·̀c˷͓·ϲpюlyюр>
6uIυЕ5tȥƘĮJVƮέ]ժǩ]{XƤK9⮾Ȋӥ$P
c
{!%&r&'*9-,+*P,//
3a7:<?B4D%DqCBtBOBcBNB8BB4CB>;740+%F)tOE1jp v]_UR b{Z0y#']+W048:=ACE8GHJ]LL{KIzH0GE@C@ ><	;::::e:B:98652/+7'# jk(
	7yck:7xP t/U
Y]#)/1~5;A`D0DCCJB?<:9653Y/*((Y'V$ :sL2qjbP
	S7:$_=֥4-4׊bרx֛wԜѬо|;VE[<ҭOPՋ@־֦d5ؾ/Юʫ)X*&򺷸<;tαܰ-ȰͯE[I޳BQq1)Y'ؾ:Qps	
H6pv%()*,/1/w-,o.1l4z679p;8=T=^<;;u:9R9888B9%:97r42 1.*a$:k
L	 ~ 2(y5Zs^k@" 
 
	&["%:*^.u13n69<6?@BEXHJJIgH>G.FD#B>;V976)53|210.-+*'<$ 
kT	*a rfD[_Bj;[LJ	
Z|gbvV $(r+,.S0j2-3}22221#.+*)8(X%1"q 2'
67	tC i2;9ߣhb0gr٨١ٟٴkٲp؅abأإ ٴ%ڎ:'ܷH>ܚܐ9ڭ	?֙E&ʒyt޶۶pȰ0'$u@0lyqݼ e+Nf#h5T"#%,'k),*/122;33332H224*7o888n99g986<5	43J321S0.,)&# 0@
jW]@.m}P?S %/oe
TFp!f$L'*Q.k1}357h:<>#?|@?BCDDDCCA@=b;97P5:30].,+`)p'%@$:#!BK
&	UT $|*^=`1}	 %	~!d~ G""?"@"V#,$#G#-#$$#;!GbLb;

%
~\ e
N2 R0jgވeBݙݧA	ߴސލ{ޢhݭbߌ^pj4ZSO?w;h?Gީ݆NڞOiT((θq\ɚƔXż-kҸ:L]ctD/Q
~{MôǢɞW΄*=ڽhw ~
b !#D%/'((-)*-/050/00u0J/].--..-,+M+*)f'%}$#"a 5MAj	{!_  IlYxy	>
/cw?3v:!R#$%&j()^+,./z12345^55u66q6555532s1w0h/-+*^)([&r$"R! 3w~ Tsg
B

!
 
D
fX
	x		J	|)v	
H,+pbujbrDCd[(@7I~3
w	G? Dx]0`A\hk6'\]WJbFO*ܛgٖx׊@ըԎ/ξ,DʔaJ ap'@bcDaheE\GHΧ^ֈڙ5ݏ9ގݖ0";ٜسٗ9CJN 	

dlhg68 d7W?B)n/&Mv>dX;r?e2( U  /!""#.$$$$$z$#L#""W"R"n""M##Y$$%&0's''''''b'
'&%$#Z#"! ,nQLO+N  x B g x E$#An;yxs
H "   n"VT?&
ZF
	04? o"9cQ<lAqL-Tvq8X5KD<s>xp1%	#rםե 0oҭё6#̹̍ˍʬe8ʠgZ:˧Ż/ε)wѨM	,^=ڼ܊"ߨ%/Aze;+*'PV`	Z



V
=dCF1eoB9z>0nIE1v`^!"?##z$%%$$y#;######'$d$|$$v##&$${$G$$%h%o%5%%M%s%o%i%%$$S%
&c&'(*+,,>--,+Z+k+[+[+e++s,p--{-w--+-,,G,++*H*)M)('&C&%$#".! iW_A~Em

,
	V	
R~W (zuv"*'|t-)k3|^0_u[S*~2p-8M:
dh.yYܢیډx$Qm*PҾщBѩϞϧNКЯ=Ј6τtІФ4Ұwӡӱ(X28Mj{ۜۇ!ܷe\)Go=<N,v9:57k^6ZpSgES&bJ

m o)kB*[
x! $ OF;ep!"#d$;%%%%D&S'(**D)w)+},+,*(((('&m&&&%%!&*&%%/%%=&V&e&&&&&&@' '&$$$%$#"A"9"! E)fW_op-c*w
S
?
	:	E}  3}vAsGrN.Hf\`j	x[r-^pP0߮vޯݷ݂ۄۜtZ8?7ٞllكٖپ5RSx%=s۸\ݷRߴbfv6aC0epC018$v?p GS;\~p!a ,{[	z

Cnj\JI,:  !!"#F$_$k$$%?&&&k''E(g(({))L)(((h('(('''(Y((((C(`((e(N("(''''y')'&&&&%5%$$G$##"h"9"!+! 4 rS=GSvI$KYIO

	$	Y(?{9 @;B<K#7%PN(tDxMlW.[
T|fmTg)'	u|,߄"3ߎߣY/aߤ߯߰S@#Y	AxMZ7LTdd9WQ|QqoTT.JimLG)N[X    pDUP,qP\	
b

Gp

iQ|+/V2y
PuFjeTr Q |     R!h!<!     v (   ; 7 Zw(v(&' U!TKR	>O,6ay
8
u"
	?+n
a @+"	c"U"w25O[1z'f`F)iGgr'b$cZgwQPpfJ;-J=^
h;p.QkJw`;hLP^Jc}
c-]Bbrvb<-  L@[TF		G
O$




31 lI=;"'!
G?K4*ek:
4/Im*Fa2'=J@#,bv]zO9%N3o+RU*
u
sF	0z
	__f1R_2Q1gX  ~p+-``lvE2[zCIK'>^2>aG(2\z|f="\A.6P\P%W|J7Uj]@717l!L89ex{*+'8U_@1Ur3OKK;^Sz[9^}S7       l+G!?'}	P


v%
]

=$c$Wn1m.;s&C-&	X;H1,@<8Vliag{s<}P2D$X>Iq4

O
EM
n

	x	)	7Wx$d7Js3 Q  3OOzf*k?	toqXSFxc!n\E'rP.h.U 'lX3n8qTH0 
 /DN\q'.R[` WH[`&:!6-M!H-
BwUb'Vy~~
=e% k  4YJpe[4m:r1				!
I
T
C
,
?


)u(b&
g



*4DO}mgmm_A$(
q
[






/@1?x~mD

z
A
Fu]$




e
+

		%	GQbUBE      h G 
 qD>;Wa(HzW>+-@[qPmd3hAw;~u^0tc?	c}X&7Ik#EG$3[i`D:HK=+-Ho$=804WH~#Jefp	$0/,GAv1])@'MPy > i   F~-;cW82Ms2MRL!LStCe[cgWOO?%@XI"+7\d>OmDUjB&sy6by=l[]K  r d ] V V M F M C  
 , 9 S u   t {          | ^ 8  bB#DQ[%\=?PPGDKU<
-U-B=R+fj__hvuvhRXe`H<@MN7M&"W_Rv>#q6# `  zf+1[k|
Xoi~{|\!n9NMqwx1y2!098842*j^B
~xnaV6
sbiwxg]t}x=	zN.   ` ?  wN+!`G;.-Fc/jwZ-sYT?.:6.%?ng?cF$
-j4KfqTE~`O7".Pdni_M47?@BdAehn
6r . $    	  	 3 S r      
  
)AcnW        0C:"$Iptl}*6=F=%/@994" mhel`YRF   q ?     4 H J C 9 !    2 N P <  n_;	A`ceoe7\FLX= 2h%Ah           
      RSRC     [remap]

importer="wav"
type="AudioStreamWAV"
uid="uid://5pxej7v64dc1"
path="res://.godot/imported/c.wav-2b325efd9b1ffacf904127972b6f63cd.sample"
              RSRC                    AudioStreamWAV                                                              resource_local_to_scene    resource_name    data    format 
   loop_mode    loop_begin 	   loop_end 	   mix_rate    stereo    tags    script           local://AudioStreamWAV_67ek4 8         AudioStreamWAV          X    
        # ( . 2 6 8 9 ; = @ D I M Q T Y ^ a b b _ ^ a e f b [ X _ g i b Z V ] i p l a S K J L D 5 &   ( *   	  	  {mf_VTND70)nWHC:$
wjT?1#znjlobVWh|pv9Q]gjcbmu
 %6H`
)IZ]`gn{! E X i    /Lj#V%4Fj
(JoAdq~5?J^w+14Hey -0/95,
 	 mUZXF.e=%
nAqV/T$mN"|9   R  \s@e4Qh8k7r2[2u9zg@M
nH0+/1fF43;*!/Fd2AJRh.Ky<_,TyQKI2}Y4$y y i  r.G Ax\-]		E

k<

~I@cxx-}C5_9Rqy?m:0w
[,{>iz
b
K~
	9	+t9pu 1 a&cQk_U2"t@by j!s&=aU2
R/
8[fIS]
+Ga&pFw	?dAWqWlMgLy	J;yyyMT.x2czE~ 
x_{)	8

A
:bxz 8["yB6W*x!i  M s                   x O  ~5Mc3%l#+g/pG,`
5
>
	*FiSn 7 b55UrZ<tc	Cha
^FzeR2*Ia7a@\uBgGM&OxIuE}L5m;gAxB~+Ly-g)} m)0<BDWG  >)!
rtz		

<AV

]U@A#!ygHl0W6z<~3]|,;I[bdcXLF?5,&^6{Lz#VDH~ L_yoh/u
5


	r	.DN}$r + ui
o 5USC#*E_a]4MoM*w_9d=#2>ETr6Pejk:c,Pz$O~	@r(Km#@_|1S|!Ab&N{5jR
<v O`!kS=Ps0uF j  C
pQ?'"%;O		;

J?(

'wlA3](RVe"k;pAl C[pxcK(U*O}6B/[xDi 1Jk
5
K7
 
	UI%q \ Ymx:ZdeS@9ET}]Jx4e)s9w6e3hG2#5<8@Kaz AavHqFh9Tn&A[s*<Nq<p"Fp3KOXu(Uw	.Y}Fp9j
3aW
W7h
k^
 c  )Bu<c0K			U

C

v

BsQ y6G@3T"Q>g7Xr}e>oD|=v5OKR6u?gr
a
X
	W	A4*0Hdft X A(}cHKPm2NBspp$*R
PzY(pc^OD>1+%",..8Ncu =b:YBe&LM-_
E~5zJ M~4^T)IfMqGl,T}Gb}Nw
9i = _    -T{6q*WtC$RO
[;x'	[			
N



3iKv
W



!O7Y{
%Fn,JdrrN7sV8V$=

z
A
	
n3Q


Y
"
			y	X	0	{>1l
~_n3B09
AF]),NRJ}SypQ_p2@
],mTUr18R!02&D;$=)9@_}AN"Y;ADD< =sy W   [ WQq a k { "Dr~k"<yeZ3c[ r v r~B \H{C]R 	t
v
CH
#
sjRr;Pe!)"!A&f"%&I((%)"J "#{#7!:SMm
L5o?



|	/ Ag  I KKdar`rAF6)TaUG`N9<Po-uoQr\Ze1o'LK:zuo$l 2ݪܸl؊؞صVؗ׺
հ~ԝN\ѡҔҭ<46VoJӾӹp5ճw֎.#ځO^۱ܧݩSޑ"߉+Q]_|CGaDCTw` I=
"
	T`a[UH!"$&(;*,F.T0#23656"89;<>w?CARCCEFHHeI
JJKKALtLmL|LLM@MMLLeMN_N0NNMM=MULKJSJIHGGFECBGA
@>=<;:987H65321.10/.-7,*0)'&%#""!"!> 3J !!w"Z#$@$#"!)![ ?  
D
>RWE%:GT

(
				Y di$|R j#)ܪہږد<֨/Ӿ#
!*aÿ5|׼b6Q1%Z
Ѱʮ_:&5ld#%ί[
׮zO~3_4u!36޴&HĸFa˼Y~ĴŬǀD%تY-5O P	)	X7
jGLx!"$'(1*K+2-M0w3S555F68:;;n;<M>?@n@?????r??4@@@
@m?%?>0><l;:;;;:98R8,8715{3g21X1
10/.--Q,u+*))((u('D'&'&8&[%%n%%%5%$6%%&%%+%%&^'7'&'()}**P+,,----t.o/00001 344z4e444$5)5444567%9&:2;m<x=>===<;:978276T6421//-+u)'-'&l%#L!V 
	{,b~m9itܸUfkhQnȔ2ļ~76ػƹsƷﶊAM hQW۫ު9#cСIsg+p
Oؔc(vǐɐd>^@dΑKw``쳫Ef{ŹNx*ݺwRHp!%A*-G148<T>+@yBEFG^HJL
PvRRRHTWVYBYWVWYZEYXWbWcVTRP0OMJH8FME8DB>;986k41/w.-+*+)'f%" 'E-I`v\<(!#$%')T+3-.&0l1!3+5&79:<>@
CEFHJ'LMOPQR^TUVVV@WWWVTRQMPN;MKJIHG=FuEKEDRCA0?S>=<G95140.+K($:"3 Ev}U^

	RIXF c=P>JKp{a"Q
Vmk$PT>;V^{C"m7Ќ̱ƶݾh;|ghsXCz:;5Ƈ$i`xU7'΂1хrY~U8OsnbbVŊʽ~/6,jo?Yv>5q"w$&[)>.38<>@BDnF
HIbKLNfQ=T VUTRP]P3PON"NMMMMMKHBEiB@c@6@>
=;:3:8k6=3/,)'&%O#H!R%a%leq,!P_6r#CW!#$!&')+q-/	1K358f;>\@SBC(E9FqGHwJKMhNOPQQQ3QPPPPFQrQuQBQPONMUL*KJIGEaDB@8>-;O85D31.
,)('''&H%!$u#" GW 
:	TM2=cH	!		$
7
h	,phpg <9-(bNKEepF),Aܼ:WA" GŸcƻŹϷZoް謳稢-.Ơ4q
yxZI= ֎ď(r@@4-ޒp AUl8oFj-8ԅؔܫ^|
 Z
#
	bt0#')+,.0v3u6:?DCILGO-PdO>NMN@NMnLKL|NMJE<CBbB@j>y=>~ABDB1A?=d;w8_520
/\-+M*<)y(&#\<1J{.7  !!!5""F##m$;%&(*-0 4689;=?ANCZEGJuMN2ONINNMLKEKzK"LXL1LKKK)KJ#JIInIH4HGE&D+B?V=:\85Y30-T+)&}$R" r\$jdV;h
uP+#
{=e

Y9

2	"Hc:L&. (v܂a]CS)ǔ
°{dbCݭE3vSuOy>@~[ҙ[`%BUE@=@ԏ2NHіחiaי!f~"NQcޤ!
r
5ͱj1Sh

?T
L
Z#!%')i+,h.X02O6^:?CGaJLKJJJ.JLHFE4FFGTFC@><;R:86@799g9+987
6f3 15/-,"*E(&%%$"QJc^).:xe _!"d$%&'(***d**+l,b-."0=247f:N<=?@BhDEGIKM!OOOuON[MK@J[IH
HFE
EDCB>A?>P>=;=!<:99753H1.r,*'%7$"  M 6R^tu>D
k
Z



u

#

/#\]N)?l#3X)#l	_/By']$D@ZޛܷڶT}WƄOݾEλεҳI2a=RG}X L=Hʟ[rߛQ𙒙-FJ$_+G)̞}&	5YW$s~ظI>_aHH|> 1

2g5, $(*I,-/y13>7:=yAEFJMOPgP9Q3R>RPNMMMLIuE$B@?Q=9;7h66m765432/.^,(*'%F$"!5!h nQQO


A1BPpT!#;%l&'))*+W,,.s/M135B8T:<l=>AJCD{FUHJMCPRRRS7SRQO"NLKpJHFfECA?><0;9865z4P31/f-
+(&@$n!z6
	l<t8	OH	
BX
8@e
F+@P yw$W    = {cb:L@	! e.dw-qԕ {ɢǶ@\ßܿ:$B>H6#ɮͮŮEެ¬}٩ש8ަ-Ģ8 CĞt=ᜑ`bʝiٝkϜ8$ѤcD'L;ΩkiY<]	Q
:8Yo"&p*q,,.0O2#5<8n;>ApDGKMN)OOQRRQlPONLIEB_@K>;W9+755(4i2/-,T+I)&$^#%" !1]
		(
		z
IsZ "L$%&q(*,G./024R679z;q=r? A]BCEFHJJKM	P)RqS)TTUUUTSoRHQOMKJIFDBK@>;97p5308./,O*L(&#!88	d, [H
  @,{z	,#Z\$+2>p6!#x$$$$&q'(('&%%A$" >M>ksGr1
=	!/ a?) ޿:t֮ax˻8ǦHv;{uݹ&NIϵ4ߴ)_񵎶(ݵ5ͱ
-Zި}ߤǢIʡ|Ǡlv%O@~K
؝Z.2hźտ/ĭFa$CR'_!%F(#*+%.J14Z79g9R:=@CEFGqIJKFKKrKNJHHGFBEB?i<97640,***'$!H'c/Y#_
v

=
y5t	#r&
)K+-/1g4689j;<u>Z@BClE
GGHIKbLMBNNmOPQ+RQQ]PPOqNLJHgGEBO@=e;82630.K,)&\$!^eG-DM
0 u S9% fM*`	-<
pJlGv#S)!"$&((())`****+`+V+*X*)0)'(&%$M#! *W0	=m IMv2 ՋӖЦKx
E\==w6)j"d=ػyyȹ̹k+׶bĶ/eOJǰcJ}\4k֣ǢM02 sΚr՞XġBF/SmGH*NhTγaFg	]
#'Y*^+,/367888p;>AArA!BCEFEGDVDDaDBCAV@?>e<p97s531./+(d'&7%t"$|"VI@U.2:Ybs%dD3hg: B"$'*,.03}68":i;b=?ANC"D,EFrHI1JJKmLKMMMM,NZNxN3NMLKGKPJHGLECB	@=;86O41.+)p'$%"kJ
0
_H	
`
v>+KK@ 0fc !#$$D$s$k%&&%$"H"! :`rt8

	o@v Zn&a m}ދzٴMұѹ*ϧIˉ:tSn+ŽX¸~5ݽ༩J|^):M")7㸍X)
ѩSf>=tl3KtMw~âţ]Ǩ}{񱇳6àư՗Y`VET	
Fe I$(+,-q/[2I567779;<K<;a<=>5>4=O<;;;9754>3}1/~,f*(t'$!:oTs[|\|8hG9FS^/"$R&')E,/;1246;8:,;;=>@MABBCDE*F^FZFXFFFFFiEIEE_EyD-C BA@U?/=:b98?641?/[-+c)&c$A"a }	6B

\G
$kwZ${Lng  6!#!8!!"#"! #!!/"!x A_X`(]i
	h" omgeXL?ވܫٔ:lMX
ẃS˛/ l%ǖBp7 dϼ9Yùϸֶܶɵ@îխǭ81yY,Zæ ?vJ誸p2F/rܻkŕfF|ש/c9? |cVcq".$%&(*,Q--.0d23*44555{5I55433321r10/-n+;*[)=(w&$R#"!E!>  >'K+^3v%K+ !R#$!&<'.(J)*,.L0t1235m7q88~9\:;<=_>>}?	@@@@ A@@l@@AA@?_??>=e<:9876r5@431/l.-+)'%~$Q#D"!!!   c!o!< nrsq ,0\J F 8 #)Qg'$A.d2RU)BcI^~`m
0	F */=q$bGetw+݆pFِײbҢSрP̐˄HɈ3Ƌ$Ć8djS~kqj̷շgɵ%5z󱆱Gدl{JCIӮbc#_|KٳW۶H>	&21œǤɗ8xҷt׆ڞݴ0x9Qw+	
{]*$PE  
!"{%'( ))+-.~.s.i/01l103001205/P../.-+*++1+)(:(((('&''F'f&%%&"'&%$q%&A'&%%Q&'((''v(*+++e+N+6,-...P/u0122b2~344y474456o655a6c777;76_775876c666655066666[77X765444\321b0z/d//
0%/".----+y**))'&&c%o$#! ?#Y
`




*

K	bD:h[Gp_ 8s
OqH*=69dUJߠޓݙܧیE	-c=3̯˜ʖɚ~KRůmï-Tƽ^__o߷_ƶ@#.#ֶܶIͷ2j	[[,;k J>,G7;dIAJ-Qa3˗VϬs{w}CwE3	fF "#W%6'1)*+,,-/./0A11E22|33N33221&1000g00////#0//..#/Y/6/.d../'/#/...-K-?-7-1-,,,-{--y-#-,--...>//00y182^2 2132233y334677u899:k;<<5>?AAAA@BBB,A?q?Y@8A@\?o>>p?)?=<;:H:97654{3^2[1J0.d-+*+(.&$e#!gn

f
p
;	0,O@ /HvZJG1
g8vM@,_c/ފB܈۾c!JN̥͂ˣXɺSŋvã=X ýwM*ڼѼ<񾖿8EiOUZ¼-×ăp:<ɐɇɟ7[˴(́8Њ3%+ѽғ2Xׇ؂i?[Ff5ihT o

D>* g!!y"V$'!)_)(>(u)I+W,,-.r02222v333P32U3F4
5443344 4222343]33;3343G33Z334r4956_655N66654568f9888N:::8189#::;.;;'<<<i<;;;<="=O===>:>=<<;;98766+6432(21/-+*&*)~(a'&&&&$5#{!9 *a/l
!
	 S+V@Jx[VbmtB;uFmnߧKaܸQ۟eضG؈ס8uӿ_ѳ.иL΂MQʃxʑʅ<ɤɦɜj+?ɚɢɔɮɸɊI0iɳɩɏwbk˘|DfZ"Kaѷу9fLӌba&!t'׵^6MۥvݬgB*_R^gl@<o[} eS _ D  
m
]@)=
s'
cC9-9&G~2T !""#d$I%%.&7&y&''_(b()(;()/*o*)z))+++8+Q++L,K,
,+\,,- -G--./...//@00/a///// /..C/`//.g....-v-\-J-,B,++**-*[)(>('i'&%$$#A#"!$! . ] {
[H6UvO&[+
m
z
	/2s
l;x =[e/#U+9/cq/m$'yyt2HSHLU!c".߼߃F%*"ޯ\
ݘ]ܻ~^[K-+R][|CmVDw*Kޛgߪߓ^ߒD52&LaI% tY[Ct:S_1S]IRp<Y   YjR+;					1

-8
K+

h]6yc0QGBT~150~	m.nS[7GB;'[g9B2[Zbxwdlr1%&6>gCz*j@

h
!q
		D		15^xY(7mp    [TD~"il	7X*P_!rD(TX\7f9d%8U9<4_;%<BT{UoO69Ms:H;R5l@X%Ap/V8_mD:-Nk%lXy-c1Z}$b=Vj: v    
&mh#`o!V.Yz#	<	@	)				 	%	!	0	e				e	Z		 
P
]
Q
l



	!.M=?8Dn{_bl^0nF






)4











p
S
G
P
i
~
l
Z
G
D
=
?
C

	t	=	T#c.B
j9>G
qa>*

'FbY/g@p u ? ACzRz!O
%#}Pjd, \++DD8*S*$5EUdu_;*"(Ckt<1:0
2`
7\kb].I<9j.M 4^]<@~y8BAN*V M o ~     y ~                             @q{aEDOQIKTXk'Ukw02+,3.#CR`s\YM*&) %+/((+*#jC6NkqgRE603;5%3WtuZ<)(%
m[aumVN0       u Y ? : ? E C @ = = F I K E F C M \ d P ) }wrkXH($G[oyM(,&zF$8L_jxwkn5MUSSYK7-2?NOD*
gQ<-$">aAp|}sorueO8tcQ<3-!	y :j8U{l_idS6(+16;/*Ufv
 & W   CjruvjbSI2  i C 9 1 "   2 R s  t w       %'!                   
	                  .:62GpzuqdK60;KYWG23Mu1;% "&& %5EIB=5'|y'n # "  y6    zXS    1 ]   1 ztL       !]BPR^*=_w!>H:P6)P
qe0x  Md,_`EoqzwhB	lC&eSQOH?9AVnreVH43Llup^Z^n#6Jh%,010.;OaxGf@g~4`X>Xsw]A0*'" $& qpz{z|t[J@6- 	$/@Qk/Nj ( C Y l      "BRY`pDi :Uekmghmx'EXep
%-3@Tbnqlc`a^\ae`]VOE:'lL9/  t^PH@4 pZJFCIA3 
{odVH-       
(,7EVafiovyvz|{yy}}vxussuxm`WNB9"       e Q 6 "        ! , 7 ; H \ h s w      } u m d a c d [ T T X \ ^ d k v                         y y   ` #  ) / &       " - !   3 L L 2 , E U M 6 7 J M ; < P a l s m V J X s ~ w k g u x m a [ X [ i |                      z k e [ F +  m]J-
xoZB5+#&$$+'&
sf^XF8663. xiSB76*
~wrrtrqv{wzxopry{
+5DGXekz"&-7CMUer%1Ln&5CRer    % & + & + 6 7 < F P O O Z ` p                     	 ',38AJOVXap{         
      RSRC [remap]

importer="wav"
type="AudioStreamWAV"
uid="uid://dq2p6shjq8c13"
path="res://.godot/imported/d.wav-de201fd4ef483bc38bb044495266fa4b.sample"
             RSRC                    AudioStreamWAV                                                              resource_local_to_scene    resource_name    data    format 
   loop_mode    loop_begin 	   loop_end 	   mix_rate    stereo    tags    script           local://AudioStreamWAV_s2261 8         AudioStreamWAV          4^                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          A _ c i    C g     n  -D{yF     GG,ay )  c7@g')bj5:|`t.h[ul-4
C/'jb5$ _:kYc
D< Bg PTN~$r|6s2c>>k=tu:Xz`=@> ;E U  Du%y+O((.bFu]2	6<

D}mtC zN1D)JIyx
_
|   $fP|Q+*@
<lB޲ޕ{EߢH+&a@=6AG}l#ja}  o	
8


g6
p_~_^W

/.

['


H
)% @

(

.$xd|
>j?	Hyxn;!!! ""#m$$%#"#$$$$.%x%7%$$$;$#####"6"u!m YktpE
hq <
G
	V@l^_m;2_(E
[ݴۤ1[׽wGrЊjP̑-γHʻk}T.Kս什MƸnmgڭtbeܳǶeqǖ̿bג>һXeμt;I;D,
R%@!'X-12	-7%| &~/9PCJjMfKnE=e60#./4v9=O?=92,F)(*/:6<AB?8e/&!:s!%'&#nxC;|/6
p/
	
@
I  d}	J m

	Y	K		
{n4<HHd!,\hB!x\Ym%yZ	
   /	(Ik+08('Sa&
z!^\i&jK\8u-)Gmp,	!*߼'ݕqۀٿ=$DI̪˪Xş@umݶ?y.lhX2E,rxĄ^?|Þگy/Օ FHKF!)
.<+v#M#-:DLYNKF ?M967:4>BFGUEM?@965b68o>FWLNXMIBN;3-*()}+J-H.,.,*%!C]p@m,)WXE8
}n<H I+ 

9
oZ#)bEL\q!%>(()*+*4&."#"&H*++.6598 2--q.*$!"%,/%-('*-*%"2%h*M-U+&9# 
|8}?kH4
	{-~	W'D$

]=FP{3=M_%~; q0}֗.ӭҸ$BWĪ޿ο).F)v3i#qWV9㚮e޲o%ϸCfжOKf۔((4dlGv@*T"i$w# !(&p,{3:UAEHQHGE}CA@&AYB~DFGTF@Ch@s?o@%BCE0GpJMMIDT?f:W631)0//#/e.?-+'#i M)o6?&I6N 	:	%Gk$ <I5% \+(aB]8:6
x_w!#&({*,-,**&_#"/#"-!0 !"#0$(# " b!#""B$(W+*P'#" Vv7"}"Pf}
	A/a}? Ej  ryF:TDq(
xZ`jrBYٙ0λK)P|&巏9ӱs9񪿩֨𦣥gPӐAÖ_6J!D#6Fj117S׆۔9eVL
=c!$&'()*(,.27q=!CTHULNqONUM?KIFEE#FEEMFSGGGGIJKLLL'JTGC.?!:5^20
.A,~++D+)'%I#T ~9tSd	h; U=v];qt%YV+l|{Pqfw 0/	Q,3;n+)=1=c!#W%Z&&='x'b'>''')*+,a,},+)&B$"Y"""${&9'_'''4&"2KXT`$G|~2wg
\
l9t	#BSO(
7f8	6Eum(Q__*Q D7<AY];PY.$9U܅tiȽYvU%5bGt;2R2ŒFG7؉H"OEȴ/ʰc	wָ@Щc#WV
	Vtb&,133o21137>#FLtRVZYYgWUSOML$MNOlP7P+OM L~JI<JyKBM_O:QQ0PLcF_@%;626/,+}++<+8)?&4#  
~/oZ
qQl!"U10-V]z!cb

B/d| Q"$'*----.|.R.-x.0+233210.,*(''&&&'(+%-=.8.-,+f(6#C@{[ pB9l
mMRd+)b=  ]bAO$!!neI
/@)@#2fOs
ѫ?ˏj5239nڰyBW	ٝhߖ;UxD07׉U!nªԮ[{aۮam'!+أ1%y~rA~ 

""',d2S7=:w:8w8:!@]FOLQW[^L_Q]<ZQWT)S`RRuTRVWeV0UwTTTTTTUxVEVjTPqKE@8<z8L5y2@0-///0.3,i)n&# :QB	
dQ^^=fKEd\)e<m
	|
c5$# !~$2'),-..//40m0U090f001D2_21/0$.[,0+W*3)'&=')+,+',=--+(&$"c
mM6`K
W 	e`$-dm|	K<qrP[PDX}9lGfp ܅T6T6 þʽܻجDfvDԘw˓6Аbg<ȇ!ԁx#aO֢t#tL֪ħϥ֬TsKYX=֨kkVV

'
L
o )04f9<+=;:;=,CLJQW\_]a`]YWWCX/XvXY[c\ZNX[WW@XY0ZI[\[#ZVQnLFA<9S765G433o2_00.+!)% ! YHS
9S`S'+zu%dwtEYg3rO^a # &v(*8-....v-V-----./0S11f2D2246y6t42293V1t-|**),L,***e+*(%'$"?!)NT{ AJ
{
-#W'dy!r':~N|"Xo102F0LqR#Wy(@!PnJيcתՁ.Cˉɪǡ*P$),%ǮxФm,Kq͚8ޔEȓĒa2ތ(>[=p'Xϰ1WU2#Ԓ۱߳t[|6	;
$+=3I9<=g=<C<<?DJ
QW\_$`p^[Y]W7UTUX([>\e\\>\ZXX1YYYYNY XULPfJDI@<U:8789986q30-(J$ \*w
D	CW) (BIz
8qPGF.8aWo
=
w}HWcjkU "F$&^)*+[+*`*!*))*%.2555O6C751-+3-.
//#1233j20/(.-b-,f*('|&#5 qRz-SKs
2f
6


	tN U
4pdBiFKjoNU8.^__S(ݾۖ=Tu҆hNῼ1dߺ˸2Ʒܵxհ;Ы#ۨݢxʜ6;^V꒡Ē돎(МҠۤgbg1Gc[&ӯߡp	
R#SyT$#*=29>@?"><<>BrHNUZ]7^\Y;WTRQS|VWY[F[ZZZ&YXWXX(YXWTPKFAG>;98?889+:9W852%/b+!'"c
Z01
1
	d			G["(o;@;o 	
A
lmr!H
!%+/M0/-I,*&!#"%)+-02M4H41-'*'&&z'(*,,+'x$J!"L7:BQLrC
6	 @58Q`5J8k3K48BZoEr%d,ZN*{F
A<zܜ٘NՂ)бϐ̉@ȼŵ0K=͸'9ڰxѩ|˦@
ԟܞ-r-xڛxMٕ@p.EeaÓ\缃s;RL;Hj	PA	~2f"E9"l'i-48<>A
B?==>@CFL.SX=[m[YW!USRRQSTUVUtTbTTFT7S
S2TlUFUxSPyM\JFB>l; 97655~54(4231"0:-C)$B!Yohm

N+
h

0	+ 	]T




8	

!$%%q&(J)'J$r!7"`%'((*]/35&668:;;:+91863/,G*))(@)+x/E22/--T+y'x"|RD&s-
H
:
F

9	G/5Y6#]j}=2(F)& /	F
!%
q'gBd1w1O	_?d)w@lV_$ߏiF֫%0̷l#`cɿnGb%inҰf53*`
š
ݢ$4wޚ8wCΝϫw\=$QRʙ{.#O!!!PW

85
4F=OqNIoD?8219\FUbjl]jd\}UO
M`NPSX[]~^S^[VR)S@W^\_Ma`^[UMHE=
84346!889':;;71,<(o#}1:Ej3M4	}/Q=60V8gaT
.YD#(I++-4.D.1-&+v(&%z')+/23S46;U>{9V0h+(/67/x(l*3
95u-U*F.132-)b*,~,'"G P!A"N *,E
A	k
q
zxO
`Mc	|K:e`^$B{Ik#V>߯c
<ݾّؕDڐ<ר֝Ըъ<:Ω͹ɻǞ\^ȽZ/򵆷`zk&ݤʤգڡ F ݘRXЕx4U:h؎3zc'pGȰܶčK}>@	rE
0)	y
+:?>;72,*)v+4S@sMDX^_\W%Q7KFSELHNTVWsWWWUQLMQWZ[^[YUVPH@:6D4346H8`99X:J:8I50,(>#~'+		!
 %	P
	 *\ +65?G	$"(*h++!,+W*'%%L&'n)*o,.1h3#2
/"-.601I0j//134241-k*b*++B)&&1)*)&$!$N$#!  tL_#|YXv[
kl&   w D @q?]4	8D%fs)%G XސܯKp5ڣ
צբө6ϪE̶aįbWٸW#,Yk4HA۫XG&qˠ*rN]TsS\ʔqnTYxì|npk%oix0@D
		
X
4
 ..B9==<:97d6'8=HF(OTVY ZfXUIRGOLhKK:OrSU&VUUUHTQPmRUjVUTRPLF@;v7742345678R9c72 -(,%!|3 


I
8



rCJ
B=ap f`5e:@j>{}Z#Y(g,J/04/j+'7# !;%*o.024m40*%$'&'''P*-.,])@&L$#%"!!"#)$"DI\\G(

ln			 
9~KKScq`qK\\`2v*ާiMއݵلز֭{$1ͨ<"AZپPNqظ "@େC9$jZk;آߤ6fjᛁxכN՘ݦfMШ}÷¨L$d/%JaN{#20;ZC4G.GcDA=k;:}=B>K_TZ\[XURO!MTLWNMQjSTUUTQNMO{QRQeQPNyKFA<7|30O0j122v223<5<63#/[*&""
R+!
Ck*k	9|
Z
I		gP& ""#$$%|%&(+-.T010.,**&-..-/48_71-\-//,k(9(*-M,)J((((#(T&n$-$;%:%"d/E
f}*Sv"My]|/OycDw9+QjhbHxF|Qmzޞsܓٙl%K]͞Q0ăiԺȸXݮnޭ
*ȦB87`Λz'BΙǜיB]OC徫'`kLl?'űƫ3-ml%+e~Vy&2k=CED@CA?=<4>CLdSVWcXXVS$PLYKsKM)OPRS~SQNKJDK=LLLnLKIF4C>}93/-I.a//{/0122.$*%"]P6
TZY

	C	~
+ej
!X
1zynU<!#g$l%&&&'_',()+-04P88y6433	16,G)*o.=110234P5431/./k0
/,))(%!At!!b  ! *|Adu
z5	KqBC0uv(]=hj`'>r28J{nrO߳ݔma)6*jٮֵ!wщО̂ˮʪǥ	:ä "]7%M汭)P{WH#EBhŠߟʟx˝͝ݝ<k͢9x&}ˈ͓*o 
igJ.li"*3e<~ACCVCB^A??AB`FK?QT?VUTTSQ8PNNMMMNN!NLKJ;KMLLLKJHFXCy@S={9!519.-,,$+**,./-k+((~$Q %AYQ&Rj>


5

qe4b7
 !"#M$g$ $#q$&'(()+.`//#014y66545z9<<8b5$69:5/-1z65@1/Q1|43.*(n*-+)f%D#$`%#ba["_G l 1 J5%	j& 5S'| }{m݇ݬۉg,^(҂$&z<^#ȷ}z'z3-6Գ+ѲR']=߫B˩oF짆ݧ0*jLۢ#磭q2WefYOvyķvTؚOa9ѕ62

c
W#"9{ s!9%#-7>2BBBAAQAb@@HC!HM6RTwTRPNMLKJQKcL*MLKIJHFEE/F-GH	HFDB@=94$0,@+k*)n(z's'(*E*(%" }tAypev1W^#)
(d !"$%@&.&C&':(p)*+:-./n009123/5z679<x>g=u: 86m40--/m2334g542/,*(Q'B&%$#"n
uDK dM6T~D.^?<05UI1S	c/-r2[xiJ;eBރ
݊ܥT
2֔5"ntё̫MwCǋ#ĹÿZ%'j#	Q³En@aɪI#uިt?̨0~mߪ).SqqڶG|ܐ%^
a\:*	.w
1 7#$%$]#d"C"#'-L4{:	?ABbB@Y?>P?@*CFKO^QQPNhL)KyIYGEaEEFFFFFuECA@,AAA@ @!?=<9[62.w+)o'T&P%$%$&&$'u&%"` ?P=DT&f>+X9(/x"5

(!#v&#*r.0080Z13,41..6133\21[2467779h;<=<:W9974@1/..-,!++, ,*a'$#"J 62gA
-		G 	5id$uW$H_P`jC,`~)NqOd7Jܡ
W-gӁҳB̀ˠɤ@u,m½ԿMM3Żعط:?l*2_	&PaZЯ+ѱ\*̲/*z赻eո:J罽./mԼ1(lߜ2c +	k5#S')(':&p&&&(-39>t??>>>O=<L=H@DHUK!LKI`HGECiB+BBZCBAmAA A>	=<N==F=;98N8X752
/,*l(&V%$#%&t'&6%#P"3  )=eYln$3q8A1"$$$%%;$!_ 7"%Q)&+,-045351R0N2_5654677^5w21311123557T753q0x.Q,h)&$$%%$2#/!3>v]	2sk M?gpsiB+qT q|w_ TqwHilm1cR=NߏR*	g8ܡڃ٭|ב}fӘZΒ;̊ˢJN*k­L|7ƼԻźjz@0طɷfhRiķv*I\󻇻ڻ+9dWQy±Èoʆ1ҽՇv*h~okH k	VW-9"$&%'&)*@)'~')\-046F9;<R<F;X;<N>?@`BEzGJH~GE_DC
DD
CA@@@H@?=j<;;	<]<;3;::f9Q86R5O30-+)(|'6&f%%&''&%*$"! g7A^&u! F:$'(*))*+,h,o*e'&'+,,-0365,5.56636!5444L4Q31v/!.u.{/z/.	--30x1;0Z-*(v'%K#6 -	aF1 F>kR5NbC'Z(߆;M
߽1Oޝ@z!CpQ"
ܚۘځ`Wז#ҚBtA5˯@ʪɞaff]\e3㽶ǽ^㾕۾FjԿp=ĲƓƷƫ9tʝɿ͸}ի?հz(<2X~'y3 yh\?"$~&;''7((~))+y-04"67p77\899
::p:;=?@A|@@@Q@E@?>=>=<<{<+<;!;:T:e::::87M76B6(5M351/.-,P,6,,--p-,!,#+s)&
%%&d'&%%'(`'$#%''9&%'))S'%&)D+*);+d.0/-,-.-, +,(./.,..0	2 20/n//^/E.,x+**.)S('L'm&X%$$#0#!c (_8
9	# >>km
:o@|E
aRGSI/߭Oݼe޹ޚ&ޠ.'ܦܠ!ܑ۝ۅDVڳڇڣٱׄ'֯ս2*Ԗ@;҃6Gϣ..̌̑ͮpjʃʃdȔSǙƉwśPę6Ƴ{ľzƘ\vƮȪ`M?ʈ+h'<6Дҵ3uZ/?^<ٲzݹݣޠ]GX
ptFJ{sh	1<~W [!X"V$&())*|**+c+,-03433?56G64304f567u888*99:Q988.9x98%888=9g865q687,7M656|7(998655/641B/%/133R2e124U53 25113:320/o0000J00c111]210X//.H.m-'--M.-$-,-'.-],+**u*/)'$#1$T$R#! Z!!Z!zQDKf!q
4
=	rG< 2Hky|m\l0.{	K=	I޶G;W3>{ ڛڟ٦Bڱ5٩(כ/uճeN֙Ԓ7)tR/n[Ұ11$-ҫ#x4;Ֆ
dJچ-E!czv؍حڠ۬ݶu' 
JڙP&ڎ<ݧ޷w
,[#|0_R;3K%ZK>CMVh\@!d
gePogO,&!r"#;%&,''0(((g(k'&&&O&%3%%&y()"**I+u+a++*)5)(x((:)))H)((_(x'k&%%S%$$%,&w&C&%%:&&H&%$$%%#$"!!!d!  !6#$R$r$$S%_%$##"##"^","Y""`""!l!y!!!!!!""! q  U=~|J19)kB
	F
- Z"1\tvfN+!?zD>j4N0n"n3@  +pg	"6oG 6a3uWHkx8v*M!)zt~v1I{g,NAS~GFU`
A 2  )*XiS0o			

b
c

<J\j$Q/uEoj	VL|(
@AV b  H!K!9!t!!!!L!"!!  s i       k C ? :  :P.>qnpY|7E/~S)J

:n

	&	<@S <3HM PAdqg(M;f /^O&/3V+
b	9Xr6I7o|`DN5
"wu/&=w/<=+
K3D7G>puAoGC:DpE%U.RTjGo\3-Hs|1mbLB:c7 |  (m	VD}KcJJ		b

F\O

\r'X)s59y67(8 k``Q/d,9bKyDrD|TR5b=

W
.

j)g
f
		p	7		m9B'H
S6hI[v Y    V`l 4+U_I[
8_/nUPRc0	7C1xkV?)|wkG :^ub4|`r#:><Hk|]OZ[5
3dX-Ygg%`k"Y6GLAVDD@?r2 o    }@HpH1y 
D6W	&	f		5
Y
V
k






iPO

u
-




+
~


 
=Y/





x



g
G
A
?
P
b
b
6
~M!"#R



O
					o		9	P	3	
	ikG
X/v8Zc0+$<, M ( 5 A A @ E Y _ 7 z'f
q/tvzDgVf[+L9z[B3X*wwtya`=NwU'	
#[U~|J&&
KXSq@s&d _	6`
3{ + J n     'Ca}=l
-fp: 8mmQ"#W}dSH__"Q^Rq&oL}8Fkw'&3"Cv0\R|`_aCHr=T15dIZ[.  ^ 	 afsV&nE(
~J~Z3U:4WA %0;v!EYdq.Lix,AYo5g{7TW^&=_	&W6` J R X j    	*M|2MwT+6/ )-1>Y[P[g`WXXM?50+'7_Q,}+.1O
"15<Nh8SRIRv

/TqwfcycJ?/ kF"C`W*	*->ZZJ;6<HNE8T)3@)d@1R4,)
           S !    |oeH"9c   4 J _ n p k [ S b m N  }dL9<DC*2cnWA83%6OI8  mQ=4427>=1"
)4)	
/ND~hk~~`[dZ=&3- &9T\`ZY\ZNL^o|}gVJB?ESdzllz{1PeeVE@;7*$*.##:J^t&7CA2""7Pbm}}q|
     + . % ' ) + ' + 6 U r                                                   EcfSMWdpZ7?i~ 3NXcfciyrWJJONG,

mI936@T^]NF?.      ~ g \ X R F D @ 5 (     0 D T [ R ? 1 + +     ! , 6 @ ; (    1 8 1 + !    # ' + +      + &              ) 1 : 7 4 1 . * + &              ! : Q a l y v e O A 8 ? E B 8 7 5 4 , % ' 9 U h x      { v t y v g Z O E F L Y [ g v    u g P 7         
     " , 0 - + )    
  % - ( !            
      RSRC         [remap]

importer="wav"
type="AudioStreamWAV"
uid="uid://5u8llf2cyi3r"
path="res://.godot/imported/e.wav-e09d9cbe33b95a555aa8fe787a4544b3.sample"
              RSRC                    AudioStreamWAV                                                              resource_local_to_scene    resource_name    data    format 
   loop_mode    loop_begin 	   loop_end 	   mix_rate    stereo    tags    script           local://AudioStreamWAV_0wksx 8         AudioStreamWAV          po                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    
     > 9   *         6 e  b  V  b = H =  9 { m  <   C  E  < _   d  v  wl 1  X| x 3+N md5S.P|    -  Ap<yg* J v=z 3yi.% **, )_{?O
zfL   =  i 1\ dOrD= Nk ;4l 
$ ,  kKFu Z Ej b B$-
/
{5 - ]1 Sn[8x *.  P lR\ 0\  DX
   [v, 
+":{N6  [wW.^c oN}eek46ns* k0`-$k`t.>@ycLq[gT4diU` j=P26[qvs0RLS[@LB  |kIkO7xM ~ X zz$   q  e(r @d/_c.  A z :N t_M0cK tK[qPylh~z^  H_6OP) IM& YyXn
 B  h6 V  dF s
~
)F:(( 9iNFO,  MoQp%ko.i
+G"7!1vHq>"PgKxKQJ  s y
{J  ( z|:n6o  k_  @rWDmtY K H !  7   I9<  3 !Y"[G}x;a   >  L  1 0  q  =x  "sS&cf_)}"<x8xMmgWU  KOi  v ?qBTQ 	KW -rI  .bIG6{
EjR)L?3jsY9mL\x!XI$1z\TN_X(s_${T$X(LOaAb|;0x%vC<Cs =fkQeE#?]
kh  Eu%? +qe/hJNw p5x28[r   chuW9 @    `jG  OZpx x-oIT@Ls$C%6
D9 8 Y  i(ADgot3(.?tu/31u_*Ga\7v,f[xk`j!"~
ZJFRYdJ	;.=]'.KR=kSZZ]'~OU*8J4/-n>t]/Td\-I78keE. fa#5`"I7gal*g  q   &  > ^ b F  $ q s    J  tNx%gzrez4J\7bn[Tn~Ysgd"<wzRk$	o<[	XyvbpV+.7j;^lm"S,-fV" $K1<X.9@ s )   (  :  ' /E  +JF^;        c    O ?  l:%  &7
         N  	 
 * Y G 0 B _   w     K   _   n z  #mqMIjkC5+'Cjc`]&   [ \:xkAJ+()%(AN( RBkh917#?n}K tCKKEJ&sd :6	a0>,)`v$$&52Y9;uJ*$:Rob
Dx
!#2] O            8U|v-*
0Q3Mq
Zje^?	~
#5hD!(
6&3I4C.Zzn\Ec/5#Xi5]@
:.$*);ro8;mh1	~r6A8=G@7.|\c%  w l k J    % 
  / ] u w {    
    o  f{eC+lqwtzS;WuP]~F	,>FNC:>OUA,3GEhD,
9buz4a\%0?lwxQ:v4!&:f
*7Ni B q    'IFJzf         0@5R.27LcxwJ(%(!)=,2<gU'
4i}`0;A_vvk<10s:dP/		:YL4;KrC%c_KmaV%VfLhM^4e$.&!<>1KR51VsshN "c'!FR    _  < cS<":qFbx& 7 Y          ~ ] :  _
c>n=!ze|h
&.'<iwx Ei?&#Y
`DAE;!#Ebuw{%)&;WP+vp[A;HB2?Z[S^old\P@>C@0"ri_/()jb_1#! 		2E
'G8 
*5Niy8FS)5+&$&)	!A>_{|pjy+1


98#.,7('U{ &3eqwvW63PhO12K\t#| Z                s B 8 w   D # 3 6  5 v b   N i r   w R  $6Yt	%6<ToK>84 4M;oe]ub~v|qim9;`0&cGqP]u*,@!mov\Rv=:vvsa/s@xel^9a'
w;#>*M`;#5* vdC\rhJLW=`+#9>'   
          ?`Yi"- nldSBEYajrZ<264
    ~ v   T . 3 \ g F   ( 0 2 *        & *  	 !   zvc`}gw&8O/5&Zl: le4GNIj-?+~wbumC\Ts>]M!I;:=	#M@/dC#KnZC^vdC'Vm1#mQL'HNg_v_wp2;zqqe7G-rV5|R.
<$A=1s0Udl 4   I &  3 _ Q 1 I   j P t          .Rs('3U`AVM;0'E-sOaSjAFlg~~^Ctt!xpn4whR)	adg>         u 0   rW_W2o?tK }KsE MZ`(+#$veY,Td;+_|>D~e-9ZP>N'K77@BOjCV.0g-a#^w8I6'#@u>^d	4f$ 8   !aFz]4tHO`33`|6a
	Z						x	~									
			

								u	p	z	G	
		<	%	v|3T }Y)D-j8:V E K  ?7+_"5u)F$)q,E4Z*B>oW/.#	pV5]g
/^9|yA3X '""El/~Z0DKV5{b2k"S@' DJEq@

	|-I!"$V%&'(k)2**[++,9,,+++)+*Q*)6)(''T'&M&%%k%)%$e$O$H$$#{##s#K# #!#5#<#<#/####'##""""""j"L"2"
"!!~!_!A!!  A sjSz/Gj
S
	!kPY"~ AY7bwzr;j"npu Q4/ߌދbBۯKٯkצ4Ս<Ӏt8Ϥa0̥6@ʙ$ȣH ȹn+9ŜFĉ]	o'ܿBmRvYMƗ?jz # (!%R+m0*479<g?=BBA???;7540j+M&" 2U0x3Mo.uWQ9HC j
i 	)ev@
=s5!%'),"03639$<)?AC EEeFgFED9Bx@z>;9k630.,*(0';&%#E"x! V%-igod}b(
M
	uj8Q-x&4Q	


<l
kL>B,%
	iM s kgx+:a6 wkKASZP%J
o XQ\ߺyݣ;y9Vٗh׹'՛!Շ0@kYUɞ!Ǚu(ƿAE\
ݼBIi7=ZNo\iRe1Vm-q<˨[Д$CnseA%$')+.q2m5'778|:;;E8F532.R*j&"j
=		X




6WiU
>
)Vyx`,
V

	6PG
IHT^_ #H&v)C-0)3'5g7%:<?@mB%D~E(F+FEECB?<S:741.+4)&%#!2R>1Z
Z)aHK|
	V			
a#
n~s!$':(),_-G---x.:/-/P.[-,u,G+(%3#[! z'C	/SP,`		c	7/	$	U	f
%
B
F
	t	WlO^ Noa^AX2e:Ad59Amdݒ`>dۯۥngo-ڍ
k
eؔ׷ZoP2	lͳ9rHbw:Sֹ|Z1˸DH۸
wq붍ڵ
 z<l1ɽ͸ҿ=NX	IR #&(g*+g-(.-,+*	)2'L%#  lg!gX[

`

=

	4a{2

s
=G{2 R#&),/`2O58:=?@XBCVDvDJDC&CA@)?=;97531/-+a*(x'
&$#f"E!. '?^n}

^
{
,yc|a73  w!9!  r rKF

x	I&Rxad]d`KMJ ]gngiC"{OCMD\<  Uxnw%`b ) @!\
4oE*Q:S`Rnߐ2.;Xn؄מ־ BYч@!Coɵ5azYƬōhïKhE|ԼټƼ~T,ϸ+ѹ蹳
=gj¿&¹FŔ\ˋl_ۓ;Cp	<
A #&)+-L.w/0/.-6,I*'J%"] ga/@.y;X-g
<Sp5
o1 #5&(.+-]02F57:h<>~@4BCDE&EDjD_C Ba@><:8n6p4v20.2-+'*(k'*&$#{"L! |>0>'6d=Qq
aWA&Zl*|fC( Qk)d
3
p
	aSagj   OT"f"{g7
cq oEJdKkv2	۹ڀ|ػB֏=ԓ#/!λkǽƇ|Ĵ`Zܹ9F%G!p.Zȹ.;H뾠²ÿ-Tʨ1

_Hڎtީ7YhN)I:( !"2""##"I"_"""g! H W_/p	sOQ\yt@
[:7i`m "b$&')+-:/0V2 45I7M849$:;;;;;;{;: :	976D53+20/s-+*r(&%2$":!fA+*QXV?E-|z%Ct"@EH-7%X(%!c?*?WYI
9
(
{z/
'
	8	Ye.h	7-I  5.r[RJZi%M+cnEg,U]P[pT'z _ҌА>ʆ>!19ëu7񼨻ùsqW	߳DiNubگɰͱR3ٶ
EaM
MŉCɞʖDѤ8b.ܣjceEzfQ %fWt+ !4!!":#"
"m! 9 #7Z*d0B!dcrZt}oz"Wj !#$&')+M-.02467-89:;< ==>x>e>>=p=<;:s9F87531i0.H-n+)(v&$U#!W P<:-.NI92
vwEw$HJm	 !;""g#$R$N$5$$$/$n$}$#4#""B"!dhj w

	7Y;Tf9 1 Dn\@8l[PMF!WZR)N޽ݘlL9֪P!tF@<ȝǌrC
ʽNǷ]Z2߰S8$2ܬѬƭŭSDC-E%aS^,¿wƈȯmх|%O!D{ n}h
wyLTw 0"#%%%%<&&b&Z%2$h#"[!! _o
f"Mr'"zOi	!A[pUJM !t#%X(*6-W/1B468e:
<=?@ABCdDDDDPDC%C;B@??=;):,8531/-+)'I&$\#!a 	V7Oou`XE w`

t


K


eA5Idu7PG  a!""#<$$%%&O&@&&%r%$%$P#e"! fUZ[.w 8(
tO&
;j`s[R       z     y @   A\%M#IV=&B;3Ff}zhK(
|eW`rwv٢ӧҕw#϶|X5ɶ\򵩴A^,A21/ū«		BhVh[n鲻˸)lŪ)̍ϣҶ)82?	J$"]QBU]V=zX0}OB`^X9;CE!"$&(*,.024m689;<=>?AAAA?B`B4BA@3@h??><X;:865|3
20.P-+*)~'&$#&" ^`uE5C"D+wp~2+?]D.,O|{^  >!!D"""""""7"!I!!  \.z.20Lultu;
x
		
x3     ^ b       p e ] = h@![m4j9D+n@%޷jc:׵ּԯӑrR[vd/:5!jşĞç0Ѿýϻ6
;lmXYѰ]ׯ鯢0F.׮k*X®mM)ԱdkҷL

|%ĭVɒ
hQI(
r?}!#G$$%2&G''''1'&%$#!a W2fn?<-l /UqM0IgeRE "$&)k+-@0{2468:<=>&@HA.BBfCCDVD$D}CBA@~?=<:9[753620!/-+j*)'&_%$"!X ;sO
0x
V
		i	t			L

s`%KM/"$$',//>,+./-0+	*+-'-*)*]+)~&=#!$!p#mhd
r
z)]H-`;'i.h35 tw7A@.6{~v5܎۷2ّ?ָu_ԃCѻБΩ̤ƉjX پxOIqӴGf)Ӱ	^{9<خNM2착'ҶจG@wS[.Kt(&fxcl;'8p
S   \!"#_#""Y#~#`" T7{-U@3txXxrE|<jYa/C !u"#$%&(*\,-1/03467C8}9e::t;;<"=Z=2=<	=0==<;::-97s6$532N1 0.u-T,g+i*[)M(?'C&%$#"!+!^ AlW}p:gU?GJ#2Ou "6"y!!"##}""""="!? , B3Ay

	\ym=     N j   U      \M"%ds;]`i4A3hO=ۀڈTh&ObnhKV~rKQul8 ôfylɻ;w?Ƿ۶˵xSjɵ浘>/۵IٵFVxK8o.W6tY
Xǹ1̔x
ږB] PpB

8^  e!!!!!!8! ; <y.2\GI
]"}  <!!##$C%%&,(i)S*+5,v-./01/23344K55Q666667#76665254;4Q3f211G0i/n.~-,H,+*))u('_'s&%$o$#"!! 8 Zl{H($qpo !!!!""L""y!  h v,mNTM

;#G
 
	d	f6'?0Mf, ) ;J{+v,GtN[
niu5uk޽4cۦ$ڟi֡պԜ]eѳ}${ˊɽǮ]+Emux黩DາGùO/:94θbhi
f16o2rpDͦϫ{#a$  !}#M$$#"$$$h$#$#""j"! $ }
\#%2@ZiCa D z   w!"t"""|#z$+%%%&'()k*+,2-e.A//0`1<2333445I5&5445#543@3%323210O0C0/.-
-,d,++Q*))M)('4'&&%%>$##$#~"!!  
 P:wL	StYQsA!"!"#$$%i$#$$g$p#"y"Z"!b cyu.!@


		u	S*6WxrgS aXGI)\sY,<DPv7wkބޢ#݅ە?۟c'VԪʫ|klsńĖü88mο"`[Dɽܽʽʽp
KļνmؼrüT<n~Ml_k̦nΣЪ]5آٸۼM;O<~b()v T% !!`!!"@""k!  c!\!n o    J v=    L }  !      1!!!!:"####7$%%3&L&&'())-*+l,f---f.W/'00000G11Y100|000Z0//....'-,{,K,+**))d)('''''d&&%%8%$#Y##""!!7!! a >zbg,   $&*&#".$%,%" x g!!L  w5$Y{
Q0



'

D
	sr	o_	sxh"6 S!3BTr0-{6005yJ gUߗ/ l|ۖ\K&0؁#ӝ+ҖЗϾ bd9}5ĉ"
GK¬ȿؿWվ0,axAۿ\3uڿEt¿myN;Ƶ_Muњ!+SlߗX
3Aw<%	 W
!AAqdB5vkqR{b+)<p & & h  !!}!s!""#1#""######$$ %Q%&&&&1''4(f(r(())**Z+++b,;-.Y.M.k..>//p/(/./Q/S//....N.
.----,K,,++C+*c*
*)$*3*)b)*)i))(#('U''&%%p$#>#v"!w!!!7!"###w$&'x'`&z&'(q'n%]$$x%$H#""! 8OV>|~D0 D'
{s~
cy

F
	G		Wac' @ ;SW[P,:a\(q|R)T/I>`ީݏ=qI~5Ӆ5iή,̝4ʯ}Mɪ^fuGǮ%ƺŠůŜ>ĄĚĲ| ĳÝÛÏT/ÁfOä$^gĉOłŵ"Ƌ,ȝ	ʡʠΔ	ѥӜ $m_%^YsWpE

]60 =HH
V&A2?C2 G    O!!."^"N"Y"#$\$##$"%%%%%&8'''''C(r(P(/(U((((h((#)C)U))))*C**=+>+H++n,,-
-,-q--d--$-d---q-\-p-J-,z,5,+}+5+*******?*))*)m)"))e)*n,^--.20z110E020'0t/].Y-p,+*+*I)('&~%	$"!j #~(X)nH5l?e^"B

L
	99a5 zBJ
aF@[~	lQt/|AYGݒBچDբ9I}M60ю*СJп&Ϸk"{/̳r̽˄Iʞ^ZJɕɝɴZ5kn(3ɣɡZɖ4ʄfi)-}s̰=b^nрӐӐF׼i١>;J
fqo|_'!>;m#a }n	_
km B!0!!q!5""K#e#|#$$$%%
&=&&V&E''''}''((?))(c)***{**#+y+J+**I+F+** +&+9+[+++++,,=-K--A--..N./..///_///00////K/.k..-j-,l,,+c+*Z**)8)((M(''&s& &X%[$#t#"j"B"]#%''"()G,-s,Y*u).**d)&$&$($#c"m! Uy&T
k
{

F
/ER NZygRo`2 bjGhc$u~Uܲܓ[Ij"}ځ0ڵ׭Uֳ8v!oъ"tμͲ̊ziEP̪-͂wECp̈́C̱̰̺̻̾$X͒́ͩ͝ͺ́?g͝	ν$FV'
П7[pҥӛ1,ؾ؊hBݰv-3"z,k#GK`&(LE}G~- FSN	
S:#r Tz`l  R!!""""#h$$$$%&&''X(()*u**+2,,q-...|/$00001+222t223p44=4544[555(6V66$7;7I777&7666666S65554s4321/10U0M/2.g-,p,++#*4)( (''h&%)%$#x#"="!7! P   E\d:X)d



>	\kx  +3R=*StM}Wv|u4*V:Gr߸bݴy&ܠVۓ\گڞڏ]
ٽٯa*>XP::5B٠
#Igtړڷڨ}tڜڪڑڟ#Tە=qܥ܉M
A߃߱X~
T|t<N*HngZRMGKr'xII g t 28@J-		
,
j}Y*G9(m6wlJr
  !f"L#!$$$%%&&7&%!&&&&a&l&&'D'g''''c((((C))*R*w**(+++++5,v,S,+q+&+*{**)((>('g'&&%]%%f$#/#""9"!!  5OL-' suH6
0

G
	y		r
t2wN T [O;09p41<ltzC\qG#=;RxH]E.	`R;l6jfd;	PH|3JPTh{>OTv6m
QWz>|v"	pc.AxB%m4TCw~0Lmr _!i  *=Lx		)

@oF


Npb3KJ[D?4J?=z4b;#{K=RSndC2r4[DjB![GzDm5 obU|9

v	U
M
		>	E~B(8Tz<* B lWk<Th?)k"Xw9&FLm@]A2
uDVQ"Gm Ps!R4eZ<+qG%(u!c25j
=9*  CDkO5J	U		h
2
J

y#:
a8k
o[vp

j
K

C
O



#	

V
p	PHvT
!
2
E	y	
I
6

h a


S	6Hp9	OV?	A8u	km*[t3TyvwukzGAYS_  
 C h Z  qP.IwyW&(Cr?xgmoxMiwZG@PowLiwu`}S#&ED<85'bADHZ}$%
@Q1:^,zxvrzf{[j#0@l"x6+S;_ O V [    %Hpc3EmLr9qy.u g:`VIShz	$	&			.	[		
R
}






8s$MnN]

 
.cq5


!<`V









+
	a		t@;GMI5w	^e|LwO2*%]W*l: S g0wB{aVesP
l6Y5!Mq/HknUD7y\LKJ8!">ZdW=  BQ]t.Zz0-!.ReYADs(G\V82U7Yw}Nrx{ ?]M@*S|  $ H v  FktyA	K7fsty|1cku%;Oo|V"$
#)P
!vl`XZfwA%6G8\/z{}rQ<-6MC`;       j J < 2 , ! ' %        - )    {LjF\/	         
      RSRC             [remap]

importer="wav"
type="AudioStreamWAV"
uid="uid://dnk2m4y8r5dm"
path="res://.godot/imported/f.wav-b99f199978ae6fafeab144ead0ec4b84.sample"
              RSRC                    AudioStreamWAV                                                              resource_local_to_scene    resource_name    data    format 
   loop_mode    loop_begin 	   loop_end 	   mix_rate    stereo    tags    script           local://AudioStreamWAV_sp7l8 8         AudioStreamWAV          JC   	       " ' * - 1 4 7 ; > A C E G K N O Q R P N M O P O M L J J G D ? 9 3 / * $         {k_WQC9.
ueO@>:0 xmc_]`\QJQRLJIA3/13::959>IU\gpw8EJPZp2Nl	 & : M d t      6N]rAew{5Uo 7HKZk|2;:<@CLQTTT_cpwhXQU[XTTSJB94+qM5) gO;{Y<sV4   { X 5 
 pM)_3rK  kT6zaG2rV;*!ziZN@0
'3<FMQ^o #1Oeq|6Wz!;Ut9b/^2Nw" S    Cr"Y/c!Is<c=_8KgGr	;	P	_	l								
"
7
=
5
7
F
W
[
^
h
j
f
^
_
P
J
E
J
H
A
6
2
"



						n	V	@	)		xZ8f<[, h7^%O{@^$   Q  f7d(^%V%X#}MZ4
^>iXJ.p_WXYH82-)-*"%(-/8=?ELITSPM]ntqq{5ARi;]}6Z
/YAlJ|
4^	6bG M   
>vN
JX(fU6p3q	*	T				
0
K
l




 @]t-=KVdv}|qhbWD(vL,


u
G

			e	3	}=\X[&ZH^T  A _VIo=
}5Z,j,m@L~X-|U6sL('2:GQf:\w#?b~ =jBl3g'Y?j?s+h*`<D    2v5s!f)o5r58r(c	O	~			
G



7f/^
F
h




7HRf~


r^A"


}
U
2
	
y:`

s
=

	~	7	p/Kr&`t7HNt3  O gqmS{0f%p7c*c5	wM'f6pK5#rg[O?0(%&1-&),.8DHQW\^ahnz1CLQa0Lk?f6e @`7]7k%X;X	CwP,c M    5s/tH3p[D;u%U(	X				
A
q



Bo3Us
+
R
p
z







%.8@B6,,'






^
=
#
	
wW0@

y
C

		X		c07o.MfDj I l  I^KSf3y8g+K~]7\; nR3}fO9(& *76>Sgiis/Ru2IXo+;Sx-Rq4e	/X$S}2dBq?c.k H s   CuI!Y9XyJ{'a,T
'Dg	/	H	k					
B
i




'=W})*%"(*.0)uP8*"



l
S
A
1

					V	)		T! NId=l1xI&o(l>  o 7  ^'b/ b%Sl6h@lR7}lU4uY@4-'}tru+Lv)6Tou-Z5b "D]v'Hf&OzG@~ 5 ^ z    -GZaw7m)e-|I5+O6	_		&
ggTB	*~

}.
y3b<DzE&W5 YP
!n
	I
j6[$uEb zM}    z* Ib**Zcg{M}'+&u [B>	B	(
ztc
:zCvGAqZS?{w`ks);)UlڋzkCծxܼ G82eMݕQD߇e^y8"6AjWNIM3n,.i&}$N6{c|
X@!)iGu$$r7

e
;%[n}
I
>L0?xL<}$.$d>s  I =  !"  ""C!O"&-34129><I5..M36v3Y*##@'($"&'K('q&%f$#
"'9;;T<S$! "7=vl8~Pl  :N14 g_HPoc a\'m(8iߵHXU"ޫخBz|ԋpn95g͎J3~gjΫ͌ζοϫ@}_̯̄+y1ԇԉ԰aի֒זSLۚ	WDn>i^zYYv-K



YdTr!  #(+-I.h1F56J4/+@)'0&L%%(,9133w334s54R4 56887520/.$-++,-$.-2-,,,
+)5(K'&%%#R##N$$J$t#i"Y!6 1bY"SA$"
HB/L.
E
					U
"QW
l	xJ ~wggURDsatq	ۈۖqI׎ֲһѵ+uѡxϛα&̐ZJΠ#͉}͢AЈ\'#Ќ`dеюQ?MՇ֊
Be0ڍIۜO߃x\`M"hnXrO  Ij-
H
6['E   
"L""M$&)H*+**o*g+,,l,+g,-j.&.-*./r111233554"44o688879::988$8777U88889D987e7w77|8888O8$876565443.322O210%0///.-,Z,+F+*)s('?''%&$""!!,H/Tq;]M&
O

Y	L
JwT6 MxOe.+f(=	)td1CU~Gގ$@%
ھH.բwYьUЂϽ:SH2ͦlOi@&ӴRٕ}(df˕)e.ǓyM̬ΤzˍQ~s4lʯ"&a+ŨǖoƨcpBωϤR-n,ʖl%8ֶ@HEG(!1Am"2k`j
~   <!"#s#$u%%.')++*,'/13<568i;===='>>> ??>%??&>j====;\;;;$;l:988F7m788x76665320/~.-+f*(&L%#"%"!6! 2!j""
">!-!~!L!_ YX>*[9r  !L!!(""A"!!!("""Y"k""##$$%'*,-.t14`42I0/ 0/-*s))*S*(&u&((''%P&(V)(t&y$##!sa
oyu UCIVC4޳b;[Ԫ^9Җ̀Kǣ(.FI^X=xܴr3|0mcy٧>*}ࡰ\۞jޝ^ϙș Kؘ
ӛd塓ݣ"p*Fg24UTԅ Ph	K
`#{ 
$&Z*.39=@<CGEMQ!TUUWY[][[\s^`pbccnddd<dc[deeee+e#dc:b`^\D[Z{ZX~VTQOMcKfH(EBA?=d;8Y7T6G53E20./-,+)'J%A$)#! CulGmFUMT !"}#$%&,(#)j))*Y,-./14678S;J>??>?ACC CzCD3FUFE{EE]FFTFEFGFDCAm@?=r:n8B7X6d531/'.,*)$'%" 
eS2
wg$
	
	rVj{ = m2hYKh 8({O
w:~e4WOo<r~bBFJ#`Jž,~mRɺ기\G+iܠʟ_(֗Ao&,So^hx8͂
.f(扐<s63*RьՐܑiRj#̛}GןͧխոXýMƩbp$H=WA 4$'}+1:AWEkFEAEEF4GFEFLIMONMxNPQQCRARWRRSSR2RSUTuR(QQPMItFDDCCAM>z;O:R962.z.X022O3321+1/.-A*(x('n&%%$3#!$ `  !#&'(r(*i,".._/l//02{44457+8797b77188>:<=8?@AA&BCEDBACDcCb@>B=j==;v976642e1 1_10/0)4&7743565E1,****&!3$6fXM>OA33=

	:*"	


Zv)	'	x	+
	q eU{7V
S%C2z<}͝nˠƭ?}ؽ7	ǭ.Ty4šڟÜљr˖ߖ0krΏЎ%JDٍyߋ̍ȏb5KMJ嗤8
MBɮt&MϾr(
d&e
\Z hg4Gk %-z6=
ABwCFHHhHGDH)J`MOPNKDK7LMBMM3LGKK/NPQP1Q|SUWWnWEUQNMLSJG%Da@<:85/a*a'b(J+\-.>/]/////o-)b''I))(&#V!CS)z!!"$'+-. 0136s9::_:];<d=H<r:8779';<=>>\@BLDHGIQJ"IJNxRP=JFE,EHHD?)=l=E=;87k:[=y=;E<K@nB>60/01{-(K&&'u&8")F{;$kT=@-		
D
1
	8 7 	\+#bL(YC sV_vzlo qQݙF҈е
ΏNʻǔŔĔ%^eF´6٬fϧw 矣9\+]v=sSP.gPk;O.Lw<홋 Y>7q\4}壉Xإ岄K{Е)+ ^h-Gji#+H5;=<<@!D"EMCABEH`JIGrEDDD DBuA@@BVCUDDPEFHHJ-K}JqGCBBA?;%61,0A/,'!5 #{&&X&&'()$)\'%x%&'@(r(9(&# 4  b!u =z+"$q%$#%.*.1124n8;>>>K?t@]AA?&><;::<=>=7?BFGF3FHK{LKELNQ|SSSRpR(ROKFC9B?^;64564S0K,+L./1.Y+:*-,./O-)9'$a!z
2
]
uM
-	}U5&
	
c
UH
-'1 RU\
tw>??!QݏkV
\lҊWͭ2*ìG22ZJe9gtA铌]T~E˔-/ɛSq i)ޜʞ3ܡyz8,N_<)4*E7F@&

:I#\+V5#<C=;&:<`@B>B?F?#BFJJGDCDDCA>'<F<=>(?D??@?ABQD/EC@P=<=>=
:40[..+%P$!S$ %$ #k#$%%#""#o%'_(g(&
%#($%$#"O!2"$&'%%%&I*-)0013s7*<?@ABZDFED3C+BAZ@q@kAeBB|CfDE2GIMO(ON<P9UKXVSAQjRSSOKIJINGCAA=AE=8u55 6j3.++--+(&&='%"z	MYT?jkG ?>G 1LHu	]:YpA,ӀRVUʟ]]iܹ1ð>֬ϪǢ#@MÜHϖȕy1͒Kԓidӕ\sT̜vߟDġ򣨥5ਦ4iSi!Cwc]<  =/ Xm	

\Rz #(09<;m;=AB-CCDFIBLL}JGFEjDRB0@><::X<<<<s?@@3ABpCA ?=>?><9!6A2/R.C*$ 	!7#|$$0%%:%##R$$"i#%(*+,-,*W);)O)(((('&')(&U&(+-.^026{9<>?"A}CE1EBAAA(A@
BQDF HHLIhJJLMMKKMPPMaKJKJIoHFE0DFDC+B?=;96420\,)(o('&i%#";!!g %Z5&yH"F	b2,R6& y8{ICf"$&vWu,Kc KDuohާBnڪd/JԓџʘB1àzK/VZߩ}uѠ5)ЛuȘڗ>-|mvʞݟe sP[oΠ/#ϧ[PíӬ+ح~U^ưīٓZ<b: 
<9"C+2l526r7:n=2>>@4CEHLhOdNL-J=I]HEpB?=;S<=;>=<>@ABCEDCBBEEcD*B@d=:8|61+t'"'}) +-*)((T(((&N$$&S*-#/010/{/0.^,**>++,K,f*'/'(*+C,-0377;=O>k>?=BGCCCCCCACGLLHGHJMhLFA@%C]EGKPRRQxSUUoPJEFHIF@:+7x5*41-g)%$(,,Y)G$  "!ymi=D


@&[N P/O. o p xr]39 qD=24J{rJ*?ٽ՜0̗MʊsO||?uU?»]񭸭@~ƣAF&[z]5'?ʜ(bM[8\򞪠>`)Uа|{xim(j8r޳zlܵ#'DR
 Y2v7
{)+"**0p2"4B7;U==0>)?AUDtGJL0LKKJHFC?=<=>?>?<BD@EVFGFFEF6HPHGDCfA?h=:75z0
.#.,/a/.8.--1.	.,+))+m.V0234U5v5J5P42`0.@.n.~.L.-,++,N./14E8<A>DEGIKM NN!PQQ
PNN>N<NMMxNtNgNNNaMLKK4J+J K6LBLJYH8GFEpDA4>1;9S8,62J.*(%#D!ie^7UC
	Z	k<z.;5cdA]!a:Dat:SRV	Y.KTA>Vrڧ`ؒtQМΑ3exŶL4'T/C#FxR\vУx7-8릈r~n"s|˪$24:ׯܯB`ڳwI߼"q_>˻żj̾0EhÒÄJhs<bSF'
xo
:EUm$,/?/o./t3y7!:;;;i<>HCGI/HFEGIIGDFB.BCDDUDCC DEoHIHFEGIJ
IEHBp@@A2@<7567!8752q12B32i0$.W- ./13{32_1Q1233Y1//2}6-8778N:.<<+=b?ACF[JMONNO_RQTTSSWTUVTFRPNMM MLzKQI:GkF	GFDBAp@
A@8>[;8|6z5J42C/,v*'
%l#4!PY9-
z	^LW T3xbckW+.s#TA:	S4gUrn	 MTBcKB޹vpL+mv\ z2uXfs+"$A}F #eЫCJ.íI#ű·
ݹ.FO fh^QG}2Y@wǑzǵ_?Eɹhzȓ(Ɉȇc̲]˅F2Ͻ&>1&+z~6:|A)#)6,+>*+304665
79 >BSCPBA0BuCDDNCmA@?hADED-C=BBDeGGFCBFDFCGHEB?>>?Z?4<D8a6379: :97656q76F54C6d:>3A@A?>?ABAAACDFGG7G-EBABmDEEDDvGoJKfKICH5HIIMJIHGHHIIHE|BO@@?><:f98h87531/...-+)6(''%"cnh

*5  4gnvLVec*=.'8@4X
6O8m~ߎދzpۛ׻և`qӢҺ(gαͶ̔v41=CkT`ٽOUV*ۻû3b#J-ܿ?M{Û1TbƵVfɍʰ˟+ϰjѻҦFԿQՏ=OO\׫إvڟ
hہۅeڨܒ݁ޭއ߂)vI&?n T
#>-

KtIIU( #}%%+%%1'
*++++E,R.1j2223W4e56{8V9M9s82890;:87r6G79:97j78
;A=??&A4BAACEE!B>>9A4CUC"B@3@?J?
?>>=<;;=x?>;9];>~@O?=.=>>?#@0@{?=<<N;9:8V75334h653L22q3332100120.,+**1)'%#g"6"" f!5|mN%Dk
0y[i {-mh~)*/AOx2(9yV>pg @Q }}WpTڬh19f/׍Ռ$Ԕ|uhL;ԁҟYщ6Їij`&дRH|ϠυbZSdϥq(2Iiϒϝ?/ ѫ!?BwҦ2ԁԨD4juPxy٧ّDcܮpޗP/c4+7;8`#80lku<7S6 / I X5RN\			s
OA
R)Ep.*r@%L&,r !!o!! !Z!d!]!!"H#d#m#+#"E#B$%Z%%%3&;&%"%_%%%%6&&8'&%O%}%%%]%V%<%	%$.$###$$%%$$&$w#J##$#>#"-##E"f!'!!!!!J!! F
NU9
K<]jV4^mKLKMSd	X
&
h"
0
	r	{ h+1gW
X (o3_4sb-_!d>",!<o+6u3*uk:N NJxh6yQ_u7\P)#]r,G\hYAo#;KfOdA'SNmYsA
gw-@[eCfH)5;1=<	 Y d Y   3F1*n?{qB8Px& 	u	y		 


!^qU]`?2u
(
*
m

Y GhvNG\IQ#BpVNpbL^mAnK#f}dJp]`Al.

o
l
}
~
_
)
~!|G


\
)
	2	dxkW!h"  ( l - EjR"Di-(3\WW72&!	!57pg\J4#GaS:'K!]o
/B:Cn
HwuI,C{"(=?*
||',#0x~@(Z-HH9N%DBQ'AGwvN!TO!5           
      RSRC [remap]

importer="wav"
type="AudioStreamWAV"
uid="uid://d2ah6qaub8l0k"
path="res://.godot/imported/g.wav-47f645a97ddd2471735cef38a0cc3424.sample"
             RSRC                    AudioStreamWAV                                                              resource_local_to_scene    resource_name    data    format 
   loop_mode    loop_begin 	   loop_end 	   mix_rate    stereo    tags    script           local://AudioStreamWAV_oaoi5 8         AudioStreamWAV          S        $ ) / 6 < B H N T [ b h l p u z                                                    ~ { y p d ` \ U M E : -         uaRE6&uppdZRSRQJE@:6467642321278:8<;81.% )4267ERVYZ^iu%,))/7=GLWTX]\_ZTLHCHRUVQNKBHMNX]blmkotu}  
   ! 0 7 7 8 6 - ( ) 1 1 - , $         ! ' + 4 8 = 9 2 * % % ) . : E O b t      .MjxfZPH;248BGPT^j~
'8CEFOX]m ')
tR2 
	
Al~yjP+nT:*''079;FKb+Kd~ukll[H;,x_I:'          } g K , 	 
 $ < K O ] z     
(>B@>8,
       d > 
 vo{mD g@-He{za:
%(
,L]ghiqsv{dTJ:4-33%#-9BPWblns`B;Qdt'?AAFJT_`TA"t_V`ee^Z]dm	#.501Vs $ , . 5 H h              .BJZwq`OAESr	4KJA2vjhhaRD7!	  :bz\M/     m Z ? , 0 K z    JHx
	/890,.$e-n) 9UuurwX3#:V_TL?:Db9|7[~e5
l>{^8(980+*!   @`s~thY@)
         n *    ' '    viaurB$!:Sn|xkX0
mB .UytaL3,+ K.G_P?+ P>k}ua`j9>(j`lb-scE6MUOJONGb1_v]XaT0'GDEYbmk8FcG*aFl,~Gz."s6^b;ouE#q2zWC^vjsDN1`EO"OW *GWK/%U2)]g ; E   jXE`AakjlG  M1YY6R]H$PX+DRzW!!l;0=4h5Xt `FN		
-
5
S
{

j
_



V

	h	0	+	D	"	gZ 	W	o	d	N	8		NmT	~					K	=	d			U	,	%		s_*4/w]bPI
cW\Dj#N/xzSf>3u X  ' k  AJ9 ^ P	$t^}-	lrD9ePY`[fKT@17 GJ3//_a"$4c`*qB#13ixP]p88`QvaT:xC^o7g#n+ =''yI6P
X16C3 /--_j^p> e D m=+j)   I F#j9\He	J< { x  &C`t95dBE       "JU >oP.aD"#Zr'/W_pKgO ;;} 
 kFBnF/V/uh1hx+T V   <^NAf
f$@oQEpVD:>b \ H - &Mi*d! t      y  N?/ D  dJ7-$wK\hV%`yUkoH-  V:6fQ  7 sg~~I'@@  Ir )%?):K0  M 1 T     / p!*R>.N[.=D  cq&\d?;o v 6+s]ql1/  gN J? c  FYf  Qx_c
@Zt
a$JQw|c R mvW0&   ? [y0I"8E{z5seLQF ` {  g K  iQO9  R  *G $ 3 >O#M*t!	0E \(2T  Q QR;r(5GjH	YQ( fg  E    q   ?J+     X  5Gx4:nmHZs e        @>7<NX0 t j &  |OOQ_3D@e  / rQI>]q|0A #  [  m g5 
 `4C|D}A3L-2Pphpyy#GIxx@;'2Oz'})d-_ZhEf
Iq[uSeJA(|DGo;Z
iYYhGAKk
F7EIs2h-8{b u r}hbo&OyA
EIbf.3M ZEh   z g#9`ay8V-}f
M4[)32* s   S{nL@_rx5R%|ydEzQ@ 	BRiJwr\i
,XULXJ[
Jgq7e b  NYF\F d.]4st%vC\}  Y i  b>+hj.+Qn#1AE+Ds<2k7n :a  L	V;=\<\.K	j<9VF0YI I  6%^5		e	
		'y6NM24W;N.)v7)4*(drk/YWVK \|:J) v  )5& 1R  8  F0c
H X   b H j oD9tj\iFM E <) 6; { h \L]oQ2`jr le} f_-A3 v~$pY   jPK DN Qt !$K*.89M@HO 7}7IqY/!h'    G 3T6E?M|_1Ri(yyYbw  ,  {2vv  u e'2vXQ|FS"#q&M:#fu{U } J ayap6D.  1 q0 e o 7+ U6_[zWxIC!nE" `~ W%sTEh}BOE D  !2Qp \   YN\] LAf>n45(
Ap'p`uV )0;!0" s |   v 9  U tyhLD $F!   ` h  "Gr  A
G    :r 7  ZH mhCm$0kd= q #t  } S x Kk-ng#`e6oFFLH   C  e  b w  J )  ^@Wx$:e9sNfD?V{)s06jf` L xqvh6q;RN/qU			mF	

	s		
v

		e	2F2{A1	
 w!0B+K0JX:E[0(\Jo'=ee] s -h; E & a [k !
  kev<wS+CsmTff#  12of+r^SQX7JdV%NvF*b*oX@nL}uEM^>-!S NEX`7<z3a~M8by	 

		ePW
R4adyfaOZw<~	(;Kj !!!!'!!!>"!  !!!"!!1 u/V:4rrnEMNC:l=30
ut=n
(^
	%U yh(z[GV6'2Zd>B`:Ux݇aHSڵڐ؇FU֓Y+՜ԹRY<1ѡ
ψ1̹˒x0ɎgCǌ= ľΎϴ~d֞ҲiΔ<O2T)1ͤg6w҉!#"ڄۏE߯lSKdt ju	03B[ %"#$#"#%$$##c$%%$#$O%%I&G&'(K**+$,+M,-q.-h--/01&0*01R453*2z25$87,669h<D>c>=>7AqBuB}BBC"FG3HHJMJOOOLNNPdPzN<L6KKLMJ'HFFFFEBy@>?F?>=::T:986M505)5%4y2	1j000/-*%)A))'?$"X"g"!p qz8]8=C
z
%%L {k'Q: F!fs\ccm_5ЩGNιK͒5ɦ[ȧƌ[WOsdKhĵѵ1,ݹD}.d@kٰر!U	MƯW$8;"&I0ĴsBְڥ-ibTf
SZELl!$$b#"""#$$$
&'(@))o((V)(&#e  "#H"p!=#%4'&&#w"k#x%&{&/&')+-K../01F21"2356
7_78:;U;h:K989!:99:a<>>a>>
>=6>f>=1=W==y=<y=>[?!><y;:y9766J5443o2W1_0.-+C+**))()n**)(8(()('&"''y((C('Z'&%n%$$&E)c-010J02675O3G478a532a5640z/2/-*&m#1"! =Q
w
`	b*l Ne8%+i{_ # 4wy,l.=bыͻ̹˖KɼǍDƖĎ~C{o]0öᵟCzf`\Ȳ28IӬħnbХǠA/!#{&pҟ
t63KOϐg+ڏyK&+`ҳ*ȣdxjO&
.v4+# &&^$]##%=&%$P$~% ()(+&8&(+v+++~-d/00/{.^.o.,b)a&%&3$"!
  7 q "m%:(;*h+	-/3l56!7>89>;;;L<=?></<<==p<W;l;u<=>>
>5>?|AAAQAB8C+CDCCbCBAA2BHA?>=E<:P9887?6643221/.	//0.-7-b----<,x+*V*)('K'&%$m$$#["  mGC!$'((^*,S.-,++./.D+)f+.(/-,-A//,-*L)L**
)&%%R%>$"!55aud
k;
`	QN&3*9$		1TPzrm3]Dp4=߃ޞރݾڡNo=)ZX̪!ȣ}ƤNNֺ_]g)ʦ$ák鞹l噚Q֔j;5u:Аw7(F94BǆS' Um3ƮH|uu
 &)$+-0{20.-*Q+,^,&)e&%&'^'%"!a#%1''(*,-`.-+u(&$j /wSJRkl

U!"%=),.^014K8:;h<e=V>l>#=0;6::;;::;=??=;;==/=;;<%?@A@AA"BA?<y;:B:86:5'42b0#-0*3(<'&#!  !" $6)cc{=x ]$'i+.1457}9V<?C6D@DEGgHGBECC!C@6<L7n420,8'" - _b$
k
!
 f % V_zW4qeYoNDy1ӉuvZO[±6)j@ǳ̲v𬣪$]D4W5HIl"Ԙ|E\ǖܕ[ 'Ex[+Ĵԇ%
;
)_14-5v45 99p4%-*,)-(`#!   : 
XA!%&$/'+p..-*&d%%"yV~v&.
:#(+,-]1E69::|;=>>I<:e;=>=<{=?zA#B	A?>M@[B\B@?MAzDtFlFE8E>FjGFCB@E>d>m><:854?41-W)\&$T# PY|iU6F"6^ Myi- !$$$h$<',;24(4p479:74Q2,3t31.X,j,-+)*'@%$"Z KY9KNkx>yBJ V(UZVsU*N^mݭ6y՜aNќϳ5K˹6NǈYƮuYńcn,-(Ȭf JVL	!~5=\%) <FK'̑Ώ;B[ϺN%-G5888:;=W;6_2b0!0/+'$$#?!X'	!U#$$&g(+.-+n)'$&$#8IB@+0c.c2 gquI ,q -#&)a.6368:{=z? @h?>>+??w@@5A*BCQE-EDBCYCrC
CHBAsABsDEFAGGHiI:HDFDiCB@a=:88535/*|&" M}0)T

mb@j`x !##$&)N,E./14789U:<;*=>>=<
;v962.,4)%!&0!
		'THdD-U"K!V Vnax{#ߔܲcXXνSJKrșǼƾ4bLTܫ>TbdR)+ףBĠ̠bǟw)\㝧wF7ޝ (vL\iТ~GE	x#(c-z1c5089::9-8%6341/,Y(%#i!Qgvf~!"$d&&H&&n%/$"s/	2X
4r b-nd #'+.1q4P79`;<<=@>>?@@BCCC	DEDZDCBBAAABpB0CzDEaFFfFE5E1DBs@><:8520-)%Z"KQqjNH4#
i:
d:QHsKB'F"%'*/95I9:;>\B
D_DCCE9FEC@>!=c93._*&v#(wknVq
f   a hndaE/E=W;,h >3   289TW{e}sJ]%pDͫEʘ]~ƮĂwY71̲+RYP^Q=lͤ=/ڢ=H	¡ӡA7@ʢb^T9>äBĢ֤ĢգC[
տFV
5t!&o*A-0m234e2/-F-,($'#"![R!5" ?pE?w	

0
$	
K!J$'{+.13N68;]<5===>@@@@BgCCBAAAFA(@>@>>?%@?@@NBBuBXA@G@|?D><:9o7530-*r(&h#o ],Jt


)[
D}- !#0&((()m,/511h3A689y:;;;T:8P6542+0=-l*'$!VB&
p
	F or'H6QF<	0v!%OnZU[BchI?ݫ܆)ڨ;׭ԝC
ιU"B<7řrG&ظ""X1q:o0^z߫ӪB QpRZ:WƬU4%J%a=X '4ڭ߱ӳh|Hˍӈ*pz~$$)=+(,Y-L.E.9-@+k)D('%$"<! \
 !n#$%%d#!!!fu-}8^9.~"!#&(*,/24Q6j7X8=999B9888
9*9>9]9999J9w877b8m88/8W9;b<<<====h<:9l9z8642V1/-*]( &#!Qk/%_|$(7 O#&&%(-/-Z)4)-o10.U.}1k5w52M1a121-\*!))V(%"s`KK	2
cS<Wm B
: *c>QN4bsq75n)uU
H]߀ݳe!د՘ӛcшwfοʪBg0f(&rٿӾ%*ƻ}̹=fض(;)Ҵ߳вղ^HxsGn
zyLػ+/hQ)!=ɺ|lxZ7)/	*
b !#%&%$$i%$\#"V!~!!!!""M$%%&&8(g))))(
)('&
%$*$`#" [/: >#$&`')3,-/40~123G44@556"7{7778;888877T7777s77839988888654432/v.-i,*(&%$#C!H>/$lb/ ^"""`"x%,)
*('h(I**c(&%'n('$#$&'
'
&U&u''<'%#$%&P$!,HM


}p~]RS*X1 B
6Lny{  ?.Ww6vzxB+^ڨj	q7sԠԶFҷе	,Pș65B;C9⺰R {'N.ии!+]Ewj@qz׻ G4Am§1)j¾(o3Ntٶb? HoWXZ "#""#>$$%$###$$#"#%&'&'=()+{+2+*++*;)''u&%%A$#Y#"! aj^aH F!"$}&'(n*I,-|./133R445&6J676>6b66607#76666?65554:4b4444405h54=433m3210I0/I/.,z+*3*(\'C&%%
%9$$%&&B&&{()b(|''C)P***&+-).-,/-B.V.,W*)Q*)'%y$$/$" lVtqgxg0b&"rR	
~v

9+G l#oWy.!fL7TTlVn2)Nߐ޶>tbTٕؐ׸օՙ35UͫDqQRɥ=ȳ/P\sK+P¥jõr))bÝâà|)G]yŢŝejŖźpƦ/9}ɐʄ˷˰̩̭`7C :жЅѫrӔh݊cy

Gyi+"!8  !H$%#B"""$%!$I"y!"}%&%$&(_*>*((^())(8'%&'x('&&'4('&j&&''''';)*+++,8./0/H0135}54m445543o3444643@44g432?2233[3=3Y344s554445S6=6567o99T98099r9@86666%643[3S320.-,
,*('T&&%$#:"^!  L6\ d%3 -,W~
C
g	H $o'
]vZ-7(y'8;}y6UQeۘڅُئՃzԡWԌ҄o"aшϟ[S̫̮̎ 2˝x!ʑ!.pɎwvɏɢɩɡɿcʠG˷,vqZ̊a.w͛RhͧS&ρ2s_Ҍլ֣׌kٿ>ڐ8p]DJ
zZ0
KT]^'|0}v	
5
- S,    !##5$<$$Y%%%M%%&'('(H)3*)(''((K(y'.''(U)((()s*G*)**E+,k,,U-Z./1a2229346654\69;;^:%:J<4?k@??>>@QBBBASB`C DCCA@@"?=X<;;;8655Q5F4s20/A00
0%.',+,-W-+)(0)))(b'''&%$#"!   	pd>
n

	D	GK e7N\mZ]ci"?@WGCO$mߍދD3C ڏV+=`b$ةQ:;	ש<ոw&Ԗs;vUӏӒ" ҷҮҼ	dӜKҚ1,ӝѷKN>y	ӐHԗԭԇԈz.ֽ= ٱڽ]܆܊ܵݒG]aRj|k@lHqt=Uh=+pE]\<."X c(=	{
d
%VclVm4*XC^n>  g!!!!j""r"A"8"r""d##$$%k%%&'((F((((3))*Y*C*N**@+|++++',,,,,,+++++*F*W*X* *)E))(('f'7'&&%%%b%$F$#|#`#^#D#"s""!!~! $ diH/D0;t I}A
0^q
	[Jw}C3 $H	C>[!I=#GA7Z]n{<vGj,P%ygfhY5o7
^/{-ej=rjWJQ|9"/#1a!}Xt*$`buK
BRSD3! ]
/>P!h y
*;2Tt			
I
UUU1STJ5`FsGA;"< P|"-=[u6P:>:trwp';"DKExs$kj

+
y_

d

~		i/qe"eEJAQ
z7Z+#  x g @  QZNNMt0f 5e
A~R3ul`:toZz%p'X-8JC`[ivl6zG@
E.;<KB|c Ej!5M'Zhu7x$cT;03  =PZl(O?$*MU:,^	;H-
'&	)lw
N-	Z	|				
!


)
W
t
r
n
|

y
^
>
:
Z
y


6
c
`
p
U

			
l

 
Q	?(_V1S&KW\		b	9	d				z	P	#						[	O	G.voFt4i! L bJEM/|_K,l8!,zYT3xQ>
#W
6Ni         
      RSRC [remap]

importer="wav"
type="AudioStreamWAV"
uid="uid://cxn6gruv4j1tj"
path="res://.godot/imported/h.wav-bd90cd8134f0e33d9a91c10284261147.sample"
             RSRC                    AudioStreamWAV                                                              resource_local_to_scene    resource_name    data    format 
   loop_mode    loop_begin 	   loop_end 	   mix_rate    stereo    tags    script           local://AudioStreamWAV_jmy7o 8         AudioStreamWAV          P]       G S @ G d v       (O0           A   J!=gGrW    ` cE	  c   1     y  mYk6!0%2<
o
$uZeKkoI21%-83a'fba+kpnycN!5Tn6&Qm5^S?]qgwlK8-,83$7Z}	  2 k ^ X            Z / A w  Y #  _ $   . 
     <   n a l     ~   r    ' 2   p& D B  p " ! n    } l K 7 X u ` Q ^ Y E x    U f     h  ?8      ?&`       (4   "y~}mM      Y$ 5  C
 }4[SMpm L*T    r y ~ .  H 0  $ [    r t ~^V7     5 Q  JZ  | q :   o  b  " ~ X ow   9  Ss f y   q       a ? 6 ; ( c '    5 ?dh   ~  I     XIv`w
D
!!<6r0oL z2@2H nVmt{X20nC;5%hHDk|  HzF߯wߩސݼܥc>ڙ~ڑڱۏm1/ !J"!( ?Q}	n$4Rxb*.SZt
f
R5K~m7nvgQV "v$%
'/(m)*z+B,,,,,+f)I'$"/V
S
)
*	>}	)
&v/GM
POmD:nSO  !#%w&;&%J%%M$"K!q;=q t0 >)bV|f*^  #V Zlq	&^*n$W.Eߣݻ֞ZюȦȳ1Ƃu$1t 1rٵVNϜL?
]< p"(/357H<1A%DB*=5-, QpsƵYaʬ ܡުJp<j
o
l $M	v l)\17<>x@kABEHLOQOKE>b6-$6>Zp;M"  
Rq!"'*F-./j.,*X)](F'%$!*C$={sF>x
!]a{
 	E* JD_	3



T@s	6Beh
B}Gp(W#%'((.((
',%#"" pR5bV `	G}cS2
	' Jjv')0~hۚڒt֟R͏˂1i2迊x:$߲VƩMқ)۔x$ǖb(ȭ܍	#'+28|=?ABX@9]0I&J
%P˰±{k֮N^r
H
~N%**,K-^,`*?('),/'369;c==d=<<<a;:	:$7[2,,(h#:5K

o		Zg!K#0$$d%&'('v&$#" AceS
n

{
	CA^ ZwX,
&|
* U	:j$Qd9*k
W
Us


Tg$KcF5 FI=WE)
p
c
Iq
	 c^Bp1dߝX۔
UtxrTZюθ̦\ǿ<"ϴ뱐jܥ""zdޞߟo$פsmt΁,+/ q":#%)f,5-Z---`+b%nMl
)!tޅ8ӟ,Ξά֕"#PSO.{]e?	IE "&[+049>BEHJKK:KaJVIGD>@;61,(P#o+
p
Q


+ls #%&'''5(,(L'%_$" :w )j[Ob=_	~ QS|nn;bY,_[ ]			

@W
/
	w
:|O@"inE	`Q"L{	$
!_H!q=_
	 #$;	N]2߷ީ:w աZҤaͱ˻KǏ©mf蹤ܴ$mbLޣPv̝G-trvr{䧫IտTSt+"i%(,0%2	2F10
0+"_Foy%-0vs>ɰloKBK>B	



KMw !{%+*.G37<<AEDIKMMMMLJG0C}>/:5/12,F'"}

q


G&p q$(n*}+++",p,H,+2)^'i%j#!> CstQvowLnpDOcQ
m9 2/ 
&
wM0{GWV
V0
d	g		x
*M;mhh!u"i#c#["   1(
U2jk
KV
*8V%

}	3=8!:9ު#٣$׊&p7MUǓV$7ŦD'?vUˠRW񣻤Ĩk"ݯ\p^3L G#N&z)v+,-o-+z)$H>a	.ן++,5
ߣg ]<43QK " $%&'),05o9k>[CFIJKmMNNNaM]LJGGC>i:5o0+'$X!)!x-@jm"$M')+,--J-,+),(r&$" UZFlcK@c'S,=w
W9P6it s  }g
H !x"w"! yd"jZ1
y		]
J
_xR`mxpz
!X

-y
I{WC>ۛx٣9ت/lՇ:pщ1̴(hP";Lۺvɲ
بyᢒtL䢉Ԥ2QsҾǥr; P\S"%),.//0/-l(["M{
	KPdwy{s]NuZUxIC_q+!#%')9*+.16s:>tCGDK N
PkQQPO\NLIEsA<83$/x*/&"1hja5m!#%9()*++***(j'%#U!gJ(z<%(Qbcb*
k C0/

<R*D\(' }!"""J"!M
s+]1nOo	
{ 
l d7S)a]2iٰBG}Ԝӻҟ#Ц͞)ʈ"Á]j¾nζPHĪ,ڦ؟6#r8vP+R1ϥ5MI,V@g1MX#$&*.00/0z/P+#7 Y$ЂSN A
*v+~Z~  "%D&&&|'B)^,05:G@E`JNPRTTT[TRPMIBD>194.7*%;"a&c"D*pX1"&(>+,-..e.-,+)?'%`#! bT-taJ?JA0.Nn
	|q  1K l0	 

eS$np R"#[$$i$3$#"!! &> D

	(	]				

!A


(@_%u/
= F
.AJBteԃӒϣ1͍ɻc~ŝ829xĶƱᮥSר\˦b--?٣ءPPƧy<ͪʫ&ѮghSZ$v K%&(,00 /-.,(!Z
lތ%uDu
c
[
#Uu1yk={!3$D&.''()+.3M97>xBFK7PRSTdUUUSQ1NH(C==9.4.*&$H!VH9+ "%%C')O,./0/5/-a,*(%
#U ;[mtueUA(9
uX	}>Al
5veS:w/"$@'8)>*=*W*?+D,i,P+)(&b%#!F6	A^r?

[\ 1N=
^6
	~+x ']Yf$,ۘ
ٔ1Qң(ϥE+V \{mܵXu8(զd*.A	E}+L9H˛ěl$dZɡ% 籏#,ڲ.[ %A*-,1477w765>3@-l%	8c'װюӆjy\z[	xm{&aO #$%$$%'w*.:4d:D@[EIMQ.TUVQWyWVTqQL~GB}<7 2w-k)%"![WsU"%'+h-W.k..l.j-,*(&#x gss_F4E)% _H]
MM	t^   ?xXN	
\
&8"%'X)*,Y.0/
/..,j+)?'%" QLq$7d
C	/} 		
{t
e


0

NW
A zk@
߉ޗۋ؞iWvԪyҲbLM8Dg­پķ6ʰ 𩺨ѧ2FȤqmX_SИNߖ#)7%v*ԿfJ߶K%i,28q<>6BD<EoDA<4+R#If	GF_n֮oC֙ݧ{\3T b/@qAi2_W !! N d!$'U,&28x?D'I
MP*TVXZ"[ZXT{OI6D><9J4/+(<&Q$j"K 
!NsP.E?!$m(+,n---4-r,+)&$"^5n~Xk\e	.!K'1
=YIx: 4V/D	
=


< O$(+.H001M2e22100-0X.+G)y&H#H#CXlF		-a(~J*S$
J
Vs rV ne1.ݍ۱p.wְѮЕi͙ʶ=d,^Z*lHլӦޥRj~̞ua.1͑S*\;كÃxo5DksZ*G ['#/59*<k?BDC?3:3,x$m
F>ީ1߼()bWrk	
<	j	
Z|; x$
*07W>vCGLOwRTVWWV]TPJED@:j5W1..+)3('j&%^$P"b(. #$%%%%%$#E!&%1,!""u"! 63Y(y.=<
@ %AWg6 7CW4
jl##(A,A/013455"5j432l/F,(%"Ii!
	K dApe]<	
N
Dtx;
>
N?
b*z l =ۼEՏҦM ҟ #͖+ĵ7׸rj 05!Ҝ+qטnJ	pHU;ԈycNԊ+;(1O5*68>BgA<7y3,#fJ_u2c)[6 v?		kd ZYu:5O>]"'.5=BFBJmMiPR\TyUfV6VS}OJHFA<a61%/-|*'&c&Y&g%#" ><Uq1f!""!'!  [ ;D:!e"e"h"f"!);dr9/HH
 9ceqb"rQZV<mwp}	
]0yh}#u'+/Y48r:w;};:9741q-)&!	U|uG[[	1r
>vg



#	f9 bwK3mt @ځؽkՇ
ӄ($8Z]):˄ʒHTňZҸ`V`49g.ggK$ikQ*?"8>Gc$򦥷4u[$++277P9=?p>8J2-_&@	;$ 5A߯O)+( bQ<	L
3
^obfq	I+,{0/!Y'M.~5P<QBGbJ4MOR:T*UU^UOSbOZJ$E?9|3p.*{(f&^$3#""!G7OkH H 7QN 'P0!k"""!!  [!!v! 	
OFPUC
.7
(/w!?_qf
R&w#(V.u246B8i99y7531-M)$/!<+
75Q@2?\	HC

\)%
'

	jYrY,R 1H3W\ۇPI֋՝sAЧ~ΏQ~,ʫĝ4J
ϯ٭:01sڣYϠ&I0zRn˛"yn"ٖՖ򠿬ؑd$*.012%45\51:,S&*! 
 p+nh
JJO-		
{
D$QC9{|#c(o.4:?=CBFHJLDNOLPOFNKGQC8>82--*Z'e%##"""?"!! s / a1|*/u|>N5p",U>my  o   e}}6(	jL p E/d^-G	

%nZ&!#8$$%&&$###" 4s
6
?fS)

j
l
-
f	.Of ! ?wTw$~pW{$iِ3-ҹϾEȪƫ l^xĹ@.,sЪΨ~F/-f	Gk2m18 $f*H/dF" 1wu $3+/ 0/02q1,% ;Ngx
~4
M]  D~Qr$}/i	*VN7fnt]#m'b,1	7<A)DFGvIKKHKyJ=I#GC>9150d,u(%-$K#","1"z"~":"!! < 5E8 9F.S!>HV &!B!1! jlP
~p
|	+-3&% EKoFiS#m  6  s'u=F!#&(((W))|)'&:&z%# L<
R3K(	;	Z%yLL=4zZ f"eff *$ܽڞ+΀̤.açeU@ڳSIP̥Aɣ:yN ̗IϗT.ȽNݥn	m!'+,,-
00-k(a#,_&
m
o	Gg.VTFG	9gvq9y$
f!F&]+0$7<@CoEFHH]HGF
EUB|>9531,(%#""c""4##$#"!)!x x-D	^j<!!""!]y&i2Pw
*
		LI-!E  N;1 > km<u@	`4Z	>6Y]I'L Jlok 

o2Wrq)*v-|uCNzVzW #Gm mon|s03a/a4זrqѴ3κ)˹&EaZMYQ̻йoll1ﮠH˫ū覴򤻣3ؠ 2ӘLUc}g!%*/D1/Q..P.*t${.iH
`
D>[P_iU P5>zuw	2b_C$).38=xA$CCHDE@EDCCA>:6I2-j)o%"q!)!>!!"2$$%%%,%Q$d#{"! c"&1!cELTh<U'PT!!2"!!_=h9p
#|

	8%jB 0_|0!Z)b9]Pb  S"#)$#!X!+!YR.=*V	
R
K

"
3
	6	yeh fV? A
m/ 0E0 4N׶EʑZP79]5*񲜱JFnG[T
ߥJUogLk6[¶цQ#n[!$L(,,k-+)(()& y
X?!PGHVRa
2.q+M #l'+049>@A@@@C@m?=O<:S96k3/+(%}#"#"$%r')o*Y+g+l*(&$a#!o}0MMxt


,
'

s]u`' g!!!! fv^(ILpfAU~
K
@# -N
Xz+vZQg	o=TMD
q-n0
	,6 (1b%# 8i9JgqQi$8V ]8&UJg^>J0l.V9WޏېصV^zz͟Lrəl4NŧÓe{(ϼCWf A-ݭ,𩆨SjuΥC.b[SGO¾?ۘ8K	&@ !#$# 7?*17zPugGO| w d*e_c?LaE<D=!$"'l),1/258/;+<;:t98Q877]655e4;2}/,*f)K)*p+-./00/+.+( &"" 37	
T*
|		h

	NyWKQK5#"Bh_=R3#
:ak @;`ZyV Kua
o"s7 }`L'7Y$2%6;:*f	;DSx  $e cX_x_ w3G5i']MjއFQէЖ^ˬɋȭ4Ʈ8ŶAL$luQr8z_\~7@J'=¬ׯU}YƅfzK	H_2.=M&	Eab\.fPdf*<v@$r')*K+`,R.#13666|544S55554M565420/0091222R21U0I.j+'[#!~
T
U
y
(N
?VwPF
a ba-Y'!Y
rd]` :r0+UnE iNL-
b:IhbLjPlQ$E[']3_s
	6^
J  , a'^5@.

4A	VP+vn;ρqQ^zк3,q:~ٲǲ$԰;˰&̱d\S9ƴڶL1*Kި

wZL^U
y}b:	z
	zc/XnD	_[ C(r?t$BU($u')****+W-/1222211N2l34!6Z78?9875>43~4f5'66664F2H/+b'"g
&ER	W8?IwEJj
&&v
-` +$=Aa gQcHOh
3* [!:! Y s%iC
Z3-
N	h<a1  # P#U %8K~ K[&QnU/.4d{۠؇qчϹ͛iyǙŃÌ*Q湋͸S.ڵH5䲻Tݯ3l
@=h3žGymnzm=	6B


wG=	O

2
XhY}	
?	bX c"c
 #%&'';'b&|%z%&s)4,--,,./0Y2B457^9:;;:&97x7a89x:9P86g30
-(f$" 
Vi;/Q"*h~
Q

:FR4KoooyC2tz
q  kz~P; D V}O* e#
n(k-=T791Qd*D8O,g
y
K	Vs8dN?UA#? }   ? _$(T56W|8Ӥ6
̖GnjO/Һ% BLֳUɳŲĳճ	e˶طѼxPkN	>o DqFNOO

"
N
$
c	J _O'\I` %&>'d''&]%b#!!s#%9()*(++c-/2w5u7?9;<2>[>5=;y::u;<<;97X4r1.)G%!Jx=/2

		
L
h
o<1'@<b
	d,$]:b	
=
X

|
	p{MtL&3(M	Y
ak
Bk,vUFX2
$
JZs; . W  J ~] 2/SAh XܞBڭش֝wϦXȦƱŹjRrʹ)Mz0@󬹬4׭űR#mxOK{Yiv IW	w
	t	
q
	,
<R
+ D	dmK )HUG#{%p$! !$&'c(#)`+c/39789:;9<;h:8B889z;;i:741.,P)&$!  L   	6b J"W#3#" ig2w				=
TnQc

X$w
`F


7

*	P5Ms-P				X	zS*qgD\:N	Ev }*	/*Z;
cHkO	DC
!b




#
c
S
T	4f 4=<k-~p@
_26t=}ߙ<\ےڠ
˧_ǻdıxǼ\۸*η^dcc<?owۮv b+#Lg?M=J8  *,6oXp7\ $
	
t
Z$

{
Eo   6
:
#R$0"_< !!!#&*L/P234579:97v66f8}996v30x-+)'@%"!M"x#B$V$$#?$$%&	&6%#!; s
6



E	!		
|

Oz_
0
7
	nc } &k-7		e~yS *dU_
>
-
[8

e.


z5|Tl*s&g{


u%"

M

	9	)	p mixensPZ0 -x.|܏[-tәс5Fɤ%ObæHmzk0g.ڹmAն]2. r%LTɠ"{f 4;G@-JJa B P]		<	

;\7qsSw	vanO3 "#&)-///%001 22)1B0/K0000.,G+)t(H'%T$"X""#q$v$-$####i#"u!8@

kx
l
		"	'5g:   @;B'iV <vJ    ~	I
	
F_
'8'7M(dByEMRaAE.(

gj	f\	k	Jf~n; Hb@XQ.;=0ko$$ Ph߼޸isӠ-ύΧ̀ȇA~!{ßUǾHYH]Ys&9d̏IG+~mBV
o;}@&DleGvCx
huFDAy?OTJ-9w E!;"#%u't(()U))7*p*+*)h)_)X)j)_)('&%%S%$#&#""7#s#|#K#"[!C {e
e X
&

b
?,!
	J	#! m I2 4n q  dn ymwr`r1B-
0
a
-]
XnHXVVzF
:~,'p
*



eQ9	
	~Rm={y.{I!gOwhr݌n
 ("g3A$ίRͰ ˑʂqɘ}N4T(xYΤm^Y^cWWq&~p' r U{ X|   
icTV !!"Y"""*#>#!#"""""","Y!  h	}-0~Jx/UT@HK
\{3


z	C38(qqoZ;NW Y &  ) a  0$?IwFt$G	h
<'F&$






!y

H
`
z
U	}aC61"3<g G(V#kK8`V{qW#Fk"P%#.io݄߬ٮ+"CՔ*Ԩչզzmrؕءٙ#m!DBzpTkcyu^gP L X  Vsa?2C9	^
.y
l<-!vy pi#Z'-=[PqsL#
7Y11<\N

d

A<

l	QD
Wi{1    ,\C    1    5   7; ( )         /PUe6R)&.t] (x(x%{F	:w .Z>%ud4+  ! ,  H(g1L
a \PxA"%H9 8230?-thw\/Ijj)r'UryCRM8 M<NF2>7AhQc7X	vXQ/b# 819Ud W.zR^		7	Y				

x/

[3]Y
?qr?6/!hK/%Yd)	Z2+

(
H)
4
k	V`Jx-! D  /ue:F <B$,yDW2{ssME99&C*kML'o*4w;W!TWF0in Dp6;Q~bv=H		

2%c}

8

k{9(wpavz31
~u+<
(
hK

j
<
		=	adP^Q!/+  c # I-5k9s`S24QF99Qkb7%/.
DZ*3#IS`3Rfs`_W8,\cPx7 I `       ~ 0 hL*e@56%	gDV %)F;01z*ugA)52'7V/QqEqMl	LY0o   |_v\\ 3 ` j c n    t [ 7 . Y   t t   );A'         72&     y \ Q 9   3 R i _ I N _ Q            
      RSRC             [remap]

importer="wav"
type="AudioStreamWAV"
uid="uid://ctv463vgcnfkl"
path="res://.godot/imported/i.wav-6ac81f41f313ba98957e5e79b8017b53.sample"
             RSRC                    AudioStreamWAV                                                              resource_local_to_scene    resource_name    data    format 
   loop_mode    loop_begin 	   loop_end 	   mix_rate    stereo    tags    script           local://AudioStreamWAV_0yych 8         AudioStreamWAV          W                                                                                                                                                                                                  ~ttn_V]iu}iO8:^ztUDHQP@00DD!&). *%,GI5D4\OG&8/E^lDc  hDZM#   p B  [ &  
  	 o !zyat2     #V}7R 
Uygp?P]*;98|W^\rpbx`e1j8/gT"kZw<TWv,l`gi$[kz9~(xz$<C  0l    *0RP\}^ MC f    `pS.@Ox (yu	dyQC\
`KgE  Mej MrlO:  Aod$dzR
)N>[#=ovU|7h&IFGs0cxr%oLMLxq@!0z Zf]G_fU   _(i/pJKy+)zp  t` 0 g N | % <Z'&p 3 L"o j%|  ! !g U bWX  aY8g < & 	Es() j}! p!c". c K
[  +y'q '"\
!o#jK cl~20K( D"H/ <" S  h Sz\Cc	/fX0 d<}5S~8B		d,QI05jC?QdVc=
<.t6^9Dsu }-  jbT]r Q 6 3 D TX Er)0
 ~8N } t( r U$_|H+ -./ Lxl !$5< - /[& v u | 4iY )  4$ 
	;!sv7 %? P 	c&#gqR|~jH
  S &< K  .F' F{kwN6
)3`    Mbe1 D@1IKQ q	O!oe cBq?}9E wfjBCGy
(=NbG	ZA { B  4lSKd%Tr %
pAmL74x l"[!qc
 W ]*x6g5Ijl2 w	

uGgr  3;_I &foePo#Z
4O
CB
&?vv 0[0#%_	s	1> i#CULzsT(kP ]_ e	r
DKJW%o@`B
h :@U#*b\} M2uNleFwl: k*e# s 	ize7Fk~|o g0 HFpzdh[Y	 )+( 1 4j mzna#vyct{G?7{
	JX10Zj2D ^S jf&  bdN F
& -	
mJU$j {mt[ B 0X'%eJ+
BdIg	*5)w+H;\T W];Y9`mG p  fW/ U ~V 	>R-  =	R)JU1l/}


R 8}L-V <P	*UY: { T  cJ - ? Ey tx'flG~ UW{u		 +|/Dyb"pE +y dqU 	 ?+M"of w#"]F+Vi 5 @,-ep' dSy   /X G ^z_ Dd N4KFr!h{ZkcH m S HZ/Uf{Iz	$<m' twAy=tSym&iD -T  2a1H
:]]y  .] 5-;; z t]i2udvm%m!_mU MmsOK 0G^(	@;Ql	
	Fuj>	wT$_ R ~ x G  8w 4 Y3W$PW'('& G&,Lrv- XVe T. I  /LB[   o{oYw C6  pc{ &>I}U%T
i } Z  00; _F      ` 'A.8 fvk D    = $ {( $B   S94  8 C < ~. Q{  , Qx_  :S 4N# ~f5 wB~   + 7>:_Wz(l6#y<lp@w]"5@.!FhBq#hCBD?K5P AG{R  9 |f%+ ) N    &  z ;,z    (+9pJK}0JX7Y@	

m	twU>H		



U+






aj
	
$
m
u
L

$

GhO9"'	z
#
	
[

K4\

N





M~C
p
	T	1@3Wu\X CwRJdD	ec z]>Io|b6=m~ܜ~Xۓ A~Ԩd	m΃"˰a˜|cXĨ\*I­Ôìušǟ4ؐ1576T% W
 %)
.14666666D7A89;>.@	BCAEFHJLNkP`QQQ`QP>PwOtNEMLvKJ$IdFC@=;9M8665554`3130v.,*0)q'h%'# 	ky
P
q{
	{	
i\
m?' 	!!-""##$$t%b&'''($))*))))*L+,-./<//K.,)C&"gtUJ]AR6W~ mD?i߾wڥJ:ӠOciЇЅВО`Cσβfʪ|ï·`^%.a&<ܷ?߳N
׫ɪ1ȣޣ4ܟBƘDBiS +_ɤ

'i|ky+T,%eEh=;ip$(g,05P;aAFJ8MNNOO'PPRSUW<YZw[[[	[[[]^`N`-_9][XVTQXPOO<NKGBF=8(4%0,%*((b):)'%!5=	@V :  E y    N3B
dJ;v
h Q"$&
)*,N/2_69n<B>F??@AB'DoEFH"IIvJJ}JI;II<InIiIHGCFDBCB@\?>'=[</;h96n3X/+(&}# +e]
}
&+CF+tU
8QWFx
6V
9s|& =
[
.	SprZS@	n
\x
ئOǇD<1f\d.%ڝ~,IɖLn% =2-f\ יq8$򜦝S?I8Ĥ0ۧ
ٲ,æjOC`b5

R	

KvO"&k*U-/38=AmEHbKL@NPOOMLJpIGFFiFFE1FF	GGlH\IIH@HCH2HGFDAW?=;79X51,)'$"V?^7#\5"En-q^Q.5d "$'*,-J/1345a66667D889:;<=>@B$CCCCD1DQD9DDCCBASA?=;E:8R7,642:0o.s-},?+ *)4)(''%#
6(A
o
R	(34w(vm}uYv		
L
=0
	S	`a4. K+])4tFߏ}ۢPRѤ5ϋ͛ˣVRHϴ4r-ְr<JAdk_?K! :ʥȥߥ,=nբߣ7pȠĞEO؝ěbۡs3)0#hQfyq"%*2:@@F
KNPTQP$MJHF/DZBZA@FAAXBBB
C3DEFGCHEIJKLzKHD@N=93.)&#"5!xkbHWUG_LNP

3 i"h'p,0j4R7:{<j>?8@??>>?@3AAABCDEEEnFGHHJaKLULNLKJHEBt?<X;:Z:<:9862/0,'"XsB+.
9	\]'m IEO}%	n		3

u`

 
 
$


*R0aQ*>
	"ZVO sM36{=,|Ѻ=	-`ȁX
¬('9vҷkd^۴Ƴ nĳ[]ñ-gD&%߯Я PO2ɧߧ3BmI5p74SߠǢe<(ЫG#`W: $\'O*n.S4:?D	IMOQSRQONM LLJ	IH9GSFE~EDhD2DDD'DCCCLCmBHA?;852-.)$)!hGT[

x

_^n
h$P
Vpij+ $9'r*-15Y9<W?#BD+GH
JJ%K9KIKwK|KK{JLJwJJJdJJI~IhIIIIaIHGF(EBH@i=$;|:;;U;9K7s4C1*-'
!  &


B'D	"||d_~2 Bo	W&

X
c

dcDS]
hPK
QS($Q6e$kޤa	5PpQC˵VȸǱƐŴV$ĸ\]a!_uѵ|ڶvt;)s9֯it~װ!˱ױ%JxN-z Z|֨QLܥ60r$:Tɟfv5~K\rKK T"
'++-0?4a8y=BE?IbLNP{QCQ:PNLKHEC@>i=F<:99499988x71776/5B30-*'p#D
0
	U	 
R1T|{j",6Y : n"$'g*T-047;>A4DwFHgJKaL0LKKJ[JIjHFEDQD|C4B@V?>D=<N<;:98|752/R,(%#U#$%v%#!,O%\dOd&	W6dp	F		@kf
/
OI]J*gDPsw!	2#nd{(m@zVbBf+8r'͔fʞNɑȑ0=ǀPjƳB|ħðAD"M8r'ƹvԸڷͶ?ֳm>"<ƨ/Hv2WӪ˨Av饚çԪ1!
*Yv1Rv!%1*.21I34i7;?CFGaIbKLL
LRJHFEB@=%;r86A420D/e..-,3+)E)('@&$"5!VAR
f	r1$T
073-~.nJ -"#$1&_'(H*+o-.0q246
9;>AcDGBIKL*NO]P8PONML5KrIGECKB@M?=f;&97W6B53H20l/-+,e*(&$" }wv`v/<'y

k		
5(


z^mSSMH::Psv2 ['u1
HC	;W5k(9GdX|zyԂӃҧ,=є~ѽЯυjk΋rΜp̍0U>P*yÝ¶/`4Z渉MiM 篫׭S	J+ڪw?%`ǨL?~2@8qBLfȥi Q'1FZ?!#T&{)5-0%3,57:=>ADFHXI~IFIHTGD<Be@><8530.,)P(&&&~&&<%o$#h#" 36p\d
	=	~	3

2#
C(hS!h#d%$'(*^+,-/G0x1214x568Q:E<Y>{@BTEGI+K_LIMMMMgMgLJTIG]FD6B?=^;96h41 /,*=)'%#=" t
.@
	\	0
'	Zn
/
h0m`Xxov~OlrS1
QhB z`m Cjso߻Lhfؓ^ւօֽ^vԤ|ҿҳҪХ{ϗРоϑ͕yBwoD}KM ռ
k)ܳ L^mݮޫi,ݦ0ҦK8Liޥ6Fϩ4RR5 J`rl҅ٙ!tq
FO P#&*-/1357^;>`@YA%CFGHIHHGEDCzB?;741
/+($o"!!+!>r&q2
5
	lLxY	

gP=%!#&)-,-./0B23+556 7g8:;Y=>L@B]EGI9J~KLMN
NMLcK*JHFrDA`?<
:E7L411.Y+(p&,$'" 0bQSmV		$
2o	xo = sI}0[				yf-0  3"#%%%j$""w$\&&g%#"#p%%#_! !"N" SOx9]San4AC`xyߓIݢ8ܢ6DڹTX?ܛd.݆܏Eٞ$ٜؿתדՕԤ$CҾы)1q(mǲŵbNҽ%̹E t+-e+nǩC'[zE%Ubܤ9tçdܩaz׸꽅SҀt
S%r9e #!')<+F-02
555`7:<>?@EAA@@@=:]8752Q/+(%N">! 'gah
	v)	
C

0:"7"
'*U-i/9134e6799:;)=T>?t?
@@BpC,EFH1I)JJKK}KJI@HF3ECA?=:752/C,(%G"R3
B
		bwX4 ff	.[
&V,gz_m w!."""q#$V&&!&%s&''r&$#D#<"v ]&8
$	RN`z:	lHqP2D>6~c!ލ޹ޜ16ވ޸ތ>ݗe
{?۷J/Oء8Ԁh̸ˬQɛğۿ˽ tD>ٱorRZf*,Z,yèK?/
A_WbMI 4K![OV)|^8 "Q%]'(n*,.+0m0012
4579:::::86g420R.+_)&D$q!QBWrr^h/
vj)`SBW "S&	*-Y/I12n456D8~9m: ;k;;<2==>(>9>>?@ABBC^CCuCBA=@R>}<:99T74>2/@-+(%."PidaH
z
	,	.795	uZ
*CpN"! i!P#$$%&'&&E'U(m(&$i#`##"'!F a{l[[R.
 KAq\E:<kb'FL|!;MQ^Y27?e9و9SA {4ίF:ȁƤ,5ʸ(ϴƯAB¬«D[@G%rjeF<ɧm<~ѭ/2B۸:@ğЍՌ3jS%G 8.fK/];I s!F#5%&(*,)-J.+/:0G123x4555543T2,0:.L,9*'v%# ^[I & gX4'_63 




)%}ffx!u$V'?*'-/92<456789V::W;<<<<<<W=='>>??o@A*A@@@p?O><:p8o6m4C2/e-*(+&#$!L:T=
YOJ
	$	s	Q

Q
0

rC'
S		
Z?fC,}ts  !">#L###p####r#u#q##A"I! sX+D-%<,
q=`(N-1~W,k[R(*	h'dvߌG
ߴ#Uyۍf
ҏ,Ξ̼͟˝6b «վ~R
kAƭGxz}Fɭǭ%,Fy^ؚ/.yB"R7 !"$b&(a)*f,z-..f/a0a1y2%3T303221;0p.,.+p)'%a#!mdX]Ei
~
H
4
8

>P/]"%'v*
-o/1C34567}8j9::?;; <3<0<<<<<n<<r==5>Q>>=<;S:{8d6S4m20.5,)'-%" x>B? 

=MG
Q	ji>	R	di	"@8	(
g hFK!d"#$%%_%L$##a$$u$#]###L#*" 1u^-L^F
	E7; .t7>qs(|i%~ _tJ{2n*Q v|޺GݕL|؏K֥ԉ)юY}fFƝ$è+Ͼ
z *U8/TP]Ouԭk)e:OvxZݵ,J99_'%uδїխ޽lIP
SId
a v!#$O&'(***L+,,J--;...{.@.-,`*(o'%$2" E4~a0Z(<? 1tlcB "$'v)+{-./0'2f3U4651677o8199,:\:a:_:?::99999999C9876b531)0b.m,L*((9&]$@"a)|!
r	{GI			5
6/	&

X!(5,-/m255M3I/,-./!.v+)2*+`*(#&%o$!thQTe}'^9!6
Sv86@
[hS4@4#JhG&rW~<0d_i܄Aڀרr<ѯϵ~gȶ6l .<h{ǪɫJK2cجӬen۬"Ŭm ^:9x÷q}[ŋ7Eߚ{\?

Z "$&|(*%+}++`,-\.P.G..O/A/.-=,*A)i'C%# 	:gf&CVj

.xK(k+
	*c`|!4$&})+:-.0C2345N6]7{8N992::;;;;A;:;[;k;.;:y:>::987[642?1a/&-*'s%b#C!D

	Bv"	
uq
lL;AU5Xy Y"3##u$%'(p'%.%%&A&$#%#";" #BtT;uD@o
2c|R tc8b7	)N553hA I|,7-?m!<KI%9pߓ.۽ؐҘeΗ˫yȡŐLξ$+O±Ȱ𮰮Cw^̭ϭ\"ӭ󮏯sj!6۱ʹhykpMرk[D>
Nn=W "$&{(#*+R,,6,-/l12345555320.W-C+H(%M"dC



&
 

	
	.JiC	

9Cqi";&)+.Q0-234g67899:99d9O9K9X99>:8;B<<W===$=<;:9865>420.v+(%T"V	pPk D n~xd InsMJ] v#%
(d*,;-+))J)D)*(&v%%%1%%$"^!  tX /c
	W<d W85+S}C	Rg`m6b  K!,5t
F=z<$3'D.ݾۈٟg%Gʱɍ,ǍÕxnŸGqD1cBH%(D/c߳_ٵL ǾkǹrV"B	
_C= n"#=%&''&&2(d*!,,-.00121f0/.%.{,)&p#1 
z4D
bv(Uw
		c
SN(6"$R')n,.012355X66k54'4334h4556^78H887:76{65m432@2 1/-+),';$ -xp
h	MRt1G 0g +	
Dq"ko8 "f%`''&Z%$$$|$'#.![ x =QV|H\
m3
	Wl xF}5b khK^%dT8hrtyvdXu\Aoܡ9MҌi)̃͝$OȏgŪĵ1©q-!W4(<h׶#m䴮h>7V@FĚǪ>ZՇ/!,{ak "=$$$u$&@)>,-
/t0123Y3210K000.0+I(N%!;
?
=
m





(
Z	66W1)TKw
kJ
/
[h6|!$')+-/1p11K0/$//D//=0U12q456778!8q888N76a6635310C.+B)H&#(>
c.	!Sd a'")
$zYjg +V
Fs'Y#st !""u"!"##;# o r! B'{f
)& ueu OZ:3xoG#V=XP	=a{v!T9r"-D;0hsA߳Mڠ~GϽΰ>ͳʐʔʉlqʀ}ʪgW8ƛRƞğ8L~&AſǣƶƿuΌ҉Eغ2:$  GTR"kZ!`#$%''''
(g(r('M&8%$#"z jOkx
e			

_		D

=
{Q_J>8+TGE	
{.nt;v!~#'%&Y(w)));)(((''()+2,,Z--.H.$.-,
,+++3+F*
)'&%#_!1Q7

~	xr	uQ _X@O`p 68	5X!6!|,HUvo$5f
+
w	 .(+dMwSfFEVd	`	SJ'm_PA
r)eiR6"~9
8y~#ؗ&=[Ӣр@{@Ъ0T: ϯ]VoҖd֙[ڊyGW Ej =DW5	

:r{U(DRyQ-

		i|/m{ee tvV=	C
Par
2elX;:@    !!	""!5!  k  J4^hD*<F
!.
,	Dyt	
U)X
%p\
][(y/1jw*'

	7!"2H?C /5@5 5	-x!"X>=H>e ]%Wݟ9ޛ1w1޾i:ޖo?݋pZہ4طؔDّ]ٔ(ؓ
ٮصy0ODn63 5J	
(+

Fy0O_?S3qn2^C[

B}


	0~]L)g  m 9 I  QjG~"b	
>l&IzdKL5_[E3%IJTmyT\h
P	5;?Dc  /0eEcgYR  sD'<oxYq'Xo>% /[mJ:.?/| GK3yU: Q[zS-	 >gzDuN:	9g)Hj(My* 0   Rn
FK.c!rT)fI;!0BWz6zN[<5AE^$'TkneOCH2>w5f.e%
	sbVF?g%[yKFF O    c"0B>5zbF    ` 3  h P|cQ. #.N
,=Jl2l& C   ML]QSVQ@$)3,h/	   { K   ? M I h      -^-E${CYYefK9%zdRM?7(8Mhx
)_KL	4i^I         
      RSRC             [remap]

importer="wav"
type="AudioStreamWAV"
uid="uid://7isr1wr5btty"
path="res://.godot/imported/j.wav-7906bee2ca0f1fc9ce96e7509665a565.sample"
              RSRC                    AudioStreamWAV                                                              resource_local_to_scene    resource_name    data    format 
   loop_mode    loop_begin 	   loop_end 	   mix_rate    stereo    tags    script           local://AudioStreamWAV_8bdur 8         AudioStreamWAV          k                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 # 1 l [4m,%N 5? P T
1z0qP I p*L5&p>\'EHq>,%\}*%9`HAE*1@$(	yX	eWYgyZ!:eE,pV?	
 
-
WU:+RTA z lyx\QHOVzS8kR'#N Oe1*#  GH  f- b    { 6  By {P4 r 
 (V PnB8 7	b	
a!|
^1  z.ix=_ j  2   A   _~" ZS	>1:OzkWU<LyX-";0 C5DF-N	eB8x,AMe:[7Q Vy5*"1c>);)h[/!-z1573[;,  A p1  #t)>-NXX0IAOlrNZ3|

PN.hlgY>A6	v	}		&


\
		Q	2	@	p			&
r








3hFc|`FN~{@F_%


Fu4

=$|
O

!
L6n3*
.
:s
qN)->'v,"#CXb
O
"		1V
,
4
	[	t	[		P
	J
M}COGW2,}lze|NIyHT& /  ,d Te	uo hTyieU/M86'
;{@dA(4P.1Z=!Xz`igWWt|GK0$[/=JH4y&.`obpr5- :Ia^WOi
a%,Q;]vpJOB>	J&?se/-O0#LyX/9=AKh$4Auad>hx ^ -;E6B&!Mhtsx  R     F].  Bk  Fh	n@HTiv\O t  YH\Is9hQe VaE.e;EAz9i;J?kab/~Z^  w   ]81xi,\4 We 4w3t 7 t N?z -d{Q@v6t1Kg 
L",  O) @    k   g_.YR p,> *s)?\f  < _ /   S a d   -WIF,J6lo'd+Op1Bd,F
2 z&KL83\kz,|]6SXkd   laB.Z
HUZf*7rZdv0 P zt|Lx|?33xT[JZ/8Y#c[u]Oc[#1Bf^agQal{)+4    r\CA}ji^lO.C!'0VH2P1zR!d{KQ`Bhz55L-   KV u 8 wE
}A5GK3i[< $g]>?AG4q^hfG>eQ	Q: X  Jlc4 x ' 	    u   j  c /
,:G7h7 X  U_d9T(^B*TbLo|~+#X@RP_h\Cca~  >sF_k"Y,qeQ82%f"@|*fFQo.a`.O6Lf>F      | z  k ! CM$p`*]Wc#d	hu2O~
WrP>&czSQ
FpN*
]6_smo\f]|2 q{t2# \ , PE,`R&U#pT0*^lfT+>Kz % |    BH? q V d         +RhB.k*U9N\e~LI
	pCkKz0>Hm?%iNh7)<+Zf,4\;%\nf14$Kx6
SxZ"]   | k V s        6   
   >
=<
0x $TY I`Y.)e*L / ;  w&d <5U`] ^ " zx
}=ZO (K~W4nr8. % X  l 4     iZ=!WIXCm*	6nc2(5y~AAR9u3U ! H%M^X*lpN6'	[m1 E[R j U  yYIFex{Z!:Jad<j  f^F u ~   w b   ,e;JL7/$-D y,?  ] 3 : !  $  QSrOHsio}r(

q~OFg{O;b\'0 y ?  @ i l l _ 4 ) x  x  =   Q x     g eMI(Y3}l.]IQIc_nESZM_   l (gg"o7     OE*fU#( e 
 x7	}< O#{{ $ X , b K!2Z b|0CqCp5kX ~[/    o|ou  ah'qdFie	 NR q v hy ' q v * _  o@S/P~ W  , ;X 4 ~0t  WVQ
   SK' 
yv#fj,sc j@;oQ  - 
 $4G    qYoL_
     >  	 
Hhc0= {  iseh{Q 	 T    qK*e9'@5 6  a -9   f L&       1    `{4i%n!UEv& ihBD=Ite3Yf|,UU%_?^SrIYeWWP'PpnCm72mP5ABm^w=vg*ee@Dg P bt  ]}"Q s  V u W v 
 ,jy #GpN.b-	b   Dq  j  X  ArH?6ligJ  YY h  	  1*_AO V   K8 [ A7A M  @r6     ^ 0 + d  2 /   9  ; TY@ , r   u  NOxzL]ux"YeG:$S^Ndn<1fo?qlL$OQ\-u$IYt<rm`*(>8[ +(##\  j9u f   G      Cu7  Z   [  3 by#Q/|-H-(j>:pL"^4%,F4X~">|,w
z^pR'!B.F(}X_N%C9	|D~.5wcK=  ?  | 6 c  , j u s  ;F  z~_W/  " Rh6["K__h<RU{j_f_{ATK+de5md;[N^1vDv*7d ur^3gxD k   EN   Y #!@mMJ	j
D-2  M 
  m  	 ;x {1  s\o5S)U%.i>1J~K #=,		w	F	w			Q	 	6		Sbd-^			u	}		
		k				_	h	t	H	'	\Pki.U2OQJM			I	r"_8}bE.!^ V  Su&,Fw!1tX0m\N=I4E#9qPHg4s;VpfFX-Va@I<S:F)cPc1a()|Pj)~tl"5d_Lb
R .tCI lr$:P
g
y)\ e"#$$$7&'O(P(()u)4)))*+'*)*+,B,Z,\,i,---E.H.R...,/$/.r-R,6,G,+B+*))*f**))){)))H*N*))))))''&&c&%$#"""!!
<F{93 8rF
S
2K3s*h<kvAߡ݇|3ېڒcajE3м
Ϛ̪˚ZG6ǹƀācEÔ;Oǿ'lR"l|طk{651A"׻ܼv򽘾aV'ȝʨ_ϡrOS]W!!!#]%')v*++,|-.r.Q.-----,+)'&!%($"!`? !"$1%%%4&&t'''.'O&%	%$$&%}%%t&'+)*+,-/1234U5678!98889$:':9z99m87E76U6~54#43E44443233/32:1060/y-+*(m'%#J" != |
+ T  !#$$$$%%$ $#1#"! U Ma}mm/vCw&]_>_]

	>@_  D":?
e2wC޼X.V-ֻԘЍ4G͎̐;x z̿ǽ~VպɹW!ڳq-l@ ;7DV|Hsw픅\ͭ빆)ҙEx|H <;\Rp^
|#M&`%$c'*,,+(+~,./q/..-+(%#!l.
	>
 
rinn=!   !h$(N+]-.Z0[368W86"67Z:;;:I:x:;:X9n754{323855+5'446>8876.6G6H6*530l/*.,*k(&$"! S~DKn*"&#*)A(n*/	20-l-@/n/:-P+3+,l+(Z&%'),($#&)
*l(=&%&()(l&$$$a#F!*d2HvP
Ee	
S
nMs4   Z&U(qeubuٔA,ԟԪ 4Ifш0̆5öZZ乼<,r6έث.8%g+&{#n|ʕƑ)>@T̥B.#N
2mJ>%^)$()))*,s..-,,. /.,*`(%# X
 	@"
x
 "	
KrWXho~!R%(+-/268999}88:<===f<;;;:8.7s53@21k203342162344323221/-N,*(&$" B@4Xnkhs9XRv $9&{$$U'+-+0))/,,^*L)	*+P+P)'C(R*a+)&%&T'S&#!  O   xNhH

7SxA `@7UedI8C(.R
aa>B#u=-ҨͲ̄1ȴdľҿ˾cW1ʶ .n2(oYbŗEΒ//?jWq0ݤ ^#G7ek?)8R !$'))W))*,g,+*+F-A-+|)&$4"(a	>P}wQ,	;`W4?W.= *"$'l+S/2H5y7+9W:	;;<>?@@B@? ?3>v<0:754Y4O4433=4444444F432Q0.-?+(&L$." %p/m0a3![rG~NU !"%())(N*+	*(()0*)())*]*((@(((&S%$$$*$"d! G!s\	"Yi
n+ 7 ImpL0G_\w
SH{,aaezVޔܤahҧK	q9@̿zҸŶn갘f~,Vʦeߤ&QQӠOܗXǔs4,d?٘D¤Uϸ}ҽݮ|	K-aZ1(!$&&3&&(x*++++O-.,P*'8%t"
	<HQz@o*
ae
}ZEv!Zz%1 T"$(,03#68;a>??@
ABCCB3A-@?J=:8654333k45#544455K5:42104/-Y*'V%:# b?*
J
(

z~^u##'+5-/2B676688765i54k3	1-+*'$"|[
Z
c	4V},mO}F.Hno8t!A8L;V ߒ[ ݁׽=Ҋ?ʉG!r)Ƿ)[ٰH.-g\D	!V[ԣf%/ޟpY
gؤ5`	Q!w"D"<!  Q!!!"#&K(
)(r((J*i++K++,--,:+(8&}#w u
k 7 *G	i
cDNMKiBIV! #$'*'.v1t479<=>;?p?;@AfBwBA?Ai@'?f=Z;\976443333C3332.2y10/.x-,+*(%R#
!=^
r
a


v?3U<f5ll!#h$R&*:/0.,-.00.+,-<-*'U&&%"?37+OFH
W
	{ ;k	cbDpNvV&-m%--_pVz(޽޾ވ}ڿةםQoΪv`9|Ōk]VsݹK޴e 0,<Qʨ֦E!ͥ^7Ps%^6!W<͙V&BmǎET4
FLdT; >##;#"U""@#"i"#o&(9))	))+,q,4,,-z..*.-,)4&R"#)oT :#!
6 4YJ
qG3k=v"\g !#%Y(+)/247;=>?@
A?BBB~B	BuAy@><:2975L4s3332l2111'100.-,+$*'(&#!9,179{#_MR" "+#2$$$W$z$$$o$#g##$%%%%&'F(}(G('''W&?%#"5 95&`
	I\Xm =)/l|MvHpdM41%Mu ߰{܎#dڧ'!Ш7˨c_/CA¸~e,ϻsⷘ7o$Vr򮡮ڭdgU|BM1P#ЧF֦. cMu6YԱ׿)ΙP
K!#"!!!"##q$%w'7('(V(,)&****5++E,,X+)m'$"T'>$oj*	A
`Fc}GM !#%'),y.G1$468:V<y=>`>>L???;?m>=<;98~6J5A4R32219100	0L/u.-,+*))'%K$'"
Ea+}RTU !<#%&<'K'(D)**o)((\()('&%u$####! N$L2eYp'z
	0_BOGo'n /2r"O0=>TkRtVs1JJڑ	x׆	׃֌!ՌԏLkW[69Vmb+Y鹼ܶ!jĳݲ@ʰr2Do%C+U_0" NHhMorvĊ{ rHNyRI !!!`"#$%$%_'()))a*:++S+*u*C**p)'%	$!p"
_	a@^
D
3V'Jx6[ ("R$&I()!+,.024x6O89<;<g<<<<<?<;;:98g7v654Z3&2y1/10//k.-g-s,F+7*5)	(&%#! p%N
pMrK_"()*(((o-/2u2-Y)_*--Y*&i&(<)7'E$"Z$$"c ! U9kaA
#	093 _2<%	#F>gQ[$QDnt~UaZlQo^Q*~ؤjgՕԹӹҴ7κ+ʰ?ƵßG\2ݺԷ.j-h
55j*ۨ//ƨc$]J'}=F&ZMoQy{!
 BD!"!$!&!>"]###h$%('%((Y'5'>(P)G)`(?'&&{&$!p"
]FX
R
'` 7;I~KLT?3 M"o#$&~()Y+!-l/135Z78p:;.<<;;;`;::986543210
0/T/.,.-,,+A*m)I(&%|$Z#"h .WK8'd ##)$$%Z''J'&&&J&%f$m$$$#/"!D"#5#W"!! 	!I! yjt?
O
*
n@?JOSC)  9Cd v24(PE:$ ph@+-qSU܏5Hٞذ րӓ?*/Γ˃0ƓĕUF?!{Ny1ZFHffʭQ$լHꭀ}󬌮^}Z϶zКܹ|:[	l.Q    M!!!"$%%c&&'''	(h((=(''&&$"#_q
Fq
	
`|
,aZ~ # !"=$%A'(h*O,\.0135v67e88888888766
53210/...-0-,/,+X+*)('&%$#A" }iOaPu_( !"#.$+$4$g$$M$#""_"! wn)bLgGbN!#

	7\0  \  =.]s2Im4={Koq?߈h݀ >~gڮQׂGӄ[NΟ;+BŵT¤}M*W7Ng{겅 7ڲI1,/rݳC1ѻǜˇ[ֿe Q

1UK*  !m!m"#m$U$$M%%*&&%%/&&%0#Z! 
Lr2


		c	

=yXj>7o g!"$~&'i()+-k/}012;4S5555555z54/43l3x2%1#0//H.'-
,+++*)()(('&%$$!#! J   :zEK;b !!!!Q""C"v!!"R#?#")"!!!L!V MXk3r=

		-Fn8. ANM+s_)/aW`_?+IG\S~C3߁ުq܍9ڑ'?ԫӧZ=_˹s('ȱyċ#@ɾV{YɻzRܹ
ƸѸ举y/й۹}oK6`Ļ/hǟʐ/[Wfu,u~[i*  ~ !+##$'$$%&b&%l%K%%$q" `m !0
J
a



&.T0$~5m  H!k"#b%&`'K()+
- ../0T111111710,0/]/.-,?,+V+*)R)(),))(4(''='&&R%s${#"! sC#'<Sa5'?q|G#,Az"9#t$%'('&5&%$#" P.0a#pEFd&
'
'
?	n	6z^2Y aKaO5'9dcYRWd8ߘr׫5	:. 	t
ξGͮjf̑(˾ŝF/sм,tE+(ŹTY\4TĹ]̹YAbgĸm,Þȶk/!@ 	oFo".jT-0!!!U"
###[#"3"8!R%6
^

Wa>(Lg#kf [!I"#%e&r'()e+,k-..////z/e/G/.u.-b-,,{+*w*))F)<)0))(q(V(/('"'w&%~%$m#X"l! E]@fW&e_ !!} "!U  Q"y"Y!% +   #nX ?7Ep^
pR
A	:?-U)4" C4P?pFva!'
|P1tN	zN~t9߮
`y\J@) 
XтHУ>NΧ	v̯ʓ%P3k9ƂśÊû*.@=$0ï^{zhĈĜnȢ0͵V@@L(&	

d}VWr} !<"
"!h! yS$xE
XLSkln)E+39{pX5 X!1"T#$
&'
(()*q++Y,,,,,,,Q,+v+*z*)l)*)((#('( ('Z'''T'''''['_'a'&=&H%$($#"z"O"""!d!%!   hU4xg?w=Gt*t:gf"(:H

U
a>

	2a] ",)mtL	sYt'Lf#iv
s[vݕܔ۩ڗُرk֫#ԺX
Ӗo%H?Np^ ˥ʏInǷǰǬm 
@ǂǩǁ>7gǂx\*
	ǃ~ƹ[mF	&ȫɳ̻ܞh >
	
J
oC\ 	 ] I lr
!gye24#^wUP>3v;Y}O  }!x"#r$J%/&6'7((b))***l*V*i*w*\**)x)J)(G(''&=&&%%-&]&a&b&x&&&9&%%$$$N#n"! !; ATS"$#!u"%s'x% z ""f2
Gdu VBb
|S
$	ZjWh%.d[c U  \?>L%P{bZ1RflJH!#@ݮ5c~؅Dכ6էZ ԍ@҈.ѥ.ѷI`Ε͐m>̜ZZ̅pFMrc,˶˸˲ː"6˛]ˇ(&Ydε"ϴϡЙ#v;בםUۤ);'KA
E
Ym@[.%VKJwAI;=/p a'7ut F   b 2 u !!!!!9"# $$.%%!&&?''((((((()%)((()d)))*,/[0_.-.11.@++/W0.*)*+*(&S&.&$#}##$}$#!.5 8! 2)!_4
u
?

z;T	,l\d1qP Q4{W.;=^bh{>s3("2ZTާIܒA3$e1%ٻهJ%%ؒ:רP6ռհ7մԛԶԦJ!ԉԼN
! ӑZӬccu=сb/Ј:ϿϢϲVѤҋҨ҉ԌfԠcCp܇~8>ws.> `W	

qm5'TYXNi~Mi R~R':  w!"""a"[""I##i#d##G$$$$9%%`&&&I''1((()**,(/;10/?0_232/-*./0.!-A,],,-,*$*)((L))*U)' &%v&'i&$"[""#!~7+
bq|/*[V[bcCqQ=)	*>z};CEP{L T6bx
E/w!1>R%6ey}
S}a.ݾ܎mEܿۆ]
ۧrpjڨXJ8حrSL(׭ׇqdjׇױLؓ؄(ظׂטץO ֗֧ըվՎGg2uվG׋|| /iB݆ޒSi%9TfVs1~ umVI	
`W

:@ar+!uoC&Yq^C_U5B  !x!"m""""",#####K$$%&*&P&&'''(-(()>)4)")8)r)))Y)
))))~))()'))(W(@(A('l''&&&p%$+$##
#S"|! S " IG|dq[IQVd~7k
+
1
	W	j=< g-qtSfg!m3uH|JhOYN^\Cj|S=X/߳zoߓ߫ߙwi}ߥ߲߇YZߚߨZQ߰
Rz!bGV6hl'Q>@!gd ^sgtmJXg<i#JRt| Bj[.	<

p=

!=.za7k,Pecvw(CT+,8"QI * H \ O 9 6 < B 1 y8h2uf <bBZhZiCGI3t7k
1
=1

		pOfM
 < ddjL>9<h.k)z#d3uJHwm.Jc2|D" qB#o`I78C-:]kx;5No	"+Lv
={cD0tN $
Lq&cLV?xShcV/SVYB  ,LhXnYp_		i

|65
e
z

+qs_,4BmZCkS=Hf~!
IhP6f8B)1b{wY S+w7
wBMY@/	+
J


|%l
x
?

		G		uC:@;u~+W h  ahML<h~:x/O	l w[^K{R/yT-
	&GOA.?d})7<Rv#%F	Swpe:oJvd .d>L/L_*3{`0v B s    K<|P+ #f9Px&QsT	#	8	J	l										
4
Q
j



Ch0q 
"
<
b






>bV6#*36"

l
X
R
J
2
	
~b+yZI>-


w
f
B

						y	U	?	3	3	-		kW@&hL7gq&M|J"`)f&   j 8 n2y5qU'e/k/Po;f@.{lmowwi?*xWDGYicQUdpqkpxyj`RMRXSF=@IOVWc/Kn	0KM5+8A/%@r[D`w
1Xv<oo5k
.7>N^z   A b   /`<h|).4CKBBMhv ?X}
!	 +',K\=TZ_P8$~mvz|gK ~rc@c>
vYOJ/ xJ$	gSH<         t P .   teM#^;zcbO.rgN>)
ymr|{x~}n[VWZUA785760)%(-66>JMMFIQSD5 
&-6BQar|2LWU           
      RSRC [remap]

importer="wav"
type="AudioStreamWAV"
uid="uid://1fmjasasxjqu"
path="res://.godot/imported/k.wav-14347ae01f2840a18568626c1284dbe5.sample"
              RSRC                    AudioStreamWAV                                                              resource_local_to_scene    resource_name    data    format 
   loop_mode    loop_begin 	   loop_end 	   mix_rate    stereo    tags    script           local://AudioStreamWAV_l4hv6 8         AudioStreamWAV          ^       " ) 3 > C C C F L U c t                                       h Q b v r ` L N X Y ; 	 \YZ=nwqM
'F	I/sv<>|hs] 0-HH|v
<xTsekQ-p8)z^V
lu
)/@^;	R:
PF  |  = 
CmzP%reQj6*)					C




SP


R
+

9


=v

BB

//


{
m
n
|
}
X
Vf/

"


	J	/2)p9'EA)*  F CN Y6\;4nE!|6\ v#P%l
I&}RlG_k-Zbpp	|e;
k79[wg]|Rx,ls0fGBl&[r_ M	
b-5ku; "d#$*&<'("*+,-x/11234567899:;;?<<=(=|=>i>E>=>5>>=K==<<T<;
;\:9:9/87E654321v0:/.,N+)(P'%$ #!h_&+NT
9o-	 :\5VSMEHgZ@bO>n_EnUޥ
x)ۆWٳgBֹ/՚Fӓ`wdϗ-c̸FvgZȍLľe ĲcE¬T'꾪VU˻zA<_ǺjBMؿſȣ˦J|KU
|]Y\	e"$&J'()+(/4`9l<3>?fABBBCDGTJdLcMMMZMDL!KJKoMOtPuQQnQPPNqM+LKnLoMnNNN|M(LJHLFCABoA@?d><:85D31
/b-+*)(W'%G$##" P$OHGBP_S

.		
]%,
v



`
[
_A
l	
n8
 
g		mI!R_' >.Tm"dRK*9o'\߃UZQ+պo\ҋϊIV̖
Dɡ.1[Ɲ6b%-Âc"gܿBi὘ɽýaZڻun}k鹘mc>Ǽ>0C|!Ϧ4LM]WUv~ h{Bi5 T"Q#""$)[0(69;=??>f==?PCF9IKK\KsJHFEFHJMNOONLJ8IpHIJFL MZMMLmJHyECEAl@@?>[=w;86c30f.c,*
*)(a'#%" h4O2R003 V
@a2>


N
	N

6BI8<.u dTOWW4|"mEF[so
)
;uWC	&nST.ݻVG٥SW:/[hҠуfϊf͠(An_eƜFŒu3Ũ=7g*ğ}ċñi
տ!{Ά˼߼[qkl8sHDIʇ-ϕЍ1҇Ӏտז9cG"yJ V $*/358K::S::v:<(?B9E
GrHIHGEtEEFHeKtMNONMK?JIIJKL}MM`MKYIFGEDsBkA,A%Ah@>`<:7952[0..g-,+a*(%#L" + [_$o~


)
6
	;	,	.
}6 
v

YIvGJqJR$ZoApl{UB<&-JG



<	%b 5|s	w
M߸ޤsۛb[~yrFխ7(ΰ;3̮zW˽ɹYșTg\ƼŻÝ6üwt°P¯=RCu9pPV,]Ÿ\ٶQC%з&Euy|!uɞ̖TѳDG݀8H!
=DK]"(.3N7:r;K;4:9G9;?}CF@JLKJHF?EDFNJMPQRQNALNJjII+KLMOQRQNQKHGE2ChBCDDB?<`952g0	/.--L-+($!L $D





.R&%P	|
.
gW+36::#Aj.P,?CW2h8hssWz
	4 M 
}X-&߆ޥ|?kګ&ص;׋֏ZTN~Љnqs̴ʫm3ȒoǟrE do]\EY_(ſ,~н]컻JR긜˶M\D=	(h.Ǭɓ QטJSXZSX	tPj`$R+0:59
=><<h<=?`C+GJMONMK	JHHJZNQSTKUTHR;O,MLMNPS6U VTIRrOMJXHFWFG	HGEsB??;7C4a2c10//.,;)%" <1spoz~QtR
V
sQn6IW	
U
e^Mw6kL0Y ; v   !'! pzP
\y
'D"
_QM$lC<Io,[77+W:ۅڟi<TE >ӢVy4Γ,ʹK]qkŬ#Ĕlµ w$dB~ź[ǷBյy'J䮊@Wt6p^Zyjě>ʿg6R5BBB&SY`s	S** J"$).s48< @nBgCCC@DBFCI4LN`QST_TSQ$QQQ9SUWXYXWEVTSRSlUV WPW!W
VSPTNLJrIHH
HvFCA>:\74;31\0/-#,)&&$"z 
)ikm`c

B
ls.).w
08pWxV5v~ !#$$"!! e!"! YBqWu,%(5
k`	 };} 	f(]ىI`F4ӬҦҭVҔѕЕk̴˟C˸mi.tgȝ,ǁƝĀ3Éáy/5̿pa~tBνV»o+󻐻)~JmQT,ʶu-\)4pȮ3 ݫIPulO[TZO@͢zSݘ;
'!#&'(*7/4:'>BgFI.JIIMK	MeNOQSThUT2SQPOOrPQRSS|SQOeMK9KKLLN:OoO	ONL/IFDCA@P@?F>;853=0-H,2+1*F),(P&#!)vhYeere!r
E~UJqj	~ "$f$C$#=#""$'(5)))((E(l(})W*&*('&_%#""#$f$###e#!QT(f
CMYHRq2\09aܕG܎>SڏٻׯeNϱc^)˭~
j=ZStYܵWdXͲ&=UYRϦ,u򣍣8ѠA58VŜ<@i)ؚeח&A/Ֆpw7~T2Q!QA
&%8*.256y6T5l680;<=?"AGCDQDUCCEILM>MQMMMLKzLsNO#P*POMJQGfC?93. +'$"	Vn   
5<
 { o"#$H&'*D.1n497:>RBBEHKOQS6T;U VU4UT%SSOSS7SRdPN|LIGFB><c:697^5210.+-+*N*1*	*!)&"wJ{*?	AF>xvdZ	`LU.


		

eQa
KE
	j
 SWL
R%޺܅ךqm5ˡ+ƪ]Md;Ysñ)qͥ £򠋠jq&(lӛÝgPßg:ǡ~{Ußɡq=AFh}ַbӺ\ 	'2L_","6V<Z@>EiKONKsInI@IG!GFVEC^CRC3BI@?U@UBCCB-A@y>f<:=:::]:::k9683..`("~&
w Po9[d BP
-&m#'P*+.0e1224e7:m=?OBCDF'GHIIJLtNPQDSTVYZw[\\\ \Z9X UQNJGDzA%?0=:_84/*%!RN}Y3W#:Wg	 j< "-#5$$%$##,$2$)$8$$#&#! ym~C	"r ( 
s-+(@
v_ i4jڙ}{ӕ"_ԁӗh)ΛPP˜|}Ը϶ⴣ̯ܧO%	ٕٓ-Lْ۔ 菢0l"gђOۓiݕ&ޢᵤQ[GnO=#$*2<@HHPRSpW[Z^WSPPPjN{K\HaEBiA-?|;7]6378851%/,b)&$W$$#'#"o!@
1| HY^7||:^| 1$ .$*06;m?HB!EjGHEIJMOQ*TU6WW4WWWmWVUU2VV2VU?T)TfTzTS@R2QPNmK7HDE?:G61-)%!HHD	E : C
$
<"
$]mr q%*,./q367I6580<=w<:	;;;:767H87!51.,*'$=": ;k'=dtq^h=AXuV	yZoEDqTܝfX/ҽRκɫƮ[:ŷ˴eRIOҦ-}ڐ؎ЉE^Ņ̓`m-]sPB]`r͗.˃֚%KZ"(,1(;]GRXYV[^`^ZXTPNDL
HBZ=9_7E4/,w)'((('#	 >31hS
2s
BD+ QV#@+3A;AG!MQiTUQVV"WfWWDXY[w\x\'[YXWVTQP0PO	N LJII4IG=F/ECVB?<72.(#v
f
? rgK 0U2R >#&*@.159{;J=%?ABDDADB@>z=+=
=<{<7<m;:8\6530q-Y)U%!MAYF&=m	{)'u W&C3BM\Dr)@mZDu#A+^׬c(rDq1x @(㌧Pۈċ`<Ԋg捼ސgLѝy7\7ѣ)=Ȑe;
!#j&(0e>KPSQSRVYY)TMIHG|C_=6/+v)A& d&l!"X
0C
= W<!x	c	I#F(.4$<C/JORTVXXWTSbTVvWUTRBRR%PLJiIHHEcB?>->=<:9998162}0-X)#fl
=tH $_x
.E!""#$|'n)))G+.3p5167@9T;8<;:j:E;<<<<G<<];6:87716241O.*&!c[C(
e	7 NmB}DvCIectadC0Cctjmy.ݶ۸٧}Τ̦lƐS些P)լ Idf7/P[Q!ubyِBeAyfe^5)Sm6tתg} kbZ.>p %.:DG5HJOFRN/H+C_BB9@9u3.*& eE&A4j<\L E-G
k%-t
UcRc"g$r',3:?vCvGKNfPPOPO:NtN*O,OMVLLK?J^HF.DC(B@7?=<;;:9X8i76X6q653s21I0,(#c v:\k	<m.	 kyBW}!>$'*+++j-/0/B/023R2.,**)'&(+[--,++2+c)&"#!!Z!BRvo
+	j# TayL7YSVWh*vo+vDeޣx؍ғA˞ɫN4𿷽úùӸ.ֲ0ܬvoΡyBbpItY2B[4ܥF~c&]ժv&ťޮ$;ޔgyQ *6DBGHILONIC?L><8-3,8'#&" !%. $
&# @'WzKK"##q" 2/e.L
	5 

O{ 5% ,3:2?BFIK<LJHoGHHHG]GGMGFE@DBBAA@?=*=<;:J:F::;I;I:986M25-|(Y$ W|-
m(  Jx	 P
<x "^"S"@#%K(n))(*x+,"-+m*)'&n&&)'4()+y,,-,P+*)P(t%!*

g
	(J!ar_4
[7P=0wY_]@QPZ'ݥڢSoj^x "HJOȤ{Ĭ¿zbݳ|"̧"PڟZz͡Kӧʪ.`{=ެw4yӦƥj2Ig[*JD]9CO!%z/;DFEGLXMnJDR@>><:950+('\%a"l "J'*9)v&$u#!,GW=@\+/i7[V	F
- $(].p49P>>BEHJQKIIHHhII
JI'IHIuHGEEEeE5DBAANA&@>==_<[;98e7a562].* %" Q
y{	 &wl}#{yz
R "%'(j(n()0+,,+++*(&%&'(}(()@))(&V#b z AYC
	.*	t	}	MXdPGo|?&0)7@>tcdT8jNkTU}[>ؑԜӓҩѩ('cNÿᾶ׹޶6|ez,~0.rʩѬ¬YOCj~8GCt@!欻ݨǩBF<`Z!1$|'.7>6BWBbC]FGwD^?;b: :740.)+(%# ! "#!  ).+v
C]fs!'v#!$
)-T27];>ADGGI]IH}GsGG>GFFzFFmEDCB{AAAAHA@b?>[>{=%<:[976<53}1.+'$ ~ZE

*(bv>p	^4!j#+&'f'8&E&(+,{+[*+-.O-*A))**A*))))('+&%X&L'&$X"!;m-V		p	1)_{43GX:-@   ljq!(Ynw}%V0[HV"ޏk7T٘ر]տ1ҥ4ϸl̛ 
ʸ<ǖũl3締0)4̪(-02Ъ۪ح]9}T<ٵp޳*̱4WǬJ3aErK''3<s???.BDCG?
:77o73.~({$"!F !d$S$," J.)j+j 
F[P^ 	9
o ; #'>-V38<?B-EGAGEC&CBBnB8BAAAA@??>>>><;:9865*544!31q0.+'7#*{
	&`* 	  	
"6C O!!"W#$$&(*++K**^+^+O*w('&B&%~%)&''7()*)Y'$##"a!1t!%
L
7K ~ 
D' a8if/nm(UaO[s	-w`S jm^7Qؽ`$/F[Ｌ򷫶P\"Q"֯ò$mKJ,ѳHϴ޴Dfĳ:߰\PթO>ʪutð3Թ	Y"Dx!&r/8>?>B@DgEC=97)750w,(&$" u'# !t,,?b
N :Pb;{>ts! K')J"&a+059=?*BDXF6FE(DCCdCCBBBA{A Ad@}?>.>q=<<S;2:87o76y53M21F/-Y*&"7?Ts	kh EA\C[~9Wj!,#$$%W(B+,-:-@,+X,-..z-U,++^+\*)((V)(&#%`$#" sEy
EA	V    Vj W xB`54x:`\iJsld`#8{xiߏں٤Cו"ӂ:lKTƚxܽعkHDƴԴ}ֲ/Uɱ< ڶӵ3}ŷPqϱ ^᭕*ͪmHJ\~4|[ P'.5:=#@BCA?<;U961-*&)")y	i
M6gS
blq2^fcZSVF"&*/)5L:!>@@CHE`FED<DCBBXAA@@?>=<;;y:987;7V64a3210/.-+)r'#oruw^
	%!u[ !"#$%&(?)8*++%,^+)<(<'&&g&&[&&*'&%$$#!9:e
Nf 0:7AlaBwt$ - 2rXy*CW Lk2	31 ޿5ٽC֒<ֹF3EԫG/*))ȨǼƔŀgF:45BPlJ=47V9_ջM,]oD⺓ǹ
*
dK,uɯhnլX:ơ2D$i-4_8=9:>A@=9F76U51-k*'%# I-yW:


s v+o%zv)v l	
f!%)-25i9k<>
AGB>BAsAA@d@`@l@@>u=<;:99877643w2N1I0/-,P*:(O&$D"AKPcdJE%K$cg< s
~w0v'!E"##$j%&{'p'k'
(((/'%##6$#""4"B#<$<$#z!hu
_xtEB>  H
(chx-
UG7J*|-T7vPm]Dnx01q;߸7}ޜܕ܈܊.܊۠ڡټ؝45X}ёЏϩ̥ozņ{Õg&@U佢$Ѿ6|^̽U1S/}9''C>ԾbE:	P!d$)/Y4|689;;L96_2h/9-c+)Q'$K" lhsHvG#
z
	`@B Z&9 '/SFI #)'0*-/[369w;=H?]?>==<<;2;:6:t9'86(5>4*310D/.,+*)e(e&`$"G! Hh`P
n 0|<q

lA< d!!W"#$`%$$/#G"h! \#p<IA
+
		R#g ~c\b: t ~V
;g
<ut*&V   i%~!DfxI]@a( rKu_#DߡvDrްݝuN1Hc.־<{jωΥ͎Nej/pÛ}bc'}xǿW]2پٽ](Ŀ t`-,b2rmŽȨʞN3F;J "'"-g12\22f442.+,*|)'%#2!D	W4]	;		eK# 9 e x I  ?FJ	 ]#&(5+-036K8M:;<"=<A<|;::I9876k53!2I0.&-+*)('&S%#j" (UWZ
|	KUo'F;~	qA
o3"  |
w !6"_"Q"-"!\!    x )mbN z B,Br

0/ !%Oo Ke$	P<c D?L84S+)*<{B/wFݘ݊CwpۚL(WyO
FˆP:oÎÙÇ
è¹3,=éwES@ADJdEǬǨ8ǕYǶƶ^FiǠ-H ɉ-̩βix٧_"Vcx M
=2B %	)+,-./.],s)&%{$" b]vsXUbYA#
5

e!"	 /+~jE	0
H6"\$&(&*V,.024678?8z76d5p4322#10.-!,*9)'&k%Y$o#""!faxr21OB
9
	y	?	h"6F		
m
6_Tj  ` c  Y 1P \! 1oY
wJ)J ]	(i>^  A   v ~ {?( jMp* v7[ o6PT1;=EfpK1"߁8+܀ِn׆֔KԢЄi@z!D5hsŘCOftkOo`PŻ (ĭ>\W0y>ŤĜ</doLȺ[YƋ;"ɡʫуԑפ;ޛ50C\c	o
JM!%*0--V--..g,)~'8&$#s" zaS$4W2`?-
f	\				


]h1 3#%'*+-K/21245666s654323210}/-,+y*')'&&6%$#Y#"!)!) B
>oQ(i
Js}

QE&."07 U:   !o#%n%$#1#"" #$C%%%#"!A;o',N
{
k	'!]_zJp]  |t;:) z       $ 6{D0kykqGfV;X@8%|=T,a]9a߭ުݚܽ lDE% 
̱IgřMpĎŶP#	b:ZKÀ_nbģŹ}}\I!}EǝYǇa?ʘ̙жܚ\#	>.9 %*- /~0222/A-<,+J*'$%" fx

;@0
rs
KKa< !#%6({*,.135Z67:76@654(4+3(291M0{/.[-,*)('&-%#$u#	#"! <+DF63lO0)0HOgk:zM{ "#%(*+!,,n--K,**y**5)&#$"!m xV*W
6+f i 
 7M	HA$Qo4Ey$yR@=eG<r;
9pbcܡRۯQFٛؙ0ֆuՓԠӵ4}ZmznR1l[ŠD_Ƌǻ}-ǊȰj+-|Ǿ}J"DQ)ƉŏlĈ&Ɨ`ĶÌq=~ɇѻSLۑw4J#'A*+-0110O/.3-,,*'\%#5"6 &[aKIYA-s&;e
y=!"$_&'c)+z-?/1i2L33p44432 21%1i0/.-V-,b+m*))`('&%%$$A#"_"!!	!Y  M*$4B~F!%(*,.1p3g32234317/.&.,)%&X#2!`{
c
Sn ^TTI,I,\,]i V  ~!p +N|P{Bxo"Nߏt]ޤB1^tڄzZs{ب׵ֽьЕϽΫθ3zt̽ˁi˖̙ ?d͕ͬ͗WͰl˛˩`C˙̏[͒{Biṋ5nrju>XM̀$ϨσаB~ֿF>D 
,5	
{ 8"#<$U$j$$l$#"!1! l03 z34!*US*W\ r!6"J#$b%%5&v'))!*d*%+5,,-,,-0-!-,++*e*)4)k('^''&&%0%$#"J"!!>!    8 Hz q!!""j#0$%%&'),/ 100Z232/;-,-I.+'$8#" C")A
	T"Y-vp%p{
oX-bhT >lu{h*nt4Lo--0XE['ߧߖZBލ^1?F*!4ҬхtEХА5#ёЄZєч?ӯӧR Ҳ"njЭ͆;̻̀CZ̄YT8a]:б
ӚӀBh' ԟSnԳ8"ԅU<F/؈NܺުV-y~ 
J
2m+-7 /(M^t)OW+Za1ts\ !o"x""#%%&[&w'(|))*v**A+{++,I,},,,-,,,,Z,++**")	(''S'c&f%5%a%~%\%%F%%R&&*&&]&&^'c'''B(())p)C)t)*,,,L,g-..-+:*V*0*(&@%$p$&#?!w0P.
51




J
0
JaaK$ B;^vpSB Zd*z)6hU#@J83vݯۭڥٷxԪ1ҲFOPKԞԠQ@qӖQԗՇa+՞եTՂ%գoע\גeE֩Qeן5 m+^*ޯ߭h{!8^N<MtF\cf[%n :P	
eK;!&Q$}~oR.t P!!x"[##0$G$v$%%&('''s'';("(''!(j(9('''('''F(W(C(~())*W******)))*)C)N))})Y)u))_)((,)	)z(X(()Q***)P)9)(b(''&&}&&e%$##P#"|"!Y! 4 59nL	;eW
YP
d
	w'fFD\
c (`,q.llfc(f;3W!lQ1j-nMV
y޼ݻܼڟh
{ٸ٣y~+`Rkڋ"|ܙܴUUM4܃Py۰\ܳAw	9یeۯz|٠قm!زJm.ٰٯ<k;ep\ܘ-<:Xދߧy]eFY%IEP6fwgse2ZpMKb pM9R~8@B	
T
w)8c" =!!!c"#$###$%%%o%c&&&e&&f&&'&&C''4(a(o(()D))(T((:)1)(G(()7)('g''+((5'c&#&[&l&%C%$$:%K%$w$Q$$$$=$###k#"u"E"D""! `  !lF3qka  	%XB
|
%
	
 ; o^2aG.{Kx/uQ,KSD^@T%&N+
alJ<w7Ugh?iNTV0Q_-'H0{,}b6c>!3[&1 x:_nBlWMAXK!_!1B"qE|,&
W<X>Kq#E[]>vvw  ;*  lg3y	
:

I*CYS3
4X#y8`AbjOfrX-N>l
=|-XDTQBZp(;SM%%i*e
C
&o

	X	pkFIPC1P 7 ~
7nix@qee#vMTbG" vSQM6h+}[xwB`[gP9?HMF21ID+OY"%^g\0zH,Z9nLUH=SG~Jfb?%9gXUpH{D,F@/D   3DMm+ %3EFKN%7@{S		

r7} 
~





"D1

	+4.9@PI)





hl{,=-c=nN0-3;VFe~~_qQ.u#_

)


oD9/!%q'


z
H
				h	-	kJr`W:!p^9tZ~[?o(l  | Q  3aZ^{oTME5m*:Pa\m{}^=<ZhA!u_G;1\i,zoRA-*C*8	2Ncp~m .vwUbyj">$O@CKiXHX6t2"?e )    @ P I B O _ E    + \ x   )*,BxaNA~=q6BLVQE-O&lURZ;!           
      RSRC         [remap]

importer="wav"
type="AudioStreamWAV"
uid="uid://bfeg8i6m50dne"
path="res://.godot/imported/l.wav-5bcff1c02a9e9f42f607e75a9c0cb0a9.sample"
             RSRC                    AudioStreamWAV                                                              resource_local_to_scene    resource_name    data    format 
   loop_mode    loop_begin 	   loop_end 	   mix_rate    stereo    tags    script           local://AudioStreamWAV_qmgm1 8         AudioStreamWAV          U                                                                                                                                                                                                                                                                                        ~yuohda_[SNNLF=9871("""!!#)24588759>GXfkhl|  ) 8 M f z           $;Vr%,+27G[j~ 
$(/9GTae]bovy}wrxxfexzzwtsqjaUJIC:+&-.%k[N?-%	tdK5!      ` 5     t^O<%j<`F1
ya@
{gPA2	jjf_SKHDKYf`SWXWY_kv}$3BTajs!Dm16BTu@Q_%>]  ) K s    4kEl(Db<j&]Gl}#Ah9cvw		:	L	_	]	e	~																												u	o	p	g	V	I	<	#			{\C*kH*dBtLvJ_3 Z0A  a + yA|;v8=]!NNTOUU]v2{SWp_0uV*}[:"i5
`FG(31Djr}YDIB@SqA}DAw@ ZZ ]M&P s	p
pdc
fo|5cz  !"#$%&w'Y(L)3*++,-~.8//0^11{22~33y446555D666727Y7v77n7Q7/7766N65554/43(32
2n100f/.--4,a+*)('&%$#"!k Dc"|*}E
r
|+ !/-@COo@3ހ$ډSլ~aL+͵̞˒}uu}ƐŦQӿ-IXƺ="R<⶜g=ݵεϵ+Oxmķ @ܺz!ڼ`,¦Úĝ-mʳ]wmלzG(.CkYCHF<318T/
H#N!#%')+-/12Z4l6`8J:A<5>
@A~C*EFbHIK-L:M7N<OFPAQ=R<SPT^UCVWW5XXX#YVYYYYYY{Y@YXXXW_WWViVUbUTSRQPO.OeNML&LHKYJBI
HFSECBNA@>@=;:8@75F421v0]/<.-+
*`(&$"%!n~k|
P	t_4 CgP7VM t<$V݁ܧؽ׫֣խcҶUС]δ͎/qzʅɀȇǮOŌ:Ġ-ķJF25ؿQ	ȾKɽx6XLI8#.Gg~@Ž#r¾pؿ37BĚŁƚǞȉɈʲ)lϩ*ӄ	֤AڝtO!tHa#r`ad0
T}!U#@%?'@)L+W-h/w1v3b5G79:<">?@B:CXDSE@F$GHI'J6K)LMMNOFPP5QQQQQR
RQQQrQMQQPPPEPOO ONMM.L*KJIHFED{ChB[AN@<?,>!=<;98p7:643 20I/-|,+)X('%L$"!0 Qu,Tv
nNp
	c	[t`cq g$dw"3`w"4TYTa55X^R6Wl;R w9
U

O* oU	2p4޶ݭܽ 0F>2 %ΛX˰2ȩ2aڿZ%%:.Kܲ2FҭD5߫_%,_xӫLbHQ۲9+ธ# Ť7ɄhpυѵC؛$ߵVEwP~eWp
 "%1(*-+02468:<?kACFkHJL@NOPQRSTUVWXxYZZ-[[[\%]]d^^)_0_ _^^]\O\[I[Z_ZY^YXWVUTSSR%Q/P$OML
KIG[FDCfB9A@>=<l:865/3\1/-(,e*(&$" =GiP
h
	 Wy+vJb2HFW&tX9#,\Hil)P(s%l%Nu(75(s3s'A@C4Y&O5p '+$ܲۀGֆ8vg?ʵTŉ&zҽY@KSvȭx	Ϊ[-$4XȪuޮOرV%N˺*g>(̟ΆтmKݽ8pyXz
Em!$E')+-/&247P:J=r@CbF I*K MNOQVRST%VNWYXPYMZ.[[\]^_`abccccbJba`e`___X__{^]\[[=Z`YXWVUTLSQO0NLKIH	H=GUF?EDB@"?1==;c97	6`420.Q,*'y%c#r!l!bz

	jl^ 5Q:\I3Z#:jdFa5P1k/)* -n37Qxa*uC{LPL-Ii?l3M]v߈ލ݂mG׼ր2҄,Kng^!d.nزm2?ħ%uŤwDԡc5*>v졞ӤHͧcTMY*&mڶLzRN͓ܛ8OCT5	A
/!%5(B+.x0257=:=@
CF;IWL8OQSUCWXY)[t\]^`"a%bccdjeDf'ghiij)k=k k}ji<ih hggffqffEeIdQcvba`_^]\[UZX
WRUSQbPOMLKaJHOGECAi?F=6;P9v7y5e361.,[*'%u#f!~78Na
M
f	RcnP 0KBq}nZ]`6iNl+O'G^E2y^KCn<LuuW@-
m>;FJR:1e	U!YܞۃO
֡c%Ѩ:_&};ą%E1i׮ëԩ
@ڣQp$꠭zV졻ף8IܬN^е5
ÿz:HύҜՙ؎i X7LJ 
k#jg #4'|*-0t3682;>A!D'GGJyMPS=VXwZ/\]!_}`a,cddefgiijwk<l&m'noopqYqBqp`pooknmpm5mmllPk\jUi?hgedcbia`^\-[FYYWUSbRPOINLyKIGECTA"?<:8642B0-X+(%&#r!OM_iqr\7 
H	#v9 N7Zw.Kk 

xdX_~gh9kHo)Q;<%'3{./n]0|*y*5pNT92{PU7JL?#݇<٘2׼0ԐWF̫z[DOm!į~B4MOOXŠҠ̠N4
IG(ƭE
@60׿dZˊΦ8c}ޅc3b8

BI #+'*-1469?<>cADFILORU6XxZZ\^_`b.cpdefhi	jjk lljmJnoopqQqaqqpo:onmTmlolkdkjihWgfdcYb"a_^#]z[YWUSQ)PNLrKIdHFDBq@@><97531X/-*@(%# -
eC	AnQ{iN3/;T~T.FS
)Aed3B(|F8&]w&@Tj~?ZJ9k_
Ao%DUc{zb=x/܈?r?ԙ_ϛdȍƹ4jķ
pٲ9)ìYɨkwHʟ+4e[UGNt$6[C 櫥(zݱ{MI5pXG2Ѣ5dޜ1S= hD"6&).-0379<!?ADGG*JLORUX[G]_`3bceEffghijklomnnAoopq;rrKsssRsr^rq'qpo{ontnmlljih6gedNcb`=_|][YWUSQ&PnNL#KoIGECZA?<:8h6:42/-=+(;&#-!p^fz
9h &mO'5y4RDNUC#-Q0{GDbXKUgGf]9=(DRQIFFF$^s
mD3ve`	4gp,ܢMsfKѸ.s'z"oٹ)/_dӨåͤΣiס+b7靓;㜹Ҝޜ؜`䝁CFv:榨]߶Ը½ȿ/¿0ǫBYH]߅1_ [\F#&*-0N4u7_:=?B@EGJMPES&VY[8^:`aucdJfghijklmnPor~vEwuAuVwxy(xwwww)vauts:s]rdq[p_o/nlkjihecdb(a_][YWUSQDO;MYKRIFGlECVA>1<975^30.,*(e&$!hKPz8
+
K	)" 2
&M"McU a\yeM`.
7TB<uE'R+ |61{R5U'fi<m_qu]O=9dCR/K"Xܾ/٣˯xZ;!71pȩ<.L%<܏='M҇uz+oa@ˍ}Γu:ˣBw޴к8͗D jr:]"%()*,.02	40689f::;;<%=D==>@BC DEFyFFRGGGGGGGGFED.DCBA@?$?@><6;9876555666|67788E9/:;
=>@B0ESG
IJKLM7NN;OOO$P"PO1O>N MKJMIGgFDCB]@i>O<=:>8+641/.K,*(&$" x#%d_ckQ-!&*YT
j	
k*$"d~#!v'8r
7
M6}6y u%f\|
s
/LT?xUTP+٫x֔(щqpǅNoι׷V밝^ףC-řѕÓǑNЌ3Іxz	IׅfΈwhĖɘƚ͜
zqթ˭V?xwA0I_XWf#"')O,/0{479:q;;;:97f655W43210/-,+9+i++,A-/.y/0&1111222S2{2'3332112L21[1^122L3;33{45=78:=N@BGEGJELNPRrT|VXZ\]^&_Y_^][YWVTQO=LiIFC7@<9F742S/,*(&0$!jtxG	R	
 ":??v 6Oj12g
st!@#u$?&(r+,2-C-- .-+)j('''%$#N#"_!bZBy'cB~
	hLsmbae/@yc		^



K
	4 3V*/gA&և3S~3)Ī𾰼̶ӱ/ST #pOᚫlǑȌ܉}g爆݈]
6>1ӌq0dٔ0yU>ĝ1Ϩ_űe >EŒej#1s`g
Y #$%(+.0B/...-+)(Q((Q'&@&&%q%'$#T$%9''B()+-.a///12/32p22344D4q3G33
4333X4g5R66d79R;d=I?_ACFIvKL<N"PRxSLTTU%WXnXLXW W@VTRO\MJHF6C5@n=:b852T0V.,.+I)`'%$#"  aQt>
"
mD1(M6\ *"
q(,5 l"#%';))r)P)))n)~(N'>&%%#"!K 8}^
I
x

o
h
)
	D	(	X	u														9
K
A




^
I
	3	4Q8?3Y-R`L'
(6GiԾ,uό͋˻!vƟĎҾ'ӹĵ"`O{ ĞK?Mʖ"甂̒^fߍPҍI
Ǔ`mݛʝ*N%ߪC	"HƮk@[R-Ti
8*!)#=$%(+	.6/h//0.,
*,('%$#U"w"i"!! & Z!"l#$A%&4)*++,-///Y//11
211&22v222234^45I6K8:<>@CFEIJzL6NHP)RHS(TUUV*WWVU8UITRGPxMJHUFiC?<9~742/,&+)F(g&$Z#["B!h!;!%
w	@s7# p _
V*.% Y"%n)*)''(R))(&$!%~%$(#!7!k PAtCB%(b$
I{


	~$-	 	

5NW
RXT\
~

<
	:U \n6RdW޵nܙd\=.Ό̤Ȩe

79yٸ_BIﭣ6O?2z^>
Ĕ{:Tћ͞ zOm6B&۬٭Э+R[)cXIkH_ 
u
lw"a%v&7&&''q&4$""{##!" M +!!:! #1%%%&
)x+,e--.f012D3357 999F9)9886555d6{667w9;=>3@ACDE^E8FGHIILJ;K=LLxLLKKDKIxGGE=CGA?R<69963\1/,**)(Z'&[%#b"X! Q(]#4Nk

	P<v5Y+	BD3	
^\^v i!  S"$%%g%%&"&'$! f n@j ,CN
0

		B

\VpS.
k



o
F
5
&
			Q	\1& hN8{5]aBPjCڲԢҝȀ^ÿjƺIr벧$Si"_OӟȞ! ƛ暥Uۙܚzɜ=D	v)̪.{[Vصs
 >[+
	
=
.!$%%%%%$A"= lW{}3k>j !##D%&(!*+,-./011234u5`555D5U54z4h4456]6?78:<=>@lBCDD2FGHIUJKKKKKKK\JJIG7FfDGB@><<*:75j31/.>,*)(k'M&:%F${#"! b5u@au

}	Xs=ak:;Ff	
ID@[
	9 D#$%%+'((7'\%$$$\"[ =o
5+[p9

I
\
VT>




'i|
F

q,
a


9
M?g
	(y |81iP
{.I]8ռ9\ή&,x	Sƽ!e
,L۪ĩ¨fV|!(`zF2Qҡ΢ĥ1{Ԫ=@ЯLᰈwMִ\g}bRՌJ .

^` !"I"	!2u2 "##$&(4*6+=,Z-. 0000x12M3333/4<4322223H334D6709:!<=>? @@(BCDEFGHI
IHHzHH:GECAM@>k=;97Z64204/--S,+*)( ('4&g%$_#! r?Qke,e
Y	['+R	
\Jq  pW ? \5,hio#gf[
{
j
N
&
M
J
D
F
F



r
B
;
Y
9
V	eywH8C^y ~^W?VLr4JK8_HB܍:6Cїϋ͚ZȫXÿcʹŸ!rfݨ7&Y;tx =u TڢmĤJͪ⭅%ܯ3dEsAzVruзN'WP"ϲ\|	O[N#||<n(>  " $&o'(*,./90}07123@4{44565&59433333p334568
97:;<=Z>^?@BC	D$EZFG*GMGGHiHGFcE4D	CA?P><o;97+642R10T/.-,+0+*5*)((('7&P%k$#"!w i-1


	G		&		
>

Lx4  ]    _ _9q0C+83G)G<5(_V7

s
"j/=6
+H[^OMv,i
	G	;
3EKZ A!ryl
-~
V߲GNMfԚLϣ˹4ą@Žp$ܷس_*î
3a8;)JxȨkbqȭy|аౡ޴(]Ϸ}
.}DfĶ_ϩu>:Oi	k
xtw(%   dV~mB!z"N##%&L()*,.011223345544Q43732333/4O4j44567E89::;<=+?@DBdCJDQE.FFF0GGGnGFIECB>A?w><N;97f64Z310/5/V.+-++*C*)
):(^'&%$#""m! D3Q2ARl
s7

B
T4cL&! !$''$#$%r%"	>;vNq	4"<ISH

J

 5
			*~RO\ 2%
s	w||5$~ޜےnIֆ<κ͏Z@(ɟǲç޿xsJ~TѱQ򰔰LS欑{묍&oͮJNa󰎱F1a	C&ʹ(
v'-SŁtOw7EHV/2Oc}1Q`K V!L""#$|&';((*+--@. //01151<11B2M21~12334]4U567>889:;<8==>?v@@ABC,D8D?DsDD=DCC@CBrAE@?=<l;O:a987}6533D2j10/.-,,N+*)N)('&&%$#"##" }) !!s " y ;~@vbrzTj@M^I&T?41\`&~u&SF}u_Q



m
		b<m hgiNt+!c	b_{* Nj#ہאvvdBϙ·k<OɿXz۽fjF⺞ExڷBy˷F۸8غ$7ڽ"e YOVOÖ4Ñà ĂĈT(OģģkĪrŁjYƱot9ڒ;P:qm4r	ivH7Xo0!""p#O$*%&&'u(u)*+s,,-H...../m//40}0,18233544.55}66637789:_;=</==>>u???@@???(?>=T=<;:98a876
6555r544M443R3^33A445666?5*5.5`42X1000.Z-e,+*x)'R&$#
#s"v""=#""""""!j!f!!!
"!!H!t!!m!s a74&i:mqi=-4
`:
	pk c`tr. V-5GP3Iu=y5e۠ eٟر׷SԎ-zѺGi͏̮˼%WƋŽ e,n#񿳿7cI:;Nkվ,h׿"u?j^usUÆÿĠ?ŧg';ni
ӵ87יظ،ٻRKڬيfp#ۣI_$(ozd[ 	
_*7jE`I-'l !?""K#'$%%T&&)''()G***+t+++,t-[.%//0l1222i3,4/55668d:;<:>?J@@@@@nAAgBCEEEgEEFFEBBBA?>>r>>><9;:":	97G766665O55515Z43I332'2J1s0
0/~/x.*-+*r**?)()'&&&&%$P$##E"z! _ 6_|hA

y	U><DhQ PY<CT:=O`y?`dZ~ߪEݣfݗD15yfں%qط,֘8kpҗ)ҫU?*ЭjB3>TOσ; ΜΫ>bC,<σϪg
}-РU8Ґ:]XӐSԋAe֎֧חJ؄ؙ1کU_iFl}p	BDxtHcmM:_(4)Y9S $`&pI		

	s>}
|x8@.MU^SjZd !}!$""#G$$$%&''<'<'''3(0(,(](((e(b(((A){)))0*V*R*G**i+/,},q,\,,,+-3-3-O---l--,o,,,z,M,+6+o**)))k))(6(''	'#''&&&p&%[%:%%%b%$
$##o#	#"j"4"! Ij:]7aM(%\
H
	8\C	;u#  Bq@R!)Vxi FZ 5O`X"~=m#`*fBKI


/QeteVVcrzyV%aVFGu*?\{
Tfn./Js[0"=h]2qm8.j8GU19HZ.V}PFj5_R  ~Ci|*L3	



r%#"b9-D

(&?4<ltOp|M2'"_5-*uz<ImUPKnId
`*`*O



Y
t


p
"
				P	L	g	d		<	)CFPa!<z^V.z]J#i  
 cYHm!CHb Cw1mG)I
_<vJ

~|Q+*;2[mG( AQUG;9_y9n0L9M
Kine	$i*`fpA21 o?p?JzW
Q3 O `  -	&G(zkin%QAH%0&*S?l*\			>								m	T	q			r	e	y							


5
m













m
T
^
x
z
<
			
:
Q
N
=
E
A
,
6
m


j
k
s
I
						\	$				X>9OeU%]Ocqo6yE+ L
dCR9!U  ` * sQt !DA)@K/tIeCd%	ynJ0&"sP<0-)4ACOXn+Qgjc? ->\QswL,# '/%*CMd2O]q+E@ 6HVWYvQXpn/ h    { i e r    >fnbLNepv|n-?Vdt!8HINimcprR  2D?679962ycO;vaK6///$/,   %2,  '2Dc|wnpqv{vdF+.Ea]7        { [ K I O [ j e 9 nZJDDJ9'!
,5Nl , ' " & # * / )   , 7 1 )  |{ut 8 K V U W V X i                              z k c d v  y h Y J * mS:'&2@G@0$xlYJ=71-/xklz>_u)Daw 0 0 $       ) 2 B L O L C 3 "  # = [ j o w r o p s w                             
.<FD4                                 z j t  { d R X [ c b a h s u i J $        1 F V c k l v ~         &/(
   ?S_ippv{|v vokcehqrhXRRSPE:<B<'
             p J 4 (   	   |]LC9! 	
~||rbP           
      RSRC         [remap]

importer="wav"
type="AudioStreamWAV"
uid="uid://0jursd13dyya"
path="res://.godot/imported/m.wav-9bcd0534dfa43e2287fab20a133584a5.sample"
              RSRC                    AudioStreamWAV                                                              resource_local_to_scene    resource_name    data    format 
   loop_mode    loop_begin 	   loop_end 	   mix_rate    stereo    tags    script           local://AudioStreamWAV_wm64g 8         AudioStreamWAV          b                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         
    " ) / 5 < C I O U Z a k w                        	

                    g Q G F ; . $    |iflbG'	xT;*qb]\[WE.	#(!/IP>/1ANRSJKPRYfsy~vsxpeYbfhkeddp
&65,7X|~/GF3)Tuhp}qn " - + - / : A S d l d _ g t                 
-<FXs"&,;b+4Hbz<]eXNPb}1;ACITholf_cw{rvtleYND<u`C3/%iM,oF$}=
   V 2  m9
Zg1qHP$Hg8f7W,F_1[ eJ2vRA2+weVXlujddoxohvEk?|W&a7Py
hJ[@=2  DgsxS_	@
 Y
Tk3q!}-v"mF  D!!""###x$$%b%%X&&&2'^'''I(((((((((((({(p(V(<(%(''D''&&)&%!%$,$#P#" "Y! . 2hOgvIYUA
:AB
A	5H -hS<Y7lQ=ߪޥݠܥ۲-Eyұ*Wxδ}bʴɑȕ
s\s
ĴT\CbF7ݿw_ɿܿ$sEhLÚıi*ƒ3F͹^ѝov׌ٗ~D4 1InOj	
x"$&(*,..X0n2/45X719!;<>j@ACCEFoHIJLLMNOPQRSTaUUuV&WWX$X$X*X*X X)X.XXWWXW-WWVVPVU(UTTwSRBRQPON%NMLLOKJIFIHGFEDCB~AD@?=<;_:!9765~4:310'/-+^*('U%#!sRwr
_	\; *h$EYo4Ku?
ުݑ{nmpp׉IӁ\-ϗ|h{8
ʈHɚV	ɹvAǎ;ƪheĔ8ÕM¢8jy)ƾWϽ-Ѽɼy ̻c<	q<ڹ|^;1BRY]^Y]{˹
Bf%޽Ҿ,Xĥǡk̀<	1DwC|4R N	
#H)Nl!#%
(+*R,d.W0X2|468~:<=?AlC*EFPHI	KULMNOPQWRSSTFUUFVVV>WWW#XJX@XXWWWWWWV8VUUhUUTTS)SR+RQQPON:NMLKLKJIIJHlGFEDCBB\A@?>=<;:98075u4K3'20/A.,+*)('h&-%#"e!? *2F
a
0	 _d220a>8jv:lXhOf	o&8߻2ޜ݅ S5ڢqBװքt@ӧpYб)y4rˠJǈƾ4Ic޿"OeqĺmƷ޶6oò}x3}M
ŭujelgm? ~^@_ȷ!/ƾMY"ćoZgշJVu]l5[i	};:T #%u(*M-/1%469N;Y=?@BDFmH-JK2MNOPQRSUVV~WgXjYYZ[[\y\\w]]^^^^^^^^^^^N^]i] ]\\3\[[MZYYzXWW?VUUpTSR>R\QdPqOdN[MULaKpJhIDHGE~DXCDB(A?>=%=U<n;:99o876Y532107/- ,*Q)v('&|%;$E#w"! ^%`hK+'
  	jf/ ]	C	B"DPdkߍbܘ۩ڭٹ1׍Fmӡt2iή(KxʬJȔƈ8bË°ͼ|K0!ೢƭͬȫتV+Mq~]vF}hXpib=$D2ګҭ߯رѳ̵ۻ&\p}Įɽ˚vԑ[ٔHhZ;"{F myd:$D }#&^)+.;1369 <y>@B>EGJ,L:N<P3RTUWUYZm\]^_`acczdd\eejffKgzggghh7hbh[hhgHgff+fe'eYdncbaag`_^]\\U[ZYXWuVvUTpS@RQONmMLJI[HF~E
DyB@e?=;4:865Q31/-6,t*('k%#r" n.
Z
	MAiV  YUZhg;#,8:@ZsjF#$*$N/# XUzl4E8NxջԘj2Ͼt̯.ɼNdqrz	bqb\V>1᠘[Wɛ'Nw aۓpIJ֚7׫Q>B@ȹMDːΎh_dyݧ4jzGkzXN #9'*-13690=k@aCFH K~MOoR&UW#Z!\]A_`bMdefg@hiijkJllImmmn?ooppp5ppp/p,po!oUnmOmmlRlkjiihBhgfedc}ba`_^~]D\[YXWjVTR<QOMMLJHFDB@>=;86420/^-+)(&<$" g	_v

	,)^  K NFV			"!J5&'E@1a'NVPNTs߰ުݐg4ӿҋ]?̥_ɫW
ž~3⿅%ٻx)fֱfkʫ(nd C@Ȏ^r*	^΋oUsÏBf쥺I)@зB0uaUЁӥֳ,08omSi]!$k(+Q/258G<?BEdHKMP	SuUWNZ\^`bc;ef'h(ijjkl[mmn\o	pppmq
rr ssrrlrQr<r
rqQqppoonGnmlk4kjiigfedYc0b a_^]\I[YX{WV`TRPNM)K@IGGOEQC=A? =
;	96420.-"+I)y'%#!]*RiXT%
	uX3  ;<I5
YqG1dqs)e"~(,O $-5/4.T;_;KBZhQEl`:mK#f׌Y=ә{ˎɊVawԼ#mķ{ڲ%g! Wߡ|8ݜ˛y1Œ΍#as|#番3ɚ"ťZPIʹ"yȹ}HV5qG)
+"LY#&*E.1058H<?CDF^IfLRORT?WZ]_&bcte'ghjklmtn?oopVqrrstsst/uuYvvlv,v vuuu4utsXsrr#rqqAponxnmlkk+jigfedcbRa`^n]\tZX
W:U7S*QOLJHF5DAV?=;86}4>2/-+)9(&$'#!H )>@4le
S
	W	)=7 $#Z{5,nWMe(U
in.W;R/3!E!@ 	I>ztr~ݕsyi2ԧӀ1ϔ~LP_Odƾn~*Q$uh@哴ϑ͎&rɆ`;0e߆Xq3C#ӔUΙ՛Q%Pƭ0(-WvѐAیޚAYQi ~2!O%),/O37:>ADG"JMORTW[]_ abdfLhmiOjkklmZn-oop0qqgrUs>tttttvtet[t.ts<sr-rqPqqppo@nmHmlkjihgfedc
c7ba_^]\A[YW!VVTRPN{LJHDFCA?~==;86o4;2:05.(,$*M(a&7$"< #g-^'	$ ZZl-yi%7:V3i1U*|U4P0+V%nrTEZeb	_#pe	hgjBϭ̓1Lcß8dvŴ;ϭ&;t|:w✍EC\.ފ*gփvNNɅ&܈ێyܕؗ5ܟP٧ |1!w@ҙ00+wz<!$(k,/i3I71;>AEBHxK|N@QTVZ1]_acnegdijklmnopAq	rrsttuvfww%x&x*x:xKx#xwwwvjvuuSuuts=sr@r rvqtpYonmlkjihgfedc_ba_]'\dZ|XnVfTcRTPaNkLDJGECA?n=b;U9/7521(/^-+})j'%I$"E!nRGM)
0
z
		IkvO L' 'SEK[lO&4b[&WA5EU(88s	Z9Zu;
'-=TeriIثךo6үZ΢Pʘ-ȼBUtvݺ#TlJ2ƦTeܠ\睌Gxk=9.ߋN؈Ї͆!9*wH"0E,2ОݟŠu+׫[
:ݻ"ç"
G֞i>K
	
oQV"&l*-^158H<N?<BKEXHYKNP0S8VuYi\^`sbTd0fgijjkl;mmon^oOppdqqrsvtu4u
uttttJtshsr(rqqVqp+plonnnSmOl^kjihg{fedd+ca`_^/][YOXVTRPNLJHFFC|A;?<:r8?631P/>-E+t)'%o#! 69'"PV#
-
	&]W   8+c(A0tkP v	a'EN<*i i8/42:QhaDylF :3@L+V۟e؂P~Ϭ6̜RǬ5e_ǳO+Jy C_:Ԑb_Hj)cxȁ6ƂxEMtXuT웕ɢsުpn\Bӊ֩ٷK)y r7F"&r*.159,=@CFVJMPHSVX\^ca"cdf[hi;kTlOmJnKo7pqqrsqttu;vww\x|xaxDx3x)xxwIwv,vufu3u uts*srbrrEq9p2oZnmlnkOj,i,hGg=fecbba_M^\ZY*WURPNLfJGvE)C@><_:18531/-+)X'%">!
d7r
9
	D O'XD%-z#? gbdI[IK\0
IgOH$I~i[fjIB!_m
RT"|Zh-${ޘ ۡ؂Bѩ&ΦnNĠ9Zk2qԬSWƢ4z(ɖt5钛S匽p!}
˄Nǆ$ً#!F昗 𡒤a5FеC~èƻdֱܬߌ}U

P A $Y(+/2_6:}=@CFILOLR6U XZ.] _`bd/fghijklmnopYqqTrrstuFu3uuutttt\tsts srrr*r`qp7pobonmlkjihgfedc@ba_^^\ZY@WfU~SlQTOEM3KIF9DA?n=9;964d2@0.+)'%#S!X7u=
9
5 @	k;]\vr|oqs|,,L,^y6w0
%2T
:Vk>ebl*egBE"{|tRk"`+tҮe͸<zƗKٹ;O%Feg#eO
ۏCՋ`#:9PVSo6Aˈ}ݏ8ϒ՘WI⤗+벅t%?o֪x%|h^9R!
%(j,5037:>^ADGJkMORUXI[]Z_abdmfghijklmnwoApplq
rrs3tttttmtttitts-srrrGrq*qp2po+oznmlk kjhgfedcbaa`^][YW	V	TRP4NFL&JGELC@><y:I8631/-+)'%}#!`gq 

	}LG >?7.;\)l68+ccvup8E5MC,;(_`tga3f=eS5Bim5BݫsׇշSω̑AbU\ǫ	:Mr	>5:=NFsrO>r* %{GX8Γ#u2NBOfvTֱnmn^iΓѴ	W_>&QrL6i
 $(w+.325Y9<?BEHcKMP_S+VX[\^=`bcBexfghijkl_m2nnzoopFqq`rrrrerZrrrr0rqqprp]p pSonnmllkkjihfedcba`a_^\b[Y<XWVoTRPNLJHFYD,B?=;g967520{.W,P*N(;&$!$
+s
]	1wA xj/G@eD	\x)gClwh JGWBKL MGSAF|I & mF9;,RQv' z+6w{%[	ށV}(jyv͕_Ʊ uܿ3}QX̲1O4㪻Jףa
R4 ɖ'Ck֏َ5*R>hǄ.҃i!_"Z_tCטԚ1P"?ȸ2fƤ,փGA1 w5s"%)-1L58Z<?BEILNQSZVX[k^`bc`ef{hjk~l.mmnopqr$susstruu[v\v*vvv.vvuOutt tss
srqxqpponmlkji^h,gedcb^a_[^\[WYWU(T
ROMKIHFCA><:8|6&41t/d-+)'u%I#$!V2I:*T
d
	`Wdoj> 0KvH>OJN|_{59_rQ-JD6>Dw+\"v+h4p |0+^jlekHhaE.{CTH/KAx*ݖ-ھ4ג^s0gȧņk_ϳ6l6!a!Ҙ+SאOw5އMȅ[z8&" =܋ʍ
Η|'֧g۲M7Yr}~։ٟ5E pE0Q"!$(+g/26:n=@CFILOWRTW4Z\_`+bc>efVhijbkSlaminVo-ppq:rrs]tt>ucuPu3u(u9u,ut~t!tssVs srSrqCqp?ponmllkihgofYeHd.ca`_]\eZXV
US Q!O1M;K4IGDdB!@>;97U5#31/-+)&$"!
}$,
&

	`m| ` xQf 5<DTrUnj~ n
%s7VX7+I2SP8#vCC#j|&ݸrCssѐ/E̢aŔ,èA.ɵֳͭ)$~̥f&՛tTՑMڎӇ<Ɇy\kɇΉA	͒CIҜVyѠڢK[,OEm@d#nX/ mcn]	z!$(,/r37t:=@CFIvL
OQ;TWYg\L^_aGcd|fghiijbk@l,m)noo{pqqqrsssssssasIs(srrqqZqPq$qpp`onxnmml2k]jgiEh.g"f.e]dscQb`_:^\^[YW VT5RPPwNLJHFPD	B?=;d9'7420.,*(&$" o
b

	3\i 0|+;(<	^hVu97M
>/'Qib +l'kI/xU$p{o$>3Sg.ߗKڻ*נ.ԙϜ.̩6ǁŵnIǹߵ7îϬ֪x
)mr:(=Տ|g!n}'+̆OP*鍦To&[Pl]ȭo;\¹O-Va|ͥм*FW6JJ	CU!%(b,03:7:5>ADGJZMPRUWuZ\^`Ybce1gthyiqjek`lfmsnao5p
qqhrr}s:tt?uPu:u0u=uXucu-utWttsds"srrrvqpppeonmwl{kjbihfedzc'b`@_]-\ZXVTRP OLK	IFDBL@>;97}5B31/,*)'$" [&`GK
.
	nl Q{P!Am_KKUw)$	p)a4U6TuV5gWVJc0A<Nlqrg:7:Di@U6v"#?t[ٴ%֎s&̀Lǰ"Ğ'Vȹ0_{1r^kB[ߑǐr:*@gHr1Bw+0b_4Дl&򟹡TV׬'̷a'IMT~չ 9EA3Cf2 W#DU D$'+X/26_9<?CEHKUNPLSUUXZE]-_`;bcbefhiijklmnbopp4qqsrsssssssssassrFrqqeq%qp>ponnnMmTlVkaj[iBh#ged|cnb7a_D^\T[YXMVkTRPNLJHFD?B?=;9b7!520.,*(&$" )a}
w
'
	X-2cS WYCu^A3COi*GgCF"4-(Wc|ERSnv(.%H2fN'1ks&,ޕ<fd3Ӎ0΀{oz¨+<8A\@n¦
4àCQߙF	ϓsw5щ~
ˊŌՍܔҖv
ڛÝ˟顰Ŧ먈Pζ~_sWʜͫЏӎִX_VLETH)vc>-."%),I036B:=@CFIALNfQSVXZd]u_awbccef/h>iijskllGmnnoppqq/rr9sssses5s)ssrrq|qqppNpoIon#nmmGlLk>jSi]hFgfdcBba_^!][&ZXV/UbSuQvO{MKIGEC\A?<:p8P6742/-+)'%#!cU
;
9. o\	&9?@/ F1i@%*::QJ
rAP2% MwJCQ ?X="Y["8Eri8fsHZݫ G=wԝ@YʍȎ/wɷGaf%H0p͞MיwAꔉk>ҌNՊA+hՉ3!di%*lWc#Z쩫YDfӽudqrΈѥ`J_

i o"7&)W-0@4h7:=@CFtIK(NPSUXNZ$\]?_`bdief|g?hijjklRmmZnnop)qcqlqhqqqqqqqpYpooeoonbnmmmtlk'k<j?iZhigEf ecb[a<`
_]\ZYWRVTRPNLJHGEC@>Z<]:y8p6=41/b-h+)'%#!Eb\g<
1
c%I ${c)H&GBF2Q*N ,E
a\
8csK8c[5MC=XW.2P_OoL7ߋT:؟4ӑ sAǘĠ-NԴϰnͧLg̝|Wp-[Ό3ˋlg]u9#땏;Üd*礦ջf<ɵ̵ϕ҆կ/ F#d"	
90,"&)(-l0372:$=?BEHJL OQTVXpZ[]/_`$bkcodOe'fghi%jkkllmzn6ooooooooooVonpnDnKn:nm~ml]lkkFkjihgfePd&c b`_R^\f[ ZX	WTUSQON:L^JyHFDBg@8>&<$:'8631//-(+Y)e'S%8#!!0o!6/2P
u
	M& U/^,#6`f>pZCB[\
K,eFjJ|6Pn&EPTPXj$&$hY9y:LNXR8 zQ(	Uvx)qӰ*p̮Vǻ,ĽYgFݵ'	@٨T"àjGPxݑ/CnY.͔`旂P8Mܨg֭CŲ]c񻽿EptW@L^Pp?N[Y pi  $'++a.148:=@CFHJ-MOQCTgVXyYZ\@^_a
bbcdefog4hh}iHjkklmam{mqm`mhmqmNm	ml{l l lkkkk?kjyjji'iJh[gofgeJd/cb`_^]\Z%YWRVTRQO-MdKIGECA?=;:753T1/,*( '$"!?,Vyy

ec Au68t,if,]/mK@u?Xt
(r'pM	9a&MII/,?T|paG_,z*3CG%a|ڍ1بOӱA|́%Ǟ'ĢgȵAϪou	1٘n;׍Nٍ
ٕx]ޟáC+箍BϸлI63-+ҴԐףڵݝ\ aJ 3
c< #q'Z+.1558C;H><ADFHKJMOQkTVXY;[\^_5aBbccdefgh|i-jj[k)llommmmmmmmm~mzmXmmlll_l'lk-kjisihggGf4ecba`_|^][YUXVXUSQOMKI=HfF{DBn@R>L<`:z8s6H42/-+)'%#!'8BO|[	0e =2T<>@TM
4W u/xmz?g)E3@9Q12GR| E x          ) g(
D[n.'g_6jtޝ2ۼ+؁DӼuSǼDa`Z}Ÿ++-:EܤY@K~򌚌ҌwuƌK2'r㖠bUv㠊HѥaͰA𵬸ŻMXdD&ܐߡ{		U Q
. #U'*-0{47:=;@BEGJ}LNPR5UVoX+Z[D]|^_`ab-dGeffghiejEk#ll*mmmmmmmmmmkmmllll-lk8kjWjjih~gfedcbaq`<_]\$[YX}VTRPOAM|KIGEC%B;@9>5</:'8631/-+)'z%^#B!+,Rjmlf~u
<	&Q MNY> -_ULTCcl$:xx-	Fhk^0CE}	B`cR\+8EUqC&!Uq#/4K7k1,߫Sc*֊r4a̹9AƏHxݶEtɯD	SإӝBt?0?z\$
FƎȑl뗶V~ڣ@>6/nj@X̃y/ڙE#=bg,$~	
P-"%),
0L369d<?A
DdFHYKMuOQSUTWXZ\O]^_`abcdDe0f8ghhki4jj6kkkkk
lllkkkOkjjjjWjjimihhNhgfee'd0c1ba_^e]\Z	YWUT9RnPNLJIHGnECA/@@>8<E:Q8L6;4&2/-+)'%#!/f	D
r
qG_ @8.Q:Y1P0(O#?[u=oB :%@S-G)]ct/29]Q@=C9yGJ/ +&g6ݡڨFJ^ϡX̻4ɚ\ľ qӻL6ѯ{iVKØі
9r67iǓIɕЖAYB7#+fx߲[𷄺+w͟Їy٤ۂމhGTT#r
 N	
~W!$'b+.247:t=?QBDFI`KMJOPRTVWnYZ[]g^_`Xa&bbcdevff<gghioiiiiijjiii~i4ihhUh
hgagffeHedcba`_^]U\ZYhXWUSKRPNHMKIGFKDyB@>(=W;V9J7S5i3t1/-q+d)m'%#!=w5

D	"	. YTp}{p~"mV:cZNM7hl^	H;$zID	89W<dU96"m@g5YX'~J5I
ޯspC9z҉	tͱdYYB=VñPx#ӡuНnjx^ܓdВђSO1E`hvϡͥ/~r&eܸy0þϽޞU/)*:t<	B; )$'*G.q1[4=7B:1=?MBDFH.KMOQ[S'UVXGZ[]^_N`_a@bccdeeVfNghhyi<jjZkkkkkkk7kjjjqjji0ihhhhbgffee+d	ca``_ ^\([YX WUS1RnPNLK7IZGECB@;><:86420.,*(&$" 
6CW!xo=
	P 6W>
2N-sAV({'2?T<tI\j8{dFe:fT}
X>0hTXRv}d,
ޕ?k`Bi}i-ƪ*ÓrOݴ?y!F䦊-C%EQ4"PAMەb>L*wܨ0
ݵη.27HA,#	4gOD!X`F	x"%(+.'2358:=@BEQGVIyKMOQASTwV/XYl[\]^/`Ua?bbctdeefTgghiijj kNkOkFkBk5k	kjMjii ihhg6gf`fed-dcba`Q_5^7]'\ZSYWsV US!R~PNMuKIG)FQDB@><;A9]7d5a3[1i/-+)'%#!=d;,h
;	e$bAlnM^]S
Ibt&q ?qC.~?|  ]L,t+7R8 /9AQw%i4h,ۙ]^xs̅:ZƩ	Ô;ӾV»	b񶣵7.Ȭg1ΧzV@=Q\CVƜQi25/|kۜםmmެவ[7y^ȇ&ٖܽoo0Nld!	%X(+f.1)4U7:<#?AD2FcHJLNPqRS0UVXVZ[\^_`CaMbccqdCeeTf	ggbhhiiiiAjojOjjii/ih`hhggfexeddccBba`_^]\[FZXWVTpSQFPNL7KIGE(DLBz@><*;W97531/., *-(1&5$."; H^ctIp

M	*Y fKZIg/u4m-hygpzT.]G7|f;xOKodjpP]7*ݛ܅z\;s}#\rǴHhARʸla岞=ŬT
դ̞ 9j=Q/s>"+N
uקũ׫୷Obf.[Ɩ!̆):0~qFiPXUagl #&),/2582;=@@BEFGmIKMOJQR+TU|WYPZ{[\]^_`aObbc"ddefgPggg#hnhhhuhhgg`ggfffOedPd	dcFc}ba``r_^x]<\
[YXWjVTS>RPgOMLeJHGUECA?>@<l:86573?1Q/}-+)(3&.$"( ]*osF< x
T9
D] i>7K38=8$r9"<L1)Q^^[*)XUf`qp^YK*hS'd7h!8t:
;Ran9ۭq)֐]Ѳf ζ|QɹWNCݶJհȯx?ꪤwrHӟ,'H雨zx򛀜"͝}"߫ȭSWC!(w̌B!ٳܛߟX^*%v
& sT	D]w"%7(2+
.1346\9;>AYCEGILNPQdSUV8XuYZ\(]^_$`aab'cc7deeTfff>ggggggg}gEgfqfAffe
endcc>cb$bQa``y_^]\[ZhYXViU%TRQPcNLVKIHTFDBAO?=;98V6{420.,+7)S'X%[#x!@|MNe
>	<nWg obUVpe4v<f0" &g? j'"h1O
Y j*N3$'A|F-^ߢދ݆h? ըy>
΀"ʅ8ƊD¡n>dԷv=ϯˮۭ%cԨ1p٤\ߡk&MfA^CRǬįt;xo{g;+d2˚ИDzn
y4c(

yz{T#"$'*f-H0&35g8:r=?BBtDxFOHJKMVOP>RS6UVWY5ZP[h\`]>^__` aabbbccKddde-e7e*e eddIdcc}ccba~aa`g`_^^b]\[ZYX]W]VDUTRtQ7PN}MLJHnGED@B}@>:=;97!6i42&1/-,+)'%<$"R! 7 ea%):

W	ggnV/rS*aAZ
$>[?cQKj|sm7(8RK!,
aSB
iAg,MF?4l٣؀[8ҧъwl^;	ňO+;z|v} 5BSqǮ.ݬc<lr򤏤6գ ǥ#Qf3>'¸#HEhs9ƠWlһׁ%ްV
x{
\	#T# "%(^+
.0_35y8:H=?ACEGIKuMNPsQSTUVWXZ?[J\/]]^P_``Taaybbb5ctcccccfc"cbb=baya`W`_]__^3^]\H\[-[QZ3YXW=V>USR$QONuMLyJH#GE.DB?A?]><:897V64f31w/-2,*{)'%$M" F8px4j
HS9
Z _M8kcwHE7ndjtCK~`|n]awxWG<s\*bJ"x	^i*6{l'Uۆڰ
(B-
ΰ̑͘˄|uu}ƈŝCjüIҸ#ltĴ
mٲf hȯCF㭿l[Ucŭ?ǮtH 
4Mӷ;__ŽPt.9՗
z]t4 	I.O
5
y;?!$I')8,.0Y3582:D<L>B@$BCEnGJIJlLMNPgQRSTUgVEW4X!YZZ^[[\?]]h^^^'_L_^_b_I__^^O^]]5]\\8\[4[ZDZYYQXWV4VjUpTaSaR~QPOKNLxK1JIGFEqDTCB@a?><;A:865321+0.>-+*)(']&-%$"m!F G-.WdGjK1"0
TY;
9	VX7ZQ BD#G*f3)tEB#V`jEz[Qsr`syܚ8ܹ,ۚ	ڌ$٢Wפ4iӫ*͌%/YȫlƱ8|*zZ]˻C*Ez#Ʒu(ȶu?j)ٴ˴ߴϴմ	#:OD4<UjõM,޸` Y¯`>>ˡυҧA;جZbݕG
QIuW UVP:

4{-B "$m')+./136#8(:
<=D?ABDF.HjIJKL;NcOCPPQ_RSSTjUVVCWWX/YY0ZrZZZZZZZEZY\YXqXXW@WVTVUUfUTjTSS3SRRlQPZPONM{LSKUJnIWHFiEDC0BA?>=d<K;2:87a6953z21//	.,+n*%)(2'&$#!+ fd#%+r!
1=
q4D I!sE $v 2"7:z-b}
ktr+"|*޽@t܇ۃڃ o'ףoՠ3҃Nϖ΀fmʁ7ɋkEōm]>Pþqʽve/Ἑ~~waSQ`inw|'@9AuŽ6Wdľ66v'ĞwbK_t(ΦUӁTـښۮny.u{e (u>/	)
mH !#s%^'T)g+q-h/O1&34w6.89;<>I?{@A+CvDEFzGuHIJK@LLMNNO1PPQQQqRR!SDSNS[SuSvSfSKS;S'SSRRrRHR
RQ|Q=Q'QBQbQ^QQP
PO?OONHNM}LK'KJJIHGGFFREKD1CFBRA%@>=j<a;A:9764321<0.-s,.+)('C&$#/" 	@v]p
u
ut& J2.e>DnsZ_x?r
c$| v[vXݾvڀ&ڸ	JدEְ.ւ;ӆ"ӗlpЪ?JkͧQː&˷WʻiǋKƐsTŏiYN&ġqhmokjf\kČĲ(aū!LƾFǈKȧ
jWk]?TP]spYָ׌K٬iI:(޿ߕ~x{|6v6D)gG Hm
]|A94s x"#X%&#(t)*,m-./.12345678:?;@<7=;>M?X@3AABaCDDEFFF/GGHHHIYIIWJJNKKKKALLMNMMMMMmM9MMLL)LKKJJcJI9I{HHGGGtFEEeDCBB6A\@?>=<y;c:M9'8754~3_2P190 /-,+|*)t(P'&$#-" <}y$,

1	q@=Is_&vbYI5=ZP=tܼtLءCyճ pd&э	ФIΉ"βG̢E˖Hʻʋh<ɡlB0&)Lqɑɲ6Trʔʸ.[ˉ˷&g̵L͙Bί"όqmcұYIMձ!֣;ׇ*Vڅ-vޏߨI=2}/Q\$e h&a|W;y sz

#:V| "!2";#L$Y%b&g'](3))*+,-n.J/!001234u5@6	7789:G;;<"==*>>?n??@<@y@@$AAAAABDBkBxBmB=BBAAfA!A@s@@?N?>n>>==<;K;: :98887k654!4R3r210/.-,,+*)(&%$#z"<!|?z6?o

W	F KPdI!:_}3yܯ(u'؉,֖ՙ"Ԧ;(q$оАTϬ~N($.DtϣHЀл1sѽJҘaӳdԹm,֗ׄ؏tiTۺ}T1ތ\JERG=WcjJ[C[)Xj1P -,^{y5c  G=`0X		n

y2
7IAm\
P@af#2  
!}!!"##$$$Q%%+&&''':(((#)})))*+*>*f****+&+&+?+g++++++++++++o+=++**k**)w))(B(''H'&y&&%O%$$$##""v!  ~)o=<ju<p+g
0a
	(MtR #^A{$XO6ZS']EbaoIi-NߥJޢp9ݢ}_O;+'@Q]wݔݯHuޤ)cߣU!c?eqOM
fF)>>D!r,C&>o[J(y>&HlYrrt  XE6{Yh58		

$;!

Md,_"P*Z2 u`'\P.kAe!>DC:7=FI;03?H@+rN!g'\n"uM,a@_ 

q
]u
	E	(S;d@ + eSE:	%-CrB~WO p"g&PX&}_>vebfpyytty"9Su>g?u&WEdF2w2h'K}+pW
m"ucKPW!~Q$I,i h   =LB;8`H=	]		
n


!^V
d


UQGt4W,@Tn+EdswuhSB9(|fK!mC
mBUV/


D
Uu&

k
$
		6	~08/!w%3BK  o   O_|9d.LR`$`-U+\*nO-
zhT8#	)/1BTr &7DHQd	1\*9J^v?f5c!Bb:[A}=p6l I H    IK%Nv	@yDf
9r8`6Sx		"	@	h					
(
G
f
x






09HV_ouxpeVSW\XUIHF;-







y
o
h
_
O
3

				z	M	5	 		sO)mCw<g,Me?wQ0k=   W -  lBrL+jH$w\=lXE&sYD2"{eK91%"	
	(8CJPXbq,BUcw#-<Pey1=Lav&<Rm-Fl1Ts / K j       B[y;ZuA\v3J_s,G`wziRI4 lVD5#]<+z`CpJ#     u U : $  p`VSH>-"yvwuszzvo]PH?1 
	
!)2BIS^acjwttqywodX^e           
      RSRC         [remap]

importer="wav"
type="AudioStreamWAV"
uid="uid://ylr6ohrh8vp3"
path="res://.godot/imported/n.wav-64d9d09c3d19a8e1adc5a1e80680a645.sample"
              RSRC                    AudioStreamWAV                                                              resource_local_to_scene    resource_name    data    format 
   loop_mode    loop_begin 	   loop_end 	   mix_rate    stereo    tags    script           local://AudioStreamWAV_oaetm 8         AudioStreamWAV          fn                                                                                                                                                                                             + C a     +J[euraG%   e @  7@hD!bl/g3KupD)Biuz
u%mK]j1T?H5;_o6
X%zW      o A  b%o;t;|k 5	
<}L"!
A
, `ip#R T8(i9 
X4[4XIn!A*V/ݽMxA/ybO8 lT	K9
^S7[E Z!"k$%&P(){+,K--.[//0c009111#1m0/g/d.,+*)(Q'&.%Z$d#U"l!{ 1f'K6jZ5:kHxUwFeO#5*
x
U	!i
 yt/p5n0܅}ր]cgaSw>ΛB^Hʍ^-]ƊcMmԹuӸhvݶK9Xеǵ='[ܹr5Ǆui W	
O~"w',/g245678S99+:::907241m/N-O+)(
()(((q(.('7'q&%$=$" \#
	~^W>5oP*g[eb	xzA!$Y&'*)d*o+&,,O--J..//B0
0O/.z../0152"3K4Z55555\432W1/h-*'
%h">xc:

M= oQUMR.r(;j~md@{" v !#%'U))\))s+,,+z++,0+)(&f%$4$"P , uw
,
.N q|
R3_OjO߷݈QP>?~Z֔%ԄPѰ>м!Le͌&*Cfw~Ě%R/
־6𽹽ʼ{ b7& i|ٱsBsݭ*ӬYk_ұz.έְݐ6Q!&,256e78]:';o;<?@@?<W95Q31/,^+?,g.//d/.(.-q-K-|,/+)o'#$o c8|]b{WH6LlAf5ZCc

rT4` n$I';)Y+-/00001`34z565T54424:56p7<89E<>T@@:@?f@@@?><:85,3O0-+( &#k!,N:h
\	\Z
GuVDR5"!["">"    O   | v ] (^@d|
d_ i@	9.c`&Hj؝M֠9gϸΛ*ʶ.lƋ;132?MtٽԻٺ·6C3PbŰp
ݳUȷ˻OOǆp̗\?87/Q \
'S!+%a)P-0~3D681:;C<V<u<q<<r;:Z:L9x74R2/_-*N(&<$"! : P6e#X~eNz/z


q	n27a{  E v   Rb
cb_Q!#%K'o)k+<-.b0123"4d4r4d4H443@3210,0/S/.0.--.0.1..--0-,,a+l*C)'p& %#N" 
w.g 	rWYWW	0'
N> 
"d#$&p'b(()(('='g&%C#!8 }C


DpX
b	WUy;f T	Rk4-Nm;M~Ym܉l٤5*Ӑn9l
ñU@;л0E$|ƶoҵ^ò&W@:
y	wH@)piΫE̱K۴%MKE^7)'ո֟qSsD|	p!%&),.U13(56G8):;;M;::;;:t8Z64321/-,6*(('%*$" @tC@B"dX
o		cLt;		
^BmLD=!#%(m+-.0C12J456J7777>888)8>7t6H666d653:332)20/.-I-,+x*
)'a&;%-$ #x!G(=d 
	TF		
:
Q$ V" $%&T']''9((('&G%#""!  ~ b.Z}*6O-bF
A

&	=W-RL->IpܤWe*0т˹<ɀ/ŽDĈÕ¦.>%ӹ%4$n᧜gDy2e9ȩb!ӵ6Bɻbw}}	ʚν+ ڶA.Rv/	
#'+.147{9N;<>2@"AdAlAA@?y><Z:`875Y420'/o-+f*({' &X$"! ]'J7YJf
o
	mucn[)	
{Wy~!,$&O),.j135789j;<>>d???????R>==<<<2;$:I988V7g6T5(4320/l.,*C)'2&$# I)m1
m=o
	



m
&&P)Vl9 Q b  3!p!+! w j d G ]E\xD\
2M
K4y i5Gf
<n`7~,۱'bԾA^EɠAǃR
Ċ c¼/uJsHqDNZwWr
좢qw	+ԢM#MT f\Ϲcf9[6ʼ^C(eX35v$)-X2_69,<>0A7CDEFkGGGIGFDHCzA>N<:M97R520.T-+)'%##D" .YF7:j
	4x`iz4c
(<"?%'*.\1i47'9
;<b>?`ABiCCCC
DCjCBAAl@??><;W:09<8B764L3
20/.[,*(&%g#!E<1<6
;
:
;m.O{n{U8	 ! 8    !!5!!   _H],_?oR
e	MC~ޅiNL֘Tԙ+`Ki͐ˑ7IXr,\Ɨ,ŀ!oX弇۶񴚳Pntשeݠ鞽_/TJjܦ7PA㸍"bëǉ<&ן1 Idm#(h-2O7;?BFI6LkMmNO`PyP.P@OMLJHEAd>U;85C30.;,):(&$#! H H(^*j
j	0w( eV [#
lZs?"%K),/269<>@BmDEtF?GGG>GF%FOEDBSA?>=<;:987v6i5[4-310u/Y.'-+_*(('Y%#!& #-U
N9
C
 !#`$<%%t&&	'H''H'%$#"! ?mh+KqD`}~";
C
. X% AtU6:IgMO)&۷ٓTu҈Y+ϛ̊ImkǓTl|Ʒ#mN\ ȉ1yĘPMk,j-$ӯ&ǥy_I&;Ȕ̔	Ҕ"*"ԙњ<]죻'VU=s57ŴɿI)
Q%7+X18>@DHLORLUWWXYzZqZbYV[S~OK>HDHA=927u531h/(-*H(&E&C&%q# !dY{2	 \3(Hw]H\ j	3
.g)!@&+/G458 <?C+FHJ4LMMNWO)OMKJII6HGF=ED.DC-C2B@x? >
=<";9:*976&5
4F3J20/,-+*(b%J"#KUC MGt/	
}AU!4#~$%'((((5('&%$###b$z$#7##V$$*%&%$$
%%$%$N$b#A"I!!s!! ^
T?	Mb`vn/Dޢ6xOEE^RM`0qЇːʳȺhƌŅ0ŉ`Ŝ>ơ:%	ĥd6]뽻r,Ů˫o+ݡMc8vRKgŎg	􍕎~ّ~*Қ:YxI;E-td
u$,W5`=DI	O/T]X[]_a'dxeda].YUSOwK?FA?>&=[:631/..--,V)%#! TE-auX&qHc7C|O
d-!%*q05:!?BE
HIKNOPNbMfL)LLLKEJII:J|JIH`FEYDCIClBA@?>4>==<:977 63Y0X,(%a"qYQgt0mfAE ` $&(*,.00=11 384O43.322(2A1/.-T-s-2-,***H+d+*>*)8)f(c'$&c$"E65D\
2	g?a SNG?2yH߁߅k#ur;^HԚ~jѡϪ#͖]P]Ⱦo)}ųſƧ9ɥʮMɍID9duѼ$ݲ/	"CO+ET֎ՎՎdalb!a͒s9Εp][Ӗ×uQw#nYKqY F)109"@FLRVY[_Sce_fea]DZWVSCN@IFE~D&B,?g;R7m4^3332 0,U)'''&q#[j! !c	 Z{47ygMk\ _
	; $*+16y;>A=DJGKpNONM$MM(NN|NMLQLLMNMJHGGFFFEDBAzA9A@;@><;:f:862/ ,) &B"yI	">_i2*UFGzo.V
lj"r%&(,035
6$7+9V;:=>?_@@X@@tAA@><;;:<:85X2/-k,)%x!+yc\
fvN.\$oK`Y8$R\eYNغֵ՞Ԫӡ8Ҟ+5Өѭ?1zz=hϊ#p ˽ʩǤũb_з5Rv顪ҝ3גƌE,m%gj쉲E-9*͎=􏬐PjkҘSǰ9/˖թk[
+V'.D6<
BG<L PRS*VkXZzZYUQL#IGD@;8H8878m63E1/.C///.%,@)'&6&$"! "$s%e$}!-r)L/_V%ETf5#(0,/48><>@(B
CCDFFE*C@A@g@L@@h?>=9>>?b?=;w:999!9 8B76w6<6H6*6-5m31
0.:-e*&"At 8ys awzg n'jgYT/~ !"#$|%&!&C&&'),)(U&Z%%&%
%$ #T"""!!uWvE
\	I9w;,%\ _	#vgf2Br#ߛާpٓإ0;ց	ӕ҃]+Nќё0*ehÉͼ$ }VFoȤTĢ\aޞo#)'H!Cj	ƾ^u:!)18@"FJOTAWXZ[]{^]ZUOeKHGpC\=7-54430-*)V*c++B+)'n%$@%&%#"$&)
)&"T
	LLbg*^	B	
&?U#&+.0n59<=>9?@'ABCCB?>)?A@A@Q?l=z<L=>>A=:W988	9876<6D667@888C75G435301p-.)%" '
G*0&N7BeB)L
E)L!$<),-,7-.//...E..i/.--./b/.r....,/+)' %Q!A.[fg
L)U5,=b)gIDq>qOxja܂X=وױx~R؞טdq&Hڽٲ$k#<ӭҔ-H΄gn:ŗS?TFF߲ư߭Ԭ̫Ъݨ Σw$ݡS🭟,ΠآD=ߨzPjƭQw4r#vrQ	
q	 #%'B*
,,-.0f10/-+3)'''&$%#4##J#" BNs !"!A <*,#  PQnP[j

nhct>BK_, V"%(+-F/0P24W78::;M;;<<;:88C9N98H876656r5Y423n2C2B21E1X0I/X.-z-L-,,*})((''%#"!r>h[W~I]b3 "#v$$L$I$e$3$####y"!V! /](o'
<
.ed WuZjv6>":k5/,-~#HJLٱh8y
GϰUt͔̩ʇMzǰz%/qm?,ζҵ޴GԯW٬@%vl2	^Bӭͯô öʸzUbټn(_Wϵԏ޳
5e)IW!$'"*-++{-"/<0w0/.+@)''%#l!1 D    
    gO  ! B!O"6$C&''&$~#"!S*{}ZEU%gS:tO%s"9%''1)+N.0234355G66-7l643364>443!3|22 221f0/>.---*-,++++K,T,%,+.+***(&5%#b" !|<g%
gb

		4
	v	a

D<sOk1xv=
h75VA6k(n4a
>	] \}EL0a|H5ݵܚ6֭ebnЩΑ̵+̋ ˊXʅʘ#SǱƐąFY{fǳӲͱ#Kq,ծȮzjb&ҰҰU߳Rȸȹ򻡼CHGYn#mĹc٧^ xmBI&!W$&'(?**++*)z(&%$z#!   k  } W!!
"!!"#(#m#C$/%&&S'='&%$#v"[ P<UHa0V$!#%Y')+./1g2345*5551543H3,32-21310N0//!/c.-,`,++**2*)*I*R*S*g***v*%*)))'&%%#U" ],wY&
?HUt
|-sj&*[!)#$%y&'q('))&*)(('&%g$" TF`
C
V
q

oS?x9)

=
H
	%J'{ &fWVR:޶xݸܟl@Sٌس)/e͹bɕQKƶ]OìM:U0ƾC0bm[`p[ڳϲа;鮾nƯBٱ|	Ѻ@UBbNƳʃ?}wK| E1{] #$&(*+,5-,+*m*)h(&&%%$<$f#"!t!! }   F =rOm !"!#"!^!!]k/DmwFfpA)!#&')<+,".//011A1D1i1w111&22111|100c/.-4-,,U+***)o)_)/)(5('''&1&f%Y$A#b"}!6 W.yeT<|

	3	t	
BrDS?G$hH!b(VyLX4TDJI_:Pvv [T#
!48 es E;-`54^5.	
? =4DQޖ"Ո=ѻ#USSq{?ʧ9QƼ\ũĪG/S[ݽ;.UL2IoqYܱ\Cjkѳµs=꺕ĽD.mL7ŞƧLɨt\ѕkC:)$

2= "Y$&J()****C*))F(&'%%%%$6$+#T"!!!2!w h?5@a2rK
A0)TX!#-%&s(),+,-./:001%112:2+26292	211191p0/.s.-
-L,+*p*(*)i)((D('*'&h&%$#.#M"d!j 8[+-4]
y",drE[KbE1YbGo9w

b
	?N nN2~QU=ChcxxucOr 7PU~AўΦ̺͘ozVfƺƂgI& :wh!޷QSߵ~=δCѳ+ô{۴w(K}ⷰ_C9_ƌO@m<U>Yh uww #&p(*6,!-	....#.-+)'&%%#"!B!  [ U ! Y( Y ] m\Pkn
%
	dX<	L
%.
_ (F \"y$&(*
,U-v.6///]0W00////////Q/..a.-t--,,+++j+L+++****h*)2)('.'>&%#!+ ^IbV	9 >   ; s  M/	
ys!7=a 5g\'qlV'$wQ5*euC
2	0";>	ND&6?hgyL:`tb[SXy

^֊ՎԖӳ`БϬ0ͯ8̱˥Lh6?Ȥ_q~ĊÇPѾκGeqC[ԯȯ,BKuYtKD(!Guj DN
A"%(,.1246,7588y8C75q4#31/-U,*)('r&$#[" <~e?pFGTRh9Y
9!
*	o9W0z^@*I	6!#%.(?*,-g/02334S556"7g7{7]7&766D5_4i3X2?1M0[/b.{-,+*))R(~'&%%:$R#S"4!1M
m8H
+{
Yx "; [6,
1C#iu !!#h$q%%%6&V&%$l$##/"!9+6UPCwzi1M@
I
r		%+X V?v?G0YX6,Gw7-p:_V/	FسdiԼВwΥdt|ʠ|eƥe-ŀ[ĭ_ƺķ0LM谚4WYZqۯgİtĲaȵ@9w_2Xԍyb!
|!4&.*o-d0245N7`8:999'97665431P0
/.[-,+*)w'?&P%$#d#"!X m6r(1uEb<KZL
_J;i!mvui! @s	Y,yQ#R"$&Z(*+-./012345566;6J66i543*321Z10/2/.-M-,,"+*)(?';&$Q#! 
EE)(h@B
>S  4S O
&&h)ihQuX@p&c5"%RX(uQLf~} X$x2
o tGeNesD!IY+gJO^_߮ݓ>KbjzvUNcѯBχλογjYʹ>˂ʴŠ5GtSunU[۳W/Ec~Ӵ.ܺ
;ɾmƍ-FךNsi/8><3:#$'e*-G02467899%9766>5
4211S0/w.-G+)D(&9%$d#"U!hd
	'K .kUr]  wU	CEb	 a"$&(*?,-./1c23n4@556k66965433G2z100U/.-&-W,+*)(v'&%$[#" p
[Tp
9
]q ' I}jS6p
N
r[*
IC4i_$.=HLD[t*
*
)3F ]S$_nQV]]ejMkE?M=?JܷU b٘ضLֺ8ӆ7}vΈ>ͪẆ!gMFTȩǸŐ
:l*t޻Gt	
ʸvS}θ۸_ֻ_u;P"yލ$7c
#7'*,4/A1245566543210/$.-H,P+6* )'.&%G${#y"!*! X!O\w-"D|n
+
	IU+-d      l0=i
r" "%&h()+,-./012g3333333H210J0/.%.z-,(,+*<*)(=(d'&%>%c$M#" b+j

	9.h|CY<		
^
VzbBwhI|~e
"krl

k
T i+Pw7<Xj^xc\9ތݬ0۳]ؾQӡd ΢5̹̻̔dE$Y*#ʇɾɨ3ɼW]ǧZřdñ1d)!Oƾ
l5h5:ƕɑ*ΞЧ֤<h-^	
Phl"$&()L+,P----l-,+
+0*()*(Q'|&%$#5#q"! P G2d?9SvMW/v7 /

 
o		C	k			h
+
mM_wh[a^6!"$P&')a*v+@,,-r..k//U00c0 0/`/..z-,	,>+* *b)(D(''w&%b%$_$#;#"!!? JFUiQAX"

n
					w		$


|
Y



hGEn#?,=A,Y

H
		|G@v4 !vT/  Aqn)&C@:ۣ'ڷEٴ"زp>no lԸ(tZѷ2нBd͘i[ar}$ŸŻőŌų5WSbƘƺƾ0qǅǱ4Ƚ%ɔA˴̿"яV
2jݡ5e8~'
=r<Dq3  1![!!!_! t W P^K/Ftq.99 ' 4,Wpl|S 1VdeHGH(W.Cs!""#$Q%%u&&:'U''''(N(((((((Q( (''@''&&u&3&&%%9%$$$%%%%%%%I%$#+#"!5!x  &m(]
x&-aJ,P



Nj=mz



 
x	H'tgy vpW"SZ7dLb>:K(..5BDfWCRӡ+Ӫ_яXjβdz_ʞ(ȶD[ƮP
ĶĎķ8ńYƝ<!4dȿo;ʅe˱WX͝cλϷsЮѭҗfbզ8۪bzK
#Hve3Ocd	W6
c1F. X  !^!E!B!!""4"Y"i"r""""""""##"""""l"n"_"4""""!8!  8 -Pvi~X qVne  g!!b""#o##$\$$
%f%%#&}&&C''''''''''X()*p*!**;++++Z***N**l*)")))(;'%0%h$"!m 5Sv/,d,
(
Y(G
)<;
"	YD*q] [ _;	ao&cQr_Nۢڄوظ$ՎԒӂ)]ϪΦ7͞˕/ʢ pRšĝ.÷$! Kq Ħ2ņHȯS ʗ
̫i-SϸGђӏ8ՠ,ۻBu&j{jycE. {	w
I:@:(nY	>   >!!A""R####!$$$$$$%9%G%M%>%%
%	%$$[$J$C$$###""_"!!Q!&!!!  q [ W 9  + / @ s  !)!>!`!!!	""!"F"y"""@##y$K%&&'()*t**s++b,,,'--@.k.c.q....-6-,+++*('&`%$"!! ~T(&7($n[
6
		&W : AqLB}w]n
%xEI`Ysz<{S^$߅=xܩ'<UwRԇl!FxņEɲ@ǒƻŖr)ıēn\mĉĚĳ%Ń7Iǚ ɚAʗ4̺Mʹc϶ШѥV>ذفlz|X!&4Hon^smy&`hyp!l	

y0W6  N!!`""j## $$%W%l%%%%&F&Q&b&{&&&&&&&'-'&'''/'@'7'''&&&&&Z&D&E&5&&%%%%%%%%%%p%7%%$$$$~$i$m$$$s$Y$K$X$M$/$($6$S$$%g'5(A(()*++S+n+",---6-o-I...-,,6,Q+*&*)-)('f&s%%$$"x!  J KEuM	EkjdJ2

	4Al Qw}ji+N530?MCX##Wpz(qor^Z۾4Jٛ(ך֙%aҥϼ*n̔
TɾZǘƳDĐďĨĳĮĜĴFńŶk'ǋ ȅzEʤ˚̕wε'ϊдHr-ӻԂsw|؁xWCOr߇,QkhkN Q+
{`e'j ?7	D
|
`Qm	M !H""^#$$}%%&&u&&K''''''(('(Z(((((()<)^)o)))D****+m+++++~++++]+++++**J**)))`))(((S(''''((|))2**+, -g-{--^..Y/I//;//=050/P/+/.f..s-,+*)(e'q&%$M#I"r! U*.<;rF[

	Oc/4 }>Amg0G^i>
1X pPyK+eQ$} ݖ@yۥk/ٺq)؃!a
פ Ք:Իw
ұGDв2q|"̩{cw̗̲VͷY{VЉ7њҼR Ԅգև
ר8ظ3Pڌ&ܨOBXB}VVl 6MK132 _JRI	

kh|~ldv5Xlzz ~!"#w$`%P&D' (()b*++X,,c--;..
/-/e//
0C0{00141[111111
2211$2)221111111W1.110080//V/..:.-r-
-,,+1+*L*)U)(i('_'&F&%;%$)$#0#"$"!!j 6H\ dC?*[
;
	8	w\X / j*=[iv&>^&xfUojow2߶t,ޕSi~-ۈ8ڠTھgؠh/׺x@֕֍֥֤֙֡N~צ!fةJلDڍHۢ >Wܒ2lݡ<ޞ0~`3K(2;b+vz8Kt#  K$d@-~	i
Km


!T
z0uO_o&7 8!!!!u"#`####.$$$$$%O%%%Z%C%o%%%V%%%%%$e$$###I#"{"_"M""y!   P kx1:iBWi dHE3AG4O
+
U

	D ]q
{% e +#mw*7nsw_s$\@2>`_.o4{8nD)
:TTe-b&Rt,Hk"]-rDkXQaj#.>P*A-/	ydJ<.HERh`  gixvvxf		


nV0

\G
iwomQ2q!?t
)(##witxdA14$^-^5ks!v2ZY5m
q
1
Cc

~
M

	b		bo9M]` OTB  2 3b.T`}0Aj"v.k!JIs;pCT o?qFsd\\[SHQl"4Qx;NeupbL1)6UP2s =|X
Z
MN$b4dJxQ^,>j s  :y`Kx:/+z?d	?	S	r			

6
N
t


@Pl:w

J




 )OUawrF




W
7
(

~xkQS^P!S


n
)
		T		P[nQI;"^B* T& 8n0U m $ pI\0 og^O5V4
V"l)['aH$phcUD7  wlgc`agpy
 %0COSXf|8Mbv8^w%/Cb/S
!6Tm!:YEvO ? j    Ey6HYr+Ii3U~6f'JVaqqZJRZL9&(1<5/$&7GT\]eog`OE3xV;"}rbWF9*%!!/767CRcgbULOOI=,|R)rO*gE)
       { p h P A 2 , 0 )    |r^L8!}rjaUSM@8)&
	q]M>#zh]VRDA=>@:=AEJT_afnyre^UQLHEB@B@@P`r(=R[gv0Ibn#       i G JqDCk Tz2-%so{C k#-,-8]9 cbwgf%    j   @ ^ j H * %   
  *  a@,hN
{$}ztfn(;EWr|liu}bTUXdf\Wcqxzlhmw%Ft'BRf~2HWar|qjb]TMWVJ0	ylf]UONEIPQMUXZXSR_hnkgbaglg[Zgx{rw2M`u{   ( B Z u       ;MYf|5Z2@[m~{| .:HZjlqsw~rj_RB;6.3-wuxrxvcWPPMF3%"|ohhhc^WVSVRWTE@=6+#	t[H5$
                      	  	                 | l h c \ W D - ) & . + "   
  t_Q?4+ }y}xzyod_ZWZYTIIEA@DLMOTXcjlrw~z{
3H[`__agtlihikfaWPF7(

$.341-(%'/8@95%"#*07?;2/(
 |{~~-79<66CKOVWTU]jjeWUYbeaZRNH?61**#
"',2;EL\befifjkpljgjnnkmrmmmnd``\V[afaefjgff`ZTMIKHMPNTMGKPMEB:+
"!%5:MYaj~  " 6 B P S c o                                                 #-8JW^gmbgirlbgrqwpd]bfhjlnw+8HNIIEA4%rlfekie_`ZTN\ekfcm}{rjg[L:1!               !1;C@GGOOTOCA;63)$          p _ \ W J F A 3 -            	                             
       
 
  $ 5 A ? E F S a n v x { | { t f ^ N B < 3 + (    
 	                
      RSRC     [remap]

importer="wav"
type="AudioStreamWAV"
uid="uid://dsmvgpphp7y4l"
path="res://.godot/imported/o.wav-f6f65af29eea681ba0eafbd5ae534791.sample"
             RSRC                    AudioStreamWAV                                                              resource_local_to_scene    resource_name    data    format 
   loop_mode    loop_begin 	   loop_end 	   mix_rate    stereo    tags    script           local://AudioStreamWAV_vm8ud 8         AudioStreamWAV          Ȅ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      	     M q f |    #iK0=F`Ok# /V1>Y		dMRuTz>ynm9u  EX8N`"[PI#rff /EX\C)#io%qLJ};Wx'ENN qr2(U
wo^GrapSy[j,"++md|;2Z115QUB
8B5u.`dVc/[*ye= H   [ = u      9i~qOJ8 ?
0l:vrmRqq9}\kKRxjVLrcvtz				,
u

p
1
4
v

{
`
J
$



F
m
c
D
q

2 

							i
*l6

%6Z<nq6


8I


 
f
		>
]

	:

-Y<



r

			d
p
			{	E		8			
d




TaA7bnR	
i
o



h y6Iq<:@p_



}




1o{
C
N

`
m
u
(
1I

w
r
n
3
		 	>m1YXZY0[a		2


:{e

~



1

"
		[RmM5*nS	{	}ep.=t |    7   d  C   l./EL*;    	rx2~!6~K$u*2)XHi
NAW=H@3*'8|RfJ/%s0a	]!}/s#'g}BB{hOmK!v[>6.5@ 'js3^|&c|	=%qj;n7K[?~B?3
>$E.zx|.c*#uI;mmLRC]yE?
:JAMuy-ca9J<u>8XQgZS5=l)RSp6`oape s+:d^P
z@6Ud=1GAt2<w9\7geW7*A8ZX/N:CPbbp:9!.h]s	zi`A53@*drc?h=-PndsR4 Y v  
 \ 
 -  R{)na!(+Hj:Tl"{l|N: IOZV;KSaHVtGi
\m}r2?
kNCS5n>2P;C0+M1N:"+=b'qIR]uN&xYS~h``XK]j#^uw~;:!g#JxO 	M		
9csk
	e	2	T		M
z
H
				|	j	Z		




!
t	|X	
I%
J
*
	d<	
wjJ
	`	j		
o
	(		"

Z	V				






X+

H
f

>Y
						3	g				.		*			I	5	R	-	)	Y	~	k	(	"<]Or1[zl
73M3h?%NvL'_JZ%aC"!D1/=AU)jeqb pDH!t~@oon?J
pyBc @CuJ\0?jf^2r0Pk}&`>X*P~Fg&q47MAPZ8MW7*uG_gfyGc(xdrX9oFl*w hh)_o~/9*B-OJH.8 pS?AWG_O718p>yR!7o,;JnApZFYN~*`_:a
{'a:     b ;@ a   O $ /  8QElFsiy65q~@
 W,hp \3Qk\}%]`$AlrLH%*(ej6* ~tHF4
?rtxnz\	Ie:e>)K-VMqv%&'9t:4\X* Z wO^L     <  *j.1# ;   w(]pKUe>T! d %  $   /  s    + S   04
WX*6tc+"u

byO3At)pdA8bF=+aHz3>Z	 		9P:K>:"i4.M1X` 	x{  UT , 5   \ p_  N	       C 7!r9 enh|[+:QvR5{0k]Xl:<tnKlCUg3cvCKl_3(+7*2yP%>va|iQ:(1t]/L.#,7c?wU>]pD>Q_+07k^N 3;vA    Os
^lWWQ|=/4ze)?	

GL5p


				C		@	H		pmA}d	9
-
	~	:


g
K
!
	/


c
r
k>V\DY

%
\
M


u
Y
R
l

				
L
	l	x	:		
s~@e`

M
~X
2
@
y


n
M
	4	x		]	Iyj'A9kh1Iln	V	Z	f					3	i	F	@|ON02{hCZf`d5b ZT?iyi`H`
?wiiF}$ *601LAXf#KgXq,p
{U)[d
\3)Gf`7~"POB^6h&B{:f><Tc7IlG{F|&
}AA>[ui   
L 1 [X
 , ; @ J ^ c + 1  8 YjU7+LP4&[,%Fv1#%2{\			0
.
	x		A
m
Q
3
f




p
		B	S		e				gkTC>-kf}O?O!11h
~}E~ Q  Ze  RF&{rc	Eaq>:\/0x{<@ylV8@
}E$CPF.ߩ)ߧ+s* a
+5cr8z*Z6^.W
# }r8+@4s[mY M9Je	=		
&r
(W|_ruqk7 >!B"w#%w&m'6(.)J***F**,,3--.H/X///0/`//0)0800110L0000//+0D0$0@0[0/t/;//S.M-,,G,m+*&+M+*k)I('&0&a%~$#""s""=!S aZM)T.<EXy"\
Ni`
0	
K gBVD On!ڡـh`֠եӼсЏΜZˣƿťĜé¯㾬5)ݹ0w
'Gf3teִL
޴Pɴ: 7	;,)*Žw~vw⽰ξq;C8Ƚ&8!LyE;Vm"&-*n,-A0W3433599:q989X::94::::A<>R@@ACEZEEEFFDCBA/@? ?h=:876=40.a-x,o+(+,-?-,m,2,+Z+++G,!-M/g24R54P5^6>7p7(7)77b9:;<<<8===p==?@A`BaCEGqHH7IHII,JLKLNQTVW3Y&[\\[rZ\YWVUTSQ^ONLISGEeB?<:t8532p21/-._,*(S'P&q%6$#y"! C& :c/
Vf	 85 !p;AI`#g;{:Yۑٿ!ִ[҆)ȭƼ-6Ƽ}]ٰ8T`[nbڤQZ|LLgL6V"}ёܐzXǑʑaȐwosMyx΃lbe>"tR
'q!#%&m(9(
'')*S**++*)*+,-0256 9;=<<<=<;p9766Z42@1.+(A&]#2>h-Z"8:hH!$&(!***6++,?--z./j0000*11$35x79;>@CDFCHIoJKMPQRSTUjVZVU
UySEQNVLIgFC?<T:7X65!31u/.,*")'&u%$#^#,"y G}%'<X


$9\d
B<>. #&'(w*@,-c/0121&10/.D,,*'%5$" -a=(
3
}b	l2_ 331U=#{DHIF9ݨgۤډٶU؄QCAB34>^zk8ʍjzM-`ȸشST,飻٠ R0К}-Bܘ񘍙

Ȗ
g˓ƒ1;=w
"qRڥ Y"(-j15L:=?:@@@h@l@M@I?=_==a=<;u;;;);;<>???%?==o='<K9520b.F+@'A#?4 

S	Y, )iFvT}	u
G!"$>&(*,-/=245p79;>@BoDAFHLSOQSUWYZ\\\\w\\\[yZXVSP_NKG0C?C;730+'+$k!cC}\Q	g
>3yDzu?drs	K.g 0$'*-036t8q:;;<;]; :8N753|1/,)&# f7[k
m
	eR KJfFH) 9Y~kO7ޡފK]ܬܰ[
{۪BT ٭q^K*
QΎUȐV񿍾#ͻPܷ,32ݬ ̩s.g@V.`FKcjɇnʇz.FחǡçƉ
ݲ #$e($]+W16H<HACCCPClB@a?%>y==<<<:87i6 5.4*445?7a887 7530-*
(A%!W
S '2 $>{	?QIv!g%),W0<358;?ADFH#JKMNUPRATxV|X@Z[],__F_^<^]]]!\ZWYWUROMLHD@o;6y2-`)$* `"		~STJ+ _9\' [W{,	` &+.-,\-/2 458;5<<;::
:74w34552/./t.L,
)%G$#c#" !)@ 
w	FoT^!]U$Vj%Qy۴$] Aۦ#ڄezQԭ{hΤʬȈ򶧳$ͬEܡ?ގ}ċTSe*WU>t=edҚժveΈRBma
8 ##',16:?CDD4DCBA?=i;@::v;	:63C210v.--!..)000
/,.*&"<
[	<i=r2{6%/+/148;>ABDFHJLLLLMoMNXOQRYSSUVW X8WUVTSpS<SuRQ_OMKIFC>: 501,'S#
w /o56m6 }#	
GZK
Ft4#F+1468;>\=:N98|8y8-9::K8o5Q2L/,+)Z&H"a  k L)^h
fnl?RUv: B7x+ +d.TZodk'! %m7ߊ+LޯX"׃	΋[œ/CaŶY꭫$S3keϣD7P'ˢGiMg1ťYJȨ Q׬
ǱKʶּvZx9\ Y >#N'6*,.I0
2R34f5t544332210y/D.---+)((a'&s&%$#"["!<Ek>	ab O !9	|c|!b%(+t.02K57`9:;<S>?@3AAAwAAAAA^AaAcA^AAAbBlB4BBBANAC@><D;9!8630.6,)&$=!?BD

^(Xl	x4wX9a7? 6! }}Gw,D`  !""x!  !; bDX*
	:}--5p+ng%)!3m(`ߥ0	݈*=޴~ߏvOkڄX׉lի8Ѥ+lȯjſF칌
jٮ;[{էK	v~ɡ$Os5ƨͰWy,/Ŗ}͟H=iKGQ #3&u(*-A/12<4444)5420r/.-[,*)W(&u%L$
#R!~4Z1$"

	[@!]A7}	2I[!#&*A-/24719:;<Y==>r>>?I?w?3?>^>>>Z>=<<<>=D=<<";I:9867^531-0.-p+)k'0%"v VvBs
K
V	;BI		
9-b!#+&0'&%$#R##$%=&&=%$#"! NU 1 wIp	DQu-{o@1QVv8V-BiDf7ED޹%!ޜޚݴz3.oը@΄.r-:𰾯|Oݩe6<إ"N<: 6H]ǤNEŭ같L|sƩN7 L
ۜ_3jJkEd!#+%&(m*f++b,,,,,+*.)A(N'%#*">!{ ^LxMd
y{$unDg>,kuyz7!#%&(+*V,.q1m3579:;<=D>>>>h>=t=F==<;;Y;;n:|987W7646l543O321}0D/-j,*j) (&M%#! W\.\B]
J>f3!#%&&B&%%d$b$%D&6'''%$#"~ Q{|q t6dIS?r
Fa
!	R
Z8~11i1whDfFy,w7\ߦߖ1z$
ܾL*`5dXSo[0:mðw^CYX`e]sլ)s\9GdިJ8~m,ċƚȹD'Cٸ9J 5ON%|,x "$K&'G((((((')()o(''&%#p"!&Vx*<f5$=q|{X=<j, "$')u+V-/1345@789::";;<^<d< <y;:|:98)8m765	5K432;210/%/.p.-,9,+*)g('%$n#" n+jsxZS^w{n!J#x$$$#+##o#N$^%;&&5&%#_"! $$!8o8y)CK  "qTs5R

yNQ%Sw
:?"Bbo1(We,#(ݒ[/	݈x
؅נJϖBt;b»YTxʳ6y{@UIpYҨZ%`⨴"p9ǭ۱_Za"}Ĩ~by@}֖aݓ
}{
QX$_ml-a !"""5",!5K.'PaE0)wyq
atm!I!i+ Z"#%&L(*+-h/0124=5#6667B7f7777`7D776-65433J21c10E0/.d.-N-,+*8*)W)(:(:' &$#"! P\G+RTk@OlFm`{!'$e&O''&&&&&u')*\+**#**%*	(5%#$#"`![ RE[^*I:;
	4j
b&w`,	XC7StXk-=f9x5Iߛ}qہc$ՐKiұϼ5X^Ȏ>DKp-߳ʱȰӯQWZ#ܭTF 
K.8YTpյ46dZhĸe

R؅{jKWYzQ
yE
o<y%ta37aLWF3^HxvOrk !"<##.$$$S%&&3'')T*n+~,-.-//0008111]22$3333333~3G32222]221810/[/..h-,O,++'+*q*))H(o'&%2%$#R#""W##1$$%A'q(_)0**L+<+**[*)i)(D('g'&\&=%4$#0$#"!!!v! u3S>_bBq3Foq

v	t
L.N G  %yo[/adUe	&8Kt߸goQe36L֗
Δ̰z%ȀTC\uĻ-,̳F=Ʒȸ'|ǾlsZȭ	΄Ѝҿ-C?C\9kuw"?wx;	
O
JOH'JrnOt5k)2]buT  !!!"X"###M$$%J&&'(D))**+U,,-..//01%1g11B2v2223222r2>2$221l110
10!0//}/0/.^.-Z-,[,++X*)%)('y'/'&&r'[((;)0*+--a-\---,++*D*g)('&~&%=$w"c!0!)! -c>QjO_`sa

1
W	>$.XG 1 q	8+B-Hy3iOiwp߫ޭ33R٨29#)ɬȜǍI	W]˻LйNgf_>z"ٺY{&úƃǇ3b̈)Мӫ֓fC܀# fYyZtY {+	


*{qmXF
w%E(o 
!!"""#$%<%%&&H''U((^))G**8++s,,)--c./k///a000-112w223334'4!433	4
43k3I3@343322e2211000//....../0111010/.-----S-]-r-,+*9)s('&a%N$###!O gvlhZ,1i
-
$

~	
^ Q y9JHd\&[%=q	KR<8YY޽/ݽidە;n׉֠;ԮMК͸
kʼ8ǉ

[
u+;{#ۿڿ;ddtkÛYÐÌĜũũezZȓmOm̂+ПџW[׷ػ;FRߴ8ls+_q':gh]l	

$k
oL+)\S,RY[r !"#]$$%"''1(()*x++,-.k//011!22o334455667788!999:I::::w:j:u:L:99999&98x8,877i76D6 6555r443332G2
2100]/..n-,+*Z*)7)5(G'&%<%n$#"!a! 8 n5 +Y<z3[&
Cp
	E	#e ~aWGVADQZ`OU߸*lRِ:ׄmqҽGХ,Zͨk)ʸWȖ,Ⱦb!ſt
ĜKÜÆÍÛ×ÓúÿùD@ń#|<-ɻʔT̱/ Βwkaj#nٌKuޔt)+dly7yz/ozT"R	
%A: !"#K$%&'2(()}*L+,v,,k->. ///0011E223144n55f6778G8u88Q99999: :9999m9?9
988a8#87{777'76666N6655i5954X443m321M100/.2.->-`,_+z*)&)h('&%F%$)$E#^"!&!] d}9KK^Ej


?	GHp   Nq)A[~K)()<b9l ^݆ܢ&ڗNإמDՍ kӭ_BGϺ2}͇̺˘f˅Ɇ6#Klpqɏɶɾ
7ʔ	u0̾]AΓ/[*ѝX'ӿ8w֨P׆.t&~ݞގߎj/0%8^iMk(V*
 
m	
k
K]!tv" "#F$#*$k%&&%%%'(D((<)!+,+*8+,--d,+,P--o-,/-/[0/."....-@-|-I...---.-,,r,,"-,,},,T,+*'*))))7)((((('&%D%$3$d#"#
#"!S! ! a m+ky=|/)8|5
?^
		6f5{ = >aA=YkbYN;pyNx[h߿Aݨ<ۍ!۠/م ٞ3׭l&֬m%գ|`I%tӽӎkfzӗӽӼӧuԿ
]B֊(ל؆ى.ڴەi܇aPߦ!32&I}QHBBdL]
D:;]P }`{_~	#

{.

{#F
E{`'FaZ   !""""3##	$r$$$$$N%y%r%%%7&r&&&'K'''''4((((((1)e)x))})h)M)*))(((((V((((('''^'/'&&&s&&%%%%$${$$##""9"!=! uAcZ S`$mr{[$
9
u
u
	%	N' 6lV 1c=?_"}h*HP
jPBTJltr
]ycp.t,ݎ0ܳ܉eH.۷۔lAڑXGSKٵټ2x'ۡGSܙ&ݳޖ!߀߸OAx,2yTBjR(k=IYMFIfk}}=R FW{31N]	


Ai
b%~<ovM<!u!pJODPP"x |    !M!~!{!{!!!!"2"W""""""r"w"x"L""!!!!E!!   2 gG2QbM)bc2]OXya+]
$

C

	qCUQ1TJD u   ~
V>]oxJ+296Ur&RUl*8M{"h!|y^-^G@?5S1zl^J<0%189)!0Pan :i/m4]EkTo=2/Sc\7<
arwlEbYuXM  y8)[>ZYt5	



%-vE


@.[tt#2ULx0|2]&sjvU?OV9iP_gK@;lvuR$}(U'c|S6
p
(B

t
<
	
	r		~AFzK}BX!R7d)  F  WFj'z4XwC
AWS$a"di>_9r`?|y|}k[cWJRfprrz{pnv~0T\WhE @\F\M?}-.hZ;pai0^ ]    3'm?h \a:y'=k!5Ju	V						
*
T




?RPMJa/4$m*




w
v



















r
E


			q	d	P		]D#`$qM,qKX4p:G) u5  i 2  zCN)gH p^O+{W9c?r^?#rU7ynWJ:!"1;Hb&**4Gi!0APl&JfDo +Ie{'?]3Sl9s 4 c     0[n
E_C%:{07\Hq:^d0byvOEonlx8`m~.$%T	 	%						$	K	P	7		~ntm[<h=O$zpaGW%W3lO;$yM'    n 5 	 T"b;zbJB:*  ".<NI;"	b>,:HWftwqnlkuytw-CZ_dekkd[du~qmpshe|AYx
9\# M j       ,1<FZjv  %1Oz&+;Qo{hqxdQDFIK7}qsuqfaZ^`cU=(
~ugUOX\YNF=9'          y o y                    z l i i _ K 7 &   $ % & (      xa?%{r]QA5'$0=DFLQOPKIO^gQ(mtiV-*>PZao"4CF?>AL]fhf^hzsio~%5?9;J^nsnjo~ 	       % ' 0 @ U f z                                           } w t o t ~   u i f g n m r l d \ M > 5 4 4 3 0 . (    % "        
      	 
 
  	       
    ! ' 2 : E < 4 5 / 5 9 G O V S D 3 . + / #   
                $ ' # % , 3 7 @ J W Y [ ` k u | }                    } t f c [ W O I G J P W ^ ^ f n |          

                            z x r f a Y Y Y \ ` \ _ o     | ~ ~  } | ~ }  | t k e Y O N F < 8 6 3 . !                        vssn`UNGHMF=5+%	
09GL[fu}|tx   ! $ , 7 @ = 7 3 7 4 7 < ; C G M P ^ f r }            
 '4CQYdjsuz{x||~}}xfRPSVRL=*#,042/!
                       | t g X J > 9 , "       
 
  	 	  {ystoge`ZSNRQONFEE=1'##$$(+,,39HPSU\mw|tuwwvvtof\beegikhegjv|nf_WXX]\[XMGNRXZROOOMOVcmlry~}~wsrropmqw}}vxzxzxssxx~               ! $ ( ( ' / 4 : 9 : A E A D F E F D ? 7 5 5 4 6 > = B M S M B E E E J O P M E @ D G L F ? : 6 8 = E D L M G @ G K F M K Q I D @ ? 7 0 2 . 5 1 + %        wtw{zutlmrtw~~wtpjjmpokf_akknieYSWW][VJOPJIPVYTSTYcdigjnnjjlnssmnlntqrmgilgd]VYYTGCFPQPRLHFAED@DFGHLNKIIJMRJDIKMRNILMPZ_aeeprrvu}    
 
    # % * / 3 9 B J P O R \ Y U U W \ b h v                                           u u m f ^ ] ` h v                                   { p j f ` f [ N E ? = < 6 2 ' ( & # $ "     $     $ * . * ) ) ) ) , . + %     
  
 	  |~}wvyw~~}~{qpu|tv}~  
  	    $ * , - , . 0 + #    % + , + - 2 < A ? < @ B D F J M K K P U R O P R V T [ X X ` ] S S W ^ ` c ` b f k s t q l f f f e d ^ Z T S V Y Y X Z X W R Q K : 7 2 8 = : 9 4 2 6 4 3 - . . 4 2 , (                
     	 	      
                           $ , - % ! ! . 4 3 4 1 ) ( $                   + 1 3 / 6 ; E G C C E J L H P T R Q T V \ X W T [ Y \ ^ ^ V V R S V W P J O P M N J K K K B < = E G E ? A I H L X X Y a d b b a f m v    | t u s r x p u m q r q q q q n q v y u u r p n t s z w v m l p t s r q n o x |  | q q v                ~ z  | { ~                                 ~                { x u y { }  { u w | x { } w q v w x o l p v w q m j j h l q l g ^ ] k t s l b j q z } ~ y y x v s m i h m y z z v u q s x x o k a a d b _ _ d b _ X L F E L M J G I T P U X V [ a a d d e a f j i g c j o r o p m b Z P N J F A B @ = A C D @ F ? 5 3 : > @ 9 : ; > ? < 8 9 5 = B F D H N P S Y ] Z W P X _ a b ] [ U V X Y Y ] \ S M L L K J L O M F G B 6 . 2 . / ( ' & ) + - % - . 3 4 5 6 5 1 3 / ' ! $                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     
      RSRC     [remap]

importer="wav"
type="AudioStreamWAV"
uid="uid://cn4hd0wt1g28i"
path="res://.godot/imported/p.wav-99f014348577aa0b2a94a7ead1ee567f.sample"
             RSRC                    AudioStreamWAV                                                              resource_local_to_scene    resource_name    data    format 
   loop_mode    loop_begin 	   loop_end 	   mix_rate    stereo    tags    script           local://AudioStreamWAV_in0c4 8         AudioStreamWAV          Vi                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  ) 1 9 A K U ` j r {                          ;y  gahfr  w Y > e]!fV.O,\w 8#	mp
jQ8	["2
g^=9u?^XjxcO3$A	m de7!EdB*f,?\ߌK}{/ @	]	 

mS!
	

k	<MMD
T*]8	tmPm9 WB'P_{Al\F
v(Jbz[=  ycmd Ot0ET+ySXszL #  @YlLq	
Al s/!$'&##&_( '$"!"e"r 7}2}|
%	^ l
7+f
6>
lB
C
.  Q>\(V @:+u	~V";
<	(c


c K7 Nq pa , r 	Z [5
	mF
  <p "2}2
:w-#]Wl<PK=Gc^>]BeGY$ H}Agbgpl4~/>3
d$7

  VEwpEF:v4
`_J "=}9 ik
	b	
0
D_\
>"	DvuvU /4

1
;o#O

1	 p5gR5!H  U'L5. Z Cw@ .u#`	+};`5Q    p_5 -  " s*r  Pf
cj{xpz#%fDxtU1q#8Dv}}
QW5hA  .Y;9e+kqU)W)@D(r @/ o  q 7Cp[N(
))E^ G 1@!	r{1
q
J

T
>

p
o	q	bwC	"			|
[

_
	e	L	apaPG oU<q.ZOL#ObRA}en/*zJ@  X\(el +_3qLol!aZ-u7IVPS9*6e\KRT*+$F[,8&  >eitH'&%  I " # t8o5              Q&    t < r N  XJf  
'iAJ%9JbL+N*e*N8q"[()x*QtF[.w	fS\w+]w o q   EpH+*
IQN0q*&U1kys|	d
9D  ]'H4?ya }J)oq	 [_	)CEW)s(8sO g$q{6[p@ec#hYQBO
7EC+   r  `'j|44     3q6VN{"@ 5#)
&G,K&tk`y$Qr]JTofvug C+XUnsTn3\(sP	%|x$k)]~VfL2r9Q[-iUh4W!P0{ ;JMpM_C" r  x B . d  w  Ety87ED\*<RkOM*!6[^b)wC47jQui	F	'	vMar{XAw*
eeYY	
<


S

8
	{ce;;v}?$@k8s
 ]JB^L	
5lF " 9Gt#5%6e!=a~    +  5 
 }YA+!Ve/1w  ?=ht.>]W=5WU	E    k  jI7_. e   | r s \  xI 2?+ quuM
"{
!oaS r  j  W(4gk+b  i?iUL  n%oVqVB){wW}^O2}I6m
M159EQKd,tl
 W
~o_V026Sw!3UL&YL!D.hk;W9*_Eb?xNvF4wxIr5RjnkM\2){dx )`uy|vmL1Yf`HY].}|<JGl"j%UwN=    8a;)@SlZ&	t ^ )  kUQbd=
8u
N(   J)Q6j:kRiO.	}		k

\#Xu6#-'%




		x	G	P'; A!<?;mP[C(x$%/				
}

:<0



5fjR]g@

I
yn

>
		q	O		wKJ-I]H|LH-`N	c			&
S
z


/,!


Q

		[	%	@
$i,q2L^NLIKF.
P1IcW2+-/3>/14\|#Il|y|gC Y&  @  'n3tK)$5<tKo8xFP*m*93@Y5IV	 	 ^(bV|Ul^Ng	"#6\x+vI * P  BN-]oUuSi~/T?sKxaO-x3c0        } Y 
 9KzS'/A(tjp#9{`9|8\#
zYbuWg2KbC@3&*{oY'iGZytJ#1 i~RI`La |X7s>  Zi7DC%_)		s
"$}F

e6}
6?>_ty+R#?dvYnpgx3vfjA]2;R%b>8?Dd5
p
H
g
	P	|E
+3\Y *Yf`b-*'NS:rG܋BڝGخ׆Eճ#ԄӉhgjϲ%Ε͢%̩'ˡ$ʮ;pXHſo+ĵq9C®AarUR:1HqͿ$bJİťƩǏeɊ4t_մXܼC8Jj5a
| %Z)G-0N47:O>DACME>GYIKLLMM{NNNNNOON>NMN]NJNvMiLKKKMK7JIUHGG=GmFED=DCB5A?>:=;9786420.,*)(W&$B#j"! r
Ve' `"#$%&()+[,d-z./012H34,5I6%778;99G::%;A;@;;~:999:9^98i8877)6
53210+.F,~*(&$c!$/a	 f.1/Xߊۋ6@֤8г~MỎ/@vxOŒ Ñ$§{տlὉSɼdkSι!<Y:ѳ
:fr_E$ק]ӤjK=ڟV˗ږݕbDXoq|~kWAKp+BSל~uȞϖz7Q1+{
&M-39\?DJNRUW"Z{\i^4_#_'__`_j__^_^]\[ZZ
ZX\WVVVTQSRQIQPNM<KIH0FSC?c<951.
*&K"S >$)qRILo?	n
a, .$>(+$/Q25}9<?eBDGtJMdOSQ+SUV)XYY[\5^___`Aaabaaaa-`^]\[YWTXROLIdFBd?;98C4,0+,[($ N
 jx=
5yLXWcU\ :s TfE	g

(]G
_
		/I6P6r? 'r3wx
Ēr̷ҵ#=I>4`'PyqQkȑ:eD	ȄezI8uEG!|l|kʍ9y܏}MeÃʑUۜF+ 	tM a(H/<5:?DMHLIPkRSBUVqVUeSRoPNKI#HE
DBA?W>$=;3:t8l776/6i543211o10/'/.-D,*(%>""	t|"zZ1(u
|GU%*/3p8=NB@FI#MMPRTVwXYZ[:\X\2\x\\\6\0[ZXQWUTS<R
QP!ONLKKIHiGFFD#C]Ax?I=:852E/+(I%!ZV
= j^n>GTI! D*Fm
i{'FN
 E m  ~ o \ D  !]X
zt!YB]axڐשe	Xh1ٻj1赦b(֮])ΦߥꢜF1XʜM,t/ܙ)Ԙɕq@36JÊC1ȊZFӒٳH
pccL
&-38=RAzD2GIKnMlNNNM~LJGEzBf@><;:9999897>656.77 8X7k6z54321A/-(,t*(&$M!
AP <O{Nz4L2; '.4[: ?-C8G!KNQRTV$XUY.ZZ\[[F[ZYXW'WVpVUUS?RP@OMLKyJIH)HGFEDICA=@1>;85v2[/2,($ H xpH(giVL\x7~~$
|!(h
K0Sl}Gu'{B ;\3O
L

T	>.Doj _+o	!:aӚέkː[x  ix1꽧i(t5_ï/t룬`aA_hޏĎm
	a͇߇뇑UIɌ}nċo@  a&.T6<UBG4KNRUuX+Z[[ \ZoXUTQOK@I"G(E\CA@?=	<:h854%3x2B1A/,)U'	%" Er!
Z	T iMG	'7 `!'-F4:AHOHTMX[8_bgeHghijj~jihgfeYcka_^s][-ZXU#SyPMTK,I)GBECA@n><U:7*5]2c/j,)8'$!6h{f41
kZoXU q  AW	
#acLkkh e!5"#$n$A$####;#"*""! cBB|&d7$`k_X
v<iTgۑRSIyM.BqwX;i	5V\mD𧴧gOspިڧԧzըTD̦=A 󜦜is}^
ƕp|᥂ھ4Z#"*0/5k99=0@AlC1EvFF(FEE`ECEA?L><@;-:O9R877A8887O765243B3210.},**S(&-$!!`
0u W `%grdk	!&2+/3T8<@DHLP%R%SSTUUUUT3TSS/R.QPONMK0KJ1JjIHGaFD|CAs@>d=
<:8641 /+x($
!#1>P
	$+7:y g

yJu!$R%%&Z&Y&%$P#!E MF1/_k>4Dj]o"MY<LB	c
`Kߔ>ވ޳ߟGdf]Y߹,z2ԡ(\ŅĿBL7+¬/bҿaڽyӼBx۴߲RMK裴ٛړlo׎ad\'?pG`GBԞj -͈ԴۃA	%"',a2Q7;]@DG?JLNO-NeMIMLJ`HYF5DBA>d;851m/-+)V('&9%"6!Y 1Q5)
+b	SR#]>YR _DDZs"'q-@38K>[CGKiOQSPWZ]^T`abbaZ`|^[\BZXUSP/NK!IkFCA?=};C9,7f534230.,;*h(v&$" \,hPD/k{~#:
7?!$?(,S/a12L45666Y5f421J/L-7+H)'%#l!a9H	l  SZCI04	z>);g]ܧPL׸])ѿcϧR!$XΔΘZiͲ̿˿ʼɄ;|cԭ	٤2;^*0/mΓiN~זyҗA6	#w4ըg֯a쿕$ɉҟ\#($.938/<?C GIrJKLMLJHFiDA>;840-*'$"Q!c'RDX'
*
l. #qa-"'J-27<gAEINQU}WY:\i^_0`_p_^_][Y>WTURODMJHECA ?<:8V7531/-+)'j%K#&!]Ti
/U_9}M	L&e#5(,001B3l57z998887(6421/-+(%$#!sh$k1ZBa
]b
LJ wd^{Z<ey߶z$pwAc~lXLܢۉuW)*ӬҦ0TӆӹԨ Ќbɰv( ' vxJӠI5LÖNs$֗ZěW杽ϟ5%׮Ȱ𲮵׸voUB׮t 	"='+/S3N68;<=>>>V=<<:8{6420-c+2)<'%$i" k[yZ|5=M 
n
N	D}LMG6	Uv"&)-1509c<?BREGIK_MwN)OOOWPlPPOMLKJqIG2FDjCB@6?==;:9976543\1/.f,j*+(%#F!bdR
H2/y09t	
-

 .e "$K%&'x) +[,,;,6,,0-,+m*)(u'$&#%$$(#! ,'B;yvZ

_w yVP!Lu("j*)S;/,5YRqhי-׹֣R5ֽՅPexicΡ'SǐūÓS}U Ů{GiģM顠k2ɠcaĠg4;F𦠧ج·X"yΖݼ"DH(_	$"jFT!$(+-.0X233H32i2221Q0. .-,*v)M(U'H&$#"!*!d hZItG]B	

?
 h'

|qc9P #%g(+-\02[579;=<>O?l@uA@BBBB9CCCzCBAA>A@?>=@=<;N:j98,8<754i321C0.,F+)'%$"O vrp2(%y
T'3@40
X.x j#$%&'''f'')*^+*k)i)*{+*(''&$" P 0B>K"2"
8	7	1' g,toXFzg)&Vc}tQ߂ZݳBܥXٹٓ\:ٳp%vIҡμI
9;.8Gllڨ++ҧ47ǨWѪA6_įNB)2L$Aavr<h ."#$+%%%%%d%_%T%:%%$$##h"! # o]Tn2;QOBWA 7"#4%&/()D+,.0;23577|899:::::::::::~::[98!87n77q6544a322^100z/..7-b,+*)('k&6%#"! / kv^  ?!!"#8$$$$$%%&<&
&&&f''P'&R&M&%$#"q"! b KDJ1
|
,
Q	pdm
 )uO.m
oB9g~og5!w@ߴ8ޟ%O~ۑڱԁ4У;̐!ʊ!œ³}S#'K+hjӲ`ayްҰٰ7>S XǶH븏js3±jbʀ"s׆y23 	@(~"E&G
     3!! ;!!"!   J <B'6 V    m & #X> y   {!!4""#$I%&'/(:)+*+,'-./012)3M45L575B5556$665d5L5C5544.43+32l2621110Z00/t/8//...-,y,+R+*)$){('&%$,$m#"!  W!0#%&&(*+L,,-.(.-,,,)-k-s-<-,,+)(&%
$}!Sj$4yN3E
E
x
	a	5j&qI CQ8If3Oo+E&&y-/܇4ڒ3هHcؐ׍f:
ϏBɮJĐhֻ鸁2зc 
?`G߸иݸ3]oֹU ɻC!,+ ªÞĉT#upʼ̮?IeQO	8$n
M
xI2d#yq_ $?e`aOi j!L"""O"\"q"f"T"v""/#####*$$M%%%&B'((g)**<++|,*--,../0'111@2v2222222$21F110J0/j/A/,/
/...k.%.--g-A->-A-(-,v,H,?,,++*V**))**+**++,`-U..{.--O.Q.-,,,c,p+*)))@)'%R$#|"e D>(C=\


<
DG



a
	C	j	l	E l6]}NW(.NO"[FM߭ +dۛڮٷتו~nqӓҶ
'Gǥ(ƛ_QhQ/$H@ 
ϻ
AbrÁ
đ.š9[ǂqKʆ˶̝Й]ԺܐBy;?%r>  1
O
 =*gw/]U/:T?78    F!!""""K###c#,#A#w#}#O#7#p##$#$^$%%@&&K'())*e+,,4- ..3/b//=00101&1110y0/_/#/%/.i.-_-3---,,,,,,,---.------8-,,I,+*)))*^+]+*\**+:+)W((('%^$$$%$
$G#B##-$###w$R$e#|""!,!h geB1
Lz/hY
X
W			~L6   ' LQwf&f^SnVDoQxb
ܺۈIطoSdӒ,l{!}~FX%
ȻȎoBrǧSŷUÈ_Y<Bv}|\]ı3ſNƸ*ǳPȑ.ɖ˄Q)(Gѽҡaׅu}p	R
{>~&:$X\(P/  !c""A#3#$#L##	$###$(%$%$$%%%%-%$$%2%6%;%%g&p'G((^)K*\+C,,A---..m.~.l.d......x...U.----$-,Y,#,,++++,,,,,Q-----C--->--.R/\/6//0n1	1////>.,+w++U+s*))e*s*{)|((f)+)'%$$#"!!  S4o">85
Z
,y%JP
	Z	e	c	01O LBf30 RHE?c7^vy;/#.s^Hݺܟۃچ٧Lת֗8ԏ~ґTҚ<І3Ϸzx4ͳ+fɫG~s-^¥¤T]O6dƔƸGǠǰǵȰTɕR)uɰHS˅eͿθϳЧѐbԙusס؍ٻR$ߵ!@Wk4g2` 
LIY_ z9x=hh !Q!!  !!$")"!""#$R$$%&D';'&&
')'&&&&z'''e( ))**))******9++++++ ,,3---.H...{.0.---y->---
-'-1-- --3-"-,,-P--.0111a233	311:10L/-,,,,,h+*).)'&e&%$R#!  XN%)Iy,_mJSM0x
,iG
c
	.~A Za =YO>Cry aXhLP#_'aܟKڥXNװ
։
Ճ\҈Eц"дsнaRΡZYVʵ]ɽȡȄG}\ɿʇʖA^4h=FΙ}sϪW#=ϦЇfKDѿъ-Ӕ5Խ}k/שGWkE߭74`Uj;rs	@!P	<N
Sa4=N4}p9x'$+d d!!!!"#$$$$%%&%%V&/'(_('"'&''':'&'())
))`*D++,5,,-....///C//P//0/00///t/.-Y-J--f._/a0D115223k4P43L33A444333K43210//..6-,+*'%$,$#!$ `=#=
sP	bg:E
~O
y			g0i t9@$
d	'1?g +[=m Fyv*}UޖYۜQ؜Iԑ=U-@'җxcL*AtҒҖҍҌҋ{qҐҨҊCIғҧҔҰ
E;9ӘӍӿg^ZqՎ-׵BqٹA{D݉߾߁	WB1'$/?!e/pe vQ	H
?{
uezX~5tj
' ~!"0#}##$%&'4''()*6**$+++%,Z,,,-F-K-<-5-A-f--..-......|////0}0000001,1000010(0/q/7/..-9-,,w,+~++*V*)S)(3(')'&&%%$L$#"'"!4! 
a|6{L+M

Eg
	'f  @-y?L)J:jKjXGv^ߗh#ktݞ1۝m3ڭl&ِKت؀gX\en~ؗؽO|s\u٥ٺ'ڡK۞۲۟ۦqܻܪ74E0p޳Nߓߺo:9>,K7Rp"|s]&~Ox- }+  db:
"!

-|#a. ?  A!!"#"\"""#H#####4$z$$+%b%%%%B&&&&&&	'''@'h'r'''''`'K'X'K' '&&&&^&0&%%m%d%O%#%$$$$0$###R#""S"+""!i! W amg_>hNO:%YQ'[
?q
	L"\0| "iH.}iMbl1K)e*w048zTXYv$i?ߋMsLE/ݳݫݺKޘMߕ$m3v(Gp-j;m=yY=~X=x+;U`rz -F1?B H&K_		

 w9

Oe&@z!{4(H
ar7dDe5_p8kO1n"yij}l Z&\#
w!l.	
&TxMh? 
g
e#

	,	U}hBm j10*1h3:Ucl\aQ
{L5s,l6fN8-&jfjnq2_"Y$Gjxz|/d%`2[N~l$q["~$)#+3G#f]>"^E   aB%d>>m0	S		
v


:d$


#-,F)s,B@H|%Cs>vB&"d6		X76n!g5c

h
,
}pW&}P

c

	y	<			Y,U^;=C{5 v /   xK
wK@y=
gM{L_4NxP/plvZ
#.|`.akfeq%fS:eRS(P(02h(T}!VzR8 `   K\/]y>{r-y0IQ^:W8KSQ\/@IUY^o	+	@	>	$							.	F	K	@	/	D	{				




		

.
:
A
@
%
		v	@	$		wdF1j=x?d<|]O;V8:v-   c  CU$qBv0xf?k8yjW4}h]UR@" 	7Vw+;LWfv4^}:a7c(Px'Io#5Oc{ . 4 < C [ }         <axD!Wx-\x2NpuHCXowsonjco&4*
	*:LQY]ozy\D;<GD2sM5*){n_VB(v[6rQe3    o F  pTC8-tdYPGA* |ptxw]AoospfeZRKC@HQ^gcomjaR0+&#1,#;[l"

#'&;Ugl|,3*)"#*39;BGHJD8079@Q[bfpk_PF:22133+%6QkBt 4 I f z       -Iavp^XLEIMPOEHEF<)#10'
!
                   
'6560-/D]bdd_WQTY`glqso_D3     ~ u h c S E ,  	  	     ' ! ( ( & 1 > R r         k a U R T W V Q 7  {||zslrtuvsyvswysjls         !      # '        " "                        
    
  
       ' 1 6 0 4 2 *   
 
                     	 	    ' & ' $ ) . . 8 1 4 ) " "     % "       	  
      }wleb]WMIFIJ=;:EJPTPV^nw{yzy{    # 1 < I Q V c f m q u ~   x u q j f d e ] V N E A > ; ? 2 , ( & + / 0 2 3 8 8 B J E F F K J Y ` c m }                           	
 
           
      RSRC     [remap]

importer="wav"
type="AudioStreamWAV"
uid="uid://cbjvs32hjgfyr"
path="res://.godot/imported/q.wav-e881c35c3c9aae69c368ae5e83d5dfd2.sample"
             RSRC                    AudioStreamWAV                                                              resource_local_to_scene    resource_name    data    format 
   loop_mode    loop_begin 	   loop_end 	   mix_rate    stereo    tags    script           local://AudioStreamWAV_ly1vc 8         AudioStreamWAV          4                                                                                                                                                                         $ + 2 : A I Q Y ` g o w                    
 (/5:>BEGKMPRTWWWURPMLLFDBA<3-&             q ` O A +   m[I4 	nU7dI3{`SG2nWE8"wja\]aXWRMMNLEB@JOG@GT]c`[ap,=C[x1Ld6X~5Vz(T$ P   
G.uZNCs!^&^'R	?	f					!
E
e
}




'7GV`cjnsi^XM@0





s
_
F
*
				o	J	#	vOX+ m7d1X&y<Z r0  y 6 r1n!m/ZVGx/]
u*BmT`Kg-k<jH&tQ.~a6gSD)%Wd`5t`oPQaTXb~ O
u	Yv18b !"#$M%%]&&'U''''''g'2'&&s&(&%%5%$$'$#x##"m""!L!   ZlHGS@
j
q<
v

		A	j/EUw#vc5 G <#ORR*u8nEl
0Je*Y}*/݈e|ڇ٨NرU֐Cֺa լi.ӭ`!Ҭ҇V3'4ADFStҟC{ӳYԺq-֖ט؆	٘7ڌ[Qvޫ-n]~wI0Ku
u
k@ e* :"#t%&'()a**(+t+++++9+**w*_*Q*D*H*U*x***+#+5+Z+++3,u,,,U,!,++**:)e('&%_$
#!" 
5]G*
4

		I		vz	Q				;


>"

@e0+o_@5}DM
`
Na


		xJ(-CTd u|}AJG|8[FGKVn"@d>k"NxUK$X#PwhCb7yGd;o2g5X2*7GYr2K]jx,<VosP19Y{,[qLL`" q5
mA(<6TT :!""j##{$$N%%%'&^&&&&
'9'k'''"(](((()O)t))))))))h)()(|(	('&Z&%$.$Z#|"! *@Z~'gVo
:
4H

c
6

							}	}	}			}	~	{	t	m	U	7	"	h2VFy'=50  ]m
RU"U2lE@Q8)!7]}O'ZߙAހ#ݗJܭb*ې^4کڍu`K8' 
;]lo~ک)Sی*܂sg߫j@OA< $h
:wF u!"#$%&$'''O(()Q))))))*)))**@*b*****q*O*&*))X))(I(''O&r%$}#r"Z!K 7Mj2<i
"v
F
	r	5			R			@

'o'


re3@7`1%
6x`9@e

	!:u&a;o-?M&K	:r:?p0}M66Njw17=O[F"a6RZ'cK-b5	wNRP߱ߏ\*޵ޤޏނޏޥ$Txߩ$ci0hRFoem
W6S\
	B

,BH@1!$ !"{#I$%%&9''H(()u)))***)))K)(((''&!&%$g$#6#""! \ S^_i'Wm BvSs%JdNKLC4 #/+!
{Z:z< Rk'1
w

R~


	
	\c^, K	lL(oqyr$DeWPp2O'bVOD8$#()$!$(,
`H(YE=<7DG>^"k
aޛKݳݍ\ܺܚ܁lS>;8649@U܀ܱIݪޒߧG0NAx j	M	8]36! !"#e$%%&e'((^))D***++H+P+?++***,*)')('<'&%	%@$x#"!8!r V`8-=MiJ
^6sa]ejupaXg~7U`ez2Ks=xm1u)3+%@9nD
J
4P+=Tm|Z41Rm`S	#Vo= 9L`y>X{
&1&g7
Ys/{NRXh܎ܣ'۹YڳXټ؈hJ0
 )T؎SٝoH۽Eܬj" k#)U_H O!
0
gHfwlL)  !S"##x$-%%&*''O((Z))?***+Z+++++u+L++*Y*)h)(@('&0&q%$#"*"Z! 8ys7 FwE}YC$~pe[I2gH.]4N|&f$

D
	E	(d.y: Uxlz-u mbhF6k=,<g!e<aC q@^+tHpBl0:B` 9,#-߰,ޠ'ݯR}	۩_q"ز؇S&׽׫׆`?57?,
+ׂy؃+۲ܟݨk9/o5hWAoY3
A
1M=$I !#;$d%u&p'\(F)3*++,1--F..K//0G0i0w000n0B00/d//.0.-,>,+**3)Z(w'&%$#""! ,Jv[HYp	=e8
-Jq$pc6F*7 s;>xbCY:=f
!Af

		Fw$d  H>qYdjV}Zx>
oGziQ?(iN3T&X[&^%r<,:%V߯:ު݇ہ}gy؄״9eվbԼӉQӿl-щM?I?NфѬ.҄fy%
Axڐ۱hoAk 
x>p0Q "1#J$b%u&x'h(Y)?*++,E--.5//=001|1112222111410\0//m.-,,+'*3)2(0'(&%#"! }(^\M%W. @m)iC/^aO7u:n4HPOHI:n7-.4S}b47	1Q
q
	nB% utpboW$Fg"wV+V	@i .g
fXl=b*V-y2w
F߀޷4s۲6iث _զPӴwTϙΨ%͕̮Pʎ	ʖ5ȘFǦo2ƠƃkcXVƇCǤl+Ϣ4Ӊ@,mfjoJ}	For A"#%&I()+r,-./012L33=4455596p6666q6G665<54Q43j3212W1e0q/.-y,Y+)*('&%;$"k! @vB
T
U
jjE
HW
p

D&`qm^ez#Qn?Q [    !!!!
!  ? Fe01 xL2

	.O,-fMd ~ 3 &(h&N&)t4.Px
4Xup_=
tI7K[t,QI}ߨ"%ӳҠуa0
ʵɞȏǗƱ>t¿p-ӽ;x3r6ּM车a_5ũD˽ͳb؛ޏ3%JYn
;!a!#Y&(*A,-/1234{5P607
8888999:]:w:::::::::g:0:99P98r877)6X54w3120>/-},*;)r'%#	"+ Sg<n?#
jD
>
							4
~

-S8

8A'C+=a
=w+(o(  (!!!R""#.#?#K#]#y#~#d#-#""g""! U &Wv{gR8$ 

)
}	dVz(jad` a Hxw)}y
[7eY4Gam_5z	i*11%3Rw(Yܑ݀ۤڸּժ}M,Φ_ɏU'ıËzpmnxD|뷃2ⶅ1̵Ƶ6xĶGEĻFf;ΛՔe^ޏ?#^E d (#%'*,-l/072X3Q4556P77)8s88>99999:`:::;;0;G;0;::s::99]87654131/[.,*(&%#(!=0!,d\l
aq

		ll	l		*


\

1inMjWL`U !!H""b##K$$%h%%%%%%%g%.%$$ $[#"! 
 {NpB
&
e	

	%	}aAa@rA+e HSM{79|?JN
:gk4Z;N_ښٓ}a9эEͲ_ ʕ6ŋ;c;'>u˶}]볝OO6JYTRj޲Yks[Sa(ÆŌǭ̭΅J Cڜ
<j`t5[ #&9)+.*01J3c4h5y6_77y881999@:d:h:m:y:::;;;0<<<=*=?=2= =<c< <;*;X:19765N3e1V/:-"+(&$Q" (w

	-<&K7D		

0O

XO#Ol6[  h!""-##l$%%<&&'q'''( ((((''q''&(&%$#"8"! [8Il}xq
bK5
	'jr X^3Q;+6_nwpo	o\*t	jss:}
%+-EX^R0\4!ުs2 ڼgv8РR̗Bzƻv6|?ɹs{]	Y3j*筷ݭ*ͮ:䯺aSBhi	;Ӑr%;)l[s
nU1c #&])+.?02356678899
:V::C;;;;<U<<*==>>>_????????>=.=I<
;97531}/,l*'%# [aw	eL*{$M		=

oB

,?<X{[ #!!""##1$$S%%&_''''((((0(''(((s(r'q&%%5%$"!9!I vc
f#NyI
>
|TM
	7;VX z=Sw`[V/
+KuX\'B<F)Fe|!yq%t
W}L*(*yٟe֝!ӛ0*}B|q	ſp	`@@G9-Pб)Q
d
իpc׫~ux-}hY÷NWˣ
U2%m
G{C"%(+2.024}6789:N;;4<d<<====>G>>>>??%@@AAABaB}BTBAlA@.@z?w>=p;975o30#.Z+(&# vX

`	RzVF]l{S		

Oj

T"yD+)*(
.V !"#$t%K&
''v(<))*+f++++++x+++*y*);)w('&F%#"$!5! c k3

_


^Vn

*HG&

.
~
	H CVgZci=Jv%lURfok liD\ld6cI A.0BCH)	n,ܔeٗ ^ԮEe͇˰,x׾9 N7kHdc9֬VثM/Gy
JVKApGAZqF<(1r,o-
aV$ #&)A,.024+6R7U8299q::4;;;<j<<<=G=z==>>*??@r@@FApAcA2A@z@?F?t>c=<:864c2/Q-*'L%" r2]3*U
}
`	<h9%<f<		i

v^f

\(cj.vC/%+B] !#%$!%&&'()Q*++Q,,-1-4--,,),+.+~*)('q&%#F" #:)`	-l
r
G
6

I0
	4	A99HPC<8 5m60TJ3]  as C=v9r'SourgH܃ڧ-מ
rZͫ>ȉ,Ð
-e6ӵ´:|Xϭ.իHܪFةl3@\L"XשrPeϯl&&õƇɧк|*
t*Ky1
l"%(+<.02468e9P:;;B<<k===>p>>?+?I???k@@GAA,BBC:C1C CCBBlA@?>>=;9t7?52j0-*(r%"+ iW
T

	Hg=G OT		
W
tVPjW1kf ^!"#$%&'()*g+J,"--.:.c....^.--'-,),G+8*')(&%$#"! WZREOn
h
	9+ LRj("<BGtj|Ps}N`k&bs
W	h%Nxi=߁(F^Iԯ*ѪxN[ƹÁξ~Զ8ײǰɭɬF#ra4*KƧ2ɨhת]/PݻOŖkʌͲbd~	-DwO #
'4*%-/e246t89;<<={>>?X???$@F@:@.@E@w@@3AqAAAB=B]BfBSBBA-A@@L?H><P;9753>1.1,)'$	"m"Z.4m
L
	8<(M.pP2			U

w

hUJp_U( v!G"##z$%%h&'''(:(M(_(}((((('(/('&%A%$$8$,#! @ y"V
l!
R(h
u	K		
{
y



\,J2y

	#wUA D2d{fn  4\K(|[/^:23FO
-ۃוՄrҐ
Ϗ6XȆ&c|7߰ί{ª8ܨFd=)zqjo󩛪jQ_xj]F$Hl/ŝ|ʠͣֆI=*`"&3),.=135J789;;<2==&>>>>>?8?T?i?b?o??8@@@@@A-A!A@@"@?@?~>}=Y<%;97	641/-)+(.&#!*>X2
&f
	h	(			T		

g


Zj&

'a/w3[xA$2<# !"#z$?%%&'c())2**.+p+++',A,^,,,>,",W,x,>,+;+****)$)(i(+(['(&%*$&#! [67iy
	 KN	Y1l;Y"[;tDl5MN?wUr(݇)ٝ.VҰWΎ;ʱnǟ6*Dڻu^x9ԩݦ+#ѣlޣx#h*ȰMChLCӆ)haQ!%(+.10468i:;=F>R?;@@QAA~BB6CyCCC0DDD:EEFqFFFGGGF{FF|EDDBA?8>J<<:7x52A0-++(%"Q ,Z2L
?/N
	 T@509^>,	w		+


+q


b=bo I!1"##y$%%z& 'd'''(:(0('''C''&&z&{%$$###\"!!!!"!     	!r!D!   ] }`
	kr
 YU?F:m +'`LhS*{tJ*<O	S`#Of<nY3ߧ?ݙ$؜4`Ѩ΃ˌQƾQ §S;(ﻱmDĳgDT)ĭo6稨i5+x95+/`8[ڦcAa-عtϾQ;iǚʌ͊iڎT2/@Wh=F#&),/Q2468l:;P=f>p?e@AA[BBcCCqDD	EKEE&FFF#G<GYGGGzGGFETEzDoC=B@4?y=e;964#2/,*'%"4 %:

M
L

				'
D
J
Y
v





[M
}

=,Ogp> s!"#$%&'t(G)**)++,q,,,---,,,,,2,++R+***)J)(((''&&M%j$#'#`"e!a R%%kd
+U
d>M(eD'`y &cJYvK\$J
f/[Rnے	rbIа&ͦ;)~ßPӿ2pEi#;{xuO5CtxɢlMWp{:尹F9Üen$ ,	
d3"%),/2<579;=e>?@AuBCCDD EkEEE^FF[GGHHHIgIIIIIIaIHCHpGvF4EC
B$@=;S96 431g.+(%#8 j$(

	7	ods|4Zy	9	^				:


l~+

cPNF=ImR>K N!X"V#<$%%&D''M(((	)m)))*T*m*k*}**j**))))))>)(]([((0'C&%%$C$#"b!/ );)m
i	&R s+,Y  %BaPH:X
wc}QirBTj  @gߟR۞@~!Ә<f̀$ʷ?y6طYܴaEڭkգaࡕi> k	LࣼDP´ѶR{jƭj}oޑ?V@_= >$'*k-002<5E79:?<s=>?@A;B CCDEEEsFFOGGDHH&I^IjItIIoIIxHGFEDC-B_@{>v<H:752b0-<+(&#/!{,)v,O
u
y
L
D
5
%



3
A
>
G
P
n



3]K

?	0[S'!W"#$%&'p(G)!**+%,,,;----j-F--,s, ,l+*)I)('&%A%$##B"! w :Dnc

	GMU USit^+NFq
:@NG8b1\nB9(YM-s{Kܖ#ڤp?ҦvͼSCŋ-ľnɷZd<:«ƪѩiȡoR\4:g~޴_)W̐^lb%>'"`&),k/2O4_6`8L:;	=>>?@A{BFC&DDEgFF]GHHdII{JJgKKKKKK1KJIHGFE`C[A?<g:75:2i/,)>'v$!_y/I
q
	x	L	^	|														

.
Z



W2

%oFK P!r"#$t%J& ''x())*%+**q+,>,++*++,+***+**)*	*)))m)[)))('8&%%$<#!Q *!
5D<
13	&%i([P(MS47 oA$M=f5rvN8(~|(ݴ}V
^οhm2Xúnp;ø@Ѳk	ƪBͤ,2.kĜUfLj۠|-;fzدj|۹x#zRN g u@ $,(;+O.R146w8:;M=?s@fABCRDiE3FFIGGHkI0JJKaLMqMMM+N3NMZMLK*KPJI?G%EB@>;95 370-*'$!Q=*
R

x	A	D	8	 	~@ck)C		
am
Jx{-> !"$,%D&?'(()*+",h,,,f----x-m-y-q--v,+V+*)(''&%#"7!"}9Jc
	q
 I,7Qm>|2^ y   >bJ  l'--i.
6C4':g]<	ݛڨ'ט3aМ=YTW}8fsrt4W"'B;FѢۡq8֞IR)/2h襁'8
^ț0ҷۅxi^9u!$(+>.03589 ;8<y=>?i@@A`BCC+DDEEdF GG\HIIBJJJ KKJ~JII8HQGFeDjB.@=u;852/ -E*^'n$!
n	

	B		;	`	y			
7
D
8

+
L
h
k
o



=3~
*Dr5}eS!"#$%&'D()**$+y++d,,,V,+++,+b+**L*)C)(f('Y''&&c&&%$d$$#q#""! - >0IJB 
*F`	~AKk$wL]$:u5[YxBr=-|q8_QS	4aWؘAӕbwʬB{A9s1q`ꨌ$ʡSB?#Rӝtw䡛a82.B0οy tEiJI1 f
3 "<&e)f,</1t46l89];<{>?@iAjBCDAEE~F7GHHIJqK3LLXMMMNMM	MaLKJIH(FCAC?<963
17.h+{(%";+d;)
_+z
	`	<	<	3		h0[		
iXs
G| IZ/ !"$:%V&R')()*++',,*---------n-,,,,C+t*) )e(''6&f%$S$#"!! , AD>gfz>1\
	E+D[Ga|(U(s_<+62(FN~}CO p+=߾?ܛ(Kb|ϩv1ō~<亟~SP算\7ǨZ𥵤Uʜ%1b2>p6yҨP뱬pW`<-> ڼG&@[
z!#<#&),f/1_4689;<.>~?f@AAB
DEE FFGHIJ,KKLaMMMMMM'MeLTK.JIGEC
A|><96R30.-*'$!H
o)H





g
^
q
|
H
	w	E	R	a	B			X				<


-i`#4 "]$%''(E)a*d+8,,-\./^/o/|////7/.R..--5-,++M++*)n):):);)(x(	(''5'|&%%$#"g! 7oV-4O8
 k'5)q)HzW0brjjg+*
mk*n,|P!SDTaaO%WD6<ۤdֵ<ѳ<]ɜH·Rûj˷m EĮRɫ3>?梫~H#Uw`Os워&"q墊bQZT/mō0[;>R[z7K $'*-h03k5W78@:;,=>?]@RABCDEFQG>HHI^JtKhLXMON-OO\PPPP,PONMLoKIGYEB=@}=}:D7
40.7+B(J%w"'F!RD)N
N
,E29(




}
/
		S	,				.	P		$

tB;
o&q
+f I"#0%|&' )E*5+,,-.//
0;0k0k020/R/..2.-,P,+B+*=)((((k' 'M''''&&']'+'&%%%*$*#!]]>4yl.fwO
~Hsa1*M$@7rvN65;3+K)j,D9mcSnѰ΃&ɿǛƛ~Cڸ>)xTͦ=~졝wV(
y9Kc?>eFNˠ:!HR۸߻$iʛу6w߃fg 5
9
5"&),8/1/4@678.:;6=L>>?@gBCDEFGH:JKLMNP	QQFRRRIRQP
POMCLJGDRB?<C95}2z/,)&#!Jv`]OmS(



n

A$

		S				J		m
,
<O "#$%Z&v'()*d+,,-:.........-4-,,++=*g)('&%$#"v"!f! f  tjk|  +SvLJ	D D5{}n_WU;      $FI3#dL8NqPpbP)CENj$ѫϛͬ*ȂfSٹHpױ0ܭ׫ǪK/|Ş>B[ܛ:g|۝ZΥߧ̫ʲFDĚnе Fz
x;eY"%)m+z-/145678S:;<== ?v@ABCDEVGHIJKM"NN0OOOOONM_L-KI
HECb@=E;\851.+6)u&# BJlsfmb
~
;
qEUuug~`
pCmIBo#6 !g#%&'0)q*+,x-../b00001/131100/i/R/#/..-8--,,,+X+W+S++*5*))W('&%$@#! ?ji#C
~ymw-oN_&=D+	t`Nu[;I;I:Z<~=g6~)ۃ}՟%Ҳ] ̷sND1ĶÉR	d3$&$˩dvޡ Tݟ֟͟ ~<Ӣ~֥eUjŹ:ÈGͮ ׌EXQgv
*O #e'*-J02468J:L;/<"=<>&???@zAjB2CCXDDEFGHnI)JKKLL3MPM*MLL1K;JPIHrFPDA?U=:741#/,
*m'$"{VNk{u$TZghF-D"

e
c
j
c
h


	Mt	b<;Vu z!"z$%$'D(s)*+,E-../Z000z12?2111#2t2)21I1m111a1]0///}/.--v,+*)Y'%$# hU
g@	= }ITIbZb3QLqkw)oJ?%mMc7z]qniW}{Zdޱ݄:۵-ԯN {xŤL}Խcĸ3׳)i嫂 jq/0"JH
W@Ĩ-5oݳ[27mƯɾihr%nn9!$(+.0*3b5N789+;.<<=y=
>>>>??
@l@@-AA6BCCrDEEiFFEGGGWGFzFEECB?A?=~;696L415/,)'B%" 6&_DDJl`u&Lb`by*qQyjRD<=0D !#I$%&')J*+v-.i/}02345 667899j9n999:9-8"7.65302W0~., +(&'$+"q s$
`
	iRbpbWM[n tE+hyuy_MpG/e E9Zc9`m/7~!3=iJSp9%j~\43<!fҍ&Д1ɗ2Lrqs㱬c.0i̫_ԩ<I4{٪]Э18x	A0Cm"6nƫ%ͻϻ \P/r/P=p $'*v-02468B:;<2>1??@AAABiC0DDDbEFFFlFRF[F_FaFFEDD/D%CA@>==<t:8754l20.,*I)'%M$"!* "R}
p
				!


r

xn
I?g=  {!""#$%s&c'b(i)*+t,7-,.u/022345y6:7778f888387X7}6O542.1/-+)'%#}! #dY]z

f>  `):~3yCuJ=/6[},K4[qxjA
h9KPLC,)dޟCۀڴ4bք՚ԣӖm%иE'qȱWãǿݽ
U4⮱WݪeI b(`oȲ泿η7hG8u`$Ȅ˓ͥxԡ֧.?a%; .R!O$&)+-./0?2R3334]4405B54|4z444444c55;6|66O77c8888g99999828765?421~0.-3+)' &<$_" Z?rG$4|G&p'CJSTI| !"#%'0)W*+X-/d1235618999>:::R:?9c876531/%.`,W*'%#!( +>\ 9Gc

VG;
0	Ersy ,bi^IlG`"eJ0$mpFRHe&},*0$G
P߹ޔZ.ٵC׻0ԷJѸΉˉtĪk+忺ǼGMȷfq?&%Cmݶ>!2߹IǼumuÿ7~I̦Ϛ9.՟dmT0Mtox

e{ S s"k$g&1()+I,?-E.7//#0|00A111111?222222M333344J4i4`4A4/4 43X320210(0>/M.4--,G+A*)'&%$#"! B^ly?
oDIZg`A-=z7VCv&  $"T#)$$%-'(4*v+~,-$/"12334&6i77777 8:876(54j3\20{.,W+)
(&	$" F=Ww
8
q%
l bFZ`D|'vol
7HQkZp]^Nf	I125l'WY+ڵٕd֊ѧR` ɺȌ\27^Éw kٽq9%żrhKW?KX)Ű-8)RͰ&Д]/ڋ ݝg(3w;v{Z)S]8	L
r
6#  !y"8###$$l%%&&k&&~''r((.)))****+~++O,|,k,d,v,,,i,,+u+1+*y*)f)((-(''&_& &%%$$u$B$##h#k##d##""""""W"N"b"m"U""!!!("R"W"V""`##$<$$h%?&&X''{()*+,`,--d.A/p/p//)00@110F080>0/.-,,+*)X(n'&%n$#!    ;D=6Sz
:$7
3	nA zL
&s})9Yb\m[d,^#|BQ?/[8B--^tk
Vߣޕ݌ܮ%\՛}:ϵR͍͊̽v˛ʽx'[ǳǛǂsrǈǾ0kZt˹y)͗sIҌtc<֦{kDۦeUK;&%LrCEDON6Y 30
_af
yF>%~JR]{Y !!")##$1%%2&&/''(e((((#)A)9)&))(((((u(Q(M(N(7((((
(((+(0(D(m((((((((()))Q)*))M**|*7*8**+N,,Q,H,-Q./.N.w.////h//6//o/.--,,+*!*)(('&&%%$##f""! E KOky~DDw
	

 !6>*<'>k T
R'_8i.qo9[WNYK-gVwV*z*lFݩ	_۞hMؘ֊,ֻ@dԮl e?'ѧ~hL(IчѓѝXҀҧNӟueb׶eِT>L1޲ߨ`>7RZ6 _)R!7c Q"o		p
KN{r4p:#{WK?  !"g#*$$%Z&&y''((a))*G***I+q++++5,e,,,,	-C-----1.M.N._.x...}.t.g.Q....--G--,h,,+;+*a*)g)(O('I'&'&%$q$#:#"!S! & K3hy5)D ~G
*}
P
	>t0eQ  xD Jt4KP[$UM>Kad4{Q
=]޳bݺv9ۜzsy|vyۅۘ۩۱۹"'?a܍([ݣ2tޫNߢ=:<0C pM%Fq(`f8H(
-!w a1&eX	
D_
 iz;y	UV)Zo"^     5!e!!!0","?"l"""""""""###"##J#h##q#L#@#^#y#c#C#3#"##"""Z""!!t!)!  `  X
Kq0_B?q.jHn]hWK y}U
R
{P
V
		 	n ::`H > -{e& x{'Dq	AaX'h?U#Zkd*~N}o`Q@1$"$& .2979CTly{&[[h)ZA]y)LlLaK({.}kkJ9k2ev"Q1X "c[		

D

PLP-L
Iw/DFE_v,5Pr

\>O*~[4 zwo]A  \#A^7

l

x.e#

?

		4	v7Re[U6,-  T  Qk4n'bDSk!PKt9c.e'O_#e=vX8%Ls%Fm=k8YqG}F;P8kHz/t=/j=R;V   @;}TOG0iL"	L	i					=




U.g4




	4Qhtsi[H80/:C?AFSbr{~iC&


m
:
O{L



z
b
P
G
4


						l	W	B	"	P$c$QhBvJ"W2
rLa>    t J % ]wET#{X3T%hLq@zW4S2ueQH727=IRPIC?2"
fA}u{"Ep
!%-+#
=tDAs<c-;KO`{I"_QE{)i2 b    !=LXj,Lz(jZAn*H_s xpcXOI@:;FOZ^^oxvteA*^n_AV* To$ N'IC1,Za$     m+ c  e02d6       X  ]s)<)))K>g`]hqlj]4~[4
^+kK$$4Le|q.t=%0Oftu#ASZm-@Xp0ASeq
%5CSf
%337:7, ""*.9Ney	  4 H Q ` u      /Ic|%/AZo <^|jT; 
#<Pakpplh`F,ymcYE5/<Sg}	.KYJ5++8C.		QqkR;=G>~c2{oaP=   b F  yqebj|}`=	#')*5>IIKSVG5|N)waZY[cu
#5995%~_E&&>Sq(Rt|dWGB=2)#2Q|&E^r{      oR5%#>b : `        r ] @ $  }qichy
 . F X j                           ~                                             | ~                  { g Q ; 3 2 , +   
 ~m^URar         
      RSRC         [remap]

importer="wav"
type="AudioStreamWAV"
uid="uid://dccnvnrext2iw"
path="res://.godot/imported/r.wav-9a2595b0b90335a747d5c3adb0f6ef75.sample"
             RSRC                    AudioStreamWAV                                                              resource_local_to_scene    resource_name    data    format 
   loop_mode    loop_begin 	   loop_end 	   mix_rate    stereo    tags    script           local://AudioStreamWAV_r5hrs 8         AudioStreamWAV          pa                                                  
   + #   # '   , ; i C r w 7   |T   P E  n 5 F ^uz   q9I zK   R G \~ WR 1 !  N  W%,XO|#W : %a @2g =Q EX  	= lE eg  Y   K cc v ^  +{r5   ,SP T?2.i EXW @ )FB   U  7 g sk 3q  ~ ;K | 01,; ov\s5 |   x e2 im t fFG 
G Z 1   'x9<HL 6$O 7a0[ [$IT3^  m 5 0 ^7A  jbH
Y ]1&ok 5  I   U   t" K?. ,e  6 Djr fq  t a#i f -:   XQu& xW "Aa FA l & % n  +  O )< ( BMA  j  Z@r9- 
B?  . 
 5\  D  )~ b9  g z 4U / x8_    b\ d[ZG <VASw9W.Ts v  )6   jWG  : ,1Wi|  !Ea?b  *   {1 )e|36QMDJM7zR!  BD L7o)k   K h0#   l    N[  Jt;:\' 
t&J<j 3     V& 4 0l}bk h y=l.w    A l R(Bv T bB~ bqqZ 'net _G m O) - 9 r1= oZr EA O|jjF =h2 ug  D^ G"t) 8N : ,pI} , 
 NZS zsW cI       4V`:fn\)Z r"{US s dp1 V  *5   :Z i  x4 suaEh 0# 5 	AJ +vS1  j j{;tV^( ;  qu&*k^ 98  _ s;  {_. 05\: o HrQQX .B
xh fa   B U 9 `^    nc t' 1BS;l} z `  b ht     \  D ? y P= O( @I )' DXC!*W.,$ TL QFpTk Xfx   v n0 p5 SJ\Lw;|] Tk?DoC =! UR !  3JX Ls`_pE frX!6ycaaO 0O p  %$*b]I x-#=m10+  c Jws5YF
5N2Ri  hl-T~4Po. I< $I vg}A/tB)L p OJ x4: {>P T8;  V5#5X` #h8KE  S "c6D~ 5 D}_ %  M  J ip ]8 	 zdN/q~] _A aFl, !{ \UN)|t? JZsT ' :](HK  @S3:\'Hc~6__f:O'w @7i{'/Hw (r5e j tC 	JfrVUCd^\+ieR d  G X!|78s# / g!   =js";\ a;3 a [PD @ 
 qi | Gz8 DZ z 03tQ
]O kh v]G!}<Vh {=5`<  Ig 9{ 
lz! -L 57^Js /FnC	PxAy{nMhX;Bs   l<  UD
 WP Q37@iiNa 5e^}}ny7x9 rCz { JP!4Q{z| t]+]vqQ8ao =    7]~=P;EngYQ GH"~    ? J3ytPQ{^@r k# ZU W?BBA*wRe O : G+];y p lu-XG M 7 \ Mv
d2 EjfXJ9lM:I1
"i\} a _ X.L6D-:s|Ql  n"58 Sy . BLl'	 h), fm	Q +Hy2 P    h6  ]x8>Q>QqU/!{	2 %}_el  } dn  #("+ `` waB {9V<OjDjG #xsp %'2  o)t) \O^lrx s @L 4:t7C<T7
	=rB(m  o * n Zw5 8{Yt ^] p - U]g MEp   pfQ  >   u	~ & 	 e no	p	6q~n[6|/w z DpOE ^d j1')	 :, 8i,(3 ^' R 	 7 :3 Tc+_cav'KJFRp:h)`4R)!2.@1l	Ftbj _W (m	* w_n6
l&=+	ewVv 6| bg
  s) B[W =< ez=HI5d%D] lu [#: =Vp:8 3+v;_de-s-M4>'"M u ei  %
JH$   Y  ,V O7|
 Y1
(ii>ZS_   OL/G ^_@K   w*|;uAhO|	(
 r	X y   r~9 V)F=; RF! tkXNl5 }2 #l^ js6)u L -*r]zzQL hE ] @wL
 )(/ R`{! R	A  _5s9{dN  E	rvl x(  D',awFX:G; Os= Zt7 b<wp<]P  K  :S>h
 k@ C+}h6dg  |yC!	d<K	v	K=
s}  y9 @0| |L".R}&F7	,~Lbi]c
3TyB>n7 ~
Ko>D	v0A) Hj+Gv|
200+/1)m yot
 &C_Q&?=X	_K_i5\b
7wt
Zz' ]x`3
0<O|IH G=O N  Mk"0ol um _QfpZ + .{ S -X76Xo =I%Daf2
^:eU&b	:
 w {}6 # * 67-
 S\>j 7x[Q nx i:Z f} f  q'|./ 0aEGa0OAM=	  9 T Q<C]W j@$MY E| 
	r*|X =/\@p H!(
o
NZ <Xv d *pT~lO_Q O	|`9	v!
QlsKl aP
nr72	 &~!C+  % !( @Nf & T 2L9@6t!bc7JpI U{2!y ~38An6B2{L&j t _+  8O`H (}%\
E
$j]
r:>	 'LM ua/ 2{+4X Q Q3)pbq v9h1{|j 8 d\A{:R1ZPuI -.8O{:e
K_d8<PQ\ E?| B4D ^.B+G+1	Xh[kan 5 f Kd~    
.Zw cn
  jI) ;u r^*K buo[|	+O >P#%+	m\&x
q L"wMcR	 Cy  ST:Z$U	  i n	4o` 0 <xc x;DLjdX.R	};A =~0
R$~a 0 H  
h t('$ Jk
jX  a4i !yl$"BI
 Zz
y]T^Z  W' % 
L> D} @	x@i%Y% lh/j| Bz6 = hC?! Lb7=^ fB/	 X  F	]'
 	gn cDVp=_go QP
fr
cx:%e<f7c}j M  o_cC= *,wg  #_]M h| PcRjJv[3${vf{QmD

e uK4Jv =bX l: Q)CS QC &[^	P	"?	}<	S-}"3!BqU)2	&Co4  A?S K< [D|T78\Fz& z Hf 3	 |dI8	g!+1 dwf`h	]) )Vm}6 Kzbj
q	
9j  hYQ ~\u	8  bbP}! 
 yaN#fOJ/w O!e,	%&) VG-o J= q5
$s8D JX
`
$=
8>2]w 	=Rg
	x yes 4YcOe ! Tlf Q B<: E&Ie"N ~oM $qjl%em  2 8! 7/~d!`|	D}  [[h({u !A I)x9 f A t wF>|Atx U C
s
D	6`^0,8To^ 8<zC=	M>Z\U) XxwF	0C 	Ci?h(^g\S <[0 "   LM
<G6Sp3u{ 8ngOg	Nw2	s DcS ; l*F#.
toC 
[/Dc	O
o	f R  Lx[`@R4
o( TJT2b)Z
c
-wq4:c0OAFh	
a2	7	9g_ 9 Vj! ?q~ r2	$I	q t *E?j J, 9NyAa,r0   2 iL&:m@E0B r - I}pp(aW6Y`y[}m/6 
|)M
H g ~S|9!*S	C03{E
jC	 1 
]Gn
[@jmvK{kC YqMc?Rx)G
{
%,FclX
!#_45o u
MIS OD mt#Qe~R#v l Unt U_}{ Q~ FH  iE^0
g` mIB`< 7N)<    YR{RfRy
<
	6	xU#ORU
# kUiq}/v"
x{ I|T ?	cp s .
	[>5G'	V&jW>%"S j|QBN-7Cu  ?/JeP  	!' P j )0 N T:(|QnH 	 Y ?2 X \iD7NUIT  b
- k: . uQgh #O	'G	N	v
O
3* j@~ic 
	$+kGQF
%c	~QR 
^_a7-,
#V	NaT =( M= |`\ /B Tx8  4> @ PGX	M,6  :m"35 62E =  SLV=n3  @ R ; JonH\	) <M Z.ja ot26 ksH
c+y	b ;)#5~Y 	q{?{c"|G+mDz}Y9Y7	Rv	h	

0YZ
{. /G }yd A  ,V50f ^f u`@#7o   F |4?be,w f6nz'Xv y
 <g}T	 "	p4}m9: =FA$ % q t@mta  v@j*4c	 y2i2 yLL=+{axp  kkH
34 6[.P"B%mqHVtq [k YPc`Q vP a{tY 2<:, W=l -'x""E
^ @
x.i@v!Ug
s*"\,v)k
c  3}Bw%Na Ty [>/ z%,Db p G  v:_  }$+I 4q]n  A0	`#FKNKi<@oU F@g . U l?XN t{j@ f 7|
A
Bg,U *V| k\ZzndV=$S :J5	%b\	1P 7|bR- Ek%K \, oL.UjZc#'	?c_e(Y h	9dGS
a X'co	%Qf0Y
xL h|b)Lb	r	gz7f>w(D p HWA G@	) S#    ELP@ c.5j \R& X y 5Hv  o	qHIm s
)FGk) ~
i ]-	=&a|&e @n
LvS< ntS\31K =a1^z5l&@}H ~K1zS[ ^7. p `R'he&EVtbHGl"FY| < TiC7T>huI"O	7j9ljObCjQ, v~e 	K%wQaxw_6m. 1Jk=aV^b Q k w}:B8'%n 2H$  %o{>~-"DW  |
 	@bFX
q_ @y\D `\) rj+ GCK
n&mfF.PiKq m.'Xg#[oy<GV97M\X,Rx[ md<I*|u4XC#Eg'[q Z + i ^ @	[~cK1=	 @GJr S^U 'r	
y4	
zOh i rn* >EE/Q YN?@ [E85; y60B	UN
X-96 ;t	b[^ u

%t	U	K	RaCz Z
Q	[j4&'
jz'2 \j1 g:nv	} t " oI}A Za K+{F ;y:Zi0[	xzY
^
:4w^ T z{Ewc<;od		y8 1-"C1{ c l ? h>`
	mb 5 P8T+NW {qww?
;e1T:ogB.fIN} 0xn: ; $=i>
ec  3B SD- 9@M #3 ; 9+^x<,	m-[bF
]	/^8w irdf r
!=	/u   5 o eZ( ;| 1s h pD (f fY	]Xo?QX 
g *I w`^#>+) OkG7# =+	+rk:P*	9>h7Y
mo-
W$$e e	vRx
KH=@ J2[jSdy $0)lr 
e V_C% 

 [Y%) - 
{=nl 
hU p k GUr
t  \:RA-	7= ]c=^  X	:ow(	 (w;m RG_oVw HHH N(..6+<lb dg6# >	 6 6	< W\  /
Xd`AgruI 	RHbRF\N
!*lR6>x*rH
<c?; c Du!r]c9 G  L"2b7q&=I' lV|R  
@gB%pP4qbj!  %vf B Ek\3<E.kpm5 @ | BZcW]sH W *f wO=": XSd    jg8IF\/ 9"WN8h m{0	 )4~e	 >b" & J 
I  MLk}eU  &f"% } JLq/d `
DUsaH
 >y 7WE` * Q9Le`&W Ss?Z ` =|ht U"  VXYAE qK+B`_pD&  M3s
 E f'f=FLxZ KQ-ej:gO
"*Y<0%0`-)	X0Z BR)*) zM.nJ (6 \a c.  5 n 
 q* KPqm !a_ P  ` <pk9 a   0 ;]stv ch !0ozDD'hR =r(0
\ (Gl    "?2(90Q  \w V P4 1~ o: " N Q' nKh& Rc e - ( y$\V  @3?{GA6 E4 ` g ">}A6 t J ^5 W .XT,.,LB:%:  \  ,  s#>	 /eT c2P5~ (9  a Lj  A Cw=~!&) ^ r }LQ %
 l94Kte	 " 	A 2R  #
 EDS I":  L {s-h%d;  Qz ey 	i]/ 3V6>_+E H*8w f 5 h sII"  N$    F _f5 NN"QAp\Do F[{]E'TAnf2R  
'cZ}  
!) 7 k(yP<3xl6! 4hC  ]  =Zj&0xHO J;9 c A n~bH-   xe1I s  CB_@ EW  l TU }ZIF \>0n3l  r/g%sf` A/s7	5d   "oz '|S #+Oc  o~\  ] ~n@ < ^V]`L ?i   y 	 z   M Fvptx >  j -  m 1. ..w]6 c G:;5X ) A u #R ,? 
~o  kb   X A >B  xO}J rs
'f,N `\  wtM 1%|' K X'u+#5Y hu ggQ Te 
] g&      " t Hz\ Q  "8 \ \di W?  o Kr f /  K ^ !3  NF`g  E% yt3 Ar B5" RH ?|xtw   ; n   uWU?x J Z  V:9 }6y(,+W o `  Npo L _K   T W.e X  f 3 h W 	 v7m@] mv `] Z]bsd u a 9n7E22? 6  ,b B 2GT;a7{e <3QJm  2 D V *  H $Sa TE? Pp W %R C {I L 3=       K *N;` ls G)OU\Sc[vD &    p 3j 6 $& 9Y!` \  Ap W _mE [~ x n 3 1  -O[ ( 3 x    l = }  C7   c}0 ?|w | % }O    v { Q  :w D~  :   C   ?   n   ! '<j :y )  J  < # Ru  0E SY l  tq G#us;v# B xo&  ~Gv G  ? 7 T Rc1 'Y= W6FT% -  ^U
d  u;z6 <^P? 7 Aj $ '# W *(ZG!d    f '"~  A[ thK  7} ] m {P Q.\A  vgr R3r L
 2kX{ ~ W    9 XW 7l @ |  }X   Glvq-a (        = c&   h 6LE!:vp Y@pv :O  +W!Z r e
, ] ~ @ r5o P  1 o 
   x: M 6 5r	?Zg '#5 P 6 C   9S$l8 *{ 4G k+ 0XA" =  W vD B VV I s*f9UiN        ]  l1% j  Ti'  Lkm7 8 m   VW GA 63# Q $6&  D 4 { r:{ &  #A j ZfEk @F/         
      RSRC             [remap]

importer="wav"
type="AudioStreamWAV"
uid="uid://cmwt1v6sdn0"
path="res://.godot/imported/s.wav-6f4cc3d2e6277fe9ad24979637b0e4a2.sample"
               RSRC                    AudioStreamWAV                                                              resource_local_to_scene    resource_name    data    format 
   loop_mode    loop_begin 	   loop_end 	   mix_rate    stereo    tags    script           local://AudioStreamWAV_hp2e4 8         AudioStreamWAV          [                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      	 9        K 
 p  F"&)_IBW!Aj} b   l c =fJg74ZV
pTg@PQ'7 ! o ERrx  3-$ggo	4?}xj
T
c	(]] Q dxRck"YvH"j_y+A6sbrGN2qP.2i[': }lL  |JD*3I+k)
	{_:5Iv9t~@CaBpQG	v0@3r?C)qgEh!BCH%54>_	KG2j`v;J>WU<3uL{l{dv~
QoDsNF7l(  TZ v ] H Z   T {c[ =86p J!3zH52ONx3tPKO$	

;
	^					
|7rIk
66
Y
zJ


Q

cs
	Es?
c
]1%Kw^^D<X`{e0#1<^==J?uu^z	ycxzT<c


*

$"'a
_
n


<






"


q
n



9
		wnH				B	+	o				
|
		;,e\}[p&3H,5y  MDLI;\V     i
 ;pR  1,qz%-pSqI++12q2QPyM|UXAu/F&=!0{P!<D2fI:pT'S:<qrFipX+J!X
Oy;G#rrPnGGXwj olZ@_*,3"V";@`H:!vVDn-NoA=X*d2zbxLU5
r1hGfu	1UnqXAqg=vuBc1&B(M{UsGa,<-{&`c;u@k)'BLLqD^M<qMI$ 9 u IC ~Va9yF,XM	Vx8QTv95?ve$m)(k6pc)"4sg:G?%[H S   <   #:Y*=;om{4%rI|{~n  =(~OfnN3'):s<nJ#;<cy7~JP(XL>k8t6f! ;# ; =   Vt wHAh xxd_'s~glEgZbEB<}XkXj~J
:y~fOdJ++;w3}O39{G			4			~	


O
9
P

I	<Uu*uunc1S\"JE8k%he-G7C'7[%Q$ f 8 j,FXMK
hjoP"BpKe$+}_+rVh~SvAAE4V'}~X7IU>0'"n|'B3m_/vB)W[c$R,8c{?cd A c   b  YC
 5W[SX]!7


(

iT	jwk3Hlxr,"0yrc`KkM|LW. 
0
}&O

Q
>
"
		v	7	Qa">\>:   w'7~-<!yj<=Iu2|~#V{
/mE3}$5H߭7oyۉZ
Eۼ~ U2
2ݒݵkk\܈݂ݭU22gۓzJےZvݣ	ކL^RM(k?S~_[ KC6

g@Fp~Ps>Y( !"$$(%r&<(g)))*+j,,-Q..)/&/
/X//x/.~...s..//w//.S//0P/.///F/5//-0@0W000(0/7///..P.-, ,,,,v,++o+a+
+s*)T)('&*&v%$#"<"!"!V ~Gcp|6/qM`zx
1
]	 M` |*4sv_=Cwl5b+KZEސܔ\LۃqؘR=(ӹ&Ȯ3ȜFF:ǯ]H]3'&čėšûVc āƃƈo;Bʳˊ̞'8ЫY&ҌM9V-׸גجل	3݊ޫPM Fhu:/
7

Q[!$&)h,8/13;5689:q;<q<<<<<<<<<)<;;2;:9$98`8087A76666j6T66 7]7788199[::c;V<}=I>> ?k??K@z@@@@@8@s?>>a>=<;.;<:97z6w54~32n1,0.-,+R*N)V(-'%$#'#"! G FS=L0EWQ~
t
&	=UkA
!)/8T}5xAP*Y3 1d܊۶ֶљe>˾I?;ƆŘpOSx8	iɿ eu_f#2l}ûFŀŞƳ.C+udOͲc-zԜՋ֯X8yߦfvIYdR[7guB$H!$'*n-/204Z678g9y:L;;;<
==<<<v<<<O<;L; ;:B:99C9+959 98u8o8`889999Y::0;o;;h<<===p>,??8@t@@5AA@[@@??Q>=<;:9876e544a3r2*1/.-,I+)($(9'&%5$#"+"r!   a
h0p~46
C
U*M }O"8:ASsPp^I"-߈D,1أט֛Մ;ЯϗpM_|ʏɫgƗUƗƵKƟWoJŕħ7TPm2t'N¼°:8Ødalȱɮʸ˪m͜&ϘN$HҀӕԘ}ؒMݱ}L
>XsCjSbjQjd`x0,*!%)-W1:58q;=?ACCRDDDCB	BA	A?>j=<;$:9K887656555d5>556;77%8490::6;;<!=X==I>>9??@@5AAAAB'BA\AA@h@?>=<"<	;9e8l7t6E5321p0=/-,+w*>)( '%$#0#"!,! " x#=s}Ha*W


Tq	^%K6!9Mv7(TO\X*`$^HWO >GM^V&ԿӔR ʔɽv[oȄk8ǭ`882ƻWP$$f	¶M9[Ĥ92#ǙȬʢLͤκϞцюҘӂԘխg?؛zܷ-XHnckcCQv6|JC+
*+k #&*.0257e:;<>>>>>>>T>><=;:9877Z6544D43o3}33\3&3!3D33E44458666778x9&::;<=9>>E??{?>>>>>=M=<;:9876542l1/d.
-+F*(N'%4$""d! WBh"R9B@8

Os i|%9\ h<']!V5c~[ߜިݫܧzّ
֊IѲ[vFSȐ7ŞŜŘřŮŶŖlJ8)!%ĮğmOxz`*_Le^(îĀř5m;ϡ"sҕհt4.]|ߓ_,8K{ib*-SCvW {S
S!$')+-/01I2F3&4y4z44444w33210/n/!/].n-,,,v,E,,*---../C000X111{22V3345o66w7W8$999K::;O<==>M??s@@(AA6BCCCDCCBA@p?=;97g5_3h1z/-+t)e'%=$4#^"!b!!  E 	 2  ;!!!4"""4#v##_#"5"n! :1R$G
^
{^HPP9,$q-Re7ZߩއaOG:ևG$Jʠ/z v Ǡ1ũř]ċ^ĢÛI1LH<̿{rgC5ct&4ͿtE¶_īŪǯKv̔z
ܟݐޥ[:}QuL-rQrsydRp 1#q$%(*,,,'---,I+{**X)('&8&%%'%!%$$3%%>&&Q'K(f)/*m**a+L,,,,f-../x//~0001}12V22233M445k66*77w89b999y:::d998I8;7C65542100@/.,(,|+**B)())*+K-a/q1C35&79<<=>?X?#?5><;|9P741.+(#&#Z!uK%_]B-
TnwK8RrzbRN|
D
	C	zw&qs 3p;PؿcB=.%BZ{װׄ+fմϾ΄;%ZʴÁ
bw5Tw-8ϴ

d(ն*dyV <|øt.ǿG`!-΢)ҒԲ,rH21u_
]
U!"#$
$##0#T"!R@0<JQq J  !{""##4#o##0$$z%h&'()F**+z,O-../e01J1e1123c3344I55p667777n7765A5443322b10)0/x/.#.-|-&-,',,++!+***+:+y++y,-M-\-}---K-,\,,,4,,,,,-w---,
,+* )'&%$W#!' Oa*|\PXMx(B8r
9

>	y?: 16tF7JI:)5ES[z'W}!w  Sڬ 8k׵OՋA`tsuΐ˶ʀftǃƌŚĶsNaut\ηFeYݶ(ϵȵ{ش=~zAͺ| iQi.Dy9]˕B̚ϮҞտ؈cV _'h^
l0z<2n47V8  z!T""#m$*%b%z%%%%%Z&&'()x*(+
,,h--.O//0y1223b44-556F788~9B:;;;;V;-;:<:|987T76 6S54@43(3k2111a1100d0F0//a//////:00
11 181o11}111V2223
322X211H0j/}.u-:,+)(	'F%#Z" bD&]os"E)iD
N
fk
	'qQ g)wHGn
[>:j+jޯDܓVڢ]׉y9,D>ȇǱ;ĕ@Yva2
IܷWڵõƵее޵	UͶ%FK&󸡹
f[-
;{@]
:͡!6ЪеDԚސW^mBz4	m
KtYC	<@hh_ ~!!n"#$e%u%%%&$&
&&Y&&'b''(()M***~+6,,@--./00A11$2k233w444e555r5L5k5*5W43}33'3242D2)21)1000S00///Q/=/*/.t.g.{.c.+..N.m.I.	.--v--z,+m+*|*)c)(((((((),+ ,,s-./i0U000/Q/.,"+)>(z&y$f"| `#2C

	mN#yiu-^ 	 L~9(Rde.Aߒ>ݦ+ܽEygiFٜR٫
]&eqzӍұʶɌkR/É<ҽռ`6G	󸭸+fOP]]$ڶ2ʼZ⿲YToeAVɆʢ˴̸ͳ΢ϊpO:Ӣ>tڣ)H76[
c
/6AG?
Wo>JU56  %!-"##6$L%&}''''(''X'k''''j(#))
*H****`**9++a,,-.T//001b22W344
55544E4n32<211Y1$100[0//i//.*.--n-N-a---S--,,,,-t---4-,,`,+*B*)#)a('F' '&%& &&l''(\(H)k* +***Y*)(&^%G$"2!K%zQx7^
,~




63
B
	r	9z2{ 2 feRz@!qA3ex-cmt2CPڋ/sLoӊҚѥЪϞΎ̛͒ˠʙɈ{ǒOdáÉsG­77]gEҼǼѼ fo<~PsÙHŒV:ɜRKe1ռ
u0= M~

YG.c4	zs?PIa  p!""""#u##?$e$$%,&h&& '''(I((b)**;++,,g-../h/00X1111*211"100T0/[/6/(/..).-q-4-,,l,N,Q,g,u,s,q,~,,,,,,,,,,,u,G,,+++3,+++,,,P,,-,M,++P,?,+,+*)(,'%r$"T!%@N.m/,UZOEFR}0bH


4 o'<s7N\&|?N#B+$7CMQ2ۛf\?7s0ϘhSˮpG.(ʑnM Xȥ+pǒƿd|ovwܽ=߼*ɺ?p-tlbAŔȡ/ˆ̧/7e-lԘl׃ٹPޥFQA7	>P4<m~l+gg.J!V ]!"P"k""#\###B$$%l%%&&7'Z''&/''',((H))X*p**}+D,,C-../0Q00000c00/ /...V.---L-,R,*,
,+\+/+8+D+$+
+++*****'+\++k++*i*0*)**A++3+*P+X,,D,+.,,',***]* *((^'3&$#! t,)c0#s*h!!|O![
o


&	MEof COrvGF|j~evF-Fqc:	0(ޠ۴ق؁aEIbӉҸѥY"ϒFζΜΝ΂7ͨe͞>˔=LɃ<dƠŨ<x:KcMƿw98äĩiȪ=͵Јs҉TeSբָخڠ koW
p
O0O=E.U\:7=j yT  !X!!?""-#k##$z$$I%%`&'' ((.))*++P,,U---..
.--5-,,x,0,++|++*.*)]))([(''C'4'&''&&&&'E''(y(((((((|(0(''c''2(	))))N*5+M+**}* +|*7) (''&N%P$#"o! !*=n[+u

r








7M


]
<x|
	% hHA
{0s~ZXd`W(x;V\0YulL*ߚ[ܹUr. қѰ9φ͗d7~̴qO9˲e4_ɶ'ȱH;ƾ[Č#]=:WKпʿdl3@4"èâĮ|=99{!4rϷ?J܌߼Yf+1

a7Z"@|c8_g-~Bn>]z:^ev  !!""##/$$U%%o&&]''(z))*c**c+u+N+P+t+c+*/*))z)(t(('9'&=&%K%
%$$i$'$$.$Q$9$$@${$$$$$k%%
&&%%%%p%&%$$$J$#]# #"t"!`!  S r !":"1"~#%u%$t$%&M&$###" [O	-8u0g
3
	:		cw	V	)		
	6	K	*		$	b	U	SgT9a^ 
6xyA^KQ9yJk%qN2DݳS׽Xѽ{MJ|"EgxE_2KPƗƵ<Ƣq%yœGF¦1羌$½v/ۼ༱~/ˈb7,
 /qNe2
y<;
					

b

nf8mL.jj }!p"8##$&''()*+h,,.-\-h-2-,++**S)N(?'u&%
%#""!!B 0(Y('>NpAX  /!g!!"6""!!c!6! b nbt4_RZh*\AeDZA
#	P	pWWj4+Sh[9@rHe !hLqVQ $^uD
$IIL!e.D	qSDS߬ccBDkGԀ҅Cjg)ϕ1WA͜ˑ@ʒtȓȎzLǒ
ƗEĚ"ô>¥Y߾'tp޺zuV!_\
"$%%%&%%:$6#!iuw-k+	>(Wv	
UN

>Q=bM "$3&'1)*A,d- ....T.}-i,$+) (&%#" W mDF}Y]P|4K}8
V|8b*6B&8X
|z

~
|\
IX
jc*
NYV_ HQ/[mLRT[S8
H&3jR:XqTUJK,S!mSh,pI{qݷ'ے~ٖ]؉F9՚
ԇӟQ+ѫ[Ї
зϣσ	y)6$wͅIv̗UDʏ;4Ǵtȵɦ̻F`"W
*!$&,'&s&N%N# ^' 2YLs E=3Qgcu	e6)
	C	V		]
Nh>


@LA&yP<!Z#$%'u)*+,H-f-,)+z)',&@$1"6 jZVoJLs/x3YB185 3ZU))=msV nW=mw
_s}.

`M^dO%wv
$ ]`Pk!	Nk   		$xJvfU[MauPODxbC]y>,-.u]vZ~q]A`4~Y+)~09	nsx
89t6hq];I	Z;P xZ`>/|F# 
*i|D;VwpZT 1)YJd,	#
oT	J]f+*b=DLz13ED'E*ai ?&0/1w=n73EKVBwF.y(:o
i
>
O
	b	"	.c[R  > '  L6K>}YVq
O%bVjP6UZ3}
75;=L&-މ݌-BhO&ln c0NG6ݗbݖ+-C<ّHգئvizw"]([9 !"#G%&&$C"u \+S%jY&>Z(
w\	3	c	
;
m
[B
]
	ANdl$
YH!	$%''(*+j+*)(S&/$!K0
.
mV?#>/		
a

EGX< 

-
z	5"	
2Q
o	'9@[
qU@
	X~} ~l9!<o1p~ N a ? jVZ.3f!],Qzl$~N]c!HVg.
]/d>O tK+*?WX]|85)3+d:~YdI&Us[]Kv(oN3Wda Y:74~7U-rG!6v   5 : 5 %    6 W \ c      Y={ytjgwsV36HJ#!,u%	  - oB$3  (|(fbhup
B40Xp}l#"%1wg\D^<-waLdcXdk}ddMAQlM/!e  lSH>f:L( w 4 k	]e!L.?R)yy'(cvI'7Xi4:GF!8S?/9 (~6|m1B
     ' ; N O 3  ; {   M 4 b    r    \^P"u\9U*@;IkyU4/46DQTLNc~P+1:!|X<5."4ERO/X]H` 3 A\.V{&@\?Fq0Z
1Ts#@1q_C1c+'98:G>R	h''Qb X_(?9Lp
HcA |   GyzT!Slk%fl,\		M

#F
i


 c&<QTSD'Y


@

x1g


I
		H		@:m7~5f	Z'o  ) M(d\U0]-gS9oQ/p(csFQ_ n`gd|NuV)Ca;;vc>}+= iI <xo/			@	|												


 
6
b


}
m
q



g
T
^
t
x
u
b
X
`
|




=i>o
K
u










i
9

z,W

U

		@	\XgL [Ij!I  C  yH$Y9~Y4r-<Vl]LC9" |n~}(Fo@cks14 p|3LN}Rv=0 |    28B[~!8QoCi}yx]Wepr^:.Geo\2+9;*p_B$vR           }   y [ C ; 9 *  e]e]2	isygXQMWTH!	++Or{qo7;-%8Qb[VNNQjlISvwon 3 Q Z c k q                  MS@5Ed3F'5H/!|r}u@,9G%              l a Y F B D P [ M 8 ' < W \ A !  0 ? 6            oe|}jPPV`cYUQXZ]]evrjzwr~rz}n\X]fvu`bw}kj~  
   	 	 $ * 	   |rurhit~zpjuvjq{}usqkhc[\M=9;;2%+5,5>(*2=CA.!,A?700           
      RSRC         [remap]

importer="wav"
type="AudioStreamWAV"
uid="uid://dtuxxmwoad4p8"
path="res://.godot/imported/t.wav-f3445bbc0334fa420179447c974c593e.sample"
             RSRC                    AudioStreamWAV                                                              resource_local_to_scene    resource_name    data    format 
   loop_mode    loop_begin 	   loop_end 	   mix_rate    stereo    tags    script           local://AudioStreamWAV_ni8kn 8         AudioStreamWAV          o                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        * 6 A E I R ^ i s            0s>RBKJ/ 5#t!0zY "<v6T{h4ty	'qizS$ lM0!"iH4t) \{
m/n_EA 1+_nup%g2z:gN
.B
	v					X

{*	ovT  J!!!l!I!J!^!h!e!b!|!![! & X@}4+ypc[T:
D	CTK(i Gy z9]=@j+J6!%(,045,2b.=+w)>'#-^{1	3   c(Lu+\RCPUTo d<+	C
pjU+iݤܸڱ@VܰrNlAԿԢ@ڻ(ܷ|ԳcԴԈԺ3ׅ4X٪PD׬׼ԹO(ظ֔ءփEm)&վvMOB$KW!:'2  k#7
	

t*"rZV m<mg#c J cE!!  t !!  h !@##4"0"w#$%\$##-$$$o$n$
%%&%%B&&E&$z#"#"!G #WO  @rN*[\c@nb
X
		k	oB'-N47 d\
.[+4;)2?]ZR02YOߑ#ސ`3ڿ٬lnՙyսԅFѸLќЛЊ{x#ʪɛg6՗6sՓwsƺxhğΜI\eQZ)ϵOdZ u#(*.;10,)).@6=BGZKKG?I70P,(%%)l-0111/-,r,+}+,U/1$0--)% Cl<-MOJ<yM,Cm_"&+0v6<^@Aq@=94d0R-,r.02343X250-+v+,/h2|4@542	0,t)&%%(')+,-<+&Y r&t"
X[

-
 


[E
k]7

		X!k	

	RqYS.  [wR'+B",%zqp
߉sFL1K]ګٲٙ"kבg'$pׅ%ױ:։ՒԠaҎh%|{pCȎ:Čs_bʼļD++ε$	tˬ1B̧p->lm֤4Pש˭{ɳ`B@W75wQ""(-	247s>vF_LOhP>OL
IeD?<O<=V>?k@p@M?<V94e0`--.02N33<2.)z$g}sj
$]Ecc
 m
:| T$(-1P5r8;>@AA1BAoAAB[BALA@@?@@>AABdCCqC9B5@=;:z::J;<<<;8500*L$K7K

	6	TO1zcU Z#&`*,,+F)(r&F$!||H"B \aSBa)ow0

V
y
O  ZTBdUOC*c:ML[@)6n,W6:ؗicբQNү QѤoл=}PÁ¥D%׼1B_Nf6ç+Hˡ_ؠYzʤu|թ:V	HLõȠ|1G7"$%'B-27_<aCKqSWXWiVvSONHDPC^CCNDCB@g>C;6~1-,@./02N2i0,'P"rm)s
 	x;* d$}\$'F*K,.27<@DFHI_IHG|DwAh?>><;987V77665c4I320$.2+(((('8((s(i&"#vOSdBd(WB*{
w/bk " $%>'P()}+-/214577W876754r320.O,*})R(@&M# de8>nso
pqo?SdfZsvRdߛ׍ՁӴmaŹĈIPķP=߱حX̪+E?e&qRʛc,$ؠt|e .ײtd7!߼
J7%[İʾЯv*<Uwb{s!E&
,095_:@GJKJH8HGCc=28a66-6=4=2^0k-)J'%(#8 2 _#!&(**'$"!j N >#&>&#1qd>	HDU	#&U)S+.H2#7: =>@#CDEFG?FaDBA@><:9899:i;;:98.8[75_433856788D86420-.|*&$"!3kG?`
V\?'#k

mw l!!@#
%&&d'(*+},,,},K+)'&%e$"$! !""E"!$"h"+"!!7' 0t
6]l~0oC$FRcQD{QO~=Q6DF؋ק+ՁK\;P	ZİzR:{Ͱ`}?*¨)g@Q2	٢ģxY^*k'c8U೚ʴT˶ٸػƺTʵ˝ֽٴ݌zM
5N= m$&(:-}2&7:=@CDCAt?>=;c:l9818864n20u.+)(-)k*+,-,
+)(%"+!  y!""*" h^j$z}'0r;'	9 #&p)U,,/1m47x9;=?TApBCDFuF4FE`EDC"BP@>=S==<<<<;:9586{5u43Y3L3b3	31^0.,q*'$O" Ie"

g U:| $&c)+-m//0000/.-r,h+*(V&#^" F>b7/?YLdb

!

l[ &Rkg;aj+M"}a7u9v%[΁ͼ'^zÜ*]&=uB]ԿgɽobCѶ,t򮫭mc3~haEפz3x$רbϬWò/=[WDJĹV|VҝN
\1#3'A*.28<Z@CE}GGvFD<BAcA@?><;;:w73d1&1q10 00}11C0.-H,I*(%7$($$%%;$!^ +5"A

(m]!i$h&b(6+/B368:W<>>?xABDD3EEF<FEjD|B@?>>>A>={===%=;9766M6!6655432_1]/,)c'%;$k"
m


B
	c-$''2')-50i123p67H7Y65540G-h+\*(&#A!1?T
b	O/E? u23\K)mYts(5V߸n ׇ˸7Ǩ ¬2	M+DvUxU3ݾ轥Yw5կ୙Rd,p#fh򢀤ʥޥMuIݬ:׮ư$XϴmZG~ųɏϯU+{k"&~*=-0Y3F7:<|=>@AAY?)>=3>=<);98+87 754g4v4I4 443:3B20P/.
.-+7*)*2*)X'%%#")!_c|G >#a%&r'(*,.01246S9:;<>?_??K@@A@??>>=E=`<\;:::s:919887747J658544 43321-10S0[/-,m*`))(e(<(())))))=)7))S**G+++++++*)('`'^&$#S!]qVK{
q
%
.	Zu^W `zaD~2qLBr^Hdݭ?ֈԪҋJ,eȭ~ƑŖzÖh=E-OhAo:#ӽ;OvҺH-bT8;FN?Yը9
$"zyVЬJm
BaT f>|ÌɅˑ:ύь=n1?zYE"$G'*-A0 36<:<6>D@EB	CBsBA`AA@?C?t>h=8<:98F7+5334322210<0 /-,+I++
+)++*~*C*)(''%#"#?#"""#$%+'X(&)*R+,./013 6C8:;_=g?@ ARA7BCBRA@AAI@L><;:9r8776_6:654L31<0/.9.---8-,,<-8,*((K'&V%#!"]ub79 Z6G	Ul7
		g~9 c uU,cAV-#
EDS%إ׳Ԣ
B/˛U	"_Ŕĉ\p|8ν-0ͺx>le񳌳IDKl˭^T
m9'ĳt,<7`8˿gÈw2ǄY͍άV:FdA,ݠ`7onhf
5` J#&*-~025x7!:N<=>>>v>>===<p;9888 8r6434J5[5T4333333a3100_000j//.----+a*;)9(b'*'N''&^&&W()M+,,T-.^0k24c567p9@;5=>>4>>?EA%B^BBAA+A@w?=;q:n9888q8766-769654 434432%211Y10Z/-+v*n)@(&u%#! 8 
O4s'!T"X#d$%R%>%t%& &$#/"L!, a?2
E'~S5 Vvzt:ffxsg3D$N\ߡ޻ܪs=ֽՖ3Ө*Η͔E|f9ּ_׺@KƶMCSVh%7Vͭŭ*w	±첍/6ҵѴ
'{NCxmEʹGf2˿{<"sγАӄ֎;4k	zw/" &+1.68{:<>J?;?1??@$A-@?%@?>?=<U<;:c::$;";:
::9J9t87u77{666"6}5U43~3320.,.-,+))e*'+++,-l...$/Z01r39568;:;=>>?4@aABBCDEFOFFHGFE ED.DCB~BBBCBjBBMA@@@t@!@@R@_@v?&>)=<$<:P866Q531.,*(&Q# OD1M&iKG+;i|1_;'\
KV
/
e	zO$}2q _/~0Rle]j߁ކݸ&۽V*/=4&UҸ#.ώ5ήu8dagģæ徻SHsɴf\+0c"٪"Щƫ\UA۰Űٰ7@^UH!*⷏mgӢؙ% e	]#
p25)
>

Y!1}*?L
g #$N%q&'[)+-.////01>1?/---N..-,,-.]/Y0Q1B2R394056C8699%:B;)=?E@@@A1BXCrC+B~@?o?#?><<R<;:::;:9889:m::9c:2;;];:z:5:929_8X765J4E20b/-k+(&%%_$p#~"!7!!U!0! D  ,  !)!!U!!"'""!!	! 	Hz$:!

	i"f;$ 0U,ud^\a*)@2=p/݃J^YՓ ,vyѵц[̇8Zƶ4¼è{ݼڿ\'DvFM׻@)g&
޸ֻj־d^XaNпCCD(!{c¢ֿ`Hgdg%tbRڗ9z)[!"$'")A*7+O+**",w-,(,,,,-
.-,6-.00>//11/f.T/0}0F/../l0-0.[-B-,S+)5'%$L#x""#9#$L%P%$$%&{&%&(O*>+++ -.01d22466D6/667{76&6`54#4a31[0/B0]1M160/*0y0/-,T-..-z-.0R1/[.i.;/.,**|*O)'&?&%$#"!  c M8.U)Z>uhI <P0co""iB ADe1?
)
R
 
Y\
	e	y	>	uU21|<1  J (;?^%fT=P8ސݪܪ.C"׎5@ջ:ԶR  tiem-	\IriɱGGĲe:zvfྞWԽpeIS5sg'ȾѾ#Wrܿbv߾r<Ty#CYC40`a

ÉhAŰn˖ϭ	>	
gi!"""*#O%&%$=#q##$$%C%$%('''Q'('&M'(,)w('&&U(*L*)'y'((&z$a#\" E o  ! J!!f"P#S$u$#I#Z$&m()w**y+L-/0_0c0-123K445`5%54g445m5i4V33344q3S21C22720K00_1111$22210/^00x.x,f++,+('&'&%b$q#""(! \   Q oIY+| ?!M!!![!G!{ H^rAt#O)
,
	K	i,cHv :R[pj.UX!D]l6E%!{%p݌܀ێڸq ׻|A6Ԥ4ԮxӭӜӿ)hЩtrF̴ʀPcGťĜģ}ÒænF+âV[ ó[þ0Vl|Íy`9ƟǸǑ7  (n] ?y1Eo
Q. h"#q$"%%&'5'''&% %!%%J&9&%%\&/''''&z''&&'&%$B$%Y&&%)%%$$#!kjF@Z4"< t e  !"#$%o&&'(*^+S,,,-.y///S/.&.-e-,F+))+**++
++8+O+Q++**)4*+%,,-<.l.;.@...-+**)Q);(&&;%[$#"! !iLR|B Fx?U:[Nmrksx"S
!	Mh6 |s
cd1nL@!Bs<0/H`I,5PZG\ه$i؊_	֘HԪә4Ҵ+aΧ-u͟GWʆɖ?eJUĞfqI*ȿھü['Ϻ/u?8wOջhмrD;-T󺘺(ƺ0Ǻ\3^ܓ,1+[ _	Xk#"z!U mAE ! D L!!P" #$X$|$%B&E'%'&&2'U''	('&%6%%&A&$h#["!b |a<k0X#0_ "$%%K'=)*+,,h,S-,...--.. .H-,,--,+",6----..////]0&11[220333210/</.+)(''%X"E eqFH)t^"15S5kM9{"F#
'JL` BR
b
	fQQftOy m Dl%sD\vw_1.z{Xk *ZTGݩ#ܔۦڿ:؊*׾Y6`Ӱӑ=ӍN+OcͲ̗˵ʙʁʠ+
(Ǎ<LÔ]W'Wj4jQȾ~h!ӽ`ܼ6м"Ż>Ӻ]U6MF͍٭l8
[}{q "U$`$#c"!###!c Cj 7"""R""A###f###t$%%&&&$##4#$%$!#!!! +kN{BX,_s!"j#;$&{)+>,++,G.O/u/=/...Y..?..1.J-,,-3.-,,K-p.K/I/.H../0d11-2233221/9-*-)(a'%h"   !t#pi/A7IM9v
O
R

qh=kS@"U%

}

cs]NKaP :1=lNcI3G8:mfk[ox ke_޸\yOXKڽBخKע։֍Ӆj4Ӊw?O@΀̸͝˼ʍ]=~ďbg5 3漽Ẻ3[Yx!׹gLźCP鸱r VuIRܷиfij!f9w0x$
Q
	   # &2&#:""#e#g"!!S_]% /"""!    *!E"!"9<U2^(2G9F,O"'$$.% ')s+f+++,-./p12211%/.-,+))*p,--}-
-,,r,+|+++,,[-0.d/Z0i0}/6.---+t)'p'''%%!#!!0uvZMxHIt^!BQK_[VuGs8#E
l	vnX 
 .g 37K&a(X*8U_&@]h&$xT?/.Alcݷ_ۼRsjgְ-լ|VЏπ<Cɡȭǟ4ŃuK_}^tػĻ4¹7ITOOWP,IHR~̸۸37ʕwٙޮB/	 #Y$$j&'^'$#*#!$9$6#!K @(y t W s{ ! G:%A)L d$Vp
g
+VtsY"_#i#y$')**_**+>,,----Q,++G+*i)$('()z*z*l**}+B,p,+[+B++v,+--./.->-"-,+O)&}%%%$]"   F :q$1L] 9@nW
 
"_hPZ
CyDE&Z1R,m\:3 s
k
(	G&  	:(WY9Wlo0b\0NA_k@S
Cߞ{]_ۅ&#o+ҹLKbPR~ʹ[Ǌǐ<j/ýYl`o:伯ؼɻ!κ`0hz_Gڹh縞ѹĹ% cq%ߜ9u_
NL")%&'_(%(R'W&%%$#!4SCz9rA6
U"9W [!Z#%'((())*S+v+0+++*&*)('	'&&'(((j)	**++z+**r+,,,,,,$,++*`)l'%$#<"- I6W,ah ?a{&
!
d2	


;h/CDT{A>
K
	cu1  R
JV"0gVp	a/
9chU?%5uR-z߯ބO<Lxٽ!fհ6[zH&Ua^yȔńĥ/­޾v1tYܸ3söng(*l9;׸Q5y뺟|!PŔ˙(ܰMh /	"Y'&***\+,+*''&E&v$!$T[~h,18/}		O
<
%nc4!#f&?(((0))w*+++++=+*!*)_)('E'')'****L++,+.++v++_,,---,,e+*)J'$"!2!~]YKOY7`Igv EE,h9zg&lna6}p

 
	fQn@| 8 F>\ck]o*Vbu$5 BoFK;r<^?4/'+3,CgqG.ХϓXϾmFʏ^^Pƽłzhh˽oLϼh2:0׻e5e^i|57ɻcM- R7
Gͱәp~yj5
!&)>*U*++*('E'u''%#6!:j{f s!R!t !NoJMqoj
	
3
qi
![#%%%%&_'F()))))=)(y(('+'0''()+r+++,c--G-,,,-----,=,+*)L(&9$"! : i%	dKo&f V~k! 

~#w1[JMz7bm:
]
!	MbS@ !Z_D1C@Exv#&2| U*VK>b3TA\^[Oqܘ۱bV؁ֵׁfԄӜ=Ѧ$в̥˧ʧ?ȚLř[ſ$fud]Ⱦ ۿ.¿Ͼ羣̽5ڽk>yM)BםqVo	
N {$'
)((")$)'#&%%$$
$#!! H?tyX]f !!"!!    ! l$rVL~-


_a5;U<: !#k%&&&v&&]''''*(F(I(>(B("(''g'''()*=++,c----,,,R-N--,,,(+*6)'&#! & mz3Wj:Ai?[m#8xu H)y>)+0
;e
	BG3E 1QIo^**^"Xo9 k&)wazxߙ	*G}ڰپ*צHTӬҽѾн
}Qʽɵ#HFA!ؾU<#Լ3ӽl9{Lѽ5ؾiYc翇-jZ>¨eDjx@͇՞P	 Y	'q#%&f'(Y('=&%%1%C$y#"!C 62	8C 9!!B! 7 PN z'^
8


@yp
ekX\!:#/%&&&&V''(()6)K)`)L)(o(('''~()*+4,,
----~-n----.J.\..F-`,~+*$)^'%$"T! XY<+>/;T:>a0*pN;~r@qB}&D7
H	6(VsO  H^tFl]k`A=qq-Tr#! ]}tmݓ܈ۗMٳN֒8ԃStКCΑ#̂˰ʣɒȎǝƶťĄëG=.Yƽm&g@h,CҾھ׾'
ٿ'˿tj.Zigq3

  $&.((E))W)i('-'&$&c%$=#! n i   !!_"B####""=! )!_!!# 6H5lo
;
?

w.JN3}&!+#%U&&&&*'m'')((())!)b)?)(u(p(()*+~,M--~..A/`/O/4//.....J.D-$,g+*)'%($#" *jgRf$`69]Y+V4p4
p`B^9	eP
|
	MnY*] 
#AkJHf/>mZrHd@U0K Z+]L:߱|>ہZه؎x^=2ӏЎυM.z'qæz/¦Br%&_nSYzHBOj2£
D)§7žm(b/ _;3?#6%u&'Y'&'&&%	%f$
$##5"Y!  &!3!<!"A# $$##Y#"!=! *!! ? -,0>tzR'E*<d| "p$%&'v''''j'\'''(()((((())@*++,S-------c--,+-v-h-,,]+*{)'8&%8$#!w j%8DN&c$KXd[



P(R.D"tf,_!Hf~M

			-\|  A&*]Yh9/	/dW2Bn(?z!X '5
OJn߬ޙmܷ*ٶU%׏`ՅTwѓWϹ	;<+ŻĴu_bo;IlxWU¯0V! Ô4y*Ŧ]ƶFZȈ
˞%΅
ч\k\m0Q} Q4	oi'E#!	##2#""#"!>!!!8!F
!l!8!X!u"#3$#?#=#D#"""!!1""6"9!? p\p_8	5 !/#$%(&I&&&'&&&0''''''Z(((())*++Y++,,,,,-0-,,e,,,,*+E*~)('&$%#x"!  9g9&w
P[oNU:Ve:.LuHO?
0
	#	?:AS!IJ vif}3m\lUUHR5eUUS@3{ݹݒ5ݼAܿLGڛةG׈֑ԧӋҚ]ЉϠSj˞$UQȎc]Kžŝyų&ƁƛƯǊǰǒǷ[Ȱ!ȾSɅɂGfZWUAѢ^ҊӇ]Ճؖ@e7Ir7!R
M35iI W    !!`""!""y"!!!""g! v [ lDnCKT
gdxX '!"##|$%%%9&w&&&&''&'B''''k((;)S)o))=*n**+++(,j,,,,7,+++W+*m**)(|'z&%$H#"'! 4L6	#t:'l;B1TWLr4P>Z&
5rE*
J
Z
	R"Js  pe5<94) M=g.ER J_MqP!lm	vXiݦ^+ۧxyx*4`SԑӀҮ5ѣЛy:[  "̞ʗ5HʱʴʂʽGH.̛D-^ARϣ(Є1ғXհֈsI#܁ݾލ\X3 
L-P-d|qk v!M!/!!"#""""#"/"!"_"."!K!M!P! -b x)W>1    B!!@"j""#$%s&&7''''&'&&&!'o'''7((((((((+)}))G**+/+/+)+ +*z**))o))("('<'&%{$s#"!! 1e 8o
+?i6sFN+k=




	,[]0IxQ
s
K


D
	x	c+!1x:B;Q B 
Jp[RK2{XIu#Gr^',rICOޥXxܜg4
۶|&wكؚֆ	ԍ%wҮѲ3Й
ϯ΀j?{v͚͛zQ!$r͆́:qH}ͼl̈́ͳf0R̈́e]kzϗGcT*ԇհ8׆GحٟTRe+XoqQ *	D?UkWo28)uA  s!""""Q"!!!<!     	 ;^kff=k\NmJS}O/&V V!t"m#$s$$
%J%m%D%$$#%%%]&&&E'''''P((C))T**~+++,,+N+*F**)):)(3('&%f$D#G"`! M0dVTYx!, 'x\wq=@t4


!
l
?


		YgD{	Lzv ~	?Ey OE>v>~	OTIZ7|Wp4q^hSH!ލ'Jܰۤ7ن<5؍}E_q|тAMϲτ=΁9R >aK	̩̈vES!ʘʗʀ̐̊{Ѵ/brO4XR	$WxmBjSz8)"Hd)LZ>jTAeOF_@g3xj0*" 0SYI  _!!""#7$$
%\%%&&%%N%%$$$c$;$
$#"!!L z TctonfRYEh
s

3
+
T
q





qi
8
&
8~4

	f	ry-Z4DN8~ !p`+5hU^T
Lu$r%/AL^L>-a+|vNK+Vߗ:ݿy"d`ڧqX/m֊~@դԨ{IKѽњo\O%ѺyЖpѧѮI
ӿ6ԼԎ՗֒WEgݑ0H0C|0
@	Q-
S

T"+

1'u='[20f.
0
}g;
>dX!LOk3HP4}p/}B{/*t%P^b3c]FrS`;6

N
jq9
O
		#
Q
\
K
L


?]!
d=
	j	5	F	W	$	I	G	o/=YNhI` c4h*f` *qk?Z[/J[ ;*soOlW-I$TF^KR@
PgNIvR.Qߛ-zߤ1Q6F`	:8*)|}
@\wK[		K


		't g-Fd^S&P

BN

v

XKEP. 	9r{;<7we[.NK|/Sn==wL	
C
#
\
1

		hp#" M3.Vd g d=F?  =   (  F 7>4>),ZwHJx^K_fN7XH
Xwu&0	?v1EXz|lybm.y
CI)_*t7mY%]. V ~   ]/w,O{$\M.f"Ql
<QHGg	=	M	O	G	S	k	|	x	s	u																					~	F	 	&		wFPk/P Q|5=R  ]  J==Z=dB M2%tZJ<"
}jSJ7& !QB+($!"&0Pp}|dYOWbkgSLmTSA_#2e1Rs X	6{GP
 }  IjAjxH^$`
h3			0
p


2\{"S_k



&
)
*

 
|gW_n\0!E 



k
0
				W	"	N}Qj8.|Je-kP  ^  ht:ua[a|S:nB|nfUC.	"4ITbu
 0AWl Ey !Bap))!?s8s+ZP!7T% ? U v    2^|8xNlsj@FKZm{ygUG>84&
vo`H,	m^J${kdSJ<     z f @  vcL6'kZ>!	znd@.HQWc|/Rp06>Sq{    * 4 : 6 7 ? U j l d [ c          ,89BFX{3AEEHTmux~vrpeG'!"tcWC%     p C  zxlV</.7?FD6(!

(.*%-;FQWVWROUkplfUUZ^gdQ?@KUMB2%',3. 
 	"%#(26AOZlx  ! ' 0 I P ] a l m }       
#6@CDVXOJKFCBGH>0	             | p h [ L = / (   {ot{|wd\\hpqkhr     ! ! & + ! - 7 < / ' , 9 @ ? 3 & &        $ 1 > I L I ? 8 1 ) #      % + . ( & - 6 B < - "   ' , ( $ "   !  & 8 I E ; ; E S ^ V J G X g w y { u {     | s m l i h i f f a a ` Y Q C 2 ' ' " $             
      RSRC         [remap]

importer="wav"
type="AudioStreamWAV"
uid="uid://ca7f38eop3q2u"
path="res://.godot/imported/u.wav-fff863131cf36ea0f0514370fdac437d.sample"
             RSRC                    AudioStreamWAV                                                              resource_local_to_scene    resource_name    data    format 
   loop_mode    loop_begin 	   loop_end 	   mix_rate    stereo    tags    script           local://AudioStreamWAV_k818g 8         AudioStreamWAV          a   
    ! ' , 2 8 > D J P T Z _ e l q u y }                   ~ z u s q i _ R L J D 7 &  
   xbTQJ<*~nV>(kP7+&ygXQH;-	!6KZ^bt2;BYr,M)JXc 7 C Y    -Dl)DHaC]V
Ar	G~.Q[\n!05A[ 	~wu}gB!
 `@4'tC^+vI'FYrV*   F  \e6w.s0V]?q(oL(d\=a'[)q[O1o@kOa|~iJ=AMZfkh]\k0Ocq<^}Er!iV"ga'tNb4pzV
t?H  /S0#8j^T		B

P 

~:`\ey
fOj D2G_Xjq=7 4CG?t.bK@i'P4tRdjvQFt0
?
Kt
,
		O1;KF!	~ nyW5WZeu5#GqFh^i1? h%Bv65TO(W'L({?OLY
(9@Y|6c=s8o8z8nS=]Ux#u3 /	q
6
&)1# t5   !h"###H$$%9&&4'z''
({((A)n))))1*m*z*`*I*J*Y*g*a*B**))T)+)(((|''&b&
&%%$	$#.#"X"!M!   3 H|%T()T!3H:C7v
+lb
-
g


f	;:Dn  r
c@y P
V9_22W2i%VRmD
E_!vuBM^R	F7Z]1R߹V߼tޡ
߸.ݴ{ݖWާޞxޘW߂߇ߗ.{7~lNIfb.U~3#eMTI@O|h
IKrdV, y>_8	

g
CqP^mmE"^"
 !+""9##M$$J%% &&&N'''T(((( )A)q))))))))))))j)Y)1)((J(('''1'&&^&&%X%$$Y$"$##,#""h"&"!x!N!P!J!! [ ,   q:nkaU*aoNe7Nc=


&

0
		
	X$9?'(	$jrd=r|ho=+pO Jk#dSy0icEYFޓ޺ޝޢRq5;X5
Cqdߎ/-];IWu9jl7_	Y/|q
N2 0\0 U.i>rN:=^! R,JzB	
o
F<JPYH(9cN~r;R H!:""##$`%%d&&''(q(()h))*J*n******+2+++
++ +**4***U*`**)#)()(_('&W&D&A&&g%$$###<#"'"!!!!!Q!    U q)~2Pv</BCh&#LhJg	
4
d
B
	D	a#Wvx &D^+j`::0SpH/s
6SLe`ߙ߱Vߺލn;P"Q^GwR^
ܜtڿSہ"ۧږIV.<ۋ۳ۭۨ]ܓܚ܄܅ܦE|nTLx5|ޘޮrT][Ib
yV22>	>BB{~?)&RALW2 
jw	
wv
6?3!,Wa-8kW  !"#}$$%Q&-''l((%))e**;+T+z++:,,,,,,Z-----r----d-,,,,,q,+o++**Q*))((P(('H'&z&&%b%%$$##d#2#"""!j!! ~$iu!mZJR2tx^uiJ
j0
K
	0EQR$f$ .{VY(DcF}Wf PWuBxPX;xR
 ]liHGym1JbJH߂޵aߎ%<޹ޯ_9PGgܼۋ^e%ۡ2Xg)۹ڗۚYܡFۊ?ܫO?{-܋]:ܾݑݱݮgެުޘ޲[߼_vM9z=!CyBhLd}tjRCKz
j 	
6ik !"#$&'()**+,-:..W//i0
11$2223b3344444445(544C4433373242110c0/G/.-Q-,&,z+*)(%('u'&&H%$|$!$#""!w!n!;! I L%`=^UTB$3x={n<%39
5
e

	C	u%"   p[4)lk I$DRuj5 y7.DR:0cJ<g+0ߒVވ-\ܨ{L܉+	rوyِْL>$?؜(}>=׻	ם\g׶٭
cH#.cٝٵپط YوkKf0[S5CڐJۘ
m&ޣC6V;3'UjVE >EX`c
;[y|X a"r$d&()++,./12-3V4z5x6J7889d::];;<<<=4===?>`>>>>?>>v>L>>=c=,=<A<p;:9(9887544&320/.-,+*)('&%9%|$##U"!K! I4OV$^.'@,zwZQ,db6x]
	
S"
S
	n	+y^ o [ V? F}mUa5i`\2ZB,6s-]??c4߼fݦ޴޽݇ܯ#ۭ5ڮ. ظ:רBׇ֣	J(֢֔^n-kՐ/c6ӬҺ
E@РПкP_ҏpѾ0w[Qьr2u	
YOPҶѸѴ?ѩJ;aЋЧднCҾӃ^ԷU!<YD()V~n, ~kI	
cFh@Z?> "%q(*^-/135g789:m<~=L>U?@BDDDEE~FcGGYGFFGHIJIII`JK=KJAJIWI?I<IHHFEDCFB@?
><:u9D8Z706v4v20.-h,+)(&Y&%(%d$#" "!  }+Li;;7+!G%gAAkyz900ho

k`7
	EVJ$> ?<^Goiov(M*'p> [wGdv/!޺ݿݯaP{wڌڐ,ٌ3rٚr;נ>ԕ{ձ֩
5ӯdӋ.Й0=ωnΔ?ΙtCT̸˓S?Ƀwț0ǸǏȚȖȐȆ@j=ɜ'ʭjdʁʢȸLKǣSȹ}ț<P}ɵRʈ
͚жӂz@$#"8 )
r F#$&(,03573:>= @BYCmDEoGH6JuKLMNsOO!PKP_P_PPOyObOOOO@PuP`P*PP	PO,ON(MLL3LVKIH{GFFDB@>=d;98U7531/_.,*(&u%$$X$#"!|!!j! ZADeX%QJy
P63 !"*#""t#$U&&&%%$%;%#%[$(#C"!" "*!M~)
zB1
S
	VO~N
|W(^?A	XIQ&ml݃A9HօzgԗԘNBӓ=iP Ӹ7ўZZ?5uGʙɚȮǄǕW}5Ǧ8Yć+®۾!k¾TY!4ݿmê `ÿ*M×C9[XOV-hƅbbќs}#
vy L
1
{6cl; " %(D+C.036:k=@CFILBMNyPRSTUUJV^WXYPY.X|WWXXW0V0UHUUVVVUBUUBUAUdTR@QDPONML=K9I*GaECAk?= ;59z7531/-+)T(&$Y#"?""!!!!!!!V!!5!e!?!  !!   f  X!!""w#$h%%%&'(M)*z+,;.'//0//n0t0/
/J.--s,+*.)''%$=#!D 
9rK7 i

,	>Hxl)Wds6lcnݘ[iڔ٧ؐ[KyԅӺ6ҽSЦH57-οYq*4nϢ9BhCg|^ύ͞_˞4)ǑĢÄJâ¿%a쾂þ+LmλһC?n(kָF*k»tZ^cf ?uￎǿH8c[RƉɠ
QݦZ-~3	Y%"
CNT
EG"&x)I++,-o169;=?CHLOQRTHWSYI[0]^c`6aa,a bcdec_ba*ara?a_]>\k[[O[[@[ZXWWWqWUSYRPO/OMLIkGDB@><P95320U/z,0)G&H$#d#l!y P"#5#"":#6$%6'(*,.'/0245765L6Z78:|:%:w9Z9/:#;;;:6::;<<"<W;}:99b976432100.,q*](&%#{ #rK3
}	^N.-s1Fhn"pZJnDj̋)V˅˱ʵ3tɅTǂ7ȿq}ˬ]c͘΅
	IΞΧxαRζsͫNʉ7~xȼ)F ÖZ1r$0{׵!pi0eٯ5*#bAktӲͳ9;TI)gR(V2Ļ8ɻUi1gӷ6C?;mj 
E}{)"%'()%,$/26:;<>oBwFHKHMOSWZ]`cdedfWhiDjjFjijjklife,edca_
^\[V\\[rZWU~UUTaR/OMDLK.JIFC@O><|;86`30D/i.(-!+a(N%"!!! u!#$$w$%(&&'(*,z-. 0w36&9_:m::;=?@@
??Q@BCCYB@@AAB*CuB]A`AMCEDCB@/@?>|>=:19827f6412.*'%#!ePw:	z{vT*gTfШͼ˞ʅɍ!о߽r )Һ*ʺo7#&3BK;v8#ml4-1Ǉȶ;(n@*¾躓 @V ccdEcggzJo/ݠac:ޠvǠڡ; 5fA6
6"0C Խ0ƏIڹ?N $2	M""%R)#-14568;@EH`JKMRIWZ\$^S`dh!lop[rGtuvwxwcwutwuuBu@txqoJnlrkSi6fWc%ac_$^]\/\ZlWUTSRO~LIGFECA>M;8g6N42G/+(J'W&%#x #u;2P !""y#%'5*+K,,,F.14678E<@DGgI"KLNQ8RRRSUoWYZ[N\\M]]^^t][ZYZ)ZXuVSTRQNLI	HEVCc@=G;8y630+'%L",29pr!	jm7(<57҃4;ǥ
l;d򱇱ұDoQȮ"3mdسq8ԵAͶ#lٷA߸sN~ʱqgzg}B2iÜZۖE"ӓٕOגᒇw(Γthd▊K>>ۛ֜ޜjqUޫ![$ɺH,Z\ "$).
4667:;@nFpKNOlPaSWc[\]k_ciJmoruxz{{q{z{3{yzNy&xiwHw[wvso=mk|j$hdae_{]\\\Z[PXURQEPMJGED.CBA?{<96u472/Z,(&%:%`$B"1'i?J !""#|%)'Z(d*-0305t8=BEFG#HJ=N&QSSST'WZZ\\[[*]_Z`WaCbbOc
dCeedb`%_][ZXV!T#Q2OyN&MID?M<):=8~514-F)|&$#Bk
R
F96`NWޚ
٣8ѿ|ˇEOr
1Ѿsھ-x #k(Ghɻ黯)grzw/Ä8I|z>6`wb=٪רqk6WLlUЍ{x	e(VGkjSvnFHu	הnlzO16Ƣ+EABЙךU,	0x9 g&,0248=WAB*CACEHLNPRTX^[p]]^aCevgrikan	ppqcrsLryp|nlPl4kiisgleb_^,]<[XUSlPONN'NL^JIpIIF)DB?A
@n><W<n;*:864d240-+)D(r'&Q%#"q""^""!o!!"$'()u*1+#,-/12$4}568=;p>ADGIL
NPSV&XvWhVVXZI[ZBZYxZ[\]Q\[[ZZ[ZYHXrVTHS8RPNkKHFEDAH=9 741.M+>'"#|-j*
{]
Q {|AKX`#T^%ЌϚκ̈́͢/V̌8Z˯8~əFɗǟ
ț|ǮZ$ɟrȽ_L8,6ým9>2jɩ[gݖSE{~E9PT+e8:xyԆPj.K(1\+Tp"ؠmi%X
ͯ³0]"p?8=C<$wPf%T+X.F025r9=>
>=.>AE I_KLK:NRTVV WZ@^a3dfmgikkqkk0jPifbdwc%baa.^[YW5VTQNMKJIHIIyHG8FJE;ECA`@>9=<<=Z<0:E864
3U1.*,0*/))v*)@'%%^'(:'&')P+;-.1l246b9;=>p@CRE(GH@JL
NOQ[S"TUXMZ\c^&_``|aaaaa9a%aaGbbb`&_]*\yZ{XUVROKIGD@A=:v775O2.*'%k# u%	9?#$:!vdߥ݈ؗքԏҮHѡЯgͫ1{qP͇͂g̡z7˨ˡ˺2̢̽lj^;hǩƊc۳`$?N>0G?䍤ɊrT~R?G<Bp߄9(C*(ʔ=לzr^Ĳ۳ʸWռ5b*mZ-}$2,26O9L:;>xAJC^DCABBESJMMM'OPRTUdWYi\_?acf\iaigfff)fc(a9_`^^m]Z3XAUR$QNqLUJH7GE	D!C3DPE+ELC@b@@E@?><;Z::[;b;9=7%4=22<1/,<*M)))**)A'&j'''v'(*,-/258:::;D>A8CBBD(IM4PQRSUWY\_b`5`amdfgfedchd4eedb` _\][YVRRMHFECB?9e6652-)'$%!ox}G	:sWnN܀מLԒ*k67͐dÈCͫ̺W2>ȚȬiǉ@dȔȔ{ȟ+ɣ+ʂLɟ ʥcƍŃ&M`y4n{:d|Pݘcts-s$щ7鉃'YĈ\ċ{yL6Ԣ쥠 h@]˴K7P!.ffʻ̐%m@pQ 
]8\0]&(.232027=@?<l;=BAE^IJJJLrP T]UUKW
YZ]aezfddEba$c{dbI_[]YXY|Y:XTP]MnMVMWK<HEDC<BB%DDuD*BN@???><2:Q86778u85~20//N.+5)&H&`'(M(&a%&'o(()B*,.0a248j;=>i?V@BEJHHHHK(PRSTTEWZ^abc{egjkj_i`hgNggfedbM`]v[YnVSNlIEBA?:5y2/10.*X&" tePb
	DM6ިVڋא>#tмmQҿљ;ҸE=Ћϓΐ΁ТϴXbbj{kΰPϿ͎*!̦dƺ(ďż7H$ȪRX٘~]cd~GOΈ	U;u?#񊒋48VTNϟhئ' rְ$ͷ츏P
ÁĴkYΝш.8 ]*
gp7#(/|3T4~457W;==<;<@DG>InHGrHKNONOSUWwZ(\$]
\YYZXVTP@ONNRN!LHFDDCuA>==<;;=R>#=;9{999j7K6i5a4;444J430.h-Z,w+)(<'&)'(((9'k')i*[**m,A.0#23_56738~8F8]9;
>@CEHHJ-MOOOwONN}OQ!TUlWX[^u_D__^_`_e^Q](]]1]ZWTPQMJFC@!>;86P41.+2'=#JTjV;`  pY1:B1QڦڸcVוf 3מLTѪJ;fБ>%cAʖʡ8p̚~ǝ Wcv7,8?;-.,BH0ˎۋz*>	Ƌ<$)֏{ؑf%-#ۛdzܥ
ܱTbn_UO?F@![h=h) yco|%+/1=1-2~4^79::8q9x<@\D'FEEFI@L5MMXOQSUtWZ][ZXWhWVTZROMuLLWKIGDB&A<@>==a<:9m:<=<;9888736432253320{.,+*)(Q'C&p&'1('9'='F(e)	**l,:.
01[3756787;7z78b:*<>Z?,@AqD=GHbH5G7FFIKMtO.Q]SUXY[\]A\O[z[\^d^\sZ!XLV8TP:LGD@U>
<9v74i20-*'g#H H~/8i VQCoXARHX:݊20JNܽ|V	ل)DfӦc҂KJϛ

w̀ϧJhͶˮƣſĪ򽬻H6k^)*DDKN7/=/񔃓ˑ=G/ffߑϕ6pGݦ;Ʈgݰ<ҵնƻ)t&³ġƁ'ι0׽ړ,sIA4_!?&+-.d.0(3566668<H@>CDFcGHIK-MsNOVQRTVWWUTSRPWNKxIHGG3G1EBA+A@X@?=<<;<<==<;:9976P539211L10/-B+)('o&%%#&&''(()*(++~+,./@123V44444D4415555f568:<R=?BE)GyGgHJmMyOPhQ?RS#VXeZZ)XUVUUVVSPMKNJ0HD@<9*8#6j304/-+(&r%s# S 
 xl;Y~S0+ߚ*ڥp٤+IԱ9
Ҿ~?Щ1OͺaɣȰǲHnNZҽZ$EΰUɨWٝG
GΕZ9D叭܏{roc^Q񥽧f
q: Ⱛ-^nz~tǤj72'Q^p  x%)x+F,
,-145"546I9@<?WBCuD(EGJsMNtN$PRTU;WaXW?V|TSSQNsLJHuGF6FoDHA>=>=U<w:q999h9999N977664;3#202/%.--,j+)'&8&%s%$##$%&&p&&W(*%++-.0V23655J6~6666/777=889a<?BMCBC7FgI(KJlIMHIKOhQRSyTwUVWxWVTuRzPOOONAL IFDrB^@ >?;/85431:/w+'%#!
mh`7Cs+CJ@0'C3)7*3߫޸&ہ٩^ִQX&W}ϩY~΋Jή͆P'{$ͺ-ݴz3@wѩ}衆+hĘfufkؕ}r8B\k`;|?mi\ֶ-j*
T:`ŊȺ$ԚظAF	dv "Z&'1()F+1.000082=58:==j?@AC[F2HDHHJXLGMiNOP}OMaMMLJnHnFDOCBgBA?><;;~;S:8}888F88n9X987654321G/-,,,,{*(''I'&0%%$%%&C'a''))-**+,-./01o222 2102222333578>9:+=S?p@%ANBCEExFAGGHrIwKKM%NM{M9MMNtMKIGTF3EDDC=A><";9}8b631/~-|+)s'g%"\ ( Wp,
Fa	4)1l~& @:`-* AGܟWٮ{َ׾ך_՜Ԭӯ;;ζ̇2b˒,aоѹI<LE7yW<u/A䠟]iZ"jɛV/s/T8հӱA*8N\8t08)ǧ?ʒJ!;hQyj E:%|~'w"%&'(*L-F/00(1B2^4Y7:{=>3??A=DE3FGHNHHJLhMKIHHHIGDqB@a@@ @>4=;I;;;:9888>86W6K708765Q4e321s0.,++++*)K(''H'N&%%D%B&'h(/('(****+,->.//0I1j10001u22222y467777{8o9;:::;<?$BCDDFHJIHFFYGxGjFDBAW@>=:e8k6420C/.x-W+(&$"H!$3xHQ@^
`~	l8`=@Qi/ cD`>Ttn8zsF{'ݪMܽGڴ+Bд+;̑=;ȋƝbbS}M2ɯޮڭ槪@8Цơ=-FMݟc2kHJ֬`|İѵdp
H0_Ł+PǟȪEʯ1[Q(ջLܔ`;<u9 ?"##$D')*[**,/35719,:n<n?wAJBSCE HIJ@KK%LL3KJHGGED*DCCBB@~?a>>@>=<;;;<<<<E;H:2:9874332q1/-]--,*('1'/'_''I'*''('''x())**+1-.//////
000U0012633K44e56/:>CFIKMbPRSRDPQN0NOQRPGNdLKI]HFmB\>:877}52/-m,+y*I(%"d!  K8s C )8,!
5goI&,qݠq~(jڀ<ىw.Y\1pi̡2W̖8fxÃCX*5=O,1|n˩oʦ4T:+$PO_ƶ޹Ѽ۾E!ćš=`ˋA{Uҥ^QK(in܌!1#5F	DZI F"#;$%'(!))*c,/y24567:;#<<I=c>?tA	CCDDDnDDCCBA@V@>@t@@@@?i>%>=C=<<<L<<c<<9=<f;9987H6443d32F2V180g/..,+C++**+]+r+P+/+$+8+e++++,|,,z-N....-w---.=.w../913=579q;<>BgE*GFEEFGfHGuF E0DC;CBA@=q;9q8t752=/,+x+{*e(&$##! m]=	/^FpkYd}JB wb]tT}rݣ#܂ڝړuL	6"٬c?6{к+ˁ;|cĬĩ˻˸`ڵ
;Ʈ{cŬ*fKa!t`E ĳ+յPW Ⱦ޾Đ*x|NPʍʜD>ЉԽֈ؋ڡ#ޏ=Jl+G%Sm
WN=#m-UPq!&#_$%Q'N(
)
*)+1,S-/g1-3 457:o;<(=>F@_AhB#CCCQDDDqD-DC(CBBcBAzAhAFA@@@?@?K??>=<=h=m==O<;8;:98R7]6544M32
210/O.----,,-.|/012t346w6)654455679O< >??R@AMA@X@??@ABB\BhA@?J?W>=;2:8=876532B0.f-+)!(&%$#"!!#

-@ 	#
u
V	B:NDTlvN6 ߞUޗݩܡBݤ0BۍھLؕnB ӥVБf`Ή
;ʫ!&ƀK#8=RxUʸ嶑/ŵ~߶{$(w6ɷͶyc躖/ÿ%UY!QrņFɞ͈͢;θeԧז٘3Cby2$FUrvY	evuQ	

kX6aix !!#&)c**+-R/1385L6_789:E<=>K??A@A<C'DD3CkBpB!CCUC[B8A@AAAANA@????>=<v<<<<;:98A877K6I5432221a0.-E.i/1*356555p78%976#667|9<k=<:H99|999$9x75!56787S54C5M66543~33~4]42#0D..9.J-*5(&%$^%L%#	!'R+~$IV
W z 9PlU'x,ZgCPU."RM}C޵>*~ݣlڸo(]/_וֵy1h2ҺЇt?̼͝ˀņ,^ ŻvH(¸ľYb_\Nľ7ȿh$Vӽ
gſ|¶^4l*ȕ%g4ΠAbϨЖmԩ6{.1ڙ<g܊3ch\`(I?KX$dsv|*As}	
,B|t9 "j$p&U()*+3.0123457 99W:
;<<>Z???|@ABKC6C@CCEEEE{EE^FFFFEEDDDPDCCBBBBA@@?l??h>=<<]<;;L:98*8;7K65%54321)100,02/T.
..-|-,0,++a+*1*m)(((l('7'&`&$&%C%$?$##^#"L"!!r! 0 s'"9w	K 5G
&
	8h?= *jvi^;*W[?+Z:s߿9vܸ~ڑd׻z7ցWl/ҕ;х"ѬHϲϧϢ},Htf4·?a-7ΓΘF8Ϳ͑ H*#ͼA'9ϯ϶a*ѕ!ҜGӬe7ձ#%"ڼڱ+6ߕuQ iTr;X2A9w ema!=	3
7
z@.i
7  B!!"Y##$%&F'''()++}+*P+,7...../800F11111O2333832'33/443@3
3G33d32222=2
221)1U0///w//%.!-~,o,,,+U*))o))(N('9'&q&K&%]%$$###"!F! [ \KIOO&I7xq2

F
:
S	cowF 97HLaWhaQ>$,cxMߏePާ5VڡpC%ژ٭ط؀*׼װ׍pk׀ך׮׵g=ו@ج؍FbFpٌ٬ٴژۈۊ~ۛ(4ܾݧIPޓ3xzw6Tao>W|`*`-c #vpIZV n ek=	7

:\~mfS=znE
  Z  *!!!"="}""W##$s$$Q$###*$[$I$##$p$$&$###z#f#y##s#(#""""""F"!!!!?!      t + qYW@	fMKh9FX"F7c[@

?
,

v


u	|{]|Z*OFt=z* & ?c-iRf*!lXT,H?$WWEb`"np3\@L,Dw )9?Xz] 
a6eDuD((6>Ic<8v6Lk=yZsHg;@ oR?DL  &$cOk,		
]

u=g

6nTL2x;_ort)`

)3fEKW[P9) -mXa7{53=Z
l

_I
}

	v	C	mD:}K5q-M.HCF  K   JS|LeQLE&`k,b9jk;O
+/~tkL=[di`04%=9"eV H n}&[&@k;[[Fju}
6_y9e+Y~h
?# Z   N-k!&K.LtCdpt4Z%Rw'IU\]^m}+	Y	r	o	Z	K	C	D	O	^	d	Y	K	@	4		W){qhX?5%{lMR1(agm;K'6TZ6}R ^LTT4    i 1     ]#xOpf]E	"# pQB9211+"~eZPOD5@c~uj[4	 
+LUJAIYr"Ai,B_y;tE^`^cl{|	 : g         'E_q~	"8O]ipw!
  :TqdGFXZE*{T1%$
/HTK48LU[TG=1')05FD:%gSGINP^lu{y`>)'>Wfd         
      RSRC [remap]

importer="wav"
type="AudioStreamWAV"
uid="uid://c7w58k44066qu"
path="res://.godot/imported/v.wav-12b41c6137c892e420ea28633cab9d9b.sample"
             RSRC                    AudioStreamWAV                                                              resource_local_to_scene    resource_name    data    format 
   loop_mode    loop_begin 	   loop_end 	   mix_rate    stereo    tags    script           local://AudioStreamWAV_l33m8 8         AudioStreamWAV          JX                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            wlbYPG?4+!zpd[QI>0'+>P`s4Mb} B m    -Y?l%R 0c"[2WO|)?`~	<	O	s						


&
3
:
F
T
a
a
l
v
~
|
x
s
l
a
Z
V
I
9
)
 


					b	J	.		{O!j:m5 J
WBs4X
 w / ?^u&;1AC?:@HLY
i{2Po'Iw4Li,IR)u`PA3*
!)7Ru/l>R+.L0ZU?-  '6B SZk{	
(
=M[eqzvaM>% z!?"##~$7%%&>''())/**0++,|,,<---.D.v.........h.7.--?-,e,+V+**J)z('&%$#"y![ :sK"
+Z
"`
	,	zO&a	6 _t3Lc-Lg:bNeSJl/zaEG۸/ڲ4ٺ=Z֍)ֽWԠBӉ.ҎFѬj%ОZ(ϚkA!Hzϩ>а1ѥҹ}:ԗaA@>BWۇ>w+lJ~~#L 4>	UPG)tg*g !"#$%&'y(Y)1*++,-j.//^001
22334`445h55556 6.6(66555@54443.32 2100W/.-,,$+=*I)D(*'&$#"!b .rE%vlbYZ
_i
	%V\< V%bH6 0::dT>Yf:xYMMcou)YcX9@>G:z)t19<CNOFDB@5
:DA=>7.%u_3l7gsm3a%+X|*O1h
6.uz4Kc?$xZ3#.6N)^\Dc	=e(2H]1 Ef/g	
CGBTrrXE $!""#$@%%&y'&(()1**O++Z,,@--.x..+/u///0,0K0M0E0?0,00///D/..8.-e-,P,+?+*)*)j('&&$%R$x#"! +XnLnV h9!#0Z
h
$
X
	y	Da8JWY $ 5b
#k
8x,'fry&@\KmN @jk6ZNED$;3߆G߱a ݏMq*ۼ~@
ڏG٘d)خ؅b8׼נ׋sQA3&gכ׺?إd,ڤ9ۨf0!m	I
d&3 faa	
5
S	[?~ !"#$%&'Y(-))*Y+
,,b--.2//200 1p112A2223:3[3i3f3Z3F3+322|2521141010/.E.-,,&+B*])](T'E&,%#"! Q%X4!Ms
&
	B	8;NfW0{. z ' 5V=7kM<8>,
 `A:'X0 N
s,m.u1C]u<R4o'2>OD/_0V}&=Gdar߈
ߑޖ ݰ5c ۏڬ>{nցJ
ՙnJ(`թ9֟יؖٱc-E{8nQ7)=LN kd`	unX\hI!<"Y#y$%&'()*+,-.Z/#001c233T44i55V667f7778$898<8-8877q7 76T65V544q32100/(.$-,
+)('f&<%$"! ztodbhw`k0


$
=
	k	8Jw9Xg<t[>zR-     { X 2  yQ( o8	[0L_~@r_w0sBk%]KCQ6mk`^Ix!m	!!@rXp+`{
@lݐݭ:zۏڮS؎-l֡JթVղo>
Ӓ]@54k0}vֶAu=/4:0HމGqGF=dx$B	zXv|_ Y!"$G%{&'()*+,-./01l2=344P556B77I88H9996:}:::::::::;:9h9988T765'5F4b3o2T1&0.-,+>*('K&%#Y" !jF!7x!V
J
Hv
"
	8	[06|#ok$zdJ`>5(    { Y 3 * "  w_>sQ3E}30_T/ k dT*St;g/e?mqjjk6snG0CRak|qy {Kܹ.۞ښ~w׍
ֈՈԔӰSѥJЦdϝuO<A1$);X{ϚTvp6ԈP"cٮ\E+Bn0pL)S +	oM
rDRs S"#0%~&'&)*+
-../1233456Q788d99e::_;;Q<<<$=I=q===r=_=U=<=<<I<;B;:98!8Z7z6{5`4=3 20/.,	+),(&e%#L" )!}I'
 ?
	I	R5sKoV4ybB9;02W;+Js"+N
92$%0xV7W|Bo!} | < bl(L3Lv72h8:v&Xn3>gg]|mH(0XV/$s݆q
Mٝg/u0Ԕ	r(ѓkT`e˧c˺r,ɵɑmSWizɛɼ:ʙ{gUNEץ:h޿B-f &	3c
~P7A!"S$&'Q)*	,-+/i01"3w456789:;|<,==>?@@
AA(BVBBBC@CPCeCtCPCCBB<BA>A@&@W?>=-=#<:9878643
2l0.h-+-*k(&4%#!^ 7g<
Z
	&VBT  C  8   7nI#\~HkX\		 

PJ{

66~'2n<)l

An
	TSq |z]Ewl 5o&KCI+mt6~YQq=1ߣ*xSFڢ_uցaմ(Թ7ӑN,ϋO̩#ʴ(Ȅ*ƥ!s.è!0YտyN$Ҿ[MA(4Wy־5ʿ!M~bÍ.HȖ,7ζ3ѬdԑKlݫ/!#D1CZ	*+z
 B"$&(*-/02l4-67%9u: <=
?7@XABCDEF(GGUH6IIqJJGKK#LULLLLLXLOLbL;LK-KJJlIHGFEDCBbA@>>=;9]8653
1*/I-O+X)g'f%S#G!c(BQ`]
!
*	 g [IzDg
GY]  1(A64v5		N

k2#
"6 	\~ ^B]sM$
@
 	Fd ^]o9B&Q!ZAupG
`p\vbݼ܎eWؾ?ױpձ_mRZφ-*|̟8̥w
ɐȍ=h KmfԺ;_"pӵ[Ŵ |N%Bg0M˷n cķƬvʓDbҚ
FqHW'l	>3C9 !$'y*f-G02468;a=q?XABTDE3GHJ&KGLMNOPR,SSSTT+UU+VxVVVV/W{W?WVVwUTdTTwSvRQONMiLJHFDBZA?=#;n8631/9-~*' %" Ic{^
	r@ U_jBe9nR  >bI!#F-		m

n
G&~cW48}+8 k!!"#%&&9''(C))J*******~*),)p('4'&%n$"!Q Rf+
AZ	dk 5N)#oaq:%tߓi3Vbڠم\q*yԷJѧ(м5ϒQWTdɪɜGɥǯǇX6ţaŕĂt²%0"-U%߸Go!J\=6	檿ߨԧϦKE5ڥdO/wpɫe+^P:'_\ƃ.D܀<5	28V\"'+c/v25:/>AID%G-J
MO,RTVGX5Z]\^^Y_``ambccd{d?dzdddcba"aJ`^_^][@Z)YXXWUS Q5OoMKIGEB@><96h41o/-*#(F%" hWp
^elLdHf#-61.3\ X
tq$'% !;#$&(9*+-4.Y/01	33R445678999F::=;6;::X:]:::`:9#987c766*53210/+.~,*	)r'%E$u"_ 53VuH
	C<SX/(FDd'n6r|X=uߍYHވ
[ `iZY֍765eо3miIUˌʩɵȿǾub˴Fⱖ6/ƦPC뚝2ؖ z7ϑ+E3Sq-7
0HȜОqYH=ƈ0\ !
	 M1$(,05:>BEH4KNkRUWXNZ[]{_`aaaabcba	a`0`*`{`a`_^L]\[[ZXVTSR9RPOM^KI:HFDB?<:8t630-~*'J%)#j khq>{o&-^OV_{	88BeIW"`$B&C(*9-/g12,4578':O;;w<!=>>?????@A.A@S@??r?M?>>C>==}=r==^<Q;S:99d8I754210/.y-}+F)l'%9$",x	BI"
z@N97-rP1eW%)UiX\qp{7+~(\568ޝcnwdˀȷ%%fû382`宺j㥃Q-T_kȌ>zƇUWxՁ&م*ĈI`V/۠rAkdu_n݊a
T%++1@6:F?CLHMPYSUW/Z\^`abbUbb*cba`^]\F\ZXVQUTSR2R QmOMLKJnIGEC|BAKA/@>;987753	1-*o(&$h!-$?6T x5r{pUR `-	xJT!$	(Q+.247P:0=?aBDFG*IJK5MN~NNNNOOONPNLNNNNbMLLLKKJdJIH
HGGMF=ECBA)A@W>V<]:e8631.,B)C&W#y h7
L-@F{shHo-ym4u}F;a#1x1Ud&m5ׁIϣI|ѵ7.УXQ|^ː[􍛌]]lj:̓̈́U1 F6LҒn>aDTϯSB!֍sg9Q %+p0}59=@C_FII:L:NNBOOPLQQQQPPiON(N MKJH^GF F[ECBA@&A=AA@_@?w??a?;>z<:f978h76L5e30.'-+)6'r$v!v@X

R	E".Z
:aK>"@%U(N+/.J147W:9<=?FAB:DnEeF0GGIJJJJK-K8K^KfKKJJJK<L'LK&KzKJLGMMMJLvKK;LyLKJHFG3FEEIC-@<9w7530-)%# r
( H3FAkt aun!q,
A^v
B7j1t
lQ HGgKEIܩR5ϤW=elW0F2@]AޢڠdeaÏ3ۇfJ)˄P.Mӈ݉5.&g矉4˧驯nN%ŲִW嵍W}ӹ"0Z5<lD1'
IE"7',?297U;>?ACFI2LLL]L@L$LLKJ[I~G	F7EbDB<A?=<::98s766789:;3;;<==.=J<s;:.:9J9"8C64!20.,*'#q %K	Hifx

R[
&r #2&~(+-036H9;=@BdD:EEEFEEEEVEDwDXDDvCCBGBA=A*AFAGAUAkAABCDMEBEEF`GGGFdF2FhFFEDA?<);}9730-7+(%"IkQ~	Q?`Vb
0tf}n/



	 ?uoCSq"2F$iaquwmښw<fɾ4r<r2xӯIHѨy_=vQQ3.ab55Sf,q<vawpow4]]ѮǮ
ׯ5֮¬1ΫE;ʬˮ]@+ݘ
	$h)-27j;=?@BCD{DB<A#@g?>=<;:999V9838E88x9J:X;D<<=4?@BAEUGHIXJ"KKKJHFDAv?*=s:!73f/H,)&"2
`
Qq)L\c!B$'),02416B7}8:;><<<<`=>b>=<;:987=7667789v:;=>k@BCmECGkIcK
M7N	O PPQHRQPONMLL7JXG`DA?j=q:}6326.*'$!NWg -^bb#NEu>
q)	HV @   -r]C	
	O
	;&

r
8:	 F3WeQX"cզʊ,q5Q"_}׼軇,O-Yfט]pHnaӇ5a<򔵖헗Bi;} ]m#L\
Ǥܤ{b5򧀩=}p~ϊ2۳bpZ<u$'*-03567t89;;:9}999999\99:};<A=e==>7@OAnBkCCCC~DEFGGGGFEDwB?k<+96e30.+(%	# OT%_xJg "	%'E*,-/024[66666677k7667768;999`9*9 9Z99p:t;<=?iAfCEOFwGHlIJKuLsLWLLMM!NM{LJI9GE$DA>;>9{76541".*(''%#!!!###7#"j"x"["! [ e
l
	]YSi!Ko
EI
^bmrd/yo
.a
@
 RxGd'w?{2k߶إ֯մu\Мι,?fw9ȸLt75@gA%䝋`p0ɗpꖚؘnɗOTۗGk(]EܙȚ9l1娜
/Sr]o"~*ҵ~¥\ݥ+G $=)-/424?68:\<<<;A;::::o::::=;;;X;R;;<x=$>>f>{>g?@B'CDDoEEEEDB@>;98753l1.+S)n'%#Y!H~0]Y 8"j$&)
+,X./1|35166&7r7777777M88q99999L9848=889:;6=>?AFBCDE<GzHIJLZMMMLLKJJHF.EC\B@>)<9743q1/.J,w*(7'&G%6$"!    eN"$k#+w
$S
	C5o04e	m
Y



,3
,
+
	4 ?@$p(nESr,ؙD4>X΁̨)rǿ۽)ٶY[2hA+ۙɗ9 #3Tљ2ԛHSMw񥔧̩hݭE6հ2Ĵش״]!X=#mLČ|OrH)"&+c.3001k3N56x7/754g345555f5579::_::;T>@4BPB7BBC#EGHaIIHpHjH+H4GD@<N:8i75&2.+Q)S(Z'%\#!x )  k"y$g&')*
-/1k34-445'7777_655543*32H2~2<3"444t4W44C5X67j89Q;=?]AB D@EGIKMMuMvMMzN9NLJHGGPG/FC@=;\:O9#86420/.N-+)(&&J'N'&Z%$#}"!R <
jN0
G
H1	(5Z:
eh
m
R
rR
	l$ wDnQ%J%0؆ՄΫC->9ԺѶJClŦ!pntfUҟ⟞6Ҟ9蝣mA$
ƜT
jޝϞàG˦->M׫"^"Ҵݷ=·з01۳~ó>+޷]ѻn̒PأݕD\=
D/ "$\')+,-9.n./2010/..i/13<4|446m9;o=F>>?GACEG,GFFG[HIfJJHOGEDD*B>:6320/	-*'&9&%t%$$h#{#o$%&F'h''(\*,.q///D1A3	5543;3\33d432#0../,/=//../1|3444$5G6
89:;l<=]?TABCD GHTITHF#F{FGHHtG9FFHpJJGD5B@AAAS@>Q=;:':R9}7C53M2x10/a-*'&%$![*s	

3w		tX	
	f<+			O	VrB !
.{"!~HHIeيJCtʿȲl~ªxJQǰ<
+:BcŦХ]%OC񠌠cHǝbݛӛr|ġafuVYʬceܰ^9Ŷ4^/)MA[u(t]ۼxf6;rK#YD
)!`!#`%&'()A*B*)*>+,^--5../L1,4m678:<>@wBcCCDEsFFHH	IkH_HH;IHZGD;A>R=;8H5A2/f.-,g+)((L('$(f(K((i((+)*^+h,,-.I0182222$3332.21(1O0/..e-,,,-b/0123-568q9=::< >\@*BCtEFG]IKMbOPPQQQ}PNOMKIiHGGxG:GF}E=DFCBAz@>P<n:97653200[/,.[,j*(&$"V O3o
	$	to_nr^^Q<! FQ'05MZ2&uACيןՠӏ[̉:ڿgƴA"-6^`@(ϨXŧRCgS~J렵U~;u;Ч|=ε?8иqWк͸׸ϷX_r۵EWxкäȇiq'h	 "$F&:''%((()}*m+S,=-N./2W578: <?A.CDDEGGGGHHIIHGGGG'E/BL?.=;9741/.-.-+/+a++J,d,,#--.Y.--./]0a00x1=34/554C3H33321000r0:/.--U.../135R7]89<>@tBCEHJLLNlQSIUUU1V1WWWTRPONLKHFDhBL@>]=;:K864f32L1-/,*	*N)'-&B$"! <Tx4
WPt5$;   v  :wh O g$rSeM	DfFif+݋|۔r<[xhʛS ʾUYݶF̲ݮ
f٬PL$%wxeɪ(s[ʨѨөͪ
K}ĳD>1a
LF:sIÒęÄRÂB^!ٿ,FidS5ǖ10SB0
S:1-!")$%')+,-.01W3
568M:;<
>?{ABBBCEEE.EDCDpD
EQEDdDcDDLCB@?><:h9
87654K43333032m2P2/211i10000000N111P1=1U1=1090//	0S0z0B0001235Z91>BzEFHKOQuRRRT5VX.ZZ5[ZYXX,XWaUQNL@JfHE<B?J<]:875)30 /t..,D+)T("'%#!;Z]YK%\<
	X uq$UhB*vzaG5ZCl!!K+Hkߏp<ٶ1jGιcʨě~M6ϸɷ׶DY2߱~_
Iγ ,Gʹشm|#wǱYML:YGزγ>F½?Orʌ
ΫwX^δ͏;CmpǛqnǅ6ȹ2ɥG/6dш҈|RDظ',ޛK+Wy<L

, {#r&(+t-0:23456w7o88887a8Y9Y::";0;u;<<<~<_<<=>k?T??,??R@=@6@@BBlBA@???g= ;9h88#7i5302`10&0b/../P/~//013b5m667y:;>dABBwCEgILL!J-INJK7LKIICJIeHFeFLGGFDMC4DFFEC\BCD~EDCDBB&C2CBGA?>><:W8642/,6*W(&%B"W:m
{

	U?^(,# 4Vx	JcW:4* Uܫl"ԟJ"&ͥ#YvʶP0h|ǥG0(
m0QZ*ҺjιSºW񽌾`ãvXWƫ/Ǐ)iɫ_vFPΑΉF^2һDӣ4Գb֊ֹhՓ=ՑՈ֤1ؽڇ^|ܣݣބ߈.N5e|~o* Tg//
;"
Rg n"$i&]'((5)u*+,-;../0+1i1 22y3
4}444q56667V77S8888899999:::c:::g:::?:999":1:999:::;[;;;"<L<<===>>====D=<{<<;A;::98@8776543W33221C1040//I/.-.-,&,+c+*n)('&%$$#"!}wc
+
e
K
	ZZB " Rh{$Z$%k=+y#
I0b}8ޑ(܂ ە-ڽbط؄B׬ׁFmՎCԅԋ;҈rгWϓυϨϲϕ϶#ж&DѲdRmԒԊԧi՟՜ՐՖտճ-ւ9טgANNZ܊gie%%mX|Txq+f3I<ay.rbcp< uD
d;		x

p
<F4C'U[t2  !q!!""*#s#####$
$$$P$x$$$$$$$
%T%%%>&r&&&&''(((Y(W(r(O('r'!''3'>'&"&%6%$I$#""""E"! t V : *  x3Ji/OOP>i~9qffb4o

e
wV

v	EjEI3\k {  igv5S9e>xEi+Ps!`^%Y+v;
CuU,o2pHslidaet2St'O0f%KtA~&h/tBmVX?t
d9L@q8 j_Z5cu@CvB  ["' v!qzV			
s

>.



]
8;?zX,pvvAWOZ# B=qhkNCuE_b mGfVicH$h}{>2
6
~j<?
h
	R	 sM{06oid jd~]0 j*cD9%      _ 8 - 2  Ff#G?a@.l#ON=o>
p6
zjykI0#
 ""/8;5!1EHEFE9& 6ED<E`?SSF8?OSYc!@sh?'rDR_P7X87MKO|@AmM i  TL#B[gh\NTfv{fkM(?y0_=ScuvgI+RRB?S~-WZ

EZ@N }cA9-3lN9fKD qME,.  L  x3a5bCuN/sXKLO6$.8COcyldozgRPN=#uh{           
      RSRC [remap]

importer="wav"
type="AudioStreamWAV"
uid="uid://dbfnyx3xt8i57"
path="res://.godot/imported/w.wav-1ff26c58e87c7a441a49abc6c5d9457c.sample"
             RSRC                    AudioStreamWAV                                                              resource_local_to_scene    resource_name    data    format 
   loop_mode    loop_begin 	   loop_end 	   mix_rate    stereo    tags    script           local://AudioStreamWAV_hec64 8         AudioStreamWAV          nh                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          # / > \  %
.7||r[T8 rX     `p  8  % O~ PZ]k=5]]eE f4[}Ulx:H0}[D5-Bz&}I7g~4ud|*3mh .f ; j}5 !-\
:
	c[W6i+6T   !]"f({p + !u ,pfm'<5GP Y (}mck?,4
Je6vW-Q>O~o A D    ' 3o$:
[.s % `P =e!4l?\n}p:GUvr;~_s	I%

p-3( Q><	.
H
T
;	VM\@V~t	5
		qz
N

		n	R	j~gQ&sGcQz- j t<c[p\s7WNryJ'7xLBi)aA#?H?o H"~aJ 2< :.
%iM X   J _jV; O8^P.yh]_C-,9
g{kyl@cO/"t&vC2c  .$zt=x(|G


0Shvs g2H^@Rl!t&8t\$[s	]
N	KY	
j	4p(
<
)	)	]OC<
z
 	rg1-WRdo gu 
3R
(_l u9
X ~	 

		zGQ$	
< E{Z
B
u
,
>	F>D*F	>$	b

 u#1w

j v	22Ta#)] t
 3
Q	} m2f1d M	`v3
5
  Qo
VX 1	WYS Y t -=k /zj bYnJm=|| RsfoLo(fC E9[j|>lx.G &g{|  ^_bW"Sf!'l IPYk4k+3 ,?,0I)#uy:Ypy/ e4r,wp(Xj0>r1W 
8 dzx
-t]=2hyDcR aK'N	Z
B|&TWt~ e 
'lL	q$ 'Ed	u=iwOK ZN ?dK A	ciZ`yt`
 
Xi J1Cje 
u	_}
i
O}

o9O2\J	:]7 c}Vv{9		M	]I $)~{ cg

p<M
%u	k	(
mPw^BT *aT ]"	H\ 
e<d?YKX
qg
  	
EM:D4(
V)	:6
1:mtH1d
`V  Q{^
B8B. *2A
kf"	 -N	,hN
,)`	4p  cL	PK $SN j	38Ux
' Q 2^	q&u%$F
%X`<
;V Jar:=,y,fY@ ? E<?  2hUi"
.}7d.P!r&j$-x /V[ aOH	f&4=%X 5tO~
&  7 5?/ 	,yh7 f& ~|n0zIjFJ l p
I 4
5	t(D5 #| oe Nt
HM  M *%  xWq5m<	oZR 	yX	| BO([!d|eh@&RmMaJ\
O( zm,(K .O ,	#;W*{49".<f w2p
h	w	2zs<b	A 6m	na55^P`F_ rL+m	+LZV'	N|S KM 26Mn 
	mU9X 7z]~trj^LvF>MS`o CQ
|ju F #xMjT	>+
	16`|
=N?<]Z0h')25SS~h fyw+fk	iX
 KO : 		 x
r4 T		w
+	; isYZ?
X ^ x	 \	,PIz/Q	
* M	lAj 7
K :RW
kD
nz,Y`
_
QJ
Ci	u{3Z<a Nk fx 	[m' i; q^r p[t) 9l|VBpHGg%	4X)	f
D7f 8
 
h 'K E|c-(Kf{V	 Q
r.S
My" y8X8MD	doH-\ >G[l5hTSc q5n44wrT3ow YO#M.tJ k#:[hr7vQvc 	!R.Z v@q
	 j/`vt ]]@CJQ?anZ
u`!<4[  eC8Z$?/ A8 B/LtU
l
J ^lW Y T 1	?w~/w K
5IjU3e
s
 }pH&e" 
a+('	 @ULs yR)/
	9TE`GJ9AI-~

Ld ,<F U< ~ !p;[	. >O3bCx  xg# s) ) @IBrw	 ['-
`o@,   I(Y`ySoc=h)>	*r k+M'
SHv&-	V
^
[ .M
SRT? },4{)Mu''
}
q$
 
L<
>>3	g>
 d 
! 75KyM)
3K>R  s	r QX]vC Um lVu"4x]*4gZ 
?	q$N '	#	">n m9,
1*  l:D	A% !;:
mve^X'	waeANw	C~ 7

l	2(% $ ZcH!G .V[)	lw
 il6r|w	s>Z{
 f c
} 7UF-tN q	G ~dJf	]sE} Pw;@ 	L	u
c63)	 GigE2K i0  E AI6PwiOdPa5	|8QBlL	=	
0/v
2) oy b

HX 9}s	 IpCHQ-
Wd5Rh"NL
:InaQlBQmyBO$'F	d;+2
	AZO[	' 
 8$O4LU M5txOFS Yfe19p
y Y6
ZN
R>A}nl	
,Amr 3:oP/wFy~	 Om$eAr	z?, 
	wp
SfmR g Yd

r
\ v	cO|	  :O' *$&W 	WGn3)w5#pm.FUh{YF r Ji_T ge7OGG	?ygZ
 xf	U
( vlB-
r1({3 	1
Og:'mG 'QY:
H(9! i8
 in~ 8F?< u
U,Z
	jU*F ]	gwglqdu JH h7Jt6a*	y
V>Q )E	

2
fw}0,{=%Z|
XTqPWT		4Dv/NRRCw ~i &
S7
4
3~t+ ZP`GcgZrA$Q		f
ti%
VRy@"X$  dk sjZ  pAEE74~		
	{
 (;|1_'O
EJG s(I#$
QAA'~X ?|<h!S 
$
Lv~Y	P2	)H	0T i	kD |Ffc
n
XYPeh` 	4:0L7}
- y 3jM3e'j
 CTj* FuL (%i]	p:?Ezj ~T8N7j} ($bZ e#`
,}*	<qwQDN0Ud	b)|K
XK~4bta'E/i?37	6LiBerJ| [O{~qm>U
&J A/ OMf;9A	ziz l~%;'<bU
k,&
g,)g Xe.V3_  03	{@(7 |~ >'[um I6
$	=^0	<NRMC-lJ Go]z5R6Tzzu \=d7nY<\!k'Wi
v;XifqW
Ou3 In;
[e {U1}7	c@rm\/uHmK0
Z	t
V
GN	7"RG	 9R  R
J{px
D	 Z4j{ 	.(o)m
+l %i C &; !E1QzEOoCL	|
SKhJ	HI| 9
%k _
\{$	fe-wJ
u7 Yb!t 1xes
-.P	G*
 Hgz@L
8 P	dd Pn
Y 		Bdpi6w
1V
&
fyD^) _lv
KH+	4 X U>1)N0` Hm
g	I ]wz'%Af/kxJ7
xw
9%8 T,.
ET+U	

 ,l,pT= 	!,g$r1W	Q?Gw99=1=
 ;2D$,#ce8!qr#+rTGd(_0	 %:@`+ 0  
tf1	vq% } _	|	
\s)xyX 5VV(&~	8Zg
 3xQ9 >
Z
f; >U-	a  "+MY 4c2
EB3+
A9yC
%V		,w 
$k
>.(
FuwuZ)I
j
 L<c!Xb	 dh57

R  V Y [o_{U
 U1;
Hu~	2PSk	<.	L
KubE#m82= mrYz:
 
RV&[	q,c

	CKZY	e+z/~

	#sxQ
|X Yz		NjP

!rYI;T 
	w93 3 cSu

 @
xq e O.gh	 F _	L^
U7aN  s=Z}_
qy3_ 4Q ,toz9 Seu
6V=
7 O.
 T
L ;.Fo  `	Pn\`	?  !X9*

u 
t I;)	
 Z[3_	8
vb #2
+$H>0+   >4v_m" TheoD({
d [ g*,	r
 Oo b\b/+"*G)!K0sA`O
v:)-k?5n8 2t	l~
*nb$u#rvjyogQO4@!	NMh-,` 
(y
3'm =OOS
(nR
kRL
!A =,w37
v~X7 5 
27=7%v V
	 '
-
 Y?;o
1e ~ruq <aCp	8} 5)\M
We1X 4D[Tmtp1 w6	zAl
m.mk*G 
e~3zS2 Qk$WS0  X9_	b@ -DZ

zS	u	K$
@
Pm
; =&p|'"	lHs
#("RYc'|A w>	GcnS	s>X
KO=(UP1cw
=y@; 	
,!&hC}p 5

	1	xJzG{[l_F(#[CT2[O
t)G p 	l`-GZ= 5h[ Y
{V kKl?jr?rPdWwSBJ`m

 lO	*	Crc4',| zI,	G3_p|	 2=%w&j1p
$jh
#-MsZ2!	^_ g) 8 N0r$	AHn$A[*,H#}t	 	L
a  z0mM ) aWTm r "
X9, u9 0
xlKR~\m
F	B{		F`nMopq\'Kc
HwZ 
	

E1
^b @a(6
uaCI
d" 26xq	
r	~btDJ=i$ld+#9  'G^	
 ta	OB@
 

3 a!K0	h~=
t5OUM7 	)Oc
E-_	Q t"
`$@l)0 ,vrPEH#  N$|~g"vD8p6(l U+I$
I	
Rh	
Y`	4~{PZ]Y-h yQU
n	)Og0]
2&GzGVjm/
 n= @nu]l;n6P] Wwf	Fb[9	`7bi9 o	7a,
K9ck
$C,~w+!k pd8|B U	zgsC
SN	
@Q	 I  !OSI= ?  74<Xj

s [w1o5L' `X2Y	kq	y*a3zH
*In!
-S{?xKi6.
mu	 JPP6W	'N| ld
8_9
\|b.*&_r(c  /	<	m
j/ uA	/Ug

9|NW 	 ~q-v
v
G
Kb
[@# IR Fss ;xw9gNQh "	vxOyK	\ghlg<
	pm. _x 6 >gj^kg!.	)w	^ :=2
#X?* N  &r`"26 	 	e
@nIqb|7MEX!2c 6wmel gET%a OLBjw
4v
p$ X _3	 TG
(G0  	=[.GLc h~Yo d*&Eo<yP 
-PN	_K
1|
"u 	]On	
3  		gI
j<m)2U m:
!R !X+
FX
G8N '
 xNTK ~dw}
a(Hs MS	B	R2
G	1Y]
MB\
8M7!}* dK btyzX6 X?%(,2h}	O	kjL%X _ _w	 \X|3 i  RnV
Q4
6c#'	?pD<kL 	sbZ
!X
T=! J'0 =WJXH9
TJs
\
 e`kU59
Uij	R eMX!y 3V~ [g	 
QhA;F q	wZqL^{ [5K (gpOh
M*& R
#8C m D	QZdJ[Q
! 
e_FTW <kQ)aWK h6$	7j d 9rm9	n$8r&
7
t
\@BnXj T(	 Mir
 m?
Q1a Eg	u# eNg *e T({;J 
o!3 "L ap vi-	
BM9 NU
H }h9'HD! ja9Y G~:O;# VAV, wW Y

t	g R. 6S8 Fc
R]Oqx3  VLx]8 Uim3H{
r
hI58.M	^u;8  *M !`[
0
 ;	}b]  R	$ K	w_n  )B	H

 bOQ
/0
ID([5yI{"I ~z>(Yi-c gm'7	-4 "{7
{6
li3 {4}gjl:  Crg~|jW^mYu';eS	  ^,o<	c=
xJ;t	Gx 
pR1R[~W$;vH 1	? 
95?4` 	{53`JD#W7
1E	 ubd	O
~5 *Ug 	6	*_~w8 NCJ= s8 VX V V-o
02
f-UyLKl

`d>` xc q+    i3U?	
*fK	% .G!	# 	]]f fG|A'4XHL~Lf3jn' ^w`,=iUV g-YeTy M uq4\5NP |L
G#oOpT4<	 &o~03x
#
 L  8wp g	 2
g&uy  Wy
a.E\+nBC k S  cx
?@o}ML- 0@|"s- (j<sS
Z
-"9u 	Ku	n
N_ 'X hC1#"0pm

Sl6,
"  0.ms\.9 JXj9- W	B
 ,<t&	
X | !bT c,-W9+ )ClJ3(
Sr$8Ymx
-} {
bC 6v%  Y!_yLW 
|GwL@ Q10 7<7n0jFPY	L+@ 
K$Hdn$,!6E
Ta
O"

j	vg!}S| BdyCWb	b)	U- !U S^	Gmlp\X! W
Vq ?lKM?)yT -=]( 5lU|Do6s Z ]r ? 8
w mT  I`CU k  N8A 6^lM/
 U#ITMeg@> Q1.bYNh@qn MR*@]pc*-d;[slvwvZNe -i }I [LTF VO*#m1+d]qzJ T V		,/mf9q]nmu JrF
  )*o	u|/F hJ   X ?`'iw 2v |a 	G"'u=XWtk"
m,b_ # 5 y V+v+-uRUM%m>)UdXex"	Gw	<O(R#K {GY')]0<#bJ4 7!Z   EaS({/ Ub` H$ :
I {)9 4S$.fA<,/E o  =#(m) =9J?^CEh  t
u9:%*O+6	Z9$N`BHsJ^m*fkWL\N2  )U TS 8vb 
-K% >
>
:fg	 5D;kO(F :{Cz4 CQCEx+f MGMD 	u8cB	 vN T/I
KU[3x6'  G82CD TQy5]0=k}	=F' 9 ^ GWC}Hn=M$/
 EE) 4qO 1 5 }5MCnS*m4   F '
Su b!I^o&jr#  t Fb y	e v  ? ~1 !, &]
$ <3g89  7 8s%(
$^ X*H</| QRuX<T	j LH]2 K/a
:]S "^5	 F=hCPgNt ^&OP`+ @-cBt{W^5 6Eu T% \	9kj_YT )#`@K69?g-L	JV" 
7#WL&Ccf> A\	 ! G  7#  ~Bcw m !=V|r; Sl/kz "7Xc C3n;X x jb   yN  2 } ~ ?) <. Hp H#~ %9F#q	Hj!  y 9T  ! iyZV
j:YFks 7 F-pA87iA)8N c7$y	2ow-CBc?CVG|=R	UTH=- sA  t  3J{'  }+ ;N @ >B 
  
A  l4ckO 5q` +P  o%^d= G] Hw_1w2  ,  n -g 4  k|   i1aW Uyqy           
      RSRC             [remap]

importer="wav"
type="AudioStreamWAV"
uid="uid://bu0xsd7bepktg"
path="res://.godot/imported/x.wav-e4ebcd08140948e5b1d24bb4b7d629fe.sample"
             RSRC                    AudioStreamWAV                                                              resource_local_to_scene    resource_name    data    format 
   loop_mode    loop_begin 	   loop_end 	   mix_rate    stereo    tags    script           local://AudioStreamWAV_q4333 8         AudioStreamWAV          `                                                                                                                                                                                                                                                                                                    }wod\WTOG?94,
%9M_flls " 6 D U \ a l |     4Vy%Tt69;I]&*%/=GYhwm`ZI0sdQ.qR<%bLEB.    [ '  rImZF!yI%~nV'v]I1}wcL8(~|m[bl_RCEKQGAGNRUMO[lww{#&%3Ps~|DXl/BTn6U`Mv/Mn& K d }     #N}Lx$"1X(|-Rir|?v6d4AX	N	r								


.
D
k













'=WM0 #%	









f
B
-

 
			m	Y	A		yC_1	NGU"UTb#  $ /b I^>x#y4R m_Pc+XX^^*tL?lBshYD!vXPD mF-}I:"2]fevzW868>FZr'Kz/m*_P}6
lrC Ljo Y!R	b[0/6 8!E"v#$%& (()*d+
,,~-...}/*00l11V22.3333;4y444445544G433+32l221c10q0/;/w.-,,M+y*)('&%$#"! xR-
iG
e4
	 9h8ra:!hSp6ߢޏsMHڷ ٔ؏ן֒չOӃH"Җ4dЕПG !νΑsW-ͮͮCaβSόg[љсӽ8ԙժuׯU&zܪܑy/2oak}v4
d_V!e$%;&%$#!Y"\$g'*.0l22
21$10E12468k987y64311a357
:;<< <+:715531 10w123=4L4320.,m+4*k)8)) *m*>*G)'%k$"Y R.[yb5/s4<\

			
p

.T
	>&C/^hW
	2	?	H	0	k-;a_mc\bx 				
		f	]NVp%xtm{  hfd=J7il1vQs\Gp)2Y!Lq^ߑސݝ'ۧ,ـLPXWW@ӜP[CYϏc]eϑϽϽϐDΓ"ͫ͵͹͟͠"΂Lϟ av^XЂы&ҿi@ձ-}vG/ݟudI-,1
.Hc?r:Ka=	O

\PV:kp"x  "#%I'u()*+,8--./0123W44_556q66Z77+8{88899889Q9999f998876065054P433i332$210/. .,++Z*)")((\'&%$#"5"!!!+! i Z?tkf{8w)p5V`x|\|X
'a

0
		71J~JF  `wiZaa6
:n 6C[ގ,Lkٓع@֛pYӻiѶ^c͗M̦|Jː.kɐdfɇɟɜɛɵɴɟɩɫɕɒɽ
?ʊoM̠IkͬxCϿ/мj/}ւ{`8NX}aQMw{L
C/+
H/` K9RT}U!#%')*6++,,E-\./F1r2 3?32100g00X1246D8:999O9X865322S2e2334@5G54321T0/J.---.G.--,*)	(u&@%$*$#5#""K"!Y!  5R6-G<P$D69V>e

Fl
	
<
hE]H$
	
e5u
L[)
nO 9
C

j>2zk[



w
aI
	/	1	c						?   	4K>*97v>nb5%Imkk݈GY]؁׻xNӦQ6#!MΧͳ̈w;Lˬ\ǥzǖǿz-b)ŀÖkSE5QÇæÓzÁW3WÖÒíbhċ;TRe[ǴRȵ}
o	ғBԪqմP\Ch
Go( qe
oPRU !i#$%'(*+-/<12Q4O55O6667?89A:|;<=>%?????=@w@@@A<AnA_A!A@O@?5?>O>===Q=<q<<;:988^76543)3#20/.-x,+*C*)=)X(I'(&$y#! ],PWQQ}`ZYGNaS
cE9
jz?



?d:s
P
O
>
,
$
E
t



.4>6





F
$
j7





L
	L	tqWZ5_ 5c=ZsDsye[z1!O2}Qz0e׍ֱjV^ѾaϾ!Γ)ͽh!E0ʑɷQs#ƸpƕY<ĳĨĉ?
çÅÖ
;oĘđ\ ĵÏÖöİĥŌA8fȊȁ^cȶlsʌ˔%όҏӈղq(߹SLo[Z]c	k Q b#S%&(I*+-J./[13456789:;<>,?m@ABWCDDE$EEDDDDDDDjEEFEPED8DCBAFA@@@p?>==;:/97654322H1Q06/.,+S*)'&%7$"! V;X04V"
b


		_D
.<36~LH]qx{6{V2Yp	H			n

1	'Lhy
z



~
N
	
Qr
,
	}	2	Sfd?+
\ e )?k8zAq9!\:p%I9i߸:{4ۭ/ڕd׻sԋMҝceιb N̡z\Ǿǋ^VQ!Qƥjd}aëøuü(nYX1H]ę@ŧRֿԺwCգ؆'1aqb 	[
Xg%w "#
&L(*,./1D2"33g4579<>@BDD>EEDCC?CCDEGHIJJEJIHGFEfEEFFFOFEEC@Bq@>==<T;:1:b9_8;754321Z03/.,*W)'/&$4#-"f!  K?Qd;;&
$
>
	r	W		Q	U5s |E(7n: 
ptT		
E%

&^o^I0vrk!

[
N
	a	 	> ,  _ /5*!Sv"&3X2cޙ$^ۚڻ>Ջ}tR3R͎̥ʗ$ɩIǢ#|mş0ĭ@±R´B6Vr濸p%Xh
;6&SU7XmxCϵm	Дγe+ݳpyL
c~ e5mlk!8!#s&(*,Z--./024a72:<?qABC(C
CBAAABC}E0GHCJJJJIHGEG
G4GG.HH
IHGqFECMBA@??>/>=<;b:998655(431%0g.,*(s'u&%4%$$##!b )
!
5#S6
]X


	'	>	z	x	-	MUdr					Qsbv
8	
.;5Iw#
e

DKQxW,8{9C[
B&





r
		(L5  v4S(\db{h99f>5Obu߈ޣCۍ_HG׹ kտ".3h4ϓη͘slf˴!hȷǭb	ƲŠűŒMďFØO<\2S]þpoݾ>Ǿ޾5vYʲiΝIjΑ<|hْރ
 y]^ |

*J #E&(+,d-../12-58:;L>ABCDDtDC
C4CCDE}GgI'KLXMMMiLKJIII1JJJJ KgJ(IGDFDCeBA9A@t@?>=<_;9b8c76l5#42p1/ .	,.*(`'j&%$$$##! CLSJT#=	
	i	c	X	B	f				kiN:}i8
?
L
5
'
K
dOQ72IsHt.pV
e
	
b	EW>v^?bu-@`m+۞Q*ՎC!.UБp/e}ˌʗɜȐǗp<2ħēs.|åbGnO/()TJ&¼g!x2&S"eâf>Pҝҫg3:̃ʰէږJn"Y}DGb^ O

56&#a "$&((B))Q+-
/147:a=&?@|@@x@?J???@mB4D3F$HIsJJJIHGGFLGGH*IIwIHGFDhCHB;Al@@??(?*>$=N<n;K:98:7u6^532P0.-+*)n(('''}&%J$" >M">)]=XwZ
K
	<c5[Jk}"k;XIH :	hR!HLd	
f4TJGav9H6-



V.
	HPFQjS\A M=&oML 'Go}/߮h:3݋ٞHFԵkcq ]wѩ5όͲ͏Lch<Ȣ/ƫWŇLMÌ.§I¦	QνԽ漧ź(^ĹalV}'ɧȋȴǪg+R"5 "׃Lv۔<Txbh.+
f
k_@3  "$&#'1()+-/f25Q9^<>@<B:CCC?CBBC\EGH=KMfOP0QPONMMM,NNOP*QPPOMLJKJIoH8HHqGnFGE`DCBAu@k?>=A<5:886421/{.-h-,:,/+)z(&D%=#!s^NoH^ru





A6	X 7p	-3	>

LPQj<

Y 3S*{2)u(nm:}
,

;	`jvK  
eH#Z/.dްݛܖۙڟٱ	@ր=ԋCҥ`/}Τ̔"˲/ʪQ bBp.QĸĂÁ0í2eu.俆v9z{G'"	߻-.Žȕao]yyEg~4f{E	ޖ($TRE2Yfi	dn!$s&'6((*+-/2t6U:=@
BCyDDDCDCCDEG
IsKM\OGPPPONMM"NNSOPPPPOgNLnKuJIHGHSHnHGFZERDCBXA@3?>=<:8
735U3z10+/.W.-d-,+3*(&$" 9[s+GZms0ln
/

cc
@

	+,!jmD				f	'	xWLE	t
!b
i;wm/
,
X	U1F	 eBjYJC-7JJ8[<oaL&EحAW5ՁSңqξͶ?̡6	ˆcȭǟ)Ưh@^NGorB@feM]B从.κm"ηbIq-ȉ9gɚFFotdÁ`AM9C.ޛ'^[q;e	m)g [#%W(g***+;-+/)1q36m;?BEFGGH^GEEEkGHJL'O5Q~RgSS
SBQPOOO8PPQRR\RQOfM!LJqI8HGGG5GEHDLCBB}@>>=<;86s4w2{0.,,+++!+9*(^'%#i!1JG<{

RR
s
T
~	Nd	&%XGGp35	Q	h	%		Q	X		u
!B9?ok
j



d
Nv


a
a
<
k


@
w	pr1O^  @ `|rz&[Q!g\|V{mC
S=`.۱H&5'm*tbХYξ8ͽTSmʶɸSǹ[ŻĆ&¯d#k$;񻩻Iٺ,'LǶ^yv	qڵ 4#OTH`;	ƯSV;É̝Vo ݕی(ڱ<$ex&j
T"t&)+I-u./V13469<)@HCEGIJJ4J[IH1II	KLhNPR{TYUKU^T#SLRQQQ2RRISSSRKQOMnLKIIHHHGFEDVCA?#>9=d<$;g975420.,+ +n*)(''%d$c"2 v"^.X
u

	4oNJ:    M`V
no|~K{4	$



&
)(j~p
.TQvaIM5
&
Zi
>+kiZ X4LykS'/d9ӻҿ ц<1Fj́b96ȲHǪƤ7ſ4Ĉ"X６@úw6a󸦸2̶]4d$S~سX_IưA˲ƴ7\Ây,ĎLT"!Y*Nm3ۻ!;߀/ &K]Q7"P%(a+C-`.///0K2(46j:_>ZBEHJK]LLJIMIIJ"LNRPURSlUaV;V USRnRgRRRSFTTTSlRPN,MKJ IHpH.HuGIFED CA?>==;K:o8c6&41/s-+`*)x))`)('U&$"+  "<^U
\


u
	s=Vnx  ?5	 7S  Jg%)B#Z	=


<S
+
"

RJ-EV37,Z.\D_
S
	"m8E'  cR~?
/ޢ܃-׈&Rҿ ˬʶɝ3ǝ2{
Iֿ|C:Irhk%𶻶r#$i԰1үίɯ1 ˱Z5](H\§çg
Þʪ[שڏۿ<Bנi2M>)R =C%
| $R(*U,v-,../0259=BE#HJKJIH0HGrHIKM>P8RST\UTRSQPPP[QQRS"TSRPNL/KIH8G,GFGFEDCBDA?=<Q<;9:m8p6g4i2(0-V+)(({(L('.'9&$"X vu'
=-



	y^no?$DQ5q` A 0-ALA


|
;
+

B

cQ
8b6,^5I]xslZ
F
%
V	}vx $ PcU\kt'{	0:ۄڝ٫	ռԄt҄{~ϯjnAΚͬȸXDſS8C>f׿tнyɼO 4xwڲgԱ@^9neοXL]ێd8طׇښhr`->p	=g"!R%z(+,--.`/136):>B^EGIItIHGFFG{HJLNPSTTSRPOwOOOcOOPQQTQPFNLJNIGFiFRFEECBqA@{><;.;|:908h6f4P20-c+)a(']'<''&&$" lcB,+{x(V

	X	D	9	]+
%?{ UwO+t0
w$

x
]
 N?3B26+	8
"

	I	"39^e }Ca:kt	)5g& 1G٥Sק4JXW҈ѺЍ-Зfu4
9ɥHtbm/:a$ÓHT׿9L^׼.FߺMWƶ#|2:4*̶V&ğŴھz4-['`6
 heR&GV74 .	?F $'*,---.c025>9=@CEFNG:GFFE)F9GIJWLMhOPQQP;POONOGOOOIPPWOWN	M^KI4H+GF?FEpEDCB@)?u=4<];:987|64~240-+)(''''''%i$" l2'jyMI3b;
kK'
^
	["	>0@s<0:B	{
[
<3S
i*




QDhg
*sjv5TE&@HP(p



y
,
	oG 'V}{X$w}5f.gߖw^$ۧ7}ՠ8>ӇҏF-̢z˅lˡƧŧŹţV ţ*|é)|9־GҼNջ4޺Ϲ(bD\Ҹ=&uuSuJmɅɂUƴO-sN6u&pB~w)Wi3[gu t#&Q)s+<-.7//07247~:=@oCEGGGKGFF)F,FGHyJLMOPoQQPN|MLjL5L3L}L-MMxMzLKiIGFDCBB2BA@?>$=;98727Z66531/-+z)'&%q%a%f%5%$7#e!hzjA&bQ7g
{AG
	czT_				nq(6n	
?
	5q	
a



(

4
	
'

FfaJD?_
e



I
.
j
q

 
	*~@+S|?CL!p<
$RoQb:)Nt}r݇Nڋ$ْ(hձ YѺѸщ6б`YΛ(ˌˏ7Ɂ*HȑW~şQQo0éJ\࿰{ֽt1¼T&'*-N<fISͫ:̱'~҅׷ۯTQ xw I#&(+-/M12345P7M9;B>@BHDEGiGEGVGG?HHHI]JLKLMUNNMCNcNMLKKKK2KJ$JIIHFEC.CrBA@??3><B;9+827265	4"320^/-+))(
'*&\%$$b#x"[!ds%s

9wc
~


			)

:
			

*
3

r

m
n
~


`
m


K
w<0{Y

:*
u
"
tvz
b
	=T;mk # P\;&_Ln36&<sްa6݌2٪ZصQ}&WԚӨSі*ѩ4Юf͖́_
͠@˔"ʌfc<ȿz$ȵ@lēWüÀ<«p7]LA7+tƚvȒkn_#ҙupO;|JU 
s
F_ =#%');,.02346F78":;=!@(BCVEFtFFFGnGGGzHlIJK=L LKK'LKKCJIJ
JIHGhGFFD|CBAaAy@Z?^>=<e;9d8760542100/-+)\(!'%$#"J"! 
  "MSRl|s	2: L
+
mF
oG3M4
e2
]
K
P
.
'

D_ELA

p
Q
S
]
?
e(:
r
r


c
	f		ix]Me3lz  ;2cXJX$+WES)߄i|d$NخCdռզ՜eDԚ:Ҡ-йЃL62Пh+ͨ,ͳR̻Rʡz_N ɏeN ǧ/žŏ.ĮTu
¼ nq'ő}ƤfƘȑ̬͋ϳ҉ҙӮ+Jړ!	r3j=d,*8	[+!#8&V(R*`,".i/00234A67s9;v<=_?@A,BBCCD0EjEEEF~GGGGGGGGWGGFFEETDCC:B\A@?g?>=<;:987,643%3M281/.x-,+9*(a']&x%$#"!!@ ;B/UY%GeOSj_0YiHGWF;{m*UM
u
C
U
r
_
'
^
	P&+1 adgBgiUk=GK_r>l

/߂޺݈=ܢCܮ,z^w=ּeիgԵԳԘj:!ӏ
z!Ѹь9m4%oРФЄ?ϕ)ό͏̀ͫW	̀̒w˩ˁ˸tsʉ5˺bvτvІѪ҃Eԣmׄ
ڣn8s9QR9
 	2:26 #$5&'+)*,-m/12/456
8"9::;:=X>?`??@1AAABB9CCDDD&D/DCOCBB%CBNBA@(@?>>+=<2<;<;T:Q9G8H7G665420210/v.Y-e,x+g*=)	('&&Z%o$#$#"!] LZL#YlR^sNQ.-#V6_N:

*{C_
	E	s}(   } >9X,Tc_k
[fe^S)1/<߄v.ڰK	cت/֌ Ԗ``dI-( ӱNц%Zv!
ο΂ͤ5͚j:GPx:̅ ̚b0ːvˋˑˋ˧1^ļ rХWҙps5'6}LU1~fd Zwi
]=O!5#$%&'(R*,-/1[3567899w:m;(<<<=>v??@A@@	AhAAAACB~BkBBAA@0@?>!>=== =<*;d:987w65z5854i3{211/P.,+**7)I('k'&'&%$.$z#H" I$*]&'l&
;[_y}6vBU dFSAn}
Uf


	
6M  3h}a|\4<<yBJ2 ,sgޭ$Mmۺ څ%ػL ׮Sֳ7Նө},ӻ]>9ѸјљѡцjQ#Б3ϑM-Pϝ9ЃдОKFϪQ[΍Γ(t~Ш%цx4еЬХt|;+u)зBHY^ҽ%9ҦѸ-a)Ҙ,ф3҃ғ|؉ڥ;޾B޲ޫߟ7w{IH<y+
i 	R?ii !"#$g&'()d+-./Q124667i899m:::::;<A==R>?????????@??>*>=<4<n;:;;::9!8Y76]547333210/
/F.-+*))((-'&&N%$$$h$$/%1%$|#" Y,(*=v)*pf'bg!)VW7|Xh?WGp$>Zo+
=
0=rXs@ S*rA	Dk-97=XݍۍU7'ڐڊ+֍+թ{H+ԬԱ԰lԱlM,yӡӼӲ|Ҹ%ӍJԓԶԥSfFL1EӇV
֧ԘՖՏԣՉַPU6\jה`ש?&tCڭ.ۄ^ܵ1@uwGQ*A"Ov~gr[Af
 
FjFLxd,!#$%&'()P**+Z,^-w./0123555555566"66k77778F8n8P88 877o7654&43c3	322222210
0.o-,,r+*)))6)((t)*+)N('((%e#=""##}" ""##""#j#""F!   < h@eX~k1\@ n0nK}MO
Ma


LZ{ms -5	NHoRN	߇meKܯ)ڇXPَ6@؍ةu/F֊K	9vֲ և4`ւfTֈl׶׍ך(B9'KرقTڱٕgxT[ڮ)ۄۖwۉ#ܥMLޞ`߉ߝߚ?SFRdZE]-i,h 
!VMdvGQe NoQ
OW+
Z
H<  !~"R#?$"%%&5''C(s((()M**+++,p--T-N----e--
.e.L.--.T.<.--/....://0K/:.-..U- ,,B-s.....Q/Y.,+ ,;,+**p+,,+/+*/**)u)(^(((_({'&b&@&%$0$$X$H$#@#""! =N}%
	>1zbLe


	1?`v~{| ZN70YzTL
!1jVvd}BzݽA܅?۱ۉV"8Wkg< 9FGLlے۬ۮ.&ہ&eܛܑ܈ܭ$݇qޫq߷!
~\`8qTVoS~~y7Nc5AKuGi47 y]3_/(LU	)
6M

a3bBVX3j `&q  !""#$W$$$@%%%%*&&e''m(()))+*@*M*j*******<+u++++,,++++++*f*c*l*C**))))=)((5('&E&%%%d$##-#"?"!!} 2od9<{g7^ex

o
		;h3aL >ArU
Y70GT^wQ@A`bo0lj,o
mXQO^xkK\>Ka2giMHC;g;w{iJ&&Q5ZOFXJg=T~E.z^#hN9/+[+^,<`gtlYk6`^ Z  dW  	qT3uA%d~H	jU

p&8'}_t;z@=mxGuUfCNNXqF(,fx~>i^	_
e%S7'<`J28TcY2

k
v

	|	:	F[NDb ^ bD_Z.m9u<+QI	{6ZL<lBX:7n2\EKlvb?
	GwYTkfb6M^zERz@$i%@r#2IM96KVe!kC   .T.KjUPaB7	n		

\*R5

$Jn5[u7GkFuA&<N]rPwypkV15WaajyyZ4{a7dK8y.X,V/Lb6

?
} N
W
			u	K		$m	e0kEw0Kg r  v(c/^h9F\}n?j#_9`.~bL,f6eKFVpE#1Y}


1Op(Z .\	<h+Pv;HwN t@ Hi@f@)c$kJL|+ u  M(k1dJJ4b(hL+					 
m



9w'7G-
S
M
=
K
{




L__r%0 #EO2  }p@

c
Q
F
/



L("  }`7




y
Y
=
4
=
$
			k	7	dV9	sA]$^]&e;i:p=  Q  Z[B%7JqP*e,b/nG.~iJ#pR5&	
%smns!	           
      RSRC [remap]

importer="wav"
type="AudioStreamWAV"
uid="uid://ccm2i4yvf4o1i"
path="res://.godot/imported/y.wav-555dbe26f00c812badfaf63494ed6d59.sample"
             RSRC                    AudioStreamWAV                                                              resource_local_to_scene    resource_name    data    format 
   loop_mode    loop_begin 	   loop_end 	   mix_rate    stereo    tags    script           local://AudioStreamWAV_r4w8n 8         AudioStreamWAV          N]                                                                                                                                                  {uqjbZRI;0,,+!

	#:LUft  , A m      ,7Su5c*Bk$Jr4Y}#3@e+CS]x}oaS?11-~Y%s[CeVO>4J,    i \Erhj#MA\!%	7 S/;>~eJ!MCl pr3cs_{^/&C`S.M%{dn:J/#Afw,)DE|R-,]K'8D  et'Ih	n
9B
_
8iowo\/% ^6y!3/#f6fa#5=6}Tuq#wbC
Zj
		=2ukU PUb _xJ5JwPOg{'{|z#AGmp! T43;)fTf߄-ޙݍ%qs+ݲݑ݁;Yri/*)HNޠ%'D6E E#
qW'
:&h1(Cen`n|5Oo%
?h
D +r.MU_|!"!#-$*%:&S'b(C))*+,-\. //200"11V2222B334!4(4F4Z4A44443333M43$3j2$22D1/>.-,<,+*&*)('.'&&S&[%C$#^#"&"!aVK*P"A /	`	Jdq_* QkntA'#
^)	G^=!!$޷TF@܌ݗާF۳/ۯN:W#ڼ֔ dן֬8BiBO؟֭}p9ײٕ؉قچb
ۈdgۅBwF-bxj<TQ7N4_tS R 	1
D	6%4nG!"^"#n$%&2''6(J)*|+,s,,-y.X//V0|000N11W2q2e2~22222n2n2I2211o10s0D0'0/?/.+.-x-,],,+*?*)p)g)8)('_'''r'0&$$##" 	 >y*q0E@a;Mx
!d\x
	TB	Dj9  89	D\t vK/tPXge/d[IYCg8
IY*޲Wޮ*7܂u]ݻ٦كX݋قp܊h9"|vjڗցړژGNXۡۅABTF ؉$+۠ile'jUۛI݉ceaߪD8uGsgE>  BI B<}gL		
C
jZHljp 2"[#$r%#&'O(x)6*z*+F,-.-..j/0L11
252.2\23444G43	4Z44443j3[333w3221[1>1100/=/.1.-w-,@,++*2*t)(('&&%V$#"#"!Y! C |E ,Q!Unn;^Al2r
o
1
`|
				~8N[^S@ 3 b+7..HgVBodkAs+WU1pPYH/lpW0fd.y9٫޲GյIXX~,g[ԶB%^۫ӥr-Դ=L֓չuPשնCעsOٹ`J[Hݤ[{qmlXm5Hw=>-y	NT	p
:sSST !"##%l'4(:()*.,,@-.
000`1z2333'4A5&6D6D66;77W7X7777i7777`76K6:6655X433B32t2Z2#2N1Y0/ 0 0T/*.W--,,**)('k&%q%F%W$"!S!!j qKS/pIE!=PJ`
n
+
		_	1f+=  OYZh2fYS-f
~Hc 4RSHZdROB	ߛ-7{l1{=٣Y//ߐٽ
؅קݠ3YՉanرTڟהՖLש؉k0֨ZԖEևנ,1$ՏW'3Q{ՖxS׾gذ(|ڭڽvLHKAP=q<'R\cwW&qGfu
 
P,] !"$%n&&O(H*,--D.r/022234Q55I677D88888^96:m:999;:*:9X9'98{877I77655c5F543222x210(0/g/k.O-,k,+*#)(('Y&F%g$z#"$""!!$ lZM70mXi}uqBQ
,
@	`		W	Fb+   " {{9h+_I_NT{N!mfCmw݌a#[p)܃ފeap۰:՗ٹۃM}-]?֚۵x
']-ܩ{Nmժў_ފz!+ԕH>Զ٪oDAդ٥ۘ @ڙbpۅ>)ڴ@=ހ<
 )eޣpn=

z)-
j9+q"W:ijl*2 f!f,u
\q2qeFQ !]!"B%&]&z&(<+f+V*[+.|0R/(./v22}1312443,45n65I5T5576S6L65666-6654444{4	433<32~2{210 0y//.-b-,W,+8+**X)P(@'&T&k&#&3%##
#X#2#g"!  o ]7o?VD3oX3#

A
q



?%mXTh O  E Ez;
\&[	IT3Mr3|qZoVY^P,ڶ#s]-mLPї%|:t1W(YԿ߯U- 0psz؃ےk܇D<ٚӝhԏ+kS7ڳpښOՈٓۅԒeُ׋e$Ngٞ#=TFlܙ޽.*%,ah pv|k:PX9" 
5&2
 6"d!!${''r&'*,Q+5+{-*0P0/|/c12 2i1&23]4,4
44O55N54	555^5445d59543333$322121
100/.-@-,,+*;*))('&e&&&%@$""""9"	!;  d 'XaMH#:7yp.vK


)
b

Y	Mu#,a)yT&e+	t;}c
E ?=P/B<'-8לKnG؝܂[hOxnQ9EH4N-4ڂK@/7&ߵ٦ْCI5)?f<l;_ێؿ=ۤ5Ӯj.=ڄָՋ+ۥ9EB=:؏ײV{ؕ'm޲ޢ2nk\kA+R$zG		z
dd5
!z"#$$:%&t)+y++!-.	.:./12V1u1q2%3o374R55G545o66T6667;7<65O6A775P555C5444432221g0/y/..W.w-;,W+1+++*)(.(':''D('&%$L%%h%#I"S!  A!A! 	:&nb[^vRr
A


3
5Al		
#
)[5,   +iWh%}m\#-3p"VRWUuI:wnS*e_}FݐݐFXfށ1t֌WަF{dߗ׋
ވٻڑ=׍faVri:޻Ԟ>۶VnT+٭a_jۺܚ1לړ{׉&إyo|=kpۯAڶ;RzYkgz,umw	9Z
1

G9{>acU+ N"3$S&'O&&)+++@-.7.^-x.I12T1/0-344g34z55h4X45m65M55J65L5U5w5544P43222|2i1Y000!0.-----,=,+;+**<*(h'&'(z'b&&&%\$,$$$O#"2" ;9  N6m9 8J6lo9
t

Q1
	/t	sBDDP=;@4r12?<<y,"NBވ)'d߀h_%
S:۸nnB,F6K>jڰ4{
=n)D/3KuԾܦWޣ~ ߽߽e~ֺvKX_>֢PLsؼ7`ni0ؼ8نy>ً@'ؾ=ڭՌ(~ٙܞݾ _ޅ}FLbge9/
 rXtE\
n
v
t.pZ)J8W#3$"#\%'((])9+.,+r+,.////Q0x0-1d2*3K3K3O33234_5433j444 44@43v21J2221t00]000///k.--;..-++9,-C,3)')$++*p(o'T'	(((H' %#$%$##!!"!w j){ !y@ l3?	"Sz	4O
vm,M	$p(.n}z{5uzb9T^caa"zs'߈nُ\NBSxuzMrٿ=
fmߍЍ)C0Q1$ ԉ	փѳuՙ%կ4ܚտИfLܠHP!;kߔa&pDo2[Y g!޼%_ڜ&,ݐu-5
y0Uz-voJ^
g(e *
70
w
,5A;~-C!!R!#$$$&())**+,,,.6/.N.\/1e100122x2F222x3p3>22M33~2w112`21V1|1s10u0k0J0//..4.--.-%-,+ ++	,a+)((K('''&=%%&%"U!#&.%a"&!!O"!D 	3se%>t2JKp	v	1*&d	,C w%]@ {|FvlR(3/d
w!^O |2E>s'qJjۨK ~[0.׾ޝbܧY"_ئܸq}!XZGxϒ{ ?ghH۾dsBه0lհ־n	>޹ݕӍ=ݏdثܱݼnܒEB."^QPLPokbQ tx	Y


NAy'M `#$#!
#8'8*)(b()+m+-/F.++.0/!/0j20.034101g3311'32u1;1222.1-01<210/1/X/0[1 0-,-/0-I+p+-d-*)+q*'+(*d*'<&k&Y'I'%$%(,%$&c!"{ g* ^

W4+
	M:

8	g	5*C/9lswo!	Mu32$Ke)h1@\2|c3/ވv:۟Q܈P&p٭Ԑ3ݷZں#۟}ۥ`6ܚfzڔ"1KTxnJݰ"}օщ"+8ޔ׸ּc׳ܿ9MW݋eܷ؅K`E߶ޓݜޓ;vު)GgN ONQZp_ iY!C
+
	-Jh>G
- ! 6 !"#$%&Q'&&')_*)**<*]+,,,--,I,<-./=/.-+.0=0/G..u/F/).-..I/.-,+-T/.\+*+--,s**+T+_)r(()n)R)&%'*($$$&V'$&$D#!! !#a"gv ! ;xY2"3<\D<k
 
k
^Xnx	\:n-	M%  9V"o ;T7Bݲ!r0'`CuZjګv/ʙޅ\Ձ/Qڪ Tق^`ޡ ٹձ>lZ:>ߒߨqZ و
ח%dމmڔ)؁ ՝܃VZ׹v\t7ޯޟG|CWEO4Z\" qd`"P5inj4xl
'
4
9

PW>M){f&+Fa As""("'$b%($#%k'(P('(G(()]++t*)$+7-)-++,,,~-.@-,*- .----V-++-/-}++Y,+^+,,,+3***j))*&+y+d)%$).*,#E"'*&#m$%# L!$q%R!=] #"e6zKUra6T4"vI

1

x
,XE*	.n% c~ NIvr(riW:2z?=wJzFOsܴE.d7 -Th.޹`jiL٠aݱ9dSތ AP٢?݋Ψm/ަ|&ܖܸܨ3ٸkݞ\|hܴ܈٪'Kތ50-u@SHE7'@mo^gLE0!
0% +bY	@
l<y-72hf[!""<#<$.$##%'Q'%S%()(&(*)\()++)t()[,J-',W*)*&++L,,*8))
+u+++)&'++K)'N('M'~()M))(&$w%((M$""r#c%G%K!L$v'!K?4$,"qk"j Er"% jt2A
	wT
Q~/
jw3G/
?^	8%_MD.ާ@Wx?aPS^W\BHg	ޒ?ܭیE-#ިNNSѨM*Hiڦ;Z4+'T҅TsݽqۡܵCz=ؾKRܠzܴYp}em_)Ez	3iK?Nw
#	nu_	
w
	 ({^pf07 G o8!!a"($e$! #''e$P# &'&@&`()'%K'#++U)'S))x((*,"*(9*W*()+8,(T')N+?(&*9-(#j%!*.+1(%Z&((%%(*i&!"(u(!!'%_ & #"g@!?#} 7!c/2pP>l(Jv""
h
y
(Ih ,~5n p D\Dk2
 i}Zh_&%.w WTa54O@߆Bq,Gہִܪv,P ~5
nݧ4R%1Vڈݭ1_"|LY8ީۓޓ:ޙ܃zk4k\{ ;=_dt~#(#H2$j`	
`	q
n{W$
:]?)v|/!" " !#:$0#!"$&_&o%$	&G'P'%~$d&('%%))%7$O(2*U&&$(>+(#$$)7*&}#$':'#$)*$")*%!Z"# "(%pw (&!!cAnx"D7PFvD(~yw
:6x@9
X}P
w
i


S><#x)zBSyz)fqX
۸s@~r\Pqa\׵݃LsX[OBߪ܆5Zd3CW>={ړ}Q!܀ՌGR49JݼڜݕUX۴6ݼ_\Fܴ2 ۗ ܗ1BH'5ETn;XRq4~'?5 )e M }`&		x:	bOr*}p? 6H  hF /" !a$#  $X'$!"3%%>%f%%%&U&&k%%&&%%'
(%Y$%''&&&I%$%&(g(#"))7#f "$F$%$O"C _$`%] 
$#sE. "pz{]e.Z6 >Q_/	K

f'

W	-
!VqY!Ns>t	$Abm`݌8,.ܫ7I6ރ$YZւ
89pҕڥkv;:x]|>ptߊ
JI'@\3t_[f{Zj6\"x}f_XW Qn$0;!x6C~B	p	pg
d
14 H
P*J;mz<:! Y""Ba## "%%#!!#-%]$"##%L&#!"#$&Q&)%X##s$$##%%'T$<!1"|%&M%#[!k!
#'#g P#&" Y!S&#~ "V>!   5&)7c
B1z
wj
L+	
 PmF

 #%W U%naPf0]HIE2cw/-YSE/^-`ߘ|eE޿܍ݻLڟfXJc݉
\>qؐ4(1tީۗn+c@NF!wE-Yy?P'J6/IG  ts&1	

		eB$3FufR]S2tP7e 
   ! k "e$"K!!"##o$$##
#X$%%$^$##$&%#s#^$$`$##)$#"#]%.'$,!!$%"#&$a{"" t=P P P5v  LON3d*M<VdLhpL$fD8/	
?
PoC
'Xq 
uHtO4aOYG
xT&%^Bkch"4޺ [r
VbNodpݓW	r8 ;Q7=	[Z?ݩ8^#	3ݟA^߲؟+ݬ}\wqf1Z0<	7}oDq3(m	tO` G  XQ
cg	OF	8)1TqiC|i*z!!)j	 S#" 0p ""v#z#!B c!.$$#"#"!!7$%n#!"9$Q$x! !G#":!$!!E"J"! !$# 9!%$ wm .A.";FK+QouB~R


n*	
l>_#
^RcK%vCe,klr/~SsdJO?;M	^w
dލ{`=HވIޞF ,ܹ܇R݌ک3݄T[}ܤ/
Z"zQ klk-zXO#6[DzNeG\dVddX F|y=!!
=
m

_
C;kyuXVb#]+!^u6! 8! _{ ##!
 !"!,!"$U#j "%Y$6!!8$#.!w!]$$". ~ "$}!P"5"!B 	L FuaU
tS
2
 ~EVv
 	
Y
#V 
!<M<T.".#DA^Lagߝo0B ג$2.8G(h6c<xw
$CF[g۲<(t#RqbZ/w%b*Imq+v(PoVz oc	{i
F@	a+eHRiPYn'x J /!! ^ !!B!!c  ""!  !D! 8!$""! ""  Zs ! T~N!.k;-(=SXPmx2
`pE)i?X^T[# [^.N^8qpBaC{SvVz.`wRZkހv.@5d{_}߅ܫCQgsQ5!H@!߾"_*D+]{&CY@eHug]`Iq7Z]AGHY" m ao6R	kDq.
?.&

j`JFdZw5&\IG &%  cA  c  fiG \ vL 2!z!A!   V   
I2 "wK+ "waw#R/)	3sr
W	`'
(f[
xCy1t)<`'`mrjyA;1vRu.E$`WnRܖz6ߵܱxf~kR6# g;*t#8:[.LY~V'_|cA.B}a*]
/SfzE1efvs0  
	xm
A
e
~
s3
%jT{4Zrf+[kVk_"j1L
!"N7  ? X4pAQ;;lh /"amR?N	hq|
^
	O

 

Q!c|Xj `
}$k 5UUx{{6Y"blg>= oQ86|"#ۡj&K_?P|+6m3'>tGm.MWޯFVt#C }4pwWTys;m%*DJNfNd7WfY M #'GDtF		X
7

s


P[`
/0pTI (Sv[f^0gp;Kt.pE.bWnp)PA
saKKbN#b
zV;5	DG
~ 1
N 	
5g	WK	|		k

[-(+s &SP 10
EEI50T`-)*Nz9/R}=s`}=F'zzV
C]=}
A&rU`L?MckD(L4%,xFSWm(_.=GS)lwW'X@ 
g  S\j*./
sl	
	"	xx.




)

)

3qQ16Yi(.FvMaVC
!YIlQ|&

 2	d\
QA;
V	&
z ^aT k{{
R&|	|Y?e F	#C	  5 ~p=yCy+|tUalReomI7fDaeURo+a1%piy2+
I'ZTwj_)UZ 4if|qOl?&d62fUH&{cK B ~
x\73W3 2{f zY b #M@	e
d
4z	qW

l& 
 |B7
y5
i
V
YdI
/)O
U
9i
7
r
	
	
u
m#q
{	-	 


4;

h
Ru
u
[
pF	
	X5		=
 = f*hVE  <~Q pKP 
%U Zi8GU>VTp_!T0rmV}k48L2Vci{Brr;o8^%=UvZP3]\	
\j b`}$<=\A6  }L a2D   O z'w ?5RhXK&U b,N5co&|(J6	e;	LM
6
0?D
>
[
\		d5/
O,u0TU'
{
@
z'	
`2	

O:		i	? F108
E!~T'R| n8 B` U  29L: 3L  (:{M
H== hc.|TU/O
Kf!!?<.GJ) z*KKe%!,z2Z]f#Z> 88 
jhJ26wLW y; ( 
YzeNXIM')e~ \. A?|s%0 .3NcO-  Q_V ~! F,d, d#^d 	Y	wTo,s	m			 \	
 9i;0	F	5j(6_ h&
\
$t9n
T#
+ [  OV_c{CU%-/% EjD,K H(ysU  O	 2mnQvLA:9 JCM 0h`^rV5
7HS:U{ %x;t0E1Ako
NQ4= .r, YtQ]a `:X^l /9  7G7}FVqk ~d  :^; :b {h 
j;H(p 3  vNrTU+ZCX"\<, L+:
^l:E6P  
 Smo1Z\V: 

~<	@
O^) 4&Iz 2YNA`d 1z@y> 1Q  9E 	L </8 !C\ vo ,V9 j\ y8yUV D`o<p y 7\n%2Z B+Z\AUAze k<KO2"JV Jts PNbd LI  GKm[0GZ{+k7t 2 u/h RRQR	y2s8
V *6.vop\  \m$ D(XnN 9atgH |rtwm"\  +S L |:[Gb    ,K 6~  @ L$QAhU            
      RSRC             [remap]

importer="wav"
type="AudioStreamWAV"
uid="uid://nmgop3d1jgka"
path="res://.godot/imported/z.wav-c95bbedfa41a811e116ddc5ef5a28e9a.sample"
              RSRC                    AudioStreamWAV                                                              resource_local_to_scene    resource_name    data    format 
   loop_mode    loop_begin 	   loop_end 	   mix_rate    stereo    tags    script           local://AudioStreamWAV_icmn6 8         AudioStreamWAV          xX                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        - A X o     Fq"@MZE/(#l3   > Hh'h;}UJ?+@w
8q.x0
x  X         #8Rk@j-O v  ,Y
/|pvXF3 
g;ga"U < %K#yv9I9wa0PoxVN&|@:(
4v	 / T ~   -We tcQ  y_
p%<rZEz]En[FgiJA9Ma4LZg6ND;4-Vz;d5SpN( v    "I[<#x$*/\}^,5qUe<nidOQC 
8fuWI;th^TPKvqEP  Q n  1$r  ! V7s 
 4 &8 r  N5J xK(eG(|*`;Z*e2i-]p%2i5," U &?Wok=]}'/..^,]+XaI           /   r   M{   ccb f * I h w  s _ ^ ] V O % . `  Sbp+   G[     8  x 3 \    P    W   c DRaI  Of?'#B`5
 jmYWY\("KuOe]XSPfFl X.i	K

V 

gxR,:!#%&1(()((((&%1$"!u \~;[1

x-53
5px9~KjL	EDQ^ }<L	[P9$yh\Fj
S
Z


"\;

h
:2oVU<u940x}JlD~,)0 QZb
:f~^!5oShyjulW \f	
3f|rS' !`#$%p&&3'>'D''&&n%$#"! 6=C/P=w8kT2#%V !"##$%y&X'(*+1-[./0000<1~1100i//.-,n*'%" (D_
 5R WdP4'Wvd~ph`i~ yOr*		5
L


Az"%
5EU
e	b`o~hKH E{w1F_9lMs9sa?<pZDvn}p@[,o)5EUK@v!X3xJJB>znL4LX!kވޥwDLڇ<U;{^A̑<`΄λ8kϞ'ѰЛϸMF?ͬcˬd&ΊpW5G{kZe/ơIĒ¥c-28=̃Ҥ}B ]?!8x !
##y$T%/&')*,-/025E7m898a87532	/+($HVBmzF8S؞"E˖ɱzePϲԝ%ۭMoA@.2v2Qe!#V%'4(Q))z***%*)((,'C&%$#"! I @M n!N"/##$|%J&T'](t)*c+;,,-..2//0C1223k445666;7e77j7D7665o5464e321y0b/K.-+*0)|'%#}!dj
8
 21)Lop&V%u%f.?/
@
pI!!#$%&>'''('''p&%$z#f"!V{GE	
_	8v3;B$    8i7~Ee=82`<o$	
w
lb	$b1y

S
r<#FNWR		
?

Lii
	z	(	pN$jCFHC>g$ux%@X /HDA2$?Vht:9kS0TJ<+m0t	1YC-IdOvhM߽l޻\ݧxئ؈8ף]SI8nn'[ێ2_t܉ܔܠ܂du*AXE2	BΒ́ˇ< ˁQɞ!+	F,f=а/'vIw֯B` 8輖b¦W	ţ=_ȶtN̡O"ii
ӫ[
HՇՂեսկ
g\Twќ/Lr&ʈCyɭɩɣʑʗ˛Ώ{b&KܭY/<O[ 's^VS*bQ				;s_C8F
؜PԕоϢhA Fs͏Z*П$kV![}dL1VyK K[G
x
ApUYs

	@\T7.

7Tpu{ !"#$S%&&&'()*,-=.a/^0^1U2N3g4567a89H9w9P9+9887c765+5j43210/m.`-V,+*(*)#)(j(,((("(@(())`*5+
,,-h.+//01A233456N77`88999a::&;v;;;;;l;?;::j::9998(876F6w543210z/A.,d+)f(&%&$"!X QK,AsHO  !"z#4$$%J&''n(%))%**+j++B,,-x--K..$///0#00//?/.C.a-,Q+"*(y'&$_#" 3n3\N
ya
v	rX_f4J;,4pKZ	

y-mR3dX4|mB "%')+-/0W2'334(55y66@76654=432j21M100 0|/.-,+g*2)'T&T$U"$ +6
r	x:'H>Y&7 Ohda[U7[								x	M	"				=	p			
@
j
Z
J
		1	mLCg vh+W9lYJfSUF_+#<]ݱJۑ[:؅#O|ӥHд ΅B ΫW3n;ίϦМ4oԻծN׷צ.Ӂ>;|n`AjΓ(ϽOFѫўђk=ΦUB́seL4[ǂjSY`ƙaܿؿSξhA_ZUqr;qgwRА~kؾ&:Ti~	HHyF]_X?Rdh*d	< eUllXpC	 6cX

!Ndz 1Rt[K!"#$%&'()*.+++,,++++x+*s*)(/(u''&U&&%f%E%%%%%&'(y)v*r+w,|-./0~1F2333434N4j4444444$43k332z21v10/..-,+*('I&$#D"!Epn|2Ux
$+ vwa@ #2a[
%
KqaQ#u2Bq;-\H/z<D"

}1~ +}A fg8}shv~Y4`@ 	"<JYfspnhcr|y]B	O/?]{J:ngz g'
w
bL'!!w"""."!!Y! l `*J%{
.3w 
=pop۶Wfto(+թ'&fڤ1?riebM?-5~E2N#2Ay]0$[QG8).3x_TS0|}gQm;?C/Qm(D]'teT:}Uݔ܊'Roء8EQcsٞ9BJ4peط
FփՉԏӘҡѾ %ʄMȲǽŔ_=۽ƼƻƺڶA=ݲjj0mdYүJ`Sbδκ5GZ6Ćŵ3XK/y"}lT; R(

nQjqSC7.5@}y}b%sU8j
Y
	ui%is{ag~K	m
6+
2D=6)zBl" !#l$%h'(K*+,.</;0;11s223/3O3Z3g3?3322l2.2$22r22h344M56678x9g:>;<<=S>>Z???/@W@@@@@@@@@@(@?y?$?>>4>==+=<<j< <;y;>;;::Y::99r87"7f6x543t2\1E0/-,8+)k(&%1$"! 
7m?|6OhgfUC~"jfL1 !"u#$$%r%z%%b%B%$$K$#Z#"U"!a! m hcx?keoe[J:A|m0U-~kXajv|e$

s^
	s_WPRK	D
?:1
'[ "$7&'h)
+,.0[1r11l1O1111?221b10 0h/.-P-,h,,2+c*o)|('&_%$$^" UgO
7	 YI8gN \ |	T
Z`<
25L;exalvbpT ?r

@\y
~	_=/ + w uafjM/#!*k(vgg6Njc`&r1(Pb(p )5EV܅۴ڄ	َإF־֕֏։b;i<԰%ӛcѴAΓ#Ͳ+̤8ʗzǩSƊI|ŰąZ@%k­Ng³os/XӿaQ,Cxæ"NDN\iWEƔǿɝPi0Ϧ&jqw{|D
79!#&[(**++7++,,,5-j---.{.3//N0060/.T-+)`'$!iC	ypg?oXߚ۟c#\ڝdޤOy4h ?}
V/&|" $%'d)+,6--Q._.m.3.--(-,	,T+*)7)(J(C(=(|(()G)))*8+&,-../01d2S3A4/566b77j8 99::: ;;;:::a:/:99c98`87:766544F3D2A10.e-+N*(&%%E#f!eeTC2 &	]UL  &  i	
{
ud; m!"#s$%%_&&y''($('Q'&&f%$#"! K!JYnF
s
	|Tnz% z # t=l%EU^ZkS,{` BdJTqb~[<b?Vnx$
2
!#%}'E))***+B+**)(2'%$#" nV3Fb	 4i>$MuܮE1րՖNVԦaֳׁOU\۷ކ_$&Q444" =^pT&]OQd( @`s@MXzj1udR2yߞ;uݍ_۶%ڔT|פ8Ԁ^ѩ/{ x.ˎDɘ`u*'[Ƌƺ/gǟe9ɀ&j	͓γH϶l!iӾNԋԺ"[clM.zCӀ'`ё0жЁLϵψeA$θΚ|T+& ͰͅZ9
̡sE%#	˥?|ɀ
ɕMć]<#*Z_jơ^θШҨԤ֍rܪjll>oE"	
9hN@c3c{S+>t

	n"o 1m(<-\K9dYQ 
	,8C2"!F"v#$%W&'''x(C)* ++,-.a/00m12253|333333{3J3
32y2'2111s1k1b1q111112e223b33D44X556%778J9(:;;<=R>??@PAABCtCCCC DD>DFDQD/DDCC3CBB`BAA@@:?W>m=<l;V:87)64"31/E.{,*(&6%{#!a ZaJ	;69Bz< !!"V#$$%V&''(4))T**9+++*,j,z,,e,@,++.+**})('&%$#"w!3 * CT


	p	1	hF$#!)1%3Pey	=				2
U
x







r
b
P


4O !"f##$:%s&'(+**'+ +***1++~,?-g--P--,A,++**('t&%#"l 4&]? TBXJ
<	h	4hG   u2cG3PE	n	

L
/.Q dM
=
G
		[UYt%s6 6 u8)5@yFq?
H=e*Q '- Ct2]WRap/u#?oUߘGݵ#܈7ڂٳ">zӶnѾ4ZΌͽ*̗@ʉ(ʩ*lZHc~wpO-("2A?<	1nȫȶȪ-ɒ(Zzʛu̸,͟Ͷ@΀Xk̶̃́̀#h\$ȵȚLǩU1
"ƫaA!HoƉƤưƼ CǕ5Ȍ˗̐Έ-8C1N g

"Q%|@  !!u""#S##?#""!F
1nH"
H(*AVj4:?J&OyW6ay<	

=Ee!/"K#&$ %a%%%%g% %$V$#A#"!1!z \>rYs=B^ #!!"#o$I%1&''()C**e++,C,o,n,m,3,++%+*d**)Z)(](''j&%4%$$C#x"V!3 3L@4"
#6w ,?LE=mtr4mX C+l	L

#HXiEDG
7
 vw:@9w\@Yn@@` CZpe[%n]jWi A	
Q	QY%pA




-
0*
		,$LU^:>B@%
E4ux5({~Lv}`CuO
_ !FT87VI	i d5JPV52P& g f d 4  bI0	rP-\3FFZ}|XLdld\cks|2;E=6+#&:Ncxogjm{͉̫TɺȒn@Ũ-ı8þ<º*5п/
-CXWUD4/*3<Ywxxmchm6SúGVJƻlǦ%Efȝ^ɟ+wnˎ͘.iЮNч9Ӫj&ֵ׆gH*	!@^)oL
$K n~P
S
|+Bge8jG|JD8.`e*0?Wp_ M! ""#q$8%%&'(L)
**+L,--}.%//b0112|3S4(556N77s88g99e::i;;)<n<<<<=e===	>>
>>==={=G=<<h<<;;f;9;;::|::9;988H8777x65B54!43 32>21g1000/.z.-y--,,++**))(('Y''&&H&&%y%9%$$H$##B#""p""!c!! E [g8|7(8ERUXaj
9hz>m > a   !|!!3"c""""Q###F$T$b$E$($$##x#_#G#E#D#6#(###@#k##G$$%}&j'(*J+v,5--v../*00<1=1?10/.-,++*)(e'%$X" xQ*-T
O%

	K!< {N!p4E:  b/&O	'
B)
/`Cq18Z ])	
-
w& <|[?)`? "Vq
!i8\L<M3h<4TA@L	s t]5
zDN/*/xݿpd_g<PնmӾ
\ѱXϫP͌	5T¶pJ$?uHvLIuÒï!ĔŖ$ơǃ,pȡXɦ4tʦU˸̇iQmpsqo϶r@љ҄ҰsV8s٥ڌsE޲M߽.>)Q`H5T*c R\OA4_y[ q^EC		9

X~	
m

=7Wx9z;unhr|4G3s8Y2pU5sAPO7	l+   7!k!!!!!!=""".#U#}#_#B#	#""v"P"*"!!S!  3 j]> Z ]zMq&i=E=C`gP/l
>
J|-
f

		f	]	U	@	+		dF+{Am_Q.*Pv$%']/==[2*dIug2f
W"   -Y.V(:|0LH~B^Er&B9yEXd>`?`+p+orgEi"[NJ5g*s@
|hUB:2*!qH  -4;IXosP'EbUb܌!ܰ?cڢRٸm#דM֓a5՗LռxS.ӟjP6 
ҩҲҼ9[l}Ӕӫ\Ը9ռE5םDثٕڀ;?CO[ۂ۩۝g1ڰڀM0C#ڱ`"ؼ؜{[;'$r>t٪{rBr\H5"X*Jdwwv)}A  'n[gs"	0

l(

d e]Ns=~X !"""""U#$$/%%]%-%%$;%%%q&&&&&W&%V%$$$$%$$a$#s#
###/#A#K#T###7$$$$$$)%j%%a&&'(((]))))**+},z-,..I//L0012E344 55k66777778:888T99999999~9e9g9h999:!:::X::K;;<=X>??@ABCDEgF9GHIIJK LLLMLLLaL4LLK|KJ JIHFGoFEpED3DCAn@?=< <;986P53j2>10/.-,*)f("'&$ $Y#"C"!!k Z8|rX5k} _!A"##a$$?%%&&!''((((()T)))f**+:++++!+'+r++,m,i,f,+++*K*))z)(O(`'q&r%t$#"S"!i! c ^1EX)]zSiQ)C_MF;
p

k\
	U5}z 3 WJC)7CP]c0]hsxU<")0DXUQC4.(qo(6;8:L#>n3Vi^7k.h=M߱Vޑ&޺Oܘ<p |u{؟:֞j6 ՈE*7\ՁոM֋S{ף׷6gؒؽ&Sٝ/xڦ
$;Riۆۢ8x'݌\?߷:+0] r X0ߪ=dܞC۴[tmؿ؋`6ؼBמyԿԆiM=-ӊ\.Syn Ւ&ֺXמDٙXݤo??@YrolH#<+CI]fkb@e Q7"&1;K[zGj=yeW[Qm5;SKJ+'jG #G9+8vQ R  wQ\{	1

Dj

cp ?Up7n@yHe$hH(	O4"D 1X ds4)W|hQ;%#YK\~8q.x>n'_7MbB,gGw&O1

`

j O
S

	o	)	YhN5,Bs?l.	g			
F
s


.WsX3


N

		C	Iw
~\E@ ? 2_ELf<z Co=mV'j?Lb)p)AF\d
j]g?jNA4wlbaaceeeox+6ALWZ\jwnZC-%"&&& -Khw1^&Gh@%gAw94Kbk_6nW@i[{(d,}i(cO](eZD7vYC   ]G1eJf.cH3i2v
	<	n				


			
>
a




@sJ*
k


MQAu%M\;{4qX?k:Rk!_
6c8YsAUiv#Fi$-6;@l
#S[ep~j?rG
0;FA;KZtehligfeq}kS(`D'th[]^O@)g5o?|R5y;~Y)}KdE&U(S1OcA|]=Z(


T

g>lR*



k
K

			C		y2~Ja?pIW+B
j-tE    m T 9  qK&n'd)Fa!w<[q6yAI mG"b:];gL0h0sE\A&
rcSF9(
kM/qT6* {tm^O6wf[PE94./05:?DEE@<:9<?KVkDg#_ 8Pj~ke_kw8U#Gl"VW
<r*i	9j 1Cc0Ho-Oq.a4e Hp!NnP#>aGt8GVdq - W    "R"e%To)2;Pdnwwx+b1H_kvxiF$gO6)
#Ks )BcGc&3@:3=Foycz{RH?gyZOEOZ`fowsp\I=2/,m5qnjZJ5'/F^__cgw}kXURMG2cB 
{rH|e2lXPHMRSUC2	-"
%(+#CP^L;. (0>LV`jswI{N!    _ 6 X7wjUA)         
      RSRC     [remap]

importer="wav"
type="AudioStreamWAV"
uid="uid://d1ax8bnu1j6ok"
path="res://.godot/imported/a.wav-676d2c21c4bfff51587cf128300e19b4.sample"
             RSRC                    AudioStreamWAV                                                              resource_local_to_scene    resource_name    data    format 
   loop_mode    loop_begin 	   loop_end 	   mix_rate    stereo    tags    script           local://AudioStreamWAV_5css1 8         AudioStreamWAV          a                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }{wtpmifedba]YUQMHEB?<:8630-(# 
	"(.49>DKQX\`hpw~  
    - 9 D N T Z a h q z                      { y w u r p n l j g c _ \ \ ] \ [ U N G @ < 8 6 4 2 / - , ( #    
 	       xqkecb_]VPD7,!wk^QE:,yhZL>0#
{k^PD7+zk\NA90&upkkjlmnokgffkpy,:IZl5Mi
,MnAk0Z 4 d    (TS0hNBA6v>	P			
^


$g4vB


U^-r@DHHC0k&d:nKP+]!Qbs !%).49=<:85799974.'"
kWC1 
z^B&
hN+	wY; nBrQ5T sS4
MX0~OX([e/U

K

~Eb'

`

		S		k0h M	Ek7Xw)  A l&PkD;X	l!O
6Ox9x7n)f,~B\$Z&P_3wEoM/xT0uX9q\F.kV@*|naUJ@;70* uic]]]chnsy
 4J`t(AZr!?^.^Br\,q/oWS;)4BOf(]'_A(hN;1  #|trxwuu		{
 

+@Rf}
)*)+(r[F/ v  Y!!@""*##	$r$$?%%&j&&3'''Q(()b))*e**+a++,Q,,,3-{--.O.../\///0N0000/1d11112C2g22222	3#3>3T3k3y333333333333333333333y3j3Z3F3133 32222|2Z2622111e181100y0F00//f/-/..|.?..--E-,,n,',++O++*q*'*)):)((C(''G'&&<&%% %$`$##:#"y""!]! ! I :~^D-yeCuFy<Vs+X'Z


YF

H
		B	*x#|%s_ORR  W  m!Lx6r4o&KFKv.p4 a,_._<xR/{W3
qN(iO4 ~oaVLD;3* ~rmhd`^[WRLFDAGLPTX\^_dis~yriaWMC80(
}zsmf_VME=94.'vnhb_\YWTPLHEB>;9742.*(%!
		
#*4>GPZdoz"0>KYft
#8Ph+Hf+He$DdDj.W+XI}K#[7oVQT^#h5{L f7 }  Q#j=eE!mJ&o	K			$
k


F#k;


T"e*l7y;z6t*bI+b:l)X3[3Vy >Yt);M_r|n[G6$kM0~[8{T.h<^/ n>zFs@
l4J`%v=Qe)

w
=

\$s9

_
)
			P		[*c2 qB_4^5b6	hBb?     d D ) 
 ydP?-uj_XQJC9.&
 {tlhc]VPID>942001/-&
~rfZMA5,#uhYJ?3% ~paRC4"veTC3" ufUD1
ufUC1s[B*kU>#	fJ/v\B'jM0nV>"fK0 oYC- r^K:(zn_QG<1&!

 (4?LZdo~+BZs
-Nm>fAn 3kE|&_IT"f?fJ-|j^RPN   I@8/+~%ymcM			7


%t\@


a3x BEC7q!X+\ N{.W~9[~6Pj
1DUfs|l\J7&w^B'a<yN$tFV#Jo6M\`N}8

m
+
`L
x
/
		P		v/Y?q(Mx0\O  I  FL
MZt<R}I~Nb4R"yS,xV7uaM:({k[M?2&wk^PD7,xlaUG:.#
|sle\SI>6-!yncXMA5)xlbWMC6)yph\PD7,!{ocWK@5*|pe[QH<1&xpg^UJ?7/(!!+5AMZgu#6I[l2Jd~/Jh:\}
.Rw
/V|!IrBjGv*W>o6h._,a3i>sO.hF}$Z	C{!\ L   IGDA~A ?~={7v2	n			'
h


!^M9
u


"Y9uV"UKy'P})S}:]	(Gd,Hdz#7I[o
 %+159?EEFC@>=:73.)$raQ@2$
taL6	{bI1|_B"jN2}\;z[<tR2kI)	|]=b@



u
R
/


}Z4
yP'



k
G
"
				j	D		gCiDnJ$xX8`@#nQ0sT5{]>   ~ ] A %  iJ+kN1rS4hP7"q\G2	oYC,m[H5!
qcUB/!qeZM@1"~rf]TLD;3)
 xk^WOIB;4+"		&.4:AHNU_iqx
&6GVer%7J]s&?Wo	*LqN 1p g= D/  :      +w ,Qv\>(}

atTyUb?O>>-gk2vFS^i0}yub1 g!Paei{jZ|}dt8

e
!
y9a
B
	2	ya+	d	]	U	g
Qh.V0` (P
  T wnY,yD^YS*I}_p$%& GUh}~"Zft		6
}


m
Y
[
]
s







"MD>

V
		f			I







zj

3.*





3E$!
'
eK
"
	>4n*[ C._B.:X`0j7.MmAWi%
yt0uݲݢ1M۳ٍٚـuj:	٩Hזh:֝H՝E
*% ԰gӜb(ңYшjLV`UKЧ"ПϔAͦzO̎̣Gʙʊ{[:{|.ǽǙk<Ơ)Ʊy]¥4۾O½P޼\ػC&ͷhdh(3s-ꮿYЭOKzɭ7VJ=*!+BY;3ױ{.]ٴ-Q'-v̸"L;+j9ÀȚʖ̓ӛ*
3}9|% _	

Z(?h} !!!""k#$$D%%>&&&&&'Z''<((B)))d)((O(((
))*>++,L,<,,,m,,E--}./X//O//x.--O,++**i)('/'-&+%#"7!.ws;
^
Y


	r	HkkKhq~<Qb.3		R

/25n
RHORNx.YB ,!9"B#X$n%&'()*+,-./013V4568-99:E;Z<q=u>x?x@zATB-CCsDDEFF?GGHIPJ
KK?LLM`MMMMMMMLK-KdJIH_HG(GmFED=DLCaBsA@?>>)=4<>;I:T9f8v7655|43L3t210/..%-I,_+p*p)p(g'X&@%($/#5"K!` kz	@a *P
3
0
s	>wz G6$-6H	^
=
#F9U*N; !"#$N%<&%'T()*+,-.R/0012t3U4?5/6677777c889:;<<g=B===<V==>A??@@PAhAAAAABXBBBBSB BAA*A@?z>J=<6;Y:987u6431 0.-,,d+*(*)
)('['&&C%u$#"! X]T))R~

	#	e0!|  yCeESa[V!R=Tfi2Xb*xR,\3Y(]EwރCܙ;ڗ_[{i,Z҇)K8+ ǞvgX7Nؼb:ൎBkyԩ3}HVNF>;آѢ)i)զk,ϩOӪWx#ۮAׯ/,<`"ѺƼ3Yj{5:{JNad5S "$&(*,.q0?2457:8[98:;;M<<B===s=>=<B<;:l::X::&;;;<;:::p::;m<====Y= ==<~=>>?H@AfAAArAA@.@?>g>=<;d:875310J.w,**)'%j$"!M {:SD.
Q
	9xR-!1W0			f

Yz
#T(XTDC{_E4B !'#^$%&'!)a*+-. /00123z4K5#66789|:x;i<^=9>?@@B+C.D1EEFF>GuGGGGGGGGF	F5EEDZCzBA@??E>Q=Q<=;):9765433!2	1/.-,z+*)(	('2&5%4$'#"!d I9l
a	j8 pZCKRQP("xc]}y|~0 Sa_$	
A

BmMwEcRQNq#,  !""2#"L"!!!!P""#@#"! 5V8CS
4+rw
|[7
ZW d
p+~t]E!K {߂OxrCڔ?ؙEָ~sշ 3gҒѺ'ДWϪEΟ_mʼʰʍkʾhȻȦȑu_YSsȚOɞ
wʨ&3ʙQʶRȓ:ǣq= 
ƼƉV$Ŷ>V|¡߻<?>CGL]ı*lǮۭ)Rz|ä	"6DR?.
7씤\B#'+:>^U.ʅgfiXj}GQ
ǁx;|Ԃ'?ll넼zqB5ߎe,q#֚٠qէ
A<a{}ÂP`td_ QpxQ	?y0!&$z&(	+%-@/02 4P566 7k77%88C997:^:::::`;S<9=>>??\>=1=<<<==;> >>m=<H<;;;;.<<<<r<;*;Q:z987655D4l32D1
0[.,*(&$?#w!len:


g
		]	^va9  k    :?,U	

o{m_ V<w\ "D#%$%k%%% &F&&''_()))c**l+
,,-.0.1E2[3y456J89:2<#=>>?+@@AVBCC:DDD<EEEVFFGHH'I JJK LkL\LHLK~KKJImIHGRFDeCAs@?(>:=]<;o:c9"865e4-310h/-{,*x)(&[%$#! 3v =w!:
[u
	#KEw - Jl3Nt;1E *Ou	
(Bo9	#;&q)+./)1{23n578:;===r>>;?Y@wAkCUEMGGIJELPM\NOOFPPqQRRSRRwRRQPPJO0NMKxJQI*HGsGGXHHH!HcGED\C8BAA_A3A0@,?(=;865A444&4
4321/E.,*K)'&%%$"!D V(<
K
	Qh#d }xNVZ.R9\OZDeXK&'hc>BE
Gc$	E865hH	&5D\ߊ޸-Rjن؍דQ}Ё%Kp̦ħÂǾOڹ]᲍:Юg,)X$F1'AZVIޞnYU;ќ k?cwdxˠ wΡU{Т <xԣ51Ԩ*=1=k ̕Eӹօ١3uWI)8H

Rc,"%O')s+/-.Y023579;=?AC4EF0GG[HHMIIIIwIIHHfHMHGGFGFEUEEEFPGGGG&FDCvCC|CCDKDCCA@?>Q>==F=<<D<;!;:98I7	643"3*21/..`,"*'%\#U!NU~kXf{~&>	o*kI'd'\:#   l '/]l		L

AElO2y+Ub+] !!"4##$%&'(*D+,./312346678q9I: ;;<\==>N>w>>>>*?V???Y@@@)A@@?l?> >==<<A;:;976532-2^1s0/k.F-+*U)(&t%3$#!t YO2![

l	[K^
 [-^]
};@z^UK[kg9r7JU2I uD

N|ga[x :  Go|J p!5""#'$$;%%&-''X(( )&)-)5) )(('&%'%$$+%&&;''&%$#T###$##k" Fd*p
_
\kuQ6A>IHx\x.yEފ:܍ڪڈڪـDYՑFP9ӓWѽ}=;5ϢCA͉fC9>FM9*̡pD˦˝˔˾8̃J͖Ͳ	#Dͼ;˜ɤVkȂj}ŭHË90x Z|P>FĶ
Wu)m,UQLJIɧI̦\VŤ6Y2{ם2jۗ(tIC͓z=iB`2O0:}Oݙk5͝ΟWƣZZ
Gհ?mҺ.ξT-ǳɹ˼ϼѲӥ|2y3ߨo(z 

e5a "$&(6*$+,_,,,Q-E.'/01d3456N77777889L99!987+7h655443X33"3+33(44544332t233w445@5N54L433222433B444443310!0e/N/;/"/	/.0-`+)}'p%#! 4ejNfB=g]
O4
7,OmM[a^[zy2>@HZ  v!!F""""s"Z"U"P""
##f$
%%F&&P''@((u)+*n+,?./0.2234d445506677p88888
909r996::n; <<.=D=[==<(<;;u::92987654322J100/.3.z-,+*)('&|%$#"
"N! 'o-8W qK9M{O}p
y@

V
Pm$
J
	>	KC;iH;		b
@
G3TQ6 "$
'()*+,-.n//n0I0%0/.5.---./0123044m556
77M88o999F988"87E76F65-5444;4A44H5565~54643334"4!432^0.-d+*)))c)()M(r'M&%$""-!x 43&Q|
W^(

\

			C	6u7h      ] w
i8^[Rnw t&!,BIkEyTz~;BJUjQ= o};y"}Q7߷CSZXV؂ףmhOӯfѵ TϜ :iơ:kBy޻(>UhhM\f5ЫlI.27W,PtŬݬެϬϬcܭVޮjXΰE̱RвL\vir빷λ$Gtx Ȍʕ̽с%1܇߬/51p	\N N"$%8'()(+C,]-2.//900>1111111111&2"22111122 33332)2}10$1|123:444943,3.3033P44u555=544g322z10000/`/.- ,*(J'%]$"!  xxeM~\1	
$
lptZ




n


$q?
sCIIi+L4cF$4pS u  
!M!!!o""#$%&
(R)a*o+,,,-X--b.//0z12O222~222%334e5-6617q7 76B65n5 5(5+5)5(5414H3^2{10/.8.y-,+*)('&u%\$D#6"2!K e tU@eH\S.g-)

+UT
K	<-Ms5@@"  ,v1(XdFK^t9\RGg %Pxl`TI	x
"o tH29Qm8 nikZ_jh(|38Eh%*.Ki


/	;H({V p /	Zf>\{ CWI-!<jk vAގOjIܹ!۹P
ڻ}?؇؏%օI4ժՅ*Ԗ[_b{ԓ~i
ԫ-ӯSѣс2x
ЎϖδLw|UUnT<Rwĕ$F)u}%Jx
M`ձKư9]4;Ϋ8ڪU©V쨱v4jЦO,
ץإإ3h
Sߧ2fŨݨ	,N~HD5sׯ<iذ/3Aɴ[뵉1ڹҺOϼY~a]z
\ȸQ̕5`)jר ߟ%GC`3Er wh[+b	

1peH1IEm^9etV #!!!="""""#M###C$$%O&''U(()M)g)))**)))){)K)((({''&&&w''p(( )/)({(C((6(m((P)~))P))r('m'&&&B''((.))) *6*D*@*=*M*_** +J++++r+7+*k*@**&*:*l*** ++ +***N*	*))t)x)~)))))))^(''b&:&&V&&'''''T'D'2'''(6))L*o**J**w)((k(((@))*t****d*L*+*M*h****+++**********,+y++i,,,,R,	,+++,|,5--./b01L11u1Y1811>1^11121j10!0n/A//w//d001Z1A1.1100001k112s22222222222V21b10090/0)0//.-,+
+y***
+>+*U*n)('W'*'&&&&&6&%%N$#"4"!!z!!!!!Z! n ]%XOYd!~,wE
)2d#q-8Iksi2{8*I\VU
B
G
	
[	+gA9JjI m chO==<#g6h2~^N'`@
Vi[Gt</TrA0Xf0$,\H iSgs^F{[VRZci^RGC4* 
	G>57^*HS)p9
&7ADGG9'߯ߝߦ߮O7z9pFWhI:':VsvHIK%v,eNG^M
;lT=3I<_|KYS_Xb$S& H|u[	9

tEqT0jloux^:]ZWRM}SxTdu5   k!!">"b"O"<""!!!!y!S!-!!  ![!!!6"<"I"+""!!!"-"@"
"!e!   
 I   >!P!c!)!  P ,   
  
 w.Bw ? r    C 34 C y x w t o   _!!V""'#~###$2$b$$$2%%%[&&
'^''''((((%(8(O(8(!(''S'&&v&P&*&%%j%%$$$|$J$$##X"! W  j:2b_D	a5	=N6Q]cqVAM
f
Tm
	&	;v-^mi%?2N  C D%Op%`
U,_z]{ bOiAU:"ukqDlv@oC]h>tR,b0I
~dJߨߍsh^P:ޮm2ݯݟݏxhK-ܹܓtR;%
ۼۑc0ڷږځkUD3" ٣n9#)0"ةؕ؃؀}wsdTPK]n؍اع1Xٕcڱ4lۈۤ1jܚ;wݳEoލޥ޿"Nߌ Ei-Sp3I`|!W$ZQ9Sbq*hUz/uL3RpGi1a Lwy{ro6^1MOOE:3+/5:><9:<HG7&

)El-HNUI52.E]n~uz
NRV@y-Qt8i-Od|&=Ts8i"S>i+T;g%;]} 1 ]      
&3@CHMNOIC:;@DNbx.?GNU\imqxAj
1Jg4Qr	2`	/Ru5a	0	R	r				
"
=
Q
`
q











*6DP\hlv/?LYcmy


#
&
*
'
%








+
)
'


sM$kP5





s
Z
B
)
#



						z	o	c	W	J	<	%		yo]L4qjcYQF;."
znbVVU^ffgYK8% %.<JMPG=#	jUA-#yquxwwk_K7*
nU<+	 }xsnnmu~	

	           
      RSRC             [remap]

importer="wav"
type="AudioStreamWAV"
uid="uid://cvrs4d1lkxi07"
path="res://.godot/imported/b.wav-231189f97f2ade072e3f2464fd49be91.sample"
             RSRC                    AudioStreamWAV                                                              resource_local_to_scene    resource_name    data    format 
   loop_mode    loop_begin 	   loop_end 	   mix_rate    stereo    tags    script           local://AudioStreamWAV_5oufd 8         AudioStreamWAV          [                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   
       # + 3 9 @ @ ? > = A F L S ] g v                                	4FY@&	)Jpt^adsxnG     PkQ!   /i.rV:::M_."$I% } 2 _VNmO.e: |   8;>??ISNH!   B j &  . @  FEjY$I<LV$dr-      p[7cpI `W+17n  c c4kT PS!EfvT2R  3 .Nnkh:nuIW?c
m>iq FlBV'E
\@6,lQ,.F  sk/ a^[   2lM)_GN(x/G;&~>
*p}x/e$:QV2x`NQ>~	QeXJn1x p A CE	y 1 111eTs4n,s0
y\  ,u&umgb~ rVc^T?+Y
-r$n*u>jd0?NJPWEGYh0jnLHDMNOaAL!.$t   * t? 
\ aw n"B1Z,D;a6c2SsGpL:        ) h 1      B  YHA2  W   G[&G   3S Az! `Wa|"XQ/cA.Oqn? g ! | *\!$}]S  _ 2  S\	#=ooPu	  k. N  8_@%dXL? H = 2  	 NZeXJ:EHYi#Gk5,2RsP.U}Y  8 e-Q,l#yhXL/h&ly>7_U" :w  CDL nI}hGebA r#-_{Ns~YH:  l^    v 	 !$+17DI  & - 5 L b i p ;   5  ?E)z.~/TxD/P6OpDXmH-Y/GDjT}]a i5c]O<{R) hn 9 > D  KY"R2gsY=e\  E j {l V1 F  K   # S B,  _ @)4Nb=CJ1$tAhtx  ;.!    Q daN;:A|*?Ym  / h  tPe\af4
Ewc<60k=6 x K   GdY   R  mg`bceg h0)p7   AYXP 3yQ8M
  ,fWI ]:S1$A^itb2Rs
k	?QtyS55S5C[s('zJZ)Cw
'Hid`%#{/wSuB<Y?s.u&	V	j					
&
>
K
W
:

 
		
3
U
Y
\
%
		k	a	X	}				.	P:,&/K,u+}Y@& =}9     z l p t n h  mHv`	fU:-:rp`!tqY@`mF
n#$\sBHX"aGb j8,a_\,rZxvsnߞhܨg/۞
ٰوLاT زcrׁ׍טKִlheb`ՎՆԢԾ@ոծWph`ӁӢLԆֱR<'gԽSI> Ԑ^? 	6b)Չ?ղ}F Nء؇m3مھ?ۉݎpR@/ݒd(ߏVELd/S  P12	

I/`zy@i`*uBfN  K!!!m""#;$$$$$$$o%%L&&&&'I'`'w'X'9'
'&&&&&{&p&5&%%l%(%$m$#`#"}"/""!T!  b}|_%BP"E
GF !""#$%&B(()))W))d('&%$#=#""""""n! #iFTbVJ>fB( 9!!$""
###_$$"%}%%%%%}%J%%$$L$##P#""!e! D~:?-X"c{PlQ6AMmN1 k
;	p
	x	&	AH i++ZTH;A;x o5Q"m&u"&5Y}eLE=uجex#0ԼHӪҁОGCЕ1{Ѱ њOѐйUαzB^̄L˕
ʽ&RǀƭzġxjpvZ>۾̼мϼͼdo
-Ǽ`-Bʼ[=-̹j<鸈(|ж
JiĲiҰ>eȭ+Ѭr,EPZW'5@Jĥ mf܋."2POO9%	)A{iq:  *!""#$%&'Z())9**+q++@,,}-s.i/012h3345w5\6B78:n<G>@AtC%EFHiIJKLMNOOOP5PPPOOOoNM*MLLuKJ0JzIWH4GEDCeBA?F><;+:87v53b20/.-p,e+Y*)(
(F'&%%U$#"""!!!!|!b!! m  5r7}:a Dq
{E+@_


h}#Pq>;n!#$h&()+-/14L6r8:{<^>@AzC&EFcHIK/LAM'NOOrP)QQR]SS>T[TyTTTTThT)TS[SSRhRRQQJQQPPVPP+P9PP5QQRRKSPSUSgSzSS9TTUUUT=TSS%RDQ.POMLKZJIGSFDC1B@>=U;9M875Y4281|/-+*f(&%5$"!w `HoG}^$OoF
C

v	|S&?| $+Gb mt	}6|n_v^4Wlt&eJG[JTr0~,|4q),^=y"p*mba]&]p y*oz^ةL6`:ڸѷPжɶö---󶺶R1kʳ)@Ұίˮ6ƫWlƨQܧϧ§,Da}|yvը5橘,諶F֪eͩЩ~~~pʥL\=ӨTթ)~ϬEI&bݼYÖBcфwj߾c>6.#v'!P""w##;$%%&''(''%'&*&%&*&i&&S&%T%$$$&P'(z*,-.<012Q45m6*7777#877H7654321b0d/f.k-q,7+)('[&%?#o!.wl
ot	@x ogH/\;%LnUޭޑRݹ$ޝUNsU+ ^ NߐڸٿflC;[Ձզբ՝ՖՌC֒WٶچS(ݷpW>g6z/6~
?D~4Nl#Cf5p


}P#V
@

;l
7Nd
2

G

7ZQk

	p:O6Nt0{7%l1k*>	+E]ݛޛ-yV9G
	mBSc$Si;Zsj]Q88	
&H!0#Q%&()+,E.x02478}:;<>@?@|B$DEF HHII#JKL7MRNOOOOkON%NqMLL%LKJIH*FD	B@>t>===Z>>?J@AABGCUDbEFGSHI1I]I2IIHH#G,FD)CQAx?=<:K9865.4206-i*'$s"  GVf	%9Mo  vbOYtevA/goxABfQ<=>_@Aj}ZpF]]z1
cU :U,"U&*/4%:>CFIKMNZPXRUT"VWWWVXTQkOLGJGDB3?%=;
:8764220->+(&
%#! AkjJvI
c,
	$C,d -e]84Y!Ho;6DRҢaӮӦԟժֶܢݮ޺!v|e\+HCsE Mie:֟
zjH%̅ʱ~ʋʗʧS-Ι+p϶mYQҌRӆtaokѼ~?Bwέx̊˫ʈeǽ	x<ۻ	7ݼ[ٻPǸ0~cdf^wIw(R|9ͤhr}ƪת;$[(3/+Z% l	
Ou


a
K`P.ar "#g$o#x"! U!!#3%'S*-0747':<>p@BBDEEGGsH3HGGGzFEVED0DCBA_A@*AkAASBBCBBc@>Y<:@8~6z5x4	31.
,6(c$6!
c%
pI!~ oA654hyV#Fjd>i/3!(AKI^8+9g 4
H
]?!_#%&(W*,."13579;=j?xAC@EFGiHHH4IIJKLMMjN;N
N;MjLKJ5JIIItI!IG<F)DB@"><; ;:::3;;8<<=W==>f>>>z>=_=<;;(:8h7753c0-+k)'C&$#!5 0\
lu	~vn<
E1xI)VO G3}_0\7	:R\kT%
e+B$"',21x5v9u=gAYEHKMOPVPONMdLJIGE^DBA5@?8?>>z=t<:976C5w43q3262T1s0/..5.H.\..]/ 0000p0/c/.-.-,J,+* *)'M&$#"! k4lsU

	V3LO Q
rG	xCiR~!a<_?v-"fe=6/`-P@o}e>AC m%1ݺ~rfP:Ս\@
˝fȸe	  P2ɸ`:ᳮ9įc;s1爵NkHHH2yէܦܤףˢНSܚkWs2s
`věȩ̰Ҷ>CI-7{JZ
]}C	F150*g &#%B(*,)/Q1x3578:::j9876544N3221e11X2_3f456s7A877$64Z320/m.,*F($!yNR 
w$CWj>ua&C`T  tK =Xkb	X
R
M
g	SR|b]{E

Y;="wS^ S!E"#%w&'>)*+,`-.7/M012?4|5p6`7889:;<l=L>>>
?.??@AmB.CCD6DCCA@?>>0=a<;V:9K7~5i3V1/*.,-0,+&+**n*O*O*M*V*^*x**`*-*))a('&&%$"p!]`	'
?7 
Ub&Dd5W{ߗާݶ:~/֕Իz_C=ӹ+қєZ
	1iП4lѝ:ңқӒԽ׮c DݟALu%`A.?c- k	g	|
0z7/
apTTY]#Aawi
8s"mLhK6#3X9_D|p2
	| 
 I)1f*%E=
v
3Yw/`EUd+}__B,NF#	h
_q 	%A	.Qs_)4ZbCe +!!!!3!  zcTLE|'nUJ2'
\

5k
	DsrB: !hB|$8:tE0_]M=ۍٕI{يXۑ۷j:߫(4~rDcv+ J~4
rG
,
=
(

{

jj,u~=k~])<P !#%')*;,,-l.;/(01122328211112-210/.B.-]-+-
-,,B,f+*)($('''')(''&%=%$@$##j##"! ]2Jc0n27r
 S
	*	mp>*X b%=`BqWJoG {W2Jk/y+#yFS_]Z@&JW]YtܴۦOcwV4a<{M̼˗sĊnRu×þ5[#b*D]&HػgﺲuȼƼqH}ܼ_򾄿ǿ߿1kn?ÆŮ>w &+a˕8եכڑ
^^xv	
"eP6/DpU( U V X TVj 8!("##%$I$l$$$$$%+%$$$i#""N! g#z"a`#}}2\/?
Q
\ &t#(LHqtv~U410IgvU%o;DMl,O4C[OPq+  ly(c	)

~d
&/bMPF
F
5
R	9  r^)QxGlG#ݣܑہڧ.Q]ilo~ЎϺfe7ˌyzǤ2Ƶ8Ŵ0qÞ_Đ,Ɓ0Ǳ2&f˴θx7,b)_`AܐGݶ#In
ެ'ݣ;ۮۇۓ۞ۅlۻ~Aڂ/ۛ@ܫݘހ~|J \k.#pD2L, Kl1"	x	y	z			
=

PQ

xN$QijUIVz8WZf;Ae?ShikT=BG`zili?   !g!!G""N##$%%&&&<''(u(()>)))*B*[*s****8++
,c,,-G----.....---Z-,,A,++m+.+****w*z*|****+C+t++++,V,,,(-B-]-\-\-b-h-U-B--,,i,,++?+**$*)F)(2('&g&%o%$y$#'#y"!'! OZ L aBFKU_E,1VsJ" [EfWy"+K;
\8


jF|b}XHyp!/7c1






c
6

6
o




Q

ws/E

m
/
		e		Wq"3A\F  X | u~c8
	}zrjP6gIpBBh3YpH M^%vFs[A(~S'^uD~<4k*]a4CV>q]o ߑ"ަ*ݎKۣ3مG|^5y'V;ӟ)Ҳј~m\t%ϱ>ͺ͏c0̎ uOɯWȜȨȵȬȤ}WOG[pȅȚȶ,MɈ-Tzʃʍʝʭu̪=*΃ϙП#ѣ#ҧ+ӌKԩ
rՇ(:جنڰq۷XܲIݮތߏK<>U'ZlsB[ujAM
>v\yk]i3 ) 7 #  U  ~+i0c"^"9		
`
`
_
W
N

R;$

V)MSBZrpme]}L2lh(IzkA\w-=Q3% # ! J
2W|||bHPW (  B z       ![!!!!"
"!!!!!!
""'"0"9"A"(""!!!!"G"""#?###$w%V&6'';(w(()R))
*4*_*'*)))((((())$)8)M)r)))]**?+U+l+O+2+(++++********w*E**)))t)M))((u(I(('K'&&o&8&&%%Y%$$"$##b"!V!   i`^0? b	gA*m%f/I`$a$Sa


MC

L
	h	VTOGc_@
mM-d%  } R ( u?\+FlWA'
j1wdE&}eN5~b.z<q0jEJ
`4	h:vG_3q=Z]2f=kI2	.ueQ~2b
Hqt[RHi$8Lm1t4W{!|	<we4H'p)Mr^mB  !Bs)eEbUm{oUds;0	(	H	(				`			/
 

				&
x

g[7
l



X?*QoVH&}M,mEowY+Ry3s$2#

 &-39AJWd} D_{	+NW_O?uTE78:Rjkl@eJ{aQAO\SJ.	o7xV5zl_R,^,vV6jL4W+ w^EeO9b=QBO

Q

s+Z

^
 
		N		h+w4vCR%n9r8{4g/   I  YxIzQ7v>raI1[6zV; rErT7fS@(uaNGAFKQWD1`XOUZWTNI7%	_>o[M@/wbNKIMRW[XVSQ^kz$-F` (""Fj!)1Iaz4ANU\dl .;RiG\rolrw!EiqytnzY\ 6?HWg9Tl3h9jGb}, `    Lp
9iuT2Mh7k^Q*
:y*u19Big<j4^_aZSwF			
4
'


	
*
T
}



	,`R1
c
^
Z
>
"
/
<
m


*Yzsl`tojlnx^C-*&#xT6




y
Y
9
0
&
7
H
O
W
@
)













;
6
1

kH-b<




}
u
m
U
=

			c	<		sO(~R1Z}hR5v5oK;x"  w Q + [d1|iDX?SD5Lc^YB`#fL$MqQ1r#v1wS6t;s_ejoti^K7iJ2hK2vZ.	"+(%
!>Yq!%(*,&  +7:=95:?KVfvzl_XQH?;788BL`s|pcYOW`x%.7ES_kt}yupjx6Sp'CJRW\fp*Pv
"'-6@Ys+T}It8b.Lk9YvEnJz(Ch?l"Oy3Hi0YEn  7 S p    *T}4cBZq|8Rl5Uu:[

"6K`~8^	&	?	Z	v																							w	h	M	3		 		(	=	J	W	e	s									v	n	u	|									
1
C
U
\
c
m
v
y
|
x
s
n
h
l
p
n
l
h
e
l
r




y
f
K
/




*
8
(

									d	G	+			ypg[O;(pN-
nJ'mWA0	s`E*ziYUPIA0 .<ENPQZbmy}{uj_\Z^a\VLB>9@FILD<1&}hR8s^G1     s Y > "  ucJ1mbX[_jvz~~p]SHKOTZSKB8>DQ^ada_fm|	 
/@QNKC<<<ENZglqjcWLIGWg}tbPE94.-+,,'!}oaJ4)	u[G4  !210&*6Wx:eCp  3 L e     %Mq'?HPSVVWUTSS[cbaZRNJVbp~}spnpq}
 ;Wm
+-///'           
      RSRC     [remap]

importer="wav"
type="AudioStreamWAV"
uid="uid://c17seb8d5q65m"
path="res://.godot/imported/c.wav-0623d6c395df3404cd98005840c0a6a3.sample"
             RSRC                    AudioStreamWAV                                                              resource_local_to_scene    resource_name    data    format 
   loop_mode    loop_begin 	   loop_end 	   mix_rate    stereo    tags    script           local://AudioStreamWAV_bb44y 8         AudioStreamWAV          X                                               	 
                ! $ & ( + - . 0 1 2 2 3 4 4 5 6 7 9 ; = @ C D F H J L N P R U W Y Z [ \ [ [ Z Z Y Y [ \ _ a b b a _ \ Y X W Z ^ a e f g d a ^ [ Z X \ _ e k n r p o j e ` Z V S S S T U Q N G A : 3 / * + , 1 7 8 9 4 . ) #             
         ~zupkheb_XRH?:641-(
 ~tmga[WSQOOPONC9.$
ztmdZSLE>5,($	 
	
!(5AO]gqv{|{{%,2;DTcx	$0<L]elos  - @ R [ c l u                 ':Nd{	").29?M[k|
,=N`s 	(7Lar 0?JUZ_bdegow %(+)'!"(.45776;?><83*"
 wy|||vof\UNE<2(	snjc[NA-	u`K6(~hN5kVF7)
      m Q 5  zcL9&
rW<#
hP7yY, }jS<(~kV@)e>ubG,	xk^TKC;50*$~`C*xg]TQORTVWPI<.*%&'!vohlq|&4BQ`mz",3:BIVd{
0>Mdz
+<M^u
 5J\o#Db/Pq=[v$HlAd<b! F l    4]Fm>g
4b"X"Gk Gn%Fh	1	V					
6
X
z



)Ji*Mn

+
L
i





&A\v'>Vj~)>Qdt!,7BP^lz'/6=AEHKMOTZ]abcccddhmsx}|vtsw}    $*/48=AEKQZcgjmoqsrqolkklmmnljgea]XUOID>?ADFDC@=>@DHKNMMPSQNJE:/#
uhXI9)pbTF8!
eH-b9V)



b
<

jM(mZA(




u
O
'
			Y	+	7JKAK^~2N  j :  l2['\%u7FI
\$LtDzGg<T'vM%nR7tng_WMC;4+"scSF7'$2>KXeq}

*6BNTZ^bp~%3H]s-@Qbt*C\s+:JYhz !,7AP_n}!0AP]jz#2@O^m~	/CScs #4DUh{'9L^o"=Tk5Pk6Qr>] : \ ~    (Qx8Y}Gs7^4d%UM~O0	g			
;
i



([Er
I
{



 Gl	0Z/Sy@e6\~ Cf<\}4J]o
.>N^p

~hQ>+{]?&eE$_9|V1]2~IsA\

h
2
VwB


l
5
			R		l7`'O}Lr4t4v4e  D OU^
i4^Xr=WNUu<RZc%v;f1d1[/d>eI-eM4	mZG6$fO7 xeXK?3&
'-233:@GO[ix"0?N`r/CXo$=Rfz2Lfz &7ESan 3EXj{
->Pbq*;M^o~'6ETcq'1;GSi /G]s$Ody4PW]REP[zJo 
 DhA
2VsIv
:f1J,""/<n	t8X    O}}kYi{ /Uz4Gu>c^:	m			$
h


7%


i
X
F
k


59

hSu}q[EHI?O_y5/x
f%7*~\/y;qeXH7Sdw<S@4vF?*{n[Ur~r
 ;
2q"~
	d	bl0{r;^
z-daJ2:mOPgx4LO<[a\!3K*
|W4cWK    4 ;'c)z?by!:cZ"'UvXbjP7 
+L;^ULSb*gM"K2^- 2X&oN޷5޺(܄ڠRpZ@܄܅܀Rݗݸݤ݊ݙݩfޯުVޟP;'o_O߱BWy<u	1cx9n.h}!6JL_LUco|BNZf\TS\(*8FQm^OFWP<m*&xD'`M  `GSlG7{			1
&
UL58"*uBO K! ""#$x$$%?&''x(())c*++,-Z.7//0i11223-445s6N7
889::;p;;k<==>o?8@ AAHBB&CmCCCCD,DqDDDDDDD	E EDDDDDDD	E1E?ETEHE<E'EE2EGEEEFgFFtF2FEEnE6EDDDODCC
CB7BAzAA@2@?U?>p>>=G=<k<;;;:9:987E7665
544332!21b110=0/c/.@.-,h,+[+*d*
*))T))(g(('3'&@&%%X$# #`"!!q P^0q=!2]h2rf%ImE	.4)(3HD9H`%0tnk"Ytd$SYPa)1
O
		`B$)4CRK9Q\Mq) ]8g#;7GPY[ekqriu-j,l;^s ߁m8ܛ}b5؊׶0nӫFф'?[pʓɶ!OyX󾎾1Ƚt ͼlY
ySзN˶T{c*𳶳y!ɲQ챇#ްU&J⭾	_KBeѭULC}r *Teѯ$wٰ:jr\>+3qұ2Swo?k´Ҵo998xҴ!nw޵ܷӷַ?	oZDF@+\
I]2=Tl¬[pRZ<ŜDƇƨƿmǷOȈȶ
NɊJʉt~ͷ]r kж.ўҜn$x^ՔAf֧O׵2خV]dny].ܢ d{ޒ$ߏK
1I^0}qiw);e>Uv	
-
UC4-tI5 U!"#I%&'()o*++M,,-O..p//l00j1123344N5.6
7789;:I:X:9p98_8	8777777777z7d7f7b7{7778/8P87765432 21l111111<10$0/q/g/a/[/O/..--,+)('&%"%$)$#l##"/"!
!n /Y0W+X	KJC93CMYi7BaER   !'""+###3$$ %%&'()*+t,M-$.//013 4 5#67789;9<=>!@zAB0D{EFGIJKKLJMMNOOmP8QRRSBTTUAVVWcXYYCZZ+[j[[[[[[[[[[	\\I\t\\\\\\\\s\*\[[[ZZYXwXWwWVV	VUU|TSSXRQP7PONML[K JHeG!FDCBA@?>=<R;K:D987d766v6'65<543.3211(10O0/.-q,S+5*9),(d'&&q%$+$v#"-"! B t0m1{rU~1>Np ]7:e~ 'vwM
z

V<Fr
v

Zwc@
|

j5<OV]&u

				d	>	>UlU?DJ  W(TnIv
 jadR^G|ޯ݂9ٹ؎׏֐ջ Χi!LEȍ2ƔBoàR<Ͼt$л6Ⱥ>зj⶿a|JȳMڲg<谝Mܯl
®5+Q篼#Itaf°ڱڳೣ%q@϶T/	ʶݶ6¹>&3׻{K EP^n~ úMOb̀"ZҒEڡ۞ܕߞW)gA ]
Ig]"]
3 !e#%}&'j)*,.12l456W778899a:;;<=>@ACEGIKMrOPTR1STBTwTSjSRRQQ~QzQrQyQ3QPMPOrO.OO"PPtQ#QPOQM`KfI#HFtFFEEDBD!C BA
AA?BOCMDD-EDgDCC=BhAV@D?	><\;9\865#4 3%2f10/.&.Q-,+U+*R*)")`(&^%#! Al+fg@S/w&i6BeH- Y     !<!~!! "<"}"")##!$$%&'()*s+,C./02I344t5567v8q9q:q;F<"==>?|@AB1DyEFGHI)I4IHHVHGGGdG'GFFE"EDDDDDAEQEbEJE+EDDDxDbDLDDCCMC#CCBBBBBBBlB5BAA-A@?c?>==<;987y6Z5;4310/E.
-+*X)6(6'6&/%&$%#$"-!+ &!WyHhR/[]^XA\{	cq[=F
7
z
	0	lLL{i!pF>T+.j!R   E * YL?%HQ&1fg3?JX]aA q[TMyAܹ123}ҏ&Μhwˊ6XSN W9/BczX5
ѯZ1!@lɞ!_.PŖ3HlH͑55܎_,؍ǌUFB)C	
T{	7ᅑA̈́mI& 胣a2cwX;'5h*DqbSa~ۄ9z݅~ʆbˇևdC؉o@bG+AӋcb̎61wƔ
ߘś$jȠmEEr߭VöK!4p:	SЍ?]֑.<RI{F kK %b'	y,
%kttl]V`-e !d"9#$-%;&'()++5,i,,,
--..v////f//..S.'.-w--H,+*)3)(('1'&Z&%'%y$#@#""x"l"P"2"!c!   <A,ST5?pHo0gOv/>k<f
 !"#O%&(+)V*Y+W,[-j./0=234567F8
99:;l<y=>v?k@AABCCDFG#H9IRJFK8LLMwN1OPPQST UUV`W,XYZ-[X\l]y^&__Q``1aabqbbbbbb8ba2a``__d^]\\[.Z'Y"X(WV&U6T8S*RQONMLKJIHGFEfDECB@?v>p=^<^;b:T9C8754n3U2:1E0Z/e.p-M,-+)(}'@&(%$#"! 9vn`S; E
m4

XQ[OC7
,k(D@(wZV@'Fd.=v  H!!"C"S"b""##o$)%%R&&&&&h&d&j&&:''J(()))(2('&9&%8%$S$#""" ^=_s8(tp9+


5
Q}\6 M#MrXbm$q:m%FhlpX?'=cUx'݌ۧ[3ڻڰڥڊtڛuا~Q/
փSՉJFPZ:ҦxJPP[eK)ѦyJ;+4BsѤUґ[-MfXID?JTvԟԳԉTNc#ѫckEώ&\
HTɃ3v\}5ťW7ĸP÷Èc>s	ddjm(ɻoN<)<PST('W{
W¿Lbw0x
ȟÔηԝe=4V`tw>kL,s
QFB`~z8  "	$&,(q)*[+,,9-..>012%4>5W66777779
:y;<.>u?+@@AMAABBCWCCCCCCCCWCCtBAAE@?Q??>]>=*=|<;:+97z6
532821-10//r-+*2(@'a&g&n&M&A&%$#P"	!z	_6Y{l]`)
u/0a9@:4S&*4$pN> j!^"W#$H&'^)*+,-/-0:1H2k3457899:Z;<<=q>??@AjB:CDDEFGH_IIsJJRKKeLMM7NNDOOPfPPP&QQ*RRLSS8TTTTETSSlSMS.SSR.RQPONMM9LqKJIHGFJE
DBA@b?><;6:870643721/.I-+*\)'('%$#"l!Q 6
qA

		,U~)c G <slqhY  p=
EoE	l
)TF

Yo[A,S
7VpyYXRH=	eOL	Yt%xm

->
[	tX , T}FpBoK
+MՍ̴˴ʳɫȱǥƙŇČð$z`پK%ݻ9D6B&8紗lB鳖Cزgn7ҰqЯAٮQNSXf{]?欏Iޫ9ê3O B-ƨp4ئg4=ӣ,upy@xo=	ș^y
ҕޔ:Ғ+/2ƒ\/琟18iّxj
䕽˕ߕh"2.Ԡz }٦çvҮAYĺLؽӿ'(&ϯAuZ;߂;+?aK9 
.2+/	

a!3\6
[wrma&4UG@"S ,Y
p
6
(

{



CO^7

'l,

 Fn%R2ClrjvZ>Sp 8!*"#$$%&F'((M)**+,-/0.1#2334.556{7y8w9X:B;;<=}==^>>?F@AABCCC-DDD(EEEQFFG\GGGH<HhH}H}HlH^HhHjHHHH9IOI`IAI3IIHHHHHH{H(HGTGF-FEEDDC6CBTBA[A@^@?_?>1>=<<l;:$:98847W6j5}4322\10<0/7/...q.X.;.-Y-,,,,	-`-Z-T-,',H+j*)Z)q))))=)((X''&&0'}'''''''''
(>(f(H(*('''''''''f''&t&&%%%%%%%|%!%$T$#r##"""#""a"
"!\!!  ^ K 7  N)|^ ~[1Dg[Pdv3l[m$@iux<K

@{
&
	T		qQ*K
 Lhyr7f2krgO695gJa
t4b`eZNJA_iݳq8ܰi,ۙi8ڹڑ[ٛsB؅@׻\ך/ղ\դ8ӝӦӧhҫZ^bҋҲҵ҃RѢфgG ѺЃKϗ@m"͟iG)̽̄9˚˨˵˧ˑIʟʙʓ+]^aZR˨̉ΔΙΝXΆδLn7l2оEѮ|-|ӝӾӹӲ3|Cն)|4u׶Oةmڅ!݈J0 5s!_.:] tIS	R{;(S:<
x !i#$%&&&&&'E([)q*M+8,,,-K--../01<22_2'221M22-33(44_4K4333r33#44&5>5U54O432|2222L222221210#0/U////&0///w.-t-E--O----v---,C,,+,:,i,,m,@,+b++***+s++++w++*T**B*q**X++++v+*{*G**`**-+++,,,,m,/,,+N,,W--u../3//.../y/00'11111112|22j3334	4334p44D55555W5-5
5B5w55p66!77667665-6h6687w7777Q776667D7q7u7y7176u6 65^5[5X5i5{5N5!54h4:4
4/4D4W4k4N4,43333334433\32v211=10Y0/\/.l.-F-,+z++***1+/+-+*D*)9)((((v(a('_'&%#%$L$$## #""n! G s(h|q/r@{]

?W
	v	)0>y>J@r   @8ocjxLYY>x(8'ucwE86aDG@|Ovp<Fܼ%]٪Kן1wԾ'ӑҝѐГϡ΍T̽&˕ʂɚ3U?ƶ-UçZþowJ-.>˼XػXѺJܹjѸB񷡷D󶗶;굢q@
Ӵ.ֳv>ʲOg'Ѱn?ޮٮЮˮh-H
 Acͯد˯ͯЯ 8z5aڱ=ɲ 7?HNU޳?gߴT#cѶG߷-|ӸduƻOBؽl)/[pCĖĴ1ũ Ɖ,Aɲʍ˟O;ΨϒDvҤ;ԽՎXؘ]۸ܝݖލxdXJG8X|V}cE8hYF1H\c]!7Lh  L#W^=_		

dgv
'^
MH}asow$tB<: 9sX(" ; N _   Q!!p"
#Q##h#F#9#+###d$ %s%% &!&)&2&i&&&Q'''
("(((((Q(((-)_))))#*]**0++),u,,,,,y,,,,#---(.e.d.g.H.)...9._.......y.:..-.<.p............/&///..~.S.U.X._.f.I./.---A- -,--,,,w,,+w+++ +***m*B*))_))(L((''~'Z'7''&o&&%b%!%$$$z$\$1$$##h#-##""""L"!!K!  ` ! o1X*n*wN wDY
r(u=-`a^=d:m[r5


=
R	C


R

		9		e,h)kEp)HKKkQ(  S  HTp0RwJz>JZ(b3AxO^7]7
R&|d_NJFGD3#}`L-!|\F*wpcP>% +4@GMct&3@1Bi)Lfed^OTXzs:x!MyP?|Thu+^
.R[es7^8^,_>8w	U? ~    5T=l 4i?.a(/6OhP	9W,	o					

[


1}[ 
P
`
o
y



6I[QJA8IZ	2Zw
L'T: mkwhOOP&{X5BJt$A:2&3Hx,}$x)Hjd2Aiuyoonu}zl`I2{W4k<*$W
gP8W(
mI6&"7_]ZTP*P




s
2
PI

B

				q	H		dG*n ?q0gJ0rbP+    W * LLGgD=7, hD!d>NQy@pEmJmJ/f8b?X*g4mV*Z&}S)zcM;+x^G-^C)oN/
kU?)s`ND<61!qcjqtwkaI1%-5.$3Pl 9Nct	9X'3Mk	(0<DLT`hox)<OazKw=b;\v!Dj%?]| %7J`u8^/Nm@g6Ofy&:L_x&?Xclv
1Ibv=d!8O\is}+BVjw	&0>K[it~~|zw}*;LU_bdgis|#5?FTbw (1;GQZagmtwz|~|{ztolhge_YSLGC;4#vi^N?4*!-?Shr|+8Oh 2 X o                            l Y ? % 
         ' - 7 A J S [ d n y               v g W H < 2 / , , - 3 8 ? E O Y ` f j n r w       ~ z { |                        | r i g e h j i h f c ] W R M K H L P [ e m v }    } z                ,@S\fec]YWVWXWUUUUUQLB7.&%$*2<ENWY[WQIBDDP]n	 $-9DGKA5&zl_TJA9/&2Fq8 [ 
  e  NpM*$!   H  wl_} K       i B Y r      o % i`Tw  ( I j     .01239>FK`t	,Mnvvv8^z/V}	
1Kd|{zuponrwxc;oQ3{W3yn`R<&V%   _ J 5 , $ ) . 1 4 . '  vY;#
jS<2(!wW>%|tmllnq{oT0vb]VXY^a^\TL:(n]L@40+*(+...&~~|yuqmjmnv}|skc\RHHHS^m{~}tlifghou{%.8BP]o
 #%'/7BLU]isz)=N_nz#3DMWakx.B]x	 +6;AHO\j|  	   ~ywusstvuvz~~th\PA1'""!%'.48<@CJQW^elv{pe[PMINSZa_\UPNLKKQW[_acbb_\YWTQTVVUZ\aegha[QF:.&
	         
      RSRC [remap]

importer="wav"
type="AudioStreamWAV"
uid="uid://daj714idxxkfu"
path="res://.godot/imported/d.wav-972481444ee3c4a4b9a7e84e389833fd.sample"
             RSRC                    AudioStreamWAV                                                              resource_local_to_scene    resource_name    data    format 
   loop_mode    loop_begin 	   loop_end 	   mix_rate    stereo    tags    script           local://AudioStreamWAV_rap11 8         AudioStreamWAV          4^                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  $ 3 ? K M N Q S g {     h 5   Q          8re"     8n0yUs(   *W
m;  7 O g        h)Q4  6 
     
4Z{@~tfD"0?,zk2i`Vbm7l6s<&`N;@bVJxRvwjDy/>u%W4]4{&cluq!(4URY'N4X55;AI@=9YCA?ux3V,knq@d@{}xT0@z9HXvtg[o 1pz6p&\3!%;n8Vy8ewO'2j!xFq+:2+*)HfN     ;ey   C   IY\_fl
F,2;C)4L}$w"x_F,-.:Fc*u)F4#Zn	

	D{i
Whx-'k1d+V\kqwI ?Lkj]YR|17ns<"p!#8M
2
 F
	0	eAv@?k(j MMflr'O"lqC;rWGf gT*{&~
S2u	b7jMfA#zKT]oqbDbߡޡkܸUs٪^SHTaשGmM+04+!$%fȧ?ƌBa4f×¢pI!6K鹆Sܼyf\ʪ]r̌>ǭǘǓƌĮfAȰ*@ҭ֥7ّܨݽߝg}LrMRVsM6r'>~kU.&yDtqmK	b!#&)1,.0q2Y3@4g44M44J3210/.....e../W0'11C222t1'0.-p,+++,,X--]..p/F01j234555431/-e+})'&t$/#!!C gI&v#RwT|rl
^
1O
	SZ"U eTCXnwmd4$^[4
w%Y]jU'NYNW!P~wp?bd%-G+       @lpsD    Oq!`q-*'W8	



J;f0P	vDR<xY`=|dccEf
m7 	"u
-	xJ]C, K
'DtM >v*nu2UrE]v4=8+(PwQ)n:qCd-\#_J5(p<uw_]\L<'h/qx~O0wTk-d&=S[6Kb|:dl5._L|߬܄ܱܻMۜ٧b٣٫wGѬhϿ}͊̬/˳!ʏVȋ»nprһ1%<`Zcktkų νփgKE>JU@)Ҽr?ӊך٥۰D@F&z 2c5|	X
4
Lyr0Z!2#$&(X)**+{+++N,,I--./0>23579;=?ACD[E4FgFFRF
F\EDCBBA:@W?>g>n>v>>>`>'>>=>O>>?'?N?D?:?Q?i??O@@AAxBBBBB9BA@?>=<z:86421W/.,+*)	)3(\'&&k&X&&% %c$d#e"! + tJ(e.7K
;
	M	1J( goC.Fk\}  ]XUMy6$c # ! UC/  d)
+V	e
rK#

Ge_6t+o\42/&a,Dpw?$m&Kp|b
6\hUB|R y&Ilv#6Zf_Y ByAO89_jv9
5p]Hr:od"Q T'$$v<%!5.(:)W2;
`
fKXes0


-kI

O

j
	M	v7u%raM;bA%	h8	j[LJJ0 &R~V)v/9# G a9>DBA"xg"_:y{wFO3qB.ua	1})bQTہڭ*_֒%ϔ2ˊEXlǲ:|ĹS± OYϽVܼMdI|LȱC[
n
֪.ۨaͦ:ǥSb&TY"~ڰò̶s!Xiz^AȈƈCƖĘGgŭȕ˼׸u p3v_{ 	
Melszd 8$'{*-/12456,7]76/6565j55679<>AxDHGILMOPQ@RRcRRP9OMK(KRJAJ0J=JJJ+JJJJJKKyLLLK>KWJoIIHHIQIII^JJJKK9LLLLL"LtK#JHFEB@U>
<9754261H0Y/.8.-Q-,,D,,+++*)('&%$#c" 3_i(
Q

[
S	21Px z$V;6Md|Ftfr}ST"Lai\K5_& %	
|
4QC

wW I.pG}<c  !k""{###Z##""~"t""""
#####d##'$$%x%%&]&&&''&%'S'((y)5*$**:)a('&&&''P&%#T"!G     a` *OuK'"h*j
2
}
h
S

	$	` 
{ _pd7fm~Bfq'X\/BT]fA2P!J)D8m7j8T7!/>$ln`
`8ORJݑR_0ہ0ِ1psueVpщmΏF͆1˝01ɟ:gͼ0\x*mP,W̩KmפSϣL
ˠB"Q욇GꗍKw̑,ΌjwԈZfsI !_!ށxv[چT6]ϗK۠pFfG¡!#$VŤݩܯ 0`kƆ0b П!Ѥ%Te<#NyH^8 4T	A`1 _*P|;  ""u#%'&*,/2M58:2<=>)??>S>~=<;;O:98288
889:6<v=>T??A@@@A2AKA@o@????@@	AyAAB)BLB_BtB*BA@?J><:i864 310/.0.-u-z---.../'000f0/*/g.-,+*)(&%t#" >_I;=1B[ny< P3Myb)RX,[ Ke(L e!"~$%&'2((	)T))&**B++@,,,,,,A--./z0-1X11111[2M3@415$66*7w77a889:;<Z==)>d>X>M>*>>===K=<\<;::/::;
<==>>===>>f?6@D@T@^?j>+=;`;::;%;,;:988777666-65433#2c10//N.-,{+|*})('
'U&%&%s$#"!m  6~{9=]* "
c
N
<

	V5'o&w<  W6qf+SJycEE'T#QcvO)Fl; O
+w ~<M`sB5rCo-k]Y^u=*
yP^LoDRHީ
}ۊ#xJh؆ץ	Oԡ )gE${L7$[ʦʟʙZhuǵŮţR:"76Pf}Xo
͹aյ6s b3Yѷ亇*ƋD"*gfȆƦ345KպO@P`Y s}n* -gX	ij"k&&&# 1o>SI%-5K=DHvK"KJHFD
CA?<1:855F58:@'EKPUZ]`}aHb4a `][}XwUROeM)KIHIIQKM O!QRRS	TTTKU6U!U
TRQOMKKK_MNPRS3UUUUNUcTwSQtP-NKHEB>v;X853*2040//G001822353D3S33'44r5W5;531}/,*c(~&$" `1}rg2I*~`
~oAN25l=J F~ ega[M|>SiK.Ww
2


a
+
j

2{

k
y'9K.'<u/znc UOP
'cK#W c!"###$6%M&;(***+*,1*9($ h"%O&&# ![ #A&(U'&"H
$ "$##!,]&Gi1
fe/
7jnH! 

1f#
Ww	c~oU4 Y  @  !  J}03B+&r
V%+\g&+0#F+i7_Gv,n?
,OrZBݯ*7ޗ9zە$ڴ[؈׵<iֳ{Bջ	V80Eҷ ψΔ͡F˳ˏBd>kF=Ğ(R[dxż ںc2繜:#^Ҳ<?峌OLwM:6=D.6]ʞ(3ޜ؛,$\zXҗb]ϔ̔ʔؐ-J% Z1ؓj/9HfQ(zˡ{Tݫ-}}}FΓ:\ɐ` ҠsGJKMon"zU
~[n
j1YE1\UPp!T$
*/48;;=->q>'=;
9762/e,$)&#"l!!" %x') ,G-..$///600!0/1.,+m*++.W1i4z79<n=><????>=;9w6K30,u*'6&u$#"""O##$%&'5((\))?***;+**))(&*&d%$#c"	!<m+|x[&Ka

i	Y		s
2%

 jdFFzq?1~	W)[- TZ

du)/   X!!""T##*$$%&'&(/)G*_+,,G--z-C-,,b+*K*)))r)X)))R**k,-A/012!33&44A55"6v666?6555A666778099^:::;;;;;<-<;;;z:9p99889X99:\;~<=>??@?>>p>>	?v??>?>=m;
:88[8899:9
86e5433i3J3+3]21B0.-,",+++v+2+*)'&%K%f%%~%{%$ $"a!c dcbS F ; ]hhbF`(C_tC

9}$
	'	O^a U^     9 |_A!VcS!IEfda\&X4(	Z9Q yVjGEX4Qd<Zx=[$c*o>5,29|ݿJuۉ<z׫Hh>ԋBҫрnΌAͿ͉Ͳ,͢XͶlTɪoJHF:.Ħ(3cÒQ)%!^/ۻhC0ϼ"L黇{̻P;&9tR1%ӵ uKDy?i~3ҺR8Zɏp<\٫yw^
۶ֻԿAnَڭBC߯:5\I S\b@	
]
+} """I!-x<!#&*/s48<b?ABCWC'CBBAAt@??W>>=U>>-A`CFIiL4OP)R~RRRR RQPtONLXKI>I~HFHHqHHrIJJ
KKGLL
M-MNMLXL9KJHG8GFFF1GkGeG`GLG9G GGFFFYE8DCA:@i><w:W85l3y1/.-%.R..#/-/7/</A///l00k11l11/*.,*(&$
#!$ }aEp6b@uu@HO5%Nv8?iNZ>
'c
S

H

xD
c"&Iv
L

 =$^>~M,Qh R7Nekr{  \!""#$Z&'.)***))()''&&&%$" B "=#i$$%<%_%%&''''L'&Y&%$!$<#W"!!!"g""1"!q :_I`PYbSXll$%eL

<
		|*j	=BWloI L RX\`\RH3XYH>SQjTfYg./8jhe 	C}]>Bex0+o O2߄ބ!ݾܕlM.hۢMWC0'ז>mhijӑӷHӎ:ϊ6͐=͙2\ɇFf`ŉıøA׿lžGʽm˻)ƺbݹHȶʵ̴]𲂲.ٱhGYJj+ȧyC4* @qi&㠔F	We$3ALXK>dӝ!&읳5-[ޚ˚r+H*Ěם_Im+㸛1ǻ@r+ķCtťzP%ܴ{Q'>UH;~ԯEH޶3ph;[{DSMG]%- s
E.?$
<nT;%E=6i!#v&)+-B.i/ 0000000V0//:/..../L///N00v11=292621
1%0@/p.--f,L,1,+++D++*c*)))X('&%%"$"! KnN.8e3=c[& A!!B!  j5s,XL+M<*"}ct,kyf|8v    !!(""#$%	'E()*,<-9.9//S0u00001]111111(1101!2=3Y4<5667u778`9f:k;P<5==>>T??J@@}ABBCxC|CC-CBBlBBGCCD$DCCB@>?=d=
==Q>u>>X=<_:8*8789:;o;$;9876666	76064320/..C..--"-M,y+*):)(r(/(''%${#/" ! qTg]T}S+}ab
`
[

>	}0U#(, \JysQ/o}:g'Ch0IoB>3+T58ZsT;s3q0/Woc=KI.[fA
HtU6w?8*=pjIޒ#ݳܗ{$.V~ ؁״
fճ ԀҍY%ѣ`Е=jAΔ-hN3Dm &MueVȦuCȷ_[7`Ʈ"ƚ{]ƌrWɣɓ6[ɵʀˉ˒bG-~-02K͗-975\Ѓч҈b7ԙԯdאAQ':AHs%W@j
,S y6
41A:}9^8!	$k&(*s,..i/2/.t.--s---.(.*.+../p13_579;d=>I???g?`?Y?h?w?M?"?>> >===>?AB)DEFeGG]HKH9HGLGFhFEMEDCCB[A@b@ @3@E@{@@@N@?y?_?D?S?b??>=<;:@:999:":9_987C764655A54`432170.)-+*)('''q&%%l$#T#"#"G##$$$$S$#""S!  0@Q7w_G=4pBu$c.p	jxQige7fvP#DH-uV<;S k!"$$%_$#"!3! !^"#$1%%6%$y$*$$0%%&&&%$#"!n!}!!!!!!0"d""^#
$$:%%%%%R$0#" 
5Pl;
nz/@P(ZBOn
qVH
9		0z   I2Nj/?-kK|wp
{js)PqhN
3B$-pcP+[-S:+߸ކUbpޜ 0ACFR_wߐߣ߶߁L<ޜ܊9GU,یrXWVD3ڋCsأ$֔Րhaх~P"Ϫ2Ϻ
_ͧhʆ-nɨZȷcy+qķfSM7{W,/2-'񻻻kںd/๑&DηF17ɴzRųm[J&βj:ʱƱ߱YòEQ!')մR
򷖷:Ӷ n&ݸ|Qr$UĆ	ǉ


iHؚk<ۿCxܬܱܶt3۸^M<ކ3|yrkV)(gr.3		#



e 
Q

v~h/Mj}t*>j 7!!" ##$%&O()*+[,r,,X,&,++++S,,,7--,|,,,+,,Y,,,-$-,f,+b+*:*)m)1)(((()((w(G(5(#($(%(((''@'&r&%n%$8$#"!Y!  D F H U c I / ? O  !!,"":#g####G#
#"E"!t!!    
!#!:!#!!  ;!!"""W#L#A##"##f###0$Y$$$A%%}&&.'&&,&%%%E&&a'''''v&m&d&^'X()N+},-D..C//0011*22 3333321#1000^122#3z3333+445P67{77848]8888888g8877777777_766$65Q544l4G4 4433k332f2!222F2s2a2O21N1z0/.-)-l,++x*))0(?'O&p%$#0#"x"I""!!! KkO!(AYO4>^{|
d?
4
	R	ri,4)n
k ]KtF7~+D;<TP?pcVE3(Nh)~a/^!<cmU=n80H6#| 'AVl~5 ,3;_Br2zN:&h/Mlb1w;L;o.qZ	W J=<#l+p4sCHx\	}DH~
"Lcx %"1Do(}S.Jfq{peF&.5>-)OHP   JeF$:v:llE_		
$
"nk!\<CUfUrYu}&j.   d!!?"""""#7#f#####h##""!R!%!   e  @E5  	!\!!!!"/"O"N"L"2""!!g!! ]  a/Sq?P~n^$4{^BVkkl4+nQ4?I=1eRg^U0}+:
:az9`YTN>.`A"-8BK8&uY=84?JMP;&"0CRaVKl3rEx*?



f

c5

<
		7	z'qV:_
r)P{Z# 
 Q?_'\Pa@|7V9k3CPpbq7uKyKZ/S"ycA}O3\jgdI/i\PZdQ=ߵߥߙߌߐߔߣ߲߻߳ߠ]8ުvBݦvB
ܨܠܙܾ"b݇ݬݣݚ݊z݇ݔݱݕh=ܟwN8"+3/+ۤr\Gnە877>Eg܊ܯܴܣܑܡܰ!?CG(	5[ݏݹݑW$-iݥVޤHMSMG@9K\ߘVk=bp~zwV/f>Fv'g UuyG`zk\m0|}y/fJv(['gv*|1c*o:iC\)q
4\ f f     4zV,u"RR:#;Sh	K	y				
k

E\t7
K
k




+zU{ ^'Qz,}A Az!5IPWes$@^|	-c
/IjvaMHCKSRRH>4*29K]oq\GGGGF=4!sT4]9mIwjQ9JY@&X.}W1|{{qgE#e:


`
5

rT7z^B


v
S
=
(


				y	Z	<		
	wi]QH?(sj`ZUH<bH.#yJ%oO/rV5ytntz{p[E6(08Mbt~~|qgUB4&(+:I]q}tQ/+5>>=95;AUi~%-5=FTawkOC62.("!-9HW\`]YL?0!}qe[QB4$ Y,         n P ? . '    
   $ B a }             { \ = )    , A S e s    m Y C .    ~ukjifc^XZ[ht~re_ZJ9+)C^rvnfdbdg`ZL=4+3;M`y
 ! 8 B L C ; .       	   - : F R ] e n v ~                  


!)2:BKT]elrw|1\~hdao|
$.8<@DIEA4( "20-|wtY?)
.>>>5+3;Oduzph`ceu <YxgG(,0\L{P&/9C2!tj`lYE8+(%#!{r]H9+)'q]J<.-,,-'!  
          ~     y o S 7  ulcktuwfVJ>==CIGF:. iM?1s\C*
 nK(}jW?'saJ4 yncVI9)!
 |wi\A%dE"}szs_QC@=96*
4FW`hlpu{!'-39<>BEJOV\ky	&1Kex"1>JWc{#AZt%DYmv~&4DSaoz"6ETeu
-/135<CP^r'D`w	  % !  	   ' : M Y e j o n m j g g g h h h g e d d d a ] V O D 9 - !   ! ' - 3 2 1 . , . 0 3 7 7 8 8 8 9 9 ; = ; 9 7 4 : @ O ^ o      { m f _ ` a ^ \ N @ /      - < L \ e m s z              &7AKQW`iu"6ALQVTSX\fpz 	
#.:@GJNJGB=:73/,)"!+5=DFH?70)(')+(%!'+/,)"&-5=ELU^`bba]XVURNHA80( }soknrz}yupkaWJ</"	|unkhggfedd`[ZYYY\^cgmrvz{|vof]TLGA         
      RSRC         [remap]

importer="wav"
type="AudioStreamWAV"
uid="uid://c4w613yrggx4a"
path="res://.godot/imported/e.wav-afd23a917709cac233dbed5c4276658b.sample"
             RSRC                    AudioStreamWAV                                                              resource_local_to_scene    resource_name    data    format 
   loop_mode    loop_begin 	   loop_end 	   mix_rate    stereo    tags    script           local://AudioStreamWAV_f312u 8         AudioStreamWAV          po                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    t[hvrzfghte&(IXgR<F~M =^4&H}o lnp"_0H`98J'oW
:B4~ > b [%g|{e;:Rkhe8
rSao1"p& 2 > 5 ,  ;RB2
 ( O +  D2k v  \y @ 8{Uw9YpwS)n _ Q gF\ . M o&h (_'<[ 4  9!	dJ0_}<'(_,pIs@h^,=F  3EW  vDMi&| sdx\ _;k
 W62 U y  x,]( 4 @ g     y 8(   v6:@G?/3Js).}uS1] +
lF]t=y  r+YiL|5GX=""`xU3<4\MVRNK{En@j2Iv{>4P#~@u`)wdQz]^^)8    ) J @ 5 zs tP  : S 2  /ClD.>NH aq   y`    H - c    LL>xx(.AvI	 ;  t^Gs x  J%     y s 6 h~!  oW?  U  < ] x          3 1?MkKQ"1Ad * #   |    Q 	  * U  W - gP9^f `    \ - 4 k  3V  ; o   u<kj[
YsT4

5M5:V3Qoiu5EV  "  z         8s  P  A g   U  Uoon   O G xZ) S  d    a 6  |  N]	  6    j 7 ; ? X q d X P H   IxR
        |    i;6k!9QNLA6J]sb*      (FdR@ 	Ew	 	
)-1|z9~@<9N>.CXTQ7:i|^acV*}DSbsbD7*>Ru!NU\onm,6@ 0`	4eU <Xt\Dg;'.JkqaSD%sEQ\ 4HHH5!$3%b6atxgyh5qcURN@3!#7Vuy}n:|X4           ;}#>YG6-+*\28>PbYP%   3m#,6H[YWH9GVkxoQ3
 uZ?7/2578:<JXrZA(4?Ys$9NHC/
#'$"	+9GLQH@) hB6+(%   p I > 4 * !      ' ) *    	    & - = L S Z N B #  bEA=?@>=M]dk\N@234Kbjqg\J7408?>=.lZJ:=@GNPRY`o}sdK2'
&0;@FHJIHQ[ahb\VP^l
yk]E-'!8NrzS, 	$6FUWXXWQKMO_p)@Vi|}}}|xtnhhgjmquj`ZSW\_a`_bemv}~kXD0(   $@[u    ! # $ # !               # 2 G [ q           ">Uk/?OSWPI?520/.../012331/.,,,#):EP^l	0ARbq{wnidP=#
jZJ?4+"
,FVeb_abs%4CTdozyxqjlnsysm^NC853*!yrkc\G3 
)2;BI[lu~{wvtzh\O_n|sdU_hz}omjw}r_L8$!&$!t[QGHI@6      | i O 6   }s|  4 J V b k t         $7;?;6DQeyyzm_QB90%        o ] K : (  hYJ8'oeZ?$mljr{/GMRE9>DcsgZagil`UC20-15&{pcVOGLPH?-
$5ES`gomk`ULCGKVaiqrv~rnknpe[H6.'7F\stvj_chz *33246?HJLHDINat|t{&/9>DHKKJRZn
 ( F T c e g z         $2A@?4) 
            y n W @ 3 & 6 G ] s l e Q < 3 * 2 9 5 2 "      
    !      / F ] h r n k k k r x }  { t h [ T M Q U b p t x i Y K = E L b x    z t m t z                                 ~ |                    #000,(/5J_ZT?)!%39@0  "1.+            v e d b [ U G : $  zrkgbbaabfjy
  0 . , & ! 1 @ Q b ^ Z L ? D I T ^ W P D 8 : < < < 3 + ' $ - 5 B N E < *   ! / = B G : . "        ~si\PKFPYXWE3&/@DH<0""',/211,(	
*/41-'!

"-79;;<60 '0( 

y|kqwyxw}qd^XZ[XVPINR\ffe\SNIIHZlxoZ<
&*.~|~wl`cfrzrkdltvgXwoliv`JU`mzgT8
 ,9GVOH, 
/QUX:3<E4#$HlhdA
3Xlsg\Qaq~tjs|xnf]UMT\ozbH.BUqbrrY9
%/ #!  		(&$
/Jh+!/P3$8L?2&/Dc	 7Tpnl\LKIZl|  ( 6 , "  
     . F T c _ [ D - ( # ? [ j z i Y L ? P ` s    s h q z        y                     !0>KXd{#(-# (<POM6/JbzwteV^eoytomjt~.8B4%3@l

(((&$+210-)" 

%<CKA8/':MXcSD.2FIM:'$(,03:A@?8112:B<6 (,/`H0zK6!zV?(   g P 8  [;j@a-pS) qH$ zR+}V.e:qOD9Pi>A`Yr iR g;		J

y ^

Bx"
8
pi
	1	YC^4+"&+'" ;dzg;e"*1.+&"h;GZf$    f D " 2 B   qSQ`	,

v4"
RcUB1bb;#   J!!!!!!!!=!  , eg3\e:Qqcqu3heI-bZJ

f

A{ePKF6&


H

		H	uaP?%!k4k<     :w5^$]UL!+1		<

:W


 NMM2


P
Z.
`
			h/7g~a:w)sT6zrj{T > a@!&#b*:EOf*`hhHb?Z,zg]SF:yH%X\ zJl f%<iO6ETKB
O{ENmBH|HsQ-߂(/ݙ5M/ۖڝ4L<׬օէn4ӡ"Ӥ#Ң^Цm
ЧKΞ΀bp̧̡̹̰̫̰̒oM*4:@#`̸(?GN͉͢φ1aВ(Ѿaj#v ՊTעPڇۈ܊ݭ'}[9&f
U
K>2j "v#$%&'()6+,.O/0Z1%223v3345,666y654321x100V/(.,*)(&%#E" |V'6
`o<)*;l\&d{KiK(\vN

%
g


 K1b
H8A !3"^#$,&q'()*>++,-./012S334#55]66}77:8|888e8G887U7686543210/.-,w+R*-)
(&%$#"! =rr1UROp7^p.UI~/Bwyi
?
L
l
8

						
!
[


pw

m"h>
# 3"#$%q&''()*m+,.,L,b,t,,---i.../...].G.0.A.K.--,+*))9(''&%#"! 
y1tn.y
7>F>0,U|i8d P
 `tFM*e&
z
	
iC#
-
	w	0		p<pM/27;?[l8kl | W 2  ?l*Otv &,MvDKwyZ/j?Nw4_~>r:y^QB-3W Rx6]~1kW@p{|"#%	#EiF1oL:qq\[.=U ng 1mV/`,?o.p$7B . 8>6),TXd	=O]3IWy>ILc?}q/J?@z	(ߕ|[LN=٫ؗ׮Gnqyӏ<ш%ѴD{'}0x!̏P ˱zY/("ʰ	5I\iuˆ˘ˣ˭˪˧˪˯8m̢*`ͭRΪGϊ&Ё}LҚRӹEioS׵"؏ٓ5ڇ>܁ޚ-v(kw5:?J[G4-1p&Qqh h:<?	K
 
EQAJH,($2_PJM0AOGrApR$


Y

fF[,


j
\
N
K
F
 
			b	@	E	N	^	n	p	p	^	M	:	&			&	6	P	j							
9
l



5kFR

H-vI;VCg}	  J!!""x###$m$$%V%%%#&X&g&w&p&i&W&C&+&&%%%=%$$$#O#"f"!X! 0 ^Nr$\G5ff)
E
h8

U

		:	b1k7 d5zY:*R}(eN#`(	T				%
V



)Y3T{g1Y


F

	K	b/-/-+NQRrpH_~Lc4|N\RGS\agVD-$8AD%rR2  i $ kB=yLx>s7v7BY/w$80b) l3ydLr.{Af6fA|
&Br)8Z

~eCݳ$܏d9٥o-֠Քԑ
{_[xϢ5ΰ(͗̆˕$ʨ-ɤȎxv Ş=S5NYNоþy0罆%̼uFŻ?麔h=HRY_XOPPSջ.ZK׽a_
v+&Ðiuƫj*ɹHʳ!saO,
ЩGKӷԮՒyظOڽۻܹ݃Mߖg8EQQQHBA:74
JSt\V P5r 5A&|s(r<,Myv| M b7%R<lW)uN.F]<2q_[vF'c  *'Zqgf<		z
P
&`[,+HPqhp- n  !A!|!!!!!!!!!!!!d!! | ' )]kaWsdT[o*\@1.R]0



v
S
$
xr_L;5@Lt

!
2
]



Hx,P2mu
"alH"G@I   T!!!!
"&"6"C"P"]"g"s""""""""w"U"F"/"""!!P! ! _  z&XYklt#>K>5eS5{!`	dl[
g

a	b9

o

		K		f$}Y5dO8 }~vaL4%lY=!cE qHY'  | ?  W!g+m,ZB ebZUINBn+hAf6g1Ha6g|U4h .Wߚ@yޖݩ8ہ)qښ#ٿ\
ؽfן3`ջiԟ'Ӥ!ұ@}
Иωŵ̱SʚAiȂ2ǼǖtR
y)ųŐ\' ĲzC-"
ãÅgffWG!´£ ­¹£¦còLĆ%ńyǠ0Ȥɢ*|1̜U75{:݅CXY
<lMCX
_
ocVh4yI1Cg}oQ3E8F90tM2l
 
uVH97
.Su`K#










z
p
d
Y
[
[
W
T
.

									O	@	2	3	5	8	:	?	D	`	y									7
n


V`
m

8AOyMm/V *  6!!-""
#x##B$$$3%f%%%%%&&!&%&)&&%%D%$$$#Q#"`"!,!~ gydLRpg re
b
_K
,
		
|Z(pZ[ [ ?(3NN\:s
?:QW&Di*gn4/z
ZHOVB3gzcQ9	K\
$v
N

1Mt5



(
3
	~A]e>$?|%4py`7]'P&?Qbl8b@&1n#H\qN,X Uz`{VX3g.K9{
9hzR}ND9.Lva:}dW}@MYT!^t?}Q%tG.taD
lh9`(	|	MKk8t4lf݊Uܞڈ%ٟd؃:ז`װ0֯zFӧ{ty V͕@6-<H1̽̆O+1P{̨V\seUmʆ_<PȓȚȢ Ȅ[3cȕ#%'ȫxU2AQȏȍw]ȯv*lʯʌ̌BχЅуҊӌ_2ط*܄'oZ\\lEf'  [n	
tcVm%ZE* f ~   (!!?""?#Q#d#O#:#Z#x##$J$z$1$#p#""l"a"W"4""!+! S > ( @ W .  )	E*   
!)!
!   !:!t!!!!!!!!! "">"D"G"G"F"e"""&#l####	$4$$$,%x%%%#&b&&'o''
(M(v((((*)m))T**=+++,G,,--V../00
1{11S22v3'44v56g6666777G888909K9W9e9t9999999999V9"998888y8!87W76t665Y5444s32-21100s/.\.-O-,>,+!+**)9)(b('~''&&%<%$h$$#O#"t"!!! c  h
$`@\
o>y3pDU/
9|8^oeGw6NtvttldE**F(c7	 7Oe0|f @Em:Bk)UCmS0



b
5

cm

}
Q
.
'

			L		`;
x&d\TL9+
Bs!t ^ q/  z 2 k~	6NYo39@=W~L~_s%8Sw@kDf^6Rv!e
3-4eޘ&޴?[y~sei|֜4eԪn/|,gЮЍkO
z)$2
ίqU:=A:7ͼͤa'Uͦ͝ͰX|̟^ir ̅;Pȩ̛̉w̟9l͠@}ν1eϡLй0ѩHlҎҷ[ә_֢
FA&ݳWP/sTw1[?N 	@zgT		"

|O 

G&q5jeu^|ywQLRXLmN0r+1
3psL&'(A^bgI-


















1sEEG|a=5	Gc{ubSX]`.oRXD02-
GLOc(!@

e
S
@
N
b
X
N

F+U

Q
"
					u	L		~`I=2_%d9C{Hc&QKIHGe;W#	t
uk@%'
	I		_

~9
6	vs&a8HK(&]} jgwV)X0ONrbOo^$GnP3U$%oh`TVOH6SmC#oSmToZb"F\udRFE@ Et[<?a@ 
G
wB:2Olk-8ztuf3H[w=rn eJ	Iߓ&߸Kzܘ[x-ڱڋ}oxډڧڲڔg-٦ٌل|N.8צq;-#($1Rrגוח׏׆׭׬oS@Ujuאטנ׭׻Ajؑظ>n٠&cڨJہ/܏0u
x7ߋeS@wR-Sh
Exk^]\/7'$cTB		@
e
i.dIZX243 1k5   !!!G!!!!"1"d""""""""""""""""""#<#l####$$&$-$N$n$$$'%n%%%m%H%D%C%{%%%0&d&&&&&u&e&M&y&&&''''&&&&'N''''''(!(f((()');)>);)K)\)))))****&*<*c****+F++++,,*,8,F,f,,,-d--------	.%.C.b.w..j.N.$.-------------z-l-X-?--,,,,r,a,W,>,$,+++v+Z+9+!+	+****Z*/*)))^)9)))((	)	))(((X(6((((((''@'&&f&9&
&%%%X%%$$7$####r#[#4##"""r"s"w""":###$####	$|$"%%&?&%}%$s$d$U$$%%%D%$c$#
#";"/""""
"!Q!  F5izvQVVbkBew~+jNua


{
K

g!
`
		1	VQ{=2q:w1O   g 6 [/{30T3x ?9OvIJU ^)t>Qs?
9:o$hu1>|.ނ8ݪ^gۊM"گڋg?8CM;'ټٴّm>صآؓ؃؁{؀؅؇؋ؔ؝أزإؙ}bWLWYSM+׭שצ׻ׯ׋nXwט.L7 >p{؇c@#R؃صغؿؽغO٘6_ڿ ے	Zܫ>~ofߧ
ByK1^s]
7b=8@:_k.?Q2N
MZ"Cd/hnpaR\i h+rQ`Ub[[a\8  J#<]NF		#


-af
>
j





$]cfi)^chbZgs.xXDwGrR@$Oz+ms-zgW9<[
Ud[S!Ad~&OxvW88:BKKMJG</jI(`Bd31ik>
m/96hEHMe=


R
 
].X2


L
#
				[		Z0pm4l_
N:  ( c,t.Z:bwJ JbV%Ez= a,F.`; M(\*d:r?bC'jJ0wN&jJ3tP*D{gb]I= {[8saRB8(peVG6"eUJGDBG@8$*,/ :X|%.8>HS^x$7J^r	Dy>a$Gq#.:Si :IZl~ UL|(Ov'dG8]Ew1l,r
VO$WMEx
g`!^]MACk3   ;~ Bn+6KY:b(l		A	y			
M


B$s


;3#U+d\%#=V{h9UpzqAS"~?ZoH   *!d!z!!!!K""#m## $c$$$%O%%%!&n&&
'_''(k((()3)I)v))),*q******a*B*a*|***++*********++)+7+F+T+a+o+~+++++,3,;,C,N,V,q,,,,,-$-2-9-@-S-f------.....).7.A.K.0..--b-*- -,,,_,0,+++R++**L**))[))(Q(''7'&&&V&&&%%]%%$$N$,$$##g##"L"!!p!9!  p ! m8vEY(UJj*ZW_)p;*e	^*i4wGl0H@

s
H

Q+{@
h

	h	
	RyC#i8q: jGmF!	kX>!   i % RzV2pJ {S) Sb1ydQD8.$vEr[E2!%.*'!hCz_D oA~pgfebbdeghhh]N1}i\NC9/$"-<KNPA3r`NB70()*3;K\grnkYG.

{~-BX_eefghknpsz~1S{ Km	,;Oc!;Uy$6Qktj``alw-Sy%B_q@iCn)3?>=7369J[m~7Ngjnqv&5DTb|
$,323+#!/>Qdmx
'.*%#$*;IZkw & ' ) 2 ; A G O X l       Ae0ASbqnkgchlu~!Be2?MYfpy&Ii
~ujaP@6,29FR\gy/DS_`bN:% #%!*-0 Y1|vpnkhgknt{~xpf\QG6% 0AS[aehhe\SH<$gUD7*	         
      RSRC             [remap]

importer="wav"
type="AudioStreamWAV"
uid="uid://yog6ws7vu0yp"
path="res://.godot/imported/f.wav-4555ae11d3891ffc1cf0e01d649f7102.sample"
              RSRC                    AudioStreamWAV                                                              resource_local_to_scene    resource_name    data    format 
   loop_mode    loop_begin 	   loop_end 	   mix_rate    stereo    tags    script           local://AudioStreamWAV_06cgp 8         AudioStreamWAV          JC                                              	 
  
             " $ & ' ) * + - . 0 1 3 5 6 8 9 : ; < = = ? @ B D F H H I J K L L L L K J J J K L M N M M L L L L K K K K J I H G E C A > < : 9 7 5 3 0 . , + ) ( & $          
      |vpkfa\VOG?81+%!
|wphaZTOKGB=83,&" zxuvwwx{}}|{zxuwxz{
'3?CHIKMNRV`ir|*6>FLRY`ejt} 	   " ( 0 9 C N W a o }               *06>EQ]m~
%5ES`kv%&',29@GNTYajoty} |rh_XRLGEC@=1$~skb\VLC9/'|n`SG6%           v g Z M = ,  
 paRF;0& tbQ@/uj\N>.zri]QA1$re\TMG;0&|wphaZRJD>83/,'" 	&-4;=?BDLUY^_aflt|#+369AIS\ht!*7DTds +:I[m/?N`q+?Qbnz % : Q i |        .DUg|,BZs
"7Lau	*;Nax%9J\o4EVhz !1@Rdw
&5ESap		'	4	@	M	]	m												 


#
1
:
D
J
P
V
\
c
i
r
{



























































}
n
_
S
G
B
>
7
0
'




											u	i	]	Q	C	6	,	"				q`L8#{hVD2 {jXF4$zfN6!|fP6wZA(tY=!iQ9"     z b N : %  lYL@4(r\E5#ugR=$|jXG6$yk\MB6%vj_SG<1' ~yusokhebcca`_][XYYWVSQQQRRNJLMID?:5037<@@?;73//01369?EJNOOQSY`irz	'2=GRZblu,9@HNUan} 
'6DSbny%9M_o}#4DTdy(>Oau	 " : P e x       !1EZp/DR`r} /=JVcp~
 #)09CMX]abcdfilquz~~|{{{|}~~xri`\XXXURLFC?:531.+&  ypg[PIA9/$|pe\RH=. 
yi[J9(         t j \ O B 5 '  
  ug[OC5(yodXLC;4,'" %/>LYfnvz	&0;FP_o  ) 8 H Z m         );Od /CWn4Oj1H^o<Xo.BWm-D[r,<LWcmx|yuqdXK=5-*&$#~{slaUI>6,%zk[J4	oP=*waC%~eL6!
zfUE:.hK.       i L 1   r`M8#lZI8({hUD3o[F0qcUG8$p^L:( ~si[MB7.% vib\ZWTQMJHFDBBBDFGGEB>91(#
	
'3BQ[emvz~
 &(+28FTdt#4I^t  *3=GPZdoy#2ARbmw;Oc|#4FVfu /=FOUZ[\cjot~  ) 9 G U j        9Qk!Ku 9_,BY|Id~#O~i&	\PRSlI%y#%SB1
"
	/			i	oX@G7&jg bvHNB 3ZJ4"ooA(=(	
&Y^o_O
U
B
	~%+1Om6{rD{Z   _ adgIp}c[T / K$
G-d# 9|KO i$	~
_c#$&$e" p&J	
p3
X	}7^] ] ^!	
a d} 
	td, g.[E%V})Sh|4]1/.'!>\D`{1m
&%#uG߻Wۄׂ(:zAMX=apbr
@fK/[_%4{
DvohvDA>QR&^~/0l+u?l2<ni3=e^#X 7IhE02gFn6#^?ffTt"Ne|^>Xq];3; J J  V  K?K&A[ ,   05E\X		k	F
+
z
X
6
&


#t@=xmjt#~\$,}j>VBi]8PevYgy`Nm#	>
I

@
	r	2	y,uH+FGJIx"LGB<kyn*I,_!
*	F`


.v_K
c	\	D	

U 9 X g S=#9a6p    I,\sW-=QGuC  = m  )Zwq{5	k
^UbIDA}, 	!!"#"7"!+!  l  v!"@$%c&&&&w&x&z&&%'i'''[((9)))#*n**U++c,,-!..//..l.--p,,++v+*&+O+y++++++%++***0*))e('d''''
'''z''!(S(()N)))))*S**8+L++m+[+U+T+++3,o,F,,+*g*)n)(w(('&&-%c$#"."G!X iz0|re=81-+ %%N?AR<8o+[Ym'bGg.P{7C!=cE6ifc? =w73a@ex I!!!~"#9$=%;&8':''%$}##"r!   N {Y6rSl@]75uGq|U.^9?
lif"	dJ1.oZul Fx>ya36J6>d
s(*Ex&MUnyޅ
܋
ۏA&%Ԟ,(%=^L:	ҧҁ҇rnjAҪ7сQΝf˳;cǕ } ē'ð\?u-x"˼SXeq1½_ݼiضl޵õƵɵf5,83ӯljR⪓ͪ٩ETc~˦9!HCR~ࢺ9HƠ
&E"',J۠à/ڢѢƢ=z[(%j٦PK񨕩9sҴ;Ͷܷ븵KG}*!ˆtT3֫قXߋT_o jE	
'
!"?d !g#b%n')I,.13678:^;k=r?A}DFHIJqKKjLLMNOPxQRER}RRSS TTUVWXYkZ[i[[+\\\a]y]]]b]Q]D]]]^o^^^/_\_k____D_^^a^.^]|]]P\x[ZYYXXX}X}XWuWVUT'ThSRQIQPONML;KImHQGEFE EDMDCBA@?>:>=2=<v<<i;:+:98Q87+76J665k55]4321020/`/..-=-, ,+/+**a**))q('k'&&&.'o'''''''C(()V*++
,R,U,@,^,x,,a- ../{//)0011@22b33u455&666667z77o8
99:i::f;<<=2?u@tAfBB2CCD7ELFGHGIIwI/IIH<IIJzK#LLLLYL
L3LWLLvMMaNQN>NMM>M MLL,MvMMMM0MLLLMIM}M+MLL3K>JLIHGGFE;E:DBCB@? ?n>=m=<x<;M;:9q8l7h655\43211,0B/Y.d-t,v+t*y){('&%$i#," hnN8z aJeFVg|L"r

+

Y
		V}d>t7 Sx\[!hmQb8 YNk4			
I
o



q
]
H
9
-
J
f

(pZ

5,r
u
								k	NN7/d$r g!T-XeH.=ce(:YeS&v3ߕߕߖscފ-ݏ۱Z=!]ڀ٢ز%քվԌ\F=5ӡKFjd)͎̦@ʓʓ:ȾB"ƫNGŤġàßx'0Đ? -F^fƿG־ɾZ
nͼN"й{;u =
"1>Oմ jwvY޴`bVI4wj? K;ڸĹ`8U9߾lF@oսɽ3x3Yy; ÏiQFƲx_.ȺB`ef ǫz'ERiƴ-ÆÚFKN?aAAb4̾yu..w~Aq3qU%& +Ie F6	v
#h]"&t*.1456:6555B78p:%<<<<);s:92::<z=>I@AAAZAe@p?>=/=<<<<<|<L<;I;::9T999X::;<<=R===>>!??n@@DAAABB(CB~BA?><;:::::9947S520.,+%+*?*)'%4# />!C"n""h";"b"}""I##I$$$$6$T#r"!   !!
"""#!#6##"5"w! @{7guh\l*1:ctO+!#$%&&&)'n'^(_)*H,-/$0-1111111g22!3c3 322e10/.U.--,7,A,K,,u-...//.d// 1w23V555F544p4m5q678 9F988889:;2==>>>=p=<<<u<,<;9753P1/b.-,+s*j([&$! M  !\!Z WZI8@?<"T=R
7	H
 }/,+q46#v)iv<3sP(~c&4/{*zW$3EMq#K==L/^<TJq	ސݘݠݟ݊"N@"Gӊs$Lχί)w7ʂXɕbcrėI\eTDzٹr^ǯcثs h2F^von͜+ݚ\*֖teb`ސ/}ʐ\ȎʌӋ3犚Ԉ|9DNL_ԄI܄̃Ɂɀ`?VrV'I^sJR{_J
T0V+ ΋؍ǎ$ɑ^ՓvВ~ruNiOݕkObܙkۚ0*Н99Ӥתt?̯Ђ;!؄w5/#X4IlgF	c
S""l#g"c!  "V#%&'((j(1'%%%(&7')+,4..1.,+*b)((()_))])('&`%#"!!!"G##$%s%%&&''I(())*t+d,,-Q--+**x))~*+,-../-~,[*8(&$w$$N$$$v#X!X	'G+ S!!!!o 012K !!!"r! 2 r};  !Q""#E$$$%$9$#1##"e##B$$%$e$##]""!,""$G%q&'>(((L(R(Y(k)d*0,-/1244655o679@;r=@BDG'HIIJJ_KLMNRO+OOaNM)MLLKmKKJJJKK&LL
MMMpMMMMMNN=OOPQ)STVWXXJXWWXY[^u_``S_][[1ZZ[[a\[f[Y.XrVTSSRRRR{QiPN6M\LKKK}K1KtIGsE)CA@A1A^AA[@&?=:9B8{88r9<:h::99765 555#5#5`43+20S/-"-Q,+*)('q&o%h$##K"m!> xusAQ'R
jQ9|lH7Ra"

N
5
 
	:	 2@o3#8$Z 62cP+N}#:Dn|my<[zoM=݈cCuٜpCժӕҀ3̵>x[ƷĠe+ĶLۿMHݻNxk9	նHyN!/XưO79730:L`qʰI
{	2βGa
";Q"ܵNҶﶢSBqfﷇܹϹu^ݹsŴk'crڅQyOW`;-6)b!;R A%_>y		
YY
:_.!#%&'(|)*",-D/70+1g111123=4f5689:<K>1?@@@@???L?>==;:[976532v2)2s22.333333+4456w76889{99:L:#::}988p88~9::::]:987 76J5}4321o0.4-*(F&
$"!!!!H"K"M"!!D!  O 4    jM@Hu&  z!$""##"##"""!\!i u\KrD03.E "$p&F()*+/,,--./112t2\2X2S22b334I4473O210t0'0%0!00//_/;//(/,/..|.E.H.K.---u,++<+***)4)%))d))$**s*_*)('|&%G%$$3$##K"!6,%fjn

ysY@   !o}>~`!x?b|yoV84 {6_e~_.QtL$rۺ۲۱ۂ۴ڃRY`^ZbjڳNۡۊtlkS;wٻ$+4~t`֝_!Pռvў{ѫ ѯ`ЛЈve]!`
͚ͣ͑b"ͲC_Jʑ.ǁŁ!Ā}þIR;ӻ6bjr
ky2
09٬Yb vӧ6jiwK </ã~Q&Ԣɢ2`\C
Ӣ𢁣ͤWcare
 IܨͨިΨ1%yYŮ|3A_P@JV&8ƹ	9>_ҼEC9
;YE0Ä/f
[>˯m+K:д"Џj<ϭЩJCҞLhպղe`\՛? -[ػk"! 3ބ޾ %5!bk<k

f>Q
s+1H| t"P$%)''W((c)2+,F036:;===<<h<==?A{CiEFHHEIII:JJKMOQSTUzV
VUTTSgSSVT.UV;VVUUShRQPPPEQQsRRRRkR	RQiQ)QPPPpQR/SOTTfUT4TSQGQP-QQRxSSSRQON8LVJ4I=HAHFHHHLHGE&DTB@?>>??^@@@W@?>><;c;:&;{;<<\<$<";: 987P777q899:(;;;;l;;[:999:\;;j<1<;N;::{999:@<=?@kA9AA@@]AA	CDDE	F6FuFFGHIJKdLMN3PQ<ST]UVUUT@TTUVWXYYYYY YXXX3YYZZ[<ZyYOX%W'V)UrTSsS/SSRRR|R^RQ]QvPONM|M+M}MMMMLK(KTJIIHHCIIIIHGFEDhCBA}AA@,@??Q>=;:9886543o322110.-i,t+q*)b)	)(3('&%$$B#w"!! ? %  D;36Li1FM
uZA \g$

S
J[









`
5
	z	E		 	m!=BkepM ~ & cW\CQ"'b<|AXmpF"It E|yD
e޸iYdٗ0q!זGք8Յ&ԁ4ӣIҁҘ%xA
϶πKεΊg6ͦ~W&  'Gft͊͸HΝ[}ϐY!NϕϢϯ{L!7bυϸ-Hb{ЕГЉ~bG,$dУ1Mhfgщѫ;ҁҹҬҘҡҫҲҾҼҺ
<bӏӥӻ#3>WoԑԡԧԭԬԬԡԖԎԖ԰3nթ*Ieֳ֛=_v׍ע׶7|_٩6]ڒRۏi܏TqQ
5[9{~1g LmIPgYdF.c0 	 1b@<st{0>#9BN~^
'A=630xCpppaX#:Qdo>
Q+ v   0UbA\z<mENQ\`		?



d
?

		
_

	]k
E.#$S
+
U
T
S
J
D

V

m.JFBn)?U2~S	0












i
N
&
~D
 J(
@
Y
^
e
W
J
-

L4gz=b




=|{eaSF9
l

		~	c	i	~							t	1	
	o4T-Nne1])o-xl8}];.!V[!   ] 3  Y0	qB^J6c5	VB tE^/9On6p<wR0
S	yC
n[> G{Z7|\>#uY<&qV;&|aF2l<tP*sGiO@1#{_@R>) W0	
'4J`nyjZSTVXYayo>kcfr~~~o`UN^n           
      RSRC [remap]

importer="wav"
type="AudioStreamWAV"
uid="uid://dak6xqa1ghei0"
path="res://.godot/imported/g.wav-24d203b77b4a40d092d3a30998e3c4f3.sample"
             RSRC                    AudioStreamWAV                                                              resource_local_to_scene    resource_name    data    format 
   loop_mode    loop_begin 	   loop_end 	   mix_rate    stereo    tags    script           local://AudioStreamWAV_jcgp5 8         AudioStreamWAV          S                                             
            " % ' * - 0 3 6 8 ; > @ C F H K N Q T X Z ] _ a b d g j l o r t x | ~                                                                                                                } { w t q m h d ^ Y S N K H F D B @ < 8 5 2 0 - , + ) ' % "                 
  
   	        }ulcZSLF@80)#
~{yvrnmmf`_^YTPLHD@<5.*'$!
 
	 #"!	 


!&*-1/.///.38=ABCCCA@AAEHLQTXWVVVVWXY[]]]^_``_]\\VPNLJHGEFGDA><>@ACCCDEDC@=<;:8;=AEIMPTY^`adgikkkjikmsy 


!"%'()(()*,---,*(%&')+*)***)))))))(('&+0124555668:;=BHKORUUVY\afmswzzz{|{{wsrqqrvzzzywwwtqonkifdeegiiimprswz}~{{{}   + 9 I X e r                                    | v q m i k l n q u y | ~                                                    

#*/34432469::9<?DKR]fr~{o_QC6,!                         	#1BScs!+169:9988731-'	xcL3                               )6AKS\_aba\WLA4#
     	        .?Rex)4@N\iv{~qcP>/!	ucQ=(                                     $,4=:81*"                 y o f d c c c _ Z D -  ypfa[WT]guxdO:,)5ALXdjpnlfaYQ?-


	r_O?3( !'09EQbtwmbVMCBBIPOOJF@:)^3pVTRbr{pfhiv;_
-?Raqtwne\RKB9/# pVF7'f?%
1MavkYG@:AGS_gpv}s`NMM_r_:oW@3%	|hM28a!=Um8iFz)+-*(07K_n}|{gS;#Z-F|iWF6&dL3!uf_YgtOG<i5Nat
&BJR@0bA'"$8L`~&;Qh+Hd}    xhYJ7$sK'%=PcxIv ? j      =\x&,1!jQ7$
	
      .9DA=JVnxeRSTgz{|D i :     ' . 4 3 1 4 6 E U Z _ =  hggq{# I n     w c H -  ~cHUb B k         k G A ; D L C : *    ; Y         Gv=  T N G _ w q k ; 
  x'b[TUV>& 1Qq}|oT9""TY # !    7 F U v   b'4*  /Hamxg]S|;phS>DKC;!_h<  En<q`=(6J^C)rW;   \ 7   L
)hdX.jH R {    1g}egitm\2	            v ^ ?   n4   0kyq\B)   A W!k@.>CGGFYkq+8U=	3m  & - F06Qg}~ K y    h :  _2R @ a }      B6iE"YYYqrI    } I  bM8DPl	 ?    7\zsO+4\%R4w-a:|`EIN0   ^ N = O a    %!    @ iA<^eAEZ( 4 ?  zM 
3v(   %o#JqGQ[@%bCHN}"O}b;d}3   	XK 8}E*s	7  k      I qK$R
  lJ(.3VzsmD %b< w          ?Req}[4
1D:0    j V C c    %MC9    
$  { 6 1 ,   CtP?.*&            ` 4  
 :  	LX_>KWH8FT:`{yY5{hH(NTmQ6ALYfK1 ;gJd${`UK<-	{`~*9y257!HPEI4]w,h"#-XC/M}_pIFQ[{|q9RG;'<     8n4v_$&O$7JlH2i,Y$Z~T    q X @  * ; M 4    . y  w[(   &To6/Q~EAEH!whfe8
g0NwdG)IhB4{Y8      ;7 p    > 3 )  8  *\kYp:l:<=KXJ;D$Ux)l-   { v   *ZUQ>+-.26Nhq{O# 3e	!?]>r:]~F@(c=*^XR-2iD'{'  -o"    m I &  {MyTY6  m J @Z  0  } ^  ieA
5wDg@K{W3  K"  h Q   &   8W- _ M :  -HtySA.v)"NzL,PtY>(UoyNM  =  >    i & 
 4 z        G       lIggeb3y@A={)R V:LA5_-	!fPv6Y EXnbW=
!v<7  >-
;  JW    } d Sgys<_ j  D pu 3AD
Ygz#D/  c  fGe}siuUDF CBu?;   J=Q P92&bj("k(~~~`BPG\rynG Ux<    n S N 6 *  vQs9=1@oY:74MmfE:2)@jBl%XMC0/e t/ *@zN/8 ] D + [    ; _D}0
sgRDY!FoRo-"?[q{i_*&u&w6+ h       E C B ,  T
aNO=4,
g@8^hwhV}X.B_w8       GI,If%2Ma@       : yV3,UnevTYF3RzmaGan
Z-b~~bK5cB  1O0,GRi6(IPd{k"_*XR@L_(zW^jJ'bX5Rq-	j		{	U			7	q								
B



08?0$





e
7


	l	!]

)@Ufv9w"	w		
k

J}zd=









C

				
,
'
#
			A	!		'	H	|			

 
		R			"	>	Y	M	O	3					2	h					L		ArRX_,E4  _ 	 r[|n`(z`lT~PiQ9k$p_+`5rdXvd	iT&0
iyz[6b߁9ްw#kݭ@۝ۑۄx[fٌذررؚ؈ؓ*aqy՗նt4՝qnєrQ3Г	αrd̘HkιNϣ(Ф4hcӻӱӱv}֐פ	q/ k٤uٕص\"fժ!՚ԭ~3҇EiҕЅ2Я;ъ҉\/ϳzβq1?bѩѯҌӜԬ5ypKٴکP?݄݇ݨn4Uv8-Bh{CFI?.:xog /U	
Kgv1y:n *!! "!!! !t!""""B"!!!!y!!!u"#"";"w!! *!!D""#Z####o###$G%%F&`&z&&'Z''l'H'''_((>))C) )(](m(())[*+:+X+****R+,$-*.w..#.-,++,Z-./00i0//y//1B2345e6m6k6"65G667899q9d9Y9[9f9q99~:;<n=(>V>>>??@ACCDD
EDDDEDDDE0FZFFEDCBAwAAA=BBBBBA?>5>=====6=<;:987i7g7e797
7.6N5X4l3322333~21K10!0/////*/..V-,4, ,++,R,,@,+*)('&\&s&&&k&%$z#7"s!     X # C|N44GHMuY6Jw$r
9
+t
y	J%3n+& m>J
r!?k<w|]Z#|5e/l-2g"PUݞlXFL׫vH֋Cՙi4ԲiӎRқXѿ, XϿ,ͦ ˡ ˣʟɜȂj,ĦqhÝ6WȿviֽGҼȼzbek#8оg3ǾHý^Rỡ`pϹ8丐xf<O1B2ga`5r=
As	?xְk hѰhT{wK¯=nR<$߭%<x&aSbwoi8ՀڝݧH	
iK']XMu_
>
j
m

.





 |Pd`:psv|+d	3
L			w`	
[o
	:			q
`lf`E0
E|bB(
xBWf#LOC]xH>kf>SehBP5hY%[Sg}:#x}'S\+=U2gY5M) Aiaks9tjP	c={e37GH@w-1n!{}jPXv/`:$KwP=_Ix=!FfE &rWf]@R&pSsh[
Z=`}_A9%-1<Vl!6"!##j$
%%	'4()*+,8---D../012L3
321*100000 1l0/k.-+2*z)((/(t'&&%#!h&f.i{f%Hq997
|

eg@_(
J
	Z2M'@#)r N ' r   5$   u[Z4	p`D)Ovi\ |O's{N!.;SkO3K+AJSzۡzFبXطf׸֗wj\:Փ,YӤ[+Қ:ҟ|ϼυπ{()}͸LˤMɄ@mnpčùMʾ*d]&B^Ǻa¹#g*|N)"1	%iiloǴ'ǵ8صµѵ۵ϵx"
`@,s~
1<Fb}0}MvǟڡϨ <vְ|T~D	=!"N$%&O)+/
47X;<_>k>w>>=G>>[@A4BB@=\:7545666530I.J-K,<,., ,,N,,N,,B*p(&-%R&w'M*#-/1C1m10t0u1v24678 9G98686>5c310///{.-)&# k J!""5#!8j	>	:{p .!"#y$>%&(S*,.012'4455567%9O;x=?@1AAAAPBBCsD?EFEEDC2CqBB&CDEwEE^EDWDCDLD3EFFGG1HG0G3F5EDDEENFFFFED	DC\D&EF?HHIQJ_JnJJIrI4I~II$J~J
JI=HFAECBA!BDBOBZBIA7@S>n<	;98I8775Y4D2/0*.%,*p)(:(''%$_#!4!k |   !  %  ymbWmU{/  ]!!!""""v""X###$r#"!)!   !e!!!w! q s u T!3"#%%&&'"'6'#()*,.~/////41257@:<=?>> ??D@lAyBCCC}BYA?=0=<<e===C=<R;:9%8!88V887e7S6A5H4N321_10005/U.-+*h))()?**+a*)('j',''/(()9)(}'&$#g##Z###e#E"%!7Iqjd&9eWI8&\a2
_:QKDvus8bOp5Kg|Ok3

	m	8u\j{5zc/o ߻I'vݭ6ۈڰR؜D?w֮ՆmS~Ԩԓ~hӊҬLϵ#Αͫ˵ʤɔȃǶYfĚ3ù@pKP;oݺOB񳠳PޯI`?ڭ`*6BYp*^ث_5ì
Xfŭ>~ko80
V=ꭿҭ#魮CHLǨkO3Ǧf4 ̱,Lǀ̳׌T;ss SK"%&(L*+j.048_;>B@AAAA1BCCDaE`D_CA><:9t8X8<87K75y420p/..-@-,,+/*('%$$$%&'+)*++,},,-d./01121K10.-h,+**R)&(&%
#!UuB\v<
mR
S
		C	,
fnZ*Z}d !"W$%;'9(5))+**&+	,,-1.D.W.--P---7--..O//.0~00911:2234K55656	6555_664777 888778!8899n::J;p;;;;A<<H==?>>(>=)=<
<;-;:J:988#706K5g433R332,2^10/.-2-,
,+*%*P)Q(R'&%%.%%$$$P$#|#"L"!! 	 %+0'WLH7:H5:=u

VA
	A	IX$3r	Q	j				,
v





u


T`M

8f5&:N* vk9GY    [ '   ValQV
sI

	b7 q~j\ 
+L1iJ@e@lfc2YpY}O\hC:1 Q'VUT~>qnl.WD^ݵܲX7|ھ3׊ՔFzԊӛ~bktΪ4̉8kǝhvEæt5Ga̺3AI,h]򰇰kFbyUu馡Z=!ΥX1QӡVϠH6xʚp7Ι虱H\ؗ^`ە> _O呸őӑ)Nr̒ܒj[K^q&ܓf֖]̘jםCbY1DyЭu
^QC-o]333ặܺlb'ĝǥ8&\آܯv0&	
v|R( "|$#&'),u.024r677777-8C8Y8/88g7654&4P32!210//(.@-L,W+t*)((\'&&%>%$$'$#j#g#c##!$$%{%%$&[&&&'g())4****)l)(y(j(Z(B(*('&&<%l$#t#K##$$.$#V#"7"!~!z!u!9! , [x&T a!
""g#$%%' (A)d*p+},L-./0I123456O77J888N999+:a:T:G::99N9 9888888e878	877777777e7076z6#6555
6A656*65555S6678C99>::::;R;;<)<O<*<<~;:[:9\9888f88t765.543R322x10/.-,+*)(+(i'&%%E$z#"[""!{!6! v  @W- Qj- X      !D!!!!!!u!)!!!!""#$$$$%^&(*-0C2333n33[458w:E;<:98^6I656K8a:;=@=<<;;:c<=?UA[AaAC@%?e>====>>M>=<]:8}76k6i6h6654|310J/._-,,,+
+f*<)(l&$#J">"3"""H"! L\K;,i]UMZhZhda&F,GqL
c

fI

s)
^F.N
S
	W	"	d$~Ep>
&:Ng }W	X<tnhc]qd"Ny_d[80G^;ߋkܿ܄>۠GoږXؚ+ػ.ס֕:ԘQӓ
Ӈs6H 4j͠̑=ql\ǴǍǟǱǱǲǕx6ƭgASƁƯƺƾƺƶ+ǟ]bfQǶTƍ&ǿMȩǺjzodȠ}ƊMȡp?fɊ0˽J4̼\ˈ˴Zsfgh5Ӛ3ԡիմCv|҃LV`Ҕ3ч;ѬТ%ΐkFmΔg`Y҂`@;342:?VkU\[lz

%MstY.  ?! N 1Hbex9
H`        ?!!"b#	$3$]$$##6#5#5#f##u#S#""J! W ! : T r  ^ *  qY#Xls{
X F^Y= !_!!!!?""#^$%x%%&C&&&a''f((;))))))))B***U+++++++(,b,,-e----------".c..../......./}/////0/..q......w./.--;--,,,,\,+~+**)((Y(1(
(''C'&&E&-&&%&5&9&?&%%1%$+$#p#9#X#y####g##""":##$$$$f$$##$\$$$%%$)$#o####$$
$#U#"I"4""j""""J"!!_  vBF|	yO[j1$Rn:u[
B
^:

3
	;	jBPk<H2S z E  \ y=%8(p6RRgm!xHe	S7,ITBmTwݺd
ܡ6۱,ڡكwֳi$Շ.ԃ7Өc҇3zѽ|:ϴςbC'8UJ> Q͒F̏K̪Lʰw?ɢq,șKCǠ{ĨWD1ÈB«r9@FC?	i>,#-4;㿖H,ƾM|¼iP?/37^
|Abںںĺ̺Ӻ˺úͺ׺ 	'@Y'4:?/'/6=;9\ѼWؽؽٽ6NfF&'FfF%%[l}rfdbƾR`"^WÀ$E,ǖ*ȽȢɇr\cβg;Ҷ`
՚*ֻLoٽTڄܿ`ްށR!=K">f5L@<=w3t+RzD 7X
W

qY%aw  4!n!!"{"'##p$%P%%%%%(&&8''(*)))*:*V***+h+++++++++,8--k......	//20000~0/Y/..../\////\//..g...6/////_/// //?//0`0000}0s0001P111122&2c223344X566.7a77~7i777q8"99q:w:~::9/9892:;'=5>D???:?>>==>? ALBB`CCB#BAAABCDEEEEEjENEEECFFGQGBG4GFFFE:EDDnDDCCBAbA+A@@A@A@W?n>=</<;;;;;{;;T:9877_777787765&5R4"43m44a55554%4@3[21112k2222@21C1000000z00/</.F.-n--,9,++a+3++**e**))&)(A('m'8''
''''&/&U%|$#""~"""""b"!  fr4Meb`1jg788SL"1t]g@_Pko

t
H

,
;
M
_

6

		Q*r_K?3\}B  H  g*n7 ;v2C
]YqoI	1G~PdE&kw mI"m?sCN3I9(xq{hN7 "$Gjlo4[0.D.q`u -Zgsuv{XE3Ol;0OX`\XRJIHV m~:y;c%aDJ83`@x;j`8&/7McvOi 3JalB6*D^1$7%x
AypMinWF5l,: @[v  9PF5i"UI8			[

9oN0
t


4CQ;%

 !&




















w
n
e
T
B
 
}ow~
'
F
?
8

scRA/)$0<@C4&~pa]YftmX3



q
Y
:

			r	O	+			oS/~O%m@vusleE%i'tM&a@.O  T  ]:99(x#         
      RSRC [remap]

importer="wav"
type="AudioStreamWAV"
uid="uid://de7vsomqytjkp"
path="res://.godot/imported/h.wav-eca473c5f5220e67bf602348b0f5c69a.sample"
             RSRC                    AudioStreamWAV                                                              resource_local_to_scene    resource_name    data    format 
   loop_mode    loop_begin 	   loop_end 	   mix_rate    stereo    tags    script           local://AudioStreamWAV_cqcu1 8         AudioStreamWAV          P]                                                   ( < @ E = 5 8 ; G T [ b g l p u }                                        i l o           9Uqb?1"5HT`K6
        t @  hQ9$$8?E7)#8RpoSH=@DQ_ . 8 C I O n      
(1           l ;  b2w|
3\~\6,"',"rjawu^J7'\.  *49>?@:4@Lt $4Eh #8NorQ0+'=STUA,%wJ	/O^mU=6.<JQYailo#<TWZVRct~{xuvwwv~qf[l}{_BFKVaglx  # & ) ' $ ( + > P E : 4 . ; G [ n n m i d o z |  s g F $   
  vgZN8!
';EPLH<1*#9P_o^N?0@Pdxwh_Ugy|]ZWlsziO5@KU_SGOWgvrohbO;.!1AN\VPQRZan|rfZ]`ho[F
!%	:fr~^>$	$>g 3 = G ; / &       / + & ' ' 3 ? > = 6 / B U w    w T 9  % , K j      q U 9 ]         }   x j [ M V _ |            ) i =  ) @ O ^ X R @ / . , 8 C D F L S Y _ k w {  s g Y K ? 4 ? K f                   { g S i    v m    6\=  q P z       K % # G   0ypg  v  bl.    [u?	  
'1<      8\Z4      )  l S 9 I Z z    _ 8 '     $ (    ( H h      \ ^ `   C7*   3*!          p P _ n   E(
 | N  4 J u     o [ G M R r     y P ' 6 D m   u 7 1 v     i B u   <JX  t y ~    } q d r         q j d d d P < ,        & z  gS@   a ~    j  I)	5b8 f  y ] ] ]       r |      afk3


k$6H9fO[
]*3
<	FPD8=)ak
-Njnz'=m&K{t<FC0  &AR"I)0I[ -+W{z3^(G8{i@}U,3:NaxydyoeWIc+x:m(b"bnxX{Gh0x{~#h EuOF= C ߧ߁ZG455J^߱X&}Y) s1 D	
*ia?6Y|*6n
WA8
0	"<d{2F!f|r+7
fdeY Ow"C7*tN(+,_F;>w5Za:		i
N
b^1hLEOD
dmN6-d3XD|-

3
Po

H
E
A
k


*tW@

tc`iR[/
hqH+@TI=	yc3dL43>eeeox!J#L<7tib

Zgt
Y	=w@ aZ+
50"hu!YXrHqIk8)vkp!t[ޤٺةש֪մԾөҔArY@z
	R޺ g=̷޷*d>ķoT9z<ɸ 9⹍uս8Tsè439`)a 
P!"#L$$%'(*+,a---.:.g...-,k*'-%["m0
o	h(Mkg-Hc^FaA+w&XjSoo		'	U(	"
D7iii3:" !5#9%>'/)!+-//1Y3\5_79:
<p=>?@RAADB]BuB?B	BAgA A@?Q?><;Q9k7531/-+)'%#"6 jF)q]>UNr{0g]SCi
D{_ !"#$^%%|&&&&&&&)'R'I'@'&h&%(%n$#""N! ApaMO:h_nI$SE~/AR5 

;
		 m[	6RKRm	 O  GD|aAL{X{SB2;CDE-.<[r>'La8t	
j
f&
^W4
3
#Q
=
	:	eGW  VpgQ;BYT  '~#b@#-8
}{sl  ?2%a\WPHeVl
ffgE#ޒw[uڎim֟:ջ=ԦaҴ;y1Ϣ'ϭPͥˈ˹]4
ʵaɺ^ǪzŊm>¯ nGfƻ&Zh=&)C\]٬yg˨㧄%Kp<Ѧp[ۦCRթ_.I"B~QJqJp-ĺwUr֭;iQ)>"&')*+-9./}1233243$3W210T0/.0,)%!7j IXgdamy!g4Bۄ֊:^t؎\zݘDB^5@Ke        =	
]
	9,GpOx!-$=&M(g*,.1C3z579Y;=\>?C@@AAAAAAAqA
A2@V?=j<w:864202/}-+)'&($M" Bi$]db=
N(?D$B!"F$-&()+,..//_001]11222222
2110 0j/.6.-@-,d,++R*)	)(a(@(C(E(9(.((''^''&K&%%%$$J$$##t#=##"""e##Q$$$%$$($#8#"	"c! 9, q45
/	P @+ e  a:(wB  x1][M>x	


\lptj_d8\|T.baqW/6|1hpD& < e h i @  bC0OnNC
o
e
	K	X`[|
XXD			

-

			m	7	
$@a ygVco+]!iQB-i/P\N:޴/ݠ}fv	ٙ*ت*׌fhIӠһϳ{C &OƀűįíپF"ݹ׸?5>´Gy^Ƴ۳c.bG-)&NطcѸ?	QѺP:ƽPrs Ƣ[̽!Ә8
	v'b!)#$%^&''U)*{,
../...e.X.L.--+)&g# +l	Wd #)q[D RߊSڌ|0NH?C rK	
8!r?_%tk !`""/#s#### $$u%& ()+-/1 4-6Z8:<>@AbCdDeEFFGGGGHGGG]GFEDCwB&AD?c=:8631.Y,*'o%I##!$&oh$.753h@
N
	k	+		

,39Wu&`ME0XjT[b=Xr

VE3@LHE>8:<3*A
p

	>	`@8VXZ:	X	> r'Lq'o,wKpc#~ 	Kw)B)>QjiiD ~    	1*e>s   V , (>AVM2w*KlKyT.}K{
Bx/`|H	 'Ut;6}]c0
 0uIuhZhvW9-TW7:6NLD߶)Tܬ=`)ԿӌR΍UɻȉW"C¸-]hB~XqŶ=EǮM>sfߧn23¤RZbΨNϩ[4ůUi}2նjWEȻ]N$Fנ4o' 4"A$%%&')P+,[...-Y-,B,6,*,++),'H$e!C ,8f8
 	$pHFDR	;{N" S@.
5
|"5gwg!"#*%%|&&&&t&&%%c%%N&['g()*$,W-b.m/013=4I5U66_7788	99Z:;;0=~>@BDXG\I`KMNPhRYTJVWYZy[[\\-\3\:\\[I[ZYXlW6VgTRPwMJGZEB@.>;F9641/-!,*Y)'v&0%##6"!  47:Y1	2{R* V!I"=#+$%%&'d({)*+,,T-e-w-^-F- -,4,++*)D){('&%x$a#b"d! 8D}
=p7_3Uvo] X      _  )){"\OBa9x"
X
V

d/s`aS+?V1}F !;#$%&'(j)&**+]+++,,,T-l--I--,,+ +*I*)R)(I(')'j&%$#"! :Ts_I2*E
`z
		L<,Lk8		

.Wx
> HPX

_

Zw
|
	m	2'C8- G#u+;.57>YC@OFߐ0߾L݆"ݿRtۚ2ڷ<G[a/Մ fҴTЦ,gͣC˷+ʭ/ɹDTc ƜXſl`n+==ʿX*;tM׺{ӹ)8FֵFIĲB~Ѫ#hʥޣӢE	͠b$Pr}ɸο:Ρ]$j K#e&~),./012{345=78E9:9B975{31.+(%";h3[K.%`)$wys&zO) !kK 8		
O5

E
e	#I
2
[Qt5yuv!#%(_+>.13<6;8::;=9?@3BCDEbF0GGRHHHHHHyG<FDC
A>b<97252M0-l+))'G%#C"!	=3X*^H
P-
$/_5uV-62^
I


			:			S

Ql

3Y

	
<	pgT
?o 3 i^Lavh#I#.NP`K]!w{$>XgvlcZQw9*}s,pI	=k
1 v*
F*!\P
m	GI2 !}
CKIbyG=2i"xLEL
lJ\er!UL[iJ+	l?]$kOo(a9#!9G0wr2 _'
0Z*iC}+>R49]rI|Sf8ݶ܈iI	֞sԊӢҺ9Z{_ˑlʞȯǎnO!@ռ>I۲PƯW謜O ܥJ򢃢,D'מS4؞zXB-؝g雸W`ƙ1~aY u'ذظLϱ'{J
*Q 	$'+z-P//&0(1+2B4Z67E98]84641/-+(%"jge9
'=B
' 0 bi">4)| lf[	O
d
y

			>


 
	$4T#
 
.			
M
ortR/|+  j!""f#P$:%v&'|)E+-/258<5?NBD?GIJ;LMNEPpQRShTT_UUU#VQVVU{TCS,QOLJgHDFCA?<9H745"31{0t/m.F-,*)!)v(K((('v'&;&x%$#]#","! Y 5Zpp@F*t  !	!! x :  . 
 kSKx+c[zLR !"#V$$%=%k%%%
&%%%7%$r$r$t$$S%%~&&f''''''j'&J&%%$$#\#"q"!z!! TwRm@KV 3D{@\vH`FqV;3+(%&' +-gX7>0; !"$6%&!()+,$--k..t//R0h0060/E/.-&-,+=+*)('&& %/$@#" =
b0~`q	;gM2M#l<2e]Y#{"SiOJ


y
M

uS1e!
i

		P		J {A j)|,( k  - a-Mm<m/(WD23G\m߂ޘ݊|ہڇ٦	2[ԙHҹVЊ!|8͊9˖,EhƊ#ĖÀ0hc]__3ηpⴥh.󳈳eB	ta.[~
sOt~`߮^ӭGͬSޫƫTͭH ̐87?HvF
YKiD "%^'.)i)))u))H**++]+b)h'$![fqw~	

:Pe
Vc)}feYUJ m.D
yc

l@f(4uX+Nr_M}
R	ur	
a
R$}lc !!}"4#1$-%&')S+?-+/51?3[5v79;s='?C@_AABBPCCyDDqEEETE EDDxCBA@U?=;9p7?5+31#//-C+V)'%$]#"!u! ! 6 o-Vc;T0;hLWba579<0HCbPSmWz*x1:`5SNJ2`IU<rQ
*Oun
^z

"
	@S9|k vZ
 a  ~dG#+@Am { 
 1<96d0#  fF	
'+
.DZP0(rtJj3\&T
@(  
kERi%07>KXE3jWDp-zZ@Qd)U* q-[+RvB
t>b'GQ%!-IGD/-AiՐԯcЫ@ΔT̾4˩eɟPƎ)5A*$gb _:4#A[Ů/jësʩAd/s	?c\ʙәhd(OÕؔ14݌ČgЌڍڐВ013ϲ0'̠{%Ox /x5)O9#p{8d$.@R
m~
R	 (C<{k	
"n
oC;3@Ol
a
}L
:u # 5j;	 -{ * "$&( +	-/m01234|44J55556555;5444321p0/-+a*(Y'%`$"|! 	 _[8]/OT}'|&pY _5"8^t;VMA%u
^

xqj:
q<      (  'I
?EPg	1aF+/3BQNK${dN0?g$.z8yJ2_&z2FwUf%
 hovqlt}M OgH=R  C!!!"I"n""m"G"!r!!!   6!!!!!!J!!! !<!Y!!! O 	^{(YHLtU *
l0]m
M
>>
E
	N	rvkhepP		
|

0Cme^> _2



f
E

		:	Cg}tX8. 8 >GdUNkH%!bJ96}R"#7Ji݈8۹;Hٰ؅օֺ^nGӸ*Ҭ.ѥlϼd͝SǛ1awEØ^8ҿ4ӽŻ?OC뷓{iXܶzWܷgBn[NķRһd
C'
\5.
,]N? <u&B|T	wDr|7b\J9 0W!_#y }  1aVI=1%=Y_kt* Mg	[6N:h ;"#$%'())k*+-. 0~12]457$8699 :
:9w988"877x7K776z665i5&544x43c3|21p0K/6.!-R,+*u*q*m**++,,_--.//	0c0k0t00//D.A-?,*)`('%A$ #! y3p>oBH{V




BduK-VKW)I:U
q%/'*ElESbU0	*Kk4EVTR.
N6
M}
	Ah9a  9 O	 sx&[G&_  lIZ	I
]
"X[^Kme=
)V&s%
	:|>k
|
N8"]Y
<KZR
c
j-e
	  ,QMo1`E,[8nJd~lBh?bqyB,)HN[ |\<p9iI0)<a(rڣوmR7ӻVυ|MŧĄÀ}PEνYx
Xd̹F	RѷO'۴#jBc«ԪG!ѤLƣI󢜢Tӡ_ʠ|.BTҡQxG*
oͨAp_\7Է￈!^͜Sٙ&	f^1! V\  k   c  uN'd Ow7ObtMh$?	
P
o

q
	6PSU =x9	'[>"g-H	
=pQ2B !"#1$$&%%&&&'`()*+,-N.x..I.-N-,@,+++++++++^++***+U+++++*)(,('T'#'h''!(())"**+r+++r+L+**);)0(&'%m$" iH>3t jX	6'Vx		
x>
?CGA;IV952+W0v0,"|i<{oW0WUSyMM@r+j E^
Y




	Qm@


'VabcA3GS`sJ
W 7SI?eY5  !|!!!!!!!"D""#k###"$$##>#""<"!!H! + q*d=Q9HHCk 0)u
]
	"	S=R}7h!D\t|eOF>83/,V%#:RRRE9/$
.]P  7 Yj<Gz4P>6n&`>kF} Mߙ8ݢ
܍
ۂd+؄8ևVӉҼlbLε͏ˍ˾bʾYȀǋǔǝǊ6ƀP5LOSšŒ	î} °ZA)^½[H6Tr)WÅA/tɹʥ̑c&b
i	w
;
X	r#+:@Vl   C)   T6Q	l1




	Q	m		=

3
	k	M		
H
~&
S9N S  n^fnaa R$~T
OJ}L!##$%Y%%%%%%%%}$#"X"!!!w"#$%'&3''(,)))*e**x+-,T-{./12)3 445Z6$778s9::::i::e98k8
8(8B88"99-:P:s:99876t5Q4/310N/-',h*x(&$"!? Zug K,O-J{BhR=(-1c
/~
'
u0~

		
W


%PH?0 Ism

<r0s1BR&PR
4
n
		";Tumf/wg0	J	\	o	w						4	M&Zt_aQj* V/{:F"		N
E<7
1^NJG8(\bjscjqux*J
i
Ol.


9T~zMU




o

	e		tD O`Ho |Ys;kv;Lqo4A_};Jy6Rv[dU%\7gNwެaݙ7R&־*aҲ\е`Ξ 6_ǳRŞĒÆI׽PڻerԹ5e׶_x
s%سbYǱAj꯻q& Eϫ^%ɧk
4֥ӥХlIjޥFnzL+	Kd;Skif!`ԸH8)ХCk2&S-l0}Lk16a7=drq *3<d	
0
	!=?B\wq M w|   /nI

,{ 8 24,\4.P !j""O##$$%&(X*\,_./e1<233
4y44L55 6M665:54322$222m22@33333z2M1 0.-C,*)(r'R&"%#"!x ig>fnE4`j+}n`
Rh:
%
?i'!

>^}Z

VQK4EkX
6bbb4\'\Fz'|$A
f

v\


.>N'BNMFb}S(a!Oi%p;

=:8



;i0G;brIJJ6"u<g{l#{l.+X>vk_THIKHFmTl8RB{U/14Wz_%*`xZ$>EsL>1K}
V

h	?>_'i9
  u H  HJ0j4mCXRq,,^NU~nzj:5H06uZޚ)x۷ڜځڕٔؓtT՛ӘOҮVѤψ΅7ͮr7̸t"]u %"
ɱɖɬIyʪ^˻$̍6͛Kҭԋ ۘ/O7z(:"s}yf
Vb6+^\22\ =a{ 
wUs_z0Ib_``&R~&~lZ{	

z1I'8lR8w`	}}S
YfghovO)$t r !!o"9##{$$Z%%%%&F&{&&&<'{''''j'-'&&&&&&&&''.''&&p&&%%?%!%%$$$q$!$##z#m#_#m#z####$$$###C#"@"!V!! a  6
1W}IKAA
~gm`

u
<

Lx;

i
2
		f	hYzjAiC
A9i7qbR'N{r#k=          :)>/QB3M) 6Wy{}cI;-*W~cH		m-	)
&U
|	]>RfC 	}					6
u
(HH#Q`p
~
}		-


 
gb^(Pg	cJe(3%l$w  E& - z&nWGyl|6!7_rxl>ilt# :(2NRW*wk_?Elp.G3zwyzG7@dy.]&X݋ܞ۲8؇צK{i)ӄҋT
И11Ϙ1ͺD˔?fɍaǾXoĔ<à]oTlhLµ.("3ECA8.࿀ ۾IAThlowİ%ŚƕƆxEФҤԤփc4@Lߑ+Xr Sv}	hp{+dm  7}e~gQwemKRX~$A^<};.p  $VP<(Lo	~
OYo
	]']t0nV>|&[5t)\.}`#*x4H\grz}oR4$Fi}k(U#Z'ung'`d2a+]
M+Qew~jr[0ziH(jB




g
C
 
aSELRRQRRNJ0iQF;@Eb J
$
)


{]C(d/


`
?



											
3
G
[
M
?

						j	M	0			wYK;' $
 6m		y

%



!o
m
j
8
i
R




	,	bCyTI>g) 4h}d7c eT1x<mtdL4FY2Lg[P9""/DY[^?"q70+NqjL-
/_{~v_YSq)KS\]`oBjx}tN;DNiI]rx~0<He"&<Rg|	<	^										
B
o





'EpfA!





p
M
+
				n	T	:	!		lI}X6o3zB
\5W1f4bA    z _ D 2   
 
  % 	 t_J5
iUB1 XG5-%%%         
      RSRC             [remap]

importer="wav"
type="AudioStreamWAV"
uid="uid://bwxt05le5tljx"
path="res://.godot/imported/i.wav-65893108867fb99ad47954c4f9302b85.sample"
             RSRC                    AudioStreamWAV                                                              resource_local_to_scene    resource_name    data    format 
   loop_mode    loop_begin 	   loop_end 	   mix_rate    stereo    tags    script           local://AudioStreamWAV_mfv38 8         AudioStreamWAV          W                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              {sjkkyysuvy}||vpjdddkssseWK?ADNY[\VPONV_`bTF3! .<JX\_^\YUME=4-'"	1DSakuvwoh^UH;5.-,C_{xui\D+	"C1 +-/K|tK"#3D
Q   rVeszjZNBCE.? l     t T & 
 1 K e T D        
      - S    	1JE?                &/G^m{l^ZWgxtWC/+'8Hc~^ac159rOB5c%U')*(&.542,&/7DPX`[WRLi{up~
-5>)xeHb{fE`{w/Tjo_J5,$.9Sl}vEe}:% mQMINRTWcp
 7AL2gN6uI8'=Su#
q j   # & b     U 
 uknr7 _        I)190          r H   > n        <yS          g 4  C>ehkI& 9Y|F{id_B$oA*?S"s-n5%nJ ,  !mw)N!0(FdWIFDhzB[+IA9i`FJ7$,4)Z.q(NtOWj}MW OD	M"&}2:d;5@y~{rqoV&t8<@elO'LOR^k7>kN@1s[w80s9w/n!*2t)rM("5G(	LA=     L >(bxSh}b
h
  	 2u-` 8 b   %[ ] R H  c|N w  KI           {@w    L/e    JKJ
qW  4(iO  %2R#[JQ}NT8    g->2=D=17  T T W   9)CLE   94M<9K\    a7w!08%C |  }m BJ#1-Cv  G# .fD %U  . b  s+}  7 Z=F T  % 8I.a  1baO=v &C7"`9L  
gm1 6 } 7h Cf- 8 }upZ m@%	T{X |wr3FVbU +jrv *2W|`D:<9tS2YlY.  WCv wP(c<L[   Bb b? ,w.2 ^b:R ST}F"9 P. v@|*# l?llNPX<Y z   U@ *7D#M  &_~i$i  =#V>&-hkx+f4-X]5 \,s\RQv# pikfa>3g<"W/g  C 
^mW qHjjQh qybhu7m-.1X~^ l<k . 7@T v6 W  DNWk`  tJ{Xk% 5 [$C y4+#\	#GaALWO:#
UE "%oBKNxp	$ !e I&v*0I DoNTYfr8b ^SH e^Ms/ Zj&[K$~^+&!@ # pEnF9~[7PPP Wv";    }x`   &4I [m  h,| Uk
vJeN0xJ, n':M"     Y)t0r 6  4_@!G} >@BD3  C[SK @4: {)]|~+ 
s	\\ lpIHFq: ; u !	LxY\MD  fmtoj'i Id u$ m%iw*l|L& REPsMz+ =P`  <e~iT B 1  /F^WP`qZ 
 T_jHr&Gh?id( ]C(x %f ed@=j+ NtcQj|o] KR2.U
@ j O4 _Y/ &\
 s[[[ `D(Ik"{w] oV8 R8Iy 0	 nC W$
 *YB,N?* , D (]Aj $.i T/  maTd u} :W FJCi,RbM 
 4!9MGG7L}z    ( &T0n{& & * Y5R v  tI @'q^  D  3 ,8D  23 ?JMP eA% wm`RY	8[   o N k+ Tv oxX!f   rweS W*NV		1



<
	k*m2=3#dN=	
r|
	Q		
v
h
Y
	a	sE>7/s			Bw_	F}


5|
R
			
D

	4$.,*$q};/y@	* KE?  H8'oF+8djEX|HHc"qX"2	U
w:

&_


S

f8zsI
m
a8y0r	}>`tV1>
w
X
9

 L" StH

@+
N=e PcYfJ|kW
Hi nIAVqh]RDZD/!,
߶~߼Ru ݉ܭH~5ٟSؓ0J)֊VMҋ?яkGB=ELkъљѧѧѧѧѧјъхcFЩdе]ϤB͗<s̄Rʡ)fǢvNĩS¢8)ByȾѾھξþlG
ͽ{)Ѽy*:ŹhdQ򵾵c=!Qjl9k%伢sh^'|o?ŧƕǠJɥ́ Ћ0iCEhhP F=6/E\ V+\$ @]
	|
Y% j"#%&(*+7.t02=5R7f9:<=><???@$@6@g@@@@"AYAAMBBCHDDE>FFuGGfHHHIIHHNHGGGGGHKHH)IxIIIIH^HzGFEDCBA@?>=</<~;;:T::9#9)807~531/-q+)'%/$" B:2+)? lX	yaIR[
R`
~

	3	KW/  KBd3SF# b  d-kW+	
bsM

kn-?sK/ .!.""##A$~$$$<%%%M&&'''\((>))*r**+<+c++++s+K+**]**))))))))y)8)(:('&@&%$a$#X#")"! P LzU?TL

	bD! 
 *	{rC$1e *v3%ߧ;avpfnأN' 
(/7I[؃ث(N`spmcY`fٞ6ڗۓ#ܳIݎ=%-!?
 =~=gmCe V?S=vMz{tmnoߤ 0aۄڨٻճԢӞҚѺ0V}̠KyǱ'eĕ
<n-`tŲBlzިz1N룉7墎8ۡ~=ƟNמxDEGoڞSޟ4;d&Хz'էqZBLUWX< ֱEVԶX"gQ%FUHOH¡Tŀ-ǰȊcWJS[Α!zT1٥܍eVjd${	
Rw!wJ$SHZ2HwM  !x"L##$"%%6&&'d'x'''~']':'&v&%@%$#5#"!!T 1'HSom%_85@;{/_R-l
3

(	f1 5Vp(8CDo \Kw[o
u)Jk>*|bݜ+ݸBnڛ[v8؝>W|+Co֡3׮) ٮڇymݪEeytqJx!n 9eqe9f)[^5]	
1
CDt "$&s(2*+--.8013345[66"776b6555443M32N21"10%0/i//..1.---`-1-,,q,.,,++,,++++b+B+"++***)*)L)('&%o$)#! ]4iR~o`
^Y^
b	tmvo & e[64nh; S +c5[EbDS		
[
;[|{_yC "$T&')!+,-&/q012A4^5h68788&999:-:3:9:=:7:;:J:I:D::99h9P999D9b99999999
:):G:f::::;O;;;<L<n<<<<<<o<G<;;;:9958U76	655O66 7777765Q5z43210/-,)'%#W"  mf`2wB^o`P679JH=w'@
sQ	[7

S0
L
			w			

UM-]ZEm#U]lRcwq7:M  B \     2 :ZzazD-0vf

n	YDHN`q .g<~$^7R{T-f-{E(?wݶ@۵/٥هi?pضt6( ֽyֵQԑ=ӲӚӆs=ӵ`Ұo+нw2y
Ϣ>͘ZOEP^p͓͂ͥ͸
:j΍βDwϪϬ~X=@B:7
ΐFͣ_m{͕ͮ8bQA>@Π ϠDЋCtҤbIԁԲԹԓqN
tҸҦҊ_3ѬyG!Й=и0V'FHoГ4ԇ]٪j_SyL ^

{3|#5*' !#$s&C(7*!,-/12345w679~:;=?KAB-DaEFGHJJKLLLLLLKfKJ	J9IiHGFE(E
DCA@@C?>===<D<;:;:A:999y9999[988'87V766^6!65[54 4P3H2@1/.E-+*M)'[&$"!3Ky0n|@
~
-
Os0
}s
6X4PB(6[
AhL&vw/ !"#$%&(1)x*+-k./0213(45567B889<::2;;;;;q;;:y:0:999U998?87H76_655\5"544O43Z32A21-10:0//o/?//...I.--F-,z,,+**)(&%Z$#!P ( MwUA?;K	~biZ]^!a|]V	
=q


p5wL.
 {&/vQJ<`< -!!!!!!!!!!!!V!! H &#0 `\{vzWO,g5`
=&KpZY

	  J4F#s?9utt1a5_:P
pL&P}l\=x`Sޢހ_chJ,݋ݜ@۷ۋۂzL۶M2َ^^Ո)WQӬd?нUoZ
W˯Uɥ&zFžf
Ħ@²MN' _]M0Ѻr6ɹFŸeGl͸	":6=Ķf-ud2Ͷ
}2u]1ɸ-عV(ʽ*NlЋ(סܠ$cG-  }vhY	
Q

%@nu{@Xi!T"z#$@%%,&x&''()T*+G+}+6+*\*)5)(('/'&2&%s$L#!A 'hC5'
2<
{
g
S
		J?`v$*h V DD6MdxR30h:?rj4>vf-G1\ 	$
E


>05XBh)1R&j
u:JY !"#J$%%&n'E()){*+++J,{,,,,,,{,l,T,<,++)+*0*).)(((''&&%$N$#"A"! N z[+ak3#3DLTp
L
pYBK
3'J
X
f



	]		$

!e, U=BkWrC "$-&'W()o))*:+,,]--1.{....-,b,D,&,,2--s.y..-h-,,+E+++U,,,,
,$+*([(''(O((('&&&e%$##3"b! t  'CV4


;
		6fq _#9TQM2b?datC X9V`:\}-kr#>TkS:enF,])mljhfH*rWnS^ic\&ߧ^ ތ6~ݲGq{D٘ gקWְZյQtҍ!ѼѰѣC>Кe͘^$̚[˃
ˑ?ɀ?șmU=AE]uȦ0ȷvȢLan|ʐʣʼ4oˉͪ2StMнЁEҚԢ7էփ׾٨XSORY`%}?!^	~U,`+Ms!#0$Q%%%%%%0&&
''((i)q*y+,-.d//E00x1\2A3+455J6`6u6T6366678a9#::5;;;</<)<#<;;C;:::G:9876F5K4P322x10/.-+D*('m&!%#"3!,mL x.Q`T0s f

	Y	C1axh~	

Rp.

,!Y  !z"##$A%%&w'6(()U**^++%,,
---r..d//'0v0001T11'2233W4556-77S88C99:a:::!;5;J;3;;::r::9u998R87q76R654L43210/.!.V-,,H+*t)h(?'&$#"!  F(abi.`*tW_AP
A
'9 %
 
C
f
+=
o



ZV:s s]0IX(qm@Sefgp, u     !,!!!8!]!!L""Q#l##1#""B"I"P""""`"! , nm'sb:7GAi3y
4
2<
 
F	i1E 	uf<`CD$,E|nGx	0~{vqP.e9Ick?k:e3	߯ߎqSNIOTQM<+ޯށF݋Oܰ܋f=ۦXڟ~]/ڨO6أא֥9TVsҗ"ѭ0вBwή@ͨNˌzg[rcq!.ʺf#๦m3ȸpkeR?ⷢc/ضu_I3("'KoĶ=dķ^ɹ
Krʺeϻaz bþ#Ib(âĆiqwȮF̨0ϷYӦQؐ%ܺ_LOuU
>2 aoA?:d@			x

&)


q\e6{W	;loqR2a4
9


H	}%Lr 
 5a-7r:m.w`G.uh'B}A&Q&IoQ j@-$,	8
CDE
=6b@\&dJEp4NE`I\pcW5Jo\;4JW<lGpq	_
o
Q
	h		N*md[K<*-zKb		?

q
X
`
g

WT_j5>G

3
B>A\^b5
  6!!v""#$$8%%&m&&&&&U&&%%%%E&&&'&&&N&:&&&I&m&&&&Y&%%+%$k$$###S##""]""!!  sn.R8z3iO`p]IGE
>
*!
	5s>_3 I GehYwbu!jfYrE-Z= (3+"g7h<Mz<PuIE7hM6Zw>4q_9ߨ1߹ށjܠPګX٘(ٸASdիDXYэLЭcЩ9^3͘F̝̀cnẓ̏#Z͑&DcΒj0]ЋВКг?ѓT%ӈp;հ)֢׉vfNڰ}vݵfmwmb@S9FQE- k7	
1
a`) e!B""G##K$$%3&&'\'''(b(() **1++,|,,A---	.*..
...<.e........
/ /3//..~.C..-:-,+
+=*)($(v'&&5%[$~#"!E!  ?{]^Q!L.{FX(
d/mG!6Kdlj	6XP}>[ 2!!"h#$$i%&&6''P((%)x))*a***6+i+++,U,,,-U------......
...0.C.V.c.p............q.5.--d--,+,++v*)O)((i'&&N%$#Q#"="!#! F2Q%i~P4^'tV


K]"

l
X
D


=]
|cJd~&
.@Rw;F6-NF!z#%+'(2))2**+,.///-,r+))(8(](()("( ' &%$$%J%%&%$#""C!   m,3{.b;Q^"tD
o
C
r
	" 6.(	e ?OFzMJG_3l4$Nx=(J	0CfA!{F ;_
LKD?: }E
H
'
Z~g<C߿n$7(݈'b ܖ+ۯ3ڨّxOֵ}Zgђ$Ѷ7и"όfgxPʓUǹƫ8t ČÁ=U_ᾷuE׽6[YW(ǽziW)ɼ$g?<ƿ[+/0^{×3Ĵ3Ŷ7Ʋ,W)R͎Vy?ٸ۟݇ߘ	ks5Tic Ny, z{r		x

jOA


!


:

N

d;uu+LDw4KI
|=	}6D l}@HO{P%NG?_g7P|@	06D%[;i Y6h 02gt	

p4I'nLmS9>CYp2]A>5Oz9f{a`_x\?OYG;|o7	:


p
.
]`


a
R
D
6
(


		n	4		|Hy~<+IxjR	
$4<E(CQ
v<kuPEx F!""#$&0''((()(v(('b'/'5';'_'''|''&%;%$a$c$e$$$$$$U$#1#""!i!^!S!h!}!`!C!  T	{Qd-?n}%j

	+	\
]%7FU evg.W|l\gs2#unDe"BWTT{=(:`
D(-O8W!e=Rg.kK~jU 1J~y.8f5ALz	lC2/Q;Ng)H(F?y3ݒ)Q۞Yڎ7nؔY)׿ׅS <_v׍|kB֮֘ցE
ֻl8ԺԝzXeqԯ)fՆէ Xֲ
vIسuGo3>m/
bX-v(
B\v~M\!w  !!c""##V$$O%%y&&v'''{'C' '&y''
)*+ ,,-j--.s..)/F/c/`/^/D/)/.m.-4-,++C+.++*]*o)(J'&$#S"!`X^
qJ

L
:
)
+
,
,
,


						v	C	#%WX~PU9_^"EV ^]p	
"%(?P !s"c#C$#%%w&&'
''&&&&&&&&&'N''''(("))\*++:,,(---.".<.>.A.A.@.f......z.U.N.F.`.z....e.--,s,+f+*A*)('& &%$"!  &7Xy^CAf"


^
6

<r
o
	U	:?4;`9)LgXs2ve	
'h2N0Ek%s.39=B@t0frY@Xm*=O&F

U
	zhI+ IMeiKp#I	+cAIjb=.w3\m\{iV{
#;.!AWCEF,t9anV?+pjd_YSM9%_X߈{o{߈kOޡl5ݮ_ݮw@*۾ۄ	ێژmBmٙSq1ݐiB0{Lfz[5F<lG%	q.&YoMH#oGR.7  m:TJ"^)
Ciz@  W 
 Q/lG,d?0>j3rIm0rA"j.F>#P2^D  y1oK!8Ni(j!			F


`a 
+
V
e
t




N
Cz
7Qjz{D
CC 
^
B5

5
		,	.-_+k=
KRxb;vfUB/     w d i m    
4ZsM53Wz)pHykpu
'<Rv	|Y6xJw6o.x:]}9  w <  g7d=xhWB,	|Y;Y.	&CXm!Fm6r#a!j D    .]>]}"1?MZgu
,<L`t         
      RSRC             [remap]

importer="wav"
type="AudioStreamWAV"
uid="uid://bl26y2yggsuhh"
path="res://.godot/imported/j.wav-73798dddb53ab8e6c61a14b4fb35041a.sample"
             RSRC                    AudioStreamWAV                                                              resource_local_to_scene    resource_name    data    format 
   loop_mode    loop_begin 	   loop_end 	   mix_rate    stereo    tags    script           local://AudioStreamWAV_nj626 8         AudioStreamWAV          k                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       $ * / 5 : < ? ? ? = : ; ; A F J O N M J F J N V ^ a d c b g l q v t r t u ~                                            123          c Y N U [ j y                                 i D    ! 6 J W c k t y ~ q d a ^ l y |  r e 9 
 yg oaTQO@1:CViQ92MLJ0}shik_RW\g8
rSLFGI;, 5=F=4+#+3?K@4$,4& .<)~l^PZc]W.8CM,
BtX"{rI  0?=:3,17Ur~T\+E#|ylP3y2R{na^[^aUIA:1(,1Jdo{qf5xhXWVL ;h-E\AO^[X*O\VMDYohaG.7@cN$1;Fgxi|111EY9vJ<RiP8+!zvr[E~S5Fk>*D];v67cqS\f@\wc&H_"&hKR3Skz3tl's>LO\9Rk~a0^~iT\e$3@p"X7\Ec\UD3#8N\/%{zyaH6$Yv^VNWGC)3  POML@50+'###!= N 
  :hP   :dU^;v&^`334r f 0 y~"  Fe@ 	[* -?93x7 Q \J7Xx<36k
7FUMEo v  Ji,
Q5   ; +PM pBl I 0  
  ) N o  } j  Of~ f      U   kO2kj#<*jyEa|  X*DRV;(+.8B [ ` e # {. B W > $   jMU^tyh= uW:6234QnSK^q0y~#:RMIVc</")=Sj\O12Q<9670[<j=jk : e ) D)BuEz%mE*543"-8QiA[w3   ;yl6     ACD  D ejo\K:Yw A    8~

"8^{OV;!    J  |ri`WNFFF6%D`|zrliGUc`*_&/;G@9BKc{~bDuXVTD4h+2I{'.^hJA7?FCALXlu_hr%Cal9
8Rg|s?"9?DEFDC5&{gSVZv5Ng{ * I Z j n q n k p t t t h [ :  jQ7BMq      !   eD<5?IWdddv
   	 1 x   (3<EXkpV>'"&/Kfxuhb]VQJCYn+T'ib:];Y2!.BkG,`~jWD2oaRH?,(T2Ga{ lYC-$'2Kdz)E[r{|q_NHBHNE<!.KMO9#	&5E;2
5I]bhd_I3jS<N`pjS0
	R)	8^xxcN$znbbb]XNENXiy}rdUGHHFD1         j 0 lJ >{ca_rJ"##P|   / C ] v   x g S ? ,    ! , F ` o ~   ~ x d P 3  zD-`  ' : b        /x69<f8
 o + yT.2K{;   48=+   u C   . J Y g j m _ Q 3  X*!Aap|s\F-
=\n    C    3NhqzsdUSRJC5'$"3DJQB3     ~ e O 8 *     < k                             g 4 x^D/!),0%
7Vu E T d L 4  
 8 d            P  T<#  =bwa\Xdo       
  |pdM6	qU9@F]sM - A /  
  5 V Z ] R F )  q2	2PPQQQ[ekqU9
(nuTQMt  
  6 U ^ g R <     6 T q     $WwyaIFBBB+     /ZsuXE1(
1Hc}sc=  U 	 j=Gt }H=u    lSW\z:~^O@7.0<G?8BLenW@?>LZcmz'j [ ~    v j            } t j      m *  5 L X e          { b I  ynjgL134Pk{rZ&zb<
)Ej"DedcH-
):KORH=xB7]3sH1ECloF$I4bye9n5?t$<==^07LbQA>;^zO$;P## d   e  :L}O5>GWf' R              630  r Z B a     ~ @   $ S         )?3'   
CipQ     ]`C%:OtkvypfXK;,@U& 1IuxofARc9x	
.>MF>/LD<--,4u{<N1)"
Iq[Nx
FnK)"VSao643Ttld7k0  t [   +{^@  ~ f   sA         | d m v       s ] b g Z M 0   F w   N  `YR d f h *  O W ` d h                      e A  cH-zgG'*Hf!%1Qrw|O"q2+6A"	'8H1
5LNO>,*(Geb?9Wp=tAs__^SHNFg8YK;*9H.MlXE	aD(UOIunM,(#=Xu#JqN Y o  p [ M ? O `   "hkoJ& 
CgB D f//Pqf\J(!<ryN h  g N ,      > F M " fL1n  U)6p   ' a   K]ov~
)%?Yy~ZTN}%?YWV@*"&3H\cjJ*&\7k
[3Pmv ;dravtbPXaXO%[7(|ZA('&3ABC/
#:TnaTQ]h,)'B3'zgUG8dIB;*`A$t;"
+Lzi8?ZusqM(c'}J|a/  m :  
    {Z:CLhynT;8469!I a?5+JjQ9de
n&R$r%X4ukQ6Im.){aGKP>,~C>9QiiiXGJLp+RRSTU9zsxYdk
Izd~dT{b8qa-ITDfjeRf^EdHpM=)Dh(_lB 1J    q_gdR2	 

$

{%


(C*Y}0kzCgNwf[	|+:w/c&!}|KnL6%
P Cig 7gB1+!"""k"!!  >!!!!j!  5 7 : v  | T gk#'!%pbDaB;wiL@>]K<l'BrSnE
@
		I	G	B	%		 _~?H>}9_  - gwU_^D1&O-EPT YMy@	
?}~.`b~ޕ(ܺr*ܪ4۝ښ4ؒY$׭kעAռ
|-Ԋҍ6&ѷo~όλ̄˞$˪&Hkǫ`eÑ$ñB#4:l콵r.:w8򸭸\շG|򴘴?ֳpPn"
p@Ӫ6ҩ4ѧ򧺧tO4CѧeԨAŪ+gȍ\2w׾ڑaqGzG XetW?D
%B

[
 JwP9aw <Mv#ho  !  Q /aY2t

Q	H>4g2?   m8>mLPU/	L

By
>YN|ft
Hr0`z-! !"#$e%&&'()+,)-----A--2-Y--.c/*000000N0)0
0!02040/0//.Y.-	-g,++v*)m)N)-)y))@*****K*$*)/*s*++,m,f,j,+,+++x+r+|++V+&+**q)(D(''a&%$$.#c"!  CgJ]h"x+1996-& (a=,Ot% "C$$%%$y$r$%:')*+,+J+h*))N*:+&,9,S,+D+**0++_,--%-,+R+*+0++,-w-,	,*))L))*o***B*Y)p('&i&&F&d&&&v&!&.%<$2#-"! !!	!  G ab> 2rLz&T'	


!X('

p	K	*	g				=	3X&]df%i["F  \   OC*0.jk&H| ]o%
0Pdw3-g_3JCC#ތ|ڠW=)a
4z,	ԉ:tҭ/ѯYy1uxFʫBȦǪEŭehm×OK^ֿOþ6콢u>켚.Ļ>/DȸXԷg3ﶥ\D)Ƴ&ytp>zִL)о7ù`Ҏ׻hP Z	xe
udmhwI~	/P"Lw+8(N_p4a<OW{E<;-


	nK/	f	h				s

t(

AT`w&`!#~tKY`kvP')+BGlJ5J^{B_(}hdJ/3`D6+0kN3R\1eD4/+)-<JyFlgVTVZ`p0vU
\_Iwc]Y j    !     c " bbI`q4)Myq3mLPnj.<i8h
}
		U23%
'@ hH0%%<Yv"CyCB8h
6bW;u	

mK 3-uL6Zag~S)#'wg
3


4
b



{	[:Rk$0C  P2Hy@	^MlZr}h5=3!a$%6=C?]jb'Oi
4j;s}x@
>})NCG7-fAjQ&~4,wW߇v$ݞݜ9ۣڻfTJ7֨5ԬN3ӽӣӇf>ҝҊv}y{zqlL+ћ?0БQD͝/gʺɘȅe6ŕ"ĮY]ƿf߾Z:¼b/Իy#ֺb/㹗S ĸUȷ~#̶L̵>Ĵ|5$!׳߲Ȳ3_൩tH=GɬOAܛYj{;"H	
D
%c)f=CyIZqr7mL~>oUSu66}D

Z YSI'j >SF^\ //ivS#pUgw*.Dg	

B{*

PBoY@5 c    "!y!!Q""""""Z"""!!Z! t 4Y,q E'i;~7hZQ:J
V
!m
	9Qj 4$F	'F)Eu[BWfIRcJy)&  4#G@#7Z
g9J[D'z5E]; I]naG5b1xR8(C^ \RM0^y3ZC$U    xL'uL 
	0G^jX, SKf68qZH_H=xlUVXO1h<o@`4q4~2\?6$6t7|@:g݄i&ێ8ٔ0o֮IԭӗҠ!uй/ΤͫEQ˘,|_śBż>ĐG¶t2#Rt˾of8
Ͻѽӽ˽ȽsbQ;! ߼̼¼ּ̼8G)Ki}naŚɵKЈ,`wގ8~v"
?:tu;YI
LSN' O x  )!!j"##,$$$$$$"%l%%`&&)'E'`'\'W'b'm'''(8(5(1(''&Q&p%$# #z"!!V MB(#lacg.?[m~X~KWD0AP '!!!,","+"*"*"E"]""""#3#U####F$$B%%i&&a''(~((y)**$++4,,>--x.8//01e2?3	44z5)66k788.9998:F:S:>:#::::':::99|9598{887K76b65j54U43;32121I10020///P//.~.6.--O-,,',+(+*H*)a)(G(''l&%/%$#Y#""A!~  k~V
\&4y Pk:\k  !"Y"""j">"""""*"!!K!  o    !!/!   iI>     s  ) _  j E $TvW6	c?km+dR{k(A
?pfd~v^

9
					
=
O
Y

	5	"Ye=O5|?}#m S ZJ6t>{^}%g
IY+#`uTJo
/I?eBK
<0^K߂\jۊۆL٢Uײ֍uMӪ	jCOpΉ͗̳M˳m'ɀɷSǰoEƴ`
ƣ8Ĩđ{m]Qq>@㿄kRC4ﾪ<̽799IY7ȼ{'ѻ޻2Nܺby>{tmؽ çwŏƧyKˍ8CMؔܶߐKB961=I)a? V=$Ot		^

k5Ng29:?ThQ

T)ESeeeye95


w
	1 4kE?ov|E
F/\/?IH:E=0$,8j 1 X    p\m}kt 5T		j

>
Aq3#N_"8@=GUmND_3/a(T,X/W{R
yX4VOyF0z`'8`u  <!!9""""#6#=#H#T#o#}###n#_#$#""["H"4",""!!C! t  h24Wy~}bHTCS'\#)AYm=v
)8HCh
/
(C

[
"
		Z	s	ab2{( y  /;\%@nCT`7m-T#e*vD_.),o>[#xgU3|mU?}[:mz+^2(DyR$k޲Nܘ=۹ۙy^Cڟf-ٳًcE)،Q׵ׇfF֟VըՐ['Ԋ[,'
ӣ}WMDkӑӹӻөQtԗԣԨԗԅrVakԥ-ԋԊԋ=լ4Oֶ{A~ո7ֵ(י[3٘ګۼM߻#bdfD3DVh {	1RSXh<cq!C& u     !>!}!!"v""5#U#u#h#[#{###5$s$$$$$$$$$$$$$$K$#U#"""! O .foy}JlB8a+i@vWQ
\(lAM4q^	+'$B` h1-{;K %!!3""#n##d$$%J&&'((
)x))l**q++Z,,-:-r-----.=.K.T.A....----[---,,,I,,+h++**L**))1)((<(''p'K'2'%''&&&&y&M&*&&%%%%N%%$r$$$##s#;##"c"!!4!  M 
 m	tFwE	_;/ID$[fw/?pm6&xN$Xu`rgKc>yx9$"Fe=
?
l


`
)
	L	XTtyk0,tya O sh pY!o{[6GE{D
epF-o$sL$nQpAb Lv4\J
Hs2sN\/m5t.;fހޡ4Ohڄڧ6`שWֵւDֹk"Ԭ}O ӠW҃AҭZМMϛl<ΏΪW̸̤c#g$ʧʧʦʦʤxLɠa#ȮwN$5FoȖșțc^ZȁȩȸȞȘȍȓșȜțzY&
0*%ǺǖsǖǶ@Sf6cȮɇL̗ͭ>ADDԅZٴܣ4l f[Ilm/+W* }  k,E[SK~3K7M(.	}		(
I
p
Y
B

				Y	
hRj |  ?j|$
?|*XP# c    0pL>d:\y(^0I
]I	d		
\

@VQ

rbcS6Pfuz||qfL>)^4	i80WZ]VEED`}	I	ZL5NE:*>\iu-k7c$(&$!'4QpALMQVv"&
i"2TI[;|2iP+zeI-oN)fCw4

5
vu,

r
8
			G	
	Wm9G t9Lw&25  M  f>XESDG[	]g1hF~MsT6jG;qB)^O*:sRSHW(X+~~jU&v]K9^HtBUߋyfe`B)ޡ{i]XTIC0	$Ejސޮ!Hi߉ߛ߭ߺ(:K4	#b  so"L#-nH	pI!S
SNGD@~Phv[	
|
	R

{aR:
}lNDL<-HduCBqDmkd=y9l=-	q8z~kbXcs@
!9i
!4F`z)b&S1 p   
!'!C!T!g!!!!
"H""""""##=#_####
$ $8$D$P$e$z$$$$%"%9%H%S%^%i%x%%%%%%%%%%&F&&c'/(()*))k))!)=))o**B+**)(';'g''(y(((3('!'&'&%%%%&%%%/%$C$##y#=#"""j"""""#4##"_"!N!  V   !R!"! < 0PllQfxCYMhTBCDDC1_9;d>mK)si5[RH^


M
Y
c
v
		#h'7{VvD5 b u*v]%an{@l0m.si8h@c#J9RRmTAt7:NI|_<|EqY7߱ߒy^4
ޤރcUK?3ݴ݃^9+ܽܖoO/ۿۡۃa?'ڻڼھڵڸںڱڅS ٠r?0"'*جm/תא^(ָ֋a[Uքֲ
ּ֮֠֓&kא׶שמיד2yؗص؛؁~~3ڝڻ9ۉ w=݄:uްP߹#O,],819O4Y  v_2mnn1'C*Q)n0Ei  m;JZ=n5c&Y1 "a)'	H	h				
y

/0l
/
W
~


T
"&3;HVp':PXAN\l}']"AY
0)& "8Z}$@ZG4)Ijvm\I259EO7|lQ;xZ<=:)}@p0Oe>iWC2 vB








V
(
RcG
t
$
				{	n	T	9	{:|m`N3p=
dR@2%n_I3"NJ+     @  q4sa9h0}Y/b(zFybFn"`A#}@}_TF4"yO)kL6Th]K9wkP5xj\^e|;Rie\A&%"Fj@GNIDC@Xp
0Xs+Kgr}D`|EHx ;w?t&dGwOAla8{Q C   -z4l*rZ7p5b1uS
	B	y			&
s

	X
@r
I


I(T:kM
+Do 5CQXe0<D>81(/7CMSXUTQMHIHHKR[dow}rhpz
	
.ABB4& &5A=9"{Y="|V1pW;_7lR8~V0gC



[
0
	
x]>pN5




a
>

						o	Z	E	)		~eL0qO(gK5#h<uY;a3	hP9 mYB*     d D $  vbN/fL1`;a@kR9#dE)
iL0x^C+W-v]C)
rfWE4 
zmb[XTME=4*}tpk^P9!	xuswyz{tl_SOKKLKMKJEBBCDDCA9.% 	)6CQan{
&/35>GUcmwwzsljjs|td[RX^           
      RSRC [remap]

importer="wav"
type="AudioStreamWAV"
uid="uid://djvrn3pxwy0yb"
path="res://.godot/imported/k.wav-c62e0839fc86185fb6c6db19e0662266.sample"
             RSRC                    AudioStreamWAV                                                              resource_local_to_scene    resource_name    data    format 
   loop_mode    loop_begin 	   loop_end 	   mix_rate    stereo    tags    script           local://AudioStreamWAV_w6xrv 8         AudioStreamWAV          ^                                              	 
 
        # & * . 0 2 2 2 2 2 3 4 7 9 = @ E J P W \ b d f g h k n p s r p m j i i o t {                                                           o f ^ e l s { z x r k d ] ^ _ d h h h \ Q > *  
      
 ~vnjghhec^YI9% 
YB+C\{w@
 `VLe~~MiParw[@&
s|]7@IfmPD7J]m}n_PBRbipH!"WoC"K\zhP31/oui#.
3ZOD>Yu:.V~sc?gw.(WD     X  
 	 D ~    #+28Ne	+MoljihUSQ6Dk!.:73/,HeRF;B#%S-_{
Csxj	'	6			@	X	o	`	Q	!		7	W	A	+					
	vfE$U1wX< tHY,N{||c?v; z N # !     {]?,|T* l]N8"tVC1uEd1s`G.	u[RI@7V)!"jA&uR.o=S$	cM61-5>:6$~xsW4]D+;K^pbS-U-uh[J9GVp%2APUZ[]m~y 7Np.!3h
J[HO<t%\L #\S GnLz^?	~		4

j1
,g#UL],?z 4!R_@  L!!"##$k$$b%&&C''C(((H))***\++$,,,c--.V...6// 0M00001F1{1112242]222 3(3P3J3E323 323C3^3y3u3q3[3D323!3332222222b2"211p1N1,100w0"0/m/*/..~.8.--7-,}, ,+Z+***)])(((''&&%9%$P$#O#"B"!3! " 
ecqaC@JA/2IWS
E
Ne

*
	Q	_\lC7dj o  T55df}6s4K^\!~=zDVn/~NYECk!L9[<A;Ua@WMntbވMݨk'ܝWۇHڧia ٣F״ב]*ֻ֌]+ճnԀ1ӑ8Ҏ>ѵыa7ТsC	~,y1͸͇B̩S˲˚˧˳˹˾˷˱X̒,͓a2Ϝ4кѩ֥T>\ۃ:݀00nZ{W5>~.	_c2@ Ui	
E
 n<Oo!oM p"X#>$$%u%%,&&&&&&O&&%%`&&}',((}))^*p**O**))=)(B(''i&&%%%&Y&&&'/'9'C''&s&%Q%$#/#o"! M kU`kll<
-H28>QeZS7>}

	)Fe? D }b=]e]2f^.4wdT Bj)|F];ߙߙߚM`
(CJRILG1c-#V+qoB^i}IV,nePT8w. m  f     OgN	

jd\T+{|zv^G0%sqYdx:@bHoFT'yW-nBm,P=1$HyUYGrK%2cDz

s
)
	f	Jv?		q


5
	]	w
\A&Ec
9w7 x 7  fI,yw )9k8~w*
	X
Ap;0

,6s
|ym`K"#e4~"lifSA#rhJ+jkF  !D!}!p!b!:!!   j   >!!=""""""""g";"! 0 oKo5L	_&Nj]1v+]^+Jr

*
y		6ju BP   |A3mJ2 hge@j[uIJ`)3L|;7VKS$Xij߇4ީr;݋Otܭ;gڬSؖ2ׂ5	ֲևGֲ]ծUөVҒ.ф>вГt?
σ,wνȁ5˓LʩʊjCɨ2ɻxRŉBĚ:FbFkhKC;Š=u;i`ͤ/Ιϴ$ӉbT8ސ)*+s%c!=]+RPNl=/i	

hL#i !!N"![!     [!%"".$m%&4(u)*+,Z----,w,+ +x*)a)()))*+C-./0411122u21210/.-,++z++,,--c.@/001)22210/..<-s,+#+i*)()(((a))8**4*)1)}('&X%&$"e!k'-w 9j\N"%Sec0u2a

3
5
r	|;@Djg<Z{7oU</!Aaw,cG*		
Iw

8kwq7"-=/]AAe8[LMD !!"f#$$>%%%+&n&&&?'M'\'p''''''''''''''''}')'&&&&&&&&&'.'M'}'''(''Z'&I&%(%$2$# #"!! n,nHz?+9q `tTEA\
c

Y	Yf[v W+;`A#k'e,aSB6);}#sY <vCBOt<}:
!P7F32~t ߈ޒ݅^JًK0؋O׾אF֕.֓dY҄&Ү6џ	Їω
Ο1̎?˨_*ʮh!ɒJ)ȮLxǜ2ŸņSĝ4z)¥[/k">$˾plfվDoªVYWVE6΀m՘׋ـo5rSD
Dvwd

Rkiij$/;b !"#$%'())*<+q+++++S,5-./=12^4\5X66k778/99):y:c:K:6: :h::d;<<t==O>>>!?B?>> >M=d<y;L:97U642'1M/-P,@+.*^)(''A&|%$$!#)" uEP2!*2pE;*






.)K7&DN%Ew^E;sb{g9s/~>   g!!"
##$$8%%&'=)*+A-D.G/V0e12445*7s89:;<>Y?@ARCDD6EEpFFJGGH^HHHHhH HGDGFFFFFFFFFvFEvEDDXCBA@?>y=2<:X97}6o5b4332(21002/1.0-,++2+*+*)(\('Z'&&<&&%%%%$#"	!9BV*2:.Y<a

Q
	I	A8E2F[[ZST;"1?TFKP		
z




C
		d		byz
o=;:Ma{l$)\aT  < H%c~oagX+-}'kUXߢ݆u:K[׷ՍDb 
NϏO͠4w5ɨȇ@ƌEÈ7&hMPȺ<׹
<?BqyHŰC񯟯]KѭWpīQN詗F¨b!nϥKfצ6RHӧOʦ;Sh˧BԦƦB̧bpզ7YѦG6nͦ+󦻦:ayk۟˟KrJͩgA߻:rOʄι(֖XG
^RF0l[D-3vO R"#$$$y#b"!     hYw:8LVTF<<AA*b'R
|^	? `QAp&Pv"$'G[!0?}of!:W+p"L|7.m	
{)

'DA;up .!!"#$\%/&'(()*+,D./ 1K2346'7H8<9/:f;<	>v?@A~BbC3DEErFGGGGGGFMFhEDCBA@2@??o>=S=<W<
<;;m;::9]9?8!754{20P/-I,*)Q(N'L&%%$$#T#"Q"!!Z!!  _ : V s   F!!!g""`##C$$%K%%j%R% %$$$%!%>%\%%%%%%&&:''>(h((9('('r&%g%%$$I$#X##""1##$%&'^()))[**
+V+++++++~+%+****}*^*?*#**)))))a)/)(((e'&h&%%%e$#(#"!!b *7?sA

fA
 
a	Q hc^XSl%jg2<9&xlNHr7(jE$Q~}]>}R"t1wT0(3.*	uLߞf6ގW!ݴH=ܞEْrשh&շ՞R]Գ+w3ФYq͈̚˫}yrojuȬ\fƸƩ%R~é/cDܽD
f۽Rɼýjľܾj	R۾A,$ƾFîŀ)06άвѴ҄Pל\EY]Ye;)p]RD.h xi a	GH{N!'#$<&')+q-.0`000813484<@C$F[H&HGbGFCGGsH4IH(HFCrA ?u=;^;:":p97k6?42/-*(&R%:$##!w mcB#_h

b8

C
<52.14DCo'I6	n7~#	k/er	
?
l1KZ !#%'6*,n/;2	57:"=?`A.CcDEWFGGTHHIII	ILH]GnFErEEEFTGGG9GFE9EDFD1DD(D4DC	CB@C@?4?>>>v>?>m=<u;O:p98%87777x7766f54^4q4444>4321v03/F.Y-Q,I+)(%#!wu^Ho"<
I	#]2DWakr	


t|'&	  !,"""Z"%"!b""$4%&'())),*m*-++,a-------,,W,,,<-------S-+--,H,+/+*)`)((Y('
''&D%#$#!U v(M6

	Ed0x @}|{T.LtPZa]0mQ,_it>URb`^|'z"d0Fs'ZRߜ	wUܓڨـO.?yӴΘfWI[mbXŷu3-(_8^3);y0~G_vM$2@,Χpa (6ңmkѠCYo`Q~n-háf+xšx	VPKlrx;Pu`r1z\񮇮Nȱ>ѵ^̹F|˓Q&aZn eo` Z T !!#%{&]'
&$">	%T

w mZFg5}nCpZDOZ@%3 wn^~8=wFGGng:d
I3#Nat	t 4  !	"k"["K"!!_!0!L!h!!!"""!.!      j ( ]Fo=/<TcafF(	bFg
[
9_%#"uN#h.o	`)Z(7-|vX0	 ?)	u
Q
ddd: "N$C%8&&&@''}(l)s*z++,,,,,-.y013,4P4s4332211111X10//p/002345!6g6<66544W4373'21/*.,%+*)***'*%*h)(R'%$##_"!0!2 5q_*,YlT.	9{
j~
H
		
	u	

<xk,

R	^jM-$	a[n })&    .h9    3 f/
'CecDw.",Oq]Hqh*0o@Nf3%k>3vܠ5ڷڟڇvfsڀڀڀ+>٥R0j,Զ~KӰӝӂf8
҅HѯJyҧҔ^<IU҅ҴҤbҸїuѱdAӧ3Rq}Ԉ?f2Ҍ(Ё=ϻSqѺ%7҃$xj[ңE2zғҫҴһYԯԕyM|^;ۧ
e߸])Qm#|n]aT\lv,Lk) ic`e@6Ph5 ]0j	2`"$%&'()^,.157:;<;;;<<='>p>=;970644~3<3210^/-W,*)h('%v$#5"Q!e xhYblQ50$Z_3PkBL)*,
0
[ + Q6      G;	
B
60 I"#E%&(*,w.k0_2046y78I:;=f>?@KAAAAAJA@@@@@@@@@@@@@@@@c@@??>?>^>=x===<H===0>>=s==<R<<;\;:c:9+9|877z65C54%43321H1k0/}.l-,*P)'E&$P#!C .kZJFCVjB6b
 q
	s	/			I		$

`=

|!v1k ~  !!"#${$B$$### ##$%&'`'&$&%$Q%%d&"'f'''h&\%P$#@#p###&$$
$#|#7#"""v"P""!t!! ]y.td+<Ywk/;G\Hn

d
					 	f	6;:*EpRObYQ   lt6` MAg;w_-{P%U7
=AKK7K=a~7d8q}wzl5ܐOڵlH/oh1Ӑ/gПϸ9w4ɇ0G_ētPʽ-
ϻu;.Iewnd[@%ܺԺf׻Hȼ]Bl㿰T#X
m>$$qXftroDԺkbjWD䶅̸1:º:~:_o$V2)	C
4
&
Db+~5"v#$$a$b$d$%&'f('k'%$" #3:BeT&L
7

	x[	



s
N
	5H s  sy^  F MPf2DV3Cv/c)yF@;>Zu
_ #f
$ Cfp{zz: % ]n(	wX8/%hk&9?FGi#48qM9%a	x<}
&
$	y> +x:jEc?wc$MJGp` x 
0R%  Qd7wSJCP		L




_

h

.]\Z /p
S0
#9;=f ~4_+9-o_MLA

v
K
 



3
Y


!}l\K;Pd
?TesdU#8<Dp:Odcb"

M
s f 

x	`UijGc5_0 <n* T [?.TU8t _NV4T?]q0Jfr+m9{6}ߚ޸'1;JYքկ!ԔӨ8Pdo_N\ˇ#kuɩa)!
`Ȩ:ɀIʖi^'B\qͅ͹2wλ ?~ϭ 9kв&SD6ЀЦp:NbϊϲϢϒUΈ΢μ5ϯЄЅЅS }%Q%޴p$,r^K
%WnU "#$Q%&'P*,0G3589;^;;7<<;>?@AwA/A?>B=;:99K98b875#42=1/.-,8,a+*d)?(7'/&%$$p$$$*%%e%I%$/$#u#H##"! 0c
8c+C	z
0
hmq
q	qPWz
8Btr	
?

;vI^!"$e%&(u)*+-C.@/>0112<333333_333322m2+21111g1J110%0/.T.-t--,S,++U++**p*-*))?)(z(('8'&X&%%/%$$c$$#[#""!s! # D4/+
kM\jCX
n
3
	_		clG`L7, 8Z2hC=	7
#
{SLFNWpzI !Z""##K$$$a%%M&&[''*(q(k(e(R(>(i(((((('Q'o&%%$$$$$$o$
$#Q#"##r##>$$$$[$#i#"M"!G!  Q6!1Ac,R]g4|knq
 
tX
	HB:)-@N\l{Zq=GN#,ZJfeC!>c@a  q
l/ i,X.=qcp;+Ja8^tvQSx[QHA:0%dZ= OOW} i߹\ݢBzܸ_
ۻ_ځE،hbӏ'ӶEё[%+025Я6о_ ,YMBj̈́}vͷ%S/ιf1&IVbI/̳̑v[.˾˶ˮr6˚Iɔ_*ȌGɬ&;şƃQǿ:Ź8`Ĉ@KU`k@Vm%˜ZYӔՕז2w*_px Fy<	CK
aw'/.-ua 8!!}"&##
$$$a#"v!: nK(MrJ00

c	y{gc~3r^ a9Sv	zLURze~hGA;Zz5%YM]nmN	
:`
.cfJ.r  n>H
R{4yu`->(
{x%v,%O

X
		wb
h#$\ =W)>Sw
ePMRvm<
`(M
BuaMc3  r@il
AVlF	*	M	:	(	o3e^%#bV>f&`7Z0'U
		 	DM8$
lD		

EHv
A


Q&i%CJR7]
|4)Ns
|
1
{
	q	`x5|%`g + 3YN/N{Ic_hkNMO2;SJoY:x./o
5W8 6{)rܹ `7٬#ؚטքբV
Ӱv<ҳhѰѝыјѥѵ)"!':Mlҋҗң҄eP;L^ұf!yԼ Pա֔jח.bؼI|l[ل٬=uQ܇Z.,)ܞݕyhX@)Hfg 
R<9fTi0[B!x .2
I
gP)*W!"#${%&'')+,.~/r000{0]000010h0/.-,+*`*)M)(D('3'&%%J$y#"! 6 y9lTJ?a\|b~paTG>4ID%






^CTdM5EV=,sEdF
7  j!!"##I$$%0&&H''(h(((((((](('F'&}&!&%%M%
%$$V$$#,#"&"!c!! > q
6c=b;\>h@ f<v	*Y~,gA&xdqu j
k_sx%oZ v  !!!:!G!U!!!q"##$6$Q$$#L#""d">""!!!"t""F### $###"O"!i! Xc+:I!p:"Eh3

x
		H	C	>	B	E	*		~`i,qQ~J)$!F cF:.]  ; ^C+~"R^]ms>uSZonz
p.cn<
NFjD.iZKc{['xRuI\gyYEX݌ݧ4Yژ?فt%vCվy4ӣm2Ҳҵҷ\ӛ,SmԇpZz10/yԨML"5qҬҸҊ~ѻюaҳy>xѱoόϩ.гє%К,ϺGбЉnS00jФзТ{ϩϏиUҲ?Ӏ3qݗJGNT^10\ G7
Qkh
e9%QGa;.CP!"P6
o
		=	/	"		 	.f2r,E 
nikun2@ ? -mM,xA	/O  6`99		\

-
wK|XJ<BFRapL'U>*}+M
d'P'R
!
hW
b

	{	H		`!NI?R7d ( 4AX j,
5NV_[WZ^SHB<&:e%^ ++RlR<c8U		
{?
,>+
ep 1BGK
Z

	b	49PhXIf  do{7j.W (7GDB?=3)+I3K`2a1sU8    
-aI
t' \  Muig-D;=c8z&)B9vTd-=p`7P~rf_Z9]~`B&
X _%ߵߠߋpT=%޵ޔt7ݼ}R&ܩܑܐ܏ܜܪܵܨܐtXG5/(
Aiܢ'Jmݺt:ߓߵ<IV]dcb\Wdq0xvJ2nfc<un@/Rw( C	
a
BaA"	*v6 \!!f""##$$%=%u%S%0%$$$%T%%%%C%$B$#j#1#3#5#<#D#""!q!B!!2!Q!!!!!f!
!       ` 9  teG),023)4K \ h s p m }    !7!!!!    /!~!!k"""""""#t##p$$$$$$
%g%%1&&&
'&'C'H'M'p'''''((+(,(-(P(t(((((((((((((((y(i(Q(8(('d'&&h&(&%%I%$Y$#L##"""m"7"!\! | X 5 5 6 1 +   9 o |  i I @ 7 S p   
!+!+!+!4!=!Q!f!!!!"0"]""""""~"""(##V$%2%c%C%#%%%%&&M'W'a'&7&%$$$$$$%$/$p#"L"!!!!!@! > 2S?(UbuO>,B|L	j">{ XC/-+}1^"

>
iD}
S
		C	* 2xb pV?\   L  ^fq"Fj~@aU6)h5>j+Z0NZe.k,W *JgpUw
G8w߲]ݡzT%ܗxYPFLR[cdeb_ZT;"?yܴ&ܿܩܱܹ8cYN
k{Y7GXuےۡ۰۷۽/NnquR/۰۔۷6ܑܭC۞dے:*vR.iۤdܙܘcە]$'+T}ۆۏUڅmUnڈڟڷںڽڱڥڨګ"J]oۏ۩3ܥnނ%[?Xh?Ns-ZrF>BGq@[P#H9.fG@RD6$K  3~[j?/	P	p			
Q
w



;@FOY2QUY$
#nn

2Ss*r",*(6Ex U2egjkl%A\XTB012V{^L:JYnrbI1<Hd/w4gyo00A|\A%Fh6eYM`.YsCi(lZI,y>Y"
u
 
F t/

J
		4	zG=\L.g^3	j=#	     ] 3 	 ]7|yveT@,T MqU9b, m:~xvtoiWD!eApXC-# iD x`\XYY_emtuvogT@*
 #/;QgqI!k?hXH+dM6>FWgjm^O>-9D`|	'EMUcq@h	#/<2)(6D-uoja<0$9N\j_T.#*('*.Ml!V+9Gg6]?tP:K]s*Fcx+X",6So	"Y
=nCo
  - ; Q e z                        ,Y,=Nj.SxD<x>`#%';N{5U\dgi	-	N	b	v				
3
Y
v





=g/Ib{

3
d










"+;LnObuz<bn{|~)Fd{=[".26=CVhvd[RQPW^ZULB<6.'%#
}um\J0*CIO=++@:4)BZrx~fN9$}eM0lI           
      RSRC         [remap]

importer="wav"
type="AudioStreamWAV"
uid="uid://dgebs5mgpynvw"
path="res://.godot/imported/l.wav-803b4c7f630a9225d3d4e02c22b7e4ec.sample"
             RSRC                    AudioStreamWAV                                                              resource_local_to_scene    resource_name    data    format 
   loop_mode    loop_begin 	   loop_end 	   mix_rate    stereo    tags    script           local://AudioStreamWAV_wk128 8         AudioStreamWAV          U                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      ~|{yxwvtrokiggggfc`]YWUUTTSQNKGDBBBBB@?>>>>>>=<:97655678:=???<9869;<>>>@AA@@?ABEHLOPQQRSTUUTTSRTVXZ]aipv|~}    # * 0 9 B M W ` h m q s u |                        %1=GPUZ^bglu}",5<CIOTY_dinu|


~ym\LD<:865442/*$}zwtj_VLF?81&	              y o ` R @ -         ~uoh`XNE7)|oc]WOG;.$}vsplh_VMC;3.)}qf[WTPLF@:4-&
{rhebcd^YQIC==<>?CFKPJE9,#


    
$).37;>BBBEHKMRV^fnw~(5DRW\YWY[fr3IPXZ\afmu.>ELRXft$2G\v   6 L a u         &7GVey*<M^n|vk_SG<0 o\E,     y ^ D )  |\=yO%kI&jBkEyPmG%`3Y-vD~Ml=T$Ps:l8Uo9^#wAY u7I{ARj0d/c1_9^1{]?"gC(߹ߜ߁gO8޲ަޛޚޙޚޛޛޜޠޤަިީޫ޾/Ng߀ߜ߹	9iCxYlt/V4

oq{+U:A{;} Nb5	d
+q
3v0a qB{Y8 !"l#J$%%&&'~(P)**+y,1--.1//l011M22y34455066G77w88a99D::;p;;3<<<H====>>>?/?[???????@
@@@@ @@@@?????????p?`?Q?C?5?'?? ?>>>>a>7>===D=<<\<<;@;:o:	:9>98q8
87-76M65l554943p332@21w110R0// /.>.-Z-,n,+++**) )p('V'&N&%C%$6$#5#"0"!.! 9 GLXgleq}"3AUjK

a
&

wk_L9u-

+
	p	)	xB6M6x<t $'!pX@?>>>=;Pd >x	7	[	y				
Y



>Zu|3o1
q


6w>aeO9"~]<

n
/
9A


J

		2	<Q\G4Nq"{ N v+53AOZfEx020%",&eAs2'p@(y%KܲyA٩(ب0׸1֫Ջxzґ%ѹVϓ3Oxo̷Tʿlp$ǝb3Ƙf5	ŹŽ	,:]ƺ=ǅ7ȦɊ|̏ͼ`Ϩ8Uj҅Ԝ$է*ָGoٕ,b ܵi.޾߉`6}y
raV KZi?	z

h:n>qW !"$/%N&m'()*+,-./{0S13233456789:;<=>?}@kAYB)CCDVEEwFFmGGSHH.IIIfJJFKK-LLMnMM&NvNNOSOOOP<PhPPPP:Q|QQRpRRSeSSSTQTeTzTsTmTRT7TTSSS`S0SSRRRsRSR6RRQQQQQ`Q)QPP]P PO@ONN$NM{M+MLL.LKzK KJ`JIIIHGYGF%FEDBDCCBAtA@~@
@?(?>K>=h=<g<;J;:
:d98
8^765D5430321110/?/.-,-s,+*@*)((L'&%%h$#"#"!s! X 2Xj~8Q$A{y;{@WW6



{
Z
5

Z"m.


j
I
,

				Z	/		V*f3^+tO)jG#scSJC=6.&{kV@-	ugYK9&     o W D .   kM,Z5oK,dL3vY<uR/cDW)b9qS5b:Y%X"Y$x< LAZ	g?_
b	ZV-c <%sq4KߥPޫ^݆@ܥYw'ڇ5٘Fؓ1]֍-g Օ(XҎ)^Д/Whx͎̒˅ ɂȉogbM½+|S&5Ҷm7ִsQﲀ'ɰi\fM䬈,뫩UC2 ߪ۪֪4aΫf;N讂Sp*ش'ƶYxzfۺn =ֽo
@FĿIЬw.~Tܙ`)6Pj1B=l^L&	
Y
'+#f!"+${%&(:)]*+,-.
0O123;567>9:;W=>)@ABBDEFGHJJKLgMNNO0PP}Q'RRqSTTBUUoVWW-XXMYYRZZ0[[[X\\']]^^__```Vaa bPbbbbbbbbbVb,baaawaVa6a&aaa!a.a:a1a(aa``q`&`__/_^v^^]J]\\\[g[[Z<ZY\YXcXW?WVUGUTS!SfRQQoPOJON=NM=MLRLKeKJfJILIH HKGwFEDCC2BZA@?>>9=t<;:%:X9876554)3027120-/,.*-<,N+l*)('!'\&%$"$a#"!!O "J9N-$32
q
ZN
o

	i		ngeZ G#j~T)   k @  b/c2&<Ry+Tn! U    7qIdN $Df@g.D[qnI#c4a*p.by#f , [:x<a*h7Qk$7EZq*DdyznV3i.ETߧE݌J~ٲO։DӃҺ$ZϜd̥%fɞ&WŉG#^@3;]ŵ-u{
+Aᯅ7讍8㭍>񬤬Wm%㪠T	é~GߨܨڨبרƨԨ3d;!˭u<հZY񴉵9HѸj,ƻaNxzzƇǕȣɴ)πFӶևGڠJޛ4s(CWlF'lql	[$<KEG ;"#$K&'(*Z+,-./1A2n345!7f89:E<=>:@AB"DfEFGHIJhK)LLMANNOPPQQ*RRPSSjTT|UVV WsWWJXXYWYYY0ZxZZ&[[[W\\]k]]
^F^^^^^^^^^U^^]]>]\\a\\[[[O["[ZZZYZZYtYYX6XWGWV@VU2UT"TSSRRQ Q|POZONNZMLKK4JgIHGG:FmEDC1CBA9A@?P?>>u=<<e;:9887.6D5Z4t3210/..3-[,+*)('&%%
$ #! qsu5Tq
.>
M	at`Q ! 
{ppvvu|N<Q{
0Su.r$V"Oj4|;[)|Y6tcRA.7Xwyrrosw<bM%(k!.03;CUhpwX:.!
c?-~9tR^ K>#cq&j߄߱]
޳]܋
܇گR~	~i`koU&эϏ~I̭˂eDȮZƤ<ċ$_Ŀ5^#8Ncxȱߧڦƥ|dJ+ۚ֙ӘЗ͖͕Дӓcُ
)Dn(GŪ>ۃw8yAсxӁoł0=Մ"oӅ8ӆnʈk
?׋n4=ɒ-_ޚ_ğSݦبӪQϯCúó
ՁJݧn%+L
<B@>_ !"#%%&'(*E+S,e-O.9//k00211 22h344%555J66F7889 ;;<s=%>>?V@AAnBBbCC)DD'EEF\FFFFGKGGG!HmHHHHHiHHGGGGGGGfGGFF5FFEEEEmE EDDC8CBB>BAAAA@@@@@A>AAAA=BBB/CCDnDD!EEEVFFYGGHTI"JJKLMNOPQRSUUVmW#XX_YYjZZB[[[\M\\\\3]\]]]]]]]}];]\\4\[*[ZZYYX XcWV V~UT3TSSeRQQIPoONMLKJIIH(G.F7E=DCC\BvA@??7>l=<;:::9_876544!3;2Q1k0/.-,+*)(i'B&
%#"M!R)bGR		)=R
tjvV)k-
LkVD06#-R^\S  V!""f#$$s%%I&j&&&&&*'''(S(O(J(B(9(V(s(((')c)p){)n)_)M):)"))(()2)W)|)o)]))(((((H)))(*6*E**))))))*4*U**)))(({(l(i(g(((']'&9&%%%$=$#S#"2"! O }"b;n0n1}%
0

$
	{	2	.ALxU-z%X W CuhKwD8$(*)(?U8li߾_ݥ_ڠ4؀
Q՞;Ә+tk[̨ -/2.>_սݺչ͸ҷ̶^$Ⱐf=$
$Jݣ>ڡiD^ΛYhҗuÖD镎0ʔXmϔ[
iaޗh2뛠9ѝTbp_P6ɦgdWG6"̯ǰв߳ "D¹Fʾ_Vþ_%euWmm@<9 "$%k'}()*+-U/613456v77N889989!998h87765~5	544Z41433a3#32l2110e0//z.-v--,R,*,,%,D,,,-T---I..#//000000001\11'2]22d2?221112D2s222221%10z0O0o0000q040//|/i///(0x000}0b0w000 112233"445x6a7b8b9L:4;<<=z>N?"@@AeB&CCDEEBFFG2HHInJ-KKRLLM@MnMMMMM/ML:LKJI!IJHoGFEDD:CCBLA=@/?><;:9l8@7643T21/.--&,J+d*)('@'&&%%$$##p"!W! Z x5g	Ya
g5o)jC
n
 
5	b9^|  G   Z   2[tf~mZ'		
U




/~ m}ca\|
.
	a	nNz?/{ 5 HF-%S}c L:-A^yyimu$ogmE?n z e P 7 ! UWjmqset&
~laV+A9j+2@ZyEmMt^)An}~]D]889|Fa}	DXF2KaRSdtz_w.a]O\߆{(fۤ)Tו=զ
| _ў|omJzɮ*Ȧ[ǴUƸUď,¯2I:|μ {GܷXln^񱌱5ݰK])ǭw'׬gZ$龎:+ݪu۩`ߪ`"⫱wNժ[ϩQ ˪?]ЫD$ᯞ^ӱHײziWyp<ldI.(8G辚D[2Oɻʠ(| TьνϲЦF\M֮TޘmvfcN	&Cf` >  8 \  @!O!c! [ luBw"mq<l1:\kCPxjM C!9"I#]$%%%&9&T&&''@((K))))))1**{+`,F--../
//.....X.--:-,j,+,;,J,, -v--@../h/%0012)4Z5e6q74889p:i;k<y=>>??T@@AhAABPCCD_EE9FdFFFGG0HHhII<J[JJJJJJK5K2K#KJJEIrHGFF_EDD?CBA@w?I>)=<;:&938F7F6X5j4321?10f0%0//D/.C.-,.,z+*[*)z)(d('&0&%$u$$#a#
#"A"!]!    Va,ETu9HC
{
G









D
d


Gl`:TXVYg$ !!Q""|#$%c&'&&Y&%%&'#(R)**V+ +** ++,-./T0v00j0G000C11o1%1J0o/y.-,],=, ,+++d*))(e("('Z'&%$#"
"E!  } U  l{|F}H"k/5jfhxTrK.M,	3& e R @     K s o k Ar(h,QF<^{bT
'W
	2Y KZ}ޤݍܓۙF؎
@vԸ2kхЗψypa{ʖkMrĘ:}Կ'
pʼ8w,i33IĴ@4(?Uܳ^߲~
~8ͯ-Ԯ~(e{Ưү$vFdҲ9!ҷ\;IWйJ0伸B;mͿ.i¿j|T*'$Nε:`ִc٤`K1k,	

Iihl0?N!q !"B#u####$K$a$x$+$#5#"!>!! 0!I!M!Q!P!8!(!!$!:!z!!!:"@"F":""D"j""###$%%%&&&''d(L)0*++,y-B..//y0
111n22&3m33384445#66t77J8_8t8~8n8u8}888{8k828
877777G88888889M99:::s; <<<X==.>>?F@@cAAB3BoBBCqCCjDD]EEE4FqFFGRGGGGG|GWG1GGFF9FEE
EDC,CyBAAN@?>=<<=;n:987665432=1]0/..3-`,+*M*)e)(((''&$&%G%$$=$##=#""%"!X! | 
 $BNWJ<4 P-^V@~
V
X
E
		e	*				 	>			
a


n.

d8.L0BLN    !$!L!g!!!!!u!E!! 2 2S}h5Q6e-Nu$_{N3`1AfTB 
g

_R

t
C

		a		Yg.
YD+#eC DM) f 
 u)QGbgttgM&FNe%Uvbf,}o 1aݩIۣGم+OԊaј	*<Ywƞ)TzQK)ײUױccү,ܭ-ݫH/&S*Cj'㢟[TޠiD a5֜3=񚦚m,	ܙۙnȚ\`ș |+f?'Ɵ3Goޢ֢¢6^N6ޤs٤4᥏Ŧ~+a |#ˡYӠt&2ϦǨ驌9Mbd亩dò+Ƞ ͡6E׳ٸݧ߄5;i~K`E	  ZRNG^Z%LsL!H9m_A
		
3=

qK(t-v.y	Iz !!!:"""""#M#}#####$k$$%2&&'*((d))h**T++{,6--./]0'11p2/334z5866w788/99w:E;<<=>d?@@gABBeCDDDVEEE-FuFFGNGGkG_G"GF{FFEOEDD"DCCCBEBA;A@?E?>=%=s<;$;z:9-987O76@65p554343"321O10q050///y/D/.._..-S--,e,,+[+*~**)P))((*('R'&)&%$Q$#0#" "`! $ U<(
xnL](	=[! UL  !!!!("l#$&(*,;----.. 0n124#41431%1e00Z122221^0// .-p-- .4.?.~-,+**+*))((&%3$""d!_!Y!M!A! ] L *DFqS	-Ku'N7`+l7 vrT6k2lX[ 	)?&_{.l
ON
]
	e		5rBH?o Y!\
}.l2gI_@{,[\nVn]@~߲SܛVEQWy֣FԏpӱEцvϹ]ΚO̜:˝V˹QzxǍ&ou&*ń=P/źŪřgOĖØg|Í48+âf*'5Y}Ý#UĐM.tƅƖy0
CmƗ(Ǜ
u"qɽ8cʈʠʸ
,Xˆ˚˯ːa2ʻʧʓz[cɵVǚd;ƸƌOONG˽ЉҢ!,^	}> Z{:

!%LP@^:}$ARbkep{&De vO  !h!!!!"t""#9$$8%{%%&Q&&V'((&)))*2*E*r*** +W++++++++++,/,",,++m+T+++,v,,--5-U-u--&../a//////10{00L11)2}223O3334_4445<5Y5w555H667g7777777888877|7E77666|6Q665i5544m4F4 4333R332222]2(21s11050//l/>/	/..^./...-.--u---,,v,K,@,6,	,+P+*4*)()(f(('k'&&	&%%$u$@$Q$a$S$E$#;#z"!L!  
!,!K!"!  O4&0KIGt,a`gRt$w	&LlS*G_n*h
H
W]


U

		Y		=~1[<h p + i[Y$?%gA>\{
.^%Y.,,@\iU?U"ugR0ޝm9۫(ڳ>d׉׭>SW}iьћ/qΕe5͎Nͽu-˭v>ʦvMɨɡəɛɚɀe+ȣY!ǩ~]%ƨg#ŕJŸăJ%Øk7®}lR'g>1)!ypffft}Ql+J¹*Xâ(cuČĚĨ&SyŞű<[yƉƕƣƱHǉǳ2kȣ0Agɘ/ra˞6̂=ͦkZϤXйѓEҕҀԽqֹ2צؖ<ٰzG݂ߠ4]F/nws2tVR.BI.&|n/AwV R O i v GP."p&p .		@


D~	[7
}

LE4k"IMQ8/b1JdR3kB$]-eqzSa`7Yd  '!0!:!n!!.""v#*$$*%o%%%/&&&7'''<((((*)C)_)))*+`+++++++++++',J,m,n,n,m,m,,,,,,,,,,,,,,,---C-\-s-----..,.0.4.5.5.`...D///'0Q0U0Y0Y0W0s0000131>1G1N1T1g1z111111111T1(1(1(1E1c1m1x1s1n1e1^1A1%100U00////////p/Z/<//....E..------..--------p-6--,,,,-(-@- -,,h,),++++++_+0++*****v*M**)q))(V((''i'9'&&q&"&%%9%$$0$#t#(#""`"/"!!!D!  E n8F@U?ZmzP'L8awv,sc43

Z
$
_6>

E
		[	
	l c6u#Eb,sGu/f2     ` =  {Z9oF#
N|FpEk2p}+{Q5qCc@pI%yH{fYM>1!x_E3"""0?Rejj`VSLLMQVVURV`jpxqi]ZWZTSSSLB7.'|a]U`jwrcA{xu8Zhutpica[XU]dx (&$%Ox.OoH9Z{&U "6IHEJOn*Ns(Hd<Vq{*;6/)"*0ZAFOXa1Miqwus&ImkjR<DM]N V   ?g/v9^&b
!Ho/krpm+E_fkU>'^fmsQ8 #;N`M;3Pp3GZnprdWUTao$346%	'_9oW< ]8{nlmjfUD.o?#/|lJ(viS=&
          y n h b O = +  
 tS2rBw]G2) mZG9,sY?1# !#$$}vnidb`VL:&zlbXO;+
q_LB71+$  	/?LX]__^adgjnsy##$ mVJ<;9:9=AHOW``_^^bdddffggkox3Ss '-2:BHMV_gmoqplnqy#4I^y 	 %0;J[ix~!%%&'$ "5<CILU^gmkigfc``bkuy}~xxy~{yvvuy~+7CL           
      RSRC         [remap]

importer="wav"
type="AudioStreamWAV"
uid="uid://5wk4ush57qtu"
path="res://.godot/imported/m.wav-1ea125b11ab9cd027dd07cc5bd07308c.sample"
              RSRC                    AudioStreamWAV                                                              resource_local_to_scene    resource_name    data    format 
   loop_mode    loop_begin 	   loop_end 	   mix_rate    stereo    tags    script           local://AudioStreamWAV_pyrcv 8         AudioStreamWAV          b                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         	 
     
 
                 ! " # $ & ( * , / 2 4 6 7 8 9 ; < > @ C F J M O P Q R S T U W Y \ _ b d g j m q u x { ~                                         	"(,0359<AFLRX^djotx{}wog`YTNKHGEA=6/&            w j ] P D 9 - $    yk\I5# |kZOE6(|l\J9'nVC0"raP>,|kWC+|eH*rX=$x\@$xhS?&zld[OD3!u`J@59<;;5.
 ,9CMWbp~,=Rg"<V{<Yw$Hm">Yq!Iq9c'S~
9hGo1n  T    "TNBM)p IRE 	h			1
r


CV
D


L_*i/wD~6~=q7kOBm:m	8g Fl
<q0H_rIb{}_>g7vFa+u; d0K<bLZUY`mb

e

v b

8
	}	#	mV0a0g%A t  <c!R$]&Hk +Vx!BpFG{dYE+tehqt':=K@<ެ^݋T܋Vۙ\#ڸڇ]2ٿٚoDط؋_3ק׊nW?&ֻ֘u_I?5-&լ՞ՐՎՋՎՑՍՉՄՀ~{sj\OONhՃզ*:Kc|֡%5D]uז׶/\ؕBqٟ Uڞ6ۄ)wVݚ+xDߺ/!&VTN	b8
p3Mf08l'\&} O!tis~	
hL
 tGc7
o1q5w7 	!!"#u$R%&&'{(@)**+e,--D../500U11@22%33-44U55|6
77889w99_::V;;Y<<E==>a>>?u??9@@@AAAABlBBCqCCD\DDDD(EOExEEE
FEFtFFFFFFFFGGG+G3G<GHGTG_GkGpGvGsGqGjGdGeGgGnGvG~GGGGGG~GsG^GJG1GGGFFFFFxF]FAF&FFEEzELEEDDDDvDXD1DDCCCiCIC*C
CBBBBmB9BBAAUAA@@@O@@??@?>>O>==]==<{<2<;;P;;:`::9a9	98]887Y776O65554+43<32Q21i10|00/
/..z-,l,+j+*{**))(+('6'&@&%T%$]$#r#"""!8! L Zbiw.=Ni9yN!j{,{-6
U
/[
d
	T	J_JXBHc
 Q -^+Gzi.^r-OUAUFC.wn(R?9Zc
n%wA=O~Jw*QߑT	߽nv!tnt#٥sAqiփ=վmkԜ/Yѓ6ЗMдeϹa
γYͱm)˷v6ʖ8Ɇ1ȑDǠJƖ@ŘFĮl*ÙI¯f-z-/׿~$ʾpS Mߺm:Fնc49Cͱd;௄*ЮoC笊<\jƩt!ΨuçiϦJץj.񤩤a#xj]F/͢xptw|thVC9/6=CIPWsQ£UN~	(K٩jTڭq4}@|:ҷtO*ǽ_: *Ijȋɑʗ˔̒ͬOҩL֕	2[}ݞ<o 6Og{*j(AUi S	6O
hlpsw|y T!/"#
$%%&'(w)E*++,d-&../V0
11^233E44w5
666]778w88M996::
;^;;;<I<t<<<<$=]===>$>F>Y>m>>>>>>>>>??'?<?A?F?1??>>>>>h>J>+>>====P==<z<.<;;k;,;:::K::99W988Q877z7?7766>655E544-43~3/322>21110K0//!/.I.-^-,x,,+P+**'*)`)((3('W'&&&%0%$-$##""!! ! %(/BOXi}E&^7r/n<"
B
q<

n
&
	y		x-}i]QB2|ui\A&z3yJ>1,'m8%').Ba>i2YEt3~a 	P					
;


M5Xz
%
9
M
i







	(7GNUK@+







m
P
3

u<c0


[

		I	q0I
SBPUK4 k  7uY(^(Towxvq_?zDQLn*A]6
n+ވ5ܑPڴ#ْzWֹs+ӊkmxxiL:UɛCȉ(fƙ4oq,äa5Zytnkga[\^w QÈ ķ`ƹi
ȰAi ˳e+ͩ`ϕѐkz-ԷՏ{gL0}7	%cCvxyncfiu",5 `

cw'd "M#$%'O(z)*+,-. 0	1&2C3t45679*:*;+< =>??@ABCrD_E^F\GTHMI-J
KKL6MMpNOOKPQQeRSST|TT+UyUUViVVWiWWX\XXXYCYnYYYYYYZ=ZhZZZZ1[S[u[[[[v[m[e[h[l[}[[[[[[[j[,[ZZpZ=ZZYYYY\Y1YXXZXXWVWWV}VDVVUUUAUTT=TSzSSR]R RQ;QPoPPO2ONQNMaMLfLKiKJuJ JI"IHAHGEGFFgED!DCB?BA@V@??Y>=<,<m;:99I8}7655H4}3211=0O/a.t-,+*))N('&%/%h$#"!!F n^]BWGei^p 
5
Z@

w	.bMa{!\J9  
 Y5!U]lg+6v<|O"T th[t-n.Hb"Bg
#zE~aEQ}=~HE?]Eu&`7tZc
#Eyp	#ߣދݐ"ܴ=?ڹ:ٻ@A׼<ֽ;չ&ԔbLTEϧ
\ͯW˻x"r+Ɔ,wÿM9wZ"Fe޳UհWAݫ)xȩ$ӧ&pWǣ6-=Gj֛_t }jڗH/*0?ʒb1E؏j"ڎ];1(:LpɎOG񑰒p!Ӕr)/͙lЛl	qٝ*zE|_ADH@9鱗t`KҭY߰Vͳ
MuʹBg	;mƩOk̇͘ΪPӳ>I]ݗ[
{uz7jK8<f	l
g]9k
E~
!"##*$2%X&~'(*J+,-./V001N2334p5866~77x88O99:{::_;;F<<$==>s>>P??@h@@A\AA%BB(CC(DDD6EpEEEE	F6FcFFFF)GMGqG~GGGGG|GGGGGGGGGGGGGGGcGDGDGDGPG]GUGNG*GGFFqFEFFEEEzEQEEDDqDFDDDCCCCiC:CCBBBBTBBAA(A@T@?j?>}>>==<<;:o:9n98t87\76 6~54Y43O32*210G0/ /\.--x,+U+*F*)4)($('*'&;&%/%$$##"J"!!0! . ?7l%KyK!|O|a<2|q?
}3){^isx~fMY5









~
|
y



5_u/B4h4oj&2y5f
R:~<ZwKiFguI~GEx8E[- W\cs&s*=M
d
(b


		|L/7>.I Q  i+.34%y&}"nFsY!X8aߋ޼!Vۋ5jן Gh҉Ѹ0z\̟
7eȣ9ƑJĦU©8̾#zܼ? Z
g˷/hϴ0spo'U^(̫4N٭c¯oMβPֳ\󴊵-жxMj#P_<):ȌX=Ϩ5VՋֿ7j۝T2Me|'T:CA

HG|Z< 0"#%^&'){*+_-.>0124G5v6789";D<Z=p>z?@ABCDEGH"IJJKNLLM<NNO5PPSQQ*RRR(StSSTUTTUcUUV]VVV8WwWWW(XWXXXXEYYYZDZrZZZZZZZZZZ~ZpZbZ@ZZYYYRYYXXwXKXXWWWWZW'WVV^VVUUuU?U	UTT[TTSrSSRZRRQPQPP)POGONoNNMAMLxLLKOKJJJI3IH:HG#GFEUEDDSCBA#AW@?>=#=Y<;:9-9W876544E3l210/-/].-,++3*^)('&&H%}$#"$"c! JDF<Ldx3
@
[
	:	%%Ct^T}
   :ZyhV*s4?+X,dEc:-*6?IGD=5;Bgqg%?ZMIZjiglr2}-?P]k"<Wsu:q_M0{7+3`7
g(I`C1UX>7]zsE- ߌ5݆)z$vkֹPԙ)fѣ8jͰBˎ)oȶ,dŝ3dҿM}ջ?dʵ>n԰3_۫4hҧ	B{@ɡV#hEBI dɔ&>kԏI7#`#Ƈq!ц2셧r>4*;Kv߅W6:ψd򉁊'S󐘑>Ւkx?ꖻv}p\K:\}ϥ ,tKxʴ?f$g;SlƂǘˌ΃_ҼP֘8ڐ݆Lvwkf^]o2Y ?,	
U
rh0\L !#C$%&(N)|*+,-./Y0,1 223m4-556077H88\99u:;;<<==>>3??P@@OAA&BBB7CCDDEEFgFFGNG}GGGH=HtHHH%IaIIIIJ+JDJKJQJ]JhJ~JJJJK:K`KKKKcKHK8K(K,K/K>KLKSKZKEK1K
KJJJ_J6J	JII{IGIIHHHVH.HHGG;GFFPFFEETEEDPDCyCCB BA@|@?q?>O>==<;U;:(:98<876)654?433_21"10/=/.-O-,,y+*?*))l('S'&>&%%X$##p"!^!   ?\ij~.6<xWWZu@kKAqW= 









|
_
:



#
=
n




l
5


7
V
r




$7I\gl.t>x'Ib<m2]iLn'=/<J[k )39?,kigx{n8jCVAx< {B	Om8at;

)
	j	zrEy5Q . EZD@g4r<|X<=mBkޔ
Mېڿ>m֝/^ҟ5Њ1d͖̽ ]ɮJǕ)}N|߿doһ4?ڷ"g\ӳJǲE1/ů[ PuN( <Xέ<nUwܳA">ݶP򸕹޺;AtfXD7"
;ro>pԣ$IfۃܝݶAsK
;JIG : w	
Y
y/mM0
 u!"8$%&T()+q,-/90r12346=7h89:;<>
?@@ABCDEFGHMIJJKKKLMM>NNZOOUPP*QQQ@RRR5SSST\TTTEUUU0VyVVVW8WXWwWWWWX X>XUXkXhXfXTXBX+XXXWWWWWWWjW8WVVVKVVUUUdU8UUTTkT%TSSESRRuR1RQQCQP~PPOFONsNNM0MLSLKqKJJJI&IH0HG,GFFED^DC1CBAAA@??V>=<)<t;:9.9c87654#4Q3210+0[/.-,+**,)O(q'&%%G${#"!!( Jp1kL1o&m
_j

K

]	mQb:Mt	 M E+3H0n	ARzO#o_PIC2!e<(-<KKKD=1%"4Jw&KfLp^%Fw^)Pv|tf`Zl~! /Rvp\H:,'#x@x4i&>Dh@5m8i $tsyzf=qD \߾nݭ)fڪBؗ@֊UӍ"\ϕ-\ʖ3hƝjöMο/Svƺ%V?dŰۯ.Sx©>eĤ0oFD`rΙ'җ$y͕/_Œ+1ӎ%S*"G䈔DN,
8f,qQ/`
b+g
C̕VߖgZϛŜݦ
`
eJn۶&Imɾ
/XÁĳUɊXν"ьZվ!؅U>D\z	pjc9
	

q){qxU !"#%'&M't()*+-.//0?112S3445S6
77l899::;;<<5==N>>U??Q@@DAA&BBB`CCIDDAEE+FFFDGGGH8HfHHHH>I|IIIIJ+J?JSJgJJJJJK$KIKnKKKKKKKKKKKKKKKKKbK9KKJJJhJAJ
JIIZIIHHZH%HGGG]G)GFFdFFEhEEDUDCC,CBRBAjA@o@?c?>Y>=J=<J<;D;:3:99h877n65,544y32T2110/9/..p-,U,+G+*9*))('X'&:&%/%$:$#w###"s""!9! F [K i90Bge:[yuVPK?3Dd$
#/	r=TwEd+/;GGG[n@y)KlA|@x"Q>Zv >|6=EA>LZ1ax~lN1& .<FQON.Xk>WrBy6J~Zf0'
A
Lk
n
#
		$	70Dq+7 J (JX_y=M.tQr5@~V'yY߿ 6M{ت+y_ӜL|ϭ)͋eIʵMȄǺSč+jҿ(~ƽR.hطQʶD6"0ϱ~-갧yK/)KL#I쳐3׵feַH6Fٺ} G2о4CÇċŐƁr[EB?vͮp^գAlۅܟݘޓ߇{#Z&mEY/[ ]	
T
R`FlO !"4$u%&'')i*+,.*/M0p12345679:;<=
>?
@A#B(C.DEEFbGGH/II{J'KKrLMM8NN OOO:PPQkQQ/RRR;SSS'ToTTT&U\UUUU0VnVVVW<WcWzWWWWWWWWWWWWWWWWbWEWWVVVhV?V VVUUUUwULUUTTgT?TTSSSSLSSRdRRQtQ)QPPGPOO@ON|N NMrMMLmLLK(KJ=JIKIHYHGhGF`FE1EDCPCBBqA@/@?>A>=<3<;::K9876+6b5433X210/./T.y-,+*"*\)('&3&g%$#"."f! Q*|n2pVQT
?
F

		xjk5A/ ' >35K&fe
g=vGa=%
P
VI;SkyykR:$CEy	'T9<dp} !,7;?3'rqo{fJ-%$+4=@D7*b0yP,^	STu=~"[]Ey52	|u1^kP޵݄rډڥ.ٚ^׶n(yhѺXϥ,ṉ4oɩ#hƮMĕ#jLY[G=ôDrدK}S٦4b٢/?@ޜ*ݚEdҖAZ˒EBƐUownm}1߉Y&ԈzV1$2M
ZZnx5򍹎/ݐlUn*W{+Ţ̣
#:~®2].oͻ0Yiů$T}˧,Yѧv֎#ڏV޲tUQl8>Z@  kbJ

n9Z*i'Px !"#$%
'()$*4+M,f-x./z0j1-223M455o6)778<99w:;r;;F<<'=='>>*??@@AAB{BBCCCDoDD6EEFiFF#GxGGHBH_H|HHHHHI(IKInIIIIIIIIIIIIIJ/JAJTJZJ`J]JZJQJGJ@J:J6J1J)J!JJIIIOIIHHH]H HGGQGGFoF"FEEIE	EDD/DCqC
CB<BAoAA@#@?*?>!>==<;U;:;:9'98876`65;544\321:10/8/.-_-,%,+*A*)(N(''&&%%$$#"T"!*! S/4MULA7FuV6u!o>.0AWmf_93O+B

Vq
&
							H		|\<k 	g		
1
\
~









<m FJO3	G]

 .[5kea2x@	JN=WBiqxtpI`sQ0(!$(19NbWL
pzS:"#>|/I}&dwz >&`

H
gN
L
		*	vHJxLIA I$z%a	D/q)LoJY~3N+ߊ8݉==>BFqԝ+hѥ8l̠fɱ~c>Ŧu@¥Ukڽa]ӻ4O$(˶m˵oKwGA;?CA>DIXhͳ m۴r4?)ûi'彙Lܿl_Qs3ŹƬǠȍxX8:lԴB؈ٳ2Jc}
&Y]7k w,7
#v
EB/e D"#$D&'()+F,q-./02C3l456789:;Z<7=>>?@A{BTCDDEFFFkGGHIIBJJbKKaLL;MMM'NUNNNNO0OlOOOP\PPPQ8QhQQQQ#RjRRR?SqSSSSSSSSSSSSSvSoSgSOS8S SSRRRRRrRSR3RRRQQQQzQXQ1Q
QPPqP:PPOOIOONfNNMdMMLFLKpKJJJI3IHWHGsGFFFED`DC)CBAeA@I@?-?>=^=<<N;:99Y87626544Y321160c/.-,0,o+**Q)(''B&v%$##<"u! 6	K6vH<JYa
!
x-
	N	s5^9$& F +f)/Fq.J4fZaoX@:4)`- 9Pgq|Cv+Gv"Y/hQJGf3Hk!28=@CQ`}	 q[*Ow7S[@4i+eC_{0OgzsLhG}]8ޟD܉[٣2x#{dҢWϜ8͎B˛Kɥ"SƅNØ@ݿ*w,Zz4dȳ/aů#?gĩ<զ(>֢OßLN$='\3֑yF܏g򎇎ҍeCEGTaiqkfa\-K񏪐bE֓TєQҕfOV 22~[C,,-)%⧽y>"Woк

!5bÏĻ*543:@nМ\9׎ ^ܝ5EwpvXxAh_ E	
)
.|_=]el`TK A!C"E#N$W%o&'()k*=++,.--.g/+001I22{3444l55A66A77=88!99::;;<t<<3===Y>>N??1@@@GAAABABmBBBB
C7CeCCCCCC#DVDDDDD	E$E@EhEEEEF>F]F|FFFF|FkF[FVFQFLFHF/FFEEEElEDEEDyD-DCCjC/CBBBMBBAfA
A@)@?<?>e> >=.=<@<;0;::o98>87'76765U54Z43J32,210U0//.-m-,],+4+*)L)((\'&&%$i$#[#"I"!*! 
 U1#*$fZb|G1a']C

O

~>};

<
		B	x:_czW345@LFA)M 8ZAr5n	R			T

i.b
g

[n)a9C95W97q7x"^YX@Thpw
0CUY]PDCCMXftz|^?|Z9WhGU\
[CxKF"{
v

	OnG= 6DG#kOA^"R^6]J߾&Oyۗڵ 4PԀӰ,eН5i̘)eȢDƦ[į-fտAx̼! nݷRǶMӵoɴpZF2ҳc=.d fδ6۵9.øQ߹oGּdν97)µBĮŏY#ȨɊkd\\[~Р8nգ֟כ؍ـڡ#,654Tt
-:G}q6Vlh$}#	
2
%W-a1 9"#$%&'5)t*+,-./01234a5)66789m:C;<<y=*>>?[@AA4BB0CC\DDEEXFFGjGGHuHHHKII
JJJ:K{KKK?LLLBMMM
N?NqNNNOHObO{OOOOOOOOOOOOOOOOOdOFO3O!O
ONNNNeNGN)NNMMMYM'MLLL^LLKK=KKJJKJII$IHTHG}GGFFE2EDYDCYCBDBA'A@@r?>?>= =]<;%;:9/9}877Z65414y322Y10/B/.-,9,s+*)B)(''C&%$ $7#n"!  K3e[!a+sI!n
f

n	5
zn ~  JsjJ.;rmM8\!xHi?X2}X3(S~:k0_ +V~.?CFGH_uMqL|8k2n(Kn|#Uz}{zwh@bB,".:+s\9t3F@~NV ?M{ zf>4!QOް݈
ܒymؾ~9Ր:Ӎ/x*b͙+zdȳTƧ<oâ	P-q,eи.YʹcJ){ͭ#yǫc	bnƥ!{ڣ86Jt~5ٙ}&Ϙ}+䗝h3ږӖÖݖyߗQĘ"ϙsa0#r+ܦ$Kک(yfTKC8-+(R|"&6Glî
"(3Pmҍӭ	3\ۢ$`
O%hD6t7n )NA
o
3n!.,*!"#$$%&T'$(()*]+$,,-T.	//L00Y11w233E44K55:66!778n88R99]::m;;]<<,==
>~>>b??)@@@@8AqAAAB-BYBBBBBBCC0CNC~CCCCCD	DDD)DGDeDDDDDDDDDDDDDDDDDDDHDDCCnCBCCBBBdB+BAA-A@@2@??F?>>>=B=<P<;e;:z:99988776	6554$433221010J0/U/.L.-0-,	,v+*j*)d)(Z('7'&%k%$P$#J#"M"!J! D >5+/<GYx8=Ew#/`%\G


k
>
b
k=




z
D

		i	>			+	j			2
W
{





.V5a*
^



&\J[?sFAv@od>a/Da}mZUP\izb#rB|C=<L	>8o
A
}'k

		7\p
w]T _ X;o2e3?p!6-}['u^)kB
IޅOےJ؉R՘ArѲDϗ<͓EˠPɚ4ǆdvx^A8DҾa[:ǻT{CιaG-($Ը̸:YIiƻ$LAKqŀ}ǶfpˮM̓'κb՛lU?]zۡ
+;EPg~$$$.8_ 8dJ	y
$_>i>Siw !"#%&<'L(\)q*+,-w.`/N0=1&2334p5,6678U9::t;<<T==>.??i@AA<BBYCCTDD+EEEeFF2GGG0HrHHHGIII	J?JyJJJCKKKK0LiLLLMPMMMMN,NKNjN{NNNNNNNNNNNwNUN2NNMMMMMpMTM.M	MLLLMLLKKK`K1KJJJVJJIIYIIHfHHGXGFFEFEEED2DC3CB+BAA@!@??>	>z=<]<;>;::y98>876Q655\433^211V0/.>.-,2,+***y)((f'&%F%$##["! 6 !sb>K8;>Z
2
+K
|

	D	`jy&Lt ^ Mb6az	/hG
~%3p2zAi4f<wgTB>:JYeplhhhy*19;<Si2Og~#'-2457:K[tpcVRNA4 oUC1|aF"nIc)xA	b#0R89^A2i9l&>b߂߁yqOۻ'ڝىkA֩
r<ӪҀU1Ϡl'̏eGɺ#ȍQƭ
ZīEP_JIlշLö8`Ĳ(mޭJyߪE5?ŧL̦Mĥ;=ӣi	O;Ԡm'n՝Iw:̛sL7!"/Sv͛+g-bڞ_hjz]r$ϧzDت4Эp"԰z ⲥpjedddc[RF9@F\qÐį#Ks΀ώЀrolԀՔ֪׿
K@Zu5p!e5u I9p	
<
0Nlt{vqonaU: !""#$%d&/''(p)0**+s,"--f../*00a11}22r33q44}55h66>778n889c99::;o;;(<u<<<=S==='>n>>>?C?g???????@@@@
@@?@#@6@I@H@G@2@@@??????@@@????^?;?.? ???>>{>?>>==V==<<W<<;R;::>:99H988D87o76665:54X43a32V21E10:0/1/.'.--,
,+*d*)Y)(P(','&&b%$#$#"c"!>! 2 [8&|z,u"/6LL}1>

X

L
mA

n
4
			o	H	"	USg@`@*$3FZp
&Jm	)If	>q"	M			
D
s



+\G)
W




>}/^!Iq"+4AN^mw*Qj pW="]/	xPJi.

]

gl

9
		3	z#w"jJw3h ) G _}',1999/,50|L"e0uN oT2w[9ߢt]B۲"ڕفujchxӋҢ2gН1Qt
͠6YʀʲHqȠ>Ʀn5ŮŌv`N<2(07`ŉ&Rxƞ-hǳ[ȸ1ɪʋH˭̚!ͺTΌ дIi҈hd؜6فCܯ݂V,|m^WOJD0|V0 oWG7-# 	
$.>O^m !"#$%&'()*+o,T-8./ 0012^3#445R667G8899::q;<<==#>>)??#@@AAAaBB-CCCRDDE\EEE5FyFFF8GsGGGHHHtHHHHICIhIIIIIJJ1J=JHJMJQJQJQJHJ?J0J!JJIIIIuIJIIHHHHaH8H	HGGpG;GGFFyFNF#FEEEKEEDwD/DCCZCCBvB#BAiAA@4@?[?>>>=D=<l<;;;: :9987h76S65J54A43.32211w0/[/.=.--,+k+*D*))('^'&&h%$ $#
#"!"!3! & o@)=l'(4f-;<?D
Y
7

		"G|mf,^T  < L=LsX9bo
byF|S*U>&|MuG4 \$}Z7%b*W#Q) j7Pa4rDZ{U.]qEi$[S[aߊN޴ނD~8ܪb"۪s1ڤXڴaٷ_ם8u־eգ;b{ҎѴQжfϴQn̄̳Y ˬXʱSȋ!ȶKƉ*nžjĴV¡J+uп4澜Ql ؼR໬R#󺼺M๬yFиd8ݷzFݶY2еv\C&
ܴӴɴ|eO6۳سԳֳٳ'Lq:F¶=зc0Ⱥa,ǽcx3äĉfiƅȰFi̎ʹTϮЂ`='״ؓrS5߼l6 nqVj.aX oXB* y_L9- 		

\#~P"`4t&w6n C!""k#$$.%%/&&=''l())4**7++,t,,9--.k..?//000Z112r22(333A445m554666-7j7778/8Z8}8888888899888888888v8m8d8]8W8J8<8(888	8
88
8	8777777777777x7a7K747$77
776666@655U5544N4433c322(21_1100b0.0//^//.z.*.--;-,,\,,+W+**,*)|)()(]('''&f&&%%\%%$$,$#p#
#"F"!!x!=!  & 0=b0`H!s3@ kH#[$]Z*8/*yv*

D
(<

M

				\	3		yiO4qHc?eL2w`HD@BD;2 vlcY="kWC&	nE    Z - KrFfF&oH  }X+o@Nk*zFKKEXt"x~<FQxDTn$^ HPt2J	= d;S'x\2X9kD߾߯ߝߌpU<$޻ުޘދ~oa_]jw~ކ}uZ?*	$>[yތޠ޽6aߍ߸EHI&p
4^bE.2Z5\BgmN>S_3X8  V>p}5	F

)

8[?|>]Cl=rJ}  B!!m"	##D$$%0&&y'((D))i**~+,,--..)//000:111B222V33444:5556\666#7k77	8V888 9T9999:(:P:y:::;;;];;;;;;;;<<0<@<O<^<b<f<`<\<P<D<6<(<<<;;;;;;;m;Z;F;(;;::::~:e:L:2::999z9P9'988888v8]8;8877}7>7766N66555Z5)544j443q3322D2	211O100R0//3/.t..-q--,j,,+/+*Y*)))("('.'&7&%I%$a$#w#""!y! l orbI8(dI.



[
	@	)}ibU<   sv|uV,xne\UPMPW`hu ,Qy
1T}KR߇"aިQܢLۓ:چ*ق2ؖI ضg}9յv>ԝf.ӟrDҚpDѲє{cH.ЮЙЃr`QC6(ϴϘρjYG8( 	)4@LT]fpwϊϖϡϭϼ-:GTbtІКЮ0F\vёѮ(KoҔҽ>mӜ4]ԆԱ	5[Ձդ	+Mn֏ֵ,Kjׇף
/X؂ج )YىٻEsڠ;gۓ*_ܔ'U݃ݸ*fޣZߑ&Q}D}8vPS	J6q/r2o#a!d Y6t?B'_]%i9^8jZ S,oXZFB}Y`H
 T   Kg
[2y PLD,x	[			8


>9	
K


S/e#^Pc>E5q)h&gWHzKx=VnDl #:Pcw Jt
  % 3 @ Y q                         { n ] L 2   kP5pY>"`:|Ep=	Zm2Rp&IB	]UTVDk#T
u
(
@\
r
'
		I		};m'P<p(Gu-d#  _  Et0f#a#m0y;AUOyFT/
pEaA(c<nV>(cF3 {md[UNLKHEDC@=83448<BGJLMNSYcm|-<FO[g{4FXi{&>Xr
'Eb:Tu&Hk5Tn*Lo=b5_'Da~<[u7Rp 9\8Zx?h + Q x    =d!Fl)Jj#Ba|8Ww*Ln	1Z1Tw	*	I	g						
)
C
[
s





%4DWi5Pf{
6
T
u




/Ic}(:KV`lx
1>KWdp|%1?N[it~{xtqlhaYVRSSQPKGEC=7.& p]K9&r_L=-lT=&




v
X
:

sR3pP.




e
B
 
				n	K	(		sO*jE!oL*	\7d>wM#}Z6Y2    ` ?  gC sK$jF)}`<lK+oR9w[B(}hSA.	r_L8$ufXJ<.!zk\K9'uk]PF</"{l^O@8/(!$,5?GOQRUX[^djqw{~#+4=JW`jpv "-4;BHR\ht~(4DSap|+:HUam{
 /=GRZbj           
      RSRC         [remap]

importer="wav"
type="AudioStreamWAV"
uid="uid://cm1c8w73pn83g"
path="res://.godot/imported/n.wav-6a5d210ec99e51c5b925b73da1f43c2f.sample"
             RSRC                    AudioStreamWAV                                                              resource_local_to_scene    resource_name    data    format 
   loop_mode    loop_begin 	   loop_end 	   mix_rate    stereo    tags    script           local://AudioStreamWAV_ru8gc 8         AudioStreamWAV          fn                                                                                                                                                                                                                                                                                                                                                                                                                                                     
      ) 2 = I W e t             $')%!	         o ] L > 0    iVC/t`I3  gI/zcN8'
 )Go\&:CMm;xdM5CPhwoR4"0@;5} 0>LT\| A W l v            u W F 6 &  Lu2$ |^  \K:~=	

\UdIH"d4-9&6
Y
<

p	UAlP1S  < @&4"TJqA*m't):kkd973
|7O
3vj]9M?Ur}qdhmjg5WU_2FZwUwKIGXi[L}i$D'_0]9 P4n@ U_Fw6	
l2
_;ib>x~ )[  Y!!!"N"""#]#####$1$S$t$$$$%%%$$V$$###R#"""!! & Y3EGF(t]@_|M*
&7HT`isuaMD<, 1=IYi~'-37:FRapv|skXEoR5
d'X,`	Fm%
:
Y(
t

	i		P(9GPR? ) /H^jq~!!e5jI>8>EHcw xkvt,N ^]%q*ߟ[(ޙe1ݪWݶh&ۡ^۰Kـn.צ]|gfz/ӼI>i.ϒBΏ-͋X%̯[̬PʩʑyKɜd-)%0<ȷ~MǹǔrQJB[tǒǯ
@yeɉ1˶̓wЬԩrQ1Z\7	
}GQQ!"#$%%-&&'f'''!(d(x((((((((((]('&
&$#""M! 
Ypf.)$A]YU6F	]-an
V
	?t8cr 3-`thwY bUFfzF  }%S>H#up	]
(Z

KrzgEr"{.&y[
@!|A!e9*#e$OBu=/iYvO4y 1~'

xt



	0	og]>cF y8U  w v t  .8D}L		J

#
xqE^2
Z(w.N  e!![""Y##N$$
%Z%{%%%%n%P%%$$$Y$#$#p#"J"!! - h.f\Vd5GQwKXwFSVEW}
P
Y
8
		rc^B  c:GOK[ ]DZK)ADJ@Nv
SPQ YOP݈~W:ثבpԅ9ӷӀ0yҲQѺЁIϏGΡE͙J̣uA
̿p˦AɆ/ȗJǝ=ǿARĥ`ÀøG*W$ؾgB,ǽHݾ:mK3\ĒŞRǒN	ʴ`̰~K:(ї?pC%&'ڝ!ܥI%g}W1@P3if>x#e] !:	\
} l3sS2y
   W!J!=!  < n!^!=`5
5
T

s	pLYfc  o#
dU)% JU|pM*^lptF4x6f_fIE#& 
 e	
w2

)L:P[,!Fmb/{. =^xq9So

U
1


v3k

(
	`		_lL[ u )fX]FS%H
,K<g]@ti^jv   0h:	
s
7	V+d`Sj/oqClFW)MpYBQW;T3hvWRLx2H]!a6V#@
7
`
Z
 
	]		N41v,` + &#N3<qEX\^lai@b<zfXK~<ܴnܰ;R~ؚ^#ה<s֓#p0ӵy4ҚF@Ѳ$Ъ1rΒ͆̵ZʤIu\+ǭ/Ƹ@Ř@Ñk`3տN&?pۿ
.S6i)d©OïĐT;ƌNɫ[̉͒Α[%ю8ӛTD4%ٳq.ܴݛނߑ=?z?f s:
;
vo' !#2$:%C&>':(,) **+\,--.]/00-1112g222222322X221/10i0<00///g//.d..-_--,},6,++`++*o**)7)(a( ('F'&f&%d%$`$#L#""!  ( )YrH%\"`?
w;Q"%H&%uu.t$_j '8| $!!"/##$!%%N&&'-(()X*!++,Y--.@//s0	112233-44C555667l77K88%999-:y:: ;;;R;j;e;b;`;^;b;h;^;U;);::q::9q998I87U76O659544x32X21X10f0/q/.~..-,a,+$+*)[)(F('#'&%>%$#]#"6"!'! # CefONq}UICOwx$ik
A
q$W2	/Je	[z
\@GODv&LE;|CV h2](Q{hVsbs4Rl?u1th\]N[g4 jC&
 i'$Kc
2
=i
+
z	tWEM0m - i^E,K_t#Tu4 _=@|8'LoFxM#Y]&Kj.!g'*Q-^@ߥ
bݹ_I6{'$"
Ƚǝ|zwâ!_z{st_̸{ظ!uʹa*c,⽘Aq}v)ƊHǥ@ȘU˹a
ͯU΅'ЦтIԤ7՘ֶwK|<6n]
C!K#%'B*,7/135S78_:;<)>9?H@PAXBCCDUDDEEE2FkFpFuFFEDCBpA@>q=$<:987k6F5421Z0z/..|-,X,+*P*)(4(d'&%%$"$$$!$=$ $##M"<!+ FbX+gYdVZ>kva
B/
R	 x>?ULa4
	 

 

Bz7F9,*(u S"#%K'(*:,-)/01Q345G789:;<=`>>7?x???3@}@@A;A&AA@@m?>N>==`=$=<<Q<;r;;:M:99r979888R8
87>765655443'32J21y110#0//.-L-,,++*7*)F)((N'&%%q$#-#"! H p(SE8
T2N 2M"B+ g,2yj~^L	

rQ0H[_BSZoXBx$SelA *dAhy EFH1]3L 
5%
9



*i zQ(]@	P+9?ESbuyc^k݄gځ!ٍ
َ9ףֺfJ.#ԊKӢGҔ<ј.$ІN͙̇˘'ʵgȈȴ=z/37eƓƧƻƝ~R'8XcnP1ŊU;!Ĩąb5üÌ[ÿmd_Ŀ)tڼ.B)ര}Jͮ[I78986̡Ϡӟ8u grܗF01˔dғ?Ē͒	cy͔"\ЕUMė_2uQ$V`iٛUʜ E[,ŢY ڷoLǲ\2ڍܞ32_'z
	' !#$g&'()*+,.//000;0/a.2-+*))('8'y&A%
$z" (=x=ly
_0
Q	rkEZ6rPbt    I  Z_47~:XuXk%=jVO| ._	;
gm!"V$%')+-0H2J4N689;k<=>R@A=CDFDGHHGIIIJJJxJJKdKK.LLLLiLLKKJjJlJnJJJJhJ%JIuIIH2HGzGUG1GGFFF;FE5EDCCjBAlAA@@@T@??>5>=<j<;y;
;:8:9E98"8G7n6y54321150c/Y.Q-+*(M'%$"!+p3!g0
Sv

Z	<9g!x
uA~	8
*,
=iv c   %!D!d!!!!"""6"N"f"s""k"V"I"<"Q"f"""5#{#X#5#"
"1!W 3gshcPKb
fOnF:6aSb
S

	QD_,qs vKpl
]#"wS.WY"'GGq
EwO	'3?)j4dE""xJbb.,To]+cc:o	:1aQ;voL wܩBٜ\mհF҂Ѿd4Π͍
̧Aʙc.ɩIȓ>ǍLƥ`őTķĔqnl_S)ÉhFDBJSE7
©}wpu{>dċ
Ȋ ζ,բGVbba <>
n
Lh#? [#%(+-0246289M;<E>?@A5BBB@CChDD~EEEE"ECB@|>A<:-8S6;5#4d3291/v-+)&%$$$$$N$#"! lhc $1
h0rrbQ@~!!$IC|~%W
		7ET% cL8  ~)W"N{j 


ZD d"#]%&U()+-/1V34677^88'999S::^;;<*=6=B=<;:%:9<9S9j99:2:`:3::o98%8r7767n7 88888g7z654D4433333~3O32221r1;1;1;1n111?2v2222521(10/Q//..7.c-,+)
(g&%#"! J2
eI
	}* zcMk	JaxYAQDoG'l\K	t


W&^Erv?|"Gl|> M3\jR:73VxCgE7C;3^~s"T4IOPy
o
F L8( J|2bQA	SiotZ4-pH!2EY$DDKn{/r>JߑK߭Un܇ܦpUٸ؏e׎B՜ zָ֝O<քQח עB֍8 ՄANf$Ҭvҙ
т%ϤπKϥ2ΠmqʷIȔ?Vm5Ͼ:~ĸb/4FвYu
v߮3Tp/jΩ1bԦަŦY'ҥۥUߦ+dӧ6MYd{ aԪbī&(Q򮕯6ٰs9˵Qo P~ľ7ɮ˺|Vۺݰߤ",8)t;` 40Q*	~		J
{


a
		X'q
AASoieE&2_p>
P
Kl ! qe  3fiFkIOU	W
YRL
>1	-Bh/ !"$O%&'(x)N**+3,,h-
..j//00_11,2r222233K3|3333333a3322z2d2]2U2>2'22111g13100i0000//////o/?//......Y...--T--,i,+++**)7)([('\'&/&%$f$#T#"8"! B uk	nbztT9\{Y7t:r"U[UR !!7""#p##;$$$L%%%'&u&&&&y&U&1&&&%%j%#%$`$#c#""S! :GAlG9B8t1u%Fg?{/hE#R
}

?

(
	A<6!'D >d<	U{maCsZ'wP).2Kds{u`Kz{|wrAb6
] _Fj
HbjYsCSߛzYC-ޔg5ݼݯݡ݌xFܯ܎mO1۫ۀX/ڪUڞ;eؠ?nԃԚ,TѪq7З3φ;β΢ΡΡο	4RpϘPВMѪq5ӎ.Ԓԇgs3٪!ڴGRܹ!݋e!mߑߵ:gIrlfB zs`S:mz 	V p	
,
nm*&";UkB  #!!f""##{$%z%%&`&l&x&;&%%%$$##P#"k"!8! D f> ?>fL>07>hRKE~C
"R  6!z!!!!}!I!4! !!! o c@k> y/@zU#O}+SK  +!!o"!##$!%%=&&S''k((S)))$*V****+6++**t*W*:*)***))))	****))))s)h)])1))(a(('_'
'&^&
&%%P%"%$$t$4$####v#L###"""""""~"L""!!!!!!i!K!!   ? Cj^{WuSLb+1Iewxb
E

\
	~	=	d-(#|y	

);L^(


G4h8(#1
t_K^r?
0

`

?i 
	^	>1$InbWg!\2|"pEMTwY7w3mGt 5viR;1?lXNP}I8uhN!>ށX./1 ެW܉&nکo4yPؠX@վ:Զ*ӟҋтTϗ=͠]˟_ʒ/tțyW<!Ǧ1ǻ:ƹZĺzP&ûÏY#scRX^=2#OﾐH }qѺ1йp?ոG򷂷Rj[L3ѳM߲ܲ޲ֲN۳)}Ѵ).dƶ'NtݹEȺ	Jgݼn Y5~3B1qʲ/ͭ-Ю?ԟoH"ܼV߸`(j4.mao ^	
~H

+#ouT2u6"brH
v
>

tYOFTbjs
*
Q

W	Xi0;tcRA%	

u
:

 
H
|


Q.w`4
q4kO3# !!"#$%P&!''(=))*-++Y,,y--s..(/r///>0f000001H1y1111111111s1P1-1100]00/E/.q..-2-,,',+n++*]**)a)
)(i(%(''W'
'&t&%&%%A%$$^$
$#m##"t"
"!'! 4 AIB&]{J667AXtmD$

n
O
	A	[l.~M4oY)	
^
 'KNg<d	}Z2 _]`JP`O3 uju3t:irx~~~vmsyph#q]E.)#

y
*
EyK
 
&	Lq:GF-d GAG| \yV*y8Cj|ged~u>9DX"ad8 K^2-$5}6YVY%~:ߌf?޹ޗt@݈FݹmܷIpڬSپgؤ8OՅ!սG]z҃efγi	Ω7n˜g3ʵhɫɒy_F5#3D`}ɉɕUʽC8̨͖?ΪlE`զ`!'1D(Z_ V"	Ku-Z 0"F#\$@%$&&j''q((b))$*r***+++**-*))(('Z'	'&F&%W%$m$$#R##"""m"I"%"!!)! P K\9!	w-R^N8!5IJK,X-:t%iB
^
7
V
	s	 	|S '5c0#	y		S

u#
vfV9 !C""#I$$%%&&k'(()))*D*}**+Q+++V,,-@-{-----------p-J--,[,++9+**D*))m)+)((h(('~'.'&&\&&%%e%-%$$<$#n##""!G! q YU^8
QAe7|

h
;
n	JV $ Mbv^{X6b^(&B	8gqz6  CnE@Lq8n9	A	s	t	u			
I
g


~
]
=
			Fo^sD&T]	E m			nI$VK										
P



8
	N	C37L^v $2H]s,KD=JX4ZPLR	|8zRY/	!2C\utLq{N ޑ4ܱ.ڂ1yِ؀pՉ%tԷSҍ+Yl Д5Ί?ͥvF̮̣̗̓̊̂̕`= ˉP0ʹʈ6ɒ?ȗ:s
ǚ*ƽQĀzUDx)ۿ.=dŻDúb <DʷQuw6شP.ݳ Dg}T/ٶ5}Vù/Qͽ1ĪƖȂJϞљӔը׻ٮ۠c&w?C+W
 yd!	

>o{eA""Lzu(tZ@(seVNFHKJJ9'~7~V-*~hRC57:DP`qm3{xE{*se
`/F[(i&mno4^_	dnWBV*{P" h!9""#}$5%%&S'((E))\**s++v,,C---(.m../O///#0_00001;18151"11000}020//+/.u..-X-,,,,+y+$+*}***));)((T(	('l''&}&1&%%8%$$,$#}#%#"m""!H! u  )@|1c$-o"2^W;16J]D"
<
W	^ 
s
`
L
K
I
@
6
"

						

#
.
9
'



C
t

YL!
o


2H]&@KU^gghwKxL !!'.	

o
6





j(Z!




d

		K	9	'		
	Oa#mV?%8y?m
& ' F;{:hL;Yyo2>`u<[W~bG*
fH*~O u={Dy?;x@	v`Lt3O^"w?c-߷ߋ_I3&޲ޤޜޔޑގޅ}dK1ݼݱݳݵݾݷݰݷݾݽݼݯݢݔ݇zn]LA7+ܼ 'Q{ݘݶ!Tޑ<x߳Wo1+<PL	B#!?x6]"j f7	


k1d4]T\R2uU4AO't[XU;" "Mj&MLK:(%#.:.!<\tIu0JFS{Bj-o6h?,Nq3b8i|L$^,x5'wOy J p         !!!!!!!-!<!C!I!<!0!#!!!!    t J *  jF"wW7 OvmoDj	RZZZH{#K?=N(}.

i
L
	7	
kBh5	E b9M|x|# '5B+%."%\
   q  Uz5u<x,k?7c6
K0vS3n/A`AOh{4miJ%qQ*gJ7
wlޅޚݘ܌~ٜ4_֓/cԝ@ӳ|D҇IѦsU6!ЎZ"ϭo"΀+͏X!̑X˂9ʠtFɴx<ȧY
ǌb7
ƶƉa: źŕoS6%	&<RqŐŽ4MgƀƚƼ@gǍǗǡǸ0CVjȉȨC_|ɢ2Poʅʛ@_~˘˲
.U|̝̾C̀Cyμ`roMDӿ#ԇTc؊ٚ)ڸa
|6ޫf1n@2-39$kK)_.x4  =q'q,w	

i=

v*xT"]*/MV/m-k\*pDoT-Sx 7\,Ifs}zyx}xpgb]adp{~.DYn ; [ {      	!*!K!p!!!!H"""M####$2$`$$$=%%%%&%&-&5&K&b&&&'X'''''''(&(h((()))((({(}(~(l(Y()(''''j'N'1';'D'['q'\'F'&&g&$&&&&)&&%%.%$k$1$#####_#0#""*"!!d!b!`!W!O!   5e8} 
9G)Kck:	ApV~#YG

p:]
b
	r	!	R"a2cF)aA91,'_'	~AiI
 } - T
Ng-JOm+s~,x.x4^
ejB{>b2c9V,s3iD l:m*4na)v/e'r<J nA޷ޘyYI8@HQZ^aWN@159HWgwމޚޮ&Fe߃ߞ߹Dq#Ov?d0On$_*QxCj2h'd.6PY8"w3FmT>a{ iR]G oMH/l=A|
 ]  
cLah}~s		z
d

6>qvYERf\2(tK-VN,@DHR\w,Aj,GawyeM6,"%'*-%
]7xoeVG&hN#yU?)'&A\>]|_ )3-'8Jt#
 j6o5R6v?:/E~87WBC}	3

=

:d


		w	G		[#|9}<QN: + 3PyxEG\XEEw]t|3v!v bWV?\/\f9Nn#X?%k߇Aޮ`
޴at0۵=ڪY	ڹz:ؔZ׍Jּ֔tS4՘lJ)ԺԦԌrX?%Ӻӝ{Y8ҷҙwT!ѻцZ-
ЫЂYϳπ_= οΙrDͷ͎fI,̮̇_E*+<K[q̝̳̇$Qͭ1SΑcϞ+WЃвNђS҅ҷ:hӦ&gԝ8qի2rֲ'`ך^ء,vKډ\0ܨ݇Fޝ:ߛ|y_$:vY4&+*p\OF+ lH2MiL@>jF)[  zGzR0j@%
	y		F

wn

\7~nU0
m5`-N^w,#pR$i/n) ]   !.!V!q!!!!!">"c""""""#?#a#~######$%$7$I$[$m$$$$$$$$$$$%'%2%=%@%B%C%D%H%M%R%W%]%d%j%o%o%n%l%j%f%b%]%X%T%Q%F%<%+%%%$$$$$$$j$Q$9$!$$#####w#W#1##"""x"S"/""!!!c!9!!   ~ Z , m<d7W/\-pA{IvEn=sBX$V#h:	o<	yKJ}O`0e5

y
L

_.tD


Q
#
			c	3		\/V*k@pAS*g=rGxV-   z _ D )  rP1iM/|fP;$
}jVC0
kWG6$ kS=( gN<*	m^PE:1)  	#'*)(((%# !|n`N=*	vronnie`\XUX\eoy	)5EUh{-@Sfy
%>Oamz'2<FUes  .8CNXiz /=Rh/Gh*E]u-Hcs % C ] w        -Jax4Og5Ody	#(,4=KYiy#9CNQU]ew/9BBABCP\r	#///25;AP_gonnoqsux|~tj]QKFC@7. xaJ8%
ti]QMIMPTXSO@0%zupeZG4tX<lWB&
zjYG/          t i _ ] Z V Q H @ 5 *    {lT;'rU:eL2|cI.p_N@2'|tlcYQIA:62-)#p^L?1!t`K6kWD5%yoe[PG?2%	#-79<==@BEHIJGD=6302479875321,(%###%(''&%!	  	$-6?HQZgu$*/7@KV^fjoty	 '.6?LYft}!->Ocw 5JXenx
(5FWi{&6G[ow"2>IUar*D]w
%?Wo  2 H b |       .@Qbv&9MZgq{	'3@IR]is|*7CO[jy
+=P_nz"+6AHNPSSSTTX[]_ada_^\[Z]_]\ZWQKHEFGFD>7/' 

 	

"#$&(,/,)&$xog_XQG=5-!|sjaXNC8,!	xpg^WOH@<71+'$ zvrlf^UOH@70*#
	 

		

 zqgda_\]^[XSOKHEA<653.("                      x s n j e ` Z Q H D @ @ @ B C @ < 5 . &     }{{{|}|{zyyyyz|{{{}}xrqopqqqqqqqlhd`ZUTSTUX[]___\Z[\\]_abbegijnqtxy{}~}zyxrmifdbehhiijlnmkkjmpsvwwvtx{||{yvqlc[UNPRX]_a^\VPMJGDBACEEDBA@????@??<9:;;;?DFHJKLMRW_fmsy~~|yvtromlloqsvx{|}yuuuvxz||{}|zzzz{{{{{{|{{wtplifdb_]\\YUQNOPRUVWUSUVVVTRSTUVWYVTOKFA><9631/-*&%%#" 
 	"%&(-2588889632269;===?AAA@??@CGLQPPNKE?=;<<>           
      RSRC     [remap]

importer="wav"
type="AudioStreamWAV"
uid="uid://l6s7s8rybkse"
path="res://.godot/imported/o.wav-65369291777ab3a66543e83bb2042ead.sample"
              RSRC                    AudioStreamWAV                                                              resource_local_to_scene    resource_name    data    format 
   loop_mode    loop_begin 	   loop_end 	   mix_rate    stereo    tags    script           local://AudioStreamWAV_v60xc 8         AudioStreamWAV          Ȅ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         	 
  
 
                       
    ytojd]ULC<52..-.0241-!yj[[Z^blw~Z6!  j^QkvQ+
vdS8mT;s\E0e=p=TLD\uy}P"g5X,'!EimYH7-"
}
.Z +5,$ +S{?m3X_fM3'->KXOG=20-.-' 2C`}voaTF8hA&
~{xLxZk|
&Hfvje`myobTp?`	.:FZn8r?k
)7FZo0EB@@AYr#%&+/Nn:Vhz567658;CKWbp " ( -  
   $ F u       v t q j c [ R _ m     #3Le
&?GNNOJEFFXj)2:62DVm;\
K5b??@HQfz	0ea,:{	.	E	-					.	A	h					

)
*
+
<
M
b
v
\
A
		z	A	%						5	X	b	m	O	2				$	9	/	%	gik}	B	m	~				m	X	Z	]	j	x	h	Y	7		nzVNE8+	4^	8	Q	_	n	z								 
	

							
'
<
Q
W
]
l
z






f
C
&

									



%
+
2
R
s


OMJ

Z
i
x









|




	41.




9PhS>















p
f
\
e
m
|







(@WetojI)

j
3
9
@


%o,o
	

}[81)yC(


	



n
B



	


			k	<	$						"	0		qv{ob;
.Ys^IGDLSy	V				%
M
y




+U~?p
j





~
4

h


+	



h
6
			H		o2
=]VO/c^Y*H`(e)HgZND;;;BHazxv>{[:>A;5.>(`3+DDDh[Mts.AO\bh]SE73/49Qjj> 'Gp~sR>`zm^PA3bN9;>GPE9 v\_`n|>Ul	!.;@EP[kz

a5-&:Nf~0_}Z9{R)!000}A ZDtYR67f|oR5f^Vu2"j,:<>^~E					
 
4
>
G
$

	v	3	lU=:7\	E	W	h	S	?		tmfz+	c						m	3	[t\K:[|?(	f				Z	$		n6d		
 
$


H
v




'
	c	#	j		
6
h
i
k
E

		
	'k +S|)]^8RF:4/`	 	5	&		#	.	J	f	w		|	p	c	W	y			<


Au^'

S

					
Q






o
/
			h	\	P	Y	b	w						z	c	u						s	+	qdX|uM%!1?MZhntdT0~8(lUds{}n<
uL<-AUoc2z]YVzV/bea]v?y"DfR>og`cfB;DLT%gP8sqpsok>Xs`M"Fb_\M=n wO4),.
E1APQSduM|Y/(!U	
+Lo{v{}xj[F1$"@^l{peJ.	R 2E>8$[
%="8OeZO5 :EPE:Qi%^WQ2,T^xK.Kr
	'	D	:	0	TTe0	^#^}R S'-39?mKIFQ[QG &Jokf[Op SZ.^}siu{uT3]6V&pXQJRZneB'!6(ri_B%FgdD PnP3Qoy(?VJ}/x.&s*&"%             ` $ - y         5z?     M+Z]`A":Tm;nJ'A[w?      %^K"+=(.[tb5.QtsYnB[u?d2+%\R,vc[TD`|fQOMy  0qh`N<,/Clyi]RX^ Ei#S`&gf2f7sB&B:3
xL?coDVnJ6#! 9QX_!lpsM   fe2     x l z    6d2gpH\/(BFJ  ~ } |      > d'XaFw5?Ipw`J\nN//&xY%998;>FN7 	9\AkUn~}G{/%s[/p$gR<JXZ\3
kMMLE?/ 6Kj.xd~Si_?:`A"2C?<  mWu,!Cq(9(
.X
HlpUA.Hb4X8rXbl1H`{2tleTDa~o:Oc|
%@yiYYX:9/$
F	!):^vhjmt|pdUEJN^nv~`A&6#zNTZiwsn\J42FZmu}eM|rgH(~`B,|M7!z^7wG|]7f<V2
>Wn?2St^G0

4[2%'QvqU04[ck=("_31e <z%rO>vP&Ox*X-,z;|.p"cZR-=s$:PSW	   4}63 *T.@lP~S				I

LP\

 Is^JNR"PgVk-wHMPa:-iM[= Q > ,  4 r  !!G"n""""###2$m$y$$$$$%$%3%%$$$$%B%%%%%%/&|&&%'#'!'&&c&A&z&&&'&&&&&&&')'D'I'N'i''''''d'9'-''' '&~&&%%Q%X%`%N%;%$$$v$$$$%$$@$#m#	#""`"0"!!!I!  o ' iHa	[-S/4zZ/o$CK j"u z72j
H
q
+
	9	(
uRN9?W 2 C'|:[ma~F5W*wb;9lEJ
A}	`=dZYvDe-ލ;w	ݓܥ0Vٌ6؄!ؾ]ֿu]D<*ս9ն=ӯӡӢӣMpџUwјѡѧ#ўm^HϰaЪPJϚF HΕϡ-Ά̠[̞7͋kKfVE̤'G̗?
,̨$Gmͼ̡̉ruΜ΄?!HWlv΀΍Ξ*bzϒϴ/ЌвВ|gYKjЈЬвg)xѵQЎnF~"ΪkL-кJ?4^݆4*o-mqi5U)	
#{pc ="##T$$%&'(/)).)((x(A)*4+Z,,*-,h,,+,<,,,,d, ,++,B,g,.,+++R,,-.1////0E0012222]2&2C2^2232211?0f/.U.-b-,j,,++4+n*)~(P'l&%$%$A$#"!- deU#m%(6 uU5xFOXgv;)eR;p|Mbv8          !!$""v##d$w$$|$u$$$$$$$$$$$.%%8&&'''''%((5))*h++p,,,,,W,+,,++,E,,,5--h.Y/E041"22 3K3v33445|55554H433{21I100//.).-,M,+**h)(x('-'S&%$#1#r"! 7TFa
=kB>M1fis
$
 O


4
		K	q\aR a"~;a<)OH7(lVDEofiB:g;߲*jqۂ[ ڰn6ٵyU%حةئذحؗ؁d731cؘ>ٜ
ڈ	۴c0ݯ]\_t>
Yu)q P*Kn}3IOH@s2&DiE$'pL[jih5g2xݨQۚہ0ځ)ٟiؒeץaMՙճt5.7HYMWffز[;ۯ܄1޽E߃R>Zr
qYL&'M[O9&>h)sS.m9y9"ߙޢݛ!ܦ
l7٤؋ד
ր?ԩӔi-Ѕ2u"z~'7[LľKؽeؼ8Gۺ\YӸq8?Ե3{õѵֵE)ֳ
ó{;4d".z-&yYڱQɲ³ƶi㹯zr9ł>͞Aݎ{
FZ i8@G "|$	')O,/p1357:D<6>%@AAABAAAALAA@@s?>~>>==r=J=9=(===<n<;&;r:9<98?87@76V6555@66 7r7789999s9E9889877T6d54z3q2e1M0W/b.d-M,*)'[&$.#!L v;eJ
'
Zd( b"tj 	
	
c
%Lu[AB>0!!#$&(6*+:-.0x12[45689:B;^<=>@QAiBCwDsEAFGGYHHI!JJgKLLMMNNKOPPQ9RRS	TTUUVVWfWiWpW%WVvVVU~UBU	UT}T'TSeSRVRQQoPOO4NXM7LKINHFECtB@?D=p;975'4f20.-H+r)'%#"b 8mUX

5
x	fh<iTH=M`{-^_		w
N
Q1sA8?!#$%}')S+-0_23544g4445$6?7S8g9G:%;
<<>2?L@fAAzBBBmBNB*BB
B
BAA@?>=O=<w==>W?R?N?j>=q<[;;:;?;%;;T:9o8D7+654333333T322\100//.-,+*)('&%$#"P!SC+kK-Npr
"
	,a`^@.T {tCQ+Qb4RG	O~o$+KmQ+f߇#߾އQKE.ސ*L|ګOإ*Xj|ӑҦJiΕ΁7ZgtȈǜƋyT來(̹gMYeʯ1Kd#^ߦ&B<#+ѡZ¢֢T+;tϢ*'%䢣,ZãnݤYԥP,	#<N`TH=2Le	" ⽸p(n&ԒAܱ!NA l

KfZ"$&.()E+,O/13679;=@eBDEkFFFFFFF_FFEE}DC	C&BBAR@a?>l>>>?E?>	>~<:9&8t76F655g432222234333z44D558544X3L2A1/.-+):(&%$#"!% yZ;]9Ag
|	kL-{z,j{rF'fr}voC r].

86r"#%'U())*+,-5/u012C334B556l7+889-::5;;;;;;J;;:::::;g;;5<<=X=g=u=l=b===>N>m>>L>>v=<8<;;r:':999e9998r87876505433=2[1;0/-,+)(i&$$#! uIV>*	w5	E h;f#a
ix7',@kwhntApis|vx |*C<>		6


FK6

**Vi NtI@7"Gp
*9K]%n
d
"
.V~
F	x7 wSB2f|p >g#).3i]$y@e,B3%i._cN޶)c۞څIرuؙט֥5S]FҴ'њМ%ϭQʹs1̞M˥Jʋ&j0ȵȎf.Ǽǂo[[ZG3ƼPY<Ī|]oȾqFX@ҲԱְ?]|sbQq7AР_z8ȝGƜbܛNۚhuFCoٙəI+
☭y.˗̗ڗ<.,_Л6\-39ۥ n֮onԴUַ)ӾdZP_nG έ;Ѻ9ۓJߛ!1@N{t(pN-	
BJEAH !5#$]&()+;,3-+.7/B0B1B2!3 4p44$5h55555555555@54\433u21110//".?-|,+8+*C*)9)(!('7'&{&&&%%>%$$}$$#"P"!  6  w0XTb
@p;-XE
BzIs!vb  e!""#T$%%&I''(U)**+,~-e../00#11H22d33/4z444%5W5|555555p5N5
54e443B322d221Q10s00//m/8//.V.-o--,E,++L++*h**)S)((W((''s'@'&&>&%s%
%$0$#'#""!%! R z rE{dX:{DnN/ 7Or^noqj !3#$&N'({)d**K+i+++++++m+X+C+j+++b,,-.........-u-8-,,1,y+*)%)(;(('''~'M''&y&7&&%%:%$$v$>$$#####$I$$$$$$$@%%%%%%$~$#Q#"X"!r! ; t*Z|'>Q<I>&\Y
6
$




4H(
R
	r		i{[3yfW &ruY"k_w*_MT'[
b,yncpgFsNT2f {"A;Z]%Ipݥ9Vr؋ץEԇeѴp8Ύ/cʴiɵ_ȧ|e~ǗǛǦuD
ƽƮƿƠuƒŧj'
ÿÛbcdÖûùâææûøz@7/ÂrŐ(ƼPǯȢɔʫ˾̺ͷΑ`+ҫӀU֑U7ۓV Xn1`>@B`3oP ?f	 .
NplFe%  !"{#($$e%%I&&&'6'T'X'\'M'>'B'G'm''''u'3'&&k&4& &%T%$$W#"!U!  	5v5et0[r8Q@3*"v=GBj@0&=Tgx<p
Boxjp. H!!"w#V$,%%&v'(v((3)))`**D+++#,U,b,n,v,w,,,,,,,,u,=,,++P++**b**)q))(t(('i''&Q&%%B%$$D$##H#""9"!j!  ; ^Xu
K.HKQpQC6sH_q0u#oV

U

nMGAu4

~=m6{iL))<2&uB9rf
R
J
~%
!
	
	2;hH7%i7UX= Drr\/mK'd
[{Nf%md}d	NLKGp ޑ#ݰJۆ&Zَ-mu%|&q Ԇ=ӡD҉"ҹTЦWϚ4Ϸ.Λ͊̪Jʘ3`Ș6ǗLǥD_tĔ"ù>4u~bO`w*p}D
㲴W,⯡p?mۭcL5߬r.J:)'*gVǮ߮=ïH°vXʲ<cɴRݵ}F߸x)ں5ܼ}1澦h%JãRz7̇LhЮЗхҦֈN٤|iW?(NABLJHLSZa{ FYB1	k
$z

BDpE\+hJ.iRV5c /Mdw\?y > l      (!M!t!!!!!2"i"x"""""#I#y####$4$\$$$$$$$%'%]%%%%%%&&7&Z&&&&0'd''',(x((()/)B)m))).***+8+h+++3,|,,,,--e--.d....../;/e//////////00////////y/m/d/`/\/F/4/	/........u.6.---|-r-n-k-L-/--,,,h,>,,++X+,+***?*))d)')((y(?((''e'>')''&&&'O''
(w(()0)^))8**+,,,&-!--,-9-g----^--,a,1,,++++N++*t*2*)))_)>)((<(''r&&%%%%%%%r%*%$$$%b%%%%%o%"%$$e$b$_$d$g$E$"$##~#T#Y#_#t##[#,#"`"!!>!  y  AJ<hjRIR\t A'},Eg2

R

i/"
3
	:	v=& EZ<G 6 1_Q9G t'DAP M6l7f!DU}"lSdQTGFt(p#Z^+4EHQ@ݬ܀{ڭIxؤ@֚I՟EԫaԿe	Ӯq3Ѳ}#kϥ}%΍YaiΈζμΦΘΊΡβLπϠ MДZ2Ҡ9WӾ%Դ9Փ,NpFriٷJڒ_fjH޲ߏ-a0]NIp'A3K@%v1*4s;
c 4,4o@5		 

oD
l


>D$Df@S~/Xw rBYn)HcL~IwEs!M~|{}V1\1Nk1Pq"Q| F [ p     !F!s!!!!!!!!
"/"I"c"a"`"`"_"q"""""""""#-#M#_#q#i#_#I#2##""""u"e"T"8""!!k!1!!    m D  s:YgS-Zo=
l],Xq4f,4l10w
D=
j

	[+?C`$i  . |R@-r
[Ffi>3Y5 =4}"$QV=cݠFܜ:\`r٣Bm֌ֲPԚDӤGwҏeχ;yά\̂D̺l
˲Y ʺ|U/	Ȣf#ǠiK2
ƲƥƛƓƌmU=#ũŎiF'7YuŏŝūŽ
/XwƕơƱƶƼ!Wǒ9cȆȟȸ3nɳBʀʰ,o˼ẺM͐NΌ%wz;њOҩUӯ	qKվ8ַ+נ
؀نڮ6۾9ܲ8ݿQx
V*7o-5JdC1"GGT6!5NL*|5kb/  -ZrM'EIj		M

%{S

u*sj/Du	7,;v^E-'s   ^   v J!""##"""l##$%&&z&c&5&&)&O&&w'(((('('t'2'x''R((2))Z),)((('))*c++++`+****/+i+++}+-+**s***+k++++++s+`+K+o+++++d++*x*N*z***#+9+S+A+.++
+++/+<+4+-+**{*+*))x)T)X)])q))))g)J)))))()#)$)')((@(''1' '&&&&k&-&%%W%1%%%%"%+%%$$_$6$$$#####7#""3""!!!!\!!!  h ;  PCp1z7h(]+v0ZXc0]PO57;;

T

q&\

`
%
		U		68QJTCMD  ) iP_\3Sh[MHt0e!Bw;`1n2-6xCx?G^,}G!e8	qP,[3`?qT)c2hJ, ߮ߙ߂hb[^_TI-#,%'5Ni߅ߡ߫߶߿"Bd~1iCt,RD3%Am+\p#Ms	.QuL|K5Fq%}G{[p>nF6x2sb<jQ>=!ZG:{*w()b[f' s   1f0N{9NO
NY	M				:
u

Z6g
P



:gQMd}P$@]	/Ljr|sims (9MbxvrnjfffYM>/4:K[VP6mR9tM-eR?3'iJ*a8[



~
r
h
A

xdP:$
}L


{
n
_
P

		j	A			qN,[3gN8}XI7.%q_M>2	hG&t[9 gD%       i O 5 $     mL,~l___ef\S= vgM3}zvtniYH4 }lZJ<3*%   ,7<;97:9BLUairu} 	-8DMYfs~/9CF?:3/"

!%)o_WQLGFDB?8.$yvtttsqojfaXK:)	~k`TMD=5( &689." &)+,-16@JXchmhbSD8.*'(+18>BEHMOQT\dks}~ztvxzyuqkc]WRNRVQNA3 

*<KS\^][Zgv%3?Qbq~{(>FNKGLQi':Up %3BSdr
#4FS_jt  ) B [ u          9Nbglmo{	
+>PYc`^_ap	*:EPV[bk|2EWZ^[X[^iw ,9<>@CP\o&)/5;HVj~'3?DHGEGINY]ddcZSE63//0462.-,04:A<7"
-5=;94048DO[how{sgZL=1%}dK3$zpfa]VOC82+/5=FKNF>5)
ukaVK;-
 wcNA4(p[<~jXF<3(
       ~ r b R > *   ~wl`XPKD?:4-& wj\NA6-$
vmdYNB6.&!{skbYNF=4,$ztliffgkoty|"'-39DO[hmstuz~	 (1@O\hr| .;GPXhy/@O\iz
     " + 4 ; H V g w          3Kc{8Qh}#0=AFPYhw#28>1$ 1Nl-=Tjqz|}}sjaZOD;3.*& '->NV]WSOLLLNORTWZ^`eiotvyurpnorw{}vy||rh\PH?:50*#znbWMD;2+% 
wlaQB1!~tj`VK?3*#{mb[UOHEB<6-$             { m ` W N F = 4 + "    wmd^ZSKC;5/("	}tnhaYVSSSTURNKHD@;50*#

 



	  	


	 "'.5AMU\afgigeikostuwyvtqomlllmokgec\VRNLJJJIHHIJKMNOOOMPRSSSSQOONLJIHHHHHHHFCCCDEGHEA=84100/.+'&%#!!"#"##%&$"#$+17>BGJKIF@:::99;=;99:;=@BGLLLLKIGGGFDCCGJJJJJKMPSUWXYWTRPONLKORTWXZ]`abccefjnty}!"#%'(*)')+-/5:=@CEFGJLNPRTTSSSRQONQTX[`egiloprrrrrtwxz}         
 
                
             	 	 	                                                         $ % & $ "      # $ & # ! # % $ # % ' #            
    
       	      }z|~~{wvuwy{|~~|||{xuvwy{|}~~|xz|}}{yyx{~zxxy{~}~~|z{|||}~~  
 
                 ! # $ % & & ' ) * , . 0 2 4 8 ; ? B D F E D D D H K I H E C C B B C E G I K M N T Y ] a d g j l m o o o m k m n o p o n m l n o q s t t t u v v v v v u u t t t v x { ~ } | { { y x y z | ~ } | } } | z y y v s r q o m n n l k k l i g e c c b a ` ^ \ Z Y U Q Q P M I F C ? < ; ; = ? B F L S W [ ] ^ _ ` a a c d f g h i j l n p l i j l m n m l o r s t t u v v v v w w x y z z { | { { z y z { { { y v s q o m k i g f g h f c ^ Y U Q M H F C B @ > < ? B = 9 4 / , ( % "            
 
 
   
 	 
 
 	                                        }||~                                                                                         	 	 	 	 	 	 	 	 	 	 	 	 
 
 
 
      
 
      
 
 
 
       
 
 
 
 
   
 
 
 
 
  
 
                         
 
 
 
           
 
 
   
 
 
 
 
 
 
            
    
                 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 	 	 	                                                                                                                                                                               
      RSRC     [remap]

importer="wav"
type="AudioStreamWAV"
uid="uid://pfmo1yjbhw37"
path="res://.godot/imported/p.wav-b48e97cd7b5a09d7e704b5c550612779.sample"
              RSRC                    AudioStreamWAV                                                              resource_local_to_scene    resource_name    data    format 
   loop_mode    loop_begin 	   loop_end 	   mix_rate    stereo    tags    script           local://AudioStreamWAV_pgjpn 8         AudioStreamWAV          Vi                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            	  
 
  
   * 8 I M Q M I N R l         1m*Py
I{](fLIFno F  $  #T) N N  {6Q. YfF.k}P3
LIEij!Bc-y ? 
  / QE*:d\S	F&XhK1 |  ] 3H]  TD\bQ$
S{Wh>
 " > l$j  g Fc zl 9J @ jLNM \  #*7zA	`t]
?E--| 6k    i S< E.<E""a,\1U5QrRTCX%$jdEj/%j#UZB<7WNMS7kd'{SWOG*>7U 'O#:5m~[8.#0G*[ A	b8?F

Y		z
r
([x
\x

vl.lD:~:L"T-km]MN9>C!!!e	
%
i
RpY#b	Id
%	-
v

G
QZ iUA`7K]p~K9i]8.|  h8fJ
%



<	5		7
)

|	L_"1v% j   ^hSYK@!tvy# ?~rQr~Fm  ]  9uLia[UB.BWC0H`;lrV$f ]wJ6eu     _o^Lg|h?=<C$*01 s)lT<Ms6| a m  %	_7 , >hR<v/:t'
a)9is7/tr#)
zskmo{P8BRa%:WYzl"xhjDAy B5>x< DYoTi;AGs8B"7p|M  P l`9v  1yd|>kUlP4Mfh M{M* [dw up7 zFI`<MZ    L| b      ? zI A	 d  #x K 	 k  I5=qdD			`	9		1	Q			>

Q

t
	 	taONMP=7&NXf~_N<h8v}bXjkz|}J l?X&@vaK% 4 q          hknjmS9?<k
 - L Q W ? ' }cM(	pD" X	s+hS'(3nG{,s	i	U~0 o  M
1X <ewg8qG~bXN:*   T & nZ?O^q|qes > z   !4Kd@aznqm%B=9qeCKtyggfv}mt{yG}nsyzzqjd%Q} Mx)=PwA1Kdu~m]:}U-mN(o:gN6u*       -Syl_%  y   
fR"',|:&.?S&P-HbQ?	_F,.0-+
TnAnU8'#4Lf{&Vw)rxlllr}kZ#~InI$*  c G * 	 GqcUK?xk[JEBLUbs~/g:_|oantO#*;G2 8c V   5o#Ccvz}|pejjt~}y^CvcRW\PJ4               { r l {     !8PhzsqnbU0      w ] H 3 + " / = P b q    | r _ N 9 $ 
 eWDHKEA%

!-96221AOm
 + R {        { w           0]{kYSMH>+
 	-NhnXD'-3Z}	 N|!Rj
{O*d&mJ*    V &  uCvi]ppI"! DqCxD	f:2CXeq(877301:L^z  . ? L \ l |          
&A`~@a{ywZ7/2;&iP62.*!  u  [gE[%`2yU4pRH>[z6Mghi^MA571<GPV?'|zz{k[J@457=ECA9259J[{
'9f0\r{xt,27(pS(eG0tV9)dUGFECC'
d,qcUi
 @bt.Pq5Tl{hUNGPZm4J`hmorwuxz D^wtdWK?3!'=DKC9%v`J:(
w]: 0;CMVj
(,0'0F_wld]elt}wpihfhihg^S@.}_@*	 [4~^J4.'"	g\SW\YXPI>3,&$2FZclnpz%Ko=o*Eg+q(<Qf@u)Qr>v E u    
>q 'N@c*_(_U>Yu9y%	i						
@



:c Lx3
j










2F[eosyAh+28?EMX`gp}|Z@'&%,2(udU:}gP@-!





r
Z
C
2
!

o[9|cE#

x
D

				o	J	%	x6c?@h(b*[l$zE
  J U XIi^[
}7n#(u*\F:?l)PNR
8P{9c|2Ze0^)lB[ ~K~T-^0~bF*߲߂Q ޞyS,ݛtK"ܪ܁Z/	۾ۘf4ڔ^4پ٦ٍY#ث؃YB+׈R֛քmYG)իՑՅzuqvwqj_QQRUXWV`jtՐբ4\օֶ6Z{׳9؈,ق.څ@ۣ^ܶZ9~X2&>=LIjn^%;	,XCb 9"#i%&Y()
+P,-.
0G1234
6!778o9::;R<==f>>$?T????@[@@@@@@@@@@AA"A AA@@@b@C@#@(@-@D@Z@M@A@??,?>>V>S>Q>I>@>>=`=<<<;;[;7;;;::B:99C988m80877776O65M54I43?322h10/E/.-G-,,Q+*)(*(V'&%*%$#l#"^"!+! u`l<e.qY@FL~)S| vB*/i9   B!!!;"i"""""""##(#'#&###"""""""""w"\"?")""!!!~!]!<!/!#!!!    b ;   D j     "!_!!
"h""#i###5$x$$$$%E%o%%%%%%%%%%%%b%%$y$!$#l##"D"!k!   /,lht"s<4Z
6
1E
Y
	j	"_:54?T ] R4g\C,s(b0uB:Lc?~C 60߫|O3 5eߕSA`ivY/2Y!IDLxx
md;!b4Rt-U~%Da~>o$neNmj&A[ht&:JE<)
	#/7<;92,!
 Qȅǿ?Ň6Ýyu}
6¹OҸUط[f1Iײdz+4ĭUA櫄"A9-RVr)ߤOӣj?"55988OgģΣ"1գ9o^$ꡒ:ϠfpZԝxlҙ: טkqw`iК6>㜉Y&تT K6ơ
̈́n+ޅO
QO}M7h!#~%2'([*+6-./02$3455I66#7]7777^7(76S655Q432I21Y100>0///u/c/[/S/y//0c001"14100f00'0-0011O22[3333333w3T3F333322i211100/>/.Z.-\-,Y,+&+t*X)<(&1%t#!?eO[X,

		6fU0p-/YE"O	

GaP !#%'*,6/1P468:<>K@AFCD+FGH1JpKLMNOKPQQ/RRR2SkSSSSSSSSqSSR]RQnQPmPOO.ONNCNMMMLLVKJII@HtGFE=EDCCCBBpA@Y@?`?>}>>=1=<T<;X;::c988V76544210J/-,^+
*(w''&$d#!J `lL;)	/Y	L :)D`k]XQw p?x0Cu "v_	
.
=l0O@1> 1!!<"""#M#n#####$-$M$W$b$S$E$$#####l#M##""z"U"0""!!_!7!!
!!.!P!~!!!"O""""'#V####$($N$f$~$$$$$$$$$?$##8#""y"H""!Q! G )"E_QV#~#r=`N

O

g	}U6wF W|)b34z)W#[.eQwg.%AY=\߾<޺XܠJzێ"ڶUأRן={ֹXԢIӘ@ғ&ҹ+ѝe-΋8̇LɂȩJzí6Oh yѹLZhqz˲
O֯]¬TC˧RmkbLV례^<m.\Ţ죙F Gէ:a1h`±$۴.ʻ`¾U̎ wGp ElS ~.yIZX!)$&)+./1?346q789: <0=A>??y@
A\AAA)BRB}BDBBrA@:@? ?>>=<;,;c:9987776m6+6555S5544R443_32Y2110//R//.m..j-,+*)(('B&k%$#"!!> M\ywR^lWC*K

$	}bF6 ? >#
'4?b2  ZM~	x
mO-
zXM?2!E S!~"#$%&}'k(Y)Z*Z+Q,H-#../0H1223c40556=778F99:g;<<H==W>>?m?? @@@iAADBBBBBBBfB8BBAA-A@1@?>O>=<<J;}:988S7x6543210//.,+*)('&%$$%#D"S!b ip#\!aH
<
g
	(	R
6Wx <|(YS/_o$o$a7X!N| :m	'0	;
AIn

+uTRn'#S	TE ZEb
!
x5
l	
x`YhEy# U  u`K<;WWH,|(ha\E/13BQfzڜپ,׉`q	Դ_Ӹ{>$
ѹіraOZerхыѕџѻ.15ћFЎIφϬv9̠qHɵ"Ȑ[ƭRĥ
taRοJ꾉K
ٽq=	ռyjgczǼϼؼǼnX1	û}#ɺi
]򸈸tͶ&zδn>DJ-ө̨ƧܦFyec!𙍙*%3G$dj]򜇝'ƞYퟂ֡}Q%بnQwޮCgM3.CQ`hüm(ʅKv; 	G{ݠGow-o@"$') ,z.025&719 ;=>b@AfCD<FGHIJ+KKKLrLL5MM_M6MkLKJIH
H$G;F!EDBA@Y?><F;9286T5421Q0/-,++u*)K)('"'&%%c%I%/%$t$##}"!!%!   S  RgZY{*|/sYV$
j
+k
		mr
5p7	

>
"s8v) !#w%X'9)+,.0g214579:<=>b@AB DEEFVG
HHICJJLKKKKdK#KJrJIIHGHGFEDCBA@?>=<;:9~8v7n65432210/.-L,z+*"*)(E('&&N%$#"0"k! IoR=m[

	=Wqv 2iCol? 
<}y

 tCWw 5"$%(,*;,I./J102334568>9::=;;;;;	<8<e<:<<;e; ;:-:9J98y8
877/6[5_4c32211:10`0/!/h.-X--,V,++++*?*))(''o''''''^'&D&%J%%$]$$w#"C"!! 
 s}bG`vCp!+

	 
yLh U?CZ%" %(Fdw'^1	}S8P&fBoZ!	}[wcP0lK*
HmejbW]j^RU\gre]5
́@ ǱƁP²eż߻G5c۵""S9屯~w}1"!&};὆0ܿ{i$àj.Ƭe&ʫ˘̅n=
еѐҜӧxaxARsI>1d\ X	
'\(<!"2$%
'i()*+,-.L/002111B22222Y22111W1+1000/.V.-7-,,M+*)('*'l&%%i$#c#"n"!c! Y ~6k
4z1Z IwV63g Y5tA??'~3

\



5
l


,Q>[:JQb I 9!!"A##$4%%l& ''(()))A***++T++++++++++++a+++**o*+*))W)
)(k(('';'&&k&%&%x%%$T$##W#
#""C"!!b!! u / We
]]a	Q8s
Dx3FJF:.3P

j
4

aaXs
8
N
g




Q!gYM(Kn{W?(FibdOK
R
k0

x
$
	B	,]^dVo3Z   1\Ya=M4(eu
g^Q@pf&k/t.3U	rSo	޳fkܨBdَ([zכ)ּSԊԱ6ӻBcРLσH΅>ͨr;̰zEˢvWAʶs%ɎG>ǠHƊ&ƵC_Àà$¦,?ͿOѾDaۺTҹSoM𶍶)ŵbôDl"㲦W< ٱe@ ΰİ°°~WB+?Sm\ͱM~0k0{ڴ:Oq|!Dٽr6Uz!ÕW ƼǇIʲˤ͙̑ΟϩЭѭҭ\عzTcUu 5c$IR7	u
X
8@y'C_40 t!S"##G$$
%P%%%%%%%%%%&%%%%%%	&4&=&=&%%j%%$$$u$J$$##A##"""""""q"+"!![!<! !4!H!n!!!!!i!6!!   
!!!4!4!4!,!$!!    j + vk~ 	 ! = p    
!!F!h!!!O""" #^###R$$%z%%0&&&6'''S(()Z))*a**+h++,o,,1---#.,.6.)....0.F.^.v.....~.j.@..--------_-=--,,,t,B,,++b+A+!+
+****w*E**))))v)^)F)/)))(((((((({(S('(''''`'=''&&&W&"&%%%Z%,%$$$>$##h#+#"""q"3"!!m!3!  !n!!"q#F$%%&z&&'(Y)/**-+u++,L,,---.---H-<-0-Q-s----.3.a.z......p.a..-@-,	,l++**5*)(''H&%$$F#o"! IyGIY|vD1 rbj<VvjK+@vG'Q;0Y

l<
^
		 	kG# m_Q9"c m"le  ; 7V!CZSJibn	4<2=c99yW&h:
^2Dz
/QijP:Du(߽Ek	ݶc
ܶ??ڵE~'׃.{Ֆ{`J4'ԾԝԌ{|~ԋԘԦԴԻԫԑԁp{ԆԒԝԬԻ#6Jaxա	 6@KMOW`di]PNQTXVTTTr֏<Rh׏׶eح=xٴCpڥYے&Pz!ݹPj&oXK>%
Bq 		
J

cDb3i"EPZl~&Cagmrx}~zxw'Tw7Tbpppuz,TzdK2+#$8i"bN4X6a " 0 A Q m       !!!          ~ ` A +  UzQ-
hG-
&332" 
kK+
+I6$ SiNS rn{j9
&<-y,>gGXS.o&l+,
5


"
	n		q.fj OZ.Q 4ZBo\I;-cDYr?ssY]P	jj4LWZ.dT
ߋ;ޅ ޻UܟZە?ڄ z=شiء.׺EdԔ0dҖ/mv6Ϻ}D
ΦzO2ͣvJ̠gD!˲ˌfE%ʼʞʀfM;*ɻɀFɾȉT&Ƕt"-ţaĚR
|:{^L:"	tfedq~ @OÎKĎ6UtŔų ;WƑ,BWgvǣiȴ,YTOONf~ɶ/pʥ,Sz˶J̣:wʹBΤrSGLXbgaH״#ؒٌڊY۪Uܮ"ݖޤHߵeJ(	dnsyL (/Xw+ V	
#kqnX'r8,-?n#saw{b7~ Y          %!}!!"B"\"u"""=###Z$$$$$$$$$$$$ %$$$$$$$$0%g%%%%%&>&&&'H'r'''''''''''(+(E(H(K([(m((((()")+)2)=)G)Q)Y)t))));*v****+2+H+k+++++++++++r+l+f+W+K+;++++++* + +++ +,+1+7+,+!++++$+/+:+4+/++++*+#+B+_+++:,,1--+.......B//10\00;0/h/......z.-o-,B,+++++ ,+++~+H++**O**)))(<('''T'&'&s&%W%$8$##A#""O""!!Y!/!!  u :  =t>^ pwe6{@gDh4%p1y6E[>!cC#^*c1

(
V
J
		2	KcAriH(  F  LJD6G3OcH'|T-be)Lo&qb\=\qt+M{8V;!R&lI$l?]qv/m5Q+~M߰{X4޽ޗnF=9RkއޡޢޣޗޏޛާIߊߣ߽ߜzU0ARߗEEF-,uqpQ2BV~[C*/,GaxwiG%.TynbZfJjKNX\:UA	l5|M5-mGb6,l"d'b (k,Hq-		g

J!@

Zn#Iz
G	F9X3	W-vn:K[YWhv	CilP<)8Fdwm[mJ'27J\PCqaXN9% eH6%mC[$~>k"nJ'qQ,~V=%]
o"


h
6

m>	

p
(
	|		3U0k3pJ` d yK~1Z?@)^Ogg
Wct&Ah9:3Ms'13Lqz)j+r6b0Y&y`:ߩߏ߃wgXE1ާވiI(ݗpM*ܻܚxR,ۯہQ&گڎkH(ٷ٦ٖwW:&0B^٠ٳ8\ڥ	+Cbۃۤ۶Agܑܲ'18?I[p݅ݜݷ&?Qg|ޔީ޽1^ߊ߶ (19B\r,Sx	(Bb *MqRIP
WFxRCH!k2r>y	7o=:9W
G6k&pNd
cTa)j'j4s.r ]   5z9=@Hw5i	p		G


Y e
]

o!KpU>FxA}
D|Jy+sO~]%Hl!Ip3St(3>N^q
,F`ntwyypX?7GVY_hrkG'!!/73.vo]L=*_4bG3|iUK<(m8mM/{V1h@]8g?i*c!s@e<|S'


R

V$Q


n
F

		y	4	uCq4~@	k@QqAvAX,   w E  t>
|IT.xO'wW6g4 bF(	qQ0a:jI(s]F/o[I7!vkZJ8%teWI=1voiiims|'7>GJMQT[binkibZSKQWblrwxy}.<ELSY_dlt~ 3DS]fu	 =Yv*Ln
":Nb(Uz
2a$U| 2E`{;Vz)Ii0Om6b ! 5 X y         
8Vs
%8KQW^eu"*5@Rd



xk^N>.	}p_O@1"
 uh[J:'            } i V D 2    ~{vphaZRF:+uj_WNC8-"vh[L=0#	o]H4!}rg[OD9+
{ukbYPKFB?;86667779:5/!	$-5@JS]chs$(,/269=AJT^iy -9FPW^bdjox !&+19<?BFKPW`o~
1DWiz(/5;BHMQUX\abfgilq|                             
  # / 7 = E N Z d o y               
 /?Rew%1<EMQVVUVW`hqz{tsrnjhga\SJFCGKJHD?70*$'*,.+( 
 
	wndZPJC>84/)#                                                                       p b V K I F G H C ? = < 9 4 0 , )            
      RSRC     [remap]

importer="wav"
type="AudioStreamWAV"
uid="uid://dag8w8k5evnyg"
path="res://.godot/imported/q.wav-04ae8eca1d9ccedfde31530580f40250.sample"
             RSRC                    AudioStreamWAV                                                              resource_local_to_scene    resource_name    data    format 
   loop_mode    loop_begin 	   loop_end 	   mix_rate    stereo    tags    script           local://AudioStreamWAV_cibq1 8         AudioStreamWAV          4                                                                                                                                                                                                                                                                                                                                                                                                    
           # & ( + . 0 3 6 : = ? B E H J M P S V Y \ _ b e g j n q t w z | ~                                                                                                                            { v q i a [ T N H B ; 6 1 (       }wog_XOF>5+!uj_TF8, zrg\RHC>:5-&{tojbYQIA863-&
 $&)19?EMT[agnpr{$.9BKWcr,:GT`l}&6FUct  $ 5 F [ p      .AUk +?Vm/DYq+>Qd|	1FZn3GVdv&7HXh}"0=HS^js| 					%	+	.	1	6	:	>	B	F	J	I	G	E	C	C	C	A	?	<	9	5	1	,	&	#						
		tf\QI@4'zm]M>.n^N=,{jYE0|gR>+ {eQ=+}fQ=)oXA*     f N 6  	 dH1w\C*zaE(nT;#uX< nT:!pV=&kR6waK3q[E2o_PB3$|m`RC4% wj]K:,
xoe]UH:' %8Nd%DgBe#Lw<p 0c	E5r>fUb L   eMA?EN\t		,

Mf|
 '#c5J;H~
+Kfz]@#wJk:	p?g/Oq8Td&j*bB

e

~-0

-
	}	$	s\D-u]NG  A AY~7`PWo3RMLS!b2q@P Z(f8O_1xJg:
X)tD[0	_1b=~V0
eAz^C'sbQF;1'
%9MjKv'jUU} "MyT`L	T!b4
\ .>a.		
0s	

,AKD$?,wO1w4mKJqDs
E}jQ9!	HCWI/w[,b#Ig
B
,1

Q

		L	
	d.xR,&4H\v?h-	g			#
f


/m&a
L


R c ]F|Ce
-MkHs5K`iqrt/Yr}tj^R@.	~]-+r,Y5ho
]
Y]
U
	?	cRH_/e  > y`w6Cg>jEpG+c>~a:b/vM#]=kJ-lL- wtqombWG8+zkP4^?!iBrM.m@sO*oN.fG)tT6kM1~_:oM*hO6"nV=-)07CO[f|!>[w.NsCo2g9yCfQTxS:&nm +)'1AOSD&  znE{HyE	z		<


T	h-


Vw**@_XD g7|Kv)C]oyk^O@+wOX#Z!o4Fg/|?](\*^,k>


m
D

j9pJ#



_
6

				d	E	*		sU8o^MD;9754.) '+.01000000+%$#
 ~nZE/lU>'{_B'
uU6tT4dF'    w [ ?    |[;"	yY7jO3|cM6 
zfSB1#wohaYQH?7/+&!!#$%(+/37;<===<:62/,)& |oaTE9,~reVH:,xog^VNF>4)|hS>*tY< y`F,lV@*vbSC8,"}rh`XSMGA:3' rcUF8, }n`QB4"t_J2fC\1d-U!E	Qb)E	Nm?zEzS,f8jR6ߦߌr[E1޾ޥތs\E=52.-,!ݶݳݰݱݲݯݭݩݤݝݕݖݘݦݴ4Ifރީ3lߥ.{gl1{z9vrbKQl.%y'@Q  8rF~Ip	 

,@

ScleJ'wZ8
o).5-y2k3e;Zys[<lGu5i"Mfof^[O6w\ NTY	
a

s)[

J

	~	E		|Q'V2
p\I:+ 
 '2=JVk6Ts:[{	/	T	y				"
K
t




7\
#3CO[jxmZG0{L


Z
#
		r	/	[`
_kfWJH  D .ws&4FS[z/FESr&Hby,W{1UJ^'Pd>`?m\L;* 
	%$###$%*08AFJMPV]bhs}   uaN:&~fL2gJ4
yk_S>*$,3BQh~	0Wx@o
H(|mi=590/lmhg(Nn 5d-lB	

M
d%XFJ7|Ov  !!!""#y##a$$:%% &b&&#'''?(((<))))*t**+G+++,?,r,,,-7-i----$.B.`.|......///!/////......o.Q.(. .--q-=--,~,/,++0+*x**)N)(y(	('$'&:&%L%$[$#i#"n"!g! ^ ]ev )GuVKL\SyN"x[D,	(:Mcy8Ww(PwDpDl Lx%Mv
5\9Sl!-9AHKOOPIC7+xY8Z)GYbD{>F?x4v>[#w=

k
:
	
s>@

S

		i	)	cIS
~5RBSg,   r L %  eK1xk^L;"	s?n7E_h_N*^%X2m
D|K+l
O(j
N8w=m,Pmߒލݒܘۑ~aF׾5֭&աԜӗҌшЕϬ9Xz̢<tʷ[ɽt*ǙQ
~Hŷŉ[)ĘwU:ùãÎyqinsÄÕßéçäçê']đM~UƩsU<ɬʛ˰F̑=ΗFесN$ռ֬ל؛ٚڙۙܧݵ)Vx
8~^(cW.w CUfv	

_;k%z('r$mHv(^~&''!
	&,2.*!hBL88g;HH_
C
	=| Q I >Q*(9VWEk^Q\f1O{
=pC
XGjXC#s |9 j  ,G^)Q  xf		I

*
q

Y7k;](E ]aCF2`2M`t{}wi[C,R q9T<[SXtGs\E7)$0<BIMP`p~cI0Z1e/Cm

3
dc.


n
E

				s	\	N	@	;	6	;	@	I	S	b	r					$
Q
|



0Qq8NdtpL(i+

R
		T	N#AOTVX\ S A8<J\iqz$9Tq+Oh{2-
|cN5
vCm1HޡWܴ|A٨vKֺ-ՠԕӃҁѐЬ<a͘:̗CˣWʂ@ɣyP&ȤwT2 
	 $BpȞ0Tyɲ1ws%~>ͧΊϒ мXё7ӎ?ջփKڽ!:SX]V3(K q	7<?W:Yq !"#${%m&_'8())t*++,z,,S--8...E///040f00001L1|11111122%252F2b22222
3@3r3333%4N4x4444	5#5<5O5c5j5r5l5f5T5B515 555444r4,43332@21K10-0/.K.-,%,d+*)")[('&%3%g$#"!!3 Tn	>`~XPo
V Vr:&Fg)Ge3c;k.Pr9b7i#e#^2g
F7v@TYEz1`  S    !8!^!z!!!!!!!! " "!!!!!!!!j!R!3!!   J  RKp9x;C>FYlnU8:_K

I
j~2

w
C

				Z	3	
	hCZ(D|4]
Z:q E u:/I	T ztnpq{;w5zDTT 4 W q        } j J * :.l2MQDEHJPKHRn4y t(Kz8H
] e$]9!Nh{f4Pި XܰQڔZלSԈӽ;сaε]̱_ʾɈoƀƛ#řĔùZ6=뿦a'c7ͽZ#뼴}N ׻eF-ȺmT:4/4951 
">l̺7o+rʼ#{
Väk/ǣȍwvu͚̇θRԇ&؋`?߬#%>R_|Ez7G4S	O
zJqG2(q6Piuztngjlv);GSg{pV/p6dWjHN7Nerzug
YPF
=	51,'" +DoV
rj0E]6  Am:s$`OEpM-Z*Os	/U @(x v)?HmB  '->OL:		 

	z\B

$k05@t"8GWcow|yiZB*}=k#FAS

w
A

JF











:aHz
;
a


At!(-1/,
Y(


r
D


g1o*

v
K

				i	G	1							$	D	c	~				
0
f


K	N 
d


'fW6DSZagmpsmgS@a+w7

;
*l
Q
		C	2{jaZdr+g"  Z  Gakq!x[#J]b^@q3<-{D;y#Z;s߬(mܳ Mږ'oցLԳӇ^>б$ϜΝ%ͷHeoɍ.sȳOƂƷ`Žq5ü8¬f9wU>'3>`7dk8Ĥŀ\eǙOʃIͬΖ~ҐӣԲ#Wۨb=oJ[=lv =6	
,Ki}gS !
#4$9%?&('(()*k+,,^--y..[//0U0001U1112M2b2w222223B3h3333334#4I4p4445<5{5556A6s666%7^7777888!8(8-8388777|7H776w61655544t32"2b10//U.-,+*)('&%	%$8#T"c!r |"XNszWh-vj^ZWVUgyMV 8y6n-SY'T|Gj7e3k>[)jS9=1 ~  '!!!<""":###$M$$$%[%%%&X&&&&'N''''(*(5(@(>(=(9(6(1(+(((''''s'C''&&|&_&C&&%%W%$$D$##F#""c""!v!! r  k:-rQs?J&$'04+t4

q
	B	
vO),L r  _	p)b't: iXG8)	|si\N0n\PC2 d>wQ(hN1oP1vdP; gK,
Wa&w3\
a
P1c*6G?8B>!v`TJ5ۨڍ}tpjRԼ&Ӕ{jKϷ·`9˨ʃY'ǍRŷČlC|tyx~O6ٸ}4귵S&϶ɶӶ+Z,yϸ%\ƺ36ϽtS-VŲƁPɿʚuh[hvЌѡ9_٩Yݿ#<i^c.Nt <_F	
.
v_Lx   E!!!D"""#7#[#r#####$$'$*$-$-$-$#$$$$ $)$3$>$J$W$\$b$i$q$$$$$$$$$$$$o$T$9$$##o#.#""Q"!!E! ^ 99w6ZjzslZI6$
 

	eH7% 1OY|WW mp#{oe\UNMKXdu.Oo%Lv2bIy0wecYC/~_Yg~  3Op 
sf[		A

y@
{

AA_*g!<Vp5nby56642APr"A![Vk5
!5r[|~x^Epn(+){7qA

=
%D

E

						
"
2
X
~


K	R
'
=
S
p



O
)FYmlkcZ?%m5

[

_v8

v
#
	i		<O
c+u9oS6qK% iP5d*  d $ K<T`fdKSkLU`DSF8ސ<ܔ[9٩	i%֒lAӨq6Џ;Ώa\*}(ȁJƷ$őd4{o2ཉ2ͼhdN8#	?da˼,A$ÿbJßQƙzZE//.)#3fל/Qޒ++Q1&0E\x
NR	(7EnWG !#+$D%]&m'~(j)U*++,^-..[//01x11V22)333%4i444G5556:6z66677e7777838g8889O9999	:+:B:Y:q::::::::::::n:J::99s9 98l8
8776
6v54-4w321#1`0/.--2,M+\*j)q(x'&%$##:"Y!y !XDeD:\x7H#mYQIIHOUds


(4I^x3W|)ac;iP]:(uL  !!!!n""I##$n$$$%{%%#&y&&!'s''
(A(x((().)O)o))))))**%*(***$*** *))))))))o)J))(((T($(''u'4'&&q&:&&%%~%D%	%$n$$##E#	#""="!!*! _ ]{-h /Yxn6DXxd!_
![
	9rUMh =-ApI=Z0~xtoqtwz%/;HS_hqlgWF2
vQ,
pI#MZ+g<cAS&uB]!}IR	t)<-^#AYoy`=y8ߔKݧ_۸m!zeղ	`+Ҍ@Г2ΌV;˱%ʚn;ǳ,ư5Ÿ<Ĺ6í$ 0ɿb9ԻrS񹏹%XIo*絤f(򴼴nZG4$8Vp-urڶB+$9ں{2鼦bؿZ= +Z̉ͺ(eҽp`ڹݔ@R6&^P8R2 *	
E
o(ILOG?!:8xo  '!!!E""#l###$D$v$$$%V%%%%&E&[&q&&&&&'='e''''''(#(8(N(\(k(h(e(R(@(('''e'*'&&'&%X%$q$#j#"<"! ( S~Y.
q
]	B' P#c[js8Ny[UNNNE=3)	2F_x4j=t9qaQPm	D}@r S6FO@#		
n

4[T

\+Y(;y{}jVm9,}
cax9.^	E~3VyeQ%3`97H'
c-'>Xcf
o
o\
A
	9	d
GoG:-?QvjotD$>Wv	\			
3
O
Q
S
K
C
B
A
H
P
P
Q
A
1






			w	-	aD(t4W0!.-,--$e8a3;9 b uBV&
S	_bqYL!^T|`P"i/e\4܍B|!׃8ՊGoИ
]ͭ:cʋɱfbīU=/RtZܹȹùnź'K տL>ŦƖǆznT:E{Է0nٱ,e-`Z6yHs.$y0	
Bf=D !"$,%N&q'{()o*Y+,,j- ..'//{0#11S228333"444Y55@666H7777(8d888:999*:z::;^;;;T<<<=K=p=====>*>;>0>%>===g=0=<<<P<<;B;::P9877V6544!3=2:170(/.-	,+*2)D(K'Q&I%@$8#/"9!C _{7H99;SW.}Ff]Ualt}wqf\XU[alv|wlYE?8?EOZ]a\V^ehkkls{0c%f-m[;H|?Sp  !""##$y$$r%%Z&&7''(O(((#)m))*g**+I++++++$,J,s,,,,,,,,,,,,,,,,g,D,,++~+R+&+**L*))+)(m(('I'&&+&%l%$$$#O#""2"!W! 9 BCQ UOftX	r)D@MbW,
V
(
6
	j"FD . 'T\vcQC6439@[v=rV2FS_ekqveT4y[1F[aq[R	|8fGVVg7QT\o2W|mA=+w]ݦ,oڲ?؄bսv*Ҁ7ЖcE͹$̎ q]VqǖƤŔČ"øM]J98GӼ]gXʹ=4OqoTȳ]򲦲[Ⱨl'ⰝW/BkTȱ<G˳OɴDɵMY>#񻾼x1 ο*O̘Iа Oկ=EݎT=}C3/*a 
SM	
M+B>;j=\P
bM  I!!"N""""	#=###&$v$$	%-%Q%^%j%%%%J&&&,'o''''(>(j((()-)@)S)H)=))(((((H(('['&j&%g%$s$#G#"! Tq&

u	E``` r*z=25@fV+;SG;73ufWSNID(|L/0H_MVK-UDr a_9 Ig/*[	

-2
y

H$mCwR &,4=Tl52...IdCtQ0Ds !,>TjnsbQy<yD\O*

z
|
	i	Oq!R"}\PDJOTYdn{R:u$e"	[						

4
Y
~












{
c
:

			z	Y	8		 	v_H3o`RV[ckqxz|X/Gy]+GF % WB;rm[%dB0kfw<T<ߌEݟOۤ?ي&v#vcҩ)bϗ
M̒OɉCƓ+td$`Ƚ11ѺpĹ@޸¸øBlݹ0Tʻ@ļH{'Կ<V5ƿǑcWKRZsΌϻ4/׆<ۙw^FGUgP!]}<

T~P	xP@ X!o"}#$%&'(v)S*++U,,m--z.///00?112W223b33R44J55"6{66#7s77$888a99J::7;;<<<K==>>>7???@E@s@@@@@@@@g@%@??R??>Q>=f=<.<~;:99C8g7654321|0_/B.6-*,,+.*2)6(5'4&2%/$=#K"d!} T&},f{=Y3+987&{j[K;+!$,CY{Q"sB!tQ:9F\m  M!!"9##b$$p%%o&&l''d((F))*b**+g++,y,,-\----.=.].}......s.V.:..-----n-C--,,C,,+++m+2+*u*"*))m)S)9) ))((p(5(('''''''s'M''&&R&@&/&&&%%/%${$!$#p##""!!x Br^|ur
Y@(
		Fo %guu\uQ8"9](>TsnU<F
g0~>x8l6 pI00=IJJU`tu_8d$A5ez~c7Nb)FI`1ޠ݃c>گ!ٟؤ+׷CS^~ӵLoІР/ϼHZ^Z\_U4ǟ
vU>ó"HeνF=7&(·pɶt ̵w"޴zYK=3*"	%Zܴ*iص>t϶*
wS¹0g^4ؾp5z/èl,ƬlD=]Г$In3s
ߦ wz$k>.b<]s	
\
S{xDEA)w K   4!!!"2"O"X"a""""D###$N$|$$$$%;%x%%%H&&&.'x'''(L(((!)c))))))))))~)D)
)(Y('''&<&%G%$$P#l"! UmH#

	zdNOPas %Ytlrc%|B	s0|oaF,bE(/Eb#WoU>~yv.h  7V+qVp	

(3%


d:H'cD6hecfi#x&%8v
aF~]C*=Qf||{\=5Bw$|
v4
tn


		jV8z/LraN:2)=Qz789FS!Kxt[PEDC0]3	l_QUYSN5
,MnKt-(#xE t-r3& \ /~.&9'``/m{
YGS1A5H;w޴Oۂڸ*fחM{Ү\ϙa̲WʫLȥwzŏī;p&uK!<Y&UúSē3ő	Ɓ|a5ɠʎ˫G̘2W{фNԗQ$Inߛh.`-osE}P
#
?m5W> m!"#$%&'()*d+,,\--X..B//00001:1c111222b2n2{222223Q3~3333&4R4{4445L555Q667C7778Q888:9w999:>:h:::::}:j:S:;::99|9 98Y87v76l6535433V210//:._-,+*)((.']&%$
$I#"! 0 muK>Jo]!X.	ti_kw$:Oc5Kan|$Gg!Ir8Tp
Ay2va\I   !Y!!!D""##$~$$\%%2&&''(((;))-***N++,,G--.
///M00 11H2233q44445D5m555:666666c6 65555t5C54{43?321P100x/.#.^-,+*))G(v'&%%7$<#B"J!Q w[/b>d:Ghd


	y
`
	W	i}v;`B-  ``)H9m!'5v(H	V5#6?HJM[iEv!F|&W<XttdUG8)~Kh57`$^+q4vO)D
bB^*rJ#UbHF~.RmrW,ܘwcGزyZB԰ӅX4Ф Ϝ#Ϊ1͸?Vʄ!pov+ƜXşh?ĨąiL5+Jhďķ"GzŭSƌ6oǯ:ȅ/ɂjʾjuHͮr2ϔqg^QJ[vրl_ٔHۦN݊.߁/tX=	tI
""!$.9GTk {gXI3		
k 

zja]:}	$-5GZl~yuT4#) 

		x\5
}Bv6WHB~"
V
h

-
	c	 	=uRUHR sHwndVG9*!$0@P`ow/F\r!K| $HoO.b*L%			i

v]
c

@oh%mBAqpV-r#Ly+drN++DcGj11rB7D

f
/
q&v/


v
Y
:

			p	>		q7T
n8F{aR' 6 PVs3Z'd4 +i9TEDlN
+7CB@JTh}uT3|P%N)`%]9'QyW6i;
[>"9Aer7Iau`g}sD).4@IQ_ߏ4~$޼T܍>۬i-ګdٚa<حؖnE׫׍ׅ}׎נ#2Stة
6Mdq٩*ځ0r۴!eܪb7ޠb߻
Z'%)lPh=B?O(vDX,DW'k.sC  A7b+		
-9
D>Fy/CFW6DBQGJ   ?!g!!!!!!7"y""#K######2$g$$$%Q%%%%&<&g&&&'Z''''(6([(((()A)v)))))))*.*F*^*i*t*q*o*Y*C*/******)))))))n)[)H)=)3)!))((((v(h(b(\(W(Q(F(<(6(0(/(.(@(R(k((((t(e(Q(>(8(3(F(Z(t(((((((((((()#)") ))(((((((((((((((((((((((x(`(B(#(#(!(=(Y(k(|(v(p(c(U(X(Z(w(((((((((((((()M)b)v)^)D)+))))=)^)d)i)>))((q(D(-((
(''''M'&&]&&%%g%0%$~$##"x""!Y!! L kgl8hznc{Z-O>)ZW 
V

Dy
K
		3	fy'b?^n A h|{G/\L;|N5X=o0~F<^3^.yN&{JY-S Z)V|EuQ,eF'~Y9o^L9)	zrke`WOF=- ߵߩߞߓߎ߈߅߁}yuoiknu}߈ߔߥ߷.G]t(AYo	!8Rk7W{/Qr#GgK{8a	9s'\1l*lD3g4d*c"qa*gN<,`8|g,aERR*cJ5h:   T
PY,oWhZ(m	P			
a


#Y @
k



 Ej#d8WuFb~(D`m{yw(9<@EJe.,*$zoZF0uiWE*xjXF1
xiZM@0!
wcL4vP*



r
G
!
f;pH 



e
A

			b	9		_3
cB m?y_?sW6xW0
z`?wP)   Q   wEmI%yU2iC!mM,wZ=!uX<*iN3oM+wbM4vX:x^I3" sfVG<1"$'*-/48AIRZ_djptwz~+5@LYhw
#<Wq >\y	">Zq
+<M^kw&=Si
!;Us$B]y;Ws9Us.J`u7Tk ? c    +Qu@q /^IzI%]1gCt"	I	s				
=
n



"Kq
6b 
 
B
c



-Y;f%Y#P{ItGj1Me} !"$&(*+%
 |rkdXLA6-#	~m[J;+z^B&
kL-
~cD&	|cI6#ylaVLB5(









r
b
P
>
+


gM4dA"



e
F
(
	
				l	L	/		|\>!|cJ.p\H2jR<%nL)n^I4nW8tL#     j G  c?|tl\NIEQ^hr{veO9f4p@m_RIA@?KXj}xpeZG4wW8#:Q]ihfgghiaYD/wT3yc\T\cgknr,Kj~ubH/ ,Gcv~rfZN<)uaM9&
 2CUgow %/8CM[jy&-8DQ_it	#/;GS`nz
-:GQ\gr|
&2?L[ir| &3:ADGLQOMLLMMLJEA;51-,,.11048;=?BGMSY^cioru~ 	!+4;BMXeq~   " , 5 ; A G L P T W Y Y X [ ^ ` c f i h g j n i c e g g f i k r x |                 #,29CLV_cfhkgc`]WQJDA??@??ABFKKKKKJHJLQV[__`]ZYXUSQOMKIGED?:3-$
                             $.7@GOTY]abddccc`]TKB:1(!                   
      RSRC         [remap]

importer="wav"
type="AudioStreamWAV"
uid="uid://dxsq2ompo16xl"
path="res://.godot/imported/r.wav-3f69285164fb489d429cc55a7714b0cd.sample"
             RSRC                    AudioStreamWAV                                                              resource_local_to_scene    resource_name    data    format 
   loop_mode    loop_begin 	   loop_end 	   mix_rate    stereo    tags    script           local://AudioStreamWAV_wlkc8 8         AudioStreamWAV          pa                                                                                                                                   
      	            	        !   , > O @ 2  ! U W Y  i" v   E   ? g   ~ ] < 8 4 d   +  9 ( . 4 /o^      j h f ~       ; { A    $ u =YH     P \  `<a 168 ,   ~+NU [0Z rP|  ^ " o[ x8 r g    : <L]u P`  {g @r#I</r  dmrH  _1 W6 x)0 o%d-Ga  _        | SeA  b9 d -  ( R {   x M ?  A[   | r h d   c9  Zk 5  G  + ]/_ v^ .N- :h 'y ^,7  Y $# e  V  r9 
%m  p \ t^0Y " g   -     r  {M
  2 mW  ] + VsfP:  R T ] #   . [B cF
 C\  d C/i  2C G= 7.k a  f    w  /<blvv  C9/
  x8\ U*q  8  <-}@  q%A]-l w- : G P7Sn4 > G   sQ zNmWD  =r)   q   '`tL~}x9 Q" ' jNh 2> w$~(y]@P`  
 #5 ~2 7' ? 7        $c7    3 
"x   R  ;_> hhhN  a vR  * 4 G Z       { \ >  }jVPJg ? x  5i]Q  @ =  N (Jl
 a 6   + H d  % \     B D0      + 9b{ k`   . g+ s & W ] c   (k%  m/A?  J^t e	"s6    | + Rm .G ( Ak 	  0w       }  .msy  s   n H ! aS8W C Gf F:Ko@#4
 8   c  H   wIl    / (} NID7 )\]uZ#3 L ^9 t n h   G3   ] ) #  3@" w*     * 6   5  IV ? <Rw c
5ob   W Z:eh   #   t_]ZPE9%+} &9L  b  0 H 2  p='l   EN  >dG    ) J ,t/    2<  :Y yDuRB3     1 cP @ j a W 5  N`r) [   5 B? y%`8 V<r} 	Tb#    E n   T" 3(p X ZKAF t I    I)<n. c   a|: 2bu zxw spS! 0= jP
  tO+   y 1  &8  , G R ^    431  X  I z  Crg+  & .  Wo 5 	  b  2	B= P]v  bw	y  x; 7h  cT 4  o3d +! R i@h0 R   / `H  \ $l4"O{PlO3UxZ A@>M Dr n: g/ c U
 U PA5RoH  8y3  l   v w P cbty||W8\j4S:ft4@g"0 .\ ){3 I>)"M  <? A)@s gHxrF0nP2 *3 ,&>5 ,^^ y n c  3>| +WM7> e  .#   R    {Qp } . 
8r /f FfM& Ye
{ lO )Y8 Z{(T+8`Q L,_ZUc 1468 U  *A(A zpwRc} d +R
$<yj  M|?$tl d1 #  	,O?(VB. z   (bT 
X  ( _ d i> ^   ~
l o  Dj5 {WXl 3 @]{W3 ^0a z  >qQ?  O&,Y %E p@ < -  	G( VRqwdQRT-rkI~ wW8	} ,	eX$ )u 7s+Xl<Sk S</, 
 Uu" ja 
" j9j{ > jQ 	; R:"O RTh} Rr	W_forvW Nux \"g ![b ji< "De >hy #G3i9b " Dv a[T A/S\ 7i JFC
0 8" T #x {kkj tz/ t& E.=  2 4{4 x 'Kr 46ir ]h z	 Q
x "!|/ ]:#f 2_qvi Dzpb ?iBa^ ]
@{Y   Tw  =;9  3UXG 7<P.#'I  ?Y]|R' Y'[ A6+** , y 3;r$ 3`C%*/12w i L~$   c:Rm r  iDO )E .:    NTi '?q  O ,  *('qJ 5~lY OC[ Q&S m@    y |: p-5 =b%&wd P8f '3  }X? 
:	y      d0Z ;u  g U 1= v"  y U/ s:  = r h ] b$   O w6lntw ;  q$] ,16 (-x*A3 I_"I0n f' k&cwU,W k)c}z e	
   W @'U%OlZ-a?   G  9 Ar2#  QnT( 1Y%Yq(z& SNM 5" ^:\YUG SA  y3 D"`ej		 R  e2Fr 8;?C  &    Q !Q5z
 b}c_\N@c~#KxS/w|: ^H c5	&F_ H 1 <6{3 E P  p E Wh u$=n _a!z]Y  Ou {Q .P 8,8&d#b A/CD )4+m@j e" * **++6@I $_  ?M. h1c[ C
+Yr rr ni#1# I}rfZM =1Ri  Z 8q5 $uy} O+ gnu>   { & m x  0 Z)<Oxd?=`Djs? TF 8:EOt}K -Iq 'FB $, o?mcZ1)Jgc` d5!:S wL! v$x[?x }#g{W2 vle0 KzY~!YoKwU4
?|+(v,!`K60*   Qr5eG(
4n X7 , 	H"_6Y |vog  L uP}s [grt_PAIZ w/ Llmn-O_n5 /9WQ 	'>( u1b HWfL u?h 0[
),f ~k? c? sg_ N=
{ &r] =  &  Fe |O   
~ |1 LI*  p ]  ,{Tx cK 0aytu\Bt  DUfwy | .?kq"pLE? BeB " gM\j X F < 2 \ ) cf?EEa  ])~y+^* tx VOMLj 	#<yk3r4 wdJ8p_~ iN ~E9T!?My_"B - }hSA0Lh|6 ZZ/n ECpdz $v: E/`  `;+RS Y    X8 u iagm  *gF% aeAg H {t6.&*.[tL$pQ:"u  s5< ,t0 \F1RJCoHZ	(C_+] qnI$&d< 75 l%+ c vmV`iWsuy7h Y&# X1WxCM  2O yqS  F oHybQ]/+ '     Fgi l)I)  Z [ = _K b ]7b s 2 e'Y |I^9  	@   u t :dv FK  `  JiJ(?f S2/T/YonO/ .^ =.KlScg ~Z W   Ma. `R832( }&3ag 9
pa%KW-Q+*  {4e I  ) g%. 3VKx1 bS(tE$  G<& .]X yWQ+5M /Qs %|Lz  4 dQ<) $$%a @I
 e ? &    J8^ - MrR3%7 A9o >t= ^c5NZ 
C&1p %6Gx%h|K\XU (w<< /Sx<f*a )<%ww bMir!
o b29X{F&J'S =l * aq ]B)U`\_.QG9+	iM 	N;dlv *
 W 9n	5oN'02: C''|M ' f\S8_3  f    @}i O   i+ G 
   pG[ o0 F \    w _ H 0 ]/^j  %o	ba3 p'liz # $w}%X  !pK zO4J3K j		a	! - b2 #x7EsL/C`QH.g(Z6$:P( F] 
 t7| e	!+&q 'S$  {7WS S 85e`[ u;a,	x=v,b6	FFS$g<-Bt4O '	{H<"5U js|QfP[ ^  zC D  F6#dV  ;$ !i'8oyRo 	@6ikl A:1 xU  
/&w ?Y uvw;p
v  S61,>^Q~ _<i% qCF /8 "` B__tH
2 9qVwy% /Z<&kA<"X0Z "#}z	.		 j\vgpp8  UFv  1 wC`|/L>ea]k
f@p >f |(,W{ | iZ&5W\aj&[y	4Md|Q Hm~ g6 7]O@^?E>7^.Lq]~.
lH4|`Q@ (:e :)
rq+Tf _[Lg:9 dO{	* N(t r@ I0i vO;:yC Zo  4KIB [  y D ?JF gHVfK7 \}W$ [/w/ eS n 
g   >dW ?w	!1A5.(
jS 9r! i6	 ?<cp4 )T  sh) oj9kRNL/Nm<qy#$4n 04   X  \$w?Z olc]x OY ]\F ? Y
+E h E$4w& 'X$W Q q"* }1-}z3q">Yr}Q 3	.h?V~ @fE'H&Y  #? IZv!+K[@  ydI.v LV$ ;  ut{X=oeTw	@# b ynBC#-: laE; z\Qy<N +	1RA>   s M    mt5-8.6c 9GT3 s2 O< %/c() >TQ0e  0zO# ft )   i!)=5ie	  )d8l    _P g-8D a|- [q ._N$[biB)**o6a`jQ# 	X5y,I\P	Emfx		B2 
N

Q xGA-)Ijw
h -4!Q >A. c4O1
*x~p	gb fa[5   " @Zs%b's}n g&R^jl	%8S
*c  8 K( DJ MU~ |'.lj]j Fn  - ^  ] E  j_ \~ 1uQ 5w>_y1$ud )wMImPZ    hy` n | rIn &7      E7  8BK#k K h_0oD^<J X'   h:c K 3   |- @M;}p b - I g MOQ;	  
&3	}A3%Jo53] 0y     BIC`/ NK a<[H*y V d(1}VH  f E +b"1>b0 s"D S" q$h~;+p [~I;q>SB[tUx%)O7 $!l6: _7t% _\YPue.ky & 1BS %z' x
+~wASBT f3> >}OG  c  t1 )IiD [m D tHn | c    TK
 _ qkU>R]@"E IJ K,Ym FcN 9 7  mYF9  S 56h  #BZp.z_z3WE  9 f UgB}`k;
 > -~<G?Z8tk@[vh 0 6 Z   ]  E h [U04Ut     _ :87aB[ XvqS 
  [r a r
T 3Mo t$
 6 *T> oIr A	$j "k C<+^aR + ?E. #2V8_ &rv y_N ]m0  Ge ! 9 
lU )W abv1,| mG "vl :< ACNbC)0fd< ZN 5wa&wko2!' % u'N=nQ	Apd#* ikDj$ 
R>mG YI* h  A%1 Gh = K# ^   DqW)CV iu Tl Rbl }r	 5$de![ c  -ETJA0K^gn	N &&P\ !OYH8)"]r m\
 3 w  %:[~'oS6T PT(y*5 AW `&S E]5
 s=x# p$$
Ir 2	3GZo-S?0 d* Fvoh OdyJt-
V*3d K(I (M ?Ja #?m#vUon5 { 
|SKn D	
Ic}9Q	  b [RT
2Q I\( Gdf
w7T-:O%	1GI ]26B  !jn-U0w 
rh=iQ|	4 A/	CWn&! ,u:  iL.
ds"l 	SP 3 c6Y. \< 
)'u1H=u
{bP  i#.gu'3mE?.[B* z|5
Cg7P/7 ~1K
hT XyKx-\+ Y=wT ; =}J /F:
Rq?V g @(S, mo
 }K 53 Dr2AT&i@ 6/5?'W 1Y 
%*QxT/g-R, ?3oj1TRB .8d,7 2 YE  +\ Ir tI3"3
 BViN6`@) kq=
  LRY:\}h  
	6s \  t  [ L Z `$   W Rni)0 q )wh "  : 7F VH4j  > tG|. "4V 5] 'h$ ef$Na!  a$  9   ` g &	t1 B6e?
KY /  -a @x( g G O-Y  AkHI  YEa 4N! h   l jO pSq  3r  [s }!  \ % 0 a]Ft zwOw y A#~S s p C 9'D F 2 k 7P(` ;xli cA ?$X+n*G z  +! AD 05 v /vy _w[ <vF F : y  g 5_cJ jq*x : )5^@Q  ,rB sdneY ]$Oq^" JlR A/ WS
8d ~{7   JZ#o5 4 `   8@g;QfC k$ 9Mr ZaX !eHq*FbI1^J D0# '  _J `f ? pYBYF3 bT0 rH6 i5Yh:73Q j V   8  6Op _ @5z  L<  4 eswz03IC>q\"yor	z I~Ui}3% Y&n( 0w. #e-9(&e:{Ot1XFdx
 Q( #F>6  +uh @8/%)-m K 3: d^K c: A m3?'Il. ~D   7 {d2   ( `F ,1` K @Se vL Xu `   e w-
 ' U   Bh& 0 F ^emkj ?7w t7^ Z ()lG- I Ag+}&>Ug %- 5}utt 6U=H  X 
 ( n      > n c W pVet6  4" Y= Z a iF# W 6]  g -Rxc MXc&x $? m   X  [  
 _    | = @_ u 5 tl@ _ LW  C g-    L  ON dz   pg < b  3 t   M  F3&: IS];(]] O$ zV0	 6  qS "E  C ":n  |  =g 6 xu" +bI riJzKawY`gS tlc0 H IGK  {Ji (nQ4San  !BcL     In)Gd3oSJ   ('z Wj} 5M  &m RY Ho  $ A^s <K [2nf K;&V*  %     's(
}i  Q24JZ 7 0
(8- 
 - R^K:Z y0;` _7]JF- wBu # e   B Nx"  N:< O =W  5  T Mus :  v   X &o}  { S :!mKN   * c    G ,6 W9     Q4  <. u d  	H f	no@  Y  - 8f@* h   j ^B   O"  Yf    0 /
 N F f  FR   q^~G$   J  m q - {`&  [V ]E'b E 5 aM qN+\ 2L  U| =  am fo t # 8 N I C ~z G `P _ z@  O ' ^ s C >>X! d8w    i/   5
w  e 2  PY% R  X
  (%	 -zRk   ' v2]z
gp   u ^ # tH q& >JD    9sh]?    
 ek 	 <Nx<* ] *  0 w=`WRr    xPT % 
zE %O @&  C |X  q  jXC  $ 4Ir   : oOT   
 qk %n R  ]    % |[% | w ^ - O_    a&} ~ ; %b U}  U 	
Vb  tpmW `x?   C \A  O X"@ n  3 N9	     u          ,]  yL >   = w g V QI$   0 t [@&  :   G c  /f+ x
 S   p @  J   X  + zi k =   5 L ; < S j   ~0 ?   c   4UvzJ  f 
 N   m
 R9R 5 NR4 @:5h @L 1j ]  R (" U  h : _AI\  tC  q&   < F  6M   >9 Rc K2e F%  
 w D  $ + P     f >  K b    d z7 P ~ F  q     t O )  
  N  ` . }H.W j x $ TWYkbVIo         
      RSRC             [remap]

importer="wav"
type="AudioStreamWAV"
uid="uid://bgx04fxewdn0y"
path="res://.godot/imported/s.wav-9474e298181cb8fa7f7cee84850b42c6.sample"
             RSRC                    AudioStreamWAV                                                              resource_local_to_scene    resource_name    data    format 
   loop_mode    loop_begin 	   loop_end 	   mix_rate    stereo    tags    script           local://AudioStreamWAV_0pnj6 8         AudioStreamWAV          [                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             
                  
       
  
 
  
           # ( . . . , * * + - . . . * & "      $ ( , + * %       ndZOD-zkmnzcJIGUc_[:qTH<?CA?4(
"7LRXH8,)3G[jxz{naM93-@Rm^7G)	&),++JjSPN3w=xZJ;+Y&OZeE%i,}JI|4g3cqgOLHug7r\TLGB3$8je_A"+ABDK16Tto;2BRH>6-Hc=fH+Jh0*%#!dimAFKzx4~M->^}zvdRI@:5,$Y@( '>QcnykihqzhU8#P|OykP8Uruxj]K:-! />_?Ds$rV:DNe{||^@pS6
?h\O1
/F]bfWID>Zv	Cw Sz%Y/TC3
=4,GVmD\s#H6$kR<%+0TxUV (NuvwGqF:.& 	,PtscRapkg2yW530;FZnZ8ym]^,Np*i+ D ^ O A 8 / 3 7 . %  $ M g     A;5/	eE*$<SkoO.!3E@:"
 $Ba``9               s J "   9 k     l }             L|gQ  y S . 5 < j    

 -p_:0'.4:@KWp+Otc?2$.9/&oP1,'7GIJ8%	   "F]tsrjaSE/    d :   C q     !h
p[<o}iTbpjd:'Hiou{sbRA6+&!$(1:Sl2FZK< .GrG
@,qa9T("Fimqh_n~'d@L	}C"
):73	       &X-ATPLWc!jn}FNtX`i`WyR`@Rc[SWwk-										+
l




P


					
'
8
J
f




<Zt(7EOY}
=
o






!4F_w;`
,Bm*Q]iXF#vA&2W(
xn?





N

PR



M

	y	&	Z3
IQtZ?"unghhCd(BK  d ' 
 )a=Q,f$i+u?OSN{6lBg+m/Sl$xF
7ZQy0CJZ $"-#@߭ޥ2hkKL؏Z&
לS	׶b'ո՚|0tL#ҮҌkU>=;GRI?ѡљѐѠѰѰѯ{HвЎjqxГЮЦОpC%QЄ9>Diю@Ҏ2LӤ|AՇՄՀՍՙO2mקHyص/nٗ%s"ۃ9cܮ\ݾ
UށޭBߺ1#N g 
|<bCa_/Br f0Cs	
V
Wx  M!!C"""D###:$}$$$$$$$$$$$$$$$$$$$$g$[$O$0$$##i##""D"!!h!`!X!J!<! !!   g d a ^ [ K <   9 d     !<!r!!!("g""""'#O###$k$$T%%%'&V&&&&';'r''''''(%(;(O(d(e(g(5(('|'L''	'&&&&G&%%p%/%$$p$$$#T#"j""!E!  P S@]p^	M4F
6LyLnXMCLUm|iT>ACUgXIr[D2 HA!Xc
{
*
H
T
		G	J'\Z=m4U&X  j 2 l=hFY, X)tBT#aMTV]3D5s,M7";?BNVXo]W(}6	r-vaLGB ߑ^+޼ޠތy_Fݦݓ݁vlYF!7WcokgmtݙݽFqގޫ2nߪ
9h#h7,m0,
M^$m
j!5i?8Ez-"2U&{gj ?   1}1lGw	

 
TV R!"#$&"'3(D)F*H+C,?-../b0112T33Q444
5O556?6}66666667-77
766666s6Q6.6 666555N5544]4-4333Z323
3222p2]2J2A292!2	2111|1k1Y1H171;1>1i1111	222!2E2h2222223!3A3h333334+4L4r4445H5555
66'6/6J6f6w66m6P66555~5c5,544[443a332V21110-0/F/.p..--z,+Q+*=*)=)((}'&<&%+%$@$#(#"!=! 
 vnmm(pma
An6Y\6G_.D(k+
g
wy
z
	_	u%Adq q.	sEtD$ws	$OL%|)6U
UuR.~S vV4y?	p2TSd|,߁!X݄ݪ;]jX(؍Y#Յ=ӞraWBγ2ͱE}"4ɴ~^>,ȾȶȮȗ`AǿǧǎtZ@'ƷƓƉƂƅylF ŻŜ};ĳlFäi%µ|o^M1~aC4%&(:Mcz'sbð2xľŀs:wǴ7ȭ$ɪ0zV˟̟
v͏ͨDή4Ϲ:BKІf
xNԃԸNRd?؏.|G@۩Qܑ<݀=ޡVߨ :UOIQZK
0_Culk4&{ E)d	
I
vdS
wW7r t:{#Dg}bG:-Dd]VRN'}*ccWeXIM-l L   
!W!!""
###G$$$+%%%]&&'d'''	(7(f(((P))*w**5+++P,,-m--.I....%/Z///(000k112/2V2r22222s2.211G110b00//Z.-,3,t+*)D)('E'&%Z%$$f#""Q! TOJ	F?F ^   '!d!!!"Y""" ##3#0#.##""""\"%"!!s!1!  Z 1Us	Ch<[ijhgbi


=}"
y
(
		N		d/S%j;kK#<boe  = <v:K@07eviV@65-o@|SBSl
8o
DCߔnG޷ނGݦ{Oܚ܃l_S8۠{k_K;ھڋkI/ْX"طأ؎؆~|{{{xvvtrpdTKBPZYW2
כ׋zפ
׶ףר׭׽<pآAkٜ'^ڕ$ۊ{݈^޴U.U$-?9$&vS}|Oizs[@{,>`A[vc]W$| ~	
k
aW+:c5Jb@m6317>A]m kuzxO=yXJ ,Jl*z
,[6m2NjviR7	
";EO\f8Rw

 2Qrw|FiC!*EPDh&oK'{cZQg}:k;3'
zx;> 1 H F C %  /a{n6O\nIQiszJI

I
z]6Z= 
 +:J]p3Ufw
 
=
W
r










o
W
/

a(i%
~

	K	'N6{stj   xL
mtQ1r]E0a+Z+]1k6RzJ^0Y'{3n0@_	[
rgG7,88e. l7b-lD[0Rf&l+߰w9ްp-ݸ{<ܱew*ڂ)ںQ[o׸htսmӞRӡJјSФІ\3ϵϒzaQ@.γΤΘΗΕΔΎΎ΋Έm^O@(͍ͫͣw`PJBIEKRVI?586CPg͈ͬ*P΀΢ >fσϟϧϭϩϥϵdмlѾ,cҙ5Өԇ?DQՃյ1֮AVPK؂ح8<ڲڶO^ܷ +@Uݒ-<Kޒblm;f%mYgNCw:	

]
#ibB&J:bCgd#VW5sbEo!<`Bm [
^ b   S!!!)"j""(##$w$$!%l%%%S&&'\''''((((Q))*p****+[+++1,>,T,E,5,C,W,,,,,,T,&,++++,+++v+n+c+}+++++w+G+++*****~*[*=*4*8*<*J*Y*Z*Y*Y*D*=*8*2*"*))))))))))))))))))))))h)X)N)D)4)'))(((O(('''^')'&&&Z&'&%%%%%%%%%%%%%&&&o''Z((
)S)))\**G+++:,4,6,&,,,),0,6,,+b+*m*)W)(K('F'&!&%$3$#"("! D "Lve,g%} J(l3P_mpsnilo_N+fJ*}C

S
$
J}C	

K

	u	(	632( 	 sz;`chrv&RQYpP0tUM?93pWC*Ea:6{#y!h	8[&gBf2H@ߴ-ެ*ݵDkڒ0~+أrBקtAְֹ֤ֆh4 Օy`VL'Ԉ`3;C]uohG+05yԾcՔ 5hֶbs!qYڣ9ۆ$s
Xݱo'|[Gn"u[%c[+'"##8LT[@%mw,p<
R$7H9&&&Kwn Pk)		w
 uZ,


6Z1>=s/mE5p
fDqAJskTq8 ^4 X ~         i 5 ]k&{xveI-(#8N[fXJA9FSq9b1 5 f    0!T!!!!!!!"="^"{"""""""""#
####""""""""""""""""""""""""#%#)#-##
####8#X#x######$S$$$$$$$$ %%%&%%	%$$$$$$Z$5$####u#i#X#G##""n"E""!!!w!6!   \ 7    ~O-wodZPF:4.'Bq4^62/Jgij EWkN%7Rn1zL?2BT,?S	'VKt w
=
&
	3}ZW &OXcgE#7Z~nXL=2&y[7   S  6y3vOwp2ZZa)Zou#b|Ew-x$Q[U+ jG$sE\*K[;d(ߏVߵ\ިLܲCb}١5LK7աuLҽBaχϨ:wuz7ʿʎjE(ɮɋkM0ȷȲȨȔY7ǺǣǍjJ)ƦƈgB
Ł4ā6Üe1ªn,WXſ̿ݿ߿Ϳٿƿſ$ؿڿܿ-b@ybµTáKħŇƛ2NLAʾFg͑~2υTBў
"*1Ҁy!Ք\#/|&'(3>4r5 #&z@  1Hq
0Q"y 8k:			`

.=
u

W,UwZ\:BfK>nL(^\Eg(X&Zb M   !B!~!!"h""#V###$D$$$%K%w%%%%&%&9&L&W&a&d&g&_&V&;&"&%%%%%%%%t%g%]%R%J%A%4%&%
%$$$$g$E$%$$$#######w#^#C#7#)#.#2#8#>#=#>#9#7#?#G#^#s######$2$]$$$$&%Q%}%%%%%%%%%%%%%%%%%l%U%F%4%H%[%%%$&s&&&&&&&'g''(%(2(''{'K'x'''(''F'&r&&%%%%j%%$($#r#2#""Q"!e! k  bl=7U pv38b3T	B|#<L\`aho6S`l`V?)%-!tU7caqSG#

!G
Q
	P	u$3gvq0i"Px? ~ D  xV4pYQH=3 }fO0SS!8KL/c!Gl*=B@9%,HeLBhK."jC"`@#k2}Hߢp>
ޮހ\9ݪ݋lQ<'ܼܨܒ{iK2 ۪ۓۉۓۜۛۜےۈېۊېۖۑ~S'Iۓۿ<{ܺ+^ݖ4Zބ޼)Ti~ߋߏߡ߱(V
O
gM0/.=R~_d|\L S7	z

LFAP#}G!R\cQ?v&5s
F]q*

s8U
#LuP-


h2yl9o(K^t5[}?n4b0g$]#oJI
rI6 m>  !m!!!"x""#e###$)$<$N$D$:$$##s#'#"q""!! oQ6!wmv-^TB|rkhqz
.RwCz5]ya?Mw0ZO]:*?WnweQ=)rS4




s
Q
*

t;g
{

	?	S/?3Zf&P 9d+V				$	w		0




P
			f	p	z	T	.	Y[pQ5 G "m[)wK`j+#
y?2_}f]VNE"gaZM@Qq+`)u<Mh,|[;k"`7CkN \}F&s/\"p#~%ߛoE޻ކEݐmI0ܧ{P%۾ۙuN'ڦچe6ٛpE ج؄[0׬׃Y)ֻ~5ղ|`E'ԧk.ӛsD҅6Ѧc+ЎSϗ^$ΘoL/
ͯ͐pL(̝u]DCGGG%ˢˋou|wv:ʨY;;Zwʔ{_9ɸ~FȼȦȣȠȉo?2iiɍʰˡ͓Ґחމ	n*@


7@6sz6l>
&
4E#
jBB>Tj kwC    Q[xJq{	!

CCo
IR2

f
H
%
&
%
?
S


PC5!p pR(GS(d  H!!p""D###$7$b$a$d$$#7#""c! 1 ;<1
x}1y(>5S}T/Y}1v<KqYqoY*U3DkEI1)_zihgaUJ?=531!U	r)CnfX>Iyf}6
":`|L:qk/~=L*g"y2
3
'
9
	{|pQ"2l-AKVZ_elyW1\
fg f  kyLF K+
`*r\I69<HOF=[M>4'yoaR+Rb&Ya9Z1ydPE;<===BGDC;38?Ytwsbn{mP!]9xiZQE2.N{Q1s[C?x Ls6PNK7$!-E_tGw@mCw?7}Cu [   L[v
8c?A6tN.
U^c+M^f,zdN?3/,,+        x h S > ; = \ y    )Mm2T{%:Wz2K\iv4\:Yv+`sF2c?~R'TgI$ g3pG               :Slg`K68:Xu{ri{n_PKD@<2+            c D $       }sL2&<Ras^H *E8+~zi>Z&8]k<(7X!@k(.4@Mjw`[WTPG>-yjYG9% -"	^;

pcUg{w`L9CMkzb[Veu}~~	$>FM?.8Bo3c,?SKA6*/2APSVD3)#/;<=3(&shVF,mFdG&jO@0/./210,,*(|
(8HHH@655H]w4WfwaJ/*:]~s_TB@=AFLRF>&

,<IT__`WNRXp".!?KUC2('0:DA<0&
  ;S[c_Y]`x*D^y
%Kq	 - Q w    'ZBlO0Qs
1To!.::>CJXhz	
!%(,39>DFIKNOOPOKGE@=;5."
	"3EXiu0AQ_nx}m]N?.jR<&{lXD1tbP<({dN7$qYF3! m_QB1#}m_QG=0!         x k Y F 3 !   fL2~cI5"|tcSF81*&! #1+&# 4He?ahpdX[]r $)'$$$4DYmnpg^WOYd   # '     . C ] v         !4I_n~  .<Zw-KWdfhw)3562.+'*-39BJLMG@4)(&,37<83( $($",162.+)-16:AGNU\co{~~pb\UVWWWTPE9(uka\WSPLJA7#p]J4
waSEEEFF?7'                  } z x w            
      RSRC         [remap]

importer="wav"
type="AudioStreamWAV"
uid="uid://dgcugr7mre8qa"
path="res://.godot/imported/t.wav-e1dad566e0f76edf392242f38c38ffd0.sample"
             RSRC                    AudioStreamWAV                                                              resource_local_to_scene    resource_name    data    format 
   loop_mode    loop_begin 	   loop_end 	   mix_rate    stereo    tags    script           local://AudioStreamWAV_plq0w 8         AudioStreamWAV          o                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              $ ) - 0 2 4 5 7 : = B F J O R V [ _ g n t y z | | | z w y {      ~     :oS.q#Mw(;VqxT/Mje ] #o#(WpAZJi)d,UZa@MYcmP2`GJF45jN]l|}oP2%-50*>S9(]'#.>&p[M>ZvQzT.)D_v.wQYb r&	Z
o 

z#e OQ ^t;>ASdjp]J*	Y"Lg3\0

O

j|(

C

	l		x?t*8X-g6  *OxIr2#9n$d

l+uJ3u/|]?!KT  } V / z9r,99I/GX}S
~
FtU/t.`X2L
Z pjvGw'kޗP0ߥf% ro.܆JٙIrא7;@}׹<Zz؝(ُ'~>74ޡy{u7/ 7
M
A[HkE #%_(c*h,-./x//.-,V+*(>'%3$-#("!!!""##$f$$$$$Q$#"!g `<+0Hc-sQ^	3&				Zt of]-p4>I!nUa:	5U3#\[[x v	
(V
.k28ix !"#M$$%Y%f%s%q%o%;%%$$$}$$$$$h$,$##H#
#""""""#Z###$W$$$N%%%&%%~%%u$##H"!
! m    %!!""##\$$%$$B$#"!i u-1t,M:(
+BMX_Y

SWitATfP !W#$&'(*7,-/011.21
1q0/P/..t-z,+i*P)G(>'&&%%O%%U$#"'"!t!?!
!}  a[DDMr4c^	"(g
M
	%	N2y	LlZW  Uqtn#[)\b5w, o;_LNU;bmw)=Tj߅ޠ2܊ھ_)ؚzZ0.pؾ
;iwمَٗٞ٥ٕمFِؘי֝բ%ԝӹ^(Ѽp$Ѯ7ϧϳϺϒI οΪ`ηW.̘1n`˨*2:3+,,9F{&ʟ4XȥȹȵEɥIʸ(ˡT̷̏lοϧЏх|ӂԈՑ֛׮ܢ3
iG}=	
kx {$')*++,-!.:0S2[4b689;=@HC}FIL|O"QRStS'SR/RQUP&OM	KHnFDNCBAAAAA BBAAA@??J>v=M<%;x97532%100711p2333]444430310.,)w'%" 
3DVrAg+
 ch0 rp
UV$P629 !n":#G$S%&q({*,.0-23>56799:D;;;;f;.;:::U9p8c7V65 54444*43d322}2R2'21111111222111I1100n00/.!.-,Q+*6*))))))))*7*j*N*1*l)(`'&$g#!{ 
\

(
^	=
IsV9Uq({
kM	k
r<Oan{u ?!"""##q$$%%I&&N''(d)(**+,~-B.//!0q000.1)1"10e0/R/..-
-,g,,++*)(''b&%V%$$ $e#"! c)e}yrsu`M>
1>L
t	,37} H [{)W*y5hMF?iG5lga=b?<8_cp%n?x/g4FBO>~bF\r'2>"@.^5Tq85*5^o=dwލc6ۥ!ڝٟ+ظS֮n1դT իt>ӽӢ]қdq}҇ҒqQ+ѩчT!
в`ϫϫϩφaϤ"Ο9{#̪1˿Lɡh-Ȱfǝk9 %HcBǏZ,Ǔǀm$Ǡ/aXR1̒]IXCРНКДЌиOы6K]o~&||"ҒDwi],ӬԗՅG׊=ٖ2Xܫv3Qj,<N7v&{
?S4 "$&(H*,}-.+0f1P2:33d4~4443210J00///k/4/.G.-0-,:,+]++*X*)('{&%+$@#+##4#S##""e"""#b#]#W#"U"!-! > 9j1q3M6Pjm6
Ueu
		z^+sQP	
G8
899dCgpyYh !"p#$$2%%r&''J((O))@**+;+n+{++++++++x+1+**4)d('&&%=%$$$$$$V$$##{#y#w#g#X##""U!~ *-wI m.&8&}~

vT
B	1| )!Fr>v>[e#3#*2cN	8
8
7
G
V
WX
`-lqv [+[5c3
H
y
	kfa^  T7Ja>;O.
OlpV;::8Y{;FN>{P%Nn[&9ުގPr%o5փ+]ҎѾI΍/̌Pʙ
2TvC
ïÙzZ<r_L+eF=3\Bµ(Áõùüù÷v6Z{4*پUѽy ]
1m*,0)Pv<뮦a̭7H@8dڬ2lѭ"k<įv(m-.׳an{aȷ!yֺNE׾q
ÿĝS	ʨ{͉Μ΅nЉѤҾCעV۪:c8}XB g	
>p^ < N!";###$t$$^%%>&&"&%$$#""""~"="!_!  KPU^O1[M	oZJq	>P


V

;
0
%
		 	{mv| y v`w+7t!n  }P#|KZv	E
A

{vifb4

kJy3 k5a(e>*=GQ/a4 @rX)m)}jW?(!P#.&'+^!n>k
O/.w;tMihKu*s2UFnx-^
Y

ii



5R]hii~GdyrF0R{

$
,
3
%

g8j.

n
5
			p	5	<Os%b: ~ " <'$.?SU>,w*b y9\a=]1{XlBߙEޢKݜDݽ܌['ۼۄR کwF.٩v1ؑ6ײ}G׻ւIձJԄ$ӃHӶ_qЎ\$Ϗ3΢΅hO6	ͧseW@)̰Oat̴̪\#ḇ̥̙̉̂kx̵̅92,̴̶̮̰̲̣̐F˜˿)"2Y~̱+r͹]κzχϔϮ@иn$ҝp԰ԩcv׊NڇکXfuޝd !O~0I-U 	Y'LrXpAq "$%['(y*,.R135v789y:=;<<=>>[?[?[?`?f???c@@@@@:@@??@??9?>6>=j= ==<<`<;;o;H;c;};;;;;j;);:::z:`:G::9a9988l8G8"8777_7-7.7/7'776665F544444n4
4=3q21100s0M0/a/.).-C-"- -/-^----.*.;.v..///00$000@0l00C11T223,44y566?77j8 99$::;Q;R;R;i;;;X<<,=h===>W>>>A????????@@@??6?>k>>===]=$=<<W<'<;;;</<H<b<M<8<<;;;;A;;:::::::::w:m:::::R:9r988"8777]7646g5443P33221W1h0x/.--r,++5*^)`(b'W&L%Z$i#s"}!x trSADN/a(J6Y0bjiY!9<gB wr`2
&
o,Q
[
 
	0	Snjl#[r$e G  < 0	}aF<5i.SB}M-UbSr5['
n1!4MY`ۘIڥP}
٘G׺׀3֚ձEӇEm]ѪКЉ~t2ό'Όt[F2͕͏̮[	˦CV[OǲdųuM©Qj-2L๝[޸`PǶ`D
״ڴܴ		ESI?q׷̷v!?|Y_e|3
@oǹXK>۾w©ĺȚiήg ԿMLڟږ:݈<߳O_8]8cW W P~|<45(K^rlf3.EWi;GXW?D~E]%p?"/w.j}zWkc,}j o  -& >\]c		
C
64K0v>Ab=1@KCWH:){u)  !"#$%\&&O'''M((I))t**+=+*i*)H))(((()(}(8('''''''''''R(()m)))))Y) )?)]))G***++
+++:+++#,|,,,,,C,+++J++**l*$*)))(a(('l'&&(%K$#"b"!*! [&]Wp	S#cui]N@O_6Ys2K"6IR[B)SOt)z'L
q-(
X
7t
:
	{	!	z-=>z`i0L6 ~ - 8`SN]|uJ@w6Nx8V!;J,<p0sjO3goTX\hu=R,5>ST38]J8;JyTzHP} ?N\^FIa^ߟ-ߩ'rݹܵhۓ۽ۛX&6۫GoۄeF۠ E@9۴۞ۈ܍zywW7
8Ylހަ݅bݔ]xޔWݬ 8qyނvk_SPNބ޺7661,15I\ߏT:*.}%W <wur& w/13Kb|mw7n_QG W03	0f
@<8yeS_k !"#$%&'S((\))*^***3+++<,2,(,,++++B+**b*/*=*K***+O+Q+S+)+***#+T+++",^,W,O,,+++
,N,g,,J,,,+,.,,,+C+*N**)#*j**Y+n++5+**T*<*%***))+)((F'V&f%$%$####v#h#Y#I#!#"""""+#m###$0$0$/$$##$N$$$$%A%%%&W&u&&&&&4'''`((@))*V*f*v*****N+++$,E,e,P,;,,++Y++***~*a**)F)(5('z'L''''9(H(X(Q(J(L(O(Y(b(s((((((((c(3(('''''I((
)q))*_***$+:+Q+@+/+3+7+W+x+z+{++*)N)(N(!('''u'4'&B&%/%$Y$##A#"")"!!"! B EFNRUF7WLS	)bh.d nj@|F#:P>-|1CM

=
0
"
K
s
y

I

Bq0

u
#
	s		s#`V1AU
t  vFB[n<0@,+]i$e,p"4m.u,OEY
u.cDEs!b'] 9kߥCi
ݪm0ۜd۬Bو7؝vE׈;֡Rֽy6ԆL ԴauM$ѧmhЧIΑ`&͚H̄5˘I}ɀɞRǎM
ǰTŦ}U6ħ@Y3;fil%8IZJ:(
c|0 "a=9578gƾ̾ʾȾOJv;PÿxLɧ/)$z׆ّP4`}&sw2(sNk5O	TO	F					F



Eu8S`l
0
 
o<
 ^3
,
	E	Wq^R f 2 * W  WN+; ^OKF		


H6
_DP\PCe:iu/4:*q')+?>H#LyBYo9R1NuE

"@
|
4nNGAf0@'[OCQ`=

9#
({ &6G
e"y"r@j +ksyV3.)))'&*7EA=CI0` =	oOl~Ln[10|?6J n&tB




y
1
C[)

h
-

					;	L
r(z'>>f1P	 | 6 [MqUn'8F1>HOYxm)_L6 
T=&,2OncWRL.q-{Ik3|L&[%JuIn<T.y=Wi1D߷~/ޖLݢm7܆/ۋ=ڵhٌzhdaN:	آlXE)
+֨ysnbVC0+&Dbw֌hDT֌ֹ֣ a5؟;nppّٯ8WunfS>0 Rڂ!?KT^e8WxA
P{@ZxmgQ>\R		)
&#V7t!#$;&_&&&&'}''U(('&%$A$E$J$$$$$n$#H#"!&!l I)*I%HPY6UWr5h]G08Z|Zhv8w9o+ad1w02    !!l!!"#$%1&&|&\&:&&9&Y&&&A''' (<(x((((a(('|'+'&&&p&V&<&&%I%$P$####($$$)%\%\%]%Y%T%u%%%)&q&&&&&l&/&%%%&9&&&*'y''(p(((%))((:(''''{'^'&&%$#"""&"4"P"l"!}! tT3I_,u): #%m!/|O6!Z/|4o

:
U%B|

5oPO:8B^zvJ$->	`H
@
!9
z
 
	E	CPg18FD[, t + r9 Lf	o2d2!PP.Y% Hv1|L tQ.!k{\<Y?P	bkL2)8NaY߰Vݞ?wܰHtڡ:ر؏m9بK֎Kկu<ԆԲLҏ9ѓBЯm@Ͻ]xͣQ6̇0̫'˾UɐT
ȅDǟ}jWhxǖǳǈ]ǹƠƇƍƓƆxDŨŞŔũžŢŁU( #&Ķt3%S5Ĺ[7=gæ /Ā~ȳp\GGܹro,|@U"}pd~	P	
WVL7qv^E-"G
l




F
}


,
	r				c			)
3
>

			^	(	(	(	v		
i
q
y
=

	c	Z j  *OdF(-1w9FG! 8aoT;#Ef[$u*n	A
&r







^K]7 c"

4
f=Pc
)
Q
y



3p%rc-B"@]chb[=x`,
$

%
	v	;n"u5ce-   j D   E r   _>~Ml# z  yTQN?0#D{ U   B^C(_	
(=-

/V R6{3= V}\"1 iChMaRu+

Y

M6

N
		7	d`CMz8 F)N ^ hsHW0	pf]J7!rsuysoimp}]6o@GF(CY<} >[5P[HK"-4S~3n|4ޣe'ݲw=ܚ9s۹eـ*ٺJ׉Sֲև<դWԭ~=ӿӂN 9QhӽDԍԿ )CՋ9=ADHև0ך(Ov؜_٬ٮi$ؖcE'Q{خ3w8eڒڟګ3vݪ][PB$0fL	
 Nh	{
x#59 "#P%&'^((((((()!)()(5(''&^&V&N&J&F&&%%C%$8$##"c"X"M"Y"f"`"Y"M"@"B"D"s""")#w##$h$$$|$Z$$$###########b##"!b! { $  !}&Y:&TQ&bA bsUR)T{17	6Y0g !!P""#0#M#+#	#"""#<#q########$$ $&$,$-$.$5$=$8$2$"$$######1$b$$%x%%D&&&%'b''')(r((()))((V(
('''(?(d(b(`(@( (('''l'0'&Z&%o%%$($#"""=!Y gl2 uVMFwspbS4kHB;KZdnjfYL3}nhaO=
?nPO.TFEE=5CP{y(Jy2RD~!%
Z
x(
k

	r	$	GVSMFj% U ]R
:%r'(gK}G~8hP1_5nW9S	tR0Zq;I8vW@I.P6)fI9gI޶v2ݓ8hܯTړ.W؀حJ֓>ՆGԧUӈ?pMѰZ~6Ϥ}̨̹̳̠̊>pʡʿʊʭɋiɪ#Z2
ʰV:fɯD6(ɤɌtɝdʋʳʜʆnVXZʅʱ%
ʶvnfʋʱʧʵdː˻˽˿0ḫ6yͩ
;E% I֍X.fdF)b'{ eKa	
]
+_53h_{jYH
n	\wk

wA4]wtV3+EC




_

Xk[Jby\!
8
		|	j	X	F	W@U>I:s Bq 7mF i   3o	=JEC		E

	
3
u


"3443147:=AE,




p
e
Y
X
W
x


ZFLV}tly
%EftiPd[
A
 n
`
	s		'FWk*`.vPB4=EWh\P5$*&!            w [ G 2  {aO<"-\:  q+cw	
.d
$^,A/Gke:Mq[F%@q2xWE3(

}
@
fM"b4

R
		5	I n$e
v;.Xtw> C >T79GzgTA=8COD8tfTB2"i4rK^UT?5%{AO3u/n86VB^5M{-8FE'mjߴKs݌ܟ*۷EGs-׷׈E׽x[?JUK@զuՉգսչյ՚ՇՏսHb{ywֆ֖C׃ח׫עךפ׮M؉؝رطؼKٔ$Q~ڌښگ8~4kܢr*ދQ߆'a=u|e6yX|%Kr?
 !	

&:j_:b@cG,  n! ""#>$|$$$e$B$$)$3$d$$$$1$####
$/$U$$#u##"""###($T$J$A$W$m$$L%%\&}&&j&7&&%%%%%%~%<%$$$$$$%C%l%I%'%$n$$#x#;#""U"!l! a c:ix*vs1)P_n :CjJ>
bY  !!!r""+#O#s#t#u#########x#P#J#E#`#|#############$G$j$e$`$U$J$h$$$(%v%%%%%&"&>&u&&&$':'P':'#'''''3'N'^'o'['G''&&&&&&&&~&)&%|%#%$$7$##&#"N"!>!  .:/i~A90rX?l	H{CAy4~CPkDX:$.>Or.l$J:VZP6<]d
$W Vc
O
?9

t
C

		d	*	y.rgPsn(U/ R Ch4[/bnPO
Dy3mL+e6{J	Gn-`"oP)Qa(=^2[	{>PWx\+E
Y#v4KߤPުx"`ܫbJ3ܥIHف=صqؿ^֤Kկ_ղSԲM5Ҥ@ёE3!ІF%ϿϼϹϤώ{hxψϭ	

%>fЏЕЛЇt{ЂиJ-ДЎЉYѠѝњi9GTѯ	Mґҗҝґ҄ҫ6Ӛ#)0JdԺvXq֊boص`M_}ݐޑߑ= E ]bhnJ&# hZL\mf_		4

w7






NxC
+MpJ$
{
^
B


#~i0Mj>cny/

&

Y
z
Q
(
		Q	g#JfumeKTN[l			
h

k]
:
o


(AYm(<Wq2OV]ky)B\uJo&4BA?%f;oJ?sU
|
}<


L

		W		j;
}?qCPo1^%o9oH-  y 5  a3&Cl #   ' ?   4>~)*+!

 
ua_^l{{|skkkmoxteK0}[:$   a 4  lCxY;Oc1^&X$[/|aF-{FP3O[,p<d@q?
TpP0h'~V-sK,n2T) t?mA I|@PzO/i,gF%vHpM2߶ߝ߈rdVD2޸ކZ/ݹݪݛݚݘݫݾ
-G~޵;w߲NBL
WNdoM'  
X
{O"d8@HmE4M{
L0(\3[ i w Q + g@$~6v[r:h6^2qiaYQ^kh%*)r)`e8}	P( N u                    !L!{!!!!!"3"S""""#.#O#]#j#y####%$c$$$$%%*%9%G%Z%n%x%%p%_%5%%$$$a$:$$######`#>#"##"""Y""!U!  ? B.n)b7\4\VPp5|<Pt: Yl2v7]
K2

L
 
pO-"%$#
+>`
'
/
/
/
@
P
_
n
~




q
c
U
O
H
M
R
P
N
@
2

weYL0{I



~
]
=

										q	N	*		V\7l7XQU]y/  O  p(g)?7m7Uc<~BN[&j@b8hA}[:u`?nS7(I
Z5F Ut.`HE]Hk4wNZK&X0ߑtVC1|,݈W'ܩp6ۣۅoY&ڶyLُ^&؟؇p^L8$
׫׏׎׌ל׭׹׹׬ׇbC$(+Lmג׶D؊Pxٟ?چ=ۖ4x)[M>m1S,tc.vp#sB|"RtB ?9YRhs
8So{?OzZ@%,3>J5!q4"!o&FT'c3b#  s G &   e  bBt'>VSPC6AL~>v)R+!*BUilpqs,Jg	1	N	u				
6
W
x




)X	nG$




x
\
@

				h	:	
	Dw=}X:vP*~eL%~jM1f:Q"    { t m m m _ P H A G M d {         4s1e9pQ$Gi^#'-Cb
 TC3/,)&
 tkaQA&mIU |c6g7}S)   } d M C : -    jG6%xkaXH9&ga[^`\WC.
3G\enpqkecbho{*8DPYbipv}7Rm 7 a    (Mr
1]/Jf@k"Lu,Kg 7No$\	D	r			
N
\
l
n
p



Box(:?EHLbw

'
?
V
p








,Hj(Eap~q^SIQYaigd^WI;979:5/
reb^SI8'






t
c
F
)

}kY<^9"





u
R
/

					y	Z	6		pQ3tN)Z'fH)a/fJ/wL$z\>       x c J 1  lVK?6,!tfXJ=0~dI;-0334*~ 
%1CU`jklkjlnu}#4FWcox 
%5EWh}
  0 B U \ c d d i m }      '-15ALZhqz $0<CJLMU^q.=N_n}~v{xxy~xncZQLFB?:6-%{rmhc]XSLDA>3(}vohb^ZSMJHC>95-$
             | w z | z y m b V J F C C B = 8 5 3 - '    wkbXRMIE@:3+"
         
      RSRC         [remap]

importer="wav"
type="AudioStreamWAV"
uid="uid://dupifd26absym"
path="res://.godot/imported/u.wav-0319de16f2d3a10704b26f169729d427.sample"
             RSRC                    AudioStreamWAV                                                              resource_local_to_scene    resource_name    data    format 
   loop_mode    loop_begin 	   loop_end 	   mix_rate    stereo    tags    script           local://AudioStreamWAV_tsb2y 8         AudioStreamWAV          a                                             
  
           " % ' ) , . 0 3 5 8 : < > @ B D F H J M O Q T V X Z \ ^ ` b d f h j l m n m m m m m n p s u x y z z z y w w w x y { | | | z x w u u t s r q p n m l l l k i f b _ Z U S Q Q P N L G C = 6 1 , ( $ "         |tld\WRMIC=5.& |sj_UMEB>>=82)
 }xtokga[TLF?<84/*%	  
!)1<HQZZ[[\afpz	$-4:EO[g|#&):Jc| ( = Q Z c k s {       +5>??HQf{$4DVg|'2>J]o(=R[dimrx&2?KV^elrw}~

zl]PC;4.($ {vogWG6%
w_PA:3(
o^L?2%lP@0(!
     q ] I < / $  	 iQ8 sW:$nV>#	gN/{hT='rY=!qV:xaK.~m\B)lXMB=81)oaSC3!yoeUE9.*&'(%! ybYOX`mz~}yqiiiov~
"*2@M_q1H]s+C\r.Hg
">Yt:Ws'Jf)Y ,Dk:SlJy(Ou > e    3_/[(c
:dQ.jQ+c)	n			(
S
~



DU$
Q



%c"a?tF{P-V2c
E}6a%Vz :Zz>d0O`ppqh`_]itzkd\YVUUJ@(qaA!u^O?(wN%uS1nFkR7j;
lC|]=Z/_3\:


\

c;v@

k
9

			h	<		Lp:wFr:
}O HpGm<  { L  c8h:Qv[8h%qaD&~CsCT*~U5{fQ?-m:^2~zv~~Y5	wwwwwofF&}tlza@ 	 l^OLIHGDB90$
%/.,%")2:=A>;/# *48<<<?CLU^hlpw~)*+'"%(4?Sfw	
!/=Oaq.DLT^h;yF,b8I?'^I[g@|O_ \    /vn3B(q_t#w	M			
R


CW@


 =~J?f$ItBYp{S'uNsP.`(~I

P

|>5

$
	q	2	u*@8SIgw/|C  9 m1}?x:zS$i8\-g"zY7n0zGh6|X3U"lBh8rBqW8yU2mN-}sjU@u`E*
	%1@PSVKA5*7E`|A!=DJ]p't$Mi
IG:~5pGir72w@:Q<;*P  	zp$vhp		
 2!


O=Uw[MS(W@yQN+O}#l,JitCf &Lw{wsX2!%2.*[+i3rTE6']7rU=%dN84/,) u_I6"bD&`<a9vgXH7.%h;^C)~_@n;
?



l
J
)
k$jQ9

}
A

		p	K	2		qL(vDxKHg!QxL vH  I Q P/~W/,*
zf()*5@+y2zzytp/pj]25HwB(\:"	}J+
NKHtnhntKl'69<C:-~/xe87/'zE^.(#3C<5nTy(VS"d)4;B-i`Wajzw`I/4e|G
+;K7#7FUH;'
 3Mg 
$%&-4207>LZv,U}vj~H?cP$dt:4][54@y#ooJ1+]b"CD3}F 65)xlZAx	
v

@o
<=53~Q]rVN#y,%m'_ 9sGrAc [ qYA7-)$oC y4mL+TWzB
*j_(k1Z
gP9UZ+o8 saG-	lXC3#



s
J
!
].\




q
D

		B	 	KUeJ/	c}xtplO2lD`#s;   [ ' s'GR{LehnVXZLC9p
@EI{hBi'mdZ6u
\s9 x7rd9
^5\J8,l:k},	%
WkG$d${F	.--w,6KaD&gQ<737;.!n'@EJ
5~<ߩߨߦߛߐjE޾ޓނrއޜަޯޔxBݳݠݍݢݸݽݛVܣܞܙܨܷܫܠwMۣkK)/5KbegVE/	 #>BG!ڨړ~چڏښڥگڹڼڰډa8ٺ٣TٴbK3Vy؋؞}\زRּև֏ֻּ֘o!դլճ=֐	.?n#ؖ	قpjې3
2G^+H;Y[_vye(Jsj$DGq  		.

q~
P}ur2  !_"6#U$t%&'J((m));**+m+,,--.o..<///8000=11112"252>2G2C2@252+2111c1N191.1"101=1Y1v11111111111111111L110D0/{/Q/(//...G.-d-,W,+h+***)(C('&%/%l$##c"!0! ! @r4bXEW!
8l

2
#

#
2
$

qV)


	I	 	$Xa
P;		A



BqG
 t~(|
_4?Ip9irz
;/|aEB?

O
#
~P!p
$
		lfaSE$CI#X / ?Gb#gCU=h	t=0" Ui	 t]XS?, |Z.o0*Q
%<SB1	<oG|x}
K).~(c8
Zw"+e*W
=%6Fv	M>.`9" SzQ#
/E[l}s^5lSrKzDL"7l-~#D'
YRpB޶ޙTݻ
\ޮ&ߞB z76?HMSB=$d?\ x2
		
1U
,C,|,B 4!'""#$%&')G*c+,o-^.[/X012395679_:~;<=>>@AaBBCC$DDEErF,GGeHHIPIIII"JeJJKKLLMgM2MLLLKUKpKKKLKKhKJiJII&I:INIII0J~JJJJJAJIIdIII.I4I;I=I?IHH	HyGFuF,FEEEfE2EDD(DC9CBAAS@?>>u=<<K;i:9877X65%54 4d32$2100G/.-,++b*))('F'&%g%$$$$s$v$y$t$o$m$k$\$M$;$)$$$
$$ $####f#p#{#####q#U#W#Y#f#t#n#h#L#1##
#""Q""!!!!!"A"f""""#r###2$y$$4%|%%%%%%%&&&1'{'''')((%))?**4+++,5,>,G,!,+++,;,2,),++9+**-*))J)((d(('V'&=&%%$1$#D#")"! Z M{KY1@u|-s&pst
h

W	'~:IW=# !6RnsycMD;Yw*`Q='v*}TtFO߉*|$x#vܑۖD٥m5Za֜k:մՁOԩUӍe=Ҩҁ[*ў_itєѵѴѳѢёpO'ХЁ^E-
ϼϊ@ζvK͎ͪq6̥Nˍ:ʸʊb;ɸUlgƔ@ųdũ?ĵ*×p>&]oDʻIƺ{/@A㷄1ݶq3R쳳zòw*'&EeӲ𲸲X0
&=U'~P":SǱ<y˲ϲԲò߲#L۳N<)ϳ@ŴJ굊I͸R^1GK`B&͜?R{G	ߣGz|KFjFM]mXk%.		
9`vfT !#%'(*"+-,,-./13[56o89&;k<==>?j@TABBgC!DD0EtEEEEEEE%EDD"EEEEEEE@ELDVCBBAKA@2@?5?a>=V< ;988$7i65'54V4
43k3#32+2z1I0/c.-r-6-,,,+*{)#(&%$#""""!z! cUH>4_=6/_
I3

	N		rT7~V   _ -D %L		

-CQ[6AM{ Q!"r$&(t*E,-./012345778g9!::I;;	<\<<=o>U? @@AcB"CCuD
EE#FFdGGdHII7JJKSK/KKJ9J JIIIIJIIHH}GFFFE<EDC-CjBADA@Q@?!??>]=W<P;c:v987796w543310l/.,++C*)('&%$[#"!*07[d>
%
Tl $l>2t<6}-W>P.0w
~:߁=
޸u27;ޛy%T=%.^^0?OjY+|@ߊ.ߓ7xܟ<ڱ2ٲ&[֐թҊѕ)Ю3T6d̑J|
ǝ/ńŰ-27}ÿ4>IѾ:uU5t޼
̼ػ!a5ɸҸV&ϵCڶڶOõ9¶K,cL5﷪ӷ#E{`D:0*WHҽ"rž@ŀaG͌lM%ܸr
 &ge
.lR) "$$%&'c)++|-/14526F6Y666389;=6@BDFH<IIJ<KKWMNPuRSnUUgVVVWXZ\^&abd,fgh5jk(mnopq+rrrrsDsessss[s.sr}r-rqqqqqqrqqpkomcl|kjjiihgfePdLcHbta`_Y_.___,_:_I_^^q]\\([Y&YXXWWWVUTSaREQ(PWONMhMMLLL3LKK(JHGMFDCBA@?>=<;":8o765&544o44321]0.-U,++++**Y*))[(('6(())z*C+,,p--.(...=.v.//*000F1123456s7.88z9:;=Z?*ABD EhEEEEEFFGHIJK.LLLLrLDLhLL<MMN
PPQzQZQPPOOOCPPMQQQQ%RLRsRRRR}RRRRISSS\SRFRLQRPJOBNcMLKJIHH%GcFEDCOB@?>	=<;:@:986w4W2#0-O,*)y(s'n&%#!4 J`pENVX
Z"Gp.pn_# h+OهCҿѷСϋhEDCʋ"qǚ-pLھWtg黽лgź$ڸzXܸ˸wfVnظ)7vqk2ƹڹh!ɻ
$:CL&p⾻6׽Ž=ge3ȽqS	;O	X|vٳ=K}ۮ8ج.g9{^vߢt
Iٝ-"ÛB8}ØXٖXǕGǔ_=ܒ|]?:5&ޑQАΐ	.eđ`O;ÑA-דS_=Ηpә#&,ў2ߣI6+(|鮃걶_;#ĸ̹Ѻb"&Q(fɍN˅̽"ЈҪb	ug# 	uS#0>=;M
3-o~w     V!!:""<##s$!%{%%Z&&'(e)C*6+,,,-|.N/z012l3c3Z32&21f1M161B1O110/.-,E,+A+*+(+*e*u)(w'h&=%$ #."! (9su3r<$-OqJ$UznG |C7![?^}k

"
&
N{
	-o	&	<	`5	v/ygTi~		
r]

y+vK7ONNY* o!6"$""2"R"\#e$<&()+
-8..?//A011234567	9]:;<O===>>?ApBCEETFCF2FEEfEEEDWEEGFF%G}GGGGG`G4GGFFFoF3FEED
DBcA?=[<:Y:9999@97643C2q1112L2$1/,.\,*u)_(J'O&T%\$d#"!4!z V:!,Synb>
4
;
	N=d Q  0oV=-!8O
Gc &J@7@!OdynbXNe} G?8R2&fQK---#!@_sX>EL8#:mpL(TS%E\qr_LsהrO5 Lw&d̡]((\@zó®Ͼ
J0>A빕j@㸅PWԶd޵`ų-ش
=2'
VԳ2`vuk̶gw57:Pf6wM"jg'9LȮIwKRυφχI@pџiTӾӥ|ӐӤսחR
Vޟd*}`D(ep^#|
`$iR!$s(+.v0#2L2u21y1"22
5Q795<z=>>Q>K=D<<;<=?/A!CEF&HHIIII^IIyJ0LMgOPtQRkRRS4TUVVWYKZ[]_``-a\`_^]]]t^%__`\`_^]\[Z$ZZZfZZZZ`ZYX`WUSRR1R[RuRRQ?Q)PO:NbM*MLLtLLKL~L8MMRNNNcN{MLKKKJK(KKKnKGK!KrJIHHfGFYFEF9FF"GFFrETDBA@?x?T?H?<?>>2=J<K;L:|98c8888]999j987U766778;8s8y8~8}8|88/99:;D<<V==>G?@A8BBCLDDEEEEEEE=FF H*IIJJJJRJ`JnJKLNO=PPPQP}PPPhQ$RSThVWX ZZ[:[`[[:\\k]]|^^^a^]J]\\}[
[Z<ZYYDYXXXWWmVnUpTXSARQONMwLLKJH`GED!B?=;:	98r765420.,.+)(I('a']&Y%#!T^y5nB
}	X4!J _,[%uL$`,oޱ-fءךגlF֑Րg=6.Ә7ӥҤ5GчѺѵыxexыrY ѧ*ЭEέsgO7͸w6
.RVY%̧\&
6s̯̯̕}~̝̻̣u̓*ʋU1
tLȟnqxÄU˾߽f׻uqѹɸ·ô~OsE)5]O^ǡ0ĠX*˟7rϜF<Gә2瘰z0ϖ7ΗfĘ&8UӛPĜ7vݟbǡ}Qy[}:q$׫o{aѮh Iñ=mԴH!-d
mи.dbؼf*׿R @_ĕ3ɝ̪M]l2߳U_jH5b^Yd|C m ~6=	^
~sh





]
i
t
S2R.fh)v aZ #!!8""#H$%%Y&&&&
&O%$)$$##1#"!!A FKO/f34ua:FSwQ?hlHk'_f:/F,(>JV63H
=
H9

e



"Q
2
H


7*7BNZ4W _Af|tE@iFo^g o!1""#_$~%&#()+b,$--G..P//&1U2305Y67r8c9*::;<=>@@ACDEFFGF$FEGEKEOEE1FFdGGG:GFEDCCBBAAN@?F><[;9-865b43`322G1z0//.g.*.-e-,%,o+*'*)I)('&%$t#"! ! Aa{+lri{hC
[E.
2	5sMC c 3  9
U	vkanz}b7^C(.G}Z91}E
&p f*{;eRT\~9g/NNV4|`ݽ݃Jݮ(>*	8f#ӧ+Ҝ
=mτΛZ˘UʀʅɫcÂJþj#<U齡X;eǻ*	B縌.ϷH"Ҷ}PG?fԶc^
PʹP<ֻOUiR;CLtƟǘȴV<ʞ I˒˧˽:̅̀{9@MZDҞP՘/֋Vׇ׹M#cݺJ$OzM ^*\	4

j	r* $  !7"Z#
%&(v*+e-b._//0	0/0d12d456U77d7766798693:^;<=&?H@jABBB+CqCCDEF>H2I'JeJJJKKzLMNsOaPQQJRRSTTSeSR6RQnQ@QJQUQP6PPOjNMLkLK\KJnJJIIxI>IHGFEDC|CZCCCCCyC!CBAAiAAAAAAAAB.B[BtBBcB7BAKA%A AA4AA@t@
@?0?>>>|=</<;;:::d:9t98*8q766i544]4.44333=32f211111222222W22111w2234a4444.5k55W66C778o889?9Z9u9e9T9M9E9D9C9988888888888889j9D:;W<=>o???l??*???,@A4BQCC}DLDDfCBBAAABCDEnF+GGGHJHwHHH!IuIIIJII'IHGFEDCBZBAAAAA
A@d?;><s;3:887K6}5}4}3a2D1/.R-+*~)('U'&&a%;$#r!H+io
h
j
		<[PEs `(Gb@^?k
6Gx` gy<nCߖf6,"	ޟN^܇Bۙ\۵KOp4$׷ׁKֹր0Ո1ԸԔq9ԪRҚb*ьTЊzKGgY˪@ɄmǶTpW"ÄT(pUȼ6F縖DC޶B6 rЯ$xӭ.4Ū{0(ڧ}V
Pؤ]N?O]YS,5r)wť
UԦL'Lū=Rϭ.Vְ =[رuzQt2Ըv#4r<Ȼb
^ڿGN>lJŲƞ!]eəRͨycQUqۍ9Q-=N	bvN  @uT("
l	
r2>'zH%7   $!m!!!!!!^!! D DLtW|7>}v*hWZhvspkfqL{' ~

j999L`(
~

+=94Vw#`Nn$6]5q<9r s`K [!)#$&(@*+-B.$/0012445G66W66D543D3e33`4:567D777654@43-32n22161y0/.P-+*)k('['>'!''
'&T&%$#"@"!i!0!3!6!
! S Ae	)Gd?FVfJ.
U
h	d`oHgh@ > ep>fW(=Q9TH<k#mD~I/C,j6|ApY"Cdu}srq~_?|l5Mha?Xxb%x	`TG|MvxGPm`ھ3gjկDTN]Ў0Ϫe!ϱBΙl˜Qʕʝ(ɳs4'^Ȳ6ggglqɖɺSʍV˾&1; O +ЋЏДѬU9ԹUՅմթ՞թ`dhٖڜڢڴ1ۜMܢEޝF2yߥ_t;kay>lR8 	3]Z	NK(1#H|E4
6 k]J	|

p			
$y3; !"n#?$%%F&&''+(()`*++,D,r,,,X--f./0#1u2345506a6617789U::/;h;;;<^<<;==N>>?7@@`AA1BBBBxB_BGB.B*B&BBBAAA@O@???????%@W@c@o@9@@?e?]?U?p??????.@]@@@
A2AKAeA}AAA0BBB"C\CNC@CB|BBAAVAMAEAA@e@?h?>>*>==u=2=<<*<;I;:Y:99@9(9988W877V7,77666y6h6W6J6<6.6 6	6555v5S595555554444444~4q4c4N49424+4:4I4I4H443W322E2-2222 2-262@222$2 22 2%2R222,335445t6G788^99J::;K<|=>?AA5BAA4A@_@@J@z@@A5AMA@@@?>m>	>=f=&=<<Z<<};:::9.8"76444322|1009/-,+)g(4'&&%%$_$P#@"!%P5,{VxZ/sz

n	!:jCY pv}h]D0x&i?Og?]CXo
:bfp5zR;
߬߄[ގNݠf(ܥܢܞ܍|Mۓe6(	ڶڐjL- ٠r,ؔBשׇY+](ՋәD2 ҥNҺ&Ѧ&ϛ`!`͟̕c1	ʀ!ʅ/uǽ}Ĵs^Ig[Unhbzy?)W>$Vܼc

˻l
YbkVϻIYhdpȻ66BM8#CcӽC侅}O?vº/ê&ļSŧţłƴǓqɣ^Coɐ2[/~͌ͅ|lͫ͌/ϗ iюѴ aҡӍ2_T=%
aֶHa5ؤMٱ"ړۍhܞܾ9ݳݔt-)}Y wJ1Mh<fISu-R!_"~5 c?RM		
t3y
aa U9~#*e_u  r!!!!"p""b##$%_%%%%%%9&&&Z''''''''''(m((()e)))))h)A))((((((|(I((''|''''''(((''W''&&l&P&B&5&&%%l%%$$O$:$$$1$=$,$$###b#6#
#""f"!"!y!#!  S ,  i&o"h A.
d&MnK8%_$yupaQ2}xs\E}T+b)OB{'ON,

[

^?


	[		3>UDK?e > ,/*7f~
,s_:~,RJHKg4p3vX:|P*u[A-~rekptxeR"}xjVA2#).//..&)49?IT^iun\TL^o5bxrW+ 8{.C}v%e@@vRVYT|n]KRXdIyyDYnHBYq2{,E[:6Zs]6s"v:D\t>1)
e
\ u  V=tNS,Qw&!	(	J			v

^;Xz
^7vaU<|,XOkj#`XD]/tQ  !!" "#"4"E""## $$$.%o%%%$&j&&&&'\''''1(((G)))**2*J*c***Z++S,,-I-+-
-,,,,:--B...!/
/.../1/i///&0\000001111111/1S1112<2<2<22111111-2L2j2V2C2211y1\1?1P1`1w11w1a1,10000000l0E0+000///x/+/.y.G...-----y-D-,,,+U+	+*****l**)R) )(((b(=(('''O''&&Y&
&%}%8%%$$$$^$$##)#""v"K""!!f! !  = J`&:=Xd-m0w1eR?S{r)OVA+~+

*
}'v

/
	f		=!i9Dd}/b"  C N4yPZe}9amKl1t0TCKGjg:
S`2n?SkL/]2Y0T&tkrxoe=xoe^WQLHECA4'+7CN[hkokfff|(E]v 7IZckryxxrlf`diwcBXnL{4xlaUUUsfS@Re5|<^1FWifdWIMQex8\@y,EJOSVbly =Zox0CUgx|nf^n}+Jk.@N]jw %/25=EJOSX]bjruxz}
;Vy5H\l}#-5>Rg-Lk;Tl6Pk$5GXr#4FMT^h{.Kby2H^u#6HT`ly"A`   7 M a t                   &38<=?CGQZhv0IWehjgcfhs~(1BTj	
"1AP`s|zxtpoolihgijpv{~|sj`UF7&xtojd]VQLHDA><;>AEIHG:-         
      RSRC [remap]

importer="wav"
type="AudioStreamWAV"
uid="uid://8dkvyt3ck203"
path="res://.godot/imported/v.wav-d824f3540748ce5959c55ee8a1063b54.sample"
              RSRC                    AudioStreamWAV                                                              resource_local_to_scene    resource_name    data    format 
   loop_mode    loop_begin 	   loop_end 	   mix_rate    stereo    tags    script           local://AudioStreamWAV_c0ioa 8         AudioStreamWAV          JX                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   $ / : E Q ] j w          #5GZm'=Tj+E^w0Je#>Yu4Ni :Rk"7K_s		 	,	7	A	J	S	Z	a	e	i	k	m	n	o	m	j	e	`	Y	Q	I	@	5	*			jU?(v[?"}bG-iR=&v_I1kQ6oP1`:   k B  vJ`2zKW$PNw@
j6d/W"Kt=^'Ot<`-Z!xAn4Pu>b-_*W"V$U!R!`/l>P mCtJ!ߪ߃_;ޱޗ|dK3ݹݭݡݙݒ݉݁~{݂݈ݙݪ%Gjޛ-U|ߪE_IkPC4
)=Kr
:i<w9Z*}!YQ <n"It+I		c

~
)

2&h> tH
p/<ELJ2&w c   /!l!!!"L"""" #R#y####$H$v$$$$%%5%N%k%%%%%%%%%%%%%%%%%%%%%u%W%:%%$$$$^$/$ $##c#-#""w"8"!!x!3!  E A9"]-`%4DJPWWPPSO
I
HS
[
	_	hx1MjF r 
 I-wf_
io|+Dk&WH=|?H	Od+Ro3f4n:
|N tIhE&rZD-wgXIA:86<BFIJKRYfs$>Yu2V~6Sq	4^,Y8]%Nq8a&9Ml(=Sj*>Rey4L`u1Kg7Rp<Zq	/Ts%<Rk'<M^jv  xiVB0nT:)v`I4
r\C+oXA+p_NB5,"&8Qi'JhAnG+f"]K`=)>\o2   _w;hAv[C		!


`,g

L/cFLf.?j>l';BKP   P!!!C""";###-$}$$%\%%%$&e&&&)'k'''"(\((()M))))%*Q*~*** +-+W++++++",G,g,,,,,,- -/->-H-R-[-d-i-n-s-x-r-m-c-Y-P-H-:-,--
-,,,,,,[,6,,+++k+F++***M*
*))S))((E(''Z''&b&
&%_%%$Q$##9#""*"!q!! T 6'-~"w.Sa
{:{7|C
c+a/nDsI&kAnL'hK/hH)




f
G
)

pU;eI-





s
X
<
!

					z	`	G	/		jS='fP:*mS@-eL2rX=%
}^=e<}S*    X , vIi=c2yN"d4a7h7xGS%l>d6vC]1{J]5
Mc6Z0l:V*rA~P!wGY'i9
d6c6
g;nA^6{U.oL/߷ߕrM-
޻ެޚއxjc][Y[]bhwޅޥ!:Zz߰"]*\LHm+ZLG5"DVkCE(tQ;H; )p^]@e		
5-

^?csy$

pKxD  !!!R""#X##
$k$$&%|%%#&s&&
'['''#(Z((()C)))*4*e**** +K+w++++++,+,C,N,X,X,X,Y,Y,],a,],Y,L,>,3,(,,,+++]+0++**z*I**)):)((P(('_''&C&%}%%$.$#5#"@"!a! q jU@*
hN3"'6AOd~
*
X
=/
x
'
		;	n*h){B_/q>{G{J_1   q K $ ~U,[5ycA ufWG.}dR?6.#}pg^L9%uhUB.}obU=$z_E3!lWB,kR8_H1!pK,`>|kZB+
lWB+{\= vY?%oL)mM,	lI*pT(b;iAyO%^9T!oGLpJ$`*]*߿ߍ[$޷ށMݰyB
ܣo;ۘa*ڰ{E٪v=؂A ׅI֗\"ՉQԧq;ӧvEҧtDѫ{JЕkBϡπcE)ζΝ΅mUH:0'""/<AFKO[gxΉΝα2WϑaУ!]ѤJҪs0ԌHը	k^ׁٲ?Zۃhi^	m&P	wN$UxKuM%vT2  i8
f5		
M 

g0~E	;C\sf  X!!"M##$4%%[&&`''[((j))*++,v,,U-->..3//000\11,222:333$4n44	5X555@6667=7v7777#8L8u8888889 939H9]9j9w9n9f9X9J9D9>9,99888b8'877v7A7766V665r554^433E32t22110/d/.a.-i-,h,+m+*|*)r)(G(''&%w%$i$#S#">"!:! L n;x=m
`t$@u6W'b*oP<({hWF1{qg^UH;,
'*-)&(+5>EKFA?=Pctzsy}w}}mgadhebRC6(
vnfN6s\7~R%M


;
f(b
f

	h		h?x\
I~  -Fm(0;iY&\\iL?]vEtImRE8#_8eDyHa8Ov=Ad&g Db+<߬aސOݵ݇Sܢh. ۥyO&ںڒWٙe1
ؘa)״JփAոՎVԛOԱ^
ӽBr pмZΟE	͙fy~5ʙFɝa%ȵu5Ǜq;Ɖc=)śsZ@\xůAbƃƥ,UǤoosʆy;Ϗf=0# ֐H ٳXߡ0u)bP*Pb \R9	
3
_L\6Wz !"#$&A'`()q*d+*,,-v.J/0 1123h40556>77[88^99r:;;-<<&===U>>.??@k@@"AAAgBBHCCCCD	DDD:DZDDDD
E+EKE]EoEjEfEWEIEMEQEiEEEEpEFEDDhDDCC1CBBeB/BAA`A@n@?8?>=k=<q<;s;:.:t9876605O4322_10//5.-,*)('&%$$#7"6!6 sW[_ugH@8
Nd
		iaB Q C=%u&cD%p2~iqx*E`a1Mv
UGNr'fg L    Ao.t<u7iLR9~(_+	w		
s

0Y
J

	L9eW+W;g%d
1T\eN7afo$?*!U7

~&u
		m?|$a  O.f3c6<zGzma,
b4Gkq[HLmޮW
ݾiܝ&ۑr؂ׅ>֐(֣ՕԧAҋSѣ'Ѭ(Ф8y$͍8̆)c˞<ɋ;ȊTǋAƣX
}BĻďc&èh.k>$
F{U/ۿQξLl<	׼^"滮v=c׹MOзR򶒶]'򵽵k1@粎Uر(=Iծ~(߭=wH
Ҫp-ꩋ,ͨn=ѧGɦ/<JYhowȧBW KŪoSЬNԭ[s]F.*>^߽?|s;fȋ̵Z)Ұhؼٕm{߈pL;*`x 
xKqPW!^#%&6()6+,.s0A2457_89;\<=0?@A"CaDEFG(I#JKKLMNOPQRSSS]TTU:VVlWWiXXdYY[ZZ [0[D[Y[[[/\\\\p\4\[[m[F[7['[ZZZiZHZ&ZYY1YX0XWhW$WVVxVV{UT%TqSRRQPUPO6ONNMLLK)JIIjHG%GFE*E]DZCXBZA\@|?>=<;;8:Y9876543210%0Z/.-,+*)
)%(2'2&4%=$G#k"! 
 FE(AjhCY2 Q343B_x6  r!""#v$F%&&s'((l)$**+i,'--.2//`00t1
22>3345556C77Y88/999j::a;;><<=`==>M>>>>#?U????.@b@w@@@@{@q@j@a@[@S@^@h@z@@s@[@@?w??>>Y>>=f=<b<;%;:9N98876b65.5}432+2O1r0/.--3,X+x*)('&&%$"! ;SiqxsmwOC|
	@
	[	7
uRABJa  7 *ln#qG$t6wD)T^@#	c<oXA*zdMNNRVF6oEZ}*E w%cmaT7KVCzX
D}ݪ
!/=_ՀԢ"898:<fʐMǁƪ.dWZ<չ'r߶K0 
 W+Үy(׭OҬ[0ث˫ʫ׫̫hEs+aۯVѰMʱd	;㶋*ɸpźrżj&ſc
l)í7>ƻVȓɧʻ$T[2	ޮe@(Teu,KA 7	mE&M t"W$;&()+-/135>787:;<=>?@ABCDFFWG~GGGGGGGH=HcH_H[HUHPH)HHGGF1FEhEEDFDCECBA@A@??M>= =<L<;;A;:!:l987_766x6|66p6_616655Z554>44333333210E0/.C.-.-,g,+++y*)('&%$=$#"<"h! a>VOGlo6

C	vieYq_?wPbz	`
F"
E<{*S  !>"t#$&^'()*+},9--.0//{0!11K22c33L445U555<66
7n778L8^8q8|8888888888888r8P8-888 818k8889988}8S8*8I8i88
9i99:O::9Z98r8888K8888`8877_654G43X332262u10g/., +)('&&b%$#h"%!
eX<X
F
xmx ~yQ)	kHrc?9{3)4J]pg^3$XjZ*>y3^I3~zAHPm|n_2<2EY*0Tysl2E@/]Yunݼ܉d?DI^scRҼFXp_Pm㭨mU<6q'h5]ҙd5חx qm$ܓM=-.ȏb3̍a~sQ9 t[omۂIׁf*Ҁ݀ǀԀ%jz9fpMPҔǘߙ	3`ڠѡǢ_(Ŧj:Whݬ5Z̮><ఄ5沅#Ǵk96eAxk^H2̮o1:D֝Oݧ$QVdm`S
,tqu
 "$C':)2+,./G123578s:;!==>>K??@@@iAA=BBBC(C9CCBeB BAAAAAAdA.A@@2@??'?>a>0>=>8>:>=>>=k==<<=S==b>>?"@@6AAABBtBBC[CCeDDPEZEdE'EDD4DCCECCBBoBMB BA~AAO@?>=<7<;:3:v98765F4210.v-z,+*)(	(&%$#"! ( !/G3$nGn  h!9"##$%&')C*s+{,-y.h/F0$123<4^5678:;)<%= >>?@dAJB.CDDEEFFFFFFFFFFFFFFFFF`F;FFEEEEE|E[E#EDDDSD*DCCrC1CCBBBBBBBBlB`BQBcBtBBB.CwCCCCqCCBBoB]BQBJBBBBAA5A@?Z?>G>==4=<<3<;::87P643210%0b/o.-M,+)(o'R&p%$#,#s"! W/-?pV<,!syjE-P$j N0Hb}^8:Nca_v'f>@B=*.2RjrT0V|t\9
nfA
7
vT
	0	X g*AWNEIK{ XIGcIt#TI݇]ڣ,fӓ:ѓ$aΗ#r_ɄɵKdRDŻGqÖ&¸Ja)迩Sξ'Xqc ϾjV'ݼL黅@
BxڻлƻuM*&I}"Oɻe˽Y׿O{"ä*fĢħĴ;ŖƆq*QsdU2"UȈȟȿ9ɚʵ.΋(ҌR
q޺zJ[FCA
0DYtg^!#$&8'a(D)0**+,-./u0^11x222a242111^13110000000000000	1-1N1~11111a1\1T1112i222/3u3333333C44F55n66f77=88859g999999u9998Z87A7~6543210
0W/.-P-,+*)('{&U%]$i#"!*!w J{G|8;kR7Us2{[?J !S""#F$$e%%n&&'((g))}**'+N+u++++++++++t+K+"++*****+%+9+P+S+V+G+<+)++**x*0*){)-)(((((	)>)))*K***R++,y,,3---M../Z//0f001p112G222L33444433;32h2	21r110;0//m.-,++Z*)(L('&%$#x"H! R*T{47
,
!
*
	pgBM
Qs6X t }K64x ChS'`V}uxYs(C{C+GxQOWXz+)(
9{'T}+T~װ;iӞ>_πΡͼdʮZȾ)ǌEŠ	ryBξ_;x8vܵNO KuԬ \רI|ڤY_ӟ1\xƛw(Кm=ј5ڗ͗]!㖰Ɩ	 :_{sWLJpǗ"HgΘAgՙ*њCk%wmYȟ0<袱z*ݥ^YͧWp'S(rЭKǮi°gѱF˲KcԴYݵ?Q
'Ÿq$߾GÓU̘6Q>,Mq J <b!hm?l ,"$	&'){+-
.//"00i1T2@3G4F566t77787S76=6 65e66O77.8889(9E9@9:999:t;g<Y==6>,>!>>=>9>>/?@AABtCCCCCCD+DDDiEEFxGHHIII)I	IHHHHHH|HfHHGFE=DBA?~>{=<r<;E;^:x9W86754N32+1P0////..j-,+!+{**)t)F)U)h))))))w)))))X**f+
,,-.a//0$11g2#3"4 526D7:8/99::J;d;;;<<&==M>>>>>>n>#>=}==<<<<V<&<;t;;:p:#:99999%:b:::::c:%:999u9e9999::::;;;;N<<=B>>?G@@=AAAPBBBZCCDEEFFgGGH$H3HHGGGGGGGG<GFEDCCSBAhA7AA@@B@??6>=<;:N9887<76`65C5433E210H0/U/...- -,+[+*N*
*)))*&***)l)((('5'&w&%&%e%$Q$##w"!c! a RF,\p`Uc}	j4?JevqkEz2n@w/0~e'RUW3 B@

w)~
	e	:cZ 2 ?Y}W#bq+ 	&,L	6e	MW@dO7ߠEݏ4iٴ gG3բDӡј&оРq/ϔ2g͏Z-
̜wD|˳WɲufE3 Z_NśrŁőśűŉaźm"{mŃœ|eZQpŐ<Fk.]ɐʠ%˛]Ійaѩ04ӥӡrN*/-fӟYyёсq\J Ќ%ЙϜ'͹ͦ͌wbYL@4̃>AḢ7͍͵ΆRӧVڑ܁qF[JzG9L	c
g
 diiC'j;>   !6!c!!!!!?"|"",###0$$$1%%&&X'_(e)*+,-;..H//0t123456'777?889u99v::1;G;^;X;U;};;
<t<<+=-=&=<|<)<;;;;;Y;;L:}9F875432:210/.-,]+U*K)(''
'&?&%<%$$#X#W#W#w#########$T$$$$$$2$####/$$$$%$$$$(%w%&&F''''g'&m&%%%%%%%(%$$##"~"Q";"*"!!
!| X0H !!"[#$$%s%%M&&'{(n)a*/++,
---.g/e0a1'22<3334405.6-789k99999999D::::n:987655.432S21020C/T.O-J,F+C*J)P(V'\&a%f$#"!"}!  $BnI~
q;k

Gp
	xVCz %"Ib{ol~|Q'Cm.hJ+;JHG
FA?q'Gl6CK5 Wg@!wYdKv
s7wݸ3ܲRږFُٗq8՟Dտ:Լ7Ҡa"ұ?ѹ:σH΢E͆ͧ2Oʒ?ɀoWƝ*x\4T|ʻ2p)_ĴD̰DJv
d&髵M檵md[b[M>1'.Q}>GQ=$#Lt}{Hתd5שél-jIIJi|jwɨbalٯL?ɱ7鳚gе?z=ĹR49}L{qG_QC."һ|dK"ĺeUrHf.|mJqR+ùİȲt6*HΌєDպ|T,)Vs	
{Gw!~$z u!2""#z$D%%&''(x)0**+$,,F--t.//0W1&223n45566y7&881992::_;<<=>>>,?G?f???
@@AAA2B4B6B#BBAAAAAA4BBBBBBBBBBBBBB1BAA(A@e@?t?>o>=U=<A<;c; ;:::::\:):
:999999::
:999999999999999v9Z9299
99919C9D9H999)989S9999$:.:9:*:::::
:999}9498888|8888888888888N999P:::;#<p=>@oB'DEFGkHHIBJUK[LMNO:PRPjP@PPOO8PP<QQRaSSDTZToTiTbTTSISR RQ!QPPPPONML[KJHGF,FxEDDBA@q?C>=<	;M:99887606E5[4322x1*100a0/m/.1.-,e,+s+*t*)C)(''z&%O%$2$#";"! n 	 Q5Uo$1!JK{

\&XF3:>??(

r
7



)
J
k
u
x
Z
<

		>		>n@cXB	 K 2R Swvu,6tbmG)^-UDy3Zi>L`$g=Mq=
bA
ujy}umKKsHIzW%pJ)((Dn.`.4:;J[k'.6>Ld}$Eg3NiyAs/4>I]cltnn]M@@Xq#>Po&2A\~9qY-u=\Z4aK`)Dk)Wt1c)>]|N=og$0 k    .g[ma
[?z9`c	C	i				/
f



:`9c
4
^



"ZD{W+p,`1^.Zs"Uqkhu ),/2444;AZtfI[+t;3~J~$|-uHp

K
1

h?3'3?FQA0
fL)




u
D

		w	Q	7			d6	{KTe<_-a+j>kVB/    j F ! hK,
r?\!lM"_-c+~@uL!RuO)u^A&rR'xP.rT6!	Uq8\+|[;x?PlP3[3a5o[E4#
l:~]<xX9m@*vk_OA0||{||}nf_\ZWTSSRPJC<43110/, 

*3<AGKNPPTW\^_`cfkq{+:Obu.F`o}	3Le!1B[u9Z|)Hf'?Xx
-8CZp=a;_3Ry/a-U|.Jp)]$Af;[{&[7Rl.]4e9i%W#4Tt]>^Bk0\+Qw 2 _    )BUg%\           
      RSRC [remap]

importer="wav"
type="AudioStreamWAV"
uid="uid://b4hbssq332ggd"
path="res://.godot/imported/w.wav-3ee56d145451a3038a85bc6d7d1aa6bc.sample"
             RSRC                    AudioStreamWAV                                                              resource_local_to_scene    resource_name    data    format 
   loop_mode    loop_begin 	   loop_end 	   mix_rate    stereo    tags    script           local://AudioStreamWAV_dey3i 8         AudioStreamWAV          nh                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                ! ( % "      8 Q m    u ] X R i        w ^ J 4 0 + 7 D ? :  ``_tt^"(YOE%<g ' H k u  t h s ~   Ohp^  E l  3<- +    9f=    ? 6 $&%  @
  C ( 
 H   sSV[ru_d*K/R    S   &  Y }`r ;   v   Z; . M l  N#[16d f R lheK1 ~  r ]-S  E   K?~5 S4( S Ip0G _p]8 1k .0e
,U @ FNq^H3A]y7[zA(*uT`	m

0!
		O EHqi3U	
3	 [qa9	E	P	B1Tu  jot`P'3&^+h*W
	Ah  (=S	* U |C	1/ k>!t ,x
Ml Vzl]Q lAv;&c CtC	d?D 'W m<YS,k|OT[aN=BG~FSa_UJ< ]~|{N
-p l J{ R(v`z =^XR6bydC/t 
X8bS ,! 5m
 Zv-J _ h _o=Zw`!Ij @ F utCIP.&d#U;![  SY:w(pI:S QS=(Ru7#!4K_EIM\ {f::6n $ G3yBm7ZDy H -~j! m9t4:^ $cjm=d7QOCDB@2T@-*r= 9 krx^C(-N`r[D1 Hp9.HzrKfp`b|9OekqN*sJ]B'xbLPC6o  7  	-wnez`+ Vh %* /G_]\B(WC N   8lSkE^(Ms


-O) /e n#&t[zk TnAH/! s"A>; _P>(<~@t}    6bmI$f M+uT ,6z
=nG!e& )3u?t"3\jo E_+;W" S _n |z3UX(k4 Q j- F
 8pt	v jA csL3	| v(sFPg$e  H  {&Oqr LZpsu{ /\@jX`*! Bq59tYw77b0 pMq[e ~ICU+'1*;UohQC `:M G D8OJ[ .[=&ghl8V  Q8AY+ vo[  ga n  )T z: PHSkin# }=j( ]?R$M'dT /~ F  zDB

^1%  {<[>  4#  X\t] _ Z vv~  0,x\z6R})C r	"vI:@1  (E 4Q{q.OpGz=V[#{  W; ,	e # 
875~_Bd?q`Kc" }  jv4/f) ^ `+ Pt<#Ba`^ !0|d L~s]co| o\H:+F;+ _	
 *6~ N
=
_BiM2 &3na`{R'	U
	c,4q R3Ka\WhyHHxK;FQ)39>  5U#2@
<'Y + o	*BhF ?f +j(Q	vPS d	D#J&\`  *8H21 K TS	P
K o = 5.	8	 $i[M-t RE9aY	R
NKlx
1~
jWUT 7s%`k w]BR%
 X>.d:/ +#Pg }K[k~F0dSq.U'CV iq ueZu hY /
zWE !l5oRSU
	s+p h!)m}dKr$W:*Ss	& 
7	z>Um: Wgr.n   b  {(t2!E	qSPz&  sz hAc#z  R  L lif*x}nY 	>	;9 	f|>jc>9qD F )s U> ;l9M%6|" 
Sl1mb-	|
	SWR c1jD#b 38>D UU Uf H-
#
4
TyY _ \4Ta  RLG6{!P~]xW N`q hChnH9CN~e}f X |.@\M. Im/< x-+_  ?} iv Ke @ * 
.XPj +TA/U{ q2 Kw 
?wfV3AZVt>xx?0	_ gVr  ?[)K5wNl@ %Uxo N d$wlk 1@M$ s &I[qF n

_\?p)	l 	1H"aB !EA  .))4C"UHfYQ6 O &\+Q<	Wc!~ K	oQ*M eH  P cT Hq 7MaVtz~W+1 \OF
  
 "h	 /UC/  }}$@ j (,l ,J  YM7p d V ZYw9Z	mqc\WK9 4 ( (t8|O  lZAO-:g *U P	MEiYON6 G //ZH4}_x(wZOD x* v 1 S N y > 	1
^D|Hn*}!Y(j@dQ pnk \ uSNB06+ jj g = )k ^
v

Z U}&B^8GIKO l w!l @8]L oKO  PTY AVkuD		
8fyN  8{[ s
zq[T=&# 6K_hB
	&ESaL7:=2q |G/ )

#oSR`}S#Dd	]	U	mK]6"R :*			.A:5( j a=.$V&l"A
b
TG;/Nm" Xdda0
W"dP=AF$kW=RRS8`,'B ZN-aG_d7eZN


/bP
r
[ ,S]}(c]	Jx
DkK[6K` p+~ $ ` a  9B
dF.'< =N^Ctu*c(}Q 
 ehmq}XQ<e0 8p| `cF*/4    rb{/ A
4+"
oZ<
%	
Tp E8*V/k\Bh 2\}<
 ;(	X)
ku vUgzT._5=j#7 U V'=k@) <>X,A
?7/~gjmml n kd] ] u	6 ] &n	D!Ar	oRML5h'd	B<6!$&    2~mEL  
  1:w*>Z27p_
PI	B
~M-+BYJ<1'mMZI5Qp]f
	(^{k%
(
inxS rB
qR%w!s_ 	$
r	/XyJ[k'@%Ph	k?oWMC f`Y2k@^{}{ybRB	%Vn %*v599?Gv8#},	
%EH

y

j!A
W	M?r	T[UH<[
@jpr   C

gq bm+p w[!)P	{
Z	 i ZA&]!R2NV ) 2;_& x - p i&i9	 N  i  5   v  Mj~ |(Z!n  Wd&i0nXw	wB d  [nS
I> ; D 5 ~F	SF ;Tlo k #
]P  26^>eXMI>}D!# i)p@	Q
_O2_'K(* ^qmB dyK_8 9B
Kct
 *cb!
 
mv 0`: 	\J c"G4? 6 x&(-t&}zEe  (Sp/ 6OhZL8'C_|


u (	b$b|<;z*" k%!c[RRR7 wJx&Py%$8I	S# 	3 O+Fj. _@J	 W	
Qo

k$a `^ C I[:p63
1
3
2d	'/CXUUU GECiW/9n7BNfE	  4 r*R
#9Rj  		7
}jV{^ ,K";UU2I		$ MA9h 'o_Jq:`l:x;{ Mt N}6iF$7KXe)PD	p,]+W LA3 6|3D	'	aJ4lF|p;>H 5\@#Y|J O,	-k|_\|^ AP^o
VJ1o<;  B o`Qx*/3	E`rY/.8#W Fz   XnzBu
@ (	p
.9%8iP7h TC L?  F  |Z6Y{Fn.)a 
DQ |4hEm
M
	U/  X<c fj{ $T\<Sj f8? IAu E
z	 A7nxZ =*

Uol
!ru %9

	!9
}
 #; GR :::YW
y\<	
?BXo,hS7X
 G>x
|b
Df
P 		n
; 
$ "oU ~vX
(2(' T sp{I 5W z o KBa; 	l136Z )5k;.z\`D(	
j #TX\>m/:}ssiG	8x


X  {T~8#0 DvN Ha 	nli{ [<
 ^a;1Tr0\ Q F 24 35xDf1
<c{mXBRbXN T)l N0@-
$^"C\ {p$/2 b6O]TK
o3nR@_	.G/ L.S 9Sn-|  U	
0 d#& ~fC	wYF
Vjh)>R G2Dl C)Y,`8CP~7o#1 00zEYr^A	YQN \q
Wv,AVv!fMp\/+@ _   5 -%UuP^gl !YsE k C1 M%q L7E0l[E m5/V W`{?90 X MQX )\ 5CS'l, :pBds w~zqKYkzx*,tP#}8  W  Z*5 A[0H` NKRc/%s ejn-
<>eS <Oaq  [t OJIH
-Z"	
 MA]$h

u
=X8
}X/5;FPH@+ w	 $6}.	6>BM COkHvXvT4S
&
ih" [u5-@  (<N`{ 1s !	u)%GZ{ 888(l
|
;\}I
*
f)GUca

 H{W
C/Sx
 	t,K2W|  My)wGs	 W	 @ GDB07[ WU  CG
[1]^)s
tVgxaI  &jq3;
C

Fi?A =:
		3is;cSW'  g Oh8K_9 %$ v'@ Q\n
o-: 
 GR]Xbm +18s 

^'3}0q%~  !]1	,rH


	o F`zsb  nw
E	#^q7`	[
&Hvh ZZ)=Q+`$L	
2[ZB2!E>XI:i?m! k
k8hH '
n!J
,C'] ^ p\u^Tcs X3lO k|T,T}Z 7yU-	B  ] N5B@-N	
;ObJ

_m7 vw
wPobK4(	xE&
6\DE;1 1n%
7 ;+u
j	IwbN

>
\y.l2IxAwE	<l} Q  #^S "l sU3^_6	N	f	8:iR;M'_4	`}*nB
	$	p*	 8|
U	W<\/Z89W	(	t	 RyC??


	G( `" lM+
H	g
tvp6

	6{X A`1v
	"MH   J4g (n9a0  [f  f +<a%Rr
 CCo A W O_7p~t] d n ,MtW 7  lR*:acmx2L|d% LAlO. 6[| W5s   bD4+Wr0 } -&j{Ov.M	0 LaA :m[saX51rt% fcE'	

 <(qByM	w /XV~  3CUilG$BG n'Ib}5	
+Cht\ 8z'}{[d(X	/ZB'		

.NpoP&
*
I	JRMde }MGr,   A"}!i\NE2 ]i;$f
8
TDljpX	\XD4@KTj6r(| N)r@(	|
6__ ^ZrV
96qu=
,V  D Zgs}C
HV(&$a)	
! mQ_m { j uqW2is#T
z4n nXA1X}^ #  ov$L \$wb ;_D yT2LpAM XD,
H2 z m@ a	nZ . 4N-j yM2	j	-Gf5
 !	@ n L8%qbr:'L 5  P.kB" 7@H oyG ,ir^ I [r+0y5		SPi"
7N?`5Uvpi|uZ;
E &C 5e2 e.	 I?*
Bb :t:m5 N
4AO0  9w]3 |ccc0DX z!u H0\tK sM' ab
]  3s*;w:5rN*9 I4  R cBDE r8OP: Jb*U|@ *c|\ ;9XGf C d   z rJ pYS"	dz)e-'	X
h!WC  l:  R +

; AK`K`*gb Xh
y^OA
W%NP:3 T
	Jp 5 S    >oLp 4eE&+ 
$UG  7 {2K PH>X	2	\ N,
: Y}<{bL2XFoehg4 fz* &IPI
\+\7   
 b d{`Z" -  +rPRMEi ?P>-a  kqu# =K~	x+  &kd06v=	 ^ I > Vr&qgs* @	
	9\ +n  j+sl w[CGYA-0m gL#KD( V s
 0^ 4HK[w}y,B
9\<MV7b q8 %a:"V)!	l MNR{( Vi |O0N R] pt8z~)	)p4eMh  G*=Q[C@cq
g$f		Isb9W  Wkif5V&gkJu   a  z7#eM4nZH ?    O   
z3}7 7	 kK Z$'<I_R % sA2%_|L qu5C';O$+18 |w)I nsP-Mv F(o ;& &F1  PWmqK { A,cH.kz*Vp` k s|+3C TuTY| 3[$ L)  N} rgxZBJL% s\ T"k 'j 0tt'OwM ^]u7
	 P j]tY1tMP) wgi9)>0Fwfo*	  j@Fw+NU(ES`of0J '! L GD1% # V9 |/K nRVZ;;.-9Dwq2#9C 7Qz ` B$w_G ~SK=jiF#o*VDf
0 0  L2o  Y	C >" S6h v;$z-Kjxg 4Wy G r5~\^co{zjJe;dt* V { 3M	Lh!t UY	jX F}yh  Y ! w7+  Ot
BUpib bQ %jZ+Gc!: @v6VwC)t&	
 
5eL 32d}zxw  c7 r~bA[G` FB $			
 m:tF9ljO8b&3&9L#
!0Tr ?z/
Z${i aW2NW` Ea 1v= qBG	8rb	E!OEB7<	[C-& v$ :U![>^"   m P j    ylCa~!"  \g2B &]x  BaFr   z  HS` s   (qL&T  (_1  Y *2>g UQ2   j7+  ` E+ {K=DM5 Mx:x N$ nCR^ a  v(] 3T fA4- ^,jPqz  O4M- c:3  @ 3EIh `AWF ,  MA:%v> "`CI dm| P4&  e   0 !j S~!"w    + _.E
@{ N o' T  #c!   & ] f  <fZy/FfS B c* G9	I4S!d2 P%H `]a ~0ZN` ] o\2e'     U %V@NX}e.  \I 3 '
   +  4_xdO'{QSyTS6 ]) `:s -i#d NhVJP> oO21/  %2 <k Y< dF  	I.
GrD ;DM69= U&(*-/$6 ]iM  ^ac1Xt l   k /; r.< ? jxFO3A	q  >
xurQ1N6 " I
+ #l s $s o3  6e 0 ;g94/ )^ t [ W    f4W) seW?' _W   7m vwN Q ]5              
      RSRC             [remap]

importer="wav"
type="AudioStreamWAV"
uid="uid://bqjwtrmto48hv"
path="res://.godot/imported/x.wav-b0238a219f7117128061439a075995d3.sample"
             RSRC                    AudioStreamWAV                                                              resource_local_to_scene    resource_name    data    format 
   loop_mode    loop_begin 	   loop_end 	   mix_rate    stereo    tags    script           local://AudioStreamWAV_ggsuf 8         AudioStreamWAV          `                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }{xuromkigda\WRMKHHGFEB>94200/.-*(#
					
"$&),/3<DIMPRRRSTX\ckrz   ! ( . 3 9 ? B E G H M Q W ] e m v             $.159=CIS\iu}$.39=AFKQW`hikllrw~#(-15<CHNSY^dlu{{tkbZQMHFC=6-$
}pcYOOPNLIF>6-#~tdULD;3+"	               x j W D 1    veTMF?8%~m\L>0( 
xj[SJD>4+{qg_WMD7*ysldb___XQE93-)%"
&3=HIJJIOT_jw
$,3:M_x
;Xs.E]l{+7K_q  " 2 B K U b n }        !5HZk{3DT[amx,Gax#1>KYgy-E]jx}0BVcpx!'-+)07=BEHLPW]jw	 vWK>6-#
$112+$sK[2nT9"f:
w={U2   c 6  Po*[l,ZK~7am5rEq7x17-~+?E_2z@|<C<y5LW$Mx2p-r=q_M;(
b.I	ߓ]2ޱޔoI.ݫ݉gE)ܶܬܣܦܩܴܾܱܒy`XQQQUXm܁ܢ)O݆ݾ0Pponnnޏޱ*K|߮IDZ;m	T21!sywN]o3pBrC&)[bc1{@(m  ']bV		E

!~C
N
{


dwo@pax>H=x	b.qVFv8Vz=\t 
  
  l:i%U]0x^C(qC
DL?znVs>>B;8cI/(!



{
c
K
&

E.
9
		S				#	>	>	>			b0
W noqyjXGA<<<<<4,&
}cH;/01;EWhlq]H'Y }_@8/..uVJ
  T  J
hK.xH=Hl"oo!P#Sp<k]Wkqx6=S^] a$i@M\-pJ#\7\*MqS7


(4@MZn3[+UJy%Db/Nas2\E{U6Zh>t
At7FroPJiG`&j}m.
Q  6MRXI;	

6d)

	#i^
^
M
 JS4
>s c!!+"K"k"l"l"d"["I"8"7"5"t""N##$%v&O' ((6))*n****+5+W+{+++,n,,P--V..C///000//A/..).-------"..9//0Z1
22(3333(4'4&4433(32 2Z1050/r/.//......'/}//#0s000000q00/Q/.b.-b-,c,++C++******++)++**<*)e)((('&e&%?%$c$*$####Y#2#
#""""""l"X"&"!!v!J!!	!   | > J|,t
<o="#>YsvM$\
Qj53Qc&~Z567uv8v-R^hs@$;M_/R fb,:~6ET0Z"H}'8WskH
Of:uGs:

v
5
 
}^?~-
{
+
		m	?		a5	vD$%=Vof?Y/rZB- zT/|]=wZ=%
aH.    m E  {fZM>/`4	]-Kz4j*\Ph-t>vM,tT4}GLn%X!D	YPU[CZ'zO$n#=g!Su<=Wb
o(ޭwO'	ݵݙ}iT@,ܒV!۸ۄAڭ\٩y[<سا؜؁f9תcfՍV(ԪԜԍԖԟԸ!<QfdbB!Ԣw8өY$ҵҢҤҦYӟ Bdԓ!*2I`wՍ՝լ.V~&h,ٹڂZ2ߚ7aG-8ߧߋfcaS~*"dotx@2%_? Y^"l?	

	#<X
Lvv<c /!!"5##%$$%q%%-&{&&&'V''M(()a*(+,,-./n0'11r23`3333333`3&32222g2222X33D44755=66:777777b7766665a5442433333404Z4444p4Q4433`3221610/B/.H.--(-,k,,++P++**6*)j)(((''&=&%q%
%$"$#=#"Z"!q! R xA
q5&Y	r*K e?Iud
P
Q<


t
F

	r	#	q&X`0weT_jO3h0|aFKQJC=8^w6  w F ,    B   d".nG     \<o2z#-7*	
%Nx "O|hK7$,4=E@:, fVG5$g]SD6q.D  7 i/V&zMmRl>{AYEhd<l.I#`'rjb
;l	DW@}dߵS݅ݽ[ܵeu'ْLٸk׆1|־^հZԯY҄Eѥq4жt: ύIϷiͅ9̡R̪Pʣ\ɷɉ[+ȲȘ}pbJ2 ǌKƼƏb5Ŭ{I
ĝiBìÁ?x{pUn\KIG1#] Ls<ӿÿ[;7U¨©©yI8&\"òéĠ8GWG7ΌϸϗJυο<ˇFo
ͮRӱ}>b݈J[m{%&ޝ
j[W5[
YP$9}|Frt v?46PS		

j5 (w4~viqB@?Rfs~ |!9""i##$G$^$s$s$s$J$!$######$m$$m%&&?''(6))2*r****}*Q*));)(((('''k'n'p''''''(%(.(('z''&&&%+%$N$#o##"v"6""!!!!!!!e!:!  N 
xaM-gd8P

]
!
]4L
y

	%	fP~P#H>6n  Q 4  9 \   JUDa-h(dZ=uODz"	o		
e


UKVa*
{

AgS"Bz$EeD4#fC\u^G(	OB5I]U*mDOsU6;@Wn*OXaRC.Nld:O|`
\
<
v
!
				e	6		tIS#>_X j 
 Dx3?3#>l<'
I]gRb@{[<)IyD6>nYC"d2N^6}/c3wAyM"yHߔZ ޽އQ ݣm8ܓCۭhZو%؝xT;!׶ז{aF*
ִg֓զBӗAҟS_kҵMӛ'jԬwֵּG-;dܯ܊܆܂z;ةW9ՒRڂ==P[	0Y*BR-ev,L e!~	
N
zjZ?#&|A  Y!""w#0$$%&'(*K+,-./h011P2243333333f3*3222e33o455V67789:;:<<s==1>q>^>L>===<T<<<<4<N<o<<<=k==2>>>>>>m>!>=V=<z<<;;:':9V9888v8c8R8@8877#76J655\554x443 32G211h110I0//E.-,,c+*7*))b('7'&S&%%%}%b%?%%$$F$#g#"e"!P!  ~._P&&Yh;8kq[Xa5^]\yi#

5
]@

		W!>c{l]ae		%	,	4	;	C	<	6		~<	z			
Q



Hr:`
T



(%!

'<a	'*.M
i

t@zV2

\

	w	+	;K8n7ZN  % ghJ-Z3Vt$(+6Oz7fMF4HFRdzܓ$۵Sَ+y$׉Eֹr+գf)ԯm)Ӫg$қKќ=|(ϐLΑQ|4̞wH˜XʅHɵɑm@ȫȅ_E+ ǲǉ`A"ƎPŤq<ĝxR>+ óÏkF Y"t.{]>:6+!׿ĿrY, ƾQ꽿ugow
_!xϿD=ĸ4ȀfLlȍn{ÃW|?ʺ̣ΤФe&
ؙׂՐ29s7JؚKޯ;g
?QdLf~|[96y 0GH	H
&}!
L


.=;Pj$  K!!!"<"0"#"!!f!0!Z!!!_""5##Q$%%&'()*\++p,,G-b-}-@--,>,,+++,.,m,,-U--.`......1.--Z,+*'*z))(0('t'"'&&&&'.'-'+'&&B&%%%j%Q%.%%$$J$$$#$$##q##p"!&! R?x?j.jD4<}!4R?N
x
*
p&
V
		]		dr			-	^	N	?			M	z				
D


&t)U,
h



 6[~ :sDsAO0G^{Crp`iBp
#IooX+OzhL0
R pT9Tkz$<Rcb$gN
n
&
[

=
	s		3IrH!] + {S>4/9X%c.^Ks<@y2r1f;VaHZx%WL߫]f
޵]
ݶcܵZڟXُ6|׊]/ֳ։MխՈc/ԶpӗdH,ҖPіfjt4Γ3Ω {̙̊E}ʹT9ϷӁ؟$Uه3pڭڐNס6-$ю:HԪ`+Aݪ\"<g{y"vu]9chy(P xg#	vo;wn3x0e o!z"&##1$$$%X%%%K&&P' (()*	,`-.]01_346+7;889:l:::::;:9d988889q99_::;b<:=>>?-@@VAADBBBBBAA@B@?????????<@}@@@+A[A`AdAA@E@?	?\>==<;W;:>:9a9	9888888n8987w776[665I54043	32211510y0
0i/..c-,+*$*F)h('&%%c$#>#""I"9")"6"C">"8""!|!"! : ?}Z"m4 N[Z^ 
-
T-S


		Me,c8\*W&d>/=KS[[$]X[]
Cx

	m/Dz		-	*	'	U			>
|




v
c
Q
Z
c



*EfC`}qeF&{K

p
9
%



			|	_	B	D	F	U	d	f	h	R	;	
	U";Q]OE^ y 0 	 Z#S6 =B.D'_~
4or]9t@7@<@:Z4zty!mٟ.ؼKֆ8ՠWԣ0ԽRҔAр<nx	ϙ/LWq˻o5ɏ`2ȎD|%0xŦ=d¥T0D
Y/p
Q<ݼ},ڻ[#뺪h@ٹvR&θe'귬zH鶡Z򵊵=𴯴o*䳸y{~eL9&Il;۴%p4Y:!j<AFv${ԷB9/|Ş>YtϪ-z#/ѓ}7(vCgՊBH4p'bNOQ}a;M+8\e mtZ	v
ql

.n
foFp
T !"$6%&&m''
("(''x'5''&&&'K''((l).**+f, --..."/(/-/..-h-,f,,++++,d,,/--=../*00P11111C10d0/x//.-.-G-,V,,+++++++;+*\*)x))(P('='&
&%$$${$c$W$J$
$#s##"7"!>! R T2:sGh	z9l+UdsMZe



p
U
E
4
0
+
3
:
7
3

kjnrsd

[kTpS




B% ?^JEepPRR5v<],Nq
C|&3@XpF| 1 Y    +!f!!!""""
"""2"K"b"y"""""r"d"A""!!!r!+!   P r4a0 X'Q
MvSY5hCkLE
3
y
L
	/	(,8=66Hj }  5a4FXY3P$4x'4e"<qmK2+2VqDUZ *")k ުޓi?ݝk:ܯX ܪT۴ځN5
ٲ|Gؚbd֍ֵLԱ{D{-{> #?1"sѶs/ϢzDs-DΆ aϡ,6A0 6LmpszԀC׆؄fe'QOM9ԉ v= ~!uP*Kk-Cz\zIT _Kf

B>2Jp} N!
""S##2$$$%_%%_&''( *+4,O-}./02*37455x67M777r7F776666W6+61666667E889F::;C<<=6>> ?;? ??>I>=T=<<g<3<!<<<<<<8<[<<<=E=.==<W<;O;::{98J87776O655q5X5?5#5544J433932n21v10R0/2/.\..--e--,d,+i+**g)('E'&%$/$b#""!I!!    }   t c ' lBnQ
U7}m]=LDjrz>



j
I
%

u3b
p

					
X








S

	P	Qrbek%		
~





*
	H	g[)'\'					
!
2
T
w






V



1
`
y

v
Z

		e	c	`									
-
T
{






u
[
G
3

	}	 	Ns?4*('{`ek]Nfe]o'  H 
 oYBfzCW8-Tf;bhQc7Mce9s:nSo(j-Adtޛ9݁&aۉ۰H٢\؊5חM֕M՞:{ s#҂0ц6жЇvfa\G1ϷfΡzT"ͬg;d
̽o@ʺ~C ʽɎ^G/ȱȎl\MC9&ǲgƊRŜbůVÚÐÆÇÈeAdD#Z$k;'ǿb%徥{R5뽾eR>1#(,Jh½޽
!'Ed̾`ܿXC$tH%_ȪȆE>hȒȳ:fʤ̓CXnԄb?(ٰA'
@ۄ*"Fj.lHA<l N|M7";	U
~
Fwvu>^TKSH=F O!:"%##$%%,&&'^'k'x'a'I'V'd'''(Y((()T))
*|**m++,A--. /`////	0r00!1h1`1W110000000000000f0A0*00//`/
/}.-h-,,',+++h+@++***u*]*D**))g)((('3'&&n&4&%%n%7%$$$j$3$###"&"! Z |Hq_4
=,c9jP6*#(7FS_I3a[`r?Qc*i ?j^-Z&MD;1o%Ni%1=M]w:WtY*loR5$'6DR_p~qcL6vusldC#`/f8y/Md
V[`[py#rf
c

X,
e

	5	]s(C]mf l  h
Bl=vCBuAe%45xI5i,E]1 SX#QY-Ow2W[G4+!pY/zF|aI1%c0M:wF8)07LaabWMF?KWY[= ߼ߕnO0ޓTݩݭݲݮݫ݂Y#ܽ܍u]_aN<۾ۗۓۏ۔ۙ۴,bܗcݩ)jޫElߋ߫QRdv-&,_+F7Z3].B,  8h6|C
	

[$,{#h1Q,sCQ  k!!"##0$$m%&&M''())J**s++i,,S--4...P//00111]2223(3W3334L444444	55<5a5556P6a6s6k6d6a6^6i6u6x6z6_6D66555555555c5'544M4433`3+322X221H1100{0W040//T/..(.-N-,},,+8+*Q*)k)((b(((''Z'&r&%p%$$,$#m##"9"!Q! ] h0p\
|AMgukG Bm(@P=U8hLufsR]ig
h

&
1
z




N
(0Tds@
ubNw?
J
		f	[	Q	9	"	1l%n4Z(t'W9  N UHT~>e7	|5D&61`ckP	l>TzYq!z"u&=<]ZIߦߋ@ގ'e܅>ۖ*۾[ٶsS2ؾؓgP9/$םVu0իk#ԔKӪӦӢӠӟӐӁrcZP:$ҫ}NњoGаЗЍЄq^;ϼϥϢϟϪϵϰϫϝϏϊτώϘϪϼϫϚi7ήΠΓy_/ͬͤ͜ͷ"*͔c6		
$6Mdy͎͈͛ͩͤ͟rX="̰̊b9&
	*BUg_XOFS`|̗̩̻̿E͚yχ	[Э2Ѧr{ԆԐPSԺ!iհ)`e;ڦY.ݾN߂*B9TY[fCgBHf[O@1R<=  kD	w
1_
>J.E3}2]9fx I   !k!!:""#t##$A$y$$%t%%m&&F''''(5(^((((()\)))))*<*o***3+i+++++++l+Y+N+C+0++****l*I*>*3*H*^*o**g*N**))O))(((R(('v'$'&&&&&&&~&[&&%%l%S%;%%%$v$$##"e""!!!!L!!   g m s s s P - kS<qaG.+(6C^y&Hy.VjU9Dx"
*;6rw}   C f {        { n g _ X P / 
 _/dP<*j7m&FuEcs.Cc!s
OzK3e[)
.
7q
^
		
	AIqHJN  E OAw[ZCC`gUSuBEe*g1Y@hIMvbI0j5 ]>  

u[@fR>DLi'5A5'"6JVbcdgky.XsnUQLkWH9Tp~_UJ\n.ABDQ^?@i ?Xqw|zxrlxLx_
n'@;7YzcEjy+v"a:~84xw{3   ByEy).d		

%MuG


E-ig	4_A)r#4rL0j'a+m Q9{ I u    !!%!)!-!G!`!!!"="X"s"""""<###############^#;####8#V#l##n#Y#+#"""""##""""h"N"_"q"""""""""#F#H#J#"""!q!C!e!!y!k! g eVG h    y 3 $  Q    P 715~kXa\)Gl=?AIP!-|P$	iWd"T$l-GlE^1

q
"
W
C
	i	e7	AKk9!+>v h 	 Qf*q"te	Fv
7{r!XT ]=$=l-s3w%qEV5X/Fi3g(tz9Qu],ߘ}bQ@  ޤvG*
ݾݟ݁^;$
ܼܛpE"ۮۗ}cQ?80"ڻڢڊwd]VX[YWRNPRZaaaWLD<85,#	-<FPUZWUC1&"/;CKNQUYeqڎژڣڥڦژډnR=('4Mfډګ
(B]tۋۥۿ۴۲۰۽8dܑ2d~ݘݬ-CXeqw~ލޜ+cߕ,W=Zw%cR}?wJr.gQ%Y*\4W.>FQH!>\yY5u%x&A[NL6r IcQ8l>FZ, t  c+1fg2#S7h/	c			
R


c/
|

0zK2eH{0a%a@U)/ %Ih7fA~I=`Et*5=DHMORaq+6BQ_gojeSB:2/,
~eMJGGF5%xbQ@VsQ|P#~W.xFTo7Y-t@xP'qHj5 Z$M
]/


l
B

^.Y!


n
A

			O		W- r>
vH"iP:%z]?"X/dE"~gO9$       q a L 8   yU2eN8-"
z^B+uaVJD>6/$ $(>Rgr~zkYF=31/8ASd{.39=BN[jy	!1@NV_beox~ +<Nas	  ! / 7 ? 8 1 (     ! . < I V _ g o v       ":Rbs|'=Qex           
      RSRC [remap]

importer="wav"
type="AudioStreamWAV"
uid="uid://84dels0iwec2"
path="res://.godot/imported/y.wav-ee32460bf0d0a4e30f0a09f4c36e481f.sample"
              RSRC                    AudioStreamWAV                                                              resource_local_to_scene    resource_name    data    format 
   loop_mode    loop_begin 	   loop_end 	   mix_rate    stereo    tags    script           local://AudioStreamWAV_5vjwp 8         AudioStreamWAV          N]                                                                                                                                                                                                                                                                                                                                                                            }zwrlhdcaaa``\YTOLIIIHGB=60,(*+,,)&!


    	
!#%)-/01358?FPZckry| 
   ! ) 1 A R c t y                &5@KPTY_kw	&7HS_hr
)8FU`ksz$-4<DKQV]coz !1APYbglps}snhb\VPH@:4320.#wbQ?1"{bI0wZ<jQ7+
    w _ Q C A ? : 6  e6.%6FQ\L<|]>BEUd_Z5db`s{Kf6U* q1%In`S_/ !9QI@lG"';ParolN0zcq]3tngr}ykZJHFS`lyur^J7$(,D[hugYA)&:NW`QA*
 9Rbspn^O>-/2Nj6Vj~yrtw	!9Qi8Px!DTdwJu-W"Fj"XN~$ ^    -bN-b*t5m b:{.n	_			!
Q



7(m%
`


&dO`9tLLDx#P~KCk&Ik 5L[ku 
r^G1kI%rJ"~T*p@s@o6l@y;V'm:_#

x
?

UmF 


q
-
		`	'	X'lA]cyKkG\/ 3{hR<5D1>]el]lI&ni5	DxZlh6kSj/)#$k>b:A]*	5/:@{"\PD7b4_THVd~lG!	I?6Vu`YSbqrsi_r
-PC5L)9Ic}.Nn,a Wv<0d<|a;]?6wH2VCqI%v>>  tW9gPG=E		*


/sL
p

=Lb L;$ke'C^J3I^=jjj/=BP_%~dg+Z8FP( 4NZbL2at]biJ(E`



s	E	4			
'	-; ,p l  sp0>LWcUL1f
IHZVkL/CmcX,/1EAO|hI)+HfmV^eMlBk@VOI?6qQn<3!Oq-1[<dd(|HOvRl    RG
qL		

:_
+

8wIU>einE;Gg%s]" Y    !b!!!"""
""""<"e""""~"Q"$"!!!!!q!W!=!!!       D rPL
{w3'RVZ^`b[4;nM+Q	n+}R(C^~H70 QsS=nO




@&
l
%
utr[Cp!




j
(
		f	>		/-\PC`|(jz%_0p   -5 |%N;AGNUnX(##6pa-X*nN/5EYnz"=cX	m"[bhQy[=HSVX?&vex$.eEj
l_6gaGqof<p8rqJm=x}Wޡ6ߔ6{M#}=:w܌F޲@ޡu: W޽+}Oh܂|/Pۼ(1;ۦl6 `ۿ|;}ڜl7a܍ܰBpݛn޿Wߐ	I5irG-cPhG?8	;nwdx;Q2*Xu55%P,?cfheb 1#B,e/2k=	E
M


>nB"phSVaz9qRZ) !!!4"}""z"."!!k!F!>!5!X!{!V!2!^!!!X"""##"T"!!>!  * 	  0 / .  
 Eg!oYBl*O!6|`WO
D]U"DH\}O

nE1@by]+
b

			I	+	
	;LA5\q`(gmrD}@k`U9l7  x 8 +  + 7 ? H  hp
P9)XnCFGt`@g3:@#W(5CkZU=;5Lc)>P#HZRJG-Wr, 6-vn^N=Q
>V}n{Bg@D.x8a%4 j1U_^h@T$R ~{qp+ߠ@"_߄h!6ަOyg; 5hC19hߔ_HߓߑAnw	ߋ
}JEikH߲D sZjzk[IW
6BOSVd[)	y<v`#Wes V%meH+}nM < , vn .DZ(h 	`				 
K

h
kT=9psuN%\QQHAg.~3 my\cjJ   8! A xw^o5 8 ; M"7yFVwsNJFl~9E5G]9xq~jV3SSRK
K
g$EN


i


		C



k
;

		X	F~S(-Siw_Q- a = v     ^ 
 UK
[q3X
+=5qFuW=>)[H6@IS]Ko&Q[@ht5 yOg+h+q036+@?*gZ^5n
ZYA*@GWg"8I8EcT%Ft}@uM~QM-^r*6BZsuQiqbmx+A;?q~5j!h| _Eid-J_skq D:JZ`e{aF
,#l8d'vh {0`M}Cnpk|X9
jge  HQYYd>	]3K	
L
c

-V{qjZiLsdTrC6 !"#####[$$j%%r&&'H()))+*)|)))*t+;,-7-m-u-}--w..[/%/..6.../1|11q10b0/&0u0I122322q2-2k22333332k2Q2243n33k3/3223B3o33q3G33222222r2G22211{1%10x0!00/////I/.. ...2.c.F.*.-.-,~,[,8,*,,++f++***U*3**)))))y)I))((f'&u&3&w&&&&&&%%*%6%W%x%%$$#u#h##$##J#"|"." "!C!  bP># - 7 6@"R	V=N$B2MhW)]J-,G8)

m=Un
F

PM
	o1n	


6M7"<U	f2 S Y0TQv- `? y"a( gETd!!3Z
"7
oh`6s
pkeo{[DJ(!E<TF~Q 8Q@vPf{@=42 y'uH	@1GYRM9+ܰu3]QލQ:k9ީz
WP"PYޖR-LF:ۈݢuEk4iڒXajL-޶2=Kڜkx߃)0ܚ0Suڶ5ܺl߲@ױr6۔ݨZs޲So܌'Pۋ:݇ۼڢٌt٣ݾ;ݶ5|ݗݳݴݶކީb!EݩMA=7.zR/{3'P<TmDl8&yW6'5F,D/ 
0Vq:$<j	T
Xp



ww_wL1@ZNay/24G[H6r1n	]ht]ELvUO 6;D	#5H\=|nWql`E+r3s)w
PWVy\Q
i;

[
V

I


j
Y	NZ]c*` m6|-2 l$]. $i&V*d8hX$o$v5=(@C,sj,KT^2<Oj)MV<d=W@0 Qw]m~^m}!:cP=>@,q0Mj?.YF-U&/)D9^9Q=XtKB0 Y*fGC{9/ )l+~EyA*f#+&.40a^I35z$ui^Lw'bpW{'.fXJy=qF 126vX
/5I\0	
X




'vog$F6{+rW;_"   u Q - r  !s"|#$$U%%$$i$$%%&'''	(D((((~('(
('(9)**+b+++q+|++i+J+7+%+h++,_,g,o,X,A,,,<--G--,,,,\--.S..-w--,,,Q--..x.-B-,,,
-~--..-=- -,,,,"-.-;-,,>,+7+***T+,,S-,c,H+,*))))*+*X*)O)))r***(*=)R('&&N&]&l&&&&A'&C&%!%&''('&
%G#"B"M#Y$$H%%$$H$#"5"!! !  -"!!iwK;%iS`22`U	@!~		
Zm	XN<*		
%M A"	 4   i *@
<K^s,f*q QTQ \fB"Z"\={)Q}ff@,,U!~Mn;6?9:CWي߹HS8*( do.*o~$cq[rYݗ߰L0wxHޭߋ۝ܭ݀Xݟh37:a]Tۓ}p^SA(NNXbIyEksY/6dZP?0BTkހdTL7ݵ5QjU3YޢJ]nVZK?M]
NHq3eD&4BJQH?@v0<%u[A0IeyW73j.<$\M@ih;Zw55B" M x O;dL:_UL		N
0

	 			 	=	+	
?FF)2;NRtWvG-!n'1:]	p$ejDk`"[6xKG1]& 'kkQp}j#fVr&sfw
-[c[T=7;K6!Y
1


MxG	 	p
		(
7	{l>		=a`!r ^  ZI9o vkp
I"d !g3tv'Hi~A1AQ rQkjf%3;C,{U{pet3BQYbw,"U&,a$mcݗۄٲ%B./0i 	-o2J	h+ A5
1
~paR);t~
It{Wbne$h8\4^&A\_c8}1'k.\jN?06;xH`A}bHWq`NqFB>g{.bv0jH
,~D
~L~W(.gS?r#kIc ' :  = Cq OL	T\OB	
3

f			
6vLbxU yHOss&Fe-N|Q}=3,e  O!Q!T!@!,!!!!)!!!"#$v%$8$q#"""K##$N$$##q##w$E%&&]'H'3'&&%w%%%w&&''&&%%@&&'(8('~&I%%%'v((*)'d&%%;'(V))(Z&3%$.%Q&'('&%[$%%f'(b))(P&$#Z##$u%n%g%c$_##$&(W))j'%" !J"$&3''&$i#."`"""V#	" }# !$=&K%Y$ A)!$	'%&A%!J  0iI( HHdDOmJl
Y
he
8q
'




v&Y 

	*o	sP.s?. B@@Hv{: Upu	x'xY=@;(4A	2^SS5D.0SU:=n(!A?8x]H3E7);Yrj22u h2,vx*$hvM?)l0NTu?R߯ݱ-+z݃@w)KrB0S;(2o,]߸zB_B6Z^eSD.}Y	f@'9hFgH" ;gBcC)KhIS;@Wr>71XrQg$za:qMj,E_xg(Ur r
I:+UG1!`l;		


z

4x

e	{		
0
#
^

ocW'
PKFQq3[

\3eom[{S
k,L^Bi\O] lb,G|&`WN>.
 Jsoir?
SAQ?
4
yoAIBjIB
	m		
}h
S
8xNs

[V9_e_Xgv6  #w- \[[]_; 1' /<Hf@{qupH8zNN
"Vsx>:jRwPlF ,
A00P@/]dk	La(Q=u(RE3.(% 4hCaZ6jm<n>^NqFEUiJ&xRt>N^+0 Gn# geb-^"sb. DN&,otc/|^@Xo|fGJM!i?^QC%Fg\iY+T*7i4/* 0 6 AL$c m/D.>~y4[F2	`fJH


!
d	r		
q



[

 Z[
'6E5EC@p8&g>VYWVj~
pa	7hG}='!Q""!R Q!E"x#P#(#6"C!  0 N  N!!"	#v##*$I$g$#","q!!!"n##$#4###C##r#e##""|"0##C$$$w#"_""##n$X$B$"i! %  !!!o!'! 	!4!!"E"q"r"s""!E! !F!!""")!a!
"#! & 7>Da0/H )rOE<?!F1}*X/!Js'N89g
":g
	M	b0		H	>l
 
Z,-Sy0	
w	 :  c3VO |vO$p{6_>}lIl&%{j@Lb!!\'d4	bhdBk'
(d6j gP`p$biBjsZqb49$~
,HNpjeO=;k :j1@R2W/oJwer;koxJ9A8-'#oF^p@.y#`LQ4J}
D
8Ywuw*\v-[V$cV[&H	ucLre797mQ A}4iHA"x  sg\ZUZ!|0vP
0g	5
S
p




	2	;C	
"@<

*

p
0

_C'
{
j"
?W

4~m]MyP x~T}i-&c!YsYIzvV
w
7Bj

~)9|
X
 
Vy5	W



	#	'
*7
C
DXk"	c[-H];v0xof.i?	$ R L|8U  kt| zr+} yu@ Di(};a5	QH?9Qhc]jA<zg|)"dKQWiE!9
P1YBb=cL%4le]?!eYv<9(;Z&[,rbJo^1 u
4[[ jRtP<)oY+T9{
mrH1ELS7&a>A5( j]QpV#
6
/QH>~$MRW7
t/Yz]@7oHb{{|iV+% kG#4T'{JjVC8~1Tx	P
`p
		
G
1m
x

'1;Wy5BhkT~lx[3H]5
_%MgU H|J+
l@P_I=aj`zH ~! O@,.E[%   oEiVUA\wT1 .w\,CZF2=_
(eqhMMM+:IXx7G[eozY*$, O

n

U
	Lr('F	e
s
	
H	F`	.T	^N/9yYx[wenv3 
Y\.C  's/PoQE94	_.l	pU|"%L) `0elmp 2Wh0w jbO@
6_USvkr}
QePq;El+EUam'Bd-MUd'	 Z/j%2=S'?3<~5.m`*ms6MSV|9dE&mWD@.\8QTX
gUfE&znn	
7W Kqm0AAC%nhbsSrZD	S$" O[$C}@o .hY  l Q 3  ;  8W[f	N|A GU B {$p/ 7/
!_ N = KDb{=4*"555x^9X5}Q&f!Ou8ux
s(|S
	w'<QE[Zq	
	o d,U} _"j70W~W#Rl6&JnJZ*yO%	m-*'I<.buTZ`\`e;> z g3u
H U	# D | Q( $ 6u yO}wR- W#@0!Me |rFk=s 6T}@%8U;der=BF	fv0lT@YA**a<[EQ\ci*ux U:Yy \@*D`VL|n%,+pF1 
 Q+W=(Z=
X8+nw[Fk~Ia"e6^`>)^/5D]8,!x   WH| -y~M L8	x^/ ` H@w  
  %FI   qDhM  [' %n".<6f3LoBe*ce
Ay,=	E	B~
	+	L	C1#9w			_H"
6j
 R		'		v					Z(		X

N
4
E
a#	<	ls#


H	 =	z
5
	
	_
:
	L	N		

'
*ehj			;}
	


'zT	/
P	E	5

	v8
k]
O	.			
 	h;&
Ts\
g^SJ	&daAR~	EMM		5>GF	p4n	o2  j:~@  F.Bh
d 8<A    i/$" l  SZ 0  e  kge UW X n?SR V 0#o4) Fbc77 y *|&n`_ s ,]UFV+ JF[ $C  Df  PnTqEqBMB7(Bm:,X+R@E^ju9;ljSlC$q'VH>~fqg+q?q1pFxD Wn	1cUH3p"~0 
\7$.ZPD6)nVyoB5'\&7`[u'iL/           
      RSRC             [remap]

importer="wav"
type="AudioStreamWAV"
uid="uid://xmc8ebx16dq4"
path="res://.godot/imported/z.wav-dc65fcdb650338fcff091ed1891c3c07.sample"
              RSRC                    AudioStreamWAV                                                              resource_local_to_scene    resource_name    data    format 
   loop_mode    loop_begin 	   loop_end 	   mix_rate    stereo    tags    script           local://AudioStreamWAV_elwm3 8         AudioStreamWAV          xX                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            	 	    	        $ ) - 1 5 : = ? @ @ @ A A A @ @ @ A C F H K M P R U W Z ] ` c g l s {                                y s l e ^ W M A 3 &  	 {iWF6%
*:KYcjqx~~ztpkf_XQJE@<72.)$	

pN.	
}lX@&`G8.$ ,7:3$
|Q)v]J8%jM0_<c#vL"vgXI:'4Ro1_#f;*~"mLO8o8e)^& W      *;M]p&8J]n+Ih-]@h~QtT2m@xb v ( eJ+	iBkK,S"V#oT9+2H_r1Yz@oB"8KbvDt+ m                      | d K 0   $ 5 J e          %:Z '&
ybJ2    u X 4  Y!s7kS3
sNk s    
.S|.m4n.N[birGy2bF|1g	5	N	a	u													+
g


6I]ulA


{
Y
4


2
M
e
{







M

		B	H
/^	{@iV9a({!TM v E 9 ? F H K T ^ k v w h P 7 !   : L I 8 $    	    nN-j7EY'
(X;5t13&oQMq:&i)s6*vS.	 ?Znutrrstutr}	<ez\CdZUY>2c#\	 y>Df6]K%\qH`e`|TO>~K|;@J,jvAuEz<#5EWmtWLf]sy3[9<U_WKB6K	fYbtkQ:{:\`)lGKtQ}"QP0l%`iwxF yA_(	
:J

 xX/CYo Q.V} Fn3\*o&Pos]H$[QKI%k5 aQ
5y
	DVxQ-q RPUulq% &,&v"U'h9	`5AT[c/m6hcSc7q"5Le 4i8i1T=lAr O   H\#IjjK#Kl%  \  Dij};o;S# qR:)(C_{	*3523>MY`j{r_Q?'/DS_kxZ&iL1"e+a,OQ)	yttvtpqyE~:kCI~N c't3_		t
$#

H[3D(jX6i$o.o^M;-;^ #!!h"
##$j$$@%%%%%%%%b%:%%$$_$$###~"!o!  T4f$Pz%Q|T
k

g	/Zfa F =b~=`A7c/z8jPaI!Et
T XH0`x\%S$cC  &%1>h[		

^*

U'35n !!5""T##t$$p%%"&}&&'?'f''''''''''R'%'&&r&$&%%C%$$\$$##F##"}"1"!!C!  ? 9af= 
 5Vu?50   $!s!!"_""#\##$q$$K%%$&&'x''X(()o))#*t**
+V+++$,b,,,(-p-- .J...A///F001h11"2y22'3|334Y444.5r555@6{666
7>7g777777888877777e7;77666R6655p5(544D433)32_211(10X0/v/...-
-,+h+*(*s)((R'~&%$#"! e@o5l"?
Ar62tpCpZ76V\QkQLU.q|*ye   4V}U_e	

i
M

=Du6}bE*y Z!;"##$%&Z''(()}*A++,W-	..?///001s111)2a2|22222l2C22111-10020/P/.V.-W-,?,+(+*)E)('R'&%P%$#D#"!/!u ,h2c/Y<e
	B
	CPTC        +CZr!?\y{S+X.   j P 7      ) G o    P4:.Yw:		
@h

Psc+w,Xs_ZCY+K(Q
A
~	5p@%5=&|K9BOUdT	Y			
:
a
w




M)S[-F


g
O
7


						`	6	
	PuaM;.#"6I[jxpN.Ac}_@$X{xu%h A.t%4A6(z,<`PDKRTTSPMKHGEA>F]}@v(OvsZA+e8a'P`1_x4(tS0
vP'rVI>1'/Hh!K{ ;Zvsg]K/Z1a6xX<RKmߕZ/E_yߎߖߕߒߑߎ߆{naZat߈ߚ߲L H"bHw4X{3Z0AP_nuvtsqfR:$v<r!,y h,Usގݠ&ܫ0۷?Sjך3p ՑGԵԑjG-ӵӢӐzZ1	Һ҇NџZx+vϼ^ẅx uSǐ\Ĵj.jڽK.pֹ@O~s3r+䴞[鳶M5;P^kF_iƶ]ӷV+otҺ,Lp7zݾ5LRLD=7/'	JwĿ2Vop[C*Ͽa[mɿ/e8Yw&W±:[li`\]]YSMJO_sÄÍÇtZB"19).ǽi
\"Ȼk=㺷{'ù_*ݵuD(-Jkߵ
4]϶8tX%Aкf
f¾w^B2G|Ŷ)~T͸|NԯzgLA=*cs`3{6b r@	FJUWv	

j
7:o:/e&nnt)C?
FgsiZGe4c"EI#Zu!'wA
K
Y
	
	WJ$( R &l!uC 
*Ny@T<  7?gPp1		8

x$e
I
~


G=7a
'9Mb|WI{{*Gt ]%!   j!!B"""Y##
$]$$$<%v%%%%&0&9&9&7&5&2&.&!&	&%%%%%%e%J%1%%$$$$$$$$$$$$$$$$$$~$p$^$Q$L$L$J$E$?$5$*$!$$$#####i#S#A#2#%#######"""""""""""""#/#b###$U$$$0%%%$&w&&'{''B(()e))!***++r+++;,x,,,&-`----.6.S.b.k.x...~.l.W.B....	.-----q-T-;-)---,,,,,,-$-@-[-y----.0.].../V///N001[112y22;333M445]55 6P6667W777778888877777m7H7!7666J665y5(5444433$32n221]110h00//V/2//..............//5/Z////"0W0001B1}11142t222-3o3334N444455+5E5Y5c5i5u5555555555555555555555555555555}5k5[5M5?525'5555
55444444444t4n4n4q4t4u4t4r4o4l4i4c4[4P4C48464:4?4B4F4N4Z4g4u444444~4s4`4J444443333j3<3
322n2'211B10090/|//.G.-n-,, ,++z*)W)(,('&P&%%X$#"L"! < 6kG=O`}+i	Oe39Xv6Tt
	qG]&hG#+SP/})-*~'|%xsR(BN]nuhN4Y*p0PZF3,6MV]gv(C

?
EK

W

		x	I		vW6yqjcXJ9)sM*q94Rbt'  B eBj)o5	qkga]aju

 uQ&l0z6OYLCA_9,,*&(2AQ`f_P?1)-8=C^Iz6Z4Nq&v JOuH	W_rf
c @!!"##$%&'()*Y++,I---------d-M-H-U-i-{------
.
.----M-,,>,+++***)?)(<('1'&Y&&%M%$$R$$#X#"Q"!B!  KU>	wP
+		]a @mSXtN-P*:K\Hpo}>^3.C\yFEp{o]%NC;Ly k_I+y m  F9Sn>f 7inYD2"|R#!b  & Or!?^{002f@|NNgk^))3=HWj}qcQ,Z"k0U%UZ J)x1f+k:ߟl9ޛg9ݪ݈gG(	ܝxS, ۤxE<ٰf؊Fׁ;֡U	ֵRv
ԟ5`я7КKϪY
ϺhγV̝>{˹Yɘ8Ȅ5ǖJ
ƥr@ůōlM.ĴĠďĉĎėĞĥĴ (,380ģuAëzI·\1Q9߿-۾L}J ʼqEL׺h3ɹjBɸiI,̷ܷrO*tL(޵޵ߵܵʵlN,ᴹ|ndXLB;63,޳|paTQU^hoeG!ܲu6q`M915BOY^YOE</
߰5TJt'D_z³Kz1qCtɶ8N`o~ӷ"Kʸ]"\Ѻغʺƺ/ϻ]jH/´GY#DoР0Ղ2لۍ?A
a(n!DX> X,V	n
b=

tS`:\9^7S  !"#$%&'
)0*S+x,-./+1W2o3o4h5j6e7;8890::];;<o<<=+=:=V=o=f=-=<<R<;n;:E:99f876?6543<3{210C0/..t-,1,+*Y*)*)('c'&'&%$d$#J#"9"!B! U \G4f#T7p0yP
L
[
	<	+Iy%y&T"{l_QB3)%""$%,7BINXcmwWYu:AL}	0

E	

m>  !"t#Q$&%%&'j('))*\+,,0--_..J//!000"1a1112R2222&3`3334N444445k5556=6x66 7D7771888D99:l::4;;;c<<+===R>>?u??@^@@@)ASA~AAAAABB"BBB	BAAAAAAoAJA!A@@@v@E@@??{?I??>>~>O> >===z=Z=9===<<<<<<<<{<m<b<W<K<?<5<.<*<$<<<<<<<<!<)<0<8<D<T<g<w<<<<<=+=S====>U>>>?C????=@}@@@AAAAB@BwBBBCCCeCCCCCCCDDDCCCCCCdCACCBByBEB
BArA#A@@'@?^?>>9>=}==<i<<;g;;:T:99898[87v77665-54N43332Z2 21O100)0/T/.q.-a-,T,+5+*
*v)(O('$'&%_%$($#"F"! J "fR'_Khm
 
]
6
	0	)Atf+w\O@.$/EZm@tQAc,		
s

R>(

{gR;#yP(WKv<bki
Z@    !`!!!"T""""
#8#h####)$V$$$$%%+%@%U%c%d%^%[%X%Q%@%+%%%$$$$n$K$ $###a##""C"!!.! a }zxN9=^M,d
X
	%p`q9  $V>SyBuS6ynbVI;+|dK3zdK/o_RD6*$"(07@N_p(9J\mtT1dC.&",oBxD$i o7	H{
	3Y 7Zyx C!!"q#$E$]$$$$$T$$###l#L#+##/#Y#####$'$J$S$$#M#""!?! )'.hS7q9}7k,rEtA?u

v	V,T) 2c,:Rs)o15sgg[|P!/St_7yNJJreT\ ?_JSxP&1(
y^F'?ZvT	 E    ,aO>%w$2DTP"^T"m c  |2Q`4ieN(2a8[T(xZA*~eL3sQ)}JwBv\K6!.>LW^cjqmW8{G~K]<oM+߻ߓjD%	޷ޢޑށp_M;)ݻݰݦݝݔ݋݀ti_R;ܷ܎\'ۍY$ڻڊ[.٠h.z$r״<ֻ?@ԱӉib[i͉ͫCvˬNɔ7Ȍ>ǠT
ƅ@źw5Ĳt8ÿÃJd$Tr"ҿ1޾9罗HYԻWẰQ!ɹzR%Ǹl:ҷk9
۶}U5ݵʵɵյ #3>BCDFGEB?<>EPZerĶٶ$5DP\iw˷ 8W~ٸ5iֹ
D~+cȻ,ZzԼ "4EYw
+If̾߾.BVlֿ"R :u,i¥MÅûBnĝ 1aŕNƌXǡ/rȳ6rɦ2_ʈʮ!L{˫I̎aͱ_εbϸ
cзSў6ҎJӧs]Fֵ!׌dv'}ou+݇Fާh#~4CTr5
sOB6,"}nkkt
y\DFGf:vO  1j<w	`
F."
 vQ, V!*""#$N%&&')((f)**	+++r,,C--.c../u//&0}00)111(2u223]333'4g444%5_5556N6667O7778Q88889=9_9r9|999999999999999999999j9K9$988h8'877b7766d616 655j575544n484433f3633222]29221111t1V1=1*11100000000 1
11"101>1K1Y1g1u111111111111112$2B2\2w2223M3334K4445H5~5556Q6666'7k777D888F99 :\::;s;;*<<<(=|==>h>>>I??? @h@@@*AgAAABOBBBB(C_CCCD;DvDDD&E`EEEFLFFFFG2GXGwGGGGGH#H?H[H~HHHI-I^IIIJ6JdJJJJJJJJJJJJJuJXJ<J!JJIIIIIvI_IDI!IHHHHWH!HGGGJGGFFdF)FEEuE:EEDD_D*DCCCgC9CCBBBzBYB;BBAAAAA|AcAHA+AA@@@@X@.@@??y?K??>>>>Z>3>
>===Z= =<<o<0<;;n;-;::h:%:99e9&988p8>8
8777\7=7766666s6V67665555c5<55444n4D443333l3K3,3
3222w2L2"2111P1100^00//Q//.}.7.--q-0-,,u,9,+++L++**b*$*))l)+)((_((''E'&&o&)&%%X%%$$^$"$##|#F##""_"#"!![!! } 5 bP yX3uP*pS8a>];x[=^8l=X+jP7 iEzZA' (18=DIJGB>:60+%~kR2xHe9
d:


r
>

Og1


p
F

				e	E	)				3	G	Y	h	s	~															}	s	h	V	>	%		lH}HVb&a;=<  8 0,=_QD x5m,k/GXIw1_g+\*k;d/tG! `A#Z/nTD7(!&-6AKU_js}*Rz4Y|,D[s0G^tzfP7wX5|Z7nZF3eE%^:q=e'k'J j<Xmz&uk޳VܟFۓ:ڒB٢T	ٿu+ךSցE՘c5ԷԎhCӲӐmJ(ҩҋpV<#
ѿѮџѓчznbWMB7-#иаЩРДЃraP;$ϲϟόzkaWND9,ΰΤΞΛΗΓΔΛΥίθοο    νάΗ~fO9"Ͱ́͘kP,̯̃K	ˆH
ʖ[$ɣ{S-
ȡ}X3ǝwQ-ƱƔ{gT@-ŴŧřŊ|n`RD5%ĿĵĦĒn]N>. üóëäÜÕÒÖÝåìôÿ%*/9LgĂěĶ-W}şž9QhƚƷ
)Ikǎǯ!MwȣNɊHʍTˏE~̱Evͥ+\Γ=tϮ(dЛ+[шѭ7XxҘҹ*QyӢ&Oxԥ1X{՞	.Sw֠G׃=}ؽ4hٚ)UڀڪEۍm,ݑXޯJߙ7Tt8nPU5kEh#@]'cCN="h6/8ZdV:'Id7J?
V.weUML	 h  ,UX8}KMtl		V

(A9


IxO(B.qQU>:UK~7i+Sv*D_|(CVj}yne\TJ?8:FYjz":Pfz!4FXenu}   - B \ v     !&!A![!r!!!!!!!"6"U"v""""###C#b#######$4$P$m$$$$$
%,%H%_%r%%%%%%%%%%%%%%%%
&!&8&P&i&&&&&&&&&&&&&&&&&&&&&&&&&'''+'>'S'i'''''''''''((
((($(-(;(M(a(t(((((()()C)])x))))) **-*B*X*m*********++++A+Z+q++++++,&,<,O,a,s,,,,,,,,,,,,,|,v,p,j,d,\,S,J,B,;,5,.,',!,,,,,++++++_+:++****p*V*>*,* ***	*)))))))j)I)()	)((((\(:(( ('''u'Q'/'
'&&&u&U&6&&%%%%l%N%,%%$${$P$!$###`#8##""""x"_"E"+""!!!!s!Q!0!!     k Q 4  hF(wld[M5mS;*	}umgda^XSSUX\]YPG@7(}ocWK>-w^F0|fO7zm`TI?5+ iP7kS;#pS2zT/	jM3rdWI;(nVD6*yiZI9)v[?$yeQ;#





}
g
Q
<
(

|k\M=.!x[=





q
]
J
8
%

						y	i	Y	I	9	*		
	mQ5vhYF1nXA+y_F,ygQ6v\E4$n\J7#vcQ>,      i P 3  lR7 oO0xk^OA2$xaI2~jVC1!yjYD-gK/wV5w`H0ubPB5(~si^P@/q`O?.wfUF7(lYJ?6,"	 tfYI5	pbUG9,~p`PA1!zm_J0zqiaXM@2%
xj^QA.         
      RSRC     [remap]

importer="wav"
type="AudioStreamWAV"
uid="uid://os7royxdwdri"
path="res://.godot/imported/a.wav-806934642ad5fb41936d4be875897790.sample"
              RSRC                    AudioStreamWAV                                                              resource_local_to_scene    resource_name    data    format 
   loop_mode    loop_begin 	   loop_end 	   mix_rate    stereo    tags    script           local://AudioStreamWAV_gnri4 8         AudioStreamWAV          a                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   	             " % ( + . 2 5 9 < @ D H L Q U Y ^ c h m r w |                     $,5=ENW_hqz%0;FR]iu -:GTan|-;HVdq!/<JWdr 
'3@MZgt(4AMZfs%1=IUamx			#	-	7	@	I	R	[	d	l	t	|																																																																																																														y	r	k	d	\	S	J	B	9	/	%				|naSF7)p_O>-xk_TI=2'xiZK<-n]K8%v]B'wX9wV5    a =  Y2
mF\7bD&~dK2 }aF*zcO<)q]G/oP1kK+lK)zS+^4	g>[7\8jI)
v[?&pX?%kP5v_H1vV5Z1a6oH"sO+vQ,lE! |`D&
o]K8$q^K8$ zodYM@2#߻ߩߗ߅saO<+޽ުޖހiQ:"
ݽݤ݊qW=#ܻܠ܇oZD.۰ۘۀhO6ںڣڎxaK9*پٵ٬٣ّٚه}si_VNE=741.+(&%%$$#### 	ػصخبآ؝ؘؓ؍؆~vme]TKB:2)
*7CNXblv؀؉ؒ؜اذع
&3@M\jyهٔ١ٮٻ
 $),05:?EJPV\bir{څڐښڤڬڴڼ	 +7DQ]jxۅ۔ۢ۰
5Lczܒܩ
 6Lbxݎݥݼ <Wrތޤ޽1G^uߋߡ߸ 3Lcz';M`s
 4H\q-AVk#4FWi~.Jf1G]s"9Pg+D[p3G[q	->Qdw$5GZk{+?Rew)<Pdy/CXm/E[q*;M`t!8Ne|+?Sg{%<Rh|*AWn	5Kax
"9Ph'@Zs&A\x <Xs$<Um2Lf:Uo#;Rh
'A[t)D^x  0 F [ q       /Hb{&>Um-E^v7Pi"8Oez0H_v+AWl%9Nau		*	>	R	d	v									
#
5
G
Y
j
|







'8I[l~&3@M\jx



(
2
<
F
P
Z
d
m
w














"+4=ENW_hpx&-4;AGLRW]cjpv|














ysmf`YSMG@:3-'"	}sjaXPH?6.%	













u
k
a
W
M
B
8
.
#



yncXMB8-#wj^QD6)









u
h
[
N
A
4
'



										t	g	Z	M	A	5	(				znaUI=2&}si_UKA7.$	}si_ULC:1)  ztmg`XQKE>82-'"	"(.4;AGMTZ_elsz
 *4>HR[eoy
#/<IWdr!0?O^n} 		#	5	G	Y	j	|								
"
6
I
\
p








2F[o *@Uk

1
G
^
t






-D[r+BZq0Ib{'?Wo 9Sl7Pi 3Lf(@Xp6Oi*C[s1H_v(?Uk1EZo';Obv%8K^p!3DVhz#1?MZhv	)3=GQ[dnw 	      " & * . 1 3 4 5 6 7 7 8 8 9 9 8 8 7 6 5 4 3 2 1 0 . , ) ' % "           xne[QG>5+"xiZK;,
}m]L<,
s^J4 lV?(u]E.kQ8}bG,nS8 gG&hI)	gG&}[9kG#mH#jD^7pH 



`
9

uM$W.


l
F

				_	8		zU0
oH"_7pI!^7sM'mI$c<   t L $ Z2nF]6oGW/h@Y3
uO*pK&c=a?oL*`>sR1tU7hL0oS7qT9qYA)jR;%q[F1wdQ=*xeR?,zhVE4#|k[J:)	reXL?1"sgZOC8-!rfZNB6+!
{rh_UKB8/&	 yrlgb_\XUSRQPNMLJIGFDB@>;96420//.-,,+**)'&%$#"!   !!"##$%%&%%$#$&(+-/124578:;=?ADGJMORTVX[^adfghhiknqux|	!'-4:?DHMQV[`ejpw~ &09BKS[dlt|"(/5;AHOW^fmt{ 
$).38=CJQX^djouz
 &,29?EILPSX]bgmsz#)06<BHNTZ`ekpv|")/6<CJQX_fmtz !'/7?HPX_fnu}	$.7AJT]gr|)5AMZgt
)7ESbr-<L\l|.?Qbt3G[o%:Odx!6Kaw,BYo-E\s'B]x5Pk	#>Ys,Gb~	%A^z"?[x&Ed >]};[{ !Bb'Ik 2 S u     @c?dCh &Kq&IlDi/V~9_	3	V	x				
)
L
p



 #Gl$Jo
%
I
l




CgAe8Z{>^}'A\w(?Vl)AYq1G^t(A\y6Xy=[y7Qj
#6I[n ,:JXhy&8J[m 3EXk~
 (08@JWgv #&)-26;AIR\eow~}wqoppoos{  & 5 E W l        !%!:!O!c!x!!!!!!""6"Q"k""""""#*#@#W#o#########################################$
$$%$2$@$S$j$$$$$$$%1%I%_%u%%%%%%% &&-&D&[&r&&&&&&&''-';'B'B'@'?'='5'&'''&&&&&&&&{&s&k&e&b&_&]&Y&T&L&C&:&2&)& &&&&%%%%%%&&&)&6&C&R&`&o&y&|&|&}&~&{&r&d&V&I&:&)&&&%%%%%%%%%%%%%%|%y%u%o%h%`%X%P%H%>%4%*%!%%%%%%%%%%#%&%)%,%/%0%*%%%	%$$$$$$$~$v$m$f$n$$$$$$%!%@%\%h%e%_%Z%U%D%%%%$$$$b$C$%$
$##########n#H#$# #""C"!!g!! y ( c8!3DSg # 3 C U d p z        !?!i!!!!""("="J"G"7"&"""!!!!!o!T!8!!!       x f P ' w=>xN%qS(o2sF&{W2 o#&Y6%]%s]H6'	g;k)I t.

k
9

q>n4


N

			b	0	f3rYB*{hM*}iT?0($!	fAZZ1 : 5Q$Lp>|T+dEh<scUG6s"v#|(0O:Y(l`0b.R}R(`*iw-n/vOE]{5bjos"ݓPz+ۏ?ڎ1}-ؘK׫׈d=ֶ֊YՅ:ԥX
tӭ?h`B϶+΢͏̉ˢ0ʽKiǉǓƍ
ŕ&ĺL/M["ɿa9ݾKm"ܼ^໬kP3Ѻf6ƹ[/ูc4ڷcöu%ӵ+״'ɳj
BϱZu	9ήl%ɭmRF>5*ެլĬ{hT?,
 ѫ{>w-٩%ͨ~9v7Kᥰ~L! ʤsU7ޣh=
ޢ~DɡMkӟ5㞑H
ݝ~NĜh3J TTL_0֖ǖ}jWG>=?AADHNSXXRKE?3 ˕iCӔa Փ1⒟mD̑ΑޑAcԒ4cLzڔ	7lEؖ h?zߘF4vȚ(JĜPnwiYX<z0xʤm*.1jϩ1}ߪ?jҫ'g,.I|Gݳr4Զwcк= ؽzaUQKD@AFJLS`s̓ΒϦ0Vև׾+]܋ݴ+FXizGo"jm hYSE5
+%"o.? !x#%&|(8*+-_/12496729:;V=>?y@pAeB4CCgDDE%FFDGGaHHIAJJK=LLMNPOPPQRjS5TTU`VWWoXYYlZ[[/\\L]]J^^&___S```7avaaaaaaabb'b8bHbVbebubbb{bubqbhbPb.bbaaaPa
a``X`4``_______`U```aCaaaa8b^bpbbbbbbwbbbNb4bbaaaaaaaaa b(bQbwbbbbbbbbbbzbMbba[a
a`i``_t_/_^^^}^]^P^M^J^D^D^J^T^a^m^q^g^W^I^=^&^^]]y]B]\\]\\[k[[ZhZZYdYYXcXXWHWVV&VUQUT|TTSR{RQlQPKPO(OxNML'LaKJIHGGHF{EDCCRBA@?*?d>=< <^;:98857X6v543211E0q/.-)-{,++**)F)({(((''>'&&u&6&%%n%%%$$F$##4#"y""!P!  " SCx>-Mo	KXE   L!!"f""#_###,$G$_${$$$y$b$M$4$$##c#,#"""j":""!!!!x!a!L!6! !!      u [ C 3 * %   	 ~tk_QA3$zQ NtB|jaWKA?AA?EXu1j"q[u3  !!!f""o##$
%%&&'''0((.))-**"++,,,c---...f//:00112~22z3	44-55P66z788099"::;;;T<< ===C>>>_??"@@@HAABwBB:CCC(DxDDDEKEzEEEEEEEEFF"F.F=FKFZFiFtFvFtFqFpFmFgF^FWFPFEF2FFFEEE~EQE'EDDDoD@DDCCCCCCzCjC[CLC;C)CCCBBBBBBBBBBBBBBBBBBBqB\B@BBAAAAYA(A@@@e@/@???k?@??>>>b>4>>==t=A==<<<<y<b<S<G<:<-<'<*<2<8<?<J<]<s<<<<<<<=&=-=.=2=8=5==<<<<u<F<<;;;D;;::F:99l9!98g887H76[65h54b43=32210O0//..~-,n,+j+*l*)d)(J('3'&&%$n$#I#"!"! b 6wN)d=GrJ!s
V
E:
5
	R	qA!` @~]f  > |Q1!4EL@&
m2e8uh_WOB(J@!KX uofYG0}:s)Cx6u8y,84+K H{Z9fP;$
)NrAxR&sM0yFgS:JzE`4E>   P}SH]
J	

I

u#Y)a>iVI@4t ?!!"	##$$%f%%3&&&<'''3(n(((
)?)m))))!*R****#+F+`+|++++++++u+a+L+:+(+++*****M* *)){);)(((d(=(('''(*(A(d((((')?)@)8)A)@))((D(''G'&w&&%%O%%$$$$$u$[$1$ $##s#1#""b""!!=!  d  P${oM"<<BB5}
UdjM
Y
m)
h
 
|	P+K h G@:9~!WG h	`
YS;u[Oޓ]ەں9dՑԻeѶQϦyK̽BXt-ȶu=ǤǄeF$ƛn?œX ĺćQ#
	"',375-$	ûèÕÁoeb`ZXauÎåúëÌlI!¡¦:ObwËÞïÿõÕpJ'­xtwxx{­¾,KjÆæ$Myı-iŦ[Ɯ
ƿƺƷƿ'5BOZenyǏǭ-QvȚȿ
0TzɧFzʮK~ˣ˷˱˚ˀhP5ʰʉTɯs(Ȉ:Ǖ=ƌ7ŜQŷkÅ9«dSJbþpȽv+伞YcV`ظXԷGfҳ>iׯIîEʭHˬX𫋫#V󩐩/ͨg"O饃R=|3ƠTןX۞^ܝRŜ<!ۙ8QaÔ4"
+?،vMr)≟^ۈZ܇`+͆oE҅}iS>.!ńf>ჳ`A$͂qW<$؁x|ށCwT8҄,CQ Zoʉ+ sL(5ӏ#uː#yё.cɓ+X MM}ܚ9 iќ6"Mޟv&衰o4ަٰ-n>~g}ŹSɚIΥ\!խvhۏp> p3V	m%X
 "$&()+-/7124J678A:;<=y>F?@@rAABCCMDDEUFGGHIJKLN'O=PSQcRiSjTmUkVZW8XYYZ[l\B]^^_m`&aabCccKddNeefrffgaggg	h=hShLh:h7h.hhggygGggffxfCffeee^e#eddUddc]cbb-baa<a``^`\```U`J`I`W`h`}```K``__|__^1^]m]]\L\[[[n[L[%[[)[S[[[[[[[[[Q[ZZWZZYEYXXCXXWWWWWWWWWWWWXXWWWiW5WVqVUU
UTSYSR>RQ"QP"POO~NM2MLK!KEJcIHGFEDCBAA-@@?B>4=)<.;,:976x5G4310u/>.-+*)('&%$#"! 
(?W{M8!_kz>U
n

j
P


	O	Z^@SR
T}[^^		
-I
.\
mLH:5LVc}
!6  2!!5""?##C$$;%%=&&)''(~((e))U**K++G,,*--...8///(0h0001=1g111112?2_22223E3339444^55P66@77288999d:::;;<<=|==z>??^@@A_B%CCDzE=FFGHMIJJQKKL<MMFNNPOO9PPQyQQARRSdSSTvTT)U{UU VtVVWfWW XNXXXYNYYYYYZ0ZBZPZ^ZkZxZZZZZZZ([][[[[7\\\]W]]]](^[^q^t^w^}^^i^G^#^]]]k]5]\\x\9\[[s[+[ZZbZZYPYXXXWV_VU$UzTSSkRQPCPON0NpMLK=KJIIJHGF%FuEDDhCBBhA@@i?>>R=<;;R:9877B6l5432241^0/.
.E-,++t*)$)|('E'&&u%$3$#"P"! Q ^rN@9h<:-YrT/b
5

a
	N	96><,[ ( g=*!&Mu5^U{6v6X%`4n;
f+V U%qK#|_G0)Z3-Q!,?:<8,'#	z^%>   KV
cG%&o	-

eP
G9.1CXp|8of  T!!"n""#]###;$$$$$%4%<%%$$$`$$#I#""'"!m!
! } X 2   ( B r   '!e!!"f""###t$$j%%Q&&5'''/(\(((((((((((())))$)))))(((~()('s''&&%$j$#U#"C"!:! l  >v3%Kpx0r0>~)d,{!^8~

	:xzw   .20,;J
KDZjz
<uh:*P|?cVޯ݄$ۅ1ڦm3پىV اؘ؈wjecba^UI<0$$8Z؃ذ ؝9u׋\3Ԫ'ӣҝGЗaNUdlvЎа<SiуљѤѦѤѥѥѠїьрvu}чъѓѳ-iҦ3TqԂԞԶԸԝvW6Ըa
ӻju$мЦБАа<mѨ*kҡ
!()'&,@[sӊӪ"cԡ=՞by5؍
Iهٿ+=2ٵً[)إ؊qT<8CR]j؅ت Bbف١(AYqڇڞڵ%Bhۑ۶
@yܲJvݩݨ_ݯ\ۆۉ
ڕ#ٴBl֏GՔa,Բm)ӟPҪXҴcѾo,ϯn3	ΤΆ{|~~~΂·ΐΙΜΊlN5{!swbMɽ+Ș
ǍƳCv!~+xg<̾\z_ϻP/޺ͺɺ˺˺̺̺˺˺κϺú_=Ϲ@T<۶q&[>߲)ѱw)8:+"AӪdcըNҧTΦB ˥vK Ԥj;ɣ[¢nʡcv )kƛs(㚢b!֙'ј|"ėdLiŔzw
=̕cږ9jǗח&D`,fۙR̚=t"_՜
E~QY؟_g hգC82)./f̪0ث#qŬy֭1U ڰ0ڱ)q7xܳ5i̴.cϵL%nIi"ᾩuBPz.Ǌ5ɸʒf6#3?M`uՎ֧׹ض٧ڙێ܀fF"S-*8`7
&
6FTT8`rV!"'$w%&(V)*+2-{./02>3g456e7>8"99:/;;.<<=O=~===0>i>>>?h??^@@PAAB7CCD6EEF>GGHII=JJOKKKLLLLLLLLLLLLLLLLLLLLLLLLLLLLsLCLLKKOKJJRJII(IHRHGG6GFFMFFEEEEEEFHFoFFFF?GxGGGGGGGG]GGFFRF FEOEEDDDDDDErEEFDFFFGNGmGlG]GWGLG+GFFmF.FEESEEDDND"DCCCCCCCCCCDD*D*D$D!DDDCC|CIC
CBPBAA#A@2@?=?>g>>=I=<<i</<;;h;!;::P:9998=87!765X544Y321F10/J/..~-,f,+++*G*))S)	)(y(?((''t'8' '&&M&%%A%$$=$##D##""""""""+#Q#z###$:$H$D$<$8$)$$#w#0#""X""!m!=!&!!! !!Y!!!C""#p##F$$$C%%%&:&^&&&&&&''1'T'|''''C(((>))*r**N++,h,,-V-----
.......	..-..%.:.P.p.../C///0B000 121a111112%282H2V2c2r2~2222222222222233%393M3b3|33333434P4o44444444s4W4;4443333333$4L4~44	5T555D66607x777858W8l8t8w8y8|888888889I999:m::;s;;<g<<<=;=\=u=z=n=_=N=9==<<<<r<f<]<V<U<i<<<<<.=[=====>>>>>====a=3==<<|<W<4<<;;;;;;;n;^;O;>;';;:::t:B::99T9988h8/8777Y7 766l60655_5544J443w393322I2211}1K1100x0E00//I/	/..?.--r-1-,,u,;,,+++s+\+K+9+'++++*******h*@**)))N))((c(%('''N'%''&&&&p&Z&B&*&&%%%%S%%$$g$$$##U##""r">"
"!!!!z!b!K!3!!    c 8  RSY$gBx_E'pEf:{Y;|V/MDzBaC(
h<KuL*{peYND:-yeO7 





y
p
o
o
k
g
a
Y
N
D
8
%

xM!kL.







p
F

			K		j>s]F,TzB	_1	rT9oYC.{Z6   z P &   qO.kJ)vR-zW4dC&
gN3yU0wP(rCT'~S(P!f7^5
|W/^2X-a;eF*sR0
g>uW<t`M9%vcQ?.|obUI</tY:|`C'
seVF8)iR;)wcN7 ~zvttsssrrqqqnib]WPF;0&	


vj_XSNIC=60)"߿߰ߠߐ߀p`QC4%޽޴ީޞޓމulaXQKGB<71+%ݵݩݜݏ݂vlcXNE>6.'"  !"#%&&'()*,-.0258;>BFJNT\fqz݄ݍݖݠݪݲݳݱݯݮݬݧݡݚݔݏݏݒݔݕݙݤݲ#'+/36:CNZeq~ތޛީ޷  %).4<DLSZ`elquuuuvuusrqruy}߁߆ߐߚߣ߭߸)=Pbo{(6DScr
 *5?IS]fp|$4DQ]hs"1=ITamv}
'8J[l~ 5HT]gszsdUI8Z           
      RSRC             [remap]

importer="wav"
type="AudioStreamWAV"
uid="uid://cp745rve0e0yj"
path="res://.godot/imported/b.wav-eac884be30585a02151af6e7a96efdf8.sample"
             RSRC                    AudioStreamWAV                                                              resource_local_to_scene    resource_name    data    format 
   loop_mode    loop_begin 	   loop_end 	   mix_rate    stereo    tags    script           local://AudioStreamWAV_cheev 8         AudioStreamWAV          [                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            # + 1 5 8 < @ A : 1 (          ( 2 < F O R S U X W O B 5 (   	     % 6 G W f s            q b P < &  	  0 G ` v            r c T E ; 6 3 . ) * 3 > G Q ] n                  t d Q > 1 4 < C H P _ p            		       q Z B / 0 < I Q ^ {    1?M`mgR:$      .Fa~|nb^fqzvS0             ;S[^fokK"    Q  1 h    &UmF   y m c Q H [     Jz*95!	zaW\fek+b??ZgF%iQLOPPT_m}~iR<)$4Gb	)/26;>:4,$
 @c;pGLcHA@77R;MxmP|A&4Pav$f	3ayPv4o6
|t_G2  Qh3Bq`3^WgAzwnbL0  \   xs4   :~%2,-+FR-@!eD
%BkC@+Zk@T8_Z.d8
pSHC2*<h	8d
z<K$5U`n9g<](0}kU!2d/[aXORK ~K%j O  vAa\  gqaGwVJ7!Be :c&BR|+qgtQ5U}WX

y)HFEmD>Vx'  < BH5KK'UDO;7 UMa%m4DU  @gyQ  x F  - c    ZsP&    G 
  / I ] v    HS	 x X F %    ' * % !  ]7iUF+
'Yyb)mxW>RZt*ba*D]aw|xsqr:  
;sfB9:7-3]AxHw#\m'QwDYuA  qJ( @  V%u#yZ 	*+(*F^RtS4Avc.	<Wd*GAc-fJ C    ;N\$y*ZLo>``xlQ*  3r=)	i4w1J&l2` yJL HR, Z\@%-@St*8HP?_y|.:      ]  8d+-
F 8 a          m $ D %X)   Pf/         'Z0Xz\$W-         q c S 1  rK&oZKGIC;9BP^nRs=i7g$#2Je *46/%
#FhEwc=YnF-1MjFmxgM>,~s?_kdWRMA(
4DMRZabYPKF=-
 $1>N]e^PB71,'#<[y8MRONLE<4.&
&A\z#2=L\kqtxyp_M:%xuspmlotz|xtof]UNE=8420.'
$2<EMXbcYH7)
-=Ocw-?Q`ggda^WM@2&#*3<EP`t      ! ' ) * * + , , * ' # !          ! !      	 zocYRNLKNT^iv mE?_{{uqqqpmf\RH@7,"$,4>KXbfd^WNB3 #/9AGJIE@;768=CISbtu`OA3&

 +5AO\isy}|voje`[VSRQQPOLIE@;4-(#  %+17=DJMLG?5+ znebgq{|odZQLLPW_hqyyqfZNA7/+'"
}usw|xqkfb\VV]fnvp^RH>416ALV`jt}yrmg_VMD<2'uY=&{kbYOGELV`ioqsuvsj^SI>5+  #!	!@bS#i[bx	#<Q_fluzwlaVK@3&
%.=SkoP.sg[PD3tighihjnsw|v\D.
 
dH.<Yp{{{}{q^I4'+?Vk#6>CHQ`wX(Rump=]t
#>[z}vz 1BKE7'
	(<O]dfgjkhaYRNR[ely6MdzaJ6% 3m W   'IKEC=#  | H &     8 k    Ci(?Zxb>	 0=Tz3Pe{5IXbn}t\B-
*Mt';@7,$tjjv6Us$8HS\fpyBp6[	!	3	L	q					 
^



9hFu'
y

.=D
6eD'l'./-2Jt+d*WoZ>p	(Fk3DMW_c_WD$ZhkQmuuwtl\A%(Hf~Eo
!+03<B=1"kL*zl_OA>DKMKA/c/S[.y\:o.h)q<iD!g$Q_BdA#X#[
[

Ng?

j
3
		|	A	
	zeO87Wk(|`ND?7)uFy^B tU;%     $%   l 3 Fn@@iT0rQ[8?jz+_N]$lK+_-NvM%}_@iI+|hVA f7k?rO'WAq/k9d3oAm@ߦo@޾ޏ_/ݪu;ܛa$ۤd#ڙPڿw.؟\ױ׀R*ֳֈW ՟YյYӠEҚJѯm5Тr<ϛ\ϳX͏ͭ9HN]y
Ș(ǿidŶjÂ.E¾z5U(ǿpZA⾳j0齟VܼB
,NużMǻ)x߼j>j߾߾ <\U7>(Z:߾r
RȻr<[˻Pͽg@2'ʣp8ФSZS0P&f
a5t1~V4q9cpqop M  1!!q"##$z$$r%%%&1&P&v&&&'0'\''''6(J((''x'8'&c&%~%3%(%3%3%/%=%v%%&]&&o&=&&%%5%$#*#""!#! ( , ^    +!!3""1##~$.%%&{'()}*{+,-.012234R55F66
7|77&8p889P999:.:/::999w998D87f766b54463`210/+/y.- -E,+*6*)(L(''&&%%{%B%%$$$$$J$##T##"C"!!0!   n 6 }AVn
T
	T fe $-:IXh{9lVݳi3մ2ӪҀІвF1ΐU̻˂/ɢ?Ǆ!ƵƧƣƮƿ:SuǴ'ȫ ɖ)˼̐c8нӦ:gPKVؘ,,'%ؿؒTל/׫ ֚RԊӾ2eГ1zfʵp$vS?ĺ`2ZÑXĚHŝBƑƛJȤhA"μϘnK/մ֜ףضB~r#?r=pXE604;Kh# Z		
R

Y+
W@2J@   1!t!!!@"v""""""##!#7#Z###-$z$$^%%x& '''m((X)))*6*_*z*******i*S*:**):)(p((v'&D&%!%~$#0#"!!M #&qO

	"	
wF
l'	|		
g


![S
X.G!"$Q&'()~*g+8,,-;../02@3p45078h:<=>?@BCCCDqDDDDvD[D=DDCCCCECBB,BA@?>>=;:R9	86t50421d0@/2.(-,
+<*)($(p'&&p%$$+#" 1oV#f)



h

o
4
S	\bt<{4|;(Qp)kp$*&			A

s@
|

jQWzKe-
l


Ok)

g
5

		`	+	c<6		 

zpm
ZSn	,ifY2$8%?3~2Q|:=y\Y$$7<&MD`hjbXMDHTgsp^NOJ+B@
A
cOWO<U
p=7M>0x|X=8oFcl'!l"#$%& ())*p+6,,s---F........z.b.A."...*.A.Q.N.4...---^,++F*B)'('%$#"!  8;%a6')
+G

{	JQxHTMR ; #C~P"}_N?&iw4xHzO{Y'P=OjN\
e:
tP-T^ _)[NE;+]#WߣTߡ,޸]!jۂeڒ	ً"[uAԂӝҡѪкͣ́gVE0ҿ¾p4𶶵D~G©dХǢơŠݟeDyUC敦j_|0DVj~kF#ᕯt9Ӕt@ӓȓkTD(璋&ǑflޏOƎN獈%ƌ|I"ҋpT5Պ3剕373Vl-܄фĄ}X,݃m"҂IxӁ!gr`HTQ?Eڜ8epA,Eĸn6̿ßŲ˿|3Ӻ&9۹NܖE޲fY@0x:Z?$ER"$^,NO7A!ZRkPBk(X
s7/fq2qnP  
l[Q}I  [
iI)~9|F6p @:c-g=gfD?n7}	)			w^a-vX ' WwFq`@y7s|[0AhI#R@wC45>\m{E h$xF	!iSD>Dx	U  t!!G""4####j#V#N#P#8##"""#I#i###R$$C%%&&4''G((((5)a)K)((@('''&%}%5%%$$]$Q$c$$$$$$$$~$/$#[##","!6! S     ~  !v!!h""#2$$t%-&&'e(2)**+,-o.7/00102237445I677q899U::;;H<<<J={====
>>3>L>c>w>>>>?)?R???@G@@@AlAAB`BBBTCCD[DDD[EE FzFF<GG;HH<II3JJHKK<LLL9MMMMMMMMMMpMOM1MMMLLLLLLzLgLFLLKKK>KJ~JJIIyHGNGF3FE"ED-DCC9CBBOBAANA@@ @r?>p>=D=<;P;:9P9877765'5z43-321H100x/.C.-,B,+*:*)((l'&J&%+%$6$##/#""B"
"!!P!!  s :  oWD.  		
'.4:BLSQE5'F	w p|'+l6+!I\s3z
d[
W
	T	LI1"9 Y CCh!XEd1c$qH"ybF%
~hR?+&4AN[gs6Md|#2?LZgvL~9p5i9z>^' y  ?YZU^2k<Ylwj]QF>974/'}z5a(Ty			(	5	C	Q	\	i	}				
*
R
|



"Q{$t	
X

u&gLdq~8x[.v$25f9\9f+q!/~#
q

_^

S

			t	?		H&Z4o&mM=2'|L	x2  N n8wV9wU0	j5TBxI#r^K6u[A)zfP9"
kH% qQ2kJ)uV8rWC0	}mY> a?}rg]TKB8, tkkptw}2Kd}#9Nbv*BZr	!-9ER_jt}nXE6(	gI,`>t]G2"lK&uf^ZVQH:)	q^K8&oV=&eG*u]C(iK(R~MlL.cF(	y_D)^;}eYQH?6/*% ߯ߎi@޹ޔxcM5!ݼݲݧݜݐ݆wcJ1 ܨ܉qgijgo܊ܶ;d݌ݶ $)+,+'-Kށ޹'߁xm6s
*J<XVhGZB
*:Mg
T$e2]6		mW?/1ARar:`/a8u60Y<2a'Z  	{`QFD		_

~	

"xNx<S?dZ=Yn)~<y%Y'qRF1    %!W!s!|!!!!!!!!!!!("O"v""""-#U#a#Q#;#+##""s"3"!!!m!B!!    q [ Q I A 8 2 0 / / - $  la`cdfq  , B X b [ K ; - "      	   " - = P c v      
!%!=!S!j!!!!!"$"D"e"""""
#0#Q#y###0$q$$$%O%%%%%%%&&&"&+&4&>&G&Q&]&d&`&P&=&.&&%%%|%P%%$$g$+$###N##""T""!!%! c  [j"v=
bB.!lXD4( 
 *@Sj#;Sl,E^w4Oh2[ C x   !P!!!!("Z""""#8#S#l#########$$*$=$M$Y$d$p$|$$$$$$$$$$$$$$$$$$$$$$$$$$$$$%%)%D%c%%%%%%&!&6&H&V&d&s&&&&&&&&&&&&&&&&&&&&&&&&&s&a&F&$&&%%%e%4%%$$$d$>$$#####a#B#"##""""~"g"T"E"8"*"""	""!!!!!!!!!" "0"?"O"^"m"|""""""""""" ##2#L#f######
$$!$*$4$9$9$6$3$1$0$1$2$3$5$3$.$'$ $$$$#######p#Z#B#*##""""""t"Y":""!!!!t!Q!+! !  y J  e,JnENk2HQ"rFoL*s]G1cAa8)<KRUX[^`aaagv'ZBqo[I6"`>a(K`A'
d;g*u7Z1




p
]
H
3


]-](



\
9


						q	^	H	1			jQ9 #Gz<	y			
I
z



7d,p
k

u82cvhU;	 4<5+$Hz(

?

f>*l1

~
2
		:	j)^;^4H	{0e0saO;)pP0     v i \ N B = @ D H J K I H I E 7  vGoEyjS:"
wP'xM#Y3
uO)d:
vCm8e1_+c0\'X%h:vU9sU3
sQ.}{xtpkhcWB,m]O@2&	}n_SLGA;741/,+++,,+*))(#
{qh`WOF>60*$~dK4zskc[TL@1"|m`YWWWVW\agkliea]WMB8.&
!+6@IQX_fknoqsux|! |vrpljhhhhhgec`^ZSLE>7/' '/7?FKPUZ]\ZYWSMGA;643211122332/,)'#|tkb\Z\^`chpy|qeZPG?7.((.6<CLWcoz}tmhhgffm}


'09CLU]env}}xtsssrv+ASao~9Rj
#7Me7Qi-E^w4Pk5Law)9Lb}%D`z	,?Qct6Oi
1E[s(BZn*AWm1H^q.>Pcw'>Um.Hh,Mm#.:Kb|"@\u
#-7AM]o7Z~
'Ed~ -Fg  7 O i                 +9HWgv!-9FUi}	+:IYhw
 $,:JYh{&A]y*@Zs <Um +8FRau		!	9	Q	g	|							
$
7
H
Y
j
{














(>TizrcRC>HVbn/H_wsaO>0'!"9Qf~
$
0
<
K
T
T
M
E
?
8
2
+
$


!
/
>
J
[
t




6Ts	)A^~5Sl,Lm:[{"-9FMI@6.%	(2<EMU]djnrwyyupliikllpz#7K_twj`XQHABKWalvwfS?-!#/;FSfyzuzxkaXPG?70)!ziXG6$sg\PA/	wbN9%uaO?0!|gSB3"vj_           
      RSRC     [remap]

importer="wav"
type="AudioStreamWAV"
uid="uid://p2n7ipnygwfx"
path="res://.godot/imported/c.wav-c09367f6ab4ea7cbdeac7abbaca36649.sample"
              RSRC                    AudioStreamWAV                                                              resource_local_to_scene    resource_name    data    format 
   loop_mode    loop_begin 	   loop_end 	   mix_rate    stereo    tags    script           local://AudioStreamWAV_quk2b 8         AudioStreamWAV          X                                                                                                                                                     
               " $ % ' ) + , . 0 1 3 4 6 8 : < > ? @ A B C D D D E E E F F G G H H I J J K K L M M N O P Q R T V X Z \ _ a d g j l m n p q r s t u v w z | ~                                                 

"%(*-03579;=>@ACDFHJLNOQSTVXZ\^adhlptx} "%')+-0257:=BFKOTY^chmptw{~ 
!'-3:@FKQW\_bdgjkmoprux{~")06<BHLQVZ^`acegikmorux{	"$&)+,-/01223347:>AEINSX\`cgjmpruwy{|}~~}{{zywtqmjfa\WRLGA;5/)"}ytoic^XRLE?92*!~tkbZTNGA=:863/+&"{qh^SH=2'|rjc\TNIEB=94/*%
             v k ^ P B 3 %   xlaVJ>2'~tj`TH;."	scTE5&uhZM@4'rcSD5'~rg\PE:/%th\PE:/$xdN7 
woh`XOE:0&|zywskc[SKB90&}uj^SG:*{slga[UOIB<5+ 	{yxvtsrqpolhc_[VRMHD@=;864321000122333331-(#
 {pf\SI@80)!	
#)/4:@CDEFGGECA@@BEGIMRW]befhijjigfdb_\XURPMJGEDCBAACEHJLNPRSUVWXYZ[]]_bhow~	
&.7?IS]fq|%0:EOYblv~".<IUbo}(4@M[ix.>M\l|#2BRbr%1>LZiy-=L\ky+<Ocw
"7K`u"5H[m,BXn1BSdu  , @ U j        (;Ocw+AVl'<Pcv
!8Pi.E\r"8Og}4Jay+AWm 		*	?	U	j								
+
C
[
r






4J`v&=Tj

0
E
Z
o






/EZp-AUi}$9M_q+>Pcv
1EYl} .=KYgu 1AP_n|!.:GTamz	&09AIPW]djpv|

	~vme]UME>6.&vhZM@4(|oaSE6&udSB1 zfR=)u`J3jT>'qYA(hK/




s
X
=
#

qR3}`C'




h
M
1

					j	N	1		rW<!{`C'|_B#oQ3sW< {^B%~cG+hM3     h M 0  zZ:yX8yY:sP,	|Y6\5
mDxO'^6rK$e?hE#|\<kO4{bJ4sZA(~hS?*t`L7"
v^F.qYA)|aF+tZ?%pXA)}fO8"xbL7"q`QA1"}pcUG8)zqi`XPIB;4-' }xtqnljgd`]YUPJC<61-*&# ! 
$*07>ELRX_els{&2=HS_lz'5DR`n}&3>HR[ep|/>N^n~#.9ESap~ !2AP_m|
*:JZjx	.@Rex%6FVfv#4DUgx!/=KXer-;IWet!*3<ENXcny%0:DMU]dlt|!)1:CLU^gpy'/7?FNV^ejnquxz{|}	)3=EJNSX[]_`bflt{ 	
#(-38>CINRVY]aeimpu{
!'*+,-.01346:?DHNT]emu} !+3=GUcr#,6>FNV^dintz	"*29BN\ky+9GUbn{,D]w3Kcw	#0>LZiw&8Md{$:Odz   : T n      4Ss.?JT`ksx} Gk>j4Yz#KqKy(Sy		-	@	T	l					
H
y



;l ,U&
N
v



DzI.}nO'c>l;g#c'mMC~+OuEy6v^ L#j K    !L!!!!="""#S###=$$$%V%%%"&c&&&''n'''F(((2)))'*v**+c+++?,,,-Y---#.e.../Q///0=0y00051v111>2223\33314y44485r555!6W666647q777'8m88
9V999P::;];;<]<<=W===3>|>>>+?d????@J@t@@@@@ AA?AaAAAAA%BTBBBBBC"C<CQCcCwCCCCCCCCCCCCCCCCCCCCCyCtCtCxC{C}CCCCCCCCCCC~CoC]CJC9C&CCBBBBBBBBBBBBBBBBB	CC"C!CC CCCBBBBBB{BfBQB>B-BB
BAAAAAAyAPA%A@@@k@/@???Q? ?>>>`>6>>===W=)=<<<a<,<;;;W;!;::|:D::99a9(988{8=8777@766|6;655l5'544J433W332c221n1 100:0//c//..S..--Q--,|,5,++]++**=*))o)+)((e($(''\''&&M&&%%9%$$Q$$#e##"w"("!!N!! w 2 b!f(`0 tE^#c"[ERP5}"lp }).$n
c
	
[X




c
I
0

				[	1	QU(&Nt'Jl	7	_				
0
^




;QX[djaC


|
@

		W		r<g4 f5sW@&#0@UlbF'T$^/xFw?  U " eC*7`% P x      
#&%##"      i M .  qO-|Y8tS3wR5pV2j*z	,?96,!9Q<8b[V) aF(a,w:{9s,UC Mi-|7h ߃4ޖ>݋3#mۭG٨4Nf{Ցԡ)Ӳ:IXeo{͚-̼PʡRɭ_Ȁ6ǣ[ƀ5šW
v*ÕLøo/R"c=пU,׾|N ˽wN)
ټ|jV>ջU⺫r4v9 ȸY!뷶MֶOɵ|,۴;峌3۲.ٱ0ݰB_Įw*ݭBZҫL֪|KߩƩ{qi]TONOPPNKHEBAACCDJVdp}ũ̩ȩnYG:."	ިӨɨҨ"<UmũΩةݩשѩ̩Ʃũѩ۩	3CHE@?:,ЩөEqĪ	(KjūЫ׫)D`}"3AP`mu|Э+bٮNݯ&n$]˱@g²۲2Tv'`ϴ
Gõ"A^öʶҶܶ/EXnBsTzҹݹݹڹֹչ߹
5YǺ0mHӼLǽ5Tsƾ;վ?jƿW3s0gµ8eÏö+zcŭAƍ#EkǍǣǲǿ7iȔɃOʵ&ˠ̙su.Jgχϩ	EКEќҁӂ|yx,p׿9KSaoz؁؅؄؈آ$`ٞlunT?ޞ.^߆ߜߪ߷H{O+~{Kx]7{ C
O*xbbgn$6Ne"8?1z
ZJY&S(r
 O    6q&b;qj[H$m	^		
Y

~<
f




"$%&.EdE$y2$VGNXW`t]A3RrP:
lG  !!!@"""3###.$$$/%%%X&&$''({((a))L**7++-,,)--)..7//J00R11N22Q33o4 55%66\778399"::
;{;;!<m<<=R===>\>>>A???7@@@[AABKBBBC7C8C3C<C9CCBBeB-BAAAaA7A4AUAAAAAJBBB@CCC D?D|DDDE?EoEEEEFCFtFFFGRGGG9HHH/IzIIJ]JJJK>KrKKKKK
LL#L$L%L(L*L(L$L LLL.LBLSLdL~LLLMTMMMBNNNSOOP_PPQsQQ3RRR^SS8TTUmUUVtVV
WAWyWWWXX
XXXXWWWnWMW.WWVVVVvV\V<VVUUWUUTaTSS/SRqRRQXQQPPPPP,PPPOOOOOOO|OoOcO[ONO1ONNN[NNM*MLFLKYKJcJIsIIH0HG_G	GFdFFE~E?E ED|D.DCCACBB+BAbAA@k@@?????????&@W@@@@@@@@@y@a@L@;@,@@@@????z?J?
?>>W>>=K=<<(<;8;:J:9r9
9868777766A655X5	54c443f3
32C21|110v00//C/
/..].2..---y-a-I-/-
-,,|,K,,+7+*f*)u)(h('f'&&&%<%$$E$##l#8##""^"""!!l!! w % 0<	kj{'R}!Jp  6 L b y      !O!!!!"W"""
#G####)$_$$$$*%T%w%%%%%&8&T&s&&&&'H'x'''(V(((()M)u))))))*.*G*b****+B+p++++,2,B,M,Z,i,p,g,Y,K,@,4,&,,	,++ ,,),:,Q,r,,,,
-0-W-}----.B.j....%/T///0a000N112p22>33#445|55t66j77F88999%:h:::7;m;;;
<A<t<<<=B=|===)>j>>>H???@c@@@2AqAAA+BlBBB9C~CCDbDDDNEEEKFFF7G|GGHLHHHHIIIgIIIIIIIIIIInINI0IIHHHXH'HGGdG$GFFOFFEsE7E EDD^D6DDCCCCxC\CAC"CBBBuBHBBAA_A%A@@@P@@???Y?*?>>>}>R>">===R==<j<<;p;
;:A:9{998W877R776m6&655o51544t46433^3
32e2
21I100#0/[/../.-w--,e,
,+`+	+*G*)t))((('3'&=&%$%$	${#"W"!2!  }[4	tJ!iN5<I`!Hl

.
H
	}	2	Vo5W`n  $ ZIbC^_	XRCl9a*s4v6v:Mb$Jq)U#{6[t}
CtT=dwk_O;%!5KnL*b%T
M8d(R+j
0Sx/YNY-K]T>% ]
H 8 e    '39;<:>Qr	C,^=[~r\H7'->Nay}UOHxR+   n B  }=<F-:^[Av1F^A OnemV@o~"w"x$2E.Z/ރNܰی)sؚxT.	עׁS׮Z	֪(՛Ԇe3љ	Б#ϳ@ͅ@̷nx(`go5ǐKŠ>ÌH0;ڽsSE躈(ʹj4ηe	 6HԲkN𰡰e/P!Į]&񭽭P߬l,髦e'|Bϩzqh_VNKR\fpxcF+⨲Q&ȧ}ywy|zql^>ᦷLz:Ȥ{Ф:aȥݥߥѥĥѥ*AYq{wwxy~ʦDgҧ,Ty¨5\ѩAŪKΫRά
#3=FPYbmyĭ׭.Li®Юˮc3 ѭzS-ڬkVB/ݫϫp[;٪zL ĩo[L:'	˨xiYG5'$%&"ӧۧ*E_vѨ=Zvݩ'Bj#^˫>sˬҬլԬӬ׬ =fK%Lpѯܯ߯	(L|ްOڱb5|>yVŵ-h#ea߸Lǹ\D _sֽ6hf_=¬&Ù(`ĢEţPƬ-fȑ:ʣYjn
Ѡ/]Ӂ՛.ր2؈Q3
!$
 /=L`u "M{	
	
<fEn p!M")##$l%;& '(
))*+,-//0123Q455,66M778Q8881999
:`::s; <<o=%>>?@AB]C&DDEXFF0GGGLHHHHI[III JgJJ3KK&LL"MMZN OO!PPQQQXRRRR0ScSSSSSS"TITfTTTUaUUVVVVWWWUXXXQYYY9ZpZZZ[^[[[[\Q\\\\]R]]]^O^m^^^^^^^^h^Q^<^!^ ^]]]]]]]]]^-^>^B^<^5^/^^]]X]
]\]\[[&[ZlZ!ZYYTY+YYYXXXXXXX{XBXXW~WWVVUUTSJSRRvQPePORONNBNMMgM4MMLLLJLLKK>KJLJIPIH6HGF.FE	E|DCYCBBeB:B
BAAAAAAAJAA@@D@?V?>o>== =<<;P;::>: :999Y9-99888x87877~747664655m5*5444p4T454433333]3*3222j2,2111V1!100{0]0G0-0
0/// 0	0
0000	00//w/C/
/..3.--]-*-,,,},z,~,~,,,,,,-1-C-V-l-~-y-Y-1--,,u,,,++b+:++****+&+G+q+++!,\,,,,-H-e-l-k-n-r-j-Q-/--,,,,,{,x,,,, -X---_../b///>0}000011#1 11111111
1'1Z1111:222M333*4i444	55"5,575;5:545-5,585Q5j55555:6s6667K777778 868A8@89818-80888>8A8F8^88889J9y999:,:3:0:0:/:!::999t9W9=9 998999(9@9h9999 :@:]:}::::~:a:G:&:999W9)998888888889,9S9z9999999999u9T9'988|8G88777}7n7n7r7t7v7}7777777777t7F7766y60655L5544X4433333333~3u3_3933222P2
211Q1&10000000000000~0i0O06000///u/Y/G/8/(//
////////.....a.7..-w-,-,,L,++^++**W**))U))((C(''l'&'&&`& &%%A%$$O$##C#""@"!!c! !                I s+DmDx5f  Ur'gH+PY`z/c/_/_XW 
O
?Z

S

		g	$	HSJ~?o8K  t :  Qv,sBo)v'C[2d2 b&zL"xcM9)aC%wR)}S*^6Op0w=^1Z1h?zfTB.mBVq4yDxj]M7}B{9q.ߓe7޿޺޻޽޾޻޵ޫޣޜތmBݐZ#ܹ܍f?ۿ۩ے|mbXNC7+ گڐn?ٌRةp:׫׊hG&ֽ֐c6	բj4|6Ӭbӿmр4МQнs)ΙR́D	̓Y˯w<ʽ|=ɹu1ȮxHǷǑoN,	ƻƓkE!ŹŗvU5ģyQ&Ð^,oAgB t^H0ʿW/ྐྵkE'ν{ung^WQJ8ܼoB绽mE׺{]@%	ӹnS5ָnJ'ٷķ|wph^UMC7) 
߶Զȶȶڶ0Mgʷܷ߷طзʷη߷	6UwոݸϸzbN<(*4Gcɸ"?\r˹:\%Vۻ/Pkռ7Uuս!Hn4[~޿0DXn0c3i¡ExíL{Ĩ0]ňű8gƔ+gǣLȄȿ*Onɏɲ7SsʕʴFq˜*^̒(Y͉ͺ;c΋α>bωϱ *XЇзTщѾ-dҙ1dӕGuԥ@iՓտBo֤I~׸5rحZ٘6fژ#Lv۠-Z܈ܼ3mݧ\ޛGy߬2Pm-Ps(g!a$V~*=Pg%b"r5SN7_
/ZaTv;w)}(r$^J#6sT~?1zcU	i%   a:g;f*M	l		4


>F1
~

o
YW N64nFy/n1x;z+b"R|*[%Z8h
0Lg/Pv P|  B _ {        !!(!<!R!m!!!!!"8"]"""""#$#;#N#^#m#y##############	$ $:$P$_$j$y$$$$$$$$$$$$$$$ %%%#%,%7%@%F%E%C%B%C%B%?%:%5%0%,%*%)%%%%%%%%
%%%% %$$$$$$$$$$$$$$$$$$$$$$x$b$L$8$#$
$##############s#b#P#@#-##"""""c"G"+""!!!!!!!!!!!!!!!!!!!!!!{!m!]!H!1!!!       | s i ` _ h t ~               | [ 9  k[H6+0<ELUj  &    ^>%(@Yn{v]G.e?}lYF2
q`O;*&2?KTY[_df_ULC<5/&!-8@Mf1Ngu}wl`SD6'
	 &-4870)%nK(th[OE=5.(%$#""! 	|ocVG6&rdXOF=2#seUD4*$ 	hO4|dPA4&y`E(}j[SMHB8)~[5	|Q,qY@'kR6|[;{xuqprw|}n^P@*





n
Z
L
A
7
-
&
#
#
#
#
"
!
 




g<Z9#

 
$)052%




z
^
C
)

									|	y	v	n	d	]	U	J	3		_:mP5kR8~pg`WMC9/&{fR?+oU4nL/%0<HPRLD>5%v\A)
	      z V 4  iC#ucRHA;3,'%#!qbP;&ycO;(
lS;tlc`es
xjZI9&o]NJMPQSUWZ]^ZTNH?0
yri]SMHC=841..047<DOYcnxwi\OB5*	!$%%'(%,CWdo|{z}		1EXk "-:FSao~$*/38<@CGKORVZ_dks~wog]QB3% !""
(7GVaiq{}{thZOHC>86:GZk}$=Uj{{n]G/zppu}!L{5Mapxskd[N8!
yrqtvqhdhopkd`^^^\ZY^gs~,E[o~)B[s,Gc{zjXD2#"-:KbxlP.aC&
/@P]gmonlhd_YSLJJKKJIIKOTWZ_elrx|voiea_]^_`dint|1G^v  " / < H Q U R N L I C 5 &         2 J c {      )?Tgx#7Lav3I_t 
1DYm         
      RSRC [remap]

importer="wav"
type="AudioStreamWAV"
uid="uid://do6lbgat52lu1"
path="res://.godot/imported/d.wav-e8da21e38e51ec10b0134a6de042db44.sample"
             RSRC                    AudioStreamWAV                                                              resource_local_to_scene    resource_name    data    format 
   loop_mode    loop_begin 	   loop_end 	   mix_rate    stereo    tags    script           local://AudioStreamWAV_hi7yp 8         AudioStreamWAV          4^                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           
  ' 2 = G Q Y ` g l q v {                
0F_y0Sv
3Vy4Oes~zm`RE7(	+Il#Mw4WreH*
u_O@-%'->Ws*X>~ B
	I	~			
H
b
x






w
X
$
		|	<	Ncz4d9	=fF|%Gk|yoU3k7QCe|B
'A\{'Il!Hn)03<A6Z$\1y\?#	m[PRY]ak,60$e<  ~ R 0  ubK2nTJJJDHdT! c   Q+Qs5\ Jr
 -8FR[^`beggggfd`\XSI8$oHt=
X5%*7K`v1V1p-y s
N=Pa{~bB)
rM2"1ARct5Sx	c		
t

mh#
q

8

o



-
	|	#		
						zq>~`+7v6
!	5
^~&
M
	/	v4uB]		d

_
5
-
	X	bVdq{s   
 R :A+				
V

|
!
	D	Y!*r>			#
(
	M	}_=% 7I;xEj &      j!  50\/  1FUV~y>~K-\Aii-M  u,  )?eZ~Gw2Azw^%_e^I>Y.q_L0qO,*VxJhI=7iyN-~7nPLPRQK?1)k%7rmzv.c"cq_K6)/?MYk"2:DPM+_*XLT`dvJAm+Dj	7b	p>i@#\/}G fY1X(RhvtE41^7<_K;VjolkkcWRSZh7;P   7WO)   P cs/pF!i,ckZ$6hOiX.iW|r<bn5]pWi@	{KX~wO#pEJV0\As	4d[)1p3n+h&He1H^qa?'Z?uO`P[q-ZVX>]Edqne`VI<.cx%F8;=>r@
*_	QZ)Tkrnjgilnnq~vFin/f9".9BPdyB7/~&\sV9_>[E GvubZ]MNOMRh2Tv/FYj}sZ/}Bp(xLsL#Uq+l.z;X
]WߕUޯ~KݐM5۠[ڲzJ, 
ٴٗ{_?طؒiB״f{֕ՓԌlLWn΢^"͠nJ,̧̅dB˱ˍte]PEERfyˋ˞˱˾˪z$˹U}Hȧi&ŁDý??Qw	+Iؼj3˺jչEܸrbXOF;)ӷb<޶b%浝KU6ղsO찌:g%uۯ4*ͲqWRW\]L(Ҽu2进T!fɵ<nΘ
҅DԱm*ӗ ̀}ʓʅʩ
(Go˖˟g˥Jf5ȗ$(Y)HVteќ%ԃQهpnި&ߜ0_t9~!')AXtXC\b g&Rk	
z'
@gV-Ee"QXbVa^E~$m3 !#!%&'e)*+,-u.S/00d122w3?4	556j7?899:[;;#<<<<<n</<;z;:A:998F877`7g77 8v88r9K:<;<=>U?@A:CDFyGH$JvKL*NOP+RcSTU W	XXYYZ[[\B\\\\\\\t\C\[[F[ZZ
ZwYX\XW&W|VU'UTSuSRfRQQ6QPP>PPOOOOOOOP9P~PP2QQQ>RRR^SSSST/T=TTS]SSR$RsQPPZON
NgML"LKfK"KJJzJJJJJJK7KfKKKKKL?LdLLLL
MLMM	NdNN=OOwPQQJRROSS`TTTTTTTTeSRIRQPONMLKJIHGFEDCBAA<@[?>==C<;:B:9>98D8777F776666666677(7=7S7i7777778888!8!8877d7,76\65s54q431321X100v/.A.-!-,,{+**)))(H('}'''&&P&	&%%s%F%%$$$X$'$##e#!#""M""!m!+!   O  Z\,I N#~0qN,{/d-pe]RIDCDGB$j)
B
n
*
	f:oo:
 )7NnEZ-qjo1M9  $ i;Qm:~UF1@[N:Xy/Ot),,1.a'ShJ&1G]~2Vry\>"
jR;jM3
$UUa{J s  )&j5n>g\"LG}`>");GW~ ?/\-tH_		@

& !


Q\zY)jF25FS_u1`@c<l#?pNF
+4;FNG5"6JZqPQ0+@90 Y   4!i!!!!!!!!!!!!!q!Y!5!!  Y  Y=)Z;2SW@>- }  	!D!!!!"9"Y"y""""s"i"V"+"!!~!B!  C 2_'U%u{9wC{i[J:0-./-"xP&V!^.@g u_I.	_M6 E
Xm
	[`R  C kBiC"/_0P`mr@O%aBb/mI& YMS	DmYC1r/8g K e#o_QB-S{X?#4Lf"$"$$nP1uO' c9mgp9U(mvIjR8

Kguz=	gI4!7Q{GzJgxzm`TH;. zX2Ro0zJybG.q`O?4&
l6?ߙAގ5ݥp8ܢ^;۷ۈZ(ڮl+ٿٓe5
طؤؓ؀b=סuHּփLՒ8Ԃ&ԺAJXeqϥI͋9̳o,˯s8ʽx2ɦb!Ȝ["ǤzS0ƫzDŦcċ>È.p
	CջqӺ6빥`׸D[
jȵz9ĴR5#
峵q*첥BαTݰj>ծw> ҭTZ{y$اg*򦻦}7不a䤮w@ѣc,|>ɡn@֠Ǡn^M4̟]&y<':Ge)vנ3LMǡ=ˠNӟj3
rߠFۢ颺yN'dОe8\Ϟa۟YTţLDƥͥ¥ȥ7]H:"2GWT1 жzV4׻ּ*tüşǇg2_ќ֔l(ٍEڋ2ۃ)ܗ
݉pި߰Qݴ֩?ծT԰ԏՎZGثmNIe	,]$Cwn@@ q8	0n+HdSToPG6 !"#T$%&h'%(()i*.++,o-G.Z/012 485v679+::;K<====j=U=5=<<.<;|;b;e;d;W;d;;T<<o=>>?@AzBrCuDzEzF}GHIJKLM?OPQ SiTUWYZ!\]I_`zbcdefgdhhvhhhghg g}feBeddpcbnb;bbaaaab,bQbbbcXcccVdd$ee
ff|g0hhijk!mAnooprestuwx6yNz<{{,||}e}b}9}}||a|{X{zVzyx=xwvvduts;srrqqp%po{o#on{n-nmmCm
mllylPlLlclllllmUmmmmnn,n:nnmmRmmlgl	lkNk
kjjj\j<j(jjjiiiMi
ihzhhgGgff]f3feeeeef*fGfgfffffffYf.feeedAdccZba`_*_T^z]\[ZZFYsXWVUTS
SRQONMLKJIHGFFCEnDCBNBAAc@?Q?>E>=a=
=<a<<;;;t;Q;3;;;::::c:?::99r999 988C88774766O655@54443!32.2100i/.-,+*	*)('%$##8"Q!m 2~BzYI4V1
a8d#i-w;H6
w
uj
V
	/	%b$jOII@;F^x pT7v]A"l4J  i ' u=$8@MxE  hT&08?CFJLG2UcEsORjf42Ldz		

:g 

~K
pS/MoF:SN;($d5Q"3:'nge1 !"#c$4%&&'?(((\)))))**9*\*}***+d++#,z,,1---9.d.x....}.G..--C-,,@,++P++*v*2*))f)()((%('''&%~%%u$##v"!>! & Q#y\3L
z1sHjA  !I!9!!    Y~H()6GRTB)
"C=}#mMP:!

m?
	6	}(h5l>mlG  R " h5\dx]n],k,yKdI(U3lAVTYw
,&	T< rN zPcDwkY:e^O/Ghߐ2Z~t_A!(Jf{tIߧ`Bݳݓ݋ݒݟݱHsޣ#;Sac`]^ds߅ߐߛߴDf8[u}hWE1	hE"߻߀C	ޚc+ݵݎ{gJ10G_kuݏݷ(6=AFKQXboވާRߋ:mM}x+ݦh*ܙf.ۑQ
ړb.٘sS4ؿا؏xcRB5-($׬לׇc/֏Pֲ[ջw2ӝc;ҩғ}cH1ѪъiF#кОЅn`WQNMQU\_V7ϒGΣV	y7̷}G˨h"ʊ<ɓ4u!ǁ.ƩyMſſźŴťŅV!ķnÁ9»`9 o8s)?ĽH̼Rxi㹲S4$иyP*ַrI,ڶԶٶ
*<NZ``^ZO;ӶLtȴ>ĳqQ.Ӳj1뱘6ϰg^ƬO- ګΫQ ɪQɩҩةЩɩ̩˩l5ͨXIUhwu`O8ϧzepCwM©8֨|*ܧMzԦX;|ʨ&4CJ:EʩG&fլMʭ<Ю+Uuf<㮳p/׭X#ଫvmaVNFDOh}9vT2xڽ¿P(xAW/ؖ*܀ݯޜvVC@]fjUcBK߻#9L^sM{N׋	iA2
B`s$)0/	%s!+70\|boC g!""%##-$$%&'(2*+-/1357:D< >q?@ACCCCoCJCB5BSAq@?>!>u=<<;	;:?:9q998h8
877g7=7
76*77788s9:;<7>@EBDFHnK-NPSgVXW[]>`bydfgNijklBmnnnnnxnEnmm4lpkjih	h#g?fbedcbbCa`_0_^^]]W]#]0]]^{^^_`abcFefhj<lnoqsumwxyA{|}}!~j~~~~
~}4}|{ {Ozyxwvv/uStsrq#qWponm"mVlkji"iphgg]gfff;ggg8hh3iiJjj+k}kk%lqllllm,m@mJmSmbmhm[m>mmmll4lkgkj\jihg6gffedcb[bbaWa
a`2a~aaa?bbb(cpcccccczcGccbbcb)baa|a<a``g``_?_^/^]] \,[?ZUYSX%WUTsS;RQONSMLJIHeG6FECB`A3@?=<;:9C987@7666Z686F6q66667K7{777777777W7(766666
7&7e77*8889A9c999g98)87664321^0>/.,+*))/(K'h&%$#"!  
#LGlV/eI4)"xI td

u3

		2UyqnyO%m	R									G		v
[FHG  B iQA(6^?  uks5	5	]				|	i	Z	@		R Q9B9`;=Vn|nqF	"

We6DS-yY9}f2KwX[(j5uR:]T!.Hi$X & + ( & ( , + %   1 O l    L!!"m""X##_$$N%%$&&&['''E((()I))))))***))))e) )((_(('O'&&7&%q%$$]$G$1$
$##=$$$'%g%%%/&o&&c&*&%%%E%$$%$#$&$5$G$$$%%&P''())o****)y)('&%$t#"! C5      a %]7u&X1y@sh.
xr:Ba*ZY
^

<
Rs8


;
		O
Qd  l ( c*j{a?\]>N{ml7?g<Y$xL,v>McqmN8)s?`>HY&Uߛ;މP' ݯݙݖݜݝݔ݂xwwjH ܳ܍a0 ۸ۜ~]<ڭڃY3٭ْwe`_[SVcnnkjcS<&ؠh4׈T:Ys׋ץ׽ױךwS1ֽ֠ևxurkfivևֱּ֥֗־֢ֈlJ% ճՈ\2Լԝ~^D;?HNXpԕ4QlՈգհխբ՘ՐՃpW>+##"$<aՉծ8q֫'Fiׅ׍ׁl[H.	ְֆaB)շծՠՐՂ{xrkhilqw}ՀՁՇՎՒՊul_O=*԰ԘdH.ӵӡӌqDҋLҼn Кc.ϧϛϕύυόϤ:Y{ИУКЇvfL%ϕnQ;$Χ΂\9͗V̋J
ˁ9ʰm*ɕFȸs)ǐJ
ƆBŴŝņ{ŀōŗŘŌs[G/żn"×Q	ÿx?kG% Fw+ܾ=QȼrX@)û~^>޺t\8
⹹OѸRUg˵|7ȴokmk`J-۳w9βoewӲ/f*dƴܴϴ´{Z6ĳݳ
6a̴:Cj߷R&PfU%}jS6/U>ٹ8Vysjlc8뺒<K̺Z`ؼJ;1;92)+I¿=	sMø%ċ9iŖŴſAoƤW7ȥɎʂi=̦q-΋LϪ]м-ѱ<ҿCBٳUݍ _8#D6 a=.f 7;I
^ MyH Fk/mEIt5		
Ke#z !""I###:$$$O%%&w&''m())p*!++,,--C..O//V00Q11V223R4456789:;=K>?@ABD2E=F GGHnIJJJ0KKKKKK{KZK KJvJ!JIIYI#IHHHHH{HqHeHXHJH=H1H(H HHHH%HuHHInIIJK[L&M
NO.PAQNR]SoTUVWXhY'ZZ[B\\\
]L]m]a]@]!]]\\\o\G\ \[[[[h[6[[ZZbZ'ZYYmY4Y YXXkXGX<X@XAX<XSXX YfYY0ZZ`[\\D]]`^^|__^```EaaaaaabbaaaaIa``O`__>_^y^^]U]\\2\[c[ZZ'ZYSYX|XXWeWWVxV:VVUUUsUaUSUEU4U UUTTTTNTTSS3SRR$RQQFQQPPPdPOP=P&PPOOLOONVNMgMLLLK?KJvJ3JIIIaIHI<I1I"IIIHHHHHqH?HHGGAGFFRFFE]EEDnD%DCCHCBBfBBAA1A@@A@???>U>=X=<J<;4;::j98A87$76654|43y322211070/d/..<.----,,F,++v+K+$+*********+>+^+{+++++++++++i+++**u*3*))e)!)((V(('q''&Z&%z%$p$#m#"]"!I! S }c+okibbmmP/
jTB5)[s&| i/
B,~54TipO3#"&%$<wS,}d{xFCCk;$R1l}|0H  !""";######|#P##"`""!z!\!A!!! !!2!M!`!d!W!I!@!/!  L Bj]I9QLbC   !2!Y!!!!!!!m!\!Q!G!:!/!;!f!!!
"J"""S###*$V$$$$$w$D$$###"@"!!K!!  o v ~       !!     : ]l_0sX8Zw'3:U!kARl8
bK7#bAJ_H+
m

_X
_

	h		y'x pHO%j
 c  N{Y="`2kvaLS n*]d H UA*o6o;uM%rP-d2`*U#_0sI#sV9b;wO%{P#pEp[G1t[;ߨ߆_9޻޾(AWhpmhedZC(޽0@N\k{ߌߗߛߚߛߡߣߞߔߋ߃|tkbWNIGC<4,% 
(7I\o߄ߛߵ	$=Vn~sia\XTQOQV_is|	!&*09CNWakv
'5EQWXZ_a_YSMJJLMNQYfs 
 3@KXhy|k^TK@5+" %+1;GS\eq
#6Lav
!4FWdjmnnkga[SMLMNMNQU[ac`YRNG:)
 3FU]`cghcYNA5,'! 0CWo*>Qdt{ytoiaXOE;568<CO_q%9K[iv.?N[ht~~xpjd``chow.Jj1Lg'<Qey%>Zx2[1CTbo{2EUcs
$4GZiu#,4@Rdv
"$&,6BO^o)CZo-B[{'Gk.CUfw-9CMXaglry~"3FXjz+@Sg~'>Tj~ 6Me~&<Qg}!1CUi|&5CNXajry~'3@JT_ju 2 V {    ?k/COXdp}9To|x|  ?^z'/7@KXdp~#,5<BHOUY^aejr|(>Uj}(7DR`mx	
		"	6	M	b	w								

 
,
6
?
H
Q
[
g
t













































%6FWiy)?Vo


$
&
%
'
(
(
'
&
$
#
'
/
9
@
I
U
g
z





































#0<IUagknswwvtssy-CZnzvj]K5{tngaZRJ@7.&








 #.9DO\gpstwyyuojd^WOF>731/,*+.13554452%






y
p
g
\
T
Q
R
T
T
T
S
P
M
L
H
>
0
!


teYPG=40//.-,+++*$xlb\VPJD>93-)'&#!









~
j
W
D
2
!

													s	c	U	E	1			|wrmhd^XQID<.
eK2}wqjc^XNA4'
|xsnjiiihe]TME:( {gZQG=56;@DIQZdnw{}~vme\SJ@7.'!|lZG5#}wqlf_UJ@6*{tnkjhfd`\XTOG>4+"                                           y r k d ^ Y S N J G D A > > > @ @ A B C D E E A 9 1 * #  	 zhWG6& 		

	wj^TKB91+'$ 
         
      RSRC         [remap]

importer="wav"
type="AudioStreamWAV"
uid="uid://s5b640aitk5k"
path="res://.godot/imported/e.wav-153efbfb045a29990600eb1da729ad47.sample"
              RSRC                    AudioStreamWAV                                                              resource_local_to_scene    resource_name    data    format 
   loop_mode    loop_begin 	   loop_end 	   mix_rate    stereo    tags    script           local://AudioStreamWAV_nmxbg 8         AudioStreamWAV          po                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    	 
 
 
 
 	                               	 
 
      	                                
 
              
 
             $ ) . 3 5 5 6 7 8 5 0 + & !            # ) . 3 8 < @ E I K K K K K I F B > : 8 6 4 2 0 1 3 7 : > @ C E H J K K K J J I G D B @ = : 6 1 - * ) ( ' % & + 1 7 = B E H L P Q M G A < 7 5 3 1 / . 3 9 ? E K Q W ^ e k m m m o n i a Z S K B 9 / %      	 
 
         	      0 E Z l w |     { l ^ R K H G A ? G Y o        
      w ] E /   
 2 U w     !:@?AEA-     x ] G D F F D I a      5Umof_\Q-   p K *  
 ! ? a        
	    u Q *   K    0u>  D V2m N   B{yM        :\u{z}{R   ] 9   , M p    #D8   u # u-l V    '%	    j E  
 $ < Q d t ~                b A #  rkg[MHTevU) |i1~5   #VsJ    { u q q s v |             t + j10hf  +s\J( ` Mp2L
u 
7QQ[ l vb*|V: x      o < w<gZcpAs H j         m <  fBU M  CLEG?"  \ m-K2%&LJ
 v  B* E fL<
{OW]B#>lI".tM	_M  6 Z t o c _ g X  rvG"^"   uY  : taq R   %_2  n  %9 *+
_1} $ + z+068VxS:#xbi]x'wHy-Ca8  	6C N SDuIHf2)O  \]&   =Yc!K -^b a F ( ,u	 F -,@PDL    dI Bi8o|jC	WsY6"2Ung\e~ldv~^.+L]biw2%&@DydM'd P5e  >fV;2?DEK^< X Az'n%[h_\yUY| @ L B &  ~#6VO<KW@D^ i}bqIC#S^:!BQ+
$|<c6F.{      k B  Z- $4Jv6    Ug 0 Bg-+
@nv~1]"@[FXOpH0      Q j*	2ca]c7EV \        q O " gDgH
 / <  e
!F:S% W j a G  Gq9=\ j      Z ) xr>
,SX   1 4  sKaCE]qt|087Bguiq* r       d . gH3;Odz B Y h y       [ :  kH/3jn4EgTFKi\?2 ^ m s q d B  `sI14V#a 7 F O P O ?  ugdp   2 f              x i H #  ' = 8 * % , 1 4 8 8 '  
   ( B m   <}#%H  1 @VO  &$V 7 R8^zU9 z      u 2 skP<Ep = B D V c V ( hK-0Eb !  gG/+S B    7`_L4  ` -   
  # Y   "UqD   _ 9  xdF%	 =]xrWC-f@'8;."" 3CIC=@IQNFCIUetzzw}}yy{xribZUPLIE<1'"
y]:#5APh'.=FA/k[XZYWZew&Jm}aH5'z`M>1%xcTRW]ai}!:Tff[ND1xhZJAAHOU`o~vaF&,Ie(:DO[eeWE6+'?QXOD90!6Ttsiimty[2,<L]myzpcUF92369<DWn#)3DYo$0;;5.-21(!,@Ueq{~qbRD80,(#!#(-1334552,$#0Il 2 N f t s p m f Z O F < 1 ( ' * , / 5 > H S ] e h j l i ` R E 7 &  tssronmnonlhc_[TI</#
$).38=CHNT\dls|   * 6 > E K R Y ^ c d f h k n p r u w y { ~                     w q n l i g k s {                                                            s e W I < 0 $                ' 3 ? K Z l ~           !.;HUcs#&)-0356789:<=>?CHMRVY]aehjihhhd]VOHDA?<9:=ADHNTZ`gnu} 	!%(-169;=@BDEGHGHIJJKMORUZ^cglptwz|}{ywuqjaXPJE@940/.-,(#	 !%'*/6>GOW\`chkkjhhhe`YSNIB;3,%!
%-4;@DGLOQTVZ]````a`\UMF?8/%)5?EHIKNOKD<50,)$ %*2;EOW\`chkkhc^[\\\[\agnu{|wqlgb]YTQLGB>7,!	}qeYNC91*#
}unhc^XRMHC=60+&!
                     } w p h ` Y T Q N J E A = 9 5 0 , ( % !     # % ( , 0 4 8 < > ? @ A A @ > < ; : : ; > @ B F K P U Y ] ^ _ _ ` _ \ Z X V T Q N K H F H I J K L P T W [ ] _ a d h i h f d d c b ` ] [ Y X V S Q M H B = 9 3 - * ' % # $ ( + / 2 6 ; ? C F G G F G F D A ? > < 9 4 / * %       |qeYLA5*!ziXG8-#sbRB3$uaM<1)"
	 rha[RKHIMOQTY^chjjhgfb\UNHDDFGGILORU[dnw{x|-872,(#
"@\vsbQA0
#*130,+'yslaQ?-zwxy{||zvsqlcXND:/%	#1>HNQUZ\SG;1%#6DC:.&

 
):J[jz~wneajx*2;GMG8(
 #"
 	$1AUjpc^aghly%-6=CDDFGE>70)##(-037:;6/)$ 	!=UcilsyxriaZXY\[]dq~n]J9,'$'2;DLU`krng_YSJ>1%
$*.38>CDB?=;72+$#+28<AGKG>2(od[MCF[u"254686.$$,8Mf$6ETcqy~'% ri`TNXhy|eL40H]q,<M^lu}
,<INQTX[\ZWUTZcls~  0 A T b d \ S L E ? < : 8 8 A S g z       )<M`u&9Oe{#8Nbs.8BMWZ\]^`gr|
"&*5EUeu}ytompx	
'08DP[eoyytplf`[UOG=3)	~wrjc_`chmmhba`[O>-
*58658:6,$).5BR^efdba`[PB70-,*('*2<ELRW]dlrrppqrsttst|.F^u	(<Pao+Fc}		(	1	8	@	J	T	W	S	J	@	6	*			|k\PD6"nL*cL;*uU/	z]D0!fK0mU:|iYJ:(     ~ ` C %  kQ8!
{dJ/zh[OB6.)$wokigb][_cb\RG;0$~uk\J6$|^=X/ n@{Ie8h>^)LsI!qT3h@fD#]:nF yaH.b6W0zZ9uR- v^I6'	b?#	!/8>BFILNPSYgzvojd^ZVTSQLD8'pDl@hS@,vLX#[9߾߸߰ߥߖ߀a<ޗk@ݻݴݷݻݺݴݩݙ݅s^Bܩ܊iI/ ۮەsM-ڕmL/ٮَziU9ا؈o]L4׸שהtUA5*ֳֺ֚֩ֈs^QG=-	սՠyO(ԒY$ӺӅS(Ү҄[1љYhШD_{ʹW˨T	ʏJɲgsȸYǯ]ƳcīĂQéÌrYC-¹oR8!)9X«
2MeibXVVWYYTVnØBxĲ(UvŔź*A\~ƨ!ZǤ8Ȁ%}.g˸:q̬#]͔;Ή#jϸr7я qEsӢ.Z}ԛԿ9yշ:%uץ)Vr؇ؓؗ؛ر+Tفٲ@mژڧڦڡڟښڔڍڂlY[oڇڗڪAW]^dilkg[NQgۄە۪H܈Wݙ%hޤ<w
R_K84,8Jt@ZhaZm~	
n
p<S> "#3$[%z&u'^(C)4*2+D,]-v./01235
667^8,99:#;;9<<=C>>?q@JA5B!CDDEFGHIJrKJL2MNNvOPP[QQYRR2SSTgTT*UUUrVVWXvXXBYYZPZGZ+Z"Z
ZYVYXKXW>WV!VUTyT!TSS6SRRJRRQdQPAPO ONMMULKJ5JIHIHGFZFE#EyDCBBTA@?	?D>|=</<;4;::9<98j87`768655o43/321v110F0//1/..;.--8-,,F,,++p+N+=+1+++*****T**))w)7)((_((''W''&&o&H&&%%%%%p%^%R%H%<%1%&%%% %$$$$_$:$$##}#M#$##""""""""""""""""^"?""!!A!  k ' X^TF |8i!@E-g&\.o[:{Y

=
n2
D
	C	MX`JU$yU2zS+
 /CYm(W!_%b8f 9WuT	N				
4
F
^
u







 EsBs
-
P
i
~








!"#$!	




t
R
0

wHh,

W

	n		WA}`5o
?s H &jc[ JRS?C_5[q"4>ZKl5Y&T(hM5wfTD81)!	.EYgr}Er3i(Lq:`O
PO
BzFx;pGC}R8&}dHV+  ~uv#pR		
(M_

yC~/eWo	K~
#]  ?!!"B##$X%%& ''N((1)))i**;+++\,,J--8.."//000W111E222363e333494k4445<5p555606`66667<7g7777777777777e7H7.7"7#7*7/73787?7H7T7\7R7577666b6655K5544o4A444333y3L3"3222F2211L1100\0$0///E//..M.
.--7-,,j,*,++k+4++**g*0*)))[))(([((''h','&&&f&8&&%%%_%4%%$$t$D$$##w#D##""""_">""!!!!m!G! !    \ 5  oEuO'tbRD4W-rS3
 p]F/p`PA81*#	",9EQ^m0Kg7Vy9eJ|F{S6 q   $!_!!!"K""""##X####6$o$$$$%c%%%&\&&&'S'''(;(p((()5)b))))*9*c****+D+w+++
,>,o,,,,-A-f--------...+.7.D.R._.l.y...............s.\.B.*..-----h-J-,--,,,,j,H,!,+++e+2+***L**))[))((d(%(''a''&&H&%%b%%$z$*$##<#""N"!!b!! z - Ie4I_s&Ju2j*o1v9}>E	UvA
uCR%rG


v
L
#
X0iO8 




}
b
F
*

					y	e	T	B	0				qaQA3$|xsmga\XWUSSW_ir{*6DRct	,	I	h					

=
[
y




4Wy
2W{
#
@
\
y




"Ab#Dd	 7Nf}*D_y 6J\l{#2>IT_jqvz|yvqkd]VOHA92)mP3vV7bD$ kByT.	




h
Q
:
#

tS/
~eK1





p
Y
@
#

			z	V	0		qT:"
dE#fAnO0qZB)gK/ rdTE6&~hTC4$           ~ j W D 0  
 |rg\QE9+'1<GR^jv  7 R m      
!9Pg}9Sn#;Qdt'=Sh~	(09BLWblx
"$#"! 
}hWLC:0(!pP0pV>&uV5hE"    i N 3  fL3 mP3~iWH;-hI*	uT7wdQ>*cC"uY< mN2q^J7$zdO9&
s`M<- wcQ>+}tj]OB5&~reYL?2%
xpligdbabccdccbbbceghjklnopnkigc\RH?6.' 	 ukaWK>1$
ypeYL@3&	}m]M=-
|m^M:' v\A&oXC.y_E,}^? jM2jR8sT4lL+
oP1vT2`>rQ/ߥ߂_:޿ޖlAݖoH!ܯ܋hD۩ہY/ڮڃV(ٟqCع؏f=ף[7֤~S%՜n?ԲԈa;ӧӅdAҫ҅[/ѩ~R'ЩІc@ϻϛ{Y5ΥX2Ϳ͘qJ$̲̌gD!˹˗uT2ʠ{U.ɷɐlH#ȽȠȃfH*ǲǒrQ1Ʋƒu_K9$żŧŒ~hN2ķĦēĂwqke]SF:/ äÄdC#µ£|k\OB3tO*_C,׿ȿreWI;. ݾʾ}hTE@?<9<J\nþվ޾ھվξȾȾվ'Dfɿ,8AIP\o3Ut	-Jh 6[zÔì$5IazđĪ2Utŏũ$5FYmƀƓƩ5ZǁǨFpșȽ!8M`sɆɞɿ	,Uʈ/h˧+k̫(fͤFwΪ	5aϋϼ>Ѓ
b$҃<ӗLԤ?Ոlf׻{C٦
vH۱܇Z;޹:߸6@Q[ZW^d-Aj%KdDV#x^F1 |k	[
K:%
&Kj !"#g$C%&&k'((W)**+\,%--./01Z2334d55m66Q778e8888999H::;g;;?<<=x==>u>>?1?W??????@@5@R@r@@@@@A3ASAiAnApAsAwAqA\ACA,AA@@@@@c@>@@???n?9??>>_>">==p=4=<<<?<;;:;:: :9F98s887m776w61655`554c443f332]221i110000//C/..B.--9-,,r,0,+++++~+n+b+W+M+>+'++***v*I**))){)`)C),)")))3)<)G)U)d)t))))))t)e)Q)8)))((((((((~(z(x(v(r(m(i(e(^(Q(C(5(%((('''''''''''w'l'd'`']'Z'X'V'S'P'M'J'B'2'''&&&&&p&Z&P&M&L&H&H&M&U&_&i&m&f&W&F&8&&&&%%%%%%v%j%b%\%Z%Y%W%V%U%U%T%S%Q%N%M%K%I%H%K%S%\%e%q%%%%%%%%%%%%%%%%%% &&&&$&8&L&b&}&&&&'+'N'p'''''(%(>(X(s((((()3)Y))))+*j***:+++#,q,,-b---D.../]///8000 1u11!2|226333P445c556f66	7X777/8u88 9D999:V:::;W;;;
<E<~<<<=G=v====>@>c>>>>>>?$?<?U?n????????
@@%@-@1@4@7@6@1@(@@@@????????m?]?K?8?#??>>>>>`>:>	>==l=2=<<s<1<;;b;;::N::9|98988Z887v7 76s665b554H433232x221g110`00/S/..Q.--L-,,L,++?+**5*)})")(o(('v'$'&&A&%%\%%${$0$##E#""k" "!!@!  j % [q:l6PD y7x?b,Rh+h'`_ e,V%i:
t?
m7

p
A

g<a9


x
W
5

			|	U	,		V,jH&lM0{]=ybK5"zndZQKKQTZmXj#8 6Ugg`XS_4	z		W

;U
K
^
]
a
i
e
>

wgghem
v

NIL<:4)
Q	7c;b n_q~DP?~ Lc







|
t
\
'
IJ
}

	y	/	Eh3U)R9Wi2  ` =         # . / - # R=\(\swZ]JTM^*K{.@2g!z$S~|oU2
OqAzcI1!d2b3jT<!t^:c?~X2zw|pV*i8qi_W\uDjyU(qBdI4/37:>ELT\\Dk)e+eD-uN*_%sH"
wZ:ߵߋ^-ޒb4
ݷݎkO3ܭ܀U)۸x9ھڃK٪مhL0	ػؤ،rP)ׯׁS%֤~X2ժՃ_:ԲԄZ=*  (.27::5/+$ӵӗl7ҘmI))<KK:!Ѥm9ТrAϿϥϋ|z{zxtlc_XH#Χ|IͥtP2̶̨̻̲̯̬̠̋qW>#˭ˇb@"ʵʥʔʃq_L9&ɲɒqK!Ȥ{S+ǺǝǃfL;1) ƯƛƉzl\NFEHHJP\kvƃƕƬ)HgǄǞǲ,9I^uȍȥȷȽȾȴșfP?0%0@Z{ȝȾ$363.+(''&#$1DYkɛɼ !?[vʓʮ1Qr˒˲2Rj{̫̹̉̚?bͫͅ1]~ΐΞΰξκν%Jnϐϱ&@TfxЋОг
+Psіѻ8bҌҴ,T{Ӣ?hԐԷ?o՞=v֯Q׆׼ N|ت.Xف٭[ڗQۑK~ܰK݃ݼ)j޳JߔP /Z.yPB%i8~
P+vOd0tjsK&v\)7:4ekv&'
K:   9=4=P(R		
\


;,A

]JzhY*E-+/\5NM=# {  !p!!"d""#W##%$$$[%%'&&&T'''L(((+)c)))
*9*`*****+=+]++++1,l,,,(-k---.>.`...../!/=/N/W/^/g/p/v/z/|/}//////0<0j00001&111B1P1Q1F161'1111'1.151:1?1C1H1L1M1J1F1C1?1>1@1D1H1K1L1J1G1F1E1=1,1110000000000}0w0i0Y0K0<0-000/////////~/t/k/b/_/^/]/[/[/_/d/j/o/t/y/{/~///y/m/`/T/H/;/0/$////
/////(/6/A/N/_/r//////////f/F/'//...........///#/)/-/1/9/=/</5/./-/(//.....o.X.<.$...&.-.3.;.E.Q.^.j.p.m.h.f.c.\.L.9.'...------------- ...!.,.8.@.:./."........+.?.S.g.y............................../////................... /	//#/1/>/L/\/k/z///////////////////////00/0=0K0Y0f0q0~00000000t0j0b0[0U0R0P0M0J0J0N0O0O0N0N0M0J0E0@0:030.0*0&00
0////////o/c/Z/P/E/;/3/+/$///
/.......|.f.Q.>.,...---------p-^-J-6-#--,,,,,,w,_,F,/,,+++++u+`+J+3+++*****c*D*%**))))o)T);) ))(((((u(\(@($(	(''''{']'>''&&&&r&N&)&&%%%%j%L%-%
%$$$$t$S$4$$ $####y#^#D#'##""""`";""!!!!y!X!<!%!!     j N -  xJR& kL,\7\+U `2gB g>a1]5iI(}{_F,>dc;
cP@(#*0-#uD>r?l[F1




O

h;


J

					v	Y	=	"		h3q(TK~Kc,z@{6  u 7 J}Fp;oH#`;}JMiM9%gG+
c8sTA0	cD$nAa9r]B#h7wHa@$nQ3d9[9 t^E+pK'wW;!jO3iL0nS7w\A'{eN6xaJ1}gVF6%vaK2ߺߣߋt_M;)޺ުޙފyeP:%ݹݤݐ~m\K;."	ܿܮܚ܃lU>&۳ۡې~m_TH=2'ڱښڃmYG2
ټٵ٩ُٜكvi]PC60+'"	ؾصجأ؜ؗؑ؋؅~xrlfa]XSOMKIGFGILMORUY\_bgmrvxxxyzyvspmmnoopqsvyz{zyyxtplgc_][YXY[^aeimquy|}~؀؁؀~}}؀؃؇؊؏ؘءتزؼ  *8GVftهِٙ١٣٢٠ٟٞٞ٢٦٧٫ٷ!4GYivڂڏڜڨڲڼ	%2@N[gqzۃۍۖ۞ۦۭ۵۾ 0CXo܆ܜܱ'3?LYfq}ݎݦ0Rsޔ޳)DWhzߌߞ߮߼!4G[p!1@O_r%2<FQ[afjns{ 4H\p	'5CVn:Rh}!;Wu:Sj(Da})Os
$.:         
      RSRC             [remap]

importer="wav"
type="AudioStreamWAV"
uid="uid://dnee23v5kbgtm"
path="res://.godot/imported/f.wav-34535630a75ad2077a8d6bd55d10c9fb.sample"
             RSRC                    AudioStreamWAV                                                              resource_local_to_scene    resource_name    data    format 
   loop_mode    loop_begin 	   loop_end 	   mix_rate    stereo    tags    script           local://AudioStreamWAV_bqxf0 8         AudioStreamWAV          JC                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            	  
              " $ & ( * + - . / 1 2 3 4 5 7 8 9 : < = > ? @ A B D F G I K M O Q T V X [ ^ ` c e h j l n p r t u w y z | ~                                                            	
 #&),/258<?BFILOQSUXZ\_adfjmpsw{

 %*.37;?CGJNRUX[^adfhjkmoqrtux{~ 
!$&(*-036:<>@BDFHJLNPRUX[^`cfiloqtwz|}|zxusqomkhfeeeeedddccb`^\ZWRNIE@;50+&!
 |yvsqnkigeb]XSNIC=70*%! }xrlgc^ZUNG?70( 	                      { u o g _ W O H A : 3 - %   	   }vpic\VQMHD?92+%vmd[RIB:3,%ytnhc]WQKE>70)!~ysmga[TLC:2)! ztoid^YTOJC<4-& 	|vqlhc^ZVSOKF@92+%
|yvroligda_\YVSPMJGEA>:62.+'$ |xuqnjgeddcbbcdfgfc`]ZWSOKGC@<854579;<<<<=<;:87643210.-+)(('''&&''''()**+,,,,-----,+*)'&'''(()+,./0123445555666679=@DGKOSW[_bfjnqstwyz|~"%'*-/37;@DIMQVZ^`abdfhkmpsw} 	
#(-147:=ADGJNRW\aejosx}	&,39>CGLQV[`eilnpsuy}#'+29@GNUZ`fkptx|%,39>DIOUZ`flry
!(/7>FMU]djou{!'.4;AGLPUZ`gmsy       % * 0 5 ; @ F L R X ^ d l t |                 
%+16;AFKOTY^dkrx &.6>ELT[bipw~
%,39@FMSZagnt{ &-3:@GNU\elt| &-3:AGMRW]bhntz
$).49?EJOTX\agmtz
"(.5<BIOV\cipv| %).37;>BFILNQSVX[]_bfkpty~ 			
							!	$	'	*	-	0	2	3	2	3	3	4	5	6	7	8	:	<	?	A	C	F	I	L	O	R	U	Z	_	e	j	o	s	w	{																																																																	










!
$
&
(
(
'
'
'
'
'
'
&
&
&
'
'
'
'
(
)
*
,
-
.
0
2
3
5
7
;
?
C
G
J
L
M
O
Q
R
R
R
S
S
S
T
T
T
U
U
T
R
Q
P
N
L
J
G
E
C
B
B
B
B
B
B
C
D
E
F
G
I
K
M
O
N
M
K
J
I
G
D
B
@
>
;
9
7
4
2
2
2
2
2
2
3
4
5
6
7
9
:
<
>
@
?
=
;
:
8
5
3
0
-
*
'
%
"


















	




 
																																					{	v	q	l	h	c	^	Y	T	O	J	E	@	=	=	A	G	M	T	[	c	j	q	w	~											w	m	c	Y	N	B	8	4	4	5	4	4	9	@	I	Q	Y	_	d	i	p	t	p	g	]	T	J	=	/					"	,	9	E	M	Q	U	Y	^	b	f	i	m	q	s	t	u	v	w	u	o	h	b	[	T	L	D	;	3	,	&	"										v`J3		jEsQ2}wqnmmkkov~*Dam@	y,gA0DVftveJ+|P$nSPW]`fu]?M ~ < s=xO+wg`^\YUQLGC>7.%aA"8JOQZaY>lL98<85BiS3DM^rx`>\,:UpcAkT='
iK.~o[F/fF&/;P^O	+/m-sB|txyuy+DZqiB r"Npfdc\H,p#b=#>ScpkQAJp)?@o}qlfQ(;K
f\Y\ZE
F\gJ<)-7?@<4+#
]1g,x^D% +-*/.}!>Sakt~p>
4x!xPZ'		
),s<Xlu#bEt')w4@I/@J>q(c$kBm5sݩvK>cݓݵ2fޏ޲ަ}`J+ݡ|bgw݀ݒ"<Vcea[K ݯݎd>'ܽܢ܎܊܌܆yfL.ۘufU<)8=>7&ڡڄsdTJLOZ|ھ
KۏV.ݎ
'KksW6*Gހ_߬ TO1YikhbR+d4qD3mEiI~)p	NNV7;8Rdg]/Ej$>v  7t+tS<*	

nI'sj<`MGc~Ao*E~[9B<#7b2f \^0e5 !!`"###)$I$$$$g$"$###v#o#d#l##+$$Z%%&t'?(()<**+++C,a,~,,,&-c---.p..u//?00,112a222222^211}0/B/^.g-q,+*)((2'd&%%%y$##l"!4! M;Bz=M~B !!"##$%:&~&&&k&&&%%'%$$#0$l$$$$%U%%%%%[%,%$$$f#"'"~! - oP|ZD!HrGf
d
h
6
		7 am < 	`-6!X! @ 2  YJ!H"Q|U#oA"SD&B+nEpO.^7vk\@#Nsp8IwU@+.Sw2~OwD\/7f "+ sghv
6q'jsn
U,HPI:*uaP@, t[IA5|\;"0Lj6a	yD;yQ-ye=Y~12|"nq+i-a+i.[f 0bErޘ4ܙK۰wKڑ`4
٢X؁"طKp֗*ջRӣRҕmI(
ѩхKy'нES\OK`ɁɰQǓ4ƅ1uŮKÀÜ%µKdr!8Իvh&빮u@׸s=}9󶫶dԵM״m9г^!ⲞU
̱VŰs[B'
Яj3Ů:񭮭o6Ǭ`C0ܫ٫ԫ˫|oR%Ϊ}R%nO-ϨvnfcgoyzlO%ħ`4ަӦ"8>;;<5#ͦeTZn̦%WЧԧǧCl-v;~Ū4Rrë4V,jwaҰHǱA(s6Omд/3cڷP\۹1*	 [<W"~̽Xվ%HjȿFoK*u
RßAđ [Œ3Z{ƙƸ=`ǑQșLɲ}i˺1EPZî̢̽_ͳMΐdϭ>S`ipЧ&YюN3ӝ~mJ֜;׏)P{ج Rن'ڏR۵܉cd޲J߉1i3gSto6pK#V/O/o*N'R$PTPTLBZnnV%1FS`uCkSAY-6641-&  
!Eu9y
Q3]}%ZQe4
5Xw{hCX3^lTHFHH?"E(Ex&Oc.pTxkt%GepeL3v.yT,nG'
|rmjd[U[ht|}U&sN&].uCDk= \#VH
1i=92_bds>
);M^o< | B'	y

	|P&h:
GZlblE[ngK8-f=sYQ   b!!=""##
$$%%&&'''?((I))Z**X++9,,!---g..L//0(11z2N3>4156789	:;<=)>:?I@hABDgEF/HIKL%NOPRHS{TUoVWW$XXY*YDYaYYYYZFZ~ZZ4[[\}\\6]]]5^l^^^^^^^^s^[^?^!^ ^]]]]]]]]]1^x^^__``&aab{bbXccccccmccb;bafa```_7_^^^e^E^G^`^z^^^^^^^__^^^^^^^k^L^^]]s]9]\\c\\[[[[w[o[[[\^\\\4]]]^<^@^?^D^B^%^]]n]5]]\\\\\\	]3][]]]]&^X^^^^^!_B_^_y______e_G__^!^]3]\[2[qZYXMXWV@VU;UTTTSSOSSRRIRQQ>QPPPO%ONMFMLK
KMJIHG%G`FED>DCBPBAZA@e@@?\?
?>:>=5=<)<n;:98766533K211n0//////0}00Q112X222>3z3333*4I4\4l4444v4Z4@4&4433l3;3322222222
3!333D3\3n3\332z2/21010/9/..-"-,J,,,0,.,&,8,o,,
-W---.W....../ /..`.*.---,,+A+*p**)q)Q)1))(()<)Z)z))))'*N*`*b*d*i*g*Q*)*))))h)G)$)
))*)L)i)))!*~**2+++S,,-l---F...../9/A/2///......../5/g//'00#112233 444O556V6666$7R7|77778K8888.9|99&:x::A;;/<<==>>???U@@$AAABJBBBBBC%C8CACCCCCCCFCPC]CjCtCCCC
D>DqDDD>EEEEEEEEE9EDTDCgCBLBA2A@@J@@???.@g@@@CAABhBBBBBBBeBBAPA@@@?1?>>>\>2>!>2>R>r>>>>>>???>>>>>e>=>>============,=<<'<;A;:E:99e94988888888_887y76
6;5t43210/.-6-,++**k*?****)*=*@**)z)0)(c(''s&%7%$
$r#"X"!q!    i
]v)+(vr)UId
X	J7pD?9u
 ,*
		y VBeI&@D%bNr0xY9n;Gw1Up#2qT6+4FXflkfeaO)j\.:XSsjmwg318Nt=xv 
u9 ߉IދS!ݓmO1 ܺܧ܊a5۾ۘrL)/FV`fnvugS@/ڣ}Y8ٿٶٶٳ٭٨٥٢٠ّٛ|_F.
ؒRz׳T|ՅԏӋ҃юа?z-͏@̭g {˱MxɈȜ2wzFĭĊyjWB1#óÉb:ÿv/^H࿬xJ#ؾb:潵}AμC]o˹z(ո-Էs=ֵo:ֳx ʲu"ұ<򰧰WX^ҩMШUۧgV b ݤSӣVǢrɡtA۟u1ŝ\9֛y3ᚹvlhf_N/͙QaXX畱{R:*ޔ۔֔ДɔlQ7Ǔyppsuɓ&Oo~bF$ ݓȓ
#%! )>b=jΕ/IeԖKŗU<?ŚQtwߟ8Ġ 7eUH
uR*4§"Hlɨ7m2ڪ8eά4`î!zӯ->>H?@,yͶ$u
W<(dۺWVƼ:!7¿A)S­-aÞVēcŹfƹkrȿCɄ#Fmʙ"?d˒&P~̪<nͪ]ΪVϬGЋ\эѱ.VzҞLyӨE{Բ2}4֪"יؼy-v/ܽw-ߜVtaUl5uf=</,%+Uv 34	ebR_q\hS;kI		
v

]9)
h







w
n
a
J
/






*
?
_


ptjP).7 %!" #I$Z%G& ''()*+,)--.0112l3N4=5!667O77!8\8=8777h7L7/766667:7a7788999]::;8<<m==8>>?n???0@z@@0AAAUBBC}CC-DdDDDDDDDDxDfDZDaDvDDDD"E[EEEFEFrFFFFFG+G>GLGTGYG^GcGhGeG^GTGLGRGvGGG$H_HH{I7JJKWLMMNO3PPP@QQQQqQ9QPPVPOO(ONNOO3OO5PPQR]S,TTUVWjWWWW XWWOWWVVVaV<V2VJVtVVVVWWWXnXXhYYjZZQ[[?\\1]Y]S]W]m]v]I]\\D\[[n[)[ZZZZ=ZZYYYYYYYYYYYiY.YXX8XWaWV"VUUpTS9SRRQQPPO
ONUNMMEM(MM
MM)M]MMMNNNN OBOOOeOONN?NMZMLbLKKLKJJhJNJEJ0JJ0JpJJK^KKKULLM=M;MMMMLjLKRKJKJIIhHG'GFnFFEpEiEEEEE;FFFKGGGGGGG|GFoFE[EDCCDBA@6@?>b>====<~<@<<;;;|;~;;;;g;!;::c:99'8Z7654321)10 0//......(/f////00/0?0100//v/9/../.--"-,R,+++*C*)m))((3('''''''(4([(l(T("('''H'&n& &%\%'%$$z$$$6%z%%&\'7())*+,-o./l//I000n0800//1/.u.".---{-\-l----.V...;/|////////v/I//..q.1.---. . .1...1/x//'000[1111$2a22222222Q2 211&10/i/.1.-,;,+A+**E** *N*y****+++:,,,,-9-K-/-,,,s,3,++d+:+@+e++++G,,-..6//a00n1112/2O2:22111R100/0//8/..1...------...(.D.i....../#/////...V..--v-(-,,,,w,c,h,,,-:-`-s-----t- -,,.,+*S*))7(['s&%$+$##f"!!!!c!B! ! !   M 2\g6gtyQ&Za6Fi>e

.
i%~]+


f

	N	&=o(1           
      RSRC [remap]

importer="wav"
type="AudioStreamWAV"
uid="uid://wiq5g37kkndy"
path="res://.godot/imported/g.wav-b415acda5a1d7dfd6b1fa56a565f230f.sample"
              RSRC                    AudioStreamWAV                                                              resource_local_to_scene    resource_name    data    format 
   loop_mode    loop_begin 	   loop_end 	   mix_rate    stereo    tags    script           local://AudioStreamWAV_of1x1 8         AudioStreamWAV          S                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 	 	 
 
     
 
                                  ! ! " # # $ $ % & & ' ( ) ) * + , , - . / 0 0 1 2 2 3 3 4 5 5 6 6 7 7 8 8 9 9 : ; ; < < = > > ? @ @ A B C D E E F G H H I J J J K K L L L L M M M N N O O P P Q Q R R S T T U U V W W X X Y Z Z [ [ \ \ ] ] ] ^ ^ ^ ^ ^ _ _ _ ` ` a b b c c d d d e e f g g h h i i i j j j k k k l l m m m n o o p q r r s t u v v v v v w w x y y z { { | | } } ~ ~                                                                               ~ } } | { y x v u t s r q p o n m l k j i h g g f e e d c b a ` _ ^ ] \ Z X W U T R Q P N M K I H F E C A @ > = ; : 8 7 6 5 4 4 3 3 2 2 2 1 0 . , * ( % # !                
  
        ~}|zyxwxxyyyxwwvutsrqqpoonnnnmmljhgec`][XVUSRPOMKIHFDCA@><97530.+)&"
}zvsplhd_\XUQNJFB>:62.+'#		  	

 !!"""""!     
	  
!#%'(*+,-/1479;=>@ACDEFGIKNQSVY]adhkorvy{}~   #'+/258<@DHLORVY]`cgiloruxz|~                    ! " # % & ' ) , / 2 5 8 : = @ B E G J L O P P P P P P P Q R S T U W X Y Z [ ] _ a c e g i k l n n o o p p q s u v x y { | } } ~ ~ ~         ~ | z y y y y x x w w w v v v w w w x y { | } } | { z z y y x v v v w x y z { { | } ~                 ~ { y w u t t s s s r q p p p q r r r r r s t t u u v v w w x x y z { } ~                                                                                      !"""$%&'((('&&&&&&%"    

                                                      



	                                                                                               %/7@HPV[agmty
#*048=BFGHIJLMMMMNPRSUWZ]`bcddefgfeedeeeedegjlorx~tj_TKC<4,%!
zodYOG>6.&                                             | x r l f ` [ V Q L H F E C B B G O X a i s ~                          #6I\p	*2<Kc|%Da}+@R`kv#).1479;;<>BGLORX_gntx|{xsj\NB6(
|qg]QC2 ysrtvy|~{ul^J5zutz	 !! !!"""%+5BO\l%=Qas$-6?HPV[_cfhe`[WRKA5-)*+**.:J[l}2GYdkquyzyuqmnrw|nN.lAt\J8(}rha^[XTRTWVQKE=5+ vhT9k@   d <     * 6 C Q ^ l {             '5BQ_jpu|~zpcWI7!              !/=LYdlt|	+>Sfz|eN9&  0AVm!Bd:_

qZD3$y^D- 
!1;DIIB9.	_4e/   ] ,  kP6!}[;#}sfags} #()+./-***& "$&.=Ret5Su 2 K ` p ~               | m V : "  nb[UQR[m < d     "9K[p !0AN[k#,///) nK(1Lg0Oo}bC&r^MD<.hI$    Q   oJ)pW?-#$*0<Mbtx`J1	


 4Qj'8FVgs}pQ3x]D+ :Qh=[z
 & A X j y        
       l W @ (  
      1 O n       	
       $.25:==94/!
     ~ W 6  R*
hPB0{obO2
!5GE><?=.#3GWd{
.I`xtY<oeg\DGJ|ngt!Gz <HR_g^9	_,f7|l^MAId3[r\RQSQ[VVnL0'Bf-.+/*lF)#?a2gxY;'lU6)EV`iujF%g<{uvyyx~!<` 1V5Z{eTC LxL!/I]qd;
2dHx+7:=CC:+
 	+BS]ciqvxyxvw{}{uuz*Ll3Ke~eI,&<JU`lz( V     "Mo}qQ1     p g h l k l s {     | g \ M 0  kI(hS?,;[s|o^UJ2N`" +@TaXH9-\T 1g{Ob%$p^$k   # + 1 ; T |   :~Q.HJ@80'}zwvx{~}vnf]O=+c<    g B &        & , 2 0   wJ,|/   f+9;DLAhC      &_+anA~K(4W{2GF4"fA*$6d.b"*36l#},  E   yR>0 C~.y'+c9y:l;Wm ! H s    +sFz*/`G  j  pE$$)**,.4@RVPKRgty}{wsc6JzqhfgjnlY<h;rdI5Qq0c
)S"%
 1Nj0h ) 9  h)~qQKC:=`m0@%T9fwX3>L%!Q,nxaIIq5JsJXM3B+uT0]K'{jKDw8H{C{

.W} P   NBk
!1CUfyzH{udz(CZu5Tuj4v8"IshQapVI:,-:JZiql_RE/lT;!    $-//02(   d , y9P{wqnpoeVJ;!O^(iNB;0()5EUaaUH>1wG*#4{!py/i|K}G SFz AfD$o g  
<Wm+U}5_.g+m*Pnwof^R7|jVIOcz	/N[ZUTP:oS9&-4:8,
 $T	4bjFufVQ`|>h{xi>u9~|4ELIFD@7({cK4!tN$\6
#:Pg}/BUh|-Hc/Je
"7LbvxiXE2#!-<IVdv}sommkkox}tkaXRNKHD>70*$paSG>6.& !$&)0;HUdx#Df <Vq2I`x	<	_					
7
\






&=Rh
#:Ph~

0
B
U
f
s
~









{
p
d
Z
U
S
P
N
S
b
t







 


















0Ga}kXI9' 1DTf{0CQ]gr|?`~*7FUbnz7PhyqaRC5)	#0Gb{05200*Bf/SchoxzhL0|cao~WI}bA&&;Wm:}HS+7;EMQNJB?Jf"[;^ ?eUN|	"1@Qdy > z   7!!!"b""""3#b#}############u#d#X#[#i#y#####$J$x$$$$$$$$J$$##n#1#"""t"b"I"4"2"E"`"t""""")#R#n#{#####T##""V""!i!!   w U @ < A E G G F C D B 7  BgFpL&
GJ}WA+&#tF]|P b>\ M}_+uY@


M
#

#
+
0
1
)



l~
/
	R		{2lP!p4]\+}iS:b"h$  R  pK+y\?V$U'{h]OA4(n@`	]VYp$S
PPc
#,=Od
z-c:vMa!rS{	'{0X.
^-F߫_{,ݜb,ܺ܆W)۠vM"ڭڊhDٹنT$ؕf?&׼׬׌d>ֱm'դk6ԖxcO9# ӦvHҟHљCЎ0y<α΅jZNB0ͱ͇Xlu&ʃ4ɽɌW#șn@Ǟh0ƭeŐDĪ]Û\´V&~U+Y0߿zfO9&
پʾjT?.
߽ٽӽ̽ýqbQA/ڼмuY)뻪l/C߹۹
4Z|l-y*ظ4ŷl?"ɶyP2ĴWowZ'배\7寢VyD孳}pdYH(լZ+ʫ|m\Re̫=h٬$>Ukĭܭ @fڮ7iʯG̰f̱7q޳M.~ӵ1?-׵tO,ٴȴȴԴߴ̴zO!ճɳƳϳ$<LYhwzk]QA#ٳ{hQ9+?fٳtд+{ĵܵ۵ZGB@96AWqѵAl6]NKֹ!sǺoLۼʼam4BmӼEB. Ⱦy#ҽͽ/A¿	0Rbjou5Wx
 8Ne|¯VQ=K+ïĿǐbˮ9fwjO7!		Fݔ
F-~jHH]t[W*sK $41	a
*SQVdQErug2jE!"$5&'
)+*J+|,-.R.y.../5/J/Z///0W1 223y4x5s6e7=889:@;;<a<<
==<<N<<;t;;:f:O:y:::$;;<<\==t>>?|???????o?D??>>>>>>>>*??@m@@JAA@BB	CCBBBXBArA@t@@?a??>|>H>>====b=B=!====='=1=?=Q=g=z====={=w=s=r=n=h=m===>_>>>Y??$@@@A8AqAAAB-B\BBBBBBBBBBgBLBEBNB^BiBuBBBBBBBBBBBKBA\A@x@?2?o>=<M<;?;:":99::0:c::0;;<b<<<<)=<==<<s<H<*<<;;;<<<>==>>?? @A@m@@@@@@N@@?a?>P>=O=<<0<;{;e;m;v;v;;;;'<e<<<<<=#==<<<<<`<3<<;;;;;;<T<<<9===>l>>>$?P????????????????y?o?l?q?z???????@@$@,@:@F@E@5@@@???????@7@i@@@ATAAA#BUBBBBC&C6CFCWCgCtC~CCCCCCCD:DaDDDDEEDDDDD{D?DDC~C+CBB1BAkA@@$@?e??>2>==a==<<e<4<<;;^; ;::o:D::999q9[9?9"9	9888888888888888v8A8877D766N655;544343{3%322R2211~1W131	100a0"0//</..9.--J-	-,,s,R,:,/,),%,,,,,,#,7,E,K,X,,,,->-k---.=.S.Z.f.............././J/d/|/////////p/Z/B/+//////+/>/[////0;0i0000
1)1@1R1d1u111111111111112/2K2f2}2222222p2F2211w1A1
100u0Z0G0300
000000%0,0.0)0"0000//////z/c/N/>/5/5/D/^/{////10s0001O1111111111111|1i1Y1L1C1B1P1k111112<2X2l2|2222q2R2"2111X11000^0H090,0%0,0J0q0000
1>1j1111112
2 2111111111222Q2p22222313<3>3:383,3
3222M2211k1411000e0L080!00////////l/U/;/$//....b.4.	.--g-.-,,,y,R,(,,+++++i+A++**z*%*)|)))(V('v''&F&%%&%$$$F$
$##u#@##"O"!v!!  7~*kGsH!M&OS~\?! o/5Nb]d2

6
}Q1o=

G
		m	(	n:|nbWK@6*
uCp ~/Qw\K=*X#  I b>{j]Y]dit8gU* b    #SF}:y+g5`JyL~"X.	c			
<
s


Ihl
9,qtQT/`*fnebB,*8GL\
Bv,dfYCU'

(_;cxZ0U'b=^4II\cXk9~>$#

 |
y
	z	 '//)i ?iYJTmG(|P*Ht(:\5@EPQC P#@t<Y*g=f:Ao6]n]K8#yP*PIe1߬ߪ$Bd~dI2"4Of~3b
6Vfq|6HNPRTUPIA9447:<?ABEGJNRUX_s(T}/\,Pgt~o_M8zbAa{0c~dMAENW]XE/ EߩR}ޥEܱe۾ۧېvW1	ڊ)ڻOyzuՈկ@})~*єKѵaаZ Ϝ4a̛@˄,ʭv9ɩɃ\2șf2ǏX"ƻƉX%Ŭk-ĪcÌHAh@[ѾN
νW༨uC޻U)κm=
ٹb%鸰PķsX;ζ[0ܵ~J崯n(᳝X̲<ʱzP)ѰsM*ү`'ĮwL(
 -:EQbkaD"	ꭾCˬg9
۫lI& ٪b6ҩo:H٧l6ئצ
&@Xm§ħǧϧ"=hʨ'R|թ+1(֩©{naSF9,ԨjN2$?Voʨ1fϩAʪR٫`,q9oܮ7GQ_msmd[TT_mx˯ 3dѰ
Fñбڱαͱ7`mƳ#fԵ7@yշ!;Uu$`4ӺX+-)-,ʻû;ڼ&vǽo3Trÿ$]kw2Ëðq&cG10v´AýELbƌȯ7ɽATˤFͬ>gӷe=۰ݝߙVnH5h0(A`u	
Bq !"#r$]%V&p'()+S,-.U013<4K5Q6h7r8X9::;=<==>j?:@"A)B8C@DGESFfGzHIJKzLMM.NOO'PPPWQQQQ%ROR~RRR!SVSSSSST#TTSSSSWSSRhRRQ!QP/POKONuN	NMTMMLkLLKgKKJEJIhIHHHGJGFF+FEsEEDiDDCaCCBTBAA8A@w@@?P?>>I>==d=(=<<<<W<(<;;;o;?;;::::}:q:j:v::::;I;;;<X<<<-=y== >*>L>p>>>>>?2?Y???	@A@y@@@*AfAAAAABBAAAAA7A@q@@?[?>>4>==y=N==<<<p<K<<;;/;::,:9?98Y87m76j655r5=54444444444w4`4*433?322:21k1	10b00/k/,/...~.Q.'..--}-#-,n,,+/+*$*)1)(^(''*'&&u&8&&%%%%%%%%%%%%%%%%%%%&A&&&&9'''A(((J))*o**-+++^,,-x--1...A///D000Y112k22/333W44@55)667s77U889]99:]:::H;;;R<<=g==(>>>U??@k@@.AAAB\BBBC&CGCiCCCCCCCCC DDD#D-D;DEDHD?D3D*D!DDCCCCC\C3CCBBBBbBBB)BBBBBAAABBBBB	BB
B	B BAAAAAAAAvAcAOA;A(AAAA@@@@@@@@@@@q@K@@???O??>>>`>O>A>.>>>>'>0>5>3>->'>%> >> >================>)><>O>g>>>>>>>>>>>u>e>W>I>6> >>=====w=[=A=+==<<<<<^</<;;;h;*;::U::99K9988Q8877`7 766c665r5$54}4"43m332b221E1000/R/..+.-j--,R,++D+**4*))#)(c(('E'&w&&%Q%$$4$##?#""]""!!V!!  O  SUIT`6 nV3tE(Eatz{zjYMMU`gq>l5TahrzrT,iK<AQ`lyPo9&Cu:mmG'
4}<-\k!M#lMA/)W-6avp4
<d^.lV$st{yyb<1Ra1zgXL9


g
)
vn
|
.
		t	7	\&{C
SIu0t6[&V   } J  NPZ.~gP4v@
c-d:~gTA,b3Z Y+zl^OC6'vEq8^/nN2
oHd!\"uBV(p>o9W"X1lP3c+q/l*}KlD](߰t3ޟR޺x?ܚt[D+ۥۃ_=ڱw>ّVحS&ׯ׍kI+֢ր^<Օe6Ԡm:ӐUҶ҉Z,Ѻѩљъ{lY?$	бВrS6ϹϧϖυteWI;.
Ϊΐw]D*Ͷ͕͓͔͕͕͎ͮͥ͒͒͊͆́͜{tmf_XSLFACLU]gw͋͡ͷͷ͞}Y6̡̳̿̋mM-˯ˏoS<(ʳʦʛʐʅzqib\UMC8-#ɤɃZ,Ȥ{U.         
      RSRC [remap]

importer="wav"
type="AudioStreamWAV"
uid="uid://b7ug0vj22ygmd"
path="res://.godot/imported/h.wav-c583b19ffdc10876e655e3e2b0f81e62.sample"
             RSRC                    AudioStreamWAV                                                              resource_local_to_scene    resource_name    data    format 
   loop_mode    loop_begin 	   loop_end 	   mix_rate    stereo    tags    script           local://AudioStreamWAV_phxbe 8         AudioStreamWAV          P]                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              	 
 
 
 
 
 	 	                                         
        # ( , 0 4 8 ; ? B D F H I K L M O P Q S V X Z ] a e j o s t s r r q q q q q q s w { ~                                                           } y u s t w y |                    ~ ~                            } y v r o k g d f j o s x }              ~ w n e [ R I ? 5 + !                & * * + - , &   
   
     ( 5 A O ` s           %3AN^p/;AFLRUWXY\eq	%3@LYer*7FXl!*5>HUew2Ok2G[o:]	D	n				
3
X
x




)=Rh8Ur


-
<
G
N
S
Y
`
j
y

























n
]
K
7
 

oH!c1

|
O
!
			Z	(	g8Z)\&~H_=#}fJ+}R'cTOLGBBFJNRW^fmty~:Vs8\2Vy=gCq 2d/d	<	m			 
-
T
y



	)Jm+BUi~


-
9
D
J
I
B
=
;
5
#

a? |n[D-


}
X
1

			^	;		v`D'
vnnmm|R	]				
?
t







/Fr~>

j(d ^UG!BLQY]O4zW3SZ-QEP

3
l*
N
		9	1'i %CDJF > APZ,g
OS[N[jy0%.8AIOTYbu)e"b$bQ+Qq/CXp3g?}3W|{fR@3-+)'(2?LWahmsxwiS<'_8`)KuCU0kDQPbk|B
^1Hfny';Ao:cH/ }_<xFc9jWC.	|fJ!PWzEtV7߭q3޺qs!܈?۬l6ښi<ٹٍ`3د؉c=׷י{aL9( ְ֖zZ8սէՎvggpv|Ն՘ծծ՞ՒՈ|qnzՒժ Hq֑֣֦֠֬֬֜ր`B)'8HZm|~ukbYH1"վՙe-ԋV ӴӁNҷҁF
єTЀ:ϧ[z0͜R
̗[ ˺ˡˆ{ˇˡ˷6̎-͘3ΞI=ҍwܕokNLl5

$
33Z#S(Y   t!2""|##]$$;%%%N&&&`''L((:))***V+++,D,u,{,L,,++%+*),)('&"&M%z$#"! tK}O"z
qk
\

	6	;:^? btx|wqliiknrvz~4i,%ZhZ0^V&_j_PEw %9X}-wT-
0R1iw  G!; g    9YC[fNKLIHVsEl2WwxJo&m+a2uB
 2]-d?
M+{S+JZiy}umaN5rIl-t5[3	eG*
v\C%Vhg4JY"W#[>.2ޔݜ)ܱA|ڼ`ٴ`ظhր2Ր?ԚLԹo$ҁ/я2aϔ;ΞG΍ϕлѽҳӪԬռj^;v _Ql
T
CPvn  y!!p""#S$%%h&3'(()*g+D,$-../ 00Y11N2223f3334U444445)554b4%4363a2{10/.-T,+)(]'&$z#:"!b(o2#V
8
	$	Pv OKYV/sViSrޥ4۳MjEpيIڮQ U$Rpc5Q?=9.;e>ZHsJ) 0	A
Rgy
{pmfMd{Neetu,t `MIDI^+eG- !"
# $$%&'()|*C+,,-,../|//00"060?0*0///w/0/.w..-g--,>,+++f+8++)+e+++%,,,--y.//.00Z112 33R44w566(77288299&:::@;;;3<n<<<=1=9=H=W=X=?==<<<<~<]<;<<<;;;;;i;J;+;
;:::d:=:::9999^90998U876766T5n43210/.-,++'*D)`(~'&%$##/"K!f &P}	;2RrH'pQ/o<}N#



p
@


r%/

j
+
			p	P	.	
	h<_(H
CyN?)		M

{"

1=BI}VE VKbjkVD  !j!!-"{"""6#s#####
$+$Q$y$$$$,%i%%%&8&[&&&&&&&&&&}&c&G&!&%%t%;%$$L$##I#""T""!d!!  - b.Ok[i8{aH,|Y&?zTz6[)CU
d
z-
]

	W		O$+/,&"X!f8HxFM1  L 	 HM7N8}Ds	
>rp+]/ufQ>56;:;F\u@jLr)6DP\m=b;}c$N'qZCKUi5AK  {@ hbp[SVr	 




:OBU#CVETC'e*u6x/S 5i5
e

as<


q
N
/

			v	K		u4X)nN1lQ5$c#{-k	I				9
z

F&x
f


7{#Ih}/Np
3Vy(?OQOPQNC4&pEx(/
K
R[
h
	w	 	+Ci	FD  ]  r8e6=V!{obRB2! #Oz	>rH}%cH~Fi  6 N i     #Gj~X9    u Z > $  nGZVw16"EYltx 3V~*9>,rV^|
F6%nU+^ߍ$߿Zݓ4܈4ۑJAټِfC#ع،[(׿ׄF֋SղՀY9ԹԪԛԏԆ|n\@ӷӉTҴ҂PѶъd@РwP&ϒ`/΍Y$͵zA̊H˃=ʲp1ɹɁMȯȎnL*ǻǊU!ƧQśDyė,b¡Cp5~E
վA㽅,μ`t(ǹdOַP۶p7_˴{&ϳsɲ:𱨱d#䰩l$ԯ5鮘C@F̫~vl]F&תm&کEɨ].)F]rIee[UP<
ͨS觹S13DS`tç<JPYgpi\PJIUet}Ө%:LTUK=38>7'$4Lfé7LdĪ>p̫%k¬[{ o֯B/$-ٵ0ٷjhۿ
8lò^'9Σ
cҴ@q׍؜ٞڒzW0	ߺK(bC"&*2?Yx!j1FQP9g.qaWD& 6PLr7ccK;޺?Mܵb dؙf5Բ2~X@ѹѝq5Ц[ϔB&-EϡV-ѷҸo^~&ߥo?D7NW_	7]!#%f'(b*+S-./01234Y5667D889`:;;<^=>>F??c@@GAAA$BiBBBBB"C7CDCTCnCCCCCCCCCCCQCB
B3Am@?>=[</;:876`5'4210t/@.-+*)w(W'A&-%$""9! V{Wc Hj](;
t
"	t  -e< aYo7^B`L>"B&w {8	
<
,e/+$..
P C!!"H##$\%&&O''(D))x*
++3,,S--]..l/00B11k233.44C55666M7778O8s8i8M8;8&877 769655m433]2100J/.-i-,<,++o+I+++3+|+++<,,-w--P../]//!0o001P11 2c22%333X44:5556=6z66666{6m6O6%65555q5[5:5#5)5G5l55556i666O77*8889G:
;;}<]=c>x?@ABCD"FLGpHIJKLMNOPQRSfT<UVVWXMYZZ[H\]]\^^M__E```@aaab:b^bbbbbbbbcbbbbbbmb5bbaTa`Y`_[_^]]N\}[ZnYYXLW9VUSR}QJPOMLhK-JHGcFECB^A"@>=w<R;/:976543210/.- --,_+*)(>('&&%%$$#8#""D"!!>!  $ YIyZ]z2U	o)}C.BToMLx{-Tq !!""##$$%%5&&]''(F))k**U++I,,,,,-)---,,,,,,,,,,v,],.,++Q++*`**)U)((/('j'&&&%%$$#
#"!G! B	B~v&-_/CtExo}9Qg{(<Ocy{mdV8qL& ~`B'v\A$vntGu4DEAAA:)lHZ

9
Ma
}
6
		_		ZaO\chfg y  6Vmv
2^K[h/	)GjIcJ9c7pKGt A`~ =g8z[ x^> 
	
oi
2H~*,Vi;C f
I<b ]  	!T!!!""d"""""
##"""""l"A""!!!!e!B!!  C V?v
BRKPaw'NnI>j+_8uN

g

OP
Q
	O	EI\mO81o % E`xi
s?`C#aB&
waL9%$?[w	#;Vq
0F]u	 |xtsw"Dc#-6<BGNWajtvMX]ka/O^my4\/;1%u3c ;g/E\xߖ'޼\ݮWܴi!ڏEٯbؚ^׮׆_4ֺ֞քlWA*յՒqR8ԹԩԙԆpV;ӟl7;ѯj&НZϝ^"αt5ͻ?̼̀FˤpAʝnEɈNȓJǰau(œMďKÄC«[¼jr п;q1R＿^+ʻ^ۺb#㹤f+񸹸J޷u<ɶQѵL	ƴI೨p?Ųl?pK'а{reVJD>4'ѯrE讻h:
ܭc4۬|E߫|DתtE婵b;
ިj@秺rX=ԦY-j"ܤ`(飰vhQ9'uV)롮~U1%>TmССmR,m8Οʟ(<KSSK/ܟ~IឲUܟFyOjpQ~ĢZ/0;ɬ[&46Ul¥=mɫS͒ζmԍցqig
ک:!@H/9^39f
G
UCZ!#8&(*,/91L3\5X7%9:<K=>?x@AA	BzBBCLCCCADD'EE?FFG:HHIDJJJNKKKKmK8KKJJJyJPJKJyJJJJKKKJJaJIHGGEDBhA?~><a;9|8075432n1$0.-@,*c)'@&$`#" nA>a'Ikg&L[:8 R
"
	RjA )0Qv=r{xznt{4/6.+M =#x	
(
(^/73fJ}}hD$
*@\4NF:M#JkK2X,N1<{Xak
:!""#$%s&#''()) *t**I+++',t,,-V---4.w...9///+0|002113221334j59677
9::e;<=>B@ABDaEFHLIJKM8NmOPQRSTUV[WXXY6ZZ2[[1\\]i]]5^^^[__`{``3aaa bKbtbbbbbbbbbbbbbbNb
baa a`_j_^	^]\)[1Z YWVUhT9SRPOnN6MKJuI5HFE4DB}A#@>o=<:u9N8.7
643	382c10/C/.5.-%-,),+.+*5*);)(Q(''d''&&&|&_&C&%&&%%%n%'%$$S$##8#"|"%"!|!&!  ^ ' y<G
R!|Y<!mO1t]F/$lM^vf<btiU8s]AzAGD1e =&_&AAEPYt
<
z
#
q![6(0:>IeQE

xhj*ZA{6L2~#uL%:I[mo^G2LZdD#	
#3DS^bbbd`TB2$	i4$LU2~M"",=Z
t
tk
g
	e	d}0R{
hH PH(u3iY]V3iN:fWTNFS|HQ4jNQ7&oGAv:\|Jt.Ok
zX7oTA.	,B[s"K{0m=z:{|  z~p?cWc	}		

D^/i2jH13Hau !"#$%''()R*++,r,,@---.L.../G////0E0p000k0<00//(/.9.-K-,L,+O+*M*)Q)(J(''&%R%$#
#J"r!~ ~4n3_
 	
	$Bi5 Bd_u<x<y\@%b<jU>*6\2d 5i"Ip5dY 9q)G`u9`:HC2!`C(s\G,_2|Q(gF%tAk2W3
!$%$#|pdVB, v_I6"h9u1>1sT'[pz~kZ`hO.~#]ߔ.IVpܗ'ۼ^
t'؟d)שaև=՟N ոw7Ӷ~R*Ҭ}N"фEА[&ϻύjL/ξάΗ}aE)
ͺ͌`4̚c,˷{><ɹ{:ȳs5Ƿv8ƏW ſŕk>
ĭāPÖWDfz*ֿ.ݾ1ٽ1޼/ֻ)ֺ/ٹ2⸓D󷣷UĶ|1䵗Lp$ճ=𲠲N]Ȱ8ïX'Ѯ~U)ƭ^ ڬFīMݪn_UMG=,ܩa;بǨ٨(Kr)<FF?:0שkG#ߨΨͨѨԨרި!&ʨve]WQJHNXcmty~saN8ݧqO1٦ƦƦԦ

ݦɦ7sçyԨ7zYu;װűOv6@6RjЊӻ3hxA
	!$:')7,.0,23G56789:x;R<1=>>?@AB}C\DEE(FF%GjG}G{G{GsGNGGFFOFFEEEE{EfEUEFE1E EDLDCCB4BRAq@?>r=V<:;:876543210/.-,+*])0(&%$u#q"! [{zR+Im]S'<Rg

 
,	a4>b_4'h'8	]
E1

\+y|mRrufWH(z;2l%@v#}0Q


Q

57
q

	Q	Zt0OdR0c+  K   ,  f
.Z	
-
v^G ?{ @!l"#$%&()*+,--.|/L011\223>44\55r66788991::H;;a<<=#>>V??@[A	BBCSD$EEFGTHIIJ@KK=LL4MMMMMNNMMMM\M0MMLLLeLKL/LLKKKKKrKQK1KKJJJRJJII]IIHH?HGG[G
GFjFFErEEDpDDCfCBB'BAFA@5@?#?>=G=<;P;:929|87!7}65/5443832d2"2111s1`1[1V1N1N1Y1n1111112B2j2222
303M3a3t33333333333|3g3A3322d221E10v0/i/.E.-
-Y,+*3*y)('<'~&%'%$#=#""! s aV@l(q=H!soI
$
8y

^
/
													

4
M
i




M4~
^

	d_/o""$'+/36<FVfuDj5Rgs}3Rs?b
#3=IUXO?1#wU0eE'
wP*R{!X&F
l

a`>




1Lf"+//.--/257;FWj|
 
<
W
r







u
C
	
[m

N

		N		h#O >z!-/' ! #Ac II?m8E<x@sZA&
&2>N`tiEiE%
/St=|9z9n2Oh)Qx3zR<&]
(GfBk4% {  gjzi*3mLT	I			
P


	C}"B_u
-
V
}


F"S.G[n
KeK} 
sU6^4[ Qk7
[
Y[
o
			hCY~4;'lS  l % h8c@yN"f9k7 _+`A(weN1snrwzubN:(
~sh\PE;51-("
a=nZL@4(tY?&~k^XTNFBCEECDIQZbhkjhgcYH4!
hF"e<a3J{,BcMPWd&t:{<t._Co&Mgކ<ݦY
x,ےFڰgٍEشl#׏C֪]w+ԚT
Ӏ:ҠPѪKЄв?Wkv˃˪Dy!ȏGǾǁEƇAū^Žkv/´w=
S!x?q)㾞ZӽV T%̻`#躮o-깩h*ĸoH,ҷ÷nT;!۶ʶx]D)еj;
റbL<- 
г|[4
᲼mUECJS\kͲ
+4652/+(*046:@HPUX[_bfmxѳ7fݴXߵ(p&]ȷ
":W%f˹`aֿ{ureXeǌȷ,̟,ϽW ԫNؗ.܋ݹH0BlU'H^QM>R
l p  ^Hy(	n
fff
]E"l{%f4{Hp+c%s' !Y"%##${%%%&I&e&=&%o%%$J$#9#"2"!!L!!      !>!!!!"9"R"s"""Y""!!m!! > }NyqIP  &!]!O!!  P P>o5?g"ca95`BUF}[n/@])Z.v[na6 2!="C#K$g%&')1*8+,,-./4/6/I/`/B/.c.-x-,s,+I+*>*))7)(((((}({(((((((i(=(('k'&j&%{%%$3$#|#o#####S$$%&&q'0(()n*++X,,--P...=/h///////0*0K000F111z233Q445m6?7
889r:G;<<=>>#???6@`@@@@@A$A=AcAAAA.BsBBCxCC'DDD1EEEE
F1FPFJFFEECEDtDClCBtB
BAAA@@w@x@t@l@x@@@AOAAAAAB$BBAAASA@X@?F?>=4=i<;::M9876M655{43h322"21C10f0///y.-g-,@,+*W*))('G'&E&%%S%	%$$$%%1%_%%%%&:&V&t&&&&&y&n&Z&?&& &%%%%~%e%U%P%O%K%G%L%Z%o%%%%%%%%%%%%%%%%%%s%9%$$l$$#H#"m"!!! 8 Y}
M5~Gv@t
 b
.
	
	
;m<|pkhgaM-	tH8b	@p01)$ xpnhdm8Y}	dC"l:
S,	nJ}4  W  v0j'd"yJY*y1\n N Ubt"n J
9`3g@	K P    Ip]6   P  w<^)e;v>|X+YeaST[_dn&Jv.iQ 6e1Ic}	4Rn0[_dcc  HC]sL2#		
_


$WD

J
	v	lX	v3,a$Z.1}BW2[+GZjxJ9f		d

X*M




4Wv~H{;\y}l)eZD>AT

S

c3m+
K
	5	,4/wF/H^x^&I
}fI'
(3ASf} rX@%sWF@;76;AM^om\KA4I l  |=tC#	mK%t,XB~>c	Zi.{D{Ft;S$sV@&/CXq&BdwY6nYE/`;E m 7w5|R"~K
t(:66-Jn.u=xM#߲ߔxY7޽ޘn?
ݮ|Gܩ~V/	۰ۛۅlQ7ڜsM+
ٽ٘{cI)د؛؃b<ױדxaPD6$ֱ֖uMըm-ԞVӐUҭ҃Z/ѦtA
~*"ϼW͛B̨e&˼˪˙ˊˀtfT<ʵʁKɑPȯȂU-ǺǩǚǌxY2ƱƈdH/)FjƏƴ6CA5&ƵƥƢƭ![ǚTȌȽ7MVWVUQH;.%  !%-=X|ɢEvʥ	">\uˆ˔ˡ˯˾,AWu̚.seθ
Wϡ&\Љд%mѵPҽ;ӽ>Կ>վAG׽/ءٍ~ۖ&ܵLݨYi+wZPD0$@VU;{  _'{VEcb'g|TS&EWB?ERw.Y7   !Jz +:Tv(eB\hHn6b)	^										
"
I
~


Kw

Zg
fI,-HdQ S2BLRO>"_5"Fh         
      RSRC             [remap]

importer="wav"
type="AudioStreamWAV"
uid="uid://cfrr6ucu626wc"
path="res://.godot/imported/i.wav-bd175787a15dc96926b6407b9cc67d6d.sample"
             RSRC                    AudioStreamWAV                                                              resource_local_to_scene    resource_name    data    format 
   loop_mode    loop_begin 	   loop_end 	   mix_rate    stereo    tags    script           local://AudioStreamWAV_l0l2i 8         AudioStreamWAV          W                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      ~   
   - G \ a ` ` d d Y I 8 )    
        ( 3 ? J Q Q M I F B 9 -    
 	              , E ^ w      '.-)&$         } v s }                    { y u o l u               z p f _ Y V S O H B @ C G J L L I H M U \ _ a f l t                    #0D\uw^B$    h N 6 !     % = Y p             } [ > &    ! > U p     ,:J_qwulaWUTK9'!$0=HIGM_njYG<1%           { r d Y V U M C > ? B H W l      #8FLLJD5!                 t Q *   , b   T $!G	  A iK03@Kc     |ihi[G?HXk D Y e q w x r h Y D 1 %     ) ; V     Hj{'AA3j.    a I J \ w     #)%           	     Q P|R  \B@%2>> hM
T\Tn,~
 e  UOHuEe
 W 0H \@%  
];}qsiBZP@ ? ^"yXNpm]2-    GfhYOPZdid_fzyb7  M  x	[(yPA {  }    m % A
X@u==  b`8`rP=( 5 zg(9F  ,HJ '32J+kG	 N 
 ]3; v  oUb# @ *N/5yNh H2(W0{2vLK , b%|}~,z gYb|>4O W ;G}D2h	qE     `ER%y L [HxQ  7 GXod&QJ
h3r>i w  t3xi5sF `x[tZy!MoM TBD1inl LczQrQ&We It:.
Q

[Yow} j`cFK*	Xrp`d&FFF  O R
Y/O".Ahh<U_t] 9"$BxQo-hQ~ 
 C;mR?d;utzy:FhLRVI[Jbk	
ug
	% Pl6{ :H<6Qd`*XHFYn )  1		X

M
B
F	62 Hk65{d/-r6
QBfO0gy97?Y2ps  44@{= > rJl+Aie&$6 e!	G/@ /\*L	w>W*b57E{Jd#.  h7KH#W* 0TZ@ G#!I[ b     !nRmn8M%   m"uxL=	 7X
1QU  E'%)de1m9\lqT3 \,
 +   XM^S		

N
	"sZE  3S, oUL 3& f6 Fpz  H7"I>l&1Ui d 'rah5 d  05,  0  v Ikre2
 +fr!y&xxU[ M3 Tv&k	
M:|
	9to m$4BT8"7	^ki7D  jXh@j|	-





u
5
C
RZ|hZ     K*Qw(tNc_"8aeA:0Eot?#.m
z+ih(
	>#q;T4R8~%\P)i>
m l90Qw~Bio7zE _ `RMa)\OV5 T a \ S a \ 
  )l<   );`$A<  _q 'FTe}K#q   ' ~   =? A g  8 
4n-r>i97AuX%` \_adI	{| =Y&8T}oArynxm<e4 dAj2]2. hJ;1_b&z@
~?n/UNn=_F;|TN?!\imht}NPN3Wz:<g02_;jUI{amze
2j
en.J)gysrPHdp6THvܷo7ڙ=
5ޛcgCmf@:ޅU6bޔt#GGY'[<at8ܞٯc]Ѭ\~d|֓׋}نڋs-ݓB7	JJ[$$2@'dK`?+Y^#A>z`YS-^Lh,aA	
m^hp ""#$$%7%%$$$#! 1]JYd%ojvC}4em
K "#%H'(*,.02Z4679J;<=>2@NABBCvCCDeD~DtDrDDDJEEEQFF~G*HHIXJ-KLMMNOPQR|SSTUUVBWWmXXhYYfZZA[[@\\8]]^^8___W``Caaa7bbb3c~ccc4dzddddeEeeeeveeeese4edddfd*dccecbclcfcZcjccdKdwddd0eUeieoe_eCe$eeddJddccccccc*ddceexfIg8h+ijjk^lmmbnnnnnnndn
nmmim0mmllllm
mmGmmmmmmm[ml{lk"k=jUiXh;ged_cb`_s^E]*\=[ZZ[YXbXHXFX8X*X"X!X$X>XUXHX XWmW:WVV	VUUT}TFTSSSS]SvSlSHS(S(S+SSRR+RQ$QPONMLKlJ IzGEcDB*Ax?=6<:!97e6)543C210j0//T//..Q..---l-@-.-*-'-'-0-@-W-x------
..----]--,@,+s+*b*)+)('&'b&%$##E"h! WU?2|+Mj'UlHmzVjL
X
#m(

S

		w	@	|Nc@E	i&?n,NTC)S~"rQ(U-	x		F

W:~
W

c zQ-7{
 uB{GEY{LdNF;
gMEqKY e  !M!!!-"s"""(#d###
$9$m$$$%W%%%$&}&&4'''r((|))v**+,,%--..//0a00O11&2x22=333(4d444
545T5d5p5555555~5}5x5t5q5q5y555556U666&7l778Y888-9a9999::':.:/:$::99999c9>99
98888888l8I8,8
8777E7766`6$6555e5F5.555555(555F5]5y55555555555\5%544>43w332%21210?0/]/..5.--9-,,T,,+g++*_**)E)(w(('W'&&?&%%Z%%$$T$"$##t#4#"""5"!!C! q 
z52r)oY~1Tw

)'

		z^D9@UT  + c5DHPdz
H/QE	[(Qb>GH0|W7rTDI`RvEfI0p]J7$vY<ߴߙiU>(
 )C]wߑ߮)Ea|0Pu;d/W&D_v
4Mf}.V$ZW!i>aOCUt?xQ(pHV#S|?RVA1k $ 2 = F O W ` i r {              (18?GOX_fq7Wy3]'Pt'5BKS^iu$-5;AFHFB?;4'
rf]VK?4+!
}jXG5aAyX9yW3    h C  ~U.	g>Z'Y(oG!yZ<zY8hL0pU9qZE/nP0q`O=-zbI/lN*rFoAX)b1W$T&vN)nXC.o`QC5&tic_XPIC>81) 2DTg}0Nm&MuIrIs!Nz#Px<^>d8Wv8Tp#Fi
<k(X OEwF|%^\*w]TPQ  Y  	`fp)I{N&d		/


V
e
g


a
_
^[ L8G8q
;j
2Wy
)E`|!8Ne|!7Nf
0T|;a&6EScs 	
iK.~cC mA}@:W	fy7vH/!):L^pteIw:ZkbF$
'
G
	+	g.fQ  m7pr=~jN*D {8i&wP6'r6u%[+kYaJ;,
pW7QzK&	o]G/`9P6^_)i?t[A**Ga.mP[
ae
^ L.v@	LQEw1Rn +Hg4m[P GfxaM@7.# *5>HVev{iWA)
5q-{4My.s9g&?Zu5PbpzX:p+S^?a7jR:#{U+xFsA}N!_XJ'Jn/Sy
E$l\USb|3\TL	߀:ޯg݇=ܣTܷiځ4٢\؉>ףVװWզKԈ%bӬRѢS
x0ϯr4έcͅ-j	̨F}ʵX ɨOǬf"Ɨ[$źńMĦl*ÒF©RKO_"辬rF)߽νƽ½pS2Ѽa<ջʻջϻhD˺{R(عcJ8, 

!(1;FQXWOG@6%޸Ǹ|bK9,! ӷƷfM4նtW:޵Եȵ̵ߵ 0Mi߶:Xvз)GgҸFr˹>c̺,Ns8b$Fh̽ڽѽzssypYC,
sJ Ȼn]J949BJR[huԻ3G]pwpcVKB=91-;a%n^H)Y
*:Tz4j¤OrÊãýóáÐÀp\@µf:tcWOIA:65687,}NɿkM;8=@COfڿ7c}*9âPƍTɥk.͚̾bC+"!+CYmۆܫ
:b|K[9,,R rw{	\
N!%' H!!~"###$S$$$$$$$$$$w$[$M$M$Q$P$P$a$$$$$/%%	&y&&n'(()?**+|,=--.k/00g122j344m526778}9Z:=;"<==>?K@AABDCCDNEEGFF/GGHHHhIIkJKK/LLiMNN`O
PPQtRKSTTUbV&WWXYY$ZZ>[[]\\w]]k^^G__`U```aWaaaa.bPb`bmbbbbubSb4bbaaaaa``3`__&_^]^]]]\5\[O[ZeZYjYXmXWJWVVbUT"TSRKRQ*QPPO
ONNMLLLKYKJJ,JInIIHRHGG7GFF1FEE3EDDKDCCqCFCCBBBlBOB3BBAAaA&A@@N@??S?>>C>==2=<<@<;;f;);::w:A::99|9>9 988?877176s665054R43N32N21<100/.y.-u-,g,+3+**])('.'t&%$($c#"!!A r33&=)xd	Hu
<mHS`-



j
H

V'~P


n
G

							
M
}


%mIC


9d>i
ZP@1{V*i9rFz5d!T@]<&w [   V!!!@"""-#u##$J$$$%O%%%&K&&&'J'''$(u(()p))1***P++,m,,&---7...F//0`00%111W2243344	555t66a77=889r99&:y::;_;;;:<~<<<=====;>z>>>4?t???;@w@@@3AoAAAB6BaBBBBBBBBBBBBBBtBbBPB=B(BBAAAAAAAqASA4AA@@@d@2@??n?%?>>A>==9=<<?<;;@;::K:99]998x8)877/766 65X544(43U32221<10a0/}//..-.-,D,+d+**2*)i))(L('''&A&%_%$c$#_#"O"!2!  }jmwoyraT;'z]B*

+P

E
			R	"	kX@U
WFzI9 x  a-bllnP'SW{	c:,F[houxjHGkTXag|U
ht.Pr )WPK;p9l5xFV=cHUG   E:k'W!`%Vy!-A]} 8}K:			
Q



&Lp:g
H
r






2J`%]
Kx+YR}eM ^T$pN,

`
+
F6
i
		+	kYk I~APW&m1  Y 
 [;2?PV!v:cx]C->f)}D	Vnd!How6yFo#@YC>{:g3߇NޒL݃=ܰm,۰r3ڽڃIْSؘ\!תwO*ֺ֚|^@կՉfF(ԺԲԱԻ)AXoՃՖժտ "*037;<:4.)#	յժա՚ՓՊՄՅՍՖ՝եկռվչչջջս 0AScmliec_XPH@?JYfsօּ֟)?Wnׂ׍וםק׭װױײ׳״׷׹׼׾,:GR\hry~؂؈،؏ؐؐؒؒؐ،؇؄wl`VJ>0!׺״׮׫שרקץףנםלט׎|hVD,ֶ֝ֈt_K:/&ծՉa;԰u:ӌPҡsGў{X5иЌa4Ϡo?κΎb8Ϳ͔f5̣n7˓b5ʯʊkL-
ɟ|T"ȩp3ǟOǴhń;ĕ`,íÅ[+½PD ~>N澳[5
½dE$ ۼnH!һrU7޺eD#͹{spmifefgggec`]\]`cdjy̹#A\sĺúºººȺѺ(?Wr׻ *?Ti~ȼ <aѽ(XHzݿCvCw@r£;^ÀßüNĈ9ŌCƝLǢPȠXɕ .\ʊʼ*b˘"wv@Ωv7ЗUѬPҢJӠJԠTծc6פ}؆ڜ(ۼV܌'gIQe$b*zWA- sdTC2 !	
tc
M1^2cI6& !"#$w%F&''(i)**y++,,-2../6001*22[33m44x55I667j77738t8889=9j99999:/:J:c:{:::::;>;e;;;;<E<w<<<=C=y===$>]>>>?L????"@T@@@@A<AhAAAB6BkBBBC9CjCCCCCD'D2D8D?DHDMDLDGDAD>D@DLD[DjDxDDDDDDDDDEE$E4EDEVEiExE~E~E~EE|ElEVE>E)EEDDDxDQD(DCCCCWC,CCBBmB%BAAIA@@ @?S?>s> >==<F<;p;;:;:9u998>87i76665654Q43g322
2110+0/=/.P.-_-,s,+++*'*)B)([('p'&&&%3%$V$##3#"s""!p!!  ; vAW1
rO-	]5|cO<&{hT@,	o`SG9,%&*-/0001/(gBe>vaL9)3_(_ 8oVU g9~GI8u) k  !N!!!B"""S##
$n$$/%%%Y&&%'''k((L))2**++,u,,S--,...Y//0|00011132223b333'4f444
5?5q55556%6C6_6v6666667777P7j77777778#858C8O8[8i8v8888888888888888888888y8i8Z8H8488877777h7J7-7766666k6Q6:6%66555555555y5o5f5]5T5J5@575.5&555	5444444444x4_4@44333|3G3322k2,211m1(100O00/[//.P.---,?,+X+*j*)))(+('G'&k&%%%$<$#[#"m"!x!   )=Ufmtpf_VOIB=>
@
KZ
i
	}		?b=,Fk(c&  u ;  Y p6TT#f6sCZ,V2zuqlcS=(	@$kOXwE+Mk8!af&mi+wcs.{T< n
 Z   I/r:HQ
P	z
iWC
;G[m|wmQZ3n,fy   s!!l""##""""("! ! H'-S
,Kw)\^0(+'ftIDR\ctqE,W'vO%JSJD
!
m
l

			f	E		h*"ODZ&tgWH8'vM>  S  dOPLt(VjXSV ?}$vo0/&ߧ(ݡݕ݇t_H.ܚM۱j+ڲtIEZm}ڗY۞?nܟܿ+Ryݣ,Ulvހގޔ~T%ݚ`#ܭ܉wiXG9.%۽ۃNnڪKءQ׭{hcUJW~ײ@rئ4BDMTQ="زإؠاص)Qwٜٿ'?D=62(ٻ٣َٕن}zنٚٱ!	ٸ٬٠ٰٗٞ,U|ڤ&S۩%Nzܦ)^ݙNޑ'r߽HLw(8HT[ahptuuvwwtqnkdVE5%zjZJ;-"i8ߠMޫZ޲^ܮ܁S)۷۠ۉs]D$ڲڋ^.ٛ{dL1/BRd٠)6FQM;& ٿٙvR/
؞{X4םrH֐`0՞o@ԨvC
ә]"ҥc ѝ]Пd-ϖg>Χ΁Z4ʹ̀M̦c!˞^ʜ`-ɡsI!Ȥo3ǁ3ƃ-~#lÂ>´V-|_AnEпwZ?+ھҾ˾þȾݾ6Snʿܿ
3EXr!N|4Sl¤»
*>Z}ß2X~ģ/PjŁŚų+Glƙ$aǨ5{spx)̂8͔MΩbϼfй
fy9ӨԇgP6ס_ؼh٪Yړ.b۟Aܓ>ݤ}R߼%^)[D0<nPn&y=U+
 
*
JxE?&q .!:"=#H$M%1&&'j(())*V+,,-^.6/001d23345y55!6w66666666e6F6*6 6+6@6O6]6z6667B7t7778.8V8w888888
9#9:9S9q99999:<:`:::::::;&;;;N;`;s;;;;;;;;;;;~;N;;:::9:99c9'9888V8C8G8O8R8Y8r8888999N9b9x999x9b9P9>9+99
98888899&949D9V9g9q9v9x9}999|9t9o9h9Y9?9!99888H8877=766C655Y5
54n4$433E322Y221e1000/5/..t-,@,+*<*)(4('&.&%$+$#"8"! > G><4Gk]O/9d6zP&



]
5

zme[N?2' *3;CJNRUSK?4(
{jU>(


'6F[s%8K]q
D



(mJ6j
 />L\uCg8Y{9kT/{v#FiBX3V n  !e!!"_"         
      RSRC             [remap]

importer="wav"
type="AudioStreamWAV"
uid="uid://v5kf5bssscn1"
path="res://.godot/imported/j.wav-de8ae34010f21a72b08eb76cf396f831.sample"
              RSRC                    AudioStreamWAV                                                              resource_local_to_scene    resource_name    data    format 
   loop_mode    loop_begin 	   loop_end 	   mix_rate    stereo    tags    script           local://AudioStreamWAV_7kuna 8         AudioStreamWAV          k                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       	 
      
 
 
 
 
 
 
 
 
                                                    ! ! " " " " " " # # $ $ % ' ( * , - / 1 2 4 5 6 6 7 7 7 7 7 7 7 7 8 9 9 : ; ; ; < < < < < ; : : 9 8 8 7 7 7 7 7 7 7 8 9 : ; < = ? @ B D E G H I K L M N O P P Q R R S T U V X Y [ ] ` c e g i k m n o n l k i h e c a _ ] ] ] \ \ \ ^ ` c e g i k n p r t u v x x x x x x x w w v v v x z | ~                                                                                                               %-6?GMSWVSRPLB80)#      	'.139BKNQV\cjsz~~~}~	!&()*+,*'!
  #(3ANU\hw~{z{
	

$,5>HR\bfilnonlhd^YRJB90*% 		&.8@EIHA80)!	&.5;:5/*#	
#=] 4Ja|1;ACC=3"tf^XMFGQ^is~Q' ]=$#&/KnmS>0*,8GZu!292&'>HMViz|uphaWH4&,=NTa=f6Wdlo__rE"AjyM% _KSfzjI&"Pz
*&
{m^N=/"]/a;AfsAK.h	!/PmqS(`2{G[7#uB6@~:  I)r]l^JQrMGWkv~oB  T   H   W@^nzS"H t 0 oG-
#4MdjhbXH0}ur &:NZa[UZ{g%M`&n: 7Xz
j?1JR^|-*lO;.)*)/DpDl!8IYmyoV7fG8.$}U'w`Uay1GA,yN0&$""MHwc1bWcxwN.j{b[O(0yG
&2==+JjyL(
1ZGh}*@MW][I0vbTNOV`n|b@- ,MzvHu3Ey3WvzjP-	 +4<>1GxjcY_I4hsfT:7Vs}wrjR)~;R v=	!T)Y%8HV_iz.h6tXwhP30GijR4
	&Gah]NJ? r>q>




#)2?KQV[\ZQG;/$'4@N`r&Cd.@Tn4lIDw      tZ>5GNR`i^:
M
}>mB-
(?QUSOJEEF=0)6HWcs"?^~<a*BZkmga_ZOB6+!)?Xq! X    Bi|{tuq_@     u ] L C = 4 + $ " ! !      gCY4vcN5uU2wiZPNQSSV]kz'Jn%4>FMOMJHFBAEMVbr
#7A=4/$
vKw^H0c:Iw?yyvx(3>LTNA4+$,EYtL*byZ?0)#.?O^lxsf^YSMGHTg{Hl]-sN+0AMYdmpnlkhc_\ZY\ep{ *9CLYgu&=Qbp|$.6BQ_fbYOH?-.G\n 
xof\VYet$Fk! B c        
                         )6BO[iy,:GR\gsxreZO>"oM*           .IczufXH6"      j T @ ,      % 2 B T f v                  	  '3?KVdu#2@N]lwr]I7'
+AVl#4CNXahjjkkhbZRJD=5+! )05<DP^lx
 kVF<71)#'6GU_l}"(-2641/00.*'$"""a?zgYUWYZ_k}tdR@0 	$2FbDn+58;>BDDCDFJNRVYXRMH?.gH,yjS<'u`L6           u o j ` T I A ; 2 &    ( D a    9\|#(+.4?LV_k}dH*~wlcciopqsux|~|yxyzyvvwx{wj^SG;/"              ~         '6GYjw}si^UNE:/&
                #=Vp"$&*/37;AKXgt  ?]wzrgQ8wopstqk_O>/!reVB)     ~ i Z Q L E ? @ J Y b l {       '>Yx3Wy	|m[F3$ 
q^K4    m J (  zux}zx|kQ3tY=#$8GVh|wdPA6+ );Vv"+00+%q]QG;1+,5IdCk
    % ' % !     tcTIC<1& &4?FN`vxfQ;%xi[ND=6.'# &3;EUl+/3=ISY\]^dr~zmV>/$
#2AMPOPTWTOMMQXalxe<O{ulZE4&	0]Aawxqkg_K3}oefkmov!+8FVh{xy~{x5Sp|R#QsnqzkR7 9Qh}$5DPV[`dkv'3?HP[l}qhaUE:>EIIJQYbmxyiYLEA;65=IT_kz     $ 6 E O V [ c i m n o o r y         5?H]u ?`}M<KR\ipi]TPKC9/'{sjbXNE=4% ->LW]__cff`YWZds
+5@WSHLx	$5Mg|l[A#	yvqfZPGCGOUZd}&2544660)# $6Lb}	5	d			
4
`





%6F[s-Lk




 




$
&
$
!






6
d



Et4FViz%?\zrW>0)%}dM7 	G

^

9J

u
E

			N		t:Lo@~eO9%!2G`|vU1hM4 s@PE   X . 
 ^/]'h`ags{|{{Phem4qid`^YUZb\5u8f!T}uqsx}o[D*h<Xf&o2xF{gXD/SNiR5wtrkS8&a-bS*{xnO*\"\2vX:qP5Jp1f3ߺߞ߅oZD2(!	޲ޥޘބo_VQOPQOLMOLC7+ݵݠݍ{fP=2(ܿܫܙ~Pۻیa8
ڷڶڲڪکڷگڋ]ه:؛qA&.8BM[o}zl\RB'׷גv_H)
'.5=FQalhVC:1ֿ֟ւfJ&իՏsU6ԪԇiN2ӬӋmQ1ҷқeP;(ѲњvN&ЭЄZ0	ϿϧϖϗϝϣϨϬϪϦϢϟϒqFΑQ͙sU5<Tp͓ͼ8GHHMK7͈ͭa9̹̦̓̃uj`YQH=1%!*/4:DNZb`Q>. 	!5Jg̐̽?l͙'iέ+ϊкMўҜӮԴոMKܿA-W@dB/;UgrTr " $	
M"S$
i

~#R%T  fN+Vv1qz"o65*M'@B5%WqNn/t4c-
.Lb~8aw]-UU3\)f4jK,
KR'4Kt?eU1
t

57
;
	2	'3Os0[,tG=  a  u/tOCFLLOYhyv^K3\;$
 *@S_dhoriU=)zrmc\av#)
sDm2Ge3pDc4U(lI+n[H7%yiU=#iN3xqld]VRNIDA?<:7789;;;730,$
 +74,&!?wdRMIc%j(a\  ;\v
cyA	

M

Oa
d/Rv
AQ9LL|V]1wOuW<+%"'FoFy*-wfN8Av\! \   L!!!!!!!!!!!!!!!!!!!!!!"5"\"""""#(#D#S#X#]#d#d#Q#.##"""s"K"!"!!!!!!"%"E"d"""""""""""""o"9""!!c!)!  z >  Hy3U
py'wdP:"a6;;>?I

5
[=  hB


_
.
				}	t	h	g				
F
{


)]~}k_YRIF]$m/


KC.ANW]i0j'q])]oG{)X#odXJ?841.%u^PSaozRX-vQ(oH#kE/d:Z{]D!  !!(""6##$$$d%%&Y&&&"'c'''#(m(()t)).**+++e,,#---+.R.e.....].5..---e-8------ -G----#.a...1/l///////////\/./....b.C.#..---------w-O--,,m,&,+|+'+*|*#*)q))(o(('w'&'&&8&%%Y%%$$U$3$$######$$)$B$\$s$$}$v$r$m$]$>$$####{#\#A#6#B#X#l####$B$y$$$$&%O%j%q%l%h%g%^%H%*%
%$$$$|$^$F$8$1$*$!$$ $)$4$?$D$>$0$$$$	$###d#8##""Y"""!!!^!/!!   b 4  s>^$r6k&Oo*i*mAzQ%p:\)iG*tdTE5$kVC1}hR=)|pg^SMQ\gq}$(,3?Qct1Tw
	
1\bL/#e1VQ{b!ax4=ObHqa`j.{$V9A



u
[
Q
R
V
Z
T
9

FK

v
5
										.
Z
}






g
1
		l		w@5PjzX$r>xopomw6Y~\-ZbD$
'2?ObwmM+
6~X
j@u	6	Y	}				
7
]



 SB}V^;




-AQ`roS9 


L

		y	G		rX@4#2K7O#j3   B A%X7{"k1vfXK8zE V V Qr5aAhB
}2XCvL"k1R!pU:f1w7``+{8q)Hf4^7
G|:߾߂C޼ޯ޲(8EG>2'
޸ޟތނzphoކޤ޿,^ߑ3VyzseM17Tq':Mapvuvxul`SF:."cF+ߵ߆X)޽ބLݩt?
ܙ_%ۯo.ڭq8َ_<ذؠ؏mYE1ש|Q)ֹ֔u^L:&չղժՠՕՊՀmN' ԱԂPӿӢӏzcW\m}ӋӝӲӬәӈweVOOOOQXcnzӄӊӎӒӗӖӉpW?%ҥxK!Ѩр\<мКwU2
ϛtGί~O"͠{[> ̹̐h?˗Zʝ]ɠe+ȹȀGǜd,ƹƁHōNđR×]#·oL(
 +5:4'whYJ>99::960,(
lCǿ~\:Ҿe?˽|V2qI"ܻ{\> º[9ع{^D*߸ʸ}o`RB/޷ʷwi]PC6+!
ܶӶʶ¶Ķжܶڶζ¶ȶԶ/Suܷ4;?EJJGB=:@Rg{ȸ/K_r¹ŹŹŹƹɹιӹ׹۹,Dbغ&BZnλ&M{WBfǿ*V4¦ÁÇ ŷHƛoH(BmѥO֐	AۄDߧmK
 +/03:8 t"Z
H2vPE>X!"$>%'&&'(_))Q**.++,,,[--\../00#11M22g33S44@556d66
7_777&8e8889:9j9999":Q:x:::::::::::::W:1:
:999x9U9=929*999919O9k99999999999999999:F:{:::;J;;;<0<X<<<<<<<<==<<<<y<Z<7<<;;;;;;;;<(<H<b<t<<<<<<<g<O<3<
<;;;V;-;;:::b:J:4::9999999e94998887A76J65
5m43/321A100~/.p.-b-,f,+j+*K*)#)('8'&%%f$##S"!!u aNc||{gSd_s,k@"3j-k<;r;_%Jt
@t1p=]7b7VxAt3w) b    
!!(!7!<!.!!!             !/!K!h!!!!!!"1"G"_"z"""""#I#}###$_$$$B%%%0&&&$'h'''%(a(((()G)|))),*h***G+++(,p,,-J---.E.../>/z//0W000N11222U33)444g55+666F777;888!9a999:X:::
;D;~;;;1<l<<<<
=2=K=R=S=W=[=V=@=%==<<<<e<?<<<;;;;;;s;b;L;-;;:::x:H::99{9<988~89877b77665655K544W443d332r2$211@100W00/l//..6.--Z--,,G,,++V+!+***e*<**))))s)Q)1))(((c(6(	('''S'&'&&&y&L&&%%%]%$%$$w$:$##o#,#""~"I""!!l!5!  } 4 \
k|.Bi!Lx+<2xL{U:DV
u)@

T

^
w.

]
(
			a	<		~pt	h		
R


FnT?'





>!

"P
RedgnjL#
9aCW<":DC?>@JZit+cU
tO&|nc^_cjiV/~9c(qTJF>76@LZdf\OG<X)}9+Ntu=ZDb6

t
3
[v/

\

			Q	#	\5>T+\MN
C  | ; cr!y%5SN@jfDwdP9&Y7FLlbhprx|KW$}fUR\jr}		r?q/x9rS:*tHW![8yj\OB2	kR9nM,
eE&s[NIE=89=BFGA6+$oN,n?IߡqK&޸ޤޓށnZH6% ݾݪݐnH$ ܩwC۟}Z<'ڵڢڏy[:ٴًa8ظ؋_6׹לׄnYD.ֵ֜ւhM5 չհզ՜ՓՋՄzkWB0
Լԯԥԝԓԉԁ{uoib[UQKB6(ӱӘӀjS<&ҴҧҚҍp`O>*Ѳяe7
вІY,ϰϏlJ(ήΎjDͦvF̶̂M˵˅W'ʩʄ_:ɷɘwU3Ȥ{R+ǳǈ`<ƥƏ{gS@.
ŸŠňqX?%ĺįĩĦĢĞěĚėĔđČăzpeYI9+ 	ÿñæÜÖÖÚÞáêû)7?=61/(0LiăĝĳľľĸĴĬĜăkT?/('%(4Kfęĳ ',++*$
'LwŢ(S|Ƥ &,5>FNYhxǌǨ!Sȇȷ>iɔɿ
$&#!!%2CSayʦ?r˰4t̯
:o͟	/Y΍&^ϭgиxm^<Բ/էs:ף؊cWڇܝ6ݓEߟQi*uU3}rj]ApK3 	 eF		
X	

j#y{)}(,zlS4B  %!!!]""#|##0$$$:%%%E&&&W''(`(((A)v))))))))))*2*X****	+A+z++++,2,Q,k,y,},,,,,,,,,-.-P-o----
.6.[.|...................../3/X/|////0A0[0k0y00000000000~0u0q0w0000000011(181H1U1W1K1<1.1110000`0@0%00////n/R/5//......b.G.(.---l-2-,,t,5,++}+C+
+**Q**))I)((Y(
('i''&u&(&%%>%$$\$$##2#""G"!!Z!! j ! HZ#V$j={bN;({_C%	=[v$7GWhu~@l%W9Set(=Si   ' 0 7 = A F L R Z c l u             	!! !(!.!3!9!=!A!C!F!H!J!O!W!a!j!t!!!!!!!!!	""%","2"7"="C"H"L"O"T"]"n"""""""#0#O#n##### $$-$C$X$j${$$$$$$$$%%4%M%d%%%%%&7&b&&&&'='b''''''('(<(M(](l(|(((((((()&)=)T)k))))))))** *!*"*#*#*"******
***)))))))))))))y)i)Z)J)8)&)))(((((~(c(H(-((''''l'I'$'&&&&p&O&-&&%%%%t%V%7%%$$$${$\$<$$$#####h#N#5## #""""t"]"E"-"""!!!!!!!!!!!!!w!k!^!Q!C!9!9!A!K!S!^!o!!!!!!!!!!!!!Z!4!!         !G!s!!!!!!!!!?!  G a=VTIB<*'gU)pK%q8 \%uX8a6
^/~xnaSH9~K
L]$#!LR|TD;1%"/DYlxyvtsfC


L

}8j%

t
>

			r	Q	5	$				u:BP~?tW7 nU<!wY<l>
  h 3  yc]\YV[lY.e*zY7#&5DPaz qF>Q+<R[J"a	SY	j2sM#k.P!|aD(vdSC1_>_2hYSNFDM]ovV(f+vErfUJHOXahlosyymV<%\._,yO.raO9]:w\E1tZA)
|X7v`K:*y\=}eM6|_B%	߰ߒsU6޷ޔmF!ݒY ܭq3۹ۃT'ڨڎv^F0	ٯِsU2ر؈]1ױ׉gF&ָ֧֗։|n`P:"
ճ՞Պ{uttrs{ՅՑ՜էղռ%/8AHNSX\`diou{րֆ֍ְַ֥֪֚֔֠	#-6=?CGMQUX[^`aa`^^^^]]]^`bdeedeed_ZUQKD;1'$0:EOZfs||wrokgb\WV\hvׂאס׶%5DLQTX^dlty؁؏أط4Ttٰٓ)9GVdnssqprwzz{ڈڑڙڡڪڵ'5>EMU\aba^]_abba_`dilmorv|ۄۋې۔ۜۨ۵
%.6=CFHHGEBAABABFMU\dny܄܎ܘܠܨܻܰ%0?Rdr}ݍݢݹ'A]uއޘެ0CVk߅ߥ9e
0Qp 9\0j;e6_J`N{ &/?Sm :{!y qO
.NhzFsC51;n-HmQ<06~D?l2hE;RU@   @
YQ Y3	k y!	n		
N


>;T

ltO5i>|L'q8p
<hQ)h'e$a6g6VwAt@w;[v  7 Y z    #!U!!!!!"?"["i"p"x"""""""""""""#$#B#[#n#}#########y#o#b#V#N#L#N#S#X#^#h#w#########$	$
$
$
$	$$$########	$$&$4$@$P$g$$$$$$$$%%	%%$$$$$$$$$${$r$s$$$$$$% %?%[%q%|%%%%%%%|%t%n%e%\%S%L%J%P%Z%d%m%y%%%%%%%&&-&9&9&2&+&&&"&&
& &%%%%&&&&&8&J&\&l&x&&&&&&&&&&&&&&&&&&&&&&&
''%'-'4':'>'='8'0'(' ''
'&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&v&n&e&]&X&Z&`&d&i&o&z&&&&&&&&&&&&&&&&&&&&&x&l&a&X&S&P&M&K&I&J&M&O&Q&Q&R&S&T&T&S&N&H&A&;&4&*&&&&%%%%%%%%%%%%%%%%%%%%%%x%c%O%<%(%%$$$$$$$$y$n$e$\$Q$E$9$,$$$$#####z#[#=# ##""""i"T"A"-""	""!!!!!!!!!!t!W!<!!!!     o ^ N @ 5 - #     }cF$wW6q`L3T'{T/x]B'r           
      RSRC [remap]

importer="wav"
type="AudioStreamWAV"
uid="uid://dvrun61v3a5v5"
path="res://.godot/imported/k.wav-887460c92390a4388443815145aee609.sample"
             RSRC                    AudioStreamWAV                                                              resource_local_to_scene    resource_name    data    format 
   loop_mode    loop_begin 	   loop_end 	   mix_rate    stereo    tags    script           local://AudioStreamWAV_xtqs6 8         AudioStreamWAV          ^                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 	  
            
 
         # % ' ' ) * * ) ' & $ # $ % & ' ) - 1 5 9 < > @ A C D C B @ > = < < ; : : ; > @ B D G J N Q T X \ ` d h l o r u x x x w w w u s p n l l n p q s x                                               

#)07=CINSY]`acegiklnqv|&/8AJU`kw,:FS`muwwy{zvqlgefijkq|!*0/,)&$$$##$*2:AJUbn{#2BRalv~ 
$*/22111123347>ELS]k{"5ELRX`c]SI@7.%	 '1?PbsxmcXMDCGMOU`q}~zvrnie`[WROKGC?=<:8778889;=@BDDDEED@:50)
yqjaTE4$~ukaVKA5'|vsmheefhhdZNE:+qd^ZUPKHFDB>7.' fM5gK0     w l c V M M R Y _ d d b _ ` \ M 6   mL0{vn_G-s\L>-
oS7tg\QF;0"raP>+{rh]PB4'mVA. {pdUC/
sfYOID@:/dI1{toi`Q@/ynhd`\XURPNH;)oXC-
zk]M?5.(!p_N=.znaUKHGECCIQY`gpzr`O>,	


}{ucSKJKJJNYgt|{}|m_TOMJEDN]m|xqkb\\binrvxz~~wj\OB6*
!)2:BKU`jt{!"#%''&$"#*3<CLYhw
!0?MZgt#7K\jw (07=AGO\ky

)C]v#2AQat-FYiz}yy;[x%;VuAg )Niyxjb_`[ZjLAsDp*dCv5Y}
         - @ Q ` x   *e3~?h
*=Xy
JC
J!S}	#	?	Z	v					
!
B
h



<vS#
C
^
|





0^%e.jBXgr|9Xv	*6DSbo~0@NZfq}(<IQXahjhda^]^`__cipw|}wqjdabdddhq{|m^OD=70(%(-37851/+"rR3 tbO;&|oaTE3oR6iP2d:h=


h
>

`4	^;



q
R
2

			|	T	(	vIi>a3q>zKh<T$X&   m A  b:[&G
\&R#d1d.^-pFzS-h@pEi;LJh/Q!i?l>R!e7
h@^8tHi8}P!wY?&bAqK'qYA'sL&rO2ߵߥߖ߆ubN9'
	,Jh߄ߡ#8==?B?2! 4Oh<Ws8fB~XI
i/ k]"CPYgu0\<i-k[ @_F*QTU&Yb
$40{wohwT[ 
  U+W			l

Kc
Y








r
a
Z
]
_
]
g



S_,Ki?\9  !!!b""#A###$b$$
%_%%%&I&|&&x&U&4&&%%%%y%%%,&&&P'(()Q*++,-./r0N1-2334T566x788-99D::;;;H<<<<=B=I===2=,==<<<[<)<;;;F;;;::::$;x;;<u<<v=>>??5@@RAAfBBmCCtDDxEEFFaGGG=H}HHHxHlH[H7HGGGJGGFiFFEwEEDeD
DCaC
CBfB*B	BAAAAA2BqBBC~CDDEEE}FF{GGKHHHYIII"J^JJJJJK2K3K
KJJnJ'JI=IHCHGJGFIFEOED}DDCRCCBB_B2B"B%B)B&B.BFBlBBBB
CFCCCC:DDD3EEE3FFF<GuGGGG HGGfG,GFvFEIED DCB*B|A@F@?S?>`>==_==<f<;;!;:B:9K98R8777S7 77)7Q7w77778F8r88x8`8M898	87H766
654W43/321[10"0/.E.--V,+*B*)(N(''q&%%$%$Q$##m#"#""f"-"!!!!v!^!K!?!:!7!3!(!!    A 9]2fEc:<?GY1dfzlYIOs1Orm?G
l

4e

G
		R	-`
F$@|O,                       } R + GB\Kl1{Q(_5aFATmZ8|
M{s^F,xnpv}Q2O#S|% x  Z7R]iz}h??  h 2  $ X   ]/d#dWz0?Icb\[W; B4nv@&2LdxH3oO)f	[			
T
u








v
`
G
.

					k	E		|dJ+5i	U		


+iKk

0
<
@
C
H
J
B
1


vD\

j
3
			d	7			H				
I
}








u
M
)


					}	Z	;		0l?oThL0\;z[>!   T $ t7m&TLw/c!c3o<i*l3 nF(e>Ko)]OZ'udT
@}Q%sE~N#dA"a5>s/e%j,Dߪ~Q#ޔd3݊Nܯ܀O ۬ۓ}jYH5گڈ^-ِ^-؞sN-׸נ׉pS/ְփT#չՊcA! ԤԋsZ=ӵӝӆnYG8(ҿҪғz_D&ѵѐi<бІ_;Ϻϱϡϒψςyl[B! ΜpG$ͫ͑zlgc^YWXYXTK9$̺̗x[>$˾˾˿˼˶˰˧˜ˋycI+ʩʅdD$ɶɠɎqcVLC9/&
ȲȡȎ{gT?*ǻǮǡǔǇyhT?+ ƹƢƏƁti`]`fmuzƅƍƖƛƛƘƑƉƀueP8#ŭŔ}hT?+	įęăkR7õíèåâßÞÞÞÞÜØÒËÄzn`RE6'	º§~gO5vZ?%
ufVG6$޿̿xhUC2#׾ɾlYG4	׽ĽgO<'Ѽw^A'	ѻǻt`OA3"ݺպϺǺȺѺں-@Wsһ3W޼	7jԽ3a޾#>XsԿ-YOCb}¦¼¼¹°¤¤H}dĳDņNƃƲ:gǓǼJȋ Eɪʎ^]a:ΕWϵ,eЯ Mє2җӨ:Y֊GٟqEݗO^uordDRV'r*Ul6i(qE*5-

<s~M !d#$r&'b)*+1-u./0123456789o:V;B<9=.>??@ABuC"DDEJFFGHHOIIJqKLLMNOPQR TNUVWX*ZW[\]^-__Y``;aSaWaia{aaaaabVbbcccJdddeieeseGe2eedd2dcpccbba``8`__F_^^^^s^>^]]N]\\
\y[ZNZYXXKWzVUT#T_SRQ`QP`PO~OONlNNMsMMLcLLKK}JIoIHHHG/GFF?FEEiE<EEDDDDDpDZDPDRDTDPDBD#DCCCC0CB4BARA@ @v?>6>=<#<r;:949e8766h544r32]21_10{0&0/}/)/.........|.|...............r..- -,9,+*_*),)('N'&&Y%$##a"! .] +E3zY2iX

$
HF 
t
b
n






=C4


c
%
		p	1	 		G		K

E
i#JnQD0{L  !h"-##$B%%e&&'A(()A*++,-.0B123!5p67W9:J<=
?T@AB1DPE`FnGHIJKLMNtOYP@Q,RSS}T+UUVW|WWUXXX!Y@YlYYYYYY|YsYhY]YRYGY>Y6Y/Y(YYYYXXXXXXjXQXEXIXQXPXVXoXXXY@YsYYYZBZfZtZ|ZZZZ{ZZZBZ'ZYY7YX|XXW?WVaV VUtU1UTTYTTSwS%SRYRQQ"QP$PO%ONNMMyLKKBKJJ>J
JIIIhI3IHHHOHGG'GF^FEsEDDDCECBB)BAAiA)A@@@~@\@8@@???c??>Z>==@=<y<<;Z;;::5:99B988E87u7761655t4323g210///.9-H,V+_*_)](\'\&\%\$]#a"c!] L7# *OY
a$
	J	smyD  zSt've>;>:l(7Ni%XMV'`J2|REAT	~5 ~sjcYF"	
yF

ic3[_, ;,=bjj  V!!"S#$$Y%%&8''s((U))!***$+j+++F,,,(-s--._...I///)0q0000/1X1e1S171*1100*0/z//..--,,+'+*N*))e))(((w(V(8(!((''''']':''&&&&&|&^&A&%&&%%]%'%$$A$##>#"g"!!! T '8EBjVF(sIx>o
+u

Z	#Z`a{0_  - Y<b@[SL=(%@i&Tr6R!U#b$V{ިCܠSܶw=ڑr^K3"%,169;=AA6$٦ًvot{|كٛٿ/Rsړڶ*;Obwۊۙۥۯ۽۴۟ۏ}a7	ڱڍs\=#;bڀڟreܸ`ݳRޞ6߁X"^7Wy&7G[u%Dc~q]<g0Z)sY@!
 )4DYpzk[L?3'
}cI,	߿ߛwO'ެo.ݲlljۻc
ڼl7׫e"֯v=ի~P% ԾԜzY9ӭv>҉2ч0h К2\͆ͯFv˨C{ɳK{ǬBnś1_']9ܿ"žgONpI뷈'նk8ҵ{R(l%ೖ?䲊1ձr>㯡i0|_B᭛V̬q
E䪌8⩉=˨Ǩ̨˨Ĩf7ߧ{GͦҦݦݦ *Xѧ+1(ͧ^E7+
IܧtѨ-ҩNЪڪҪY7$,>GQtɪ/P.vܮCeZ= Y\-3-гopY<ݳh@M}Գ
p|b˸*FXT>"C]ɹ1sػ6PýԽؽ̽Ͻ5oݾK-<N`p{%bD®zip{ǣ6]ɒ,[̨PΓEѽr*ӽԇM''9HQmܨ?_/EFXyhB	R;L4sL
 K4Nv	


us>\b;a

A

|2v3
}

	b	wfn3+m[ G Sz,T%$'$/]hZ 3[	
$
:O=7}G  !7""#g$2%%&'(3*m+,-/W0123m445,6667E7778599|:s;<3>?AB7DEGmIJ5L[MNOPQ(QZQQQyQ)QPPjPPPP.Q|QQ}RSST2T:TMTfTLTSRSR:RQPONMMJLKJIMIHH\HHGGsGOG(GFF]F	FE`EDDDC(CBBA@`@?>=<<;$:,9/8F76,65\5444t4\49433Z332P21d10v00//./..L//'00&1123r455667B7-7666Y65m54r4433>322z2?2211(10c00/#/.,.-4-,2,+$+*n*>**))))*A*s**+Y+++,,0,F,I,',++j+0+***d*3**)))Y) )(([(('
'z&%U%$#"! Cs#[D

N
8f
I
	&	QF2GXoi3ByZ<MD&	

o

r5D8Yu*}P%[H  !F""#:$$%5&&'N())*g+6,--.~/N0%123456!778Q9l:;<q=[>H?3@AABCNDEEdFGGXHHsI JJKKLLMzMM4NNN%O-O!OOONNCNMM3MLLaLLKKKKsKYK?K&KKJJJJJJJJJJJJJJJJJiJBJJIIIfI.IHHH|HZH6HHGGGGGGVG#GFFjFFEIEDD8DCC-CBBBBvBcB\BXBUBKB/BBAA|A<A@@C@??;?>{>>==M=
=<<u<W<9<<;;;z;P;;:x:(:99(98j887o7*766_6(6555X5 544x4:433h3"32}2 21g1
10b00/f//.x.*.-b-,r,+x+*"*o)((>'j&%$##"4!L [\PC7/*)% 'H~%ke

I
 
j	PY"J  V 
 f6U4}Br^J{(|9
qQ4T(2f]
d|O [0"/xS!  pW0	[

Nw
4
e


VyFt<0i=t JC]a:_p\PF7*1T	EAbyx\?$}e4z3i&QuW,Ty
4Uhnqvzzwqkfcb`^ZUNE<3,)'("e.\ZM Ww@
 
K{
<
	j	raQ(o6    x m p t v v s o q t k O '   Eb;yfQ8QwP)xT%pXE/R( iYM?2/5?KV_eksywm_SD(W6)"#q9GXq*ra%~?S*o)U7x3J)
%Aq={&HL2m2LP#fJ0 e>]#wU3"'9JXnK|MpGe 5,z ^ߠGަ[݄Dݼw4۫_ځ9٤`!ثtF$ׯז~fL-	ֽ֘nA՝ՀfL5*,6>EMU\bd\H,Ԙ^'Ӻ}Aҙc-їe4Ш{P( ϭςX/κΒkF%ͥ͋t^H3̵̹̲̬̣̙̐̅u_G.˫˅^6ʾʕk@ɜpA	Ȃ:ǘ4f ƕ(ž[äS
V)_-8꿚JVl,񼴼wDڻwj\M<+	ݺºs[D.߹Ϲw^E(ԸU&÷h?жwbP?0"	.Or3Ϸo¸zֹ%eߺWһLy\!`Tտ;p),+6Oo
@u¸8M\oÆá 8gĚBqśŽ6GNRb}ƛƸ#RǍIȁȻ7MYUE+ȸȋ^2ǧǔǈǊǜǼ"CfȅțȡșȆmLǥa Ƣ` ŭŧŤşśť!+5;9#žŊZ'īuOCOgāĝ6ŪƁƤc"ɛjE*ϞkI+ԬՁijٔڢe
h|`PA!m 3M_	
wf?#  {";$%'J)*+,!.9/!00a112C3445Z6S789+;]<='?@0BCDF4GdHIJ=KK{L@MMWNNOrOOrPPqQQkR0STTU/VV)WWW-XXWWjW$WVVxUTnTS9SRQ3QP:POONNMUMLuLKtKJJJ_IHGGKFEDCCSBA@S@?>=>=<R<;;::98q87Y76L655^433_21!10/S/.i.--4-,,v,8,
,+++++++++++x+V+;++*|*4*))))n)L)0) )))(((5(''$'&%%s$##c"! f T=y&\]}7	l6MZX67
*
=a
i
	P	9 z"LOr;         2m0N]WI>7- +Zfz*~J	

$;M

IYBoK$s,Y "!!J""#;$$%@&''(])!**+j,+--.d/ 001T2334J5667C889X:;;]<<=>>>q??{@ AAAeBB2CCCODDDUEEEEFAFTFEF*FFEEEESE%EDDD~DUD+D DCCCUC%CBBBaB7BBAAA~AeALA2AAA@@@@@V@+@@??1?>>->=v==<b<<;;J;;:|:8:99i9"988M8
877J7766Y66555Q5#5444L4433a3"322g2$211W110}040//O/..`..-c-
-,g,,++5+**b**))H)((c(('a''&T&%%5%$t$$#?#"m"!!!  =a'_|~}@R d!]Q
Y
		[vS$_ + gM4Z6M\+_-WLzAzl]QIC=72.+'$(6HXh)`Oa>l9c5tZ  C1'sL	l		
n

!{0	
}

bZ[WL6e'{E
/Uv6Vw#P}<ay}n_P?0*3EVewER3\s5yY0mH!$Mz7]|wqfGc!4Or+i)+|

"9
U
		A	
	dUSOHB><<;-KOI-K	Jc  6 )dSRzvvsjS0
)x[-b#s_I0
U,
=k#Q|#1>@1 h2 n=
6X}+@OTQJD=852-+0:FTbp}iQ:%)9FQ[dkmhb[RF7(  (8IZeijkkdUC0uhZPLLKF@;73-#t`J2w[=~Lu8~:j(m1}U1jE {L`1W.d:a1 g2k<wT2`@d?xhXG8,# ߹ߧߔ߂seT@-
ޯޜފxbK4ݭݚ݇vfVG:."ܹܫܜ܍~n^M<+۬ۓxZ;ڽڞ~^>ٿ١مjN2ؿتؘ؇wfVF6'׳ן׊u_K8&֯֞֌zhWG6"շ՟ՆmT;$ԷԥԔԄwk`WNF>6.$ӬӔz_D+ҲҞ҈r\E/ѲјcB ЮАrXA, ϹϬϣϜϕϋτ}|zxtpmjf]RH?5*ιήΧΠΖ΋΂{vw{΁ΆΓΦη
"4@FNZeiiikpyφϔϝϪAfДFтѳ2aҋҏҘҡҤҞғ҄ws{҆Ҋҏң3hӟjԵ'RՅոժՍg@&$.6=SՇY֟0~
*3;EG.ר׀i\N>9[ו\خo5}ڵ&Wie[UN@. 
/Rۅۿ2gܖ.9<>>:1$	"1Fe݌ݶ@qޡ4dߐ߹&B^{K~B12="a3d&S)nW{Ou0d72?e@Z+m $-g`Z	

N
^3
V&[*G !!w"&##$-%%q&''D((>))3**$++ ,h,,----.W...-/s//0Z001s11	2V222O333I444G555*6k6666$7<7J7V7d7n7i7]7S7O7K7F7@787/7&77776666q6J6655V554q443Z332m2/2111K1100}0E00//P//.y.2.--Q--,|,N,&,++++|+g+Q+8++ +***v*B**))q)9))((n(H($( ('''q'Q',''&&&Y&.&&%%%l%Q%5%%$$$$$$y$[$<$$####T#)##"""x"b"R"B"/""""!!!!!!n!P!'!   h B #   
  	 xeYSOG@:62-' wk_SG;."
   &8I^|!;Vr 0 Y    !?!z!!!*"i"""'#S#u#####$%$=$U$q$$$$$%9%f%%%%'&`&&&&'1'P'm'}'''''''''''$([((((=)))*A*b*z*****************+*+N+v+++++,#,8,D,D,=,9,5,*,,+++++++u+f+[+S+J+A+7++++++******p*B**)))E))((\(,('''p'J'%'&&&&~&`&A&&%%%y%K%%$$$K$$##o#<##""x"P".""!!!!m!O!/!!    ^ 6 
 kDtU3uA	e*u?hK2vZ<~gQ;%zocT=!c?~X7*B`'@Tco}7Xy-Lk1Li=g 0#W~  !!	"H"k"""""""g"M"@";"1"&")"P"""#@#t###$<$"$##k#%#""\!  Z3wXa&%#-&bW$RpNKr+HW<U
M
		Km%X&v1[Q > w8$PmBl,t;Z%_>"/<KZix!$&-0|H}:I*:ABGKG8#!Dkq6VzhYUWZ[\YTOIC8, sY@'i][\WU_t4;0\.}Q}IvK%Z/VUf<rY?$c:oFnL&Vn-P߇LޡuM$ݺݞ݁eI-ܼܝ}[;۶ۥۖۇxhWF4"ڿڬڝڐځrjks{ڂڈڎڕڞڧګڦڛڒډp]I6$	
ٲ٥ُٚكxrqqrqmiggd_WOIC9-ضئؖ؈yjYF1	
׾ץ׊oT:!֮֠֓ֆxk_TH;*ճ՝ՈtdWJ=1,*)'',3:@HTcq~Ս՜իջ%.8BKU^gq~֎ֽ֭֞	$?Zxט׹ :Rdpy؃؎ؚؤثذط,Khل١ٿ5Mfڀڙڲ 7Uuە۴#Inܕܽ@iݐݸ5Uqލު$/7?IT]djq{߅ߑߛߤ߬ߵ#1=EJPW^djorx
)Kp3J`ouy|~}|{yx
4\$:FNV^ejnry )]B~2e3GYoF{)a
Eu8Qez&:Ocu +Jw4g&?Ul#P#[8a,>Uo#X @9g3HZn+eiN	E{5Sq e65   T*Kl
*QV2{K,Lm0           
      RSRC         [remap]

importer="wav"
type="AudioStreamWAV"
uid="uid://bk6087xl2igko"
path="res://.godot/imported/l.wav-78df80a0344fa4aa6c9e36c0a0d708e9.sample"
             RSRC                    AudioStreamWAV                                                              resource_local_to_scene    resource_name    data    format 
   loop_mode    loop_begin 	   loop_end 	   mix_rate    stereo    tags    script           local://AudioStreamWAV_ihplk 8         AudioStreamWAV          U                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        	 	 
 
 
       
 
 
                           ! " # % & ' ( * + , - . 0 1 1 2 3 3 4 5 5 5 4 3 3 3 3 3 2 2 3 3 3 3 3 3 3 3 3 3 3 2 2 2 1 0 / - , + * ) ( ' & % % $ $ $ $ % & & ' ( ( ) ) * * * * * ) ( ' % $ # # # " " ! " " # # $ % & ' ' ( ) + , - . / / 0 1 2 2 2 3 3 3 3 4 4 4 4 5 5 5 6 6 7 9 : ; < > @ B D F G H I J L M M N O P R S T U V X Z [ ] _ a c d f h j l n p r s u v x y z { | } ~                                             "&+/48=AFKPU[`ejoty~  %*.26:>CINSY_flry&/8AJT]gq{%/9DOZfq| ,7ALXcmx
#.:EP[ep| .=KYft&6EUdt
		+	:	I	X	h	y										

(
8
H
X
h
x







!1BRap /?O_p

!
/
=
L
Z
i
w








$5FXiz!/>MZeq}(8FUet&2>KWdp~)18?GOW^emu}!*4?IRZclu|",6=CIOU[afjotz|vrnkhfeeeefhjkkkjiiiiijjjijjkigeca_\XSNIB;3,& }o`QB2$ziYI9)	wi[NA4&
{jYH7%s^J7%oYB+





g
N
5


sW:xU3



]
8

				\	6		{U/	qJ"lF a<lI)
~[8{Q'xI   V $ \(]*n>PY(],Y%PzC]"n0s3m+aa#o6Lh0Pi0F
]#k*l)_I:l(]^!q8b3߷ߗtQ.ޤށ]9ݗlF ܨ܁X-ۦzLھڐ`/ٗa)ػ؅NתyJ֛tM'շՐiBԢxM ӓf7ҤvHѷъ`8УЂaA!ϼϚzX3ΦΈkN2͸͕͍͇ͫ͂͟}wrle^VPH?4* ̧̽̏v_G-˫ˑxdQ;"	ʬʒvZ?%ɫɗɅteTE8.#
ȽȺȶȳȮȧȠȚȔȎȅ|vpkcZQH>3'
	ǺǲǪǡǘǐǍǋǈǃ~|yvqke_WNE=60,'"!$%(-4<EP^pǃǙǲ4PlȆȞȴ -;L`tɆəɱ<[zʖʱ8Qg|ˑ˥˼$=Vm̘̯̂)Da|͗ͱ -BZrΈΙΨζ
'9K]m~ϔϭ&@ZtЏЫ:WtёѰ0Rsҕһ)KnӑӴ,E]tԋԟԱ/ASan}Ռ՛թշ*7ETduքֻ֥֔6L`sׇך׬׺&3=HYl~ؑئ9]ق٦0Qoڌک&Giی۲+U܁ܮ2]݇ݭ7Slރޚޭ޻
!(+-1<FOV\cinrv{߀߄߈ߎߗߢߪ߲߻
'1:FQY\alz	 "%(,/111234420.,)"
wY8߸ߗy_D%ްޑpN.
ݥ݆fC ܪ܍rZC+ۼۨەۆwhZL@4'ڮڐpN+ٺٕoH$ة؊kL,׿הi=֦r<ՌPԥn9Ӡn=
үҁT%іf5ЏTϢg+ίs9Ϳ́G̦m6˔[$ʺʄNɪu?	Țf2Ǘd4Ʋƈ]4żŕnI$ķĎf>ûËZ(¹Ee-U"{A̾O̽HϼV໧o:̺Z$Q鸹]. ׷b9ζ_=ҵlM0ѴkV?(ݳγǳóĳγڳ ",5>IWi|̴1Kd|ɵڵ ,5<BGMQUY\]_bfjlotzɶٶ,<JYgvԷ7Qk̸	2G\pƹܹ)<NZbiqz˺׺޺ܺٺպѺкҺպ׺׺Ժ̺ĺysooppomnnonlifcaacegktպ*Gczϻ)ElżP½/cǾ+]$X&V7[£
.NpÔú*NpĒĵ2OmōŰ=hƔƾI{Ǭ;iȗDlɖ/cʘPˏE̺+_͒.fΞEπϼ1oЯ2sѷKҕ,~&y.ՎMְ׆\6٦ڄ[+ܓb2ޘlG X%:INA%d7e7l	FW+rCPH0j3w	[Wq1g:j2L`(ZQK  Un$ 	u		^

@c

.Wkl`I.z^E0,= a0lJ+
  !!"",##E$$`%%{&''(())
***s++[,,<-- ..// 0{00y11w22q33j44]55=66777N889v993:::K;;<d<< ===L>>?u??:@@@UAA BVBBB9CCC
DLDDD	EIEEEFXFFF/GzGGH^HHIQIIIPJJ KWKKL_LLMfMMNqNN OvOOPsPPQoQQRfRRSNSSS(TlTTT0UiUUUV>VeVVVVV
WW/WBWQWYW_WeWlWoWoWlWjWhWeWcWaW^W\WZW[W]W_WaWbWfWjWmWqWsWuWvWwWwWwWuWrWoWlWhWcW]WWWQWKWGWEWCW@W=W:W6W3W0W+W&WWWW
WVVVVVVVVVvVeVTVCV1V VV VUUUUUUU{UiUWUCU1UU
UTTTTTT|TgTPT6TTSSSSuSJS!SRRR^R)RQQ|Q<QPPzP2POOYOONN9NMMfM#MLLZLLKKPKKJJHJJIIEIIHHJH
HGGVGGFFvF?F	FEElE7EEDDdD-DCCtC7CBBcBBAA/A@@1@??6?>>=>==S==<n<$<;;G;::\::9n998s8 87{7(766/655254444335322:211@100=0//1/.w..-^-,,@,++&+*l**)Z) )(P(''N'&&Z&&%o%$%$$M$$#|#9#""s"3"!!v!8!  z < u2fMy2Vv(;L`r#>]<n,j+t6{@Q

i
/
Mt>


o
;
	
		v	F		rL(pV>%
|obWOGA;5/*% |wuuwz~&8Kb{9`	7d	N	}			
2
`



Es6h 
3
h



C|/jW@z&`J <z3nV/d/aQO$\	E<{7w5u=   !\!!!<"""#i###G$$$%Z%%%&Y&&&'L''''/(d((( )4)f)))),*^****#+R++++,>,j,,,,-L-z---.3.b....!/P////060c00001>1h1111
252\222223<3^333334-4P4t44445-5T5z55556>6f6666	727\77777"8I8o88889$9E9e999999
:$:7:J:^:q::::::::::::::::::::::::::::::::::::::::::::::::::::::{:t:k:`:S:F:9:*:::999999k9R989998888r8T85887777h7E7!76666s6P6-6
6555}5Y5555444~4X4344333^313222Z2"211n11100w090//{/:/..v.3.--g-#-,,X,,++M++**J*
*))M))((U((''b'&'&&r&7&%%%E%%$$F$$#z#6#""\""!z!+!  9 =;5.){$w of`	Y MB6&pT4
o

Cs
9
	a	?c IzI" ^ A'qa	[XXUQRPJC:1+,9Mn#O
BTyB
]$u: Md-SLwBp9ߕa/ޚk@ݜyX6ܴܔuT2ۤ~V.ڶڌb8٢}X3
؝xR-׽חqK%֭օ_<սեՑ~iVE7(
ԹԩԚԊzk^RF;/&
ӿӶӭӤӚӑӈ~ulbYRMHC>=?BDFLT]fnxӃӏӛӦӰӸӿ!0?N_pԁԒԣԳ%5DQ]iuՁՍ՚զղ)AYq։֤4Ttה״Ae؈ث;aه٭#Luڜ
2Wyۚۺ>`܁ܣ/Rwݜ3X|ޠ7^߄ߪAh/Y5eIt"NyEk>`
,No*Ig-Oq>_2Nk$=Uk-:GUboy	#2@N[fq|
 ugXJ<-p\E/gN5mQ5^:uL$a<iF"jD[5wT3jG$W-Z5gF%߽ߚwR,޷ޏf<ݾݔkBܡzS,۽ۙtN(ڶڌ`4٭~O ؾ؉T׸׆U#ֿ֋W#չՁIԠg.ӽӂEҎOюN
ЌLόM
΍I:̪bˉ@ʮdɄ:ȝKǩXǴaƿs)ĕIë]üf²YH쿐6ݾ0ؽ0߼<컛K[
føq̷z(ض;NZ	iʲ{-౔Gi!گF^ĭv(ڬE{8CȩF¨>v6¦OᥬxCܤvDݣt@٢uBݡxE㠴T( ۟oQ4ߞŞx_D*ܝjQ=/ ֜Ȝuj`]^_achow~̜ڜ 
,:GTbrɝޝ0Jj7`ߟ	.Or >i̡:o,o6~Ƥ
V>ݦ25O|lag'>˱V߲fq	.O߹s@ܼ{V'CT?ĭŉb;ǭ&ȣ"ɠ!ʧ1˾Kk Ε(ϵ<н=ѽ8ҬӄaPEOz٧FڞJܜIީXTLIdQq=eD# |M%Z; ~	

{pbRB-{R+
 !"#$n%Q&;'$())*F+,,z-*../P0112[3"44567z8W97:;	<<=>b?1@@A~B9CCDlE)FFGXH#IIJKuLKM$NOOPQYRSSTbUVVvW$XXeYYZ#[[Q\\l]]x^^}_```iaa;bbccccdeddd;exeeeCfffgEggghShhhiBi|iii&j_jjjk4kekkk
lJlllmNmmm@nnn'ouoopRpppqCq{qqqrPrrrrsOssst:txttuYuuu;vvv wjwww4xjxxxxy*yEy_ywyyyyyyzz5zTzwzzzz{2{b{{{{||<|W|e|f|a|\|W|L|<|(||{{{{{{{{{{{{||!|.|4|0|$|||{{{{c{:{{!{C{k{{{+||*}}=~~~}~y~i~#~}&}||{m{<{{zzzzzzzzzzzzzqz?z
zyy*yxvxxwowwvcvvuuEuutt~t\t:ttsssXs
srOrqqCqppmp#pooRoonnGnmmmgmAm m	mlllllllyljlWlAl)llkkkkkfkRkFk:k(kkkkkkk
k
kkk!k"kkkkkkjjjjjwjOjjiii`i(ihhhdhAhhgggggeg9g
gfffdf0feeeQeeddRddccQccbbHbbata$a``6`_z__^f^]])]\Z\[[
[Z'ZYGYXeXWzWVVVUUTSuSRSRQQhPOO_NML:LKJ3JIHBHGGzFEFEDD]CBBKA@??9>e=<;:	:89l8766h544g322}1040/.@.-,9,+*	*P)(''`&%$Y$#*#" "!!  3Z~
#zus=r_E*Ki


0X

4
	{	%	{'4:~!eKDM  _  m%Ibw"y&vpU7+y$z%wrdTT^|1g#h,u:H^&U,
jR8!El$h0Hz`>	s6]LF2`V8dN"M}WG5 
 ez		5


,A

d)j8!r"j\:"`@Ldix;$IaOX >y7.B\wmT!\8M



|
f
K
(

CJ
j
	P	@GGh;
g?Yft,            x a 7 QjDW5
&"k;^&s[OG<1($"!_h"CU65@KR[eqdG.WxD
7h4IdxwhWI;*Hw<SVE-	?tR*To$:^:y*Kdwk`SE?Pi .ZY4s>
s\H6"qC}6cHA:kx'~$pN{BpNK]t[6c)U=gޑ&޻Sܑ1q۴Vٚ4eח+׾Qx՟2[ҢIіFгiiϳUz͕%̷Jmʪ\v7Ǜf,Ưt6Ŗ=Ĕ6iÞ<iԿ?^˽wR𻈻-J޸u9ⶏ:浓Ebb
Y+ǰb1ˮinȬz-⫖H򪙪@詐<訔?^ѦQ㥭t7|:꣑5ݢ)Ρqj$Tߞr<ҝl8 ƜQٛVԚOșC?ח}O$֖]'H=CВfA%		 ݑɑp[F0
ѐҐ
)Ggґ M|֒3`;a6nB?IPәWĚJGМ#|ԝ+ڞ3A͠YޡYآ%uãcĤ+[Ȧ8R#DcaS$g0p;˱iŲ&Lwڵ5ض(v?wWW<»FȼA,(*zM~:n2rø9oī;|ŲE}ƺ=kǠ,YȋFɈ)ʉWJ6ͳ==Ϯ'Ю7Ѷ1ұGӔ?՘Pرs3۴{T0߾|ykN;Lt`ebO0 x]	

orh
y !"#$%&'i('))*y+=,,-x.f/W0<1223456J778Z9::c;<<S==>>??f@@A)BB8CCVDDEFF3GGYHH{IIBJJKzKKLSLLL"McMMMM"NBN^N{NNzNXN8N N NMMDM
MLLjL0LKKKRKKJzJFJJIIhI5IIHH}H<HGGxG?GFF|FDFFEEEEiEYEVELE4EEEDDDDDD\DID6DDCCCCCCrCWC>C4C7C7C%CCC$C:CGCQC`C|CCCC$DJDyDDD7EhEEE
F>FgFFFFFGDGjGGGG7HyHHH?III5JJJKRKKK1LjLLLM]MMMMNHNwNNNN$OYOOOPLPPPQSQQQQQ%R@RNRPRRRTR]RfRcRVRNRWRlRRRRRRRRS*S<SSStSSSSSSS	T
TTSSSSSSSSySlSaSVSFS5S&SSSSRRRwRTR,RQQQSQ'QPPzP@PPOOOMOONNNNhNIN0NNNMMMMMMMMM|MMMMMMMMMMMM	N&NDNaN~NNNN OLOyOOOPFPzPPP%Q`QQQ	R>RoRRRRS%S8SLSeS~SSSSSSTITpTTTTU1UPUnUUUUUV0VMVmVVVVV WLWxWWWWXGXrXXXXY$Y?YVYmYYYYYYYYYYYYYYYYYYYYcY?YYXXXXpXIX$XXWWWfW=WWVVzV<VUU}U.UTkT
TSASRFRQPQP_POgONNNM;ML^LKKKJ,JI.IH0HG&GFFEEDDCCB
BA!A@/@?B?>U>=Y=<Q<;L;:5:9988776!65B54l4	43;32i221>10u00/`//._.
.--9-,,m,-,++v+4+**o*+*))N))(j((''<'&&{&=&&%%d%/%$$$a$)$##m#,#""`""!!P!! u . U}8f"ZEq+^Ej{'34=4(Po

%?
Z
		%	X9~` C#kg q $ Ck%Il%Rj4gE,|uqokhk{ )T&<QdvExrwjy (<II#`F"		>

&l
_PY8q@9}W5"0@RZI,d+pU8

t:R `g!

t
;

zMyD
e

	y	:	q@&{R/p6~=x@lF$}^@" zdR=(        n a V L B 8 / (      xcH*nK*\)\!}Y:|mZC)~hTA.vR/f:pL6$vdTG=1%
 ui\O@1"	qO*OQ!wX:sX; dC" pL(n@Fd/_2W.[1[/Q`#j-q,^@߹|@ޏ^/ݜi5ܚ_#ۯs6ڻE٤n8ؙc,׷~Dւ?սAԌ]0ӨX2ү{IѝUЁ7ϟT
x/͟Z̍I˂@ʽ|<ɼy5Ȯk&ǜWƄ<ŭb}0Î;FP`ÿu)ݾGi!ؼIw1캧bعTѸPѷR϶Jĵ|4촥`ٳRزe+ͱV3԰}`B!̯wM"ˮwW; ˭kO1ڬyY: 	٫ë~ume[M;(ڪªo^L;/' 
"1DXk}ƪ-?OWUNJFB?=848GZk|ϫ,AUkƬά۬
(A\yح
-?RdwЮ%Lv߯M
<i6gӲ>z=~<}Cp"Ep۷
B׸-~й'?B3|7v*c*x\jgôSę3gŝTƏ${%{5ɔKʔf˨%Nz̰$\͙6Ί+uϼMБLvѕѮ>e҉Ұ]ә
>qԧ1Pkwwtvwupj`\gՁՠշ'\֐9b׊ש(<Nb{؛ؿ )_ٙ?zڷ.gۚ2a܇ܩ=hݏݵ"gު*s߿
R#g&^ /[&(>gVEEj,wK"y_G3# Xp$		d
E
)nnZ/N`kUB-*B  ^!!u""#$$
%%%v&&b''(m(()p))*^***M+++9,y,,,--g----.:.J.O.T._.g.f.^.U.M.I.Q.`.o.y........ /
//'/,/+/*/./0/*////............./3/O/a/g/j/s/y/p/V/5//....._.H.<.4.&....--------------{-h-V-D-6-.-(----)-F-`-x-----..-.7.@.H.M.K.E.>.6.0./.0.2.4.7.<.B.K.U.`.i.s.}..........//#/1/=/H/T/_/h/p/v/{//////////000$0-080A0E0E0F0L0Q0Q0L0F0C0A0B0E0I0N0R0U0W0X0\0_0_0Z0S0N0I0B080*000////~/]/=//.....m.X.E.4.'.....	....--------------------....&.+./.2.6.7.2.)... .--------------------------y-e-L-4-$----,,,,,,,,,,,,,,,,,,,,,,,,,-
--&-.-6->-I-R-V-Y-[-Z-W-R-K-B-5-&---,,,,,,t,_,L,:,&,,+++++}+c+K+2+++*****x*d*P*9*#**))))))v)\)@) )((((^(3((''x'L''&&&p&I& &%%%%p%L%*%
%$$$z$X$5$$###h#@##"""o"K"(""!!!l!J!)!!   s P ,  hJ-tfXKB;3'w_D's[E0 znd^\ZYZ_fjkkorqmhda[QIGIMPTWZajqk^PH=*p[LC<3+# pJ#f@!rW9wX: 	u`I-
l@iCkUA1 iS?-	|qfZOC8.%

&-16:@GNV]cjqxytl]J7'}o`N<*|m_SI?2#           
      RSRC         [remap]

importer="wav"
type="AudioStreamWAV"
uid="uid://dc1tc2078sh7x"
path="res://.godot/imported/m.wav-5c837620579371cb2d341173656993b8.sample"
             RSRC                    AudioStreamWAV                                                              resource_local_to_scene    resource_name    data    format 
   loop_mode    loop_begin 	   loop_end 	   mix_rate    stereo    tags    script           local://AudioStreamWAV_6qxhu 8         AudioStreamWAV          b                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                ~}|{yxwvutrqponmlkjihhgfedcb`_^][ZYXVUTSRPONMLKIHGFEDCBA@>=<;:98654310/-,*)'&$#! 
	 
 #%(+-0368;>ADGJMPSVY\_bfiloqtvx{}       # ( , 1 6 ; A G L R X ] c i o u |                    	$+19AIR[cmw#,5>GQZcmv+8ER_lw+8ESbr#3CR`o}  1BTfx(9J[l}$8K^q	!	1	B	T	f	y								
&
9
L
`
s






,@Th}0EZo	

4
I
\
p







)@Xp&8K\n ';Odx&<Rg}+:J[l}+?Ti} $7K_t+8ER_n';L]n&/9CMWal{%0<HRY]bgkmopqsw|  whZK=0&n[F/~hR;${jYE0gH'jK-a>iD`8h<[. 


X
/

`5	U$


]
*
			^	,	d3rA|La1q=
q?
zJf;   S # V"Js?sC}KQ S Kq:_)SN}Ec)zCuAwDp:d/`-f5tDW(k:p<i5f5sCT&i5h6rB߱߂U(ޣxN#ݦ}U,ܫT(ۣwL"ڣzT.ٽٚxU3ج؋iH&םzV3֪։gF%աՀ_>ԥԇjM1ӥӊoS7ҬҐuZ@)ѱљсiO4вЙЀgO7 ϺϨϗφudTC3%κΪΙ·udR?,Ͳͤ͘͏͇wpkgc^YRJC;2& ̴̬̣̾̒̌̈̃̚~zwvtrqppqpqqstuvusqpmjgc_[YWVTSQPOMLMOQRTW[^bejouz̖̝̥̬̲̹̀̆̎'5DRap͎ͬ͝ͻ 
$-5>FOW_gox΃ΏΚΦγ
0DWjzϊϚϪϺ	):JYgtЁЎКХЯй3NiуўѺ1KczғҪҾ'6FVgxӊӜӮ+C[rԊԤ3MgՁ՚ձ/@Qdw֋ֲ֟"9Qiׂךײ4Rp؏ح$B^wَ٦پ%:Rkڄڜڷ7Wyۛ۽#Fh܋ܭ/Nm݊ݧ1Kfނޠ޽=b߆ߪ&OxIu&V#Y<sH}Q9s5v;~D >z VKy&R
9mAuDn%@[u'LsFv<p
=o3bJw/['[A}*c8fAi	0W} 0 O n     
*Jk!Fm%Hk2Tv<\}*S1d.c	6	i			
5
i


:oH)
`


9n9mD{"Y$V *S{Em6] *S;k 2d 4h:n7i.^K}TT% o   !D!!!	"I""""#P####
$:$k$$$%9%o%%%&O&&&&3'm'''(S((((4)m)))*6*e****
+0+V+|++++,;,e,,,,-?-o---.4.h.../?/x///#0[0001:1l1111+2T2{22223>3d33334G4x444)5j555.6t66 7E7778O8889C9999 :Q::::;9;e;;;;&<X<<<=@=~===>>>>?G????9@t@@@AUAAAA.BdBBBB*C\CCCCDPDDDD(E_EEEFTFFFGKGGGH9HnHHHI:IgIIIIJCJmJJJJK<KeKKKKL6LaLLLLM?MnMMM N2NgNNNOAOvOOOPHPwPPPP)QOQsQQQQQR1RLRgR~RRRRRRRS,SCS\SxSSSSSTT=TXTnTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTT~TpTaTUTJT?T5T*T#TTTTTTTTT"T$T'T*T-T0T1T/T+T'T$TTTTSSSSSvSXS9SSRRRRjRKR-RRQQQQQQnQ\QKQ9Q'QQPPPPPrPNP,PPOO{OJOONN~NINNMMMXM+MMLLLvLVL:LLLKKKKvKYK7KKJJJnJ>JJIIwIAI
IHHgH3HGGGfG:GGFFFsFRF1FFEEEEtERE+EEDDDRDDCC|CDCCBB_B&BAAxA>AA@@[@"@??}?F??>>|>K>>===g=8==<<g<1<;;;C;;::K:
:99Q9988U8877W7766m646555Y5"544x4@4433>322k221u1#10z0$0/y/$/.}.*.--3-,,B,++Q+ +*`**)y)+)((@(''P'&&F&%%6%$z$$#a##"G"!!3! } " jW?)s_F%`2d:w\ H;34

=
L_
p

	v	"	umaUMQ`>  u 8 EY\T^%_6nG}S&i9wHd8]2`6{JLM`1~R&uJ!}T+f@tW>'p[F1_=qO,xQ*iCkG!]2Z.{LmAߦ߁]= ްޘހgO7 	ݩݎtZA(ܳܞ܉tbSD5&

	 ):JYgu܄ܑܜܧܱܼ	",5@KXdp~ݍݞݯ!.8BMW]aejmopppqqqrrrsuwx{ހވޑޚޢޫ޴޽
$/:EMQTX\^\ZXVTPKGC?:62-++,-.16=CJOQRTVSH9+
޷ޠވnU<#	ݽݥݎzeP<+ܮܚ܅nU<$۱ۓuV6ڹڛ}_A#٭ْx_E,ظآ؋t^G/ת׍oQ4֮֌iF!շ՗vV6ԼԝԁeK1ӧӋmM,ҤҀ\8ѤZ7ЭАtW: ϳϟϋwdO6ήΎmM,	͜xU2̩̈gF&˱˔wZ>!ʦʆfDɯɉb;ȟwP)ǼǘtP,ƾƙsM'ŷŒnI%Ğ{V1ß{X4zT,d=cA ǿiD!׾R%ƽ_,ȼd2Ի|O#ͺxN"ɹpC긾c3ԷsAܶyG嵴U&ȴe2 ͳc-Z'c6	ܰW+ѯqA⮱Q!ŭl@ìqJ% ܫpO-˪rT5ک`B#̨zbJ2ѧs\D- ӦqcVJ>0 
ե¥ubO=+	٤ɤŤ̤֤
$1?Oarҥ1MiĦ%Ca§-R{٨
:mݩRǪ@}:|G׭"mVJM ]xܳDyP,	y^ҹE+ u`վK2`7å|S.ƞ~cO6ʪ ˗|[;Ϊτ\;Ѩ҃mYS`s ؒ'پTܳLsߙ+DTn I12Tk#.,x_H,nN/k <l0^+`		
7r

L&Y Cc5i8{#rj !!j"##Q$$%3&&d''(1))]**+",,O--.//U0014223)44v566t788`9::J;;<==P>>y?
@@-AARBBxCDD2EEUFFyGHH.IITJJKLLCMMuNOO8PP`QQRSS&TT<UUQVVWWWgXXzYZZ[[(\\?]]I^^X__\``WaaQbbGcc7dd(eefffmggMhh)iiigjj4kkkXllm~mm>nnofoo)pppAqqrbrrsssMttuquu-vvv,wvww	xNxxxx3ynyyy	z8zkzzz {/{]{{{{|J|s||||}+}H}d}}}}}}}}}~	~
~~~ ~&~,~2~8~?~D~J~O~T~Y~^~c~g~k~l~l~k~k~l~k~h~c~^~Z~V~S~P~M~I~F~F~G~H~F~C~>~9~4~/~'~~
~~}}}}}}}}}w}g}Z}P}H}?}2}&}}}}}||||||v|W|9||{{{{X{-{zzzjz9zzyyry@yyxxxOxxwww[w)wvvv\v%vuuuJuuttdt+tssvs:srr|r9rqqvq6qpp{p@ppooZo"onnnJnnmmum>mmllZl!lkkSk
kjj7jiiRi	ih|h4hggcg#gffYffeeYeeddKd	dcxc+cbbDbaaLa``S`__P_^^T^^]X]]\X\\[V[ZZTZYYTYXXYXXWcWWVnV VUU1UTT@TSSLSRRIRQQ5QPpPPOSONN9NMM,MLzLLK]KJJ6JIgI IH-HGPGFsFFEED*DC;CBIBAYA@j@?z??>>=$=<2<;?;:K:9K98M87O76P65R54W43[32]21_10`0/Y/.S.-G-,3,+"+**)(s('h'&]&%W%$W$#W#"T"!O! O SW\bhkp{
/BVl	7R
q

.V


	;	Sm!<Z|G } ! pb	VI=.{fUBKcTD x3f"YEp!5<Ip*OvMUW:Z7~AgC#߯ߏnO/ޔYݧj+ܵ܊c;۹۠ۇnS8ڪڋlO6 	ٸ٬١ٍْٙه~qaRC2ص؛؂gL5& (7Lbx؋ؗ؝أجدإ؎s[B'
׮כד׎׆׀׉דםצױ׾)8HYjz؋؛جؽ&1=Ojى٦:fڑڽIxۦ.[܋4lݤOވ޼0Uzߛ߹Ap/e8e4Tu$Hl":Qi+>Ri:_?j"8K_s=b'U});L_p|)5CXp+<IVer~~l]OA2&"&+/4<JXgsywttqfQ:&wV5fL7*tZ>#t\D-zqh_VOG;)_9T$f7	Y/d>xM#HRX$߼߉Z/ޱބS"݌Sܢi3ۑ_2گڂR"ْ["زzCמf-ֻւHՒVԪr:ӟm;Ҝf0Ѷr.ШbόG΄C͆I̌H;ʰj%ɡaȟa#Ǩh(ƨg%ŜXĒRÒQH¹q*d#⿥l6žQݽbμ<󻨻\ƺ~:q/񸳸v8s0충dصMѴV޳k2x8y8w:¯JӮ]"歫p4Ŭ^*˫wN$Ϫ~T#Mݨj2ѧtFѦ^8åuN&٤pM%ΣyK颹]1ۡiJ)͠{`F,ݟhI)	͞kJ+˝pXA+ڜќʜÜ}yvv{՜+B[v՝Cp̞/hܟVؠ];Ԣ"q£jkå}D
zf۩PɪKΫOϬPҭT׮X֯OŰ=(hӳ>{Tƶ9 && dC­}XF<ƾIm ɗ3q̱VͣHϐ2uӳOԌ-nص]
ںk܇E߿|=MO;]r"-1)wf
O6| h
  UH@91		{
k

WICJe=bBa !!}"/##$G%%&R'((`)**r+%,,-K.//v02112c3445F667b899x:';;~<)=={>#??m@AASBBC6DDvEFF^GHHNIIJFKKL;MMN,OOuPQQZRRS9TTzUVVXWWX6YYkZ[[2\\[]]x^__``,aa9bbEccKddNeeRffUggShhPiiGjj4kkllldmm6nnogoo(pppGqqrbrr$sssLttuzuu<vvvLwww5xwxxx3ykyyyy/z_zzzz{1{[{{{{{)|S||||||}B}e}}}}}}~~~$~-~3~8~:~<~@~E~J~M~P~U~[~a~g~k~p~t~x~|~~~~~~~~~~~~~~~|~y~w~r~l~d~\~S~I~>~1~#~~~}}}}}}}}}}}w}m}d}X}G}6}&}}}|||||w|X|9||{{{}{Q{%{zzzkz;zzyy~yNy yxxxmx=xxwwxwBwwvv`v'vuuvu;uuttOttsses)srrvr;r rqqMqqppep,poooLoonnan$nmmhm*mllgl$lkk^kkjjQjjiiHiihxh3hggbggffIfeegeed}d)dcc.cbb-baa,a``.`__/_^^/^]y]]\h\\[Q[ZZ8ZYwYYXWXWW<WVV'VUqUUTdTTS[SSRPRQQCQPP+POlO	ONANMuMML7LKcKJJ$JIMIHtHHG-GFPFEsEEDDC<CBUBAkA@~@@??>>= =<%<;);:/:9498887:76A65K54T43]32h21o10v0/|/.|.-|-,r,+_+*K*)6)(!(''&&~%$z$#}#"""!!  #'*.-*+2:J]s 8[~0
S
o
5
	S	u/XKZ P  R  cjpc
Q7}!g
en$OZ!wA
O
8:::_b-h<\0_(^w&}'EzDp^K6!
Z4
}KzD߰߄W*ުޙސދޅxpic\O;#
ݻݖqM)ܶܐjDۮۉfAڣڅkWF5$ٵٜقiO2ع؜؀cG+ױנו׊~trw|ׇׁאם׫׸#)/5;?ACEGNYfr؍؝خؿ&=Vqَ٪)Kmڏڱ6Mavۋ۞۰+Gb~ܞܿ  =Zxݕݱ4Rqޑް0Poߌߦ0Mj-?Qcu9Y}.Ps&)***+1:DMWf|'A\x	-762-*%*4@O`p oZF1
"'(#eI,~mbXMC=9752,#lN0\6x]D*}gO8 ߺߔoGޚoCݘvW8ܿܫܗ܄q_L7۰یb9ڹڋ[-ٮن^8ضؖvV6ײאnK%֩R"Վ[&ԹԄQ"ӘlAҜn@ѳHШs>	ϟi4Α\'ͻ͇T#̏^.˞m<ʫxEɨo5ȄHǒVƩp:ũzJđa1âq=h.r3i%㿢c$澩r?ٽvF輶L໩n/𺲺t3𹫹h&ถKr-趣_ 浮u=մtC糼c4ֲwEڱp<Ѱi5̯b0ԮvL)̭|eL1جj;ޫ{D
تp;ѩpC稺kE֧bD&ͦdAѥ\5{Z:ˣ{j[J:+עˢrbRB2#	&0<JWboŢۢ	 :Wuӣ"JsդAv+j%g(p	UV
mЫ4gѭ9tٯ;]a
`	^eo̶-S#g׺Ejӽ=
hÿx3Oµ%Ù
qnt ȍɫ=eː&͹Iiσјң*ӳ:ԿFi֎#ؽ[٘8rݮQޔ4| f
Q2l8_w-Ch-p^`ihW/  ]7X~X	C

A
7)kHx7\|
(GhN !!!c"##O$$%E&&':(()"**f+,,>--t.//B00n122)33T44566P778?99:2;;<(==l>	??A@@qABB-CCXDDEFF:GGbHHIJJ(KKALLVMMgNNxOOP	QQRRSSSwTTmUUfVVaWW[XX]YY[ZZV[[J\\9]]^^^g__>``aaaXbb5ccd{ddPee&fffTggh|hh/iii5jjj)kvkklWlll+mkmmm,nhnnnoTooo	pEpppq@q}qqq.rerrrs3sdsssstGttttttt!u?uXunuuuuuuuvv9vUvrvvvvvvw4wJw^wqwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwxwqwhw`wXwNwBw6w)ww
wvvvvvvv~vhvNv4vv vuuuu{ubuLu6u u
utttttttttzthtQt7tttsssmsDssrrrbr5rrqqqUq+qqpppgpAppooo~oUo-oonnjn6n nmmImmllNllkkZk"kjjjGjjiiai(ihhxh<hhggUggffmf4feeeQeeddhd(dcclc.cbbqb2baava7a``s`2`__l_*_^^f^$^]]c]!]\\N\\[p[ [ZZ/ZYY3YXX;XWWLWVVZV	VUeU
UTZTTSJSRR/RQrQQPRPOO7ON|NNMkMML`LLKWKJJKJII;IH~HHGVGFF"FEQEDDDCLCBBBAYA@@<@??%?>e>>=@=<l<;;#;:?:9Y98q8777665/54A43S32d21w1100/1/.O.-n-,,,+6+*Q*)k)((('1'&I&%T%$`$#f#"h"!n! }  ;`!Qx*DWjv	#6Ok0
a
 
D)
n

	L	z=_=f5m R =868%l
H$eKEGTcs#5EVl:W=|?L`)U'zZ;tW8mH"rFR![0ߝ{Z;޶ޓrN%ݒ`(ܨh(ۡ\ڑTٟkCز؜؉vbQC7, ׵ך|_B$ֿ֝hUA,#/AScv֋ֺ֣!5DMPTXZXRKE@;61,)+18=ESfz׍ס׹,Ll؎ذ8Pbo|وٕٝ٢٥٩٭ٲٷٽ*Fkڒڸ/Yۃۭ"Ioܑܭ'9J]q݆ݜݲ$Efތ޹K}߳#Z)\0W{#Dd.Pu4_=kBj0Kc{#;Tm%;Qh~%6HYiy#3AO\iv!8Sp,CS`n} 
&,28=@??@?8-"
wgXE/ |l[K;+kQ9 ^9zU0eE&iG&zW3~W0	e;lCoO/eB^3V%ߔd4ާ|Q&ݩ݂Z2ܭ܀R"۸ۂMڦn6ٓ^)،X$׸׀G֛_"թk-԰r5ӻCғXѲ}GШuAϙ_%Ϋi&͢^̓Q˛`%ʷʁKɰ~KȹȉY(ǋW"Ƭn2ŵt3Ĳt7ýÀF¥o;	sAp9ɿZ ⾥h,f"༛U
Ļ}7󺱺m)蹫o3Jڷh.Hյd+򴻴KӳX߲d&걲{DװvH꯾j?îrI ϭW,٬W)ͫpA᪵d:̩iJ-רgK.֧|]@"ƦfH(ǥfQA3%	ߤפҤΤʤŤĤɤΤӤ٤ߤ
'6DUkݥ 'QzϦ1eʧ;v(cکP1p,q[Wrү5 eȱ*_ó&_ǵ-^ķ)LqԺ8nڼG&raM5êďlNƽ*Ǔ`0ɗ[+˜zdcdrЄ
ҕӠ#ԣ!՞֛ה؛$٭7Sqݜ/S߃L_/h.[$`=.l>bs+GzN-  h#@Tdt 		5

Or

>m/lI}Daw(W4 &!!l"
##Q$$%&&6''\((~)**H++,*--q.//f011E22344T556%77]889/::_;;<'==H>>i??@(AANBBC+DDsEFFOGGH$II:JJKKK\LLjMMzNOO+PPKQQ^RRoSStTTcUUPVV=WW(XXYYZZ[[
\\\n]]B^^_m__&```5aaa@bbbKcccLdddFeee2fff3ggg3hhh;iii"jijjj0kjkkklNllll&mbmmmnYnnnoQoooopFpoppppp
q'qGqkqqqqqr0rPrmrrrrrrrrss$s5sGsYsks{sssssssssssssssstt.tBtRt^tetltttytztutptjtftdtbtat_t_tcthtotutzttttttttztqtgt[tOtDt7t*tttt	ttsssssssssus`sHs.ssrrrrrxrYr6rrqqqxqLqqppp}pWp0ppooo~oYo2o	onnn]n+nmmm_m+mlllbl7llkkk\k.kkjjlj7jjiici.ihhhdh6hhgg|gPg#gfff^f+feeeNeeddbd$dcchc(cbbhb'baa_aa``m`4`___Z_&_^^s^-^]]Y]]\W\\[U[ZZNZYYXY	YXkXXWW<WVVMVUUWUUTaTTSfSSRgRRQSQPP5POxOON`NNMJMLL6LK|K KJbJJI>IHtHHG:GFeFEEEDFDCtCCB8BAcA@@ @?8?>S>=i=<~<<;;:1:9E98]87u77665=54]43332421W10x00//.9.-N-,c,+|+
+*%*)H)(q(('''&E&%b%$x$$##"0"!G! ^ u3Lav/G`y0BSn*R
{

:d

#
	H	o%Il#Ip3 d 9|\:sF}Q$\=&x"w%3F]w+E^oAk(c"^YW^ e'j+Le<ߞxR'ޞq@ݤp;ܜg5ۦwL%ڲڐsY="	ٹ٢هjO3؛sK$׬׉mV=$ַֿ֢֮֕ֈ{m^M=-չը՗ՅvkbYPIJQY_fq}ՊՖբլյվ1Jb{ֵ֗+AVlׁזש׼<[{آ.]ٍٿ#Tڂڮ-U{۠%=Vo܃ܑܜܧܳ(Ktݛ;eޏ޳-?M[izߍߢ߷5Qm&Ed%Gk'Jm:] *T(Hh3U|M}-Rw*Fb~ ;Rfx8Sm2F[o'.37:=CKV`ju"5AHOX^^ZUPMKKJIINV^fntz
	wk^RE9,iJ-|V0}_B&
rR0
_<[2yKc9pJ$[1R$nAW$Ns=	ߥsB޶މ[,ݟo>	ܟk6ۘd0ږc/ُZ$ظ؂L״׃R ֽ֌['մy?ԎRӤl5ҏX!ѱu6иy7ϱn,Ϊi(ͪm0̷{@ːUʧm3ɇNȘ[ǡb#ƥg(Ŭp6ĉSùÅP­w>LZῤg*r4{?ȼR⻫s=Һi3ĹU港xB׷p<	׶tB൯~M_0ֳ|P%Ҳ~U,ڱ\1۰^5㯺jAînE˭]<٬{]> ȫtX=#
٪p]M?2%
",8GWgwͪ1Kfګ4Tt٬ &Ltӭ5hۮRϯUڰa*o?ҳ"sôjŵ!{׶7eʸ4~Yƻ4yMQV¿(ÕwY@Ƶ*ǟȈrY>˰"̓vV>϶,ТіҐ
Ӊԃ{uplrwڄܘ"ݬ8Tp@]z":Tr MxKQHt'Fg<` Ht	4\}
.		R

u*

Mn7Qi	4I`y ?^ !!5""K##`$$l%%o&&r''~())**1++T,,{-..?//h00122<33S44j55677%88?99Z::t;<<==4>>N??f@@zABBCCDD%EE*FF*GG*HH&IIJJKKLLMMMrNNcOOIPP'QQRkRR7SSTnTTAUUVVVWWW,XXXOYYZkZZ[v[['\\\0]]]2^^^1___`_```9aaabVbbb.ctccc<dddd8ereee!fZfffg<gpggg
h7hahhhhi-iSiyiiii	j,jOjrjjjjjk<k\k}kkkkkll4lDlRlblrlllllllllmm#m2m@mOm]mhmpmwmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmumamJm4mm	mllllllllllllzlpldlQl:l#llkkkkzkZk9kkjjjjwj[j?j#jjiiii{i]i>i!iihhhuhQh)hgggzgLggfffZf+feeepeBeedddYd(dccc^c%cbb|bCb
baa`a-a```e`3``__j_1_^^^H^^]]G]]\\C\\[[B[[ZZJZZYYiY0YXXXMXXWWaW%WVVZVVUU?UTT_TTSS?SRRvR7RQQvQ5QPPtP,POOLOON^NNMgMMLkLLKqKKJ{J)JII/IHH4HGG,GFzFFE`EEDDDCC"CBcBBADA@@2@?}?"?>n>>=`==<H<;;';:^:99.98_877-76e665<54y443S322*21`100*0/X/...-C-,n,,+1+*`*))%)(P('{''&C&%s%%$;$#k##"-"!Z!   H{JQGv
=g$O|GR%`

<
tE
v

	=	l4k	D*p\ I  3 zbODEJj PIFC>z9u9 V}Gk4Ma&p2{AZ"}HzG{J]4
mDpCe9
g?fBoM*߻ߗqHޢuGݽݒg<ܿܛwQ-
۴ۗy[> ڧڈjO7ٱًٞyiXG6($*06<BGJMPTWXZ[]ait}نِٝ٪ٸ$+6ALWbo}ڋژڦڳ 2E\uۏۨ5I\n܀ܓܦܹ
&C_{ݙݸ2Jbzޓު2Kd}ߘߵ)Gd+Gc-D\s <[|5So'9Mau!/=KXdq}
%-6>FOZeq} /BTfy(3?JT^hs~	
yph_VLC:2*#sg[OD:1) 
wcP=*o[H4 fK0aB#rW<!bE%wT0kL-߸ߚ|]> ޣބdC! ݼݖoGܬ܅_8۩ۅ_8ڝuM&٪U+خ؅[4לsH֜oCվՓi?ԘoGӥ}V/ҺҒi@ѝrIМoCϙoFΪ΃\4
Ϳ͕kA̿̑b3ˬR&ʤxM"ɠtGȾȑf;ǾǖnG ƨW.Ųŉa<İĎlJ)á]:±qR3hH'fG)ٿoU:;}cI/нyeQ>+ݼ̼|obVJ?4)	ݻԻ̻Ļ}yvttuttuvwwwvtrpomllkklnqtxz}ͻڻ4H^uּ/MmսCi߾2\Hy%c!d¨0qð4uĵ6yż DƊjǹ
]Ȳ	bɽu6˖X̿(͑a,ϒ]о~?ҡf.ԙwZE׼3ث"ٚڅiGܲ݄U޻߂Ek3kF%w[9}PR"`>sea``cglrz0F  Zm&()		+

16=

FMMH;&wN!_0oF mN1~Y  .!!!g""9##	$p$$F%% &&&n''V((>))#**
+++b,,J--0..///j00P11922#33
444j55P66777888n99M::(;;;h<<>==>|>>R??(@@@kAAABBCCC\DD.EEEeFF0GGG[HHIyII3JJJ@KKK@LLL<MMM2NNN+O}OO&PzPP"QuQQRkRRSYSSS?TTTU\UUUVTVVVV1WdWWWW7XpXXXYXYYYZSZZZ[J[[[[ \R\\\\\ ]B]a]]]]]]	^"^;^V^q^^^^^^_:_W_v_____`$`<`S`i`z````````````````````````````````````````````````````````````z`t`n`h`a`Z`T`N`I`C`<`4`*` ```_______o_V_=_"__^^^^t^U^7^^]]]]u]R].]	]\\\l\A\\[[[h[:[
[ZZZPZ ZYYYHYYXX_X#XWWrW7WVVVSVVUUyUBUUTTfT/TSSSSSSRR}RFRRQQgQ/QPPPHPPOOyOGOONNN_N0N NMMkM6M MLLVLLKKgK+KJJJJJJIIwIDIIHHxHDHHGGkG1GFFF@F FEE@E EDD?D DCCKCCBBdB-BAAACAA@@?@??e??>p>>=s==<i<<;f;;:j::997988X88779766L655L544-43l3
32F2113100+0//R/
/.}.7.--d--,,2,++D+**S**)e))(x(((''9'&&Q&&%l%#%$$F$##j#!#""9"!!I!  O Xr%Ikz).3@`Tf)o0n-cJc8` 

j
/
]%i*

G
		R	PTh>dBdE  v 2 g#Kw6v<j8tBr@V0
|W3`4T)\1PT$lDpDw=NYo6Qd*NT$a/Rn4uJa;{Y8oT:x\@'߷ߪߛߍ߁xqjbZRIA90(
޼ޱޣޔރsbRB1!ݿݲݥݘ݌}hP8 ܺܠ܇q^K8$۲ۛۄlV?*ڱڟڍ~pbTG9+ٸٰ٩٠ٕوzl_P@/ؽضخؤؙ؍؃xof]SLGB>9667889;=?BA=5.( 	׹׵ײװ׭תרץףסםחא׈ׁyodYNC7*ֵ֑֩֝օzqg^TH:,խ՚ՉwfUF:."
ԼԱԧԛԏԂth\RH>5-'#  ! ӻӶӯӨӡӛӔӌӄ}vojd^XRMGA<60*$ ҵҩҝғ҉Ҁwnhc_[VRLGC=5+
ѸѧіхtdSB1одЪСЗЎЄzqg]SH=3(ϿϻϹϷϵϴϴϵ϶ϷϸϷ϶ϵϵϴϴϴϳϳϴϵ϶ϸϺϼϿ     '-28>CINSX^gpyЂЌЙЧе"0>LZhtыіѣѱ.DZrҌҥҾ4K_rӄӗөӻ';OczԓԬ/JfՃՠվ+C[rև֚֭$8Oiׄמ׹0Nm؋ب9Tpٌ٨8Vsڐگ
-Lkۉۧ<Zxܖܵ0Om݌ݬ6YަAgߍ߲?a;[z %Jn
1Vz/Sw'Ij,Mn %Lu$P|,W*V<m)W>l-]&X RBs
<n?q6h7m#`&l9}H@}+dJ2m"c$h7 |  C;sCp(UGzV9pI~	O				
M
~


?n*[!
Y



6oP0g
@uFw3_-V~,ZK|Du ,X"Io)Pw:b	4_;e $Hk3Su % H k     !2!R!s!!!!!";"\"~"""""#7#S#n######$%$?$Y$s$$$$$$
%#%<%S%k%%%%%%%&*&C&\&u&&&&&&
'''@'W'm'''''''((.(A(U(h({(((((((())")2)A)P)^)m)~)))))))))**&*1*=*H*S*[*b*j*q*z************************** +++++	+
++++
+	++++ +***************************{*r*i*`*W*M*C*7******))))))))))})t)l)c)Z)O)D)9).)")))(((((((((((z(q(f(\(Q(G(=(1(%((( (''''''''''}'n'^'N'>'.''
'&&&&&&&&|&n&_&Q&B&3&$&&&%%%%%%%~%l%Y%E%/%%%$$$$$y$a$I$/$$######o#Y#D#.###""""""p"["F"0""!!!!!!l!T!<!'!!       s ` N < )   nXA+nU=%iQ:#rX>#	t[@%y[<bD%xY;rV;oP1rT6jM/z\=~^>vU5zZ;dD$jL.



w
W
7

wW7~`B#



l
N
1

					u	Y	=	!		iJ+
oN.
           
      RSRC         [remap]

importer="wav"
type="AudioStreamWAV"
uid="uid://i5pch0xhnng0"
path="res://.godot/imported/n.wav-ae30fcbcf5bbb9f6b85bd389a7302961.sample"
              RSRC                    AudioStreamWAV                                                              resource_local_to_scene    resource_name    data    format 
   loop_mode    loop_begin 	   loop_end 	   mix_rate    stereo    tags    script           local://AudioStreamWAV_qd0ba 8         AudioStreamWAV          fn                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  	 	 
   
                        ! " " # $ % & ' ( ) * * + + , , - - - . . / / 0 0 1 2 2 3 4 4 4 5 5 5 5 5 5 5 5 5 4 4 4 3 3 2 2 2 1 1 0 0 / . - , + + * ) ' & % $ " !            
  
 	       |zxusqnmkigfdb`_][YWUSRQPONNNNMMMLLKKJIHGFEDDCBBCCCDDCCCCA?=:840+'#
~{wsqrsuvwy{~~{xuromkhfeeghkmptw{	$3AO\iv  " 5 H Z l ~                ,<L[hv|xvtrpkd[SJ@1!                   } n \ I 5 #   vj[I6%	{tkbZRIA94247:@HTany
%-59:;AJPQSX^emtx{|skaXQMLLLJFCA=5)ulbYOHFKPOMP]mx|vsv#7DP]juvvw}  1 L j      9^+jSpM%\bH			
h

Xg0

{M]2e*E\q.W"NpuZ;vX?'
rIE0?U	
~
C

e,y4

3
	v		;kap)X
o#47  G C:05j*}HLq#w#4=i"pJ"vdJ,pN.
ufXG/y;t'3UNT	cSz
(IkC:=Yg߷Xݍݫ6Iaن"r ׆@ֻx4՜GԚ=nӛ1`Џ+sϿk!͕T̫yP(ːf<
ʮʆa@"
ɼɨɟɡɢɝɛɡɬɹ!!ɾɜyNȵBǎTƫp7ŒMċ>âRC#`:徏9潟a$鼳~DͻNA/WMbBдpD^Ȳo
IH
ۯƯįƯï{iQ-ʮ{\= 
4cH*Y~Ͱ)8Lgpɲx߳XԴMµ1xڷ0}˸d0qsܻC"?о\y
)µ:þA;Ű&ƝǊȈ
ɐ*r̹r2Ϊf,қk>ַאw_??cwO
U= Sl	
0%u*n o"#$%^'('*+,D./0183i45679<:j;<=>8@AB7DEFFHIJQLMNPTQRST
V(WGXiYZ[\]^
`a-b@cHd6e"fghhiajkkWll<mmmYnn	odoopoppqmqqrMrrr7sss5ttt)u[uuuuuuuuuuuuuuuuuuuuuuuuJuttCtsksr"rqp3puonm2mzlkkUjih@hgf?fed5dcb$bxa``M_^]?]~\[[gZYYyXWLWV=VU6UTATS7SR8RQQPOVON NQMLKCKJIDIHHqGFHFEEsDC8CBA$Ap@?>4>h=<;;;:l9877I654&4z32?211X0/.7.|-,+*)(('&%$ #! @m*Sv
D
l	FsT &8Ii86s(bVW:.#v5UDBMvܣ@wڮMx
؞3Xzա7`ҟEы<ЅJϯxDη΁P)͸͓~tjRBJo͟q*ς:РqhҴ@nӐӴ6McxԒԮ'@TcqՃՕՠՠ՞՝՝՚ՏՁth]RE4$.BSarՊե7QgooputbF(գwN#ԊTӧi,үr7хNвw4ϫh"·6͝Z̐P˟c&ʜVm
ɮPǁ
Ǚ%Ʈ2Ŷ<F`5O߾idc~	#ȹ{0⸗X!T.Ķ{T-㵻b9δhP;$ݳѳĳ{ywussrsux|ǳܳ
%B^sǴҴߴ&3:>DJOSW\bjyϵ7\ԶFxMݸ1ҹ!uκ&ۻ8WwԾ3ݿ'rP-s¿dóDČ!lų7(}$ȋrUYy͍ΐϗІ^Bҷ+ӛԐծ:ct%ڜe/ݼ|:u5y:U Q7t1j  Idx	

 9`Iy	0Pl !"#$%&()4*W+z,-./01234y5a6H7289::;<=>?@uASB*CDDE_FGGH$IICJJdKK]LL>MMNNNJOOPoPP&QQQR]RRRSASjSSSS
T/TWT}TTTTTTTTTTTTUTTSSwS=SSRRNRRQ}Q7QPPOPOOQONN/NMiMLfLKLKJ!JxIH"HxGFFsED DCBMBAA@@?3?>H>=^=<t<;t;:l:9`98H87576"6554433221100/	/.'.-G-,{,,+h++*9*)l) )(!('F'&`&%q%$$$#/#"R"!!P!  g % `I apnj^N29Lb'L>k"R
<v1

u
<

a4xF

v
9
			E		B t/T {vpjhhihhks|Do3p!c(	f			!
]



EZC


Sj$J[;v;G+w	P2 s-Cw?  a  !k!!"M"""(#m###G$$$,%x%%&\&&&<'''(a(((1)v)))%*Z****++;+W+n++++++++,,',5,C,Q,_,m,|,,,,,,,,,,,,,,,,,,,,,,~,h,N,0,,++++r+S+4++****|*\*<**))))`)8)
)((j(4('''L''&&i&2&%%%l%@%%$$$y$U$0$$###}#T#(#"""u">""!!e!,!   S % tP-	|Y6wO$|O"n?d:i?oFyM f1^%Mb8lD}V-zKj1}A

k
7

{N!d4

f
2
			P		l3_,zO&lV@)|gR;#
||{y{%7HYm8Qj-C[w!?\x"8M`q			#	0	=	K	Z	i	y										



 
!
"
#
$
'
+
0
3
9
B
N
Z
e
m
q
s
v
z
y
s
i
_
W
M
A
4
%


								i	P	3		yX8wW7uT4zcL3qS4kWB.xbL7"
(9L_s8Rm2Qp;_!In:Wv,Qz$	U				 
W


=z2p%
a


;p1a@lCm<b,Jdw
&0;EOX`irxwtqogU>&qQ4}pdXL?1"{iVC0 ~uld\SH;."mT; y^C(





x
d
P
<
*


p[E0yZ< 



r
[
F
0


								{	g	N	2		pK&d@}`C#V"s7i#Mr)  O  s)Kq(Igv%{$vtu'A}>_-wM#ka\UMOb|*\KgG,Ndq}6`Q-dDp?` iGT_ l  x*'zhG(sQ*m	U				
;
g



I2h
9
F
I
K
Q
S
O
G
?
8
2
0
/
/
/
,
&




oW:rK& 



q
Z
E
5
(



	



(
B
_
|








j
M
2



							

4
R
o






"*..,+*&








	


	






s
V
4

			q	C		i@	g<
tFqP0}Z0MA? > (y_G3.(6Oh8."m@'@px/M j[9sI2yiߵ\ޫSܬ_y:ړ_2ٜp?
ثp-צd#֣b"կxA	ԡm9ӻӛzY=&җg8	ђP
АY"ϲχmV>%!%-6?HKHB=8.ΨΉjK*͹͔nJ&̺̚z\=˚p?˿{:ɥQȨUȺmƘa,žō^1Ĩ}Q$çÍs[D. ·d;~Q->h'@QVX[_`^[WUV^gow¡¾:`Æì:O[bjsxvpjea^[XUU]iuĀčĞı'19BKS[ahou{ŀŅŉŏŖşũŲźŶūšŖŊthZJ:+ĴđkAñGFF9ܿ~!ľhV*L޺lx1=CǳMֲ_q<ۯzĮnímhV򪎪*ǩa-˧rʦu&㥩p5Ƥb/ȣ\&ânBۡnWA)ޠ̠Ġ֠
,>Pdx PAˣ
D{&bڥ]gLoɪ%֫#lJ߭*te	^kűhDгQմkP;ַ g>ֹ#oP.nUý0]_,p>BKÑąŢ'ƺƂǐȯɿ"ʹXэBܞf+i:!yV@'	 &4	4
m: !"$>%x&'k)*x, ./612u467K9:<>?VABD)FGFIJ[LMnOPR
TU
W|XYe[\^F_m`abcdefguhVi5jkklm}nWo*ppq5rrstttquuFvvv'wqwwwxJx~xxxDyyyzTzzz{J{d{x{{{{f{{zz(zyxxKw~vutsrqponmlkkPjihhwgf;fed!dfcba``_^]\ZYXWVUTS(SRQvQPfPOO[OONMNM|MMLLsKJ"JyIHH>G{FEEXDCBTBA2A@)@?1?>c>==;=<<F<;;s;;;;::[:+:9996988987:766x54$4i321M10$0/.z. .--1-,,~,N,,++S++*r*
*)*)(M('i'&&#&%%~%F%)%8%]%%%%&A&&&&''''&&t& &%x%$\$#*#"!+!t pK):XdWI36hU
1

		g
Z?z"@g! J y)J{U\#  @~3ALK'f1 |  	[5(vgo	

,>%


@`*Gu/zb][ULB5( !!"#T$!%%&U'
(()F*	++,X-0.
//01q2H3 445x6'778(99K::g;;n<<|=>>>t??p@@LAABvBB(CuCCDYDDD-EqEEFJFFFGTGGGGHHH H'HHGGGGgG;G
GFFyFSF-FFEEEEuE^ELECE?E<E8E2E%EEDDDDdD&DCCpC.CBBpB=BBAAAAqA_AJA9A*AAA@@@@f@5@@?r?#?>>0>==6=<<L<<;w;5;::r:1:999Q99888V8'8777U7 766c6655T5544Y4#4333m3=3
3222J2211P1100S00//v/@//..~.S.".---S--,,J,,+t+'+**<*))t)0)((z(@((''D'&&p&&%N%$$$##""!!~ rw 9j(AR6~7Mn8

	
		xquz4Ux
 - D["W j!WJV\QU`[ oM2 *B`$`t,bD'Zz0->jA  $~~y{vF	m		
Z

e}8


B'rG%l?E:tCh(Ca@rAl

u[A(w\A&qZ?|Lp<	qAZ0iF"zNd#a

c
/
fAr`PB6(





_
<

			l	<	
	[/eJ0b8q5n+s6wP*
iH(  r =  ?r.e#WAk$Kp)BVQE%gJ8@T	ndNT!VU&d	QQfߙWގI޿x,ܔI ܺt-ڬxFٵّpM+ػؠ؁^9מqC֚qH#դՇmT<#
ԻԬԞԏԀpaSF7)ӯӝӊu`I4 
һҷҰҫҨҧҦҦңҝғҊ҂vdJ0ѽћyY>'пдЩЛЌ}n_K3ϯϏoO+Ϋ΁W+ͧ~W0	̝̾~_? ˢˀY/ʴʆV'əh7ȯȆ]3ǸǛǁjU@+ưƟƐƂsdUF7)ŸŨŘŉykb]XQLHFEBAADGILMNOPPKB7.$
ĸįĩĥĢĞĚęĚěĝĞğĠġģĤģĠĝĚėđĉāxpg]SI?5,# ýòåØÊ}o`P?.	µ|\;yaH/}[8˿`=վjG$ýeG*
μeB!zjZJ@:61,'!	ߺݺںٺݺ 
3Jaxٻ)Gd(Iiɽ2UyԾ
?t2w=|6n¢
@wïXĜ.viƿjǽ`ȲPɜ2k˺
\̯WͫSΧNϟ>Ѝ-$vn`Ԧ1vո1m֪2y׿P؝:ه
Jڇ<vۭ1܎Qݱ ޥ2߽Fk5k	D\SYb'~G
{0F:}Iw	  ,_Fs<	
rU8
yHV+{fN3 ! ""#z$;%%&t'((l)**_+,,L--.!//V00`11R22>334s44D55 666m77_88Q998::;;;G<<<>===>D>>>>> ?D?[?b?^?[?Z?O?6??>>>>i>F>#>>======|=\=?==<<B<;;_;;:g::99}9J998888j8F8#87777l7G7"7666e626555;544r4.433b3#322u2=2
2111`1711000q0G00///z/V/2//.......w.m.a.L.)..---O--,,[,2,,+++++++z+f+M+6+ ++***g*D*)**))))))))))**.*N*t****
+4+\++++++
,,),,,/,5,4,$,,+++}+L++***h*F*#**))))m)?))((E(''J'&&I&%%f%%$$g$/$###f#9#
#""y"I""!!n!3!  } > DT_ SPh;lJ&k[QH=4,'"
 
'4BP^kv.W:pJ0r;~
P`. {  !e!!"m""$#}##,$$$-%z%%&Y&&&,'q'''E((($)n)))H***+I++++,B,i,,,,,-<-]-----.*.E.a...........}.u.p.n.m.k.j.h.f.d.c.`.[.U.N.G.@.<.9.7.5.2.0...,.*.'.!....---------n-\-K-:-)---,,,,,,,r,Y,A,#,++++`+5++***Z*0**)))\)2))(((X(,( ('''W',''&&|&N&&%%%P%%$$$`$8$$####^#;##"""t"J""!!!u!M!)!
!    r X < !  yX6nN0{dL0nG!\3	}N[*d2d0Vd(^Hr,a[YT

B
t/b

S

		c	)	JwCrM/}c>
s< H`E+{aG,    g A     E t    )X":Pm!Q/e3a$5GYk|9Xw)Sz 		0	5	7	<	@	?	8	0	'	 			 	#	$	 					 	{skhjnrtsnga[QC4&{dM6	tkd^WOE:1)tHsD!cF+xS2}l[M@4(	      { i X K B ; 4 +     {smhc^YX\bgls}uL^+uW9z^C'd?_Y=n?gJ/e+U^}2{Lc7	i3D;_r!5NCG
Hv-?Rf<g%ߠ`"ޫn4ݘd1ܜk9ۡn;
ڧuFٚqI"ح؉fC׫אv]G0֑֭rN#ՠtHԜzZ8Ӱӗ}bG,һҝҀeK2ѳѡёуuhZL>/ пмиееезиздЮЩХОЖЋЁwmcZPF>5.&
ϷϯϧϞϔψ|qeXJ;-
ίΛ·s_L;*͹͍ͥqT7̞̾dN9$˾˲˥˗ˊ|kYH6&ʺʯʢʒʁqaN9"ɸɥɑm]M=,ȰȠȐȁrcTF7'ǼǮǡǗǏǇ~vme\SKEA<841/--*#

".;GQY`hptrnjgd`\XTPMKIFB;2*"ƹƲƫƤƝƗƑƌƇƂ}zxwuqld\TME=4+&)3=FOZfsƁƊƉƁwnf]SI>536:=@A@@@>91'&/7<>?ACB?;623:CJSbyƓƬ/IbxǍǢǷ2H]qȊȧ#Glɑɶ0[ʄʱO˃˺6u̴/lͧ"kθPϢrHѷ0ұ3Ӳ2Ե:վASwٙ5ڀ#m޾e
`
]
jOyty}qi bYPMQW\`h	v

sJPR !!"^#%$$%&g'9())*+u,O-*.//01P2334e566|7/889@::;O<<=_>	??/@@LAAOBB'CCDgDD'EEE;FFFGXGGGGH/HOHhHHHHHHHHIII I&I-I3I8I=ICIGIHIBI<I8I2I#I	IHHHH`H*HGGG3GFF4FEE#EDhDDC|C3CBBeB*BAAtA2A@@h@!@??6?>>G>==P=<<d<<;~;=;;::N::999R99888T8 8777R7766A655M544C433>322E211m1'100v0;00//l/;/
/...Q.$.----a-8--,,,O,,++R++**=*)))L))(((b(=(('''v'M' '&&&^&*&%%|%B%
%$$`$($####x#^#N#C#9#.# #
#"""""q"L")"!!!H!! q  X,Z9$lY6q-Tl8gQYE
~
<
w4i(

i
*
		j	*	j)i.JsU;0H`}M6pU	J	{			
R


 n	b!


GdC nL*rL$kE!pN+qA  !r!!-"""@###8$$$(%s%%&O&&&'T'''(B(}(((/)k)))*W***+/+Y+++++,,2,H,\,o,,,,,,,--3-M-g-------....A.T.f.s.{........w.i.X.F.4.#...---------|-p-d-U-@-'-
-,,,,c,;,,+++Z+++***t*G**)))p)D))(((j(>(('''j'B''&&&v&M&#&%%%l%>%%$$$\$2$$###s#L#$#""""^"7""!!!~!Z!6!!   q E  ['X$Y+zQ'_8pGh3Ui1l=V!u:t1Qev'Gu1

q
1
p1y< 

B
		z	5	[KM_!i%Qy/V  H  u0HSw2|P$kK.
dC%>` +U|%Ca*U?f"0>KWcq"O} 5 `     
'>O]jx5Z}!5DO[jw,:??AC?/vlcYNB:3,'(.6=CB<73)g0I  y J %  ~reUD4&zS)dM9"vbN<-n]J7# |aE)
_=zocVJ<)yR,hE(}q\? qK% rM' x\?$
vL$E?u4r3`-yLt= w3cGn&Mq*XME@߾}